!
! Here, all modules used in REcoM2 are located
!
! 	- module REcoM_params
! 	- module REcoM_constants
! 	- module REcoM_declarations
! 	- module REcoM_GloVar
! 	- module REcoM_locVar
!
!===============================================================================
!
! Module for defining variables used in REcoM
!===============================================================================

Module REcoM_params

  Logical                :: use_REcoM            = .true.
  Logical                :: REcoM_restart        = .false.
  Integer     ,parameter :: bgc_num              = 21
  Real(kind=8),parameter :: VDet                 = 20.d0                ! Sinking velocity, constant through the water column and positive downwards
  Real(kind=8),parameter :: VPhy                 = 0.d0  
  Real(kind=8),parameter :: VDia                 = 0.d0 
  Logical                :: allow_var_sinking    = .true.   
  Integer                :: biostep              = 1                    ! Number of times biology should be stepped forward for each time step		 
  Logical                :: useReminSiT          = .true.
  Logical                :: Felimit              = .true.               ! Sets if iron should be limiting
  Logical                :: REcoM_Geider_limiter = .false.              ! Decides what routine should be used to calculate limiters in sms
  Logical                :: REcoM_2Classes       = .true.               ! Decides if diatoms are used for food
  Logical                :: REcoM_Grazing_Variable_Preference = .false. ! Decides if grazing should have preference for phyN or DiaN 
  Logical                :: TEPaggregation       = .false.              ! Doesn't work. Decides if aggregation should be modified by EOC
  Logical                :: BenthicLayer         = .true.
  Logical                :: Diagnostics          = .true.
  Logical                :: Test_conservation    = .false.
  Logical                :: constant_CO2         = .true.
  Logical                :: UseFeDust            = .true.               ! Turns dust input of iron off when set to.false.
  Logical                :: UseDustClim          = .false.
  Logical                :: FeShort              = .true.

end module REcoM_params

!===============================================================================
Module REcoM_constants
  implicit none
  save

! General constants
  Integer :: idin = 1, idic = 2, ialk = 3, iphyn = 4, iphyc = 5, &
             ipchl = 6, idetn = 7, idetc = 8, ihetn = 9,         &
             ihetc = 10, idon = 11, idoc = 12, idian = 13,       &
             idiac = 14, idchl = 15, idiasi = 16, idetsi = 17,   &
             isi = 18, ife = 19, iphycal = 20, idetcal = 21 
  Integer :: ivphy = 1, ivdia = 2, ivdet = 3
  Real(kind=8)                 :: zero           = 0.d0
  Integer                      :: one            = 1
  Real(kind=8)                 :: tiny           = 2.23D-16
  Real(kind=8)                 :: SecondsPerDay  = 86400.d0     ! [s/day]
!-------------------------------------------------------------------------------
! Sinking	
  Real(kind=8)                 :: Vdet_a         = 0.0288       ! [1/day]
!-------------------------------------------------------------------------------
! Initialization
  Real(kind=8)                 :: cPhyN          = 0.2d0
  Real(kind=8)                 :: cHetN          = 0.2d0
!-------------------------------------------------------------------------------
! Arrhenius function
  Real(kind=8)                 :: recom_Tref     = 288.15d0       ! [K]
  Real(kind=8)                 :: C2K            = 273.15d0       !     Conversion from degrees C to K
  Real(kind=8)                 :: Ae             = 4500.d0      ! [K] Slope of the linear part of the Arrhenius function
  Real(kind=8)                 :: reminSi        = 0.02d0
!-------------------------------------------------------------------------------
! For limiter function
  Real(kind=8)                 :: NMinSlope      = 50.d0 
  Real(kind=8)                 :: SiMinSlope     = 1000.d0
  Real(kind=8)                 :: NCmin          = 0.04d0
  Real(kind=8)                 :: NCmin_d        = 0.04d0
  Real(kind=8)                 :: SiCmin         = 0.04d0
  Real(kind=8)                 :: k_Fe           = 0.04d0
  Real(kind=8)                 :: k_Fe_d         = 0.12d0
  Real(kind=8)                 :: k_si           = 4.d0
  Real(kind=8)                 :: P_cm           = 3.0d0          ! [1/day]            Rate of C-specific photosynthesis 
  Real(kind=8)                 :: P_cm_d         = 3.0d0
!-------------------------------------------------------------------------------
! For light calculations
  Real(kind=8)                 :: k_w            = 0.04d0         ! [1/m]              Light attenuation coefficient
  Real(kind=8)                 :: a_chl          = 0.03d0         ! [1/m * 1/(mg Chl)] Chlorophyll specific attenuation coefficients
!-------------------------------------------------------------------------------
! Photosynthesis
  Real(kind=8)                 :: alfa           = 0.19d0		! [(mmol C*m2)/(mg Chl*W*day)] 
  Real(kind=8)                 :: alfa_d         = 0.26d0
!-------------------------------------------------------------------------------
! Assimilation
  Real(kind=8)                 :: V_cm_fact     = 0.7d0          ! scaling factor for temperature dependent maximum of C-specific N-uptake
  Real(kind=8)                 :: V_cm_fact_d   = 0.7d0  
  Real(kind=8)                 :: NMaxSlope     = 1000.d0       ! Max slope for siiting function
  Real(kind=8)                 :: SiMaxSlope    = 1000.d0
  Real(kind=8)                 :: NCmax         = 0.2d0         ! [mmol N/mmol C] Maximum cell quota of nitrogen (N:C)
  Real(kind=8)                 :: NCmax_d       = 0.2d0
  Real(kind=8)                 :: SiCmax        = 0.8d0
  Real(kind=8)                 :: NCuptakeRatio = 0.2d0         ! [mmol N/mmol C] Maximum uptake ratio of N:C
  Real(kind=8)                 :: NCUptakeRatio_d = 0.2d0
  Real(kind=8)                 :: SiCUptakeRatio= 0.2d0
  Real(kind=8)                 :: k_din         = 0.55d0          ! [mmol N/m3] Half-saturation constant for nitrate uptake
  Real(kind=8)                 :: k_din_d       = 1.0d0
  Real(kind=8)                 :: Chl2N_max     = 4.2d0           ! [mg CHL/mmol N] Maximum CHL a : N ratio = 0.3 gCHL gN^-1
  Real(kind=8)                 :: Chl2N_max_d   = 5.6d0
  Real(kind=8)                 :: res_phy       = 0.01d0          ! [1/day] Maintenance respiration rate constant
  Real(kind=8)                 :: res_phy_d     = 0.01d0
  Real(kind=8)                 :: biosynth      = 2.33d0          ! [mmol C/mmol N] Cost of biosynthesis
  Real(kind=8)                 :: biosynthSi    = 0.d0
!-------------------------------------------------------------------------------
! Iron chemistry
  Real(kind=8)                 :: totalligand   = 1.d0          ! [mumol/m3] order 1. Total free ligand
  Real(kind=8)                 :: ligandStabConst = 100.d0      ! [m3/mumol] order 100. Ligand-free iron stability constant
!-------------------------------------------------------------------------------
! Zooplankton
  Real(kind=8)                 :: graz_max      = 2.4d0          ! [1/day] Maximum grazing loss parameter 
  Real(kind=8)                 :: epsilon       = 0.35d0          ! [(mmol N)2 /m6] Half saturation constant for grazing loss 
  Real(kind=8),parameter       :: res_het       = 0.01d0          ! [1/day] Respiration by heterotrophs and mortality (loss to detritus)
  Real(kind=8)                 :: recip_res_het = 1./res_het    
  Real(kind=8)                 :: Redfield      = 6.625         ! [mmol C/mmol N] Redfield ratio of C:N = 106:16
  Real(kind=8)                 :: loss_het      = 0.05d0          ! [1/day] Temperature dependent N degradation of extracellular organic N (EON)
  Real(kind=8)                 :: pzDia         = 0.5d0
  Real(kind=8)                 :: sDiaNsq       = 0.d0
!-------------------------------------------------------------------------------
! Aggregation
  Real(kind=8)                 :: agg_PD        = 0.22d0          ! [m3/(mmol N * day)] Maximum aggregation loss parameter for DetN
  Real(kind=8)                 :: agg_PP        = 0.02d0          ! [m3/(mmol N * day)] Maximum aggregation loss parameter for PhyN and DiaN (plankton)
  Real(kind=8)                 :: f_TEP         = 0.d0          ! [] TEP fraction (f_TEP-x) found in POM, dimensionless
!-------------------------------------------------------------------------------
! DIN
  Real(kind=8)                 :: rho_N         = 0.11d0           ! [1/day] Temperature dependent N degradation of extracellular organic N (EON) (Remineralization of DON)
!-------------------------------------------------------------------------------
! DIC
  Real(kind=8)                 :: rho_C1        = 0.1d0           ! [1/day] Temperature dependent C degradation of extracellular organic C (EOC)
!-------------------------------------------------------------------------------
! Phytoplankton N
  Real(kind=8)                 :: lossN         = 0.05d0          ! [1/day] Phytoplankton loss of organic N compounds
  Real(kind=8)                 :: lossN_d       = 0.05d0
!-------------------------------------------------------------------------------
! Phytoplankton C
  Real(kind=8)                 :: lossC         = 0.10d0          ! [1/day] Phytoplankton loss of carbon 
  Real(kind=8)                 :: lossC_d       = 0.10d0
!-------------------------------------------------------------------------------
! Phytoplankton ChlA
  Real(8)                      :: deg_Chl       = 0.3d0        ! [1/day]
  Real(kind=8)                 :: deg_Chl_d     = 0.3d0
!-------------------------------------------------------------------------------
! Detritus N
  Real(kind=8)                 :: grazEff       = 0.3d0         ! [] Grazing efficiency (fraction of grazing flux into zooplankton pool) 
  Real(kind=8)                 :: reminN        = 0.165d0        ! [1/day] Temperature dependent remineralisation rate of detritus	
!-------------------------------------------------------------------------------
! Detritus C
  Real(kind=8)                 :: reminC        = 0.15d0        ! [1/day] Temperature dependent remineralisation rate of detritus
  Real(kind=8)                 :: rho_c2        = 0.1d0        ! [1/day] Temperature dependent C degradation of TEP-C
!-------------------------------------------------------------------------------
! Heterotrophs
	Real(kind=8)                 :: lossN_z       = 0.1d0
	Real(kind=8)                 :: lossC_z       = 0.1d0
!-------------------------------------------------------------------------------
! Iron
  Real(kind=8)                 :: Fe2C          = 0.005d0
  Real(kind=8)                 :: kScavFe       = 0.0312d0           ! [m3/mmolC/day]
  Real(kind=8)                 :: Fe2C_benthos  = 0.68d0/64.d0       ! [umol Fe/mmol C]
!-------------------------------------------------------------------------------
! Calcification
  Real(kind=8)                 :: calc_prod_ratio = 0.1
  Real(kind=8)                 :: calc_diss_guts  = 0.0d0
  Real(kind=8)                 :: calc_diss_rate  = 20.d0/3500.d0
!-------------------------------------------------------------------------------
! Benthos
  Real(kind=8)                 :: decayRateBenN   = 0.005d0
  Real(kind=8)                 :: decayRateBenC   = 0.005d0
  Real(kind=8)                 :: decayRateBenSi  = 0.005d0
!-------------------------------------------------------------------------------
! CO2-flux
  Real(kind=8)                 :: permil          = 1.e-3/1024.5d0 ! Converting DIC from [mmol/m3] to [mol/kg]
  Real(kind=8)                 :: permeg          = 1.e-6          ! [atm/uatm] Changes units from uatm to atm
  Real(kind=8)                 :: X1 = exp(-5.d0*log(10.d0))       ! Lowest ph-value = 7.7 (phlo)
  Real(kind=8)                 :: X2 = exp(-9.d0*log(10.d0))       ! Highest ph-value = 9.5 (phhi)
  Real(kind=8)                 :: Xacc            = 1.e-12         ! Accuracy for ph-iteration (phacc)
!  Real(kind=8)                :: pCO2a           = 380.d0        ! [uatm] Atmospheric partial pressure of CO2
  Real(kind=8)                 :: CO2_for_spinup  = 380.d0         !  

end module REcoM_constants

!===============================================================================

Module REcoM_declarations
  implicit none
  save

!-------------------------------------------------------------------------------
! Temperature dependence of rates
  Real(kind=8)  :: rTref                  ! [1/K] Reciproque value of reference temp for Arrhenius function
  Real(kind=8)  :: rTloc                  ! [1/K] Reciproque of local ocean temp
  Real(kind=8)  :: arrFunc                ! []    Temp dependence of rates 
  Real(kind=8)  :: reminSiT
!-------------------------------------------------------------------------------
! Quotas
  Real(kind=8)  :: quota, quota_dia           ! [mmol N/mmol C]  Quota between phytoplankton N and C
  Real(kind=8)  :: recipQuota, recipQuota_dia ! [mmol C/mmol N]  Reciproque of 'quota'
  Real(kind=8)  :: Chl2C, Chl2C_dia           ! [mg ChlA/mmol C] Quota between phytoplankton ChlA and C
  Real(kind=8)  :: Chl2N, Chl2N_dia           ! [mg ChlA/mmol N] Quota between phytoplankton ChlA and N
  Real(kind=8)  :: qSiC
  Real(kind=8)  :: qSiN
  Real(kind=8)  :: recipQZoo                  ! [mmol C/mmol N]  Quota between heterotrophic C and N 
!-------------------------------------------------------------------------------
! For limiter function
  Real(kind=8)          :: qlimitFac, qlimitFacTmp !            Factor that regulates photosynthesis
  Real(kind=8),external :: recom_limiter           !            Function calculating qlimitFac
  Real(kind=8)          :: FeLimitFac              ! [Mumol/m3] Half sat constant for iron  
  Real(kind=8)          :: pMax, pMax_dia          ! [1/day]    Maximum rate of C-specific photosynthesis 
!-------------------------------------------------------------------------------
! Light
  Real(kind=8)  :: kappa                  ! [1/m]  Light attenuation coefficient modified by chla
  Real(kind=8)  :: kappastar              ! []
  Real(kind=8)  :: kdzUpper,kdzLower      ! []     light attenuation * deltaZ at lower and upper control volume border
  Real(kind=8)  :: Upperlight, Lowerlight ! [?]    light at upper and lower border of control volume
  Real(kind=8)  :: PARave                 ! [?]    Average light in the control volumes
!-------------------------------------------------------------------------------
! Photosynthesis
  Real(kind=8)  :: Cphot, Cphot_dia       ! [1/day] C-specific rate of photosynthesis
!-------------------------------------------------------------------------------
! Assimilation
  Real(kind=8)  :: V_cm                   ! scaling factor for temperature dependent maximum of C-specific N-uptake
  Real(kind=8)  :: limitFacN,limitFacN_dia! Factor that regulates N-assimilation. Calc from function recom_limiter
  Real(kind=8)  :: limitFacSi
  Real(kind=8)  :: N_assim, N_assim_dia   ! [mmol N/(mmol C * day)] C specific N utilization rate
  Real(kind=8)  :: Si_assim
!-------------------------------------------------------------------------------
! Chlorophyll
  Real(kind=8)  :: ChlSynth, ChlSynth_dia           ! [mg CHL/ mmol N] CHL a synthesis regulation term 
  Real(kind=8)  :: phyRespRate, phyRespRate_dia     ! [1/day] Phytoplankton respiration rate
!-------------------------------------------------------------------------------
! Iron chemistry
  Real(kind=8),external :: iron_chemistry 
!-------------------------------------------------------------------------------
! Zooplankton
  Real(kind=8)  :: DiaNsq  
  Real(kind=8)  :: varpzdia, fDiaN                  ! Part of Diatoms available for food
  Real(kind=8)  :: food, foodsq                     ! [(mmol N)2/m6]
  Real(kind=8)  :: grazingFlux_phy, grazingFlux_Dia ! [mmol N / (m3 * day)]
  Real(kind=8)  :: grazingFlux
  Real(kind=8)  :: HetRespFlux                      ! Zooplankton respiration
  Real(kind=8)  :: HetLossFlux                      ! [(mmol N)2/(m6 * day)] Zooplankton mortality (quadratic loss)
!-------------------------------------------------------------------------------
! Aggregation
  Real(kind=8)  :: AggregationRate                  ! [1/day] AggregationRate (of nitrogen)
!-------------------------------------------------------------------------------
! Calcification
  Real(kind=8)  :: calcification
  Real(kind=8)  :: calc_loss_agg
  Real(kind=8)  :: calc_loss_gra
  Real(kind=8)  :: calc_diss
!-------------------------------------------------------------------------------
! Diagnostics
	Real(kind=8)  :: recipbiostep                         ! 1/number of steps per recom cycle
	Real(kind=8),allocatable,dimension(:,:) :: Diags3D
!-------------------------------------------------------------------------------
! Benthos
  Real(kind=8),dimension(4) :: decayBenthos ! [1/day] Decay rate of detritus in the benthic layer
  Real(kind=8),dimension(4) :: wFluxDet     ! [mmol/(m2 * day)] Flux of N,C,Si and calc through sinking of detritus
  Real(kind=8),dimension(4) :: wFluxPhy     ! [mmol/(m2 * day)] Flux of N,C, calc and chl through sinking of phytoplankton
  Real(kind=8),dimension(4) :: wFluxDia     ! [mmol/(m2 * day)] Flux of N,C, Si and chl through sinking of diatoms 	
  Real(kind=8)              :: Vben_det     ! [m/day] speed of sinking into benthos from water column
  Real(kind=8)              :: Vben_phy
  Real(kind=8)              :: Vben_dia 
  Real(kind=8)              :: Ironflux     ! [umol Fe/(m2*day)] Flux of Fe from sediment to water

end module REcoM_declarations

!===============================================================================
! For arrays needed for the whole 2D or 3D domain, but only used in REcoM
!-------------------------------------------------------------------------------
Module REcoM_GloVar
  implicit none
  save
	
  Real(kind=8),allocatable,dimension(:,:) :: Benthos          ! 4 types of benthos-tracers with size [4 n2d]
  Real(kind=8),allocatable,dimension(:,:) :: BenthosMean      ! 4 types of mean benthos-tracers with size [4 n2d]
  
  Real(kind=8),allocatable,dimension(:)   :: GloFeDust        ! [umol/m2/s] Monthly 2D field of iron soluted in surface water from dust
  Real(kind=8),dimension(12)              :: AtmCO2           ! [uatm] Atmospheric CO2 partial pressure. One value for the whole planet for each month

  Real(kind=8),allocatable,dimension(:)   :: AtmFeInput       ! [umol/m2/s] Includes ice, but is, other than that identlical to GloFeDust
  Real(kind=8),allocatable,dimension(:)   :: AtmFeInput_mean  ! [umol/m2/s] Monthly mean of fe-input (As long as Fe-input is only opened once per month this is equal to AtmFeInput)
  Real(kind=8),allocatable,dimension(:)   :: GloPCO2surf      ! [uatm] Surface ocean CO2 partial pressure
  Real(kind=8),allocatable,dimension(:)   :: GloPCO2surf_mean ! [uatm] Monthly mean of surface ocean CO2 partial pressure
  Real(kind=8),allocatable,dimension(:)   :: GloCO2flux       ! [mmol/m2/day] Positive downwards
  Real(kind=8),allocatable,dimension(:)   :: GloCO2flux_mean  ! [mmol/m2/day]
  Real(kind=8),allocatable,dimension(:)   :: GloHplus         ! [mol/kg] Concentrations of H-plus ions in the surface ocean
  Real(kind=8),allocatable,dimension(:)   :: GloHplus_mean    ! [mol/kg] Mean concentrations of H-plus ions in the surface ocean
  
  Real(kind=8),allocatable,dimension(:,:) :: diags2D          ! Diagnostics in 2D [8 n2d]
  Real(kind=8),allocatable,dimension(:,:) :: diags2D_mean     ! Mean diagnostics in 2D [8 n2d]
  
  Real(kind=8)                            :: GloTra, GloVol   ! Total amount of tracer in and volume of the world ocean. Used to test conservation. 
  Real(kind=8)                            :: GloTraMean       ! Mean amount of tracer in the world ocean = GloTra/GloVol. Used to test conservation.  
  	
end module REcoM_GloVar

!===============================================================================
! For variables saved locally for each column and then used in REcoM
!-------------------------------------------------------------------------------
Module REcoM_locVar

  Real(kind=8) :: LocBenthos(4)             ! Storing the values for benthos in current watercolumn: N,C,Si and Calc
  Real(kind=8) :: Hplus                     ! [mol/kg] Concentrations of H-plus ions in the surface node
  Real(kind=8) :: pCO2surf                  ! [uatm] Partial pressure of CO2 in surface layer at current 2D node	
  Real(kind=8) :: dflux                     ! [mmol/m2/day] Flux of CO2 into the ocean
  Real(kind=8) :: ULoc                      ! Wind strength above current 2D node
  Real(kind=8) :: bt, dic_molal, talk_molal ! Common block: Species
  Real(kind=8) :: k1, k2, kw, kb, ff        ! Common block: Equilibrium_constants
  Real(kind=8) :: FeDust                    ! [umol/m2/s]
  Real(kind=8) :: Loc_ice_conc              ! Used to calculate flux of DIC in REcoM 0 -> 1
  Real(kind=8) :: LocAtmCO2                 ! [uatm]
  Real(kind=8) :: LocDiags2D(8)
	
end module REcoM_LocVar
