!
! Here, the benthos is declared and initialized, and biogeochemical tracers are initialized.
!
! This routine is called from 'oce_input' and is only called when FESOM is doing a restart run.
!
!	- subroutine initialize_REcoM
!	
!========================================================================================================
  
subroutine initialize_REcoM
  use REcoM_params
  use REcoM_declarations
  use REcoM_GloVar
  use REcoM_locVar
  use REcoM_constants
  use g_parfe
  use g_clock
  use o_array
  use o_mesh
  implicit none 
  
#include "netcdf.inc"
  
  integer                   :: status, ncid, dimid_rec, nrec, varid
  integer                   :: tra_varid(num_tracer), benthos_varid(4)
  Integer                   :: istart(2), icount(2), size2D, size3D     ! Number of 2D and 3D nodes on current processor
  Integer                   :: i, j
  character(100)            :: filename
  character(2)              :: trind
  real(kind=8), allocatable :: aux2(:), aux3(:)
  real(kind=8), allocatable :: ncdata(:)
  character(100)            :: CO2filename
  character(20)             :: CO2vari
  integer                   :: CO2start, CO2count
  
  allocate(aux2(nod2D),aux3(nod3D))
  size2D = myDim_nod2D+eDim_nod2D
  size3D = myDim_nod3D+eDim_nod3D
  
!--------------------------------------------------------------------------
! Testing to see if settings for REcoM are correct
  if (.not. use_REcoM) then
  
    if (mype==0) write(*,*),'This run does not include REcoM'
    if (num_tracer .gt. 2) then
      if (mype==0) write(*,*),'REcoM is not activated, but number of tracers is larger than 2'
    end if 
  
  else ! REcoM is activated
    if(mype==0) write(*,*) '*************************************************************'
  
    if (num_tracer .ne. bgc_num+2) then
      if (mype==0) write(*,*),'num_tracer should equal bgc_num + 2'
    endif

#ifdef REcoM_calcification
    if (mype==0) write(*,*),'REcoM is activated with calcite'
    if (mype==0) write(*,*),'benthos Fe2C =',Fe2C_benthos
    
    if (bgc_num .ne. 21) then
      if (mype==0) write(*,*),'bgc_num must equal 21, it is now set to',bgc_num
      call abort
    end if
    
#else
    if (mype==0) write(*,*),'REcoM is activated without calcite'
    
    if (bgc_num .ne. 19) then 
      if (mype==0) write(*,*),'bgc_num must equal 19, it is now set to',bgc_num
      call abort
    end if
    
#endif
  
  end if

!--------------------------------------------------------------------------------------------------------
! Allocating and initializing atm dep of iron and arrays for diagnostics
  
  if (Felimit) then
    allocate(GloFeDust(size2D))
    allocate(AtmFeInput(size2D))
    allocate(AtmFeInput_mean(size2D))
    GloFeDust       = 0.d0
    AtmFeInput      = 0.d0
    AtmFeInput_mean = 0.d0

    if (mype==0) then
      if(yearnew .LT. 1979)then
        write(*,*),'Monthly dust climatology is used as interannually varying files do not exist for current year'
      else
        if (UseDustClim) then
	  write(*,*),'Monthly dust climatology is used'
	else
	  write(*,*),'Interannually varying monthly dust is used'
	end if ! DustClim
      end if   ! year < 1979
    end if     ! mype=0 
  end if       ! felimit
  
  allocate(GloHplus(size2D))
  allocate(GloPCO2surf(size2D))
  allocate(GloPCO2surf_mean(size2D))
  allocate(GloCO2flux(size2D))
  allocate(GloCO2flux_mean(size2D))
  allocate(GloHplus_mean(size2D))
  GloHplus         = exp(-8.d0 * log(10.d0))          !=10**(-8)
  GloHplus_mean    = 0.d0
  GloPCO2surf      = 0.d0
  GloPCO2surf_mean = 0.d0
  GloCO2flux       = 0.d0
  GloCO2flux_mean  = 0.d0
  
  AtmCO2      = 0.d0
  
  Hplus    = 0.d0
  pco2surf = 0.d0
  dflux    = 0.d0
  
  if (Diagnostics) then
    allocate(diags2D(8,size2D))
    allocate(diags2D_mean(8,size2D))
    diags2D      = 0.d0
    diags2D_mean = 0.d0
  end if  
   
  
    
  allocate(Benthos(4,Size2D))
  allocate(BenthosMean(4,Size2D)) 
  
!---------------------------------------------------------------------------------------------------------
! Initialization of tracers

  if (REcoM_restart) then
    ! open file
    filename=trim(ResultPath)//runid//'.'//cyearold//'.oce.nc'
    status = nf_open(filename, nf_nowrite, ncid)
    if (status .ne. nf_noerr) call handle_err(status)
    
    ! inquire variable id
    do j=3,num_tracer
      write(trind,'(i2.2)') j
      status=nf_inq_varid(ncid, 'tr'//trind, tra_varid(j))
      if (status .ne. nf_noerr) call handle_err(status)	
    end do
    
    ! read variables
  
    ! which record to read
    if(restartflag=='last') then
      status = nf_inq_dimid(ncid, 'T', dimid_rec)
      if(status .ne. nf_noerr) call handle_err(status)
      status = nf_inq_dimlen(ncid, dimid_rec, nrec)
      if(status .ne. nf_noerr) call handle_err(status)
    else
      read(restartflag,'(i4)') nrec
    end if
    
    ! 3d fields
    istart=(/1,nrec/)
    icount=(/nod3d, 1/)
    do j=3,num_tracer
      status=nf_get_vara_double(ncid, tra_varid(j), istart, icount, aux3) 
      if (status .ne. nf_noerr) call handle_err(status)
      tracer(:,j)=aux3(myList_nod3D)
    end do
        
    status=nf_close(ncid)
    if (status .ne. nf_noerr) call handle_err(status)
    if(mype==0) write(*,*),'Tracers have been initialized'
    
!-------------------------------------------------------------------------------------------------
! Initialization of benthos from file -.bio.diag.nc

    ! open file
    filename=trim(ResultPath)//runid//'.'//cyearold//'.bio.nc'
    status = nf_open(filename, nf_nowrite, ncid)
    if (status .ne. nf_noerr) call handle_err(status)    
    
    ! inquire variable id
    status=nf_inq_varid(ncid, 'BenN', benthos_varid(1))
	if (status .ne. nf_noerr) call handle_err(status)
	    
	status=nf_inq_varid(ncid, 'BenC', benthos_varid(2))
    if (status .ne. nf_noerr) call handle_err(status)
         
    status=nf_inq_varid(ncid, 'BenSi', benthos_varid(3))
    if (status .ne. nf_noerr) call handle_err(status)
         
    status=nf_inq_varid(ncid, 'BenCalc', benthos_varid(4))
    if (status .ne. nf_noerr) call handle_err(status)
    
    ! read variables
  
    ! which record to read
    if(restartflag=='last') then
      status = nf_inq_dimid(ncid, 'T', dimid_rec)
      if(status .ne. nf_noerr) call handle_err(status)
      status = nf_inq_dimlen(ncid, dimid_rec, nrec)
      if(status .ne. nf_noerr) call handle_err(status)
    else
      read(restartflag,'(i4)') nrec
    end if
  
    ! 2d fields
    istart=(/1,nrec/)
    icount=(/nod2d, 1/)
    do j=1,4
          status=nf_get_vara_double(ncid, benthos_varid(j), istart, icount, aux2) 
          if (status .ne. nf_noerr) call handle_err(status)
          Benthos(j,:)=aux2(myList_nod2D)
    end do
    
    status=nf_close(ncid)
    if (status .ne. nf_noerr) call handle_err(status)
    if(mype==0) write(*,*),'Tracers have been initialized for REcoM using values from last run'
  
  else

    ! Initializing REcoM to do spin-up
    ! DIN, DIC, alk, Si and Fe are initialized from databases (not as spin-up)
    
    ! tracer 3 = DIN
    open(11, file='initDIN.fld')
    do j=1, nod3D
      read(11, *) aux3(j)
    end do      
    close(11)
    tracer(:,3)=aux3(myList_nod3D)
      
    ! tracer 4 = DIC = TCO2
    open(11, file='initTCO2.fld')
    do j=1, nod3D
      read(11, *) aux3(j)
    end do      
    close(11)
    tracer(:,4)=aux3(myList_nod3D)
      
    ! tracer 5 = Total Alkalinity
    open(11, file='initAlk.fld')
    do j=1, nod3D
      read(11, *) aux3(j)
    end do      
    close(11)
    tracer(:,5)=aux3(myList_nod3D)
      
    tracer(:,6)  = tiny            ! tracer 6  = PhyN
    tracer(:,7)  = tiny * Redfield ! tracer 7  = PhyC
    tracer(:,8)  = tiny * 1.56d0   ! tracer 8  = PhyChl
    tracer(:,9)  = tiny            ! tracer 9  = DetN
    tracer(:,10) = tiny            ! tracer 10 = DetC
    tracer(:,11) = tiny            ! tracer 11 = HetN
    tracer(:,12) = tiny * Redfield ! tracer 12 = HetC
    tracer(:,13) = tiny            ! tracer 13 = DON
    tracer(:,14) = tiny            ! tracer 14 = DOC
    tracer(:,15) = tiny            ! tracer 15 = DiaN
    tracer(:,16) = tiny * Redfield ! tracer 16 = DiaC
    tracer(:,17) = tiny * 1.56d0   ! tracer 17 = DiaCh
    tracer(:,18) = tiny            ! tracer 18 = DiaSi
    tracer(:,19) = tiny            ! tracer 19 = DetSi
    
    ! tracer 20 = Si
    open(11, file='initSi.fld')
    do j=1, nod3D
      read(11, *) aux3(j)
    end do      
    close(11)
    tracer(:,20)=aux3(myList_nod3D)
      
    ! tracer 21 = Fe
    open(11, file='initFe.fld')
    do j=1, nod3D
      read(11, *) aux3(j)
    end do      
    close(11)
    tracer(:,21)=aux3(myList_nod3D)        
 
#ifdef REcoM_calcification
    tracer(:,22) = cPhyN * 0.25d0   ! tracer 22 = PhyCalc
    tracer(:,23) = tiny             ! tracer 23 = DetCalc
#endif
  
!---------------------------------------------------------------------------------------------------------
! Initialization of benthos
! Benthic layer consists of Benthos(1) = N, Benthos(2)=C, Benthos(3)=Si, Benthos(4)=calc
  
    do j = 1, size2D
      do i = 1,4
        Benthos(i,j) = tiny
      end do
    end do

    if(mype==0) write(*,*),'REcoM has been initialized as spin-up'
    
  end if ! .not. REcoM_restart

!------------------------------------------------------------------------------------------------------
! Initializing output netcdf files

  call REcoM_init_output
  
  deallocate(aux2,aux3)
        
end subroutine initialize_REcoM
