/*--------------------------------------------------------------*/
/* variables.h (last modified: 12/06/2013) 			            */
/* specification of global variables, routines and sub-routines */
/*--------------------------------------------------------------*/

#ifndef VARIABLES_H
#define VARIABLES_H
#include "define.h"

// MAIN.C
int main();                                                     //main model routine

// HYD.C
extern void   Hyd(int);                                         //main hydrodynamic routine

// TRANSPORT.C
extern void   Transport(int);                                   //main transport routine

// INIT.C
int include_constantDEPTH;                                      //include formulations for a constant estuarine depth
extern double Min(double, double);                              //logical definition a minimum value
extern double Max(double, double);                              //logical definition a minimum value
extern void   Init();                                           //initialize model arrays and setup boundary conditions

// FUN.C
extern double D_O2(int);                                        //O2 molecular diffusion [m2 s-1]
extern double Sc(int, int);                                     //Schmidt number [-]
extern void   piston_velocity(int);                             //piston velocity [m s-1]
extern double Tide(int);                                        //tidal amplitude [m]
extern double Tabs(int);                                        //absolute temperature [K]
extern double I0(int);                                          //light intensity [muE m-2 s-1]
extern double Fhet(int);                                        //temperature-dependence for hetrotrophic biogeochemical reactions [-]
extern double Fnit(int);                                        //temperature-dependence for nitrification [-]
extern double O2sat(int, int);                                  //O2 saturation [muM O2]

// SCHEMES.C
extern void   Openbound(double*, int);                          //set open boundary conditions
extern void   TVD(double*, int);                                //total variation diminishing scheme
extern void   Disp(double*);                                    //dispersion scheme

// TRIDAG.C
extern void   Coeffa(int);                                      //tridiagonal matrix coefficients
extern void   Tridag();                                         //tridiagonal matrix
extern double Conv(int,int,double, double*, double*);           //convergence test

// UPHYD.C
extern void   Newbc(int);                                       //set hydrodynamic boundary conditions
extern void   Update();                                         //update temporary hydrodynamic variables
extern void   NewUH();                                          //update hydrodynamic variables

// BIOGEO.C
extern void   Biogeo(int);                                      //biogeochemical reaction network

// SED.C
extern void   Sed(int);                                         //sediment module

// FILE.C
extern void   Hydwrite(int);                                    //write hydrodynamic output files
extern void   Transwrite(double*, char s[10], int);             //write transport output file
extern void   Rates(double*, char s[50], int);                  //write biogeochemical process rate output files

// CHEMICAL SPECIES AND SPM
enum chem  {DIA, dSi, NO3, NH4, PO4, O2, TOC, S, SPM};
#ifndef STRUCT_VERB
#define STRUCT_VERB
struct Verb {
  char   name [10];
  int    env;
  double c[M+1];                                                //concentration [muM]
  double clb;					                                //concentration at downstream boundary [muM]
  double cub;					                                //concentration at upstream boundary [muM]
  double avg[M+1];                                              //average concentration [muM]
  double concflux[M+1];			                                //concentration flux [muM s-1]
  double advflux[M+1];			                                //advective flux
  double disflux[M+1];			                                //dispersive flux
}
v[MAXV];
#else
  extern struct Verb  v[MAXV];
#endif

// VARIABLES
//hydrodynamics
double Y[M+1];			                                        //convergence test
double E[M+1];			                                        //convergence test
double ZZ[M+1];			                                        //cross-section at reference level [m2]
double D[M+1];			                                        //total cross-section [m2]
double Dold[M+1];                                               //total cross-section [m2]
double Chezy[M+1];                                              //Chezy coefficient [m s-2]
double Dold2[M+1];                                              //total cross-section  [m2]
double DEPTH[M+1];		                                        //water depth  [m]
double H[M+1];			                                        //free cross section  [m2]
double U[M+1];			                                        //flow velocity [m s-1]
double B[M+1];			                                        //width [m]
double TH[M+1];			                                        //temporary free cross section [m]
double TU[M+1];			                                        //temporary velocity [m s-1]
double LC;			                                            //width convergence length [m]

//transport
double C[M+1][5];                                               //coefficients for tridiagonal matrix
double Z[M+1];                                                  //coefficients for tridiagonal matrix
double fl[M+1];                                                 //advective flux [mmol s-1]
double aold[M+1];                                               //dispersion scheme variable
double cold[M+1];                                               //dispersion scheme variable
double rold[M+1];                                               //dispersion scheme variable
double ccold[M+1];                                              //dispersion scheme variable
double disp[M+1];                                               //dispersion coefficient [m2 s-1]

//piston velocity for O2 exchange across air-water interface
double kwind[M+1];                                              //wind component for piston velocity [m s-1]
double kflow[M+1];                                              //current component for piston velocity [m s-1]
double vp[M+1];                                                 //piston velocity [m s-1]

//SPM
double Mero[M+1];                                               //erosion coefficient [mg m-2 s-1]
double tau_ero[M+1];                                            //critical shear stress for erosion [N m-2]
double tau_dep[M+1];                                            //critical shear stress for deposition  [N m-2]
double tau_b[M+1];                                              //bottom shear stress  [N m-2]
double erosion[M+1];                                            //sediment erosion rate [mg m-2 s-1]
double deposition[M+1];                                         //sediment deposition rate [mg m-2 s-1]

//biogeochemistry
double NPP_NO3[M+1];                                            //Net Primary Production rate using NO3  [mmol C m-3 s-1]
double NPP_NH4[M+1];                                            //Net Primary Production rate using NH4  [mmol C m-3 s-1]
double GPP[M+1];                                                //Gross Primary Production rate  [mmol C m-3 s-1]
double phy_death[M+1];                                          //phytoplankton death rate  [mmol C m-3 s-1]
double NPP[M+1];                                                //Net primary priduction rate  [mmol C m-3 s-1]
double Si_consumption[M+1];                                     //silica consumption rate  [mmol Si m-3 s-1]
double aer_deg[M+1];                                            //aerobic degradation rate  [mmol C m-3 s-1]
double denit[M+1];                                              //denitrification rate  [mmol C m-3 s-1]
double nit[M+1];                                                //nitrification rate  [mmol N m-3 s-1]
double O2_ex[M+1];                                              //O2 flux across air-water interface  [mmol O2 m-3 s-1]
double NEM[M+1];                                                //Net Ecosystem Metabolism  [mmol C m-3 s-1]

#endif


