/*-----------------------------------*/
/* sed.c (last modified: 12/06/2013) */
/* sediment module                   */
/*-----------------------------------*/

#include <math.h>
#include "define.h"
#include "variables.h"

void Sed(int t)
{
	int i;

	for(i=1; i<=M; i++)
	{
        // EROSION AND DEPOSITION RATES FOR SPM [mg m-2 s-1]
        tau_b[i]=rho_w*G*U[i]*U[i]/(Chezy[i]*Chezy[i]);
        Mero[i]= (i>=distance) ? Mero_ub : Mero_lb;
        tau_ero[i]= (i>=distance) ? tau_ero_lb+(tau_ero_ub-tau_ero_lb)*(i-50)*1/(M-50) : tau_ero_lb;
        tau_dep[i]= (i>=distance) ? tau_dep_lb+(tau_dep_ub-tau_dep_lb)*(i-50)*1/(M-50) : tau_dep_lb;

        erosion[i]= (tau_ero[i] >= tau_b[i])	?	0.0 : Mero[i]*(tau_b[i]/tau_ero[i]-1.0);
        deposition[i]=(tau_dep[i] >= tau_b[i])	?	ws*(1.0-tau_b[i]/tau_dep[i])*v[SPM].c[i] : 0.0;

        if (include_constantDEPTH==1)
        {
            tau_ero[i]= (i>=distance) ? tau_ero_ub : tau_ero_lb;
            tau_dep[i]= (i>=distance) ? tau_dep_ub : tau_dep_lb;
        }

        // UPDATE SPM CONCENTRATION [g/l]
        v[SPM].c[i]= (v[SPM].c[i] + 1.0/DEPTH[i]*(erosion[i]-deposition[i])*DELTI);
	}
}
