/*-----------------------------------*/
/* hyd.c (last modified: 12/06/2013) */
/* main hydrodynamic routine         */
/*-----------------------------------*/

#include "define.h"
#include "variables.h"

void Hyd(int t)
{
    int i;
    double rsum;

    for(i=1; i<=M; i++) Dold2[i]=D[i];

    Newbc(t); //set new boundary conditions
    rsum=0;
    i=0;

    do
    {
        i=i+1;
        Coeffa(t);
        Tridag();
        rsum=Conv(3,M1,TOL,TH,E)+Conv(2,M2,TOL,TU,Y);
        Update();
    } while(rsum!=2.);

    NewUH(); //update U,H

    //Write files
    if((double)t/(double)(TS*DELTI)-floor((double)t/(double)(TS*DELTI))==0.0)
    {
        Hydwrite(t);
    }
}




