/*----------------------------------------------------------------------*/
/* fun.c (last modified: 12/06/2013)                                    */
/* dispersion coefficient, external forcings and functions for biogeo.c */
/*----------------------------------------------------------------------*/

#include <math.h>
#include "define.h"
#include "variables.h"

// MOLECULAR DIFFUSION COEFFICIENT FOR O2 [m2 s-1]
double D_O2(int t)
{
    double D_O2, T;
    T=Tabs(t);
    D_O2=(6.35*T-1664.)*1.0e-11;
    return D_O2;
}

// SCHMIDT NUMBER [-]
double Sc(int t, int i)
{
    double Sc0, temp, Sc;
    temp= Tabs(t)-273.15;
    Sc0=1800.6-120.1*temp+3.7818*(temp*temp)-0.047608*(temp*temp*temp);
    Sc=Sc0*(1+(3.14e-3)*v[S].c[i]);
    return Sc;
}

// PISTON VELOCITY FOR O2 EXCHANGE ACROSS AIR-WATER INTERFACE [m s-1]
void piston_velocity(int t)
{
    int i;
    for (i=0; i<=M; i++)
    {
        kflow[i]=pow((fabs(U[i]))*D_O2(t)/DEPTH[i],0.5);
        kwind[i]= (i<=distance) ? (1/3.6e5)*0.31*(Uw_sal*Uw_sal)*pow(Sc(t,i)/660,-0.5) : (1/3.6e5)*0.31*(Uw_tid*Uw_tid)*pow(Sc(t,i)/660,-0.5);
        vp[i]=kflow[i]+kwind[i];
    }
}

// TIDAL ELEVATION [m]
double Tide(int t)
{
    double omega, cv, v0;

    omega=2.*PI/3600.0;
    cv=2.*PI/360.0;
    v0=0.5*AMPL*sin(pfun*omega*t);

    return v0;
}

// ABSOLUTE TEMPERATURE [K]
double Tabs(int t)
{
	double T;
	T = 273.15+water_temp;
	return T;
}

// LIGHT INTENSITY [muE m-2 s-1]
double I0(int t)
{
	double I,  l, r, nday, h, ncloud;
    ncloud=0.6;
	nday= ceil(t/(24.*60.*60.))-1.-((double)WARMUP)/(24*60*60);
	h   = (ceil(t/(60.*60.))-1.)-((double)WARMUP)/(60*60)-(nday)*24.;
	r = 16.5;
	l   = (PI/2.)*sin(PI*((t/(60.*60.))-(12.- r/2.))/r);
	I= 1000*ncloud*l;
	I   = (I<0) ? 0.0 : I;
	return I;
}

// T-DEPENDENCE FOR HETEROTROPHIC REACTIONS [-]
double Fhet(int t)
{
	double f,a;
	a=(Tabs(t)-278.)/10.;
	f=pow(2.75,a);
	return f;
}

// T-DEPENDENCE FOR NITRIFICATION [-]
double Fnit(int t)
{
	double f,a;
	a=(Tabs(t)-278.)/10.;
	f=pow(5.,a);
	return f;
}

// O2 SATURATION  [mmol O2 m-3]
double O2sat(int t, int i)
{
	double O2, T, f, lnO2sat;
	T=Tabs(t);
	lnO2sat=-1.3529996*100.+157228.8/T - 66371490./(T*T) + 12436780000./(T*T*T) - 8621061.*100000./(T*T*T*T);
	f=-0.020573 + 12.142/T -2363.1/(T*T);
	O2=exp(lnO2sat+f*v[S].c[i]);
	return O2;
}
