/*------------------------------------*/
/* file.c (last modified: 12/06/2013) */
/* write output files                 */
/*------------------------------------*/

#include "define.h"
#include "variables.h"

// WRITE PHYSICAL VARIABLES IN OUTPUT FILES
void Hydwrite (int t)
{
  FILE *fptr1;
  FILE *fptr2;

  int i;

  fptr1=fopen("depth.dat","a");                     //water depth [m]
  fptr2=fopen("width.dat","a");                     //estuarine width [m]

  fprintf(fptr1,"%d\t ",t);
  fprintf(fptr2,"%d\t ",t);

  for(i=0; i<=M; i++)
  {
    fprintf(fptr1,"%f\t ",DEPTH[i]);
    fprintf(fptr2,"%f\t ",B[i]);
  }

  fprintf(fptr1,"\n ");
  fprintf(fptr2,"\n ");

  fclose(fptr1);
  fclose(fptr2);
}

// FORMAT SPECIFICATION FOR CONCENTRATION OUTPUT FILES
void Transwrite (double *co, char s[10], int t)
{
  FILE *fptr1;
  int i;
  char datei[10];

  strcpy(datei,s);
  fptr1=fopen(datei,"a");
  fprintf(fptr1,"%d\t ",t);

  for(i=1; i<=M; i++)
  {
    fprintf(fptr1,"%.15e\t ",co[i]);
  }

  fprintf(fptr1,"\n");
  fclose(fptr1);
}

// FORMAT SPECIFICATION FOR BIOGEOCHEMICAL REACTION RATES OUTPUT FILES
void Rates (double *co, char s[50], int t)
{
  FILE *fptr1;
  int i;
  char datei[50];

  strcpy(datei,s);
  fptr1=fopen(datei,"a");
  fprintf(fptr1,"%d\t ",t);

  for(i=1; i<=M; i++)
  {
    fprintf(fptr1,"%e\t ",co[i]);
  }

  fprintf(fptr1,"\n ");
  fclose(fptr1);
}
