/*--------------------------------------*/
/* biogeo.c (last modified: 12/06/2013) */
/* biogeochemical reaction network      */
/*--------------------------------------*/

#include <math.h>
#include "define.h"
#include "variables.h"

void Biogeo(int t)
{
	double nlim, integral, KD, Ebottom, psurf, pbot, appGAMMAsurf, appGAMMAbot, fNH4;
	int i;

	piston_velocity(t);

	for(i=1; i<=M; i++)
	{
        // UNDERWATER LIGHT FIELD AND NUTRIENT DEPENDENCE FOR PRIMARY PRODUCTION
        KD = KD1+KD2*(1000.0*v[SPM].c[i]+100.0);
        Ebottom = I0(t)*exp(-KD*DEPTH[i]);
        psurf = I0(t)*alpha/Pbmax;
        pbot = Ebottom*alpha/Pbmax;
        if(psurf<=1.)
            appGAMMAsurf = -(log(psurf) + Euler - psurf + pow(psurf,2.) / 4. - pow(psurf,3.) / 18. + pow(psurf,4.) / 96. - pow(psurf,5.) / 600.);
        else
            appGAMMAsurf = exp(-psurf) * (1. / (psurf + 1. - (1. / (psurf + 3. - (4. / (psurf + 5. - (9. / (psurf + 7. - (16. / (psurf + 9.))))))))));
        if(pbot<=1.)
            appGAMMAbot = - (log(pbot) + Euler + pbot - pow(pbot,2.) / 4. + pow(pbot,3.) / 18. - pow(pbot,4.) / 96. + pow(pbot,5.) / 600.);
        else
            appGAMMAbot = exp(-pbot) * (1. / (pbot + 1. - (1. / (pbot + 3. - (4. / (pbot +5. - (9. / (pbot +  7. - (16. / (pbot + 9.))))))))));
        integral = (I0(t) <= 0.0) || (Ebottom < 1.e-300) ? 0.0 : (appGAMMAsurf - appGAMMAbot + log(I0(t) / Ebottom)) / (KD);
        nlim = (v[dSi].c[i] <= 0.0) ? 0.0 : v[dSi].c[i] / (v[dSi].c[i] + KdSi) * (v[NO3].c[i] + v[NH4].c[i]) / ((v[NH4].c[i] + v[NO3].c[i]) + KN) * (v[PO4].c[i] / (v[PO4].c[i] + KPO4));
        fNH4 = (v[NH4].c[i] <= 0.0) ? 0.0 : v[NH4].c[i] / (10. + v[NH4].c[i]);

        // BIOGEOCHEMICAL REACTION RATES [mmol m-3 s-1]
        GPP[i] = Pbmax * v[DIA].c[i] * nlim * integral;
        NPP_NO3[i] = (1. - fNH4) * ((GPP[i] / DEPTH[i]) * (1. - kexcr) * (1. - kgrowth) - kmaint * v[DIA].c[i]);
        NPP_NH4[i] = fNH4 * ((GPP[i] / DEPTH[i]) * (1. - kexcr) * (1. - kgrowth) - kmaint * v[DIA].c[i]);
        NPP[i] = NPP_NO3[i] +NPP_NH4[i];
        phy_death[i] = kmort * v[DIA].c[i];
        Si_consumption[i]=Max(0.0,redsi*NPP[i]);
        aer_deg[i] = kox * Fhet(t) * v[TOC].c[i] / (v[TOC].c[i]+KTOC) * v[O2].c[i] / (v[O2].c[i] + KO2);
        denit[i] = kdenit * Fhet(t) * v[TOC].c[i] / (v[TOC].c[i] + KTOC) * KinO2 / (v[O2].c[i] + KinO2) * v[NO3].c[i] / (v[NO3].c[i] + KNO3);
        nit[i] = knit * Fnit(t) * v[O2].c[i] / (v[O2].c[i] + KO2) * v[NH4].c[i] / (v[NH4].c[i] + KNH4);
        O2_ex[i]=(vp[i]/DEPTH[i])*(O2sat(t,i) - v[O2].c[i]);
        NEM[i] = NPP[i]-aer_deg[i]-denit[i];
	}

    // UPDATE BIOGEOCHEMICAL STATE VARIABLES [mmol m-3]
    for (i=1; i<=M; i++)
	{
        v[DIA].c[i] = v[DIA].c[i]+(NPP[i]-phy_death[i])*DELTI;
        v[dSi].c[i]  =v[dSi].c[i]  - (Si_consumption[i])*DELTI;
        v[NO3].c[i] =v[NO3].c[i] +(-94.4/106.*denit[i]+nit[i]-redn*(NPP_NO3[i]))*DELTI;
        v[NH4].c[i] =v[NH4].c[i] +(redn*(aer_deg[i]-NPP_NH4[i])-nit[i])*DELTI;
        v[PO4].c[i] =v[PO4].c[i] +(redp*(aer_deg[i]+denit[i]-NPP[i]))*DELTI;
        v[O2].c[i]  =v[O2].c[i]  + (-aer_deg[i]+(NPP_NH4[i])+(138./106.)*(NPP_NO3[i])-2.*nit[i] + O2_ex[i])*DELTI;
        v[TOC].c[i] =v[TOC].c[i] +(-aer_deg[i]-denit[i]+phy_death[i])*DELTI;
	}

	// WRITE BIOGEOCHEMICAL PROCESS RATES [mmol m-3]
    if((double)t/(double)(TS*DELTI)-floor((double)t/(double)(TS*DELTI))==0.0)
	{
        Rates(NPP, "NPP.dat", t);                       //Net Primary Production
        Rates(aer_deg, "aer_deg.dat", t);               //aerobic degradation
        Rates(denit, "denit.dat", t);                   //denitrification
        Rates(nit, "nit.dat", t);                       //nitrification
        Rates(O2_ex, "O2_ex.dat", t);                   //O2 flux across air-water interface
        Rates(NEM,"NEM.dat",t);                         //Net Ecosystem Metabolism
	}
}
