% Haerer, Bernhardt, Schulz and Corripio (2012)
% "PRACTISE - Photo Rectification And ClassificaTIon SoftwarE"
%
%   written by
%   Stefan Hrer (LMU Munich)
%   08/2012
%   contact: s.haerer@iggf.geo.uni-muenchen.de
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   Name:       Input_PRACTISE
%   Purpose:    Input file of PRACTISE
%   Comment:    Edit variables as needed, but leave the condition terms of 
%               the if-else-conditions untouched (see Manual).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% switches
%   viewshed
%       true=generate viewshed (specified camera angles)
%       false=use existing viewshed (load from ASCII-file [cf. ESRI ArcGIS])
vs=true;
%   ground control points       
%       true=w ground control points
%       false=w/o ground control points
gs=true;
%   optimization switch
%       true=w DDS optimization
%       false=w/o DDS optimization
os=true;
%   classification switch
%       true=automatic classification
%       false=manual classification
cs=true;
%   image switch
%       true=classify all images in a specific folder 
%       false=classify a single image
is=false;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% files
%   as input:
%       Photograph (RGB)
if is==false
%           single photo
    fin_image='photos/ufs20110511_0815_4dot5Mpx.tif';
elseif is==true
%           multiple photo
%               folder and format
    fin_imfolder='photos/XYZ';
    fin_imformat='.tif';
end
%       DEM (ASCII-file [cf. ESRI ArcGIS])
fin_demW='input/dem_30m.txt';
%       Viewshed (ASCII-file [cf. ESRI ArcGIS], same header as DEM)
if vs==false
    fin_viewW='XYZ.asc';
end
%       Ground Control Points 
if gs==true
%           number of ground control points
    N_gcpW=6;
%           ASCII-file w headerline: POINT_X POINT_Y POINT_Z Pixel_col Pixel_row GCPname
    fin_gcpW='input/GCPortho6_4dot5Mpx.txt';
end
%   as output:
%       folder
fout_folder='output/';
%       Viewshed (ASCII-file [cf. ESRI ArcGIS])
if vs==true
    fout_viewW_asc='ufs20110511_0815_4dot5Mpx_view.asc';
end
%       single image
%           Classification (ASCII-file [cf. ESRI ArcGIS])
if is==false
    fout_classW_asc='ufs20110511_0815_4dot5Mpx_class.asc';
%           save in Matlab (MAT-file)
    fout_mat='ufs20110511_0815_4dot5Mpx_proj.mat';
end
%       multiple image
% fout_classW and fout_mat are automatically generated from the respective
% image name
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Camera parameters
%   view position 
%       longitude and latitude
cam(:,1)=[649299.97, 5253358.26]; % altitude will be calculated!
        % offset height (only positive values in [m])
cam_off=1.5; 
%   target position (longitude and latitude)
cam(:,2)=[648740.85, 5252771.33]; % altitude will be calculated!
%   properties
%       roll angle of camera (from -90 to 90 [deg]) 
%           horizontal = 0
%           clockwise towards +90 
%           anti-clockwise towards -90
cam_rol=0.0; 
%       focal length of camera lens [m]
cam_foc=0.031; 
%       camera sensor 
%           height [m]
cam_hei=0.0149; 
%           width [m]
cam_wid=0.0223;
%       photograph size
%           number of pixel rows
pix_r=1728; 
%           number of pixel columns
pix_c=2592;
% Classification
if cs==false
%   manual classification
%   rule 1: RGB pixel value greater or equal than threshold [R;G;B]
    thres_rgb=[XYZ;XYZ;XYZ]; 
%   rule 2: maximum of RGB pixel values difference (delta of max(RGB) to min(RGB)) 
    delta_rgb=XYZ; 
elseif cs==true
%   automatic classification
%     B pixel value greater or equal than the threshold
    thres_b_orig=127;
%     size of the smoothing window for the DN frequency histogram 
%       use odd numbers
    movavgwindow=5;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DDS parameters
%   Seed parameters (X0) will be calculated using
%           viewpoint longitude [m]
%           viewpoint latitude [m] 
%           cam_off in [m]
%           cam_rol in [deg]                        
%           targetpoint longitude [m]
%           targetpoint latitude [m]
%           focal length of the camera lens [m]
if os==true
%   Upper boundary deviations (UBD) from X0 using 
    UBD=[150, 150, 5, 2, 100, 100, 0.005];
%   Lower boundary deviations (LBD) from X0 using
    LBD=[-150, -150, -1.0, -2, -100, -100, -0.005];
%   run parameters    
%       Neighborhood pertubation size (0.2 default by authors)
    DDS_R=0.2;                   
%       Maximum number of function evaluations    
    DDS_MaxEval=3000;                  
end