% Haerer, Bernhardt, Schulz and Corripio (2012)
% "PRACTISE - Photo Rectification And ClassificaTIon SoftwarE"
%
%   written by
%   Stefan Hrer (LMU Munich)
%   08/2012
%   contact: s.haerer@iggf.geo.uni-muenchen.de
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [cam, cam_rc] = Cam_PRACTISE(cam, cam_off, dem, header)
%   Name:       Cam_PRACTISE
%   Purpose:    Calculate camera position using longitude, latitude and camera
%               offset height
%                   1) altitude in DEM raster and world coordinates
%                   2) in raster (rows, cols)
%
%   Output:     cam (longitude, latitude and altitude of view and target point)
%               cam_rc (cols and rows in DEM raster, altitude)
%   Input:      cam (longitude, latitude of view and target point)
%               cam_off (camera offset height)
%               dem (DEM raster from ASCII-file [cf. ESRI ArcGIS])
%               header (values od DEM ASCII-file header [cf. ESRI ArcGIS]:
%                 ncols, nrows, xllcorner, yllcorner, cellsize, NODATA_value)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Camera positions 
%   viewpoint in rows and columns
cam_rc=NaN(3,2);
cam_rc(1,1)=round((cam(1,1)-header(3,1)+(0.5*header(5,1)))/header(5,1)); % longitude -> col
cam_rc(2,1)=round((-cam(2,1)+header(4,1)+(header(2,1)*header(5,1)) ...
    +(0.5*header(5,1)))/header(5,1)); % latitude -> row
cam(3,1)=dem(cam_rc(2,1),cam_rc(1,1))+cam_off; % DEM(latitude,longitude)
cam_rc(3,1)=cam(3,1)/header(5,1);

%   target in rows and columns
cam_rc(1,2)=round((cam(1,2)-header(3,1)+(0.5*header(5,1)))/header(5,1)); % longitude -> col
cam_rc(2,2)=round((-cam(2,2)+header(4,1)+(header(2,1)*header(5,1)) ...
    +(0.5*header(5,1)))/header(5,1)); % latitude -> row
cam(3,2)=dem(cam_rc(2,2),cam_rc(1,2)); % DEM(latitude,longitude)
cam_rc(3,2)=cam(3,2)/header(5,1);