MODULE trcsms_medusa
   !!======================================================================
   !!                         ***  MODULE trcsms_medusa  ***
   !! TOP :   Main module of the MEDUSA tracers
   !!======================================================================
   !! History :   2.0  !  2007-12  (C. Ethe, G. Madec) Original code
   !!              -   !  2008-08  (K. Popova) adaptation for MEDUSA
   !!              -   !  2008-11  (A. Yool) continuing adaptation for MEDUSA
   !!              -   !  2010-03  (A. Yool) updated for branch inclusion
   !!----------------------------------------------------------------------
#if defined key_medusa
   !!----------------------------------------------------------------------
   !!   'key_medusa'                                       bio tracers
   !!----------------------------------------------------------------------
   !! trc_sms_medusa   : MEDUSA_TRC model main routine 
   !!----------------------------------------------------------------------
   USE par_trc         ! TOP parameters
   USE oce_trc
   USE trc
   USE trcbio_medusa
   USE trcopt_medusa
   USE trcsed_medusa


   IMPLICIT NONE
   PRIVATE

   PUBLIC   trc_sms_medusa   ! called by trcsms.F90 module

   !!----------------------------------------------------------------------
   !! NEMO/TOP 2.0 , LOCEAN-IPSL (2007) 
   !! $Id: trcsms_medusa.F90 1162 2008-07-02 09:33:33Z cetlod $ 
   !! Software governed by the CeCILL licence (modipsl/doc/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------

CONTAINS

   SUBROUTINE trc_sms_medusa( kt )
      !!----------------------------------------------------------------------
      !!                     ***  trc_sms_medusa  ***  
      !!
      !! ** Purpose :   main routine of MEDUSA_TRC model
      !!
      !! ** Method  : - 
      !!----------------------------------------------------------------------
      INTEGER, INTENT(in) :: kt   ! ocean time-step index

      IF( kt == nittrc000 ) THEN
       IF(lwp) WRITE(numout,*)
       IF(lwp) WRITE(numout,*) ' trc_sms_medusa:  MEDUSA model'
       IF(lwp) WRITE(numout,*) ' ~~~~~~~~~~~~~~'
      ENDIF

      CALL trc_opt_medusa( kt )   ! optical model

      CALL trc_bio_medusa( kt )   ! biological model

      CALL trc_sed_medusa( kt )   ! sedimentation model

   END SUBROUTINE trc_sms_medusa
   
#else
   !!----------------------------------------------------------------------
   !!   Dummy module                                        No MEDUSA model
   !!----------------------------------------------------------------------
CONTAINS
   SUBROUTINE trc_sms_medusa( kt )             ! Empty routine
      INTEGER, INTENT( in ) ::   kt
      WRITE(*,*) 'trc_sms_medusa: You should not have seen this print! error?', kt
   END SUBROUTINE trc_sms_medusa
#endif

   !!======================================================================
END MODULE trcsms_medusa
