MODULE trclsm_medusa
   !!======================================================================
   !!                      ***  MODULE trclsm_medusa  ***
   !! TOP :   initialisation of some run parameters for MEDUSA bio-model
   !!======================================================================
   !! History :   2.0  !  2007-12  (C. Ethe, G. Madec) Original code
   !!              -   !  2008-08  (K. Popova) adaptation for MEDUSA
   !!              -   !  2008-11  (A. Yool) continuing adaptation for MEDUSA
   !!              -   !  2010-03  (A. Yool) updated for branch inclusion
   !!----------------------------------------------------------------------
#if defined key_medusa
   !!----------------------------------------------------------------------
   !!   'key_medusa'   :                                       MEDUSA model
   !!----------------------------------------------------------------------
   !! trc_lsm_medusa      : MEDUSA model initialisation
   !!----------------------------------------------------------------------
   USE oce_trc         ! Ocean variables
   USE par_trc         ! TOP parameters
   USE trc             ! TOP variables
   USE sms_medusa      ! sms trends
   IMPLICIT NONE
   PRIVATE

   PUBLIC   trc_lsm_medusa   ! called by trclsm.F90 module

   !!----------------------------------------------------------------------
   !! NEMO/TOP 2.0 , LOCEAN-IPSL (2007) 
   !! $Id: trclsm_medusa.F90 1162 2008-07-02 09:33:33Z cetlod $ 
   !! Software governed by the CeCILL licence (modipsl/doc/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------

CONTAINS

   SUBROUTINE trc_lsm_medusa
      !!----------------------------------------------------------------------
      !!                     ***  trc_lsm_medusa  ***  
      !!
      !! ** Purpose :   read MEDUSA namelist
      !!
      !! ** input   :   file 'namelist.trc.sms' containing the following
      !!             namelist: natbio, natopt, and natdbi ("key_trc_diabio")
      !!
      !! ekp: namelist nabio contains ALL parameters of the ecosystem 
      !!      point sourses and sinks PLUS sediment exchange
      !!      dia_bio - used by Lobster to output all point terms 
      !!                (sourses and sinks of bio)
      !!      dia_add - additional diagnostics for biology such as 
      !!                primary production (2d depth integrated field or 3d)
      !!----------------------------------------------------------------------
      !!
      CHARACTER (len=32) :: clname
      INTEGER            :: jn
#if defined key_trc_diaadd
      ! definition of additional diagnostic as a structure
      TYPE DIAG
         CHARACTER(len = 20)  :: snamedia   !: short name
         CHARACTER(len = 80 ) :: lnamedia   !: long name
         CHARACTER(len = 20 ) :: unitdia    !: unit
      END TYPE DIAG

#endif
      !
      NAMELIST/natbio/ xxi,xaln,xald,jphy,xvpn,xvpd,          &
      &    xsin0,xnsi0,xuif,                                  &
      &    xthetam,xthetamd,xnln,xnld,xsld,xfln,xfld,         &
      &  xgmi,xgme,xkmi,xkme,xphi,xbetan,xbetac,xkc,          &
      &    xpmipn,xpmid,xpmepn,xpmepd,xpmezmi,xpmed,          &
      &  xmetapn,xmetapd,xmetazmi,xmetazme,                   &
      &  jmpn,xmpn,xkphn,jmpd,xmpd,xkphd,jmzmi,xmzmi,xkzmi,   &
      &    jmzme,xmzme,xkzme,jmd,xmd,xmdc,                    &
      &  xthetapn,xthetapd,xthetazmi,xthetazme,xthetad,       &
      &    xrfn,xrsn,vsed,xhr,                                &
      &  jiron,xfe_mass,xfe_sol,xfe_sed,xLgT,xk_FeL,xk_sc_Fe, &
      &  xfdfrac1,xfdfrac2,xcaco3a,xcaco3b,xmassc,xmassca,    &
      &    xmasssi,xprotca,xprotsi,xfastc,xfastca,xfastsi,    &
      &  xsdiss,                                              &
      &  vsed,xhr,                                            &
      &  sedlam,sedlostpoc,jpkb
      NAMELIST/natopt/xkg0,xkr0,xkgp,xkrp,xlg,xlr,rpig
#if defined key_trc_diaadd && ! defined key_iomput
      NAMELIST/nammeddia/ ctrc2d,ctrc2l,ctrc2u,           &!additional diagnostics
      &                   ctrc3d,ctrc3l,ctrc3u,nwritedia   !additional diagnostics
#endif

      clname ='namelist.trc.sms'
      CALL ctl_opn( numnat, clname, 'OLD', 'FORMATTED', 'SEQUENTIAL',   &
         &           1, numout, .FALSE., 1 )

      ! 1.4 namelist natbio : biological parameters
      ! -------------------------------------------
      
      xxi       = 0.
      xaln      = 0.
      xald      = 0.
      jphy      = 0
      xvpn      = 0.
      xvpd      = 0.
      xthetam   = 0.
      xthetamd  = 0.
!!
      xsin0     = 0.
      xnsi0     = 0.
      xuif      = 0.
!!
      xnln      = 0.
      xnld      = 0.
      xsld      = 0.
      xfln      = 0.
      xfld      = 0.
!!
      xgmi      = 0.
      xgme      = 0.
      xkmi      = 0.
      xkme      = 0.
      xphi	= 0.
      xbetan    = 0.
      xbetac    = 0.
      xkc       = 0.
      xpmipn    = 0.
      xpmid     = 0.
      xpmepn    = 0.
      xpmepd    = 0.
      xpmezmi   = 0.
      xpmed     = 0.
!!
      xmetapn   = 0.
      xmetapd   = 0.
      xmetazmi  = 0.
      xmetazme  = 0.
!!
      jmpn      = 0
      xmpn      = 0.
      xkphn     = 0.
      jmpd      = 0
      xmpd      = 0.
      xkphd     = 0.
      jmzmi     = 0
      xmzmi     = 0.
      xkzmi     = 0.
      jmzme     = 0
      xmzme     = 0.
      xkzme     = 0.
!!
      jmd       = 0
      xmd       = 0.
      xmdc      = 0.
!!
      xthetapn  = 0.
      xthetapd  = 0.
      xthetazmi = 0.
      xthetazme = 0.
      xthetad   = 0.
      xrfn      = 0.
      xrsn      = 0.  !: (NOT USED HERE; RETAINED FOR LOBSTER)
!!
      jiron     = 0
      xfe_mass  = 0.
      xfe_sol   = 0.
      xfe_sed   = 0.
      xLgT      = 0.
      xk_FeL	= 0.
      xk_sc_Fe  = 0.
!!
      xfdfrac1	= 0.
      xfdfrac2	= 0.
      xcaco3a	= 0.
      xcaco3b	= 0.
      xmassc	= 0.
      xmassca	= 0.
      xmasssi	= 0.
      xprotca	= 0.
      xprotsi	= 0.
      xfastc	= 0.
      xfastca	= 0.
      xfastsi	= 0.
!!
      xsdiss	= 0.
!!
      vsed      = 0.
      xhr       = 0.
!!
      sedlam	= 0.
      sedlostpoc= 0.
      jpkb	= 0.
            
      READ(numnat,natbio)

!! Primary production and chl related quantities
!!       xxi       :  conversion factor from gC to mmolN 
!!       xaln      :  Chl-a specific initial slope of P-I curve for non-diatoms 
!!       xald      :  Chl-a specific initial slope of P-I curve for diatoms
!!       jphy      :  phytoplankton T-dependent growth switch
!!       xvpn      :  maximum growth rate for non-diatoms
!!       xvpd      :  maximum growth rate for diatoms
!!       xthetam   :  maximum Chl to C ratio for non-diatoms      
!!       xthetamd  :  maximum Chl to C ratio for diatoms      
!!
!! Diatom silicon parameters
!!       xsin0     :  minimum diatom Si:N ratio
!!       xnsi0     :  minimum diatom N:Si ratio
!!       xuif      :  hypothetical growth ratio at infinite Si:N ratio
!!
!! Nutrient limitation
!!       xnln      :  half-sat constant for DIN uptake by non-diatoms 
!!       xnld      :  half-sat constant for DIN uptake by diatoms 
!!       xsl       :  half-sat constant for Si uptake by diatoms 
!!       xfld      :  half-sat constant for Fe uptake by diatoms  
!!       xfln      :  half-sat constant for Fe uptake by non-datoms 
!!
!! Grazing
!!       xgmi      :  microzoo maximum growth rate 
!!       xgme      :  mesozoo maximum growth rate 
!!       xkmi      :  microzoo grazing half-sat parameter
!!       xkme      :  mesozoo grazing half-sat parameter
!!       xphi      :  micro/mesozoo grazing inefficiency
!!       xbetan    :  micro/mesozoo N assimilation efficiency
!!       xbetac    :  micro/mesozoo C assimilation efficiency
!!       xkc       :  micro/mesozoo net C growth efficiency
!!       xpmipn    :  grazing preference of microzoo for non-diatoms
!!       xpmid     :  grazing preference of microzoo for diatoms
!!       xpmepn    :  grazing preference of mesozoo for non-diatoms 
!!       xpmepd    :  grazing preference of mesozoo for diatoms
!!       xpmezmi   :  grazing preference of mesozoo for microzoo
!!       xpmed     :  grazing preference of mesozoo for detritus
!!
!! Metabolic losses
!!       xmetapn   :  non-diatom metabolic loss rate
!!       xmetapd   :  diatom     metabolic loss rate
!!       xmetazmi  :  microzoo   metabolic loss rate
!!       xmetazme  :  mesozoo    metabolic loss rate
!!
!! Mortality/Remineralisation
!!       jmpn      :  non-diatom mortality functional form
!!       xmpn      :  non-diatom mortality rate
!!       xkphn     :  non-diatom mortality half-sat constant
!!       jmpd      :  diatom     mortality functional form
!!       xmpd      :  diatom mortality rate
!!       xkphd     :  diatom mortality half-sat constant
!!       jmzmi     :  microzoo   mortality functional form
!!       xmzmi     :  microzoo mortality rate
!!       xkzmi     :  microzoo mortality half-sat constant
!!       jmzme     :  mesozoo    mortality functional form
!!       xmzme     :  mesozoo mortality rate
!!       xkzme     :  mesozoo mortality half-sat constant
!!
!! Remineralisation
!!       jmd       :  detritus T-dependent remineralisation switch
!!       xmd       :  detrital nitrogen remineralisation rate 
!!       xmdc      :  detrital carbon remineralisation rate 
!!
!! Stochiometric ratios
!!       xthetapn  :  non-diatom C:N ratio
!!       xthetapd  :  diatom C:N ratio
!!       xthetazmi :  microzoo C:N ratio
!!       xthetazme :  mesozoo C:N ratio
!!       xthetad   :  detritus C:N ratio
!!       xrfn      :  phytoplankton Fe:N ratio
!!	 xrsn      :  diatom Si:N ratio (*NOT* used)
!!
!! Iron parameters
!!       jiron     :  iron scavenging submodel switch
!!       xfe_mass  :  iron atomic mass
!!	 xfe_sol   :  aeolian iron solubility
!!	 xfe_sed   :  sediment iron input
!!	 xLgT	   :  total ligand concentration (umol/m3)
!!	 xk_FeL	   :  dissociation constant for (Fe + L)
!!	 xk_sc_Fe  :  scavenging rate of "free" iron
!!	 
!! Fast-sinking detritus parameters
!!       xfdfrac1  :  fast-sinking fraction of diatom nat. mort. losses
!!       xfdfrac2  :  fast-sinking fraction of diatom grazing losses
!!       xcaco3a   :  polar (high latitude) CaCO3 fraction
!!       xcaco3b   :  equatorial (low latitude) CaCO3 fraction
!!       xmassc    :  organic C mass:mole ratio, C106 H175 O40 N16 P1
!!       xmassca   :  calcium carbonate mass:mole ratio, CaCO3
!!       xmasssi   :  biogenic silicon mass:mole ratio, (H2SiO3)n
!!       xprotca   :  calcium carbonate protection ratio
!!       xprotsi   :  biogenic silicon protection ratio
!!       xfastc    :  organic C remineralisation length scale
!!       xfastca   :  calcium carbonate dissolution length scale
!!       xfastsi   :  biogenic silicon dissolution length scale
!!
!! Miscellaneous
!!       xsdiss    :  diatom frustule dissolution rate
!!
!! Gravitational sinking      
!!       vsed      :  detritus gravitational sinking rate 
!!       xhr       :  coeff for Martin's remineralisation profile
!!
!! Additional parameters
!!       sedlam    :  time coeff of POC in sediments
!!      sedlostpoc :  sediment geol loss for POC
!!       jpkb      :  vertical layer for diagnostic of the vertical flux 
!!                    NOTE that in LOBSTER it is a first vertical layers where 
!!                    biology is active  

      IF(lwp) THEN
          WRITE(numout,*) 'natbio'
          WRITE(numout,*) ' '
!!
!! Primary production and chl related quantities
          WRITE(numout,*) '=== Primary production'
          WRITE(numout,*)     &
          &   ' conversion factor from gC to mmolN,                        xxi       =', xxi
          WRITE(numout,*)     &
          &   ' Chl-a specific initial slope of P-I curve for non-diatoms, xaln      = ', xaln
          WRITE(numout,*)     &
          &   ' Chl-a specific initial slope of P-I curve for diatoms,     xald      = ', xald
	  if (jphy.eq.1) then
             WRITE(numout,*) &
             &   ' phytoplankton growth is *temperature-dependent*            jphy      = 1'
          else
             WRITE(numout,*) &
             &   ' phytoplankton growth is *temperature-independent*          jphy      = 0'
          endif
          WRITE(numout,*)     &
          &   ' maximum growth rate for non-diatoms,                       xvpn      = ', xvpn
          WRITE(numout,*)     &
          &   ' maximum growth rate for diatoms,                           xvpn      = ', xvpd
          WRITE(numout,*)     &
          &   ' maximum Chl to C ratio for non-diatoms,                    xthetam   = ', xthetam
          WRITE(numout,*)     &
          &   ' maximum Chl to C ratio for diatoms,                        xthetamd  = ', xthetamd
!!
!! Diatom silicon parameters
          WRITE(numout,*) '=== Diatom silicon parameters'
          WRITE(numout,*)     &
          &   ' minimum diatom Si:N ratio,                                 xsin0     = ', xsin0
          WRITE(numout,*)     &
          &   ' minimum diatom N:Si ratio,                                 xnsi0     = ', xnsi0
          WRITE(numout,*)     &
          &   ' hypothetical growth ratio at infinite Si:N ratio,          xuif      = ', xuif
!!
!! Nutrient limitation
          WRITE(numout,*) '=== Nutrient limitation'
          WRITE(numout,*)     &
          &   ' half-sat constant for DIN uptake by non-diatoms,           xnln      = ', xnln
          WRITE(numout,*)     &
          &   ' half-sat constant for DIN uptake by diatoms,               xnld      = ', xnld
          WRITE(numout,*)     &
          &   ' half-sat constant for Si uptake by diatoms,                xsld      = ', xsld
          WRITE(numout,*)     &
          &   ' half-sat constant for Fe uptake by non-diatoms,            xfln      = ', xfln
          WRITE(numout,*)     &
          &   ' half-sat constant for Fe uptake by diatoms,                xfld      = ', xfld
!!
!! Grazing
          WRITE(numout,*) '=== Zooplankton grazing'
          WRITE(numout,*)     &
          &   ' microzoo maximum growth rate,                              xgmi      = ', xgmi
          WRITE(numout,*)     &
          &   ' mesozoo maximum growth rate,                               xgme      = ', xgme
          WRITE(numout,*)     &
          &   ' microzoo grazing half-sat parameter,                       xkmi      = ', xkmi
          WRITE(numout,*)     &
          &   ' mesozoo grazing half-sat parameter,                        xkme      = ', xkme
          WRITE(numout,*)     &
          &   ' micro/mesozoo grazing inefficiency,                        xphi      = ', xphi
          WRITE(numout,*)     &
          &   ' micro/mesozoo N assimilation efficiency,                   xbetan    = ', xbetan
          WRITE(numout,*)     &
          &   ' micro/mesozoo C assimilation efficiency,                   xbetac    = ', xbetan
          WRITE(numout,*)     &
          &   ' micro/mesozoo net C growth efficiency,                     xkc       = ', xkc
          WRITE(numout,*)     &
          &   ' grazing preference of microzoo for non-diatoms,            xpmipn    = ', xpmipn
          WRITE(numout,*)     &
          &   ' grazing preference of microzoo for detritus,               xpmid     = ', xpmid
          WRITE(numout,*)     &
          &   ' grazing preference of mesozoo for non-diatoms,             xpmepn    = ', xpmepn
          WRITE(numout,*)     &
          &   ' grazing preference of mesozoo for diatoms,                 xpmepd    = ', xpmepd
          WRITE(numout,*)     &
          &   ' grazing preference of mesozoo for microzoo,                xpmezmi   = ', xpmezmi
          WRITE(numout,*)     &
          &   ' grazing preference of mesozoo for detritus,                xpmed     = ', xpmed
!!
!! Metabolic losses
          WRITE(numout,*) '=== Metabolic losses'
          WRITE(numout,*)     &
          &   ' non-diatom metabolic loss rate,                            xmetapn   = ', xmetapn
          WRITE(numout,*)     &
          &   ' diatom     metabolic loss rate,                            xmetapd   = ', xmetapd
          WRITE(numout,*)     &
          &   ' microzoo   metabolic loss rate,                            xmetazmi  = ', xmetazmi
          WRITE(numout,*)     &
          &   ' mesozoo    metabolic loss rate,                            xmetazme  = ', xmetazme
!!
!! Mortality losses
          WRITE(numout,*) '=== Mortality losses'
          WRITE(numout,*)     &
          &   ' non-diatom mortality functional form,                      jmpn      = ', jmpn
          WRITE(numout,*)     &
          &   ' non-diatom mortality rate,                                 xmpn      = ', xmpn
          WRITE(numout,*)     &
          &   ' non-diatom mortality half-sat constant                     xkphn     = ', xkphn
          WRITE(numout,*)     &
          &   ' diatom mortality functional form,                          jmpd      = ', jmpd
          WRITE(numout,*)     &
          &   ' diatom mortality rate,                                     xmpd      = ', xmpd
          WRITE(numout,*)     &
          &   ' diatom mortality half-sat constant                         xkphd     = ', xkphd
          WRITE(numout,*)     &
          &   ' microzoo mortality functional form,                        jmzmi     = ', jmzmi
          WRITE(numout,*)     &
          &   ' microzoo mortality rate,                                   xmzmi     = ', xmzmi
          WRITE(numout,*)     &
          &   ' microzoo mortality half-sat constant,                      xkzmi     = ', xkzmi
          WRITE(numout,*)     &
          &   ' mesozoo mortality functional form,                         jmzme     = ', jmzme
          WRITE(numout,*)     &
          &   ' mesozoo mortality rate,                                    xmzme     = ', xmzme
          WRITE(numout,*)     &
          &   ' mesozoo mortality half-sat constant,                       xkzme     = ', xkzme
!!
!! Remineralisation
          WRITE(numout,*) '=== Remineralisation'
	  if (jmd.eq.1) then
             WRITE(numout,*) &
             &   ' detritus remineralisation is *temperature-dependent*       jmd       = 1'
          else
             WRITE(numout,*) &
             &   ' detritus remineralisation is *temperature-independent*     jmd       = 0'
          endif
          WRITE(numout,*)     &
          &   ' detrital nitrogen remineralisation rate,                   xmd       = ', xmd
          WRITE(numout,*)     &
          &   ' detrital carbon remineralisation rate,                     xmdc      = ', xmdc
!!
!! Stochiometric ratios
          WRITE(numout,*) '=== Stoichiometric ratios'
          WRITE(numout,*)     &
          &   ' non-diatom C:N ratio,                                      xthetapn  = ', xthetapn
          WRITE(numout,*)     &
          &   ' diatom C:N ratio,                                          xthetapd  = ', xthetapd
          WRITE(numout,*)     &
          &   ' microzoo C:N ratio,                                        xthetazmi = ', xthetazmi
          WRITE(numout,*)     &
          &   ' mesozoo C:N ratio,                                         xthetazme = ', xthetazme
          WRITE(numout,*)     &
          &   ' detritus C:N ratio,                                        xthetad   = ', xthetad
          WRITE(numout,*)     &
          &   ' phytoplankton Fe:N ratio,                                  xrfn      = ', xrfn
          WRITE(numout,*)     &
          &   ' diatom Si:N ratio,                                         xrsn      = ', xrsn
!!	  
!! Iron parameters
          WRITE(numout,*) '=== Iron parameters'
          if (jiron.eq.1) then
             WRITE(numout,*)     &
             &   ' Dutkiewicz et al. (2005) iron scavenging                   jiron     = ', jiron
          elseif (jiron.eq.2) then
             WRITE(numout,*)     &
             &   ' Moore et al. (2004) iron scavenging                        jiron     = ', jiron
          elseif (jiron.eq.3) then
             WRITE(numout,*)     &
             &   ' Moore et al. (2008) iron scavenging                        jiron     = ', jiron
          elseif (jiron.eq.4) then
             WRITE(numout,*)     &
             &   ' Galbraith et al. (2010) iron scavenging                    jiron     = ', jiron
          else
             WRITE(numout,*)     &
             &   ' There is **no** iron scavenging                            jiron     = ', jiron
          endif
          WRITE(numout,*)     &
          &   ' iron atomic mass,                                          xfe_mass  = ', xfe_mass
          WRITE(numout,*)     &
          &   ' aeolian iron solubility,                                   xfe_sol   = ', xfe_sol
          WRITE(numout,*)     &
          &   ' sediment iron input,                                       xfe_sed   = ', xfe_sed
          WRITE(numout,*)     &
          &   ' total ligand concentration (umol/m3),                      xLgT      = ', xLgT
          WRITE(numout,*)     &
          &   ' dissociation constant for (Fe + L),                        xk_FeL    = ', xk_FeL
          WRITE(numout,*)     &
          &   ' scavenging rate for free iron,                             xk_sc_Fe  = ', xk_sc_Fe
!!
!! Fast-sinking detritus parameters
          WRITE(numout,*) '=== Fast-sinking detritus'
          WRITE(numout,*)     &
          &   ' fast-sinking fraction of diatom nat. mort. losses,         xfdfrac1  = ', xfdfrac1
          WRITE(numout,*)     &
          &   ' fast-sinking fraction of diatom grazing losses,            xfdfrac2  = ', xfdfrac2
          WRITE(numout,*)     &
          &   ' polar (high latitude) CaCO3 fraction,                      xcaco3a   = ', xcaco3a
          WRITE(numout,*)     &
          &   ' equatorial (low latitude) CaCO3 fraction,                  xcaco3b   = ', xcaco3b
          WRITE(numout,*)     &
          &   ' organic C mass:mole ratio, C106 H175 O40 N16 P1,           xmassc    = ', xmassc
          WRITE(numout,*)     &
          &   ' calcium carbonate mass:mole ratio, CaCO3,                  xmassca   = ', xmassca
          WRITE(numout,*)     &
          &   ' biogenic silicon mass:mole ratio, (H2SiO3)n,               xmasssi   = ', xmasssi
          WRITE(numout,*)     &
          &   ' calcium carbonate protection ratio,                        xprotca   = ', xprotca
          WRITE(numout,*)     &
          &   ' biogenic silicon protection ratio,                         xprotsi   = ', xprotsi
          WRITE(numout,*)     &
          &   ' organic C remineralisation length scale,                   xfastc    = ', xfastc
          WRITE(numout,*)     &
          &   ' calcium carbonate dissolution length scale,                xfastca   = ', xfastca
          WRITE(numout,*)     &
          &   ' biogenic silicon dissolution length scale,                 xfastsi   = ', xfastsi
!!
!! Miscellaneous
          WRITE(numout,*) '=== Miscellaneous'
          WRITE(numout,*)     &
          &   ' diatom frustule dissolution rate,                          xsdiss    = ', xsdiss
!!
!! Gravitational sinking      
          WRITE(numout,*) '=== Gravitational sinking'
          WRITE(numout,*)     &
          &   ' detritus gravitational sinking rate,                       vsed      = ', vsed
          WRITE(numout,*)     & 
          &   ' coefficient for Martin et al. (1987) remineralisation,     xhr       = ', xhr
!!
!! Non-Medusa parameters
          WRITE(numout,*) '=== Non-Medusa paramters'
          WRITE(numout,*)     & 
          &   ' time coeff of POC in sediments,                            sedlam    = ', sedlam
          WRITE(numout,*)     &
          &   ' Sediment geol loss for POC,                               sedlostpoc = ', sedlostpoc
          WRITE(numout,*)     &
          &   ' Vert layer for diagnostic of vertical flux,                jpkp      = ', jpkb
      ENDIF

      ! 1.5 namelist natopt : parameters for optic
      ! ------------------------------------------

      xkg0  = 0.
      xkr0  = 0.
      xkgp  = 0.
      xkrp  = 0.
      xlg   = 0.
      xlr   = 0.
      rpig  = 0.

      READ(numnat,natopt)

      IF(lwp) THEN
         WRITE(numout,*) 'natopt'
         WRITE(numout,*) ' '
         WRITE(numout,*) ' green   water absorption coeff  xkg0  = ',xkg0
         WRITE(numout,*) ' red water absorption coeff      xkr0  = ',xkr0
         WRITE(numout,*) ' pigment red absorption coeff    xkrp  = ',xkrp
         WRITE(numout,*) ' pigment green absorption coeff  xkgp  = ',xkgp
         WRITE(numout,*) ' green chl exposant              xlg   = ',xlg
         WRITE(numout,*) ' red   chl exposant              xlr   = ',xlr
         WRITE(numout,*) ' chla/chla+phea ratio            rpig  = ',rpig
         WRITE(numout,*) ' '

      ENDIF

#if defined key_trc_diaadd && ! defined key_iomput

      ! Namelist nammeddia
      ! -------------------
      nwritedia = 10                   ! default values

      DO jn = jp_msa0_2d, jp_msa1_2d
         WRITE(ctrc2d(jn),'("2D_",I1)') jn                      ! short name
         WRITE(ctrc2l(jn),'("2D DIAGNOSTIC NUMBER ",I2)') jn    ! long name
         ctrc2u(jn) = ' '                                       ! units
      END DO
      !                                 ! 3D output arrays
      DO jn = jp_msa0_3d, jp_msa1_3d
         WRITE(ctrc3d(jn),'("3D_",I1)') jn                      ! short name
         WRITE(ctrc3l(jn),'("3D DIAGNOSTIC NUMBER ",I2)') jn    ! long name
         ctrc3u(jn) = ' '                                       ! units
      END DO

!      REWIND( numnat )               ! read natrtd
      READ  ( numnat, nammeddia) 

      IF(lwp) write(*,*) 'TRCLSM', jp_msa0_2d, jp_msa1_2d
      IF(lwp) write(*,*) 'TRCLSM', jp_msa0_3d, jp_msa1_3d
            

      IF(lwp) THEN                   ! control print
         WRITE(numout,*)
         WRITE(numout,*) ' Namelist : nammeddia'
         WRITE(numout,*) '    frequency of outputs for additional arrays nwritedia = ', nwritedia
         DO jn = jp_msa0_3d, jp_msa1_3d
            WRITE(numout,*) '   3d output field No : ',jn
            WRITE(numout,*) '   short name         : ', TRIM(ctrc3d(jn))
            WRITE(numout,*) '   long name          : ', TRIM(ctrc3l(jn))
            WRITE(numout,*) '   unit               : ', TRIM(ctrc3u(jn))
            WRITE(numout,*) ' '
         END DO
         
         DO jn = jp_msa0_2d, jp_msa1_2d
            WRITE(numout,*) '   2d output field No : ',jn
            WRITE(numout,*) '   short name         : ', TRIM(ctrc2d(jn))
            WRITE(numout,*) '   long name          : ', TRIM(ctrc2l(jn))
            WRITE(numout,*) '   unit               : ', TRIM(ctrc2u(jn))
            WRITE(numout,*) ' '
         END DO
      ENDIF
#endif

#if defined key_trc_diabio && ! defined key_iomput
      INTEGER :: ji
      NAMELIST/natdbi/ctrbio,ctrbil,ctrbiu,nwritebio
#endif
   END SUBROUTINE trc_lsm_medusa
   
#else
   !!----------------------------------------------------------------------
   !!  Dummy module :                                             No MEDUSA
   !!----------------------------------------------------------------------
CONTAINS
   SUBROUTINE trc_lsm_medusa                      ! Empty routine
   END  SUBROUTINE  trc_lsm_medusa
#endif  

   !!======================================================================
END MODULE trclsm_medusa
