MODULE trcini_medusa
   !!======================================================================
   !!                         ***  MODULE trcini_medusa  ***
   !! TOP :   initialisation of the MEDUSA tracers
   !!======================================================================
   !! History :   2.0  !  2007-12  (C. Ethe, G. Madec) Original code
   !!              -   !  2008-08  (K. Popova) adaptation for MEDUSA
   !!              -   !  2008-11  (A. Yool) continuing adaptation for MEDUSA
   !!              -   !  2010-03  (A. Yool) updated for branch inclusion
   !!----------------------------------------------------------------------
#if defined key_medusa
   !!----------------------------------------------------------------------
   !!   'key_medusa'                                         MEDUSA tracers
   !!----------------------------------------------------------------------
   !! trc_ini_medusa   : MEDUSA model initialisation
   !!----------------------------------------------------------------------
   USE par_trc         ! TOP parameters
   USE oce_trc
   USE trc
   USE in_out_manager
   USE par_medusa

   IMPLICIT NONE
   PRIVATE

   PUBLIC   trc_ini_medusa   ! called by trcini.F90 module

   !!----------------------------------------------------------------------
   !! NEMO/TOP 2.0 , LOCEAN-IPSL (2007) 
   !! $Id: trcini_medusa.F90 1162 2008-07-02 09:33:33Z cetlod $ 
   !! Software governed by the CeCILL licence (modipsl/doc/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------

CONTAINS

   SUBROUTINE trc_ini_medusa
      !!----------------------------------------------------------------------
      !!                     ***  trc_ini_medusa  ***  
      !!
      !! ** Purpose :   initialization for MEDUSA model
      !!
      !! ** Method  : - Read the namcfc namelist and check the parameter values
      !!----------------------------------------------------------------------
      !!----------------------------------------------------------------------

      !! vertical array index
      INTEGER  ::    jk

      IF(lwp) WRITE(numout,*)
      IF(lwp) WRITE(numout,*) ' trc_ini_medusa: initialisation of MEDUSA model'
      IF(lwp) WRITE(numout,*) ' ~~~~~~~~~~~~~~'

      !!----------------------------------------------------------------------
      !! State variable initial conditions (all mmol / m3)
      !!----------------------------------------------------------------------
      !!     
      !! biological and detrital components are initialised to nominal
      !! values above 100 m depth and zero below; the latter condition
      !! is applied since non-linear loss processes allow significant
      !! concentrations of these components to persist at depth
      DO jk = 1,13
         !! non-diatom chlorophyll         (nominal)
         trn(:,:,jk,jpchn) = 0.01
         !!
         !! diatom chlorophyll             (nominal)
         trn(:,:,jk,jpchd) = 0.01
         !!
         !! non-diatom                     (nominal)
         trn(:,:,jk,jpphn) = 0.01
         !!
         !! diatom                         (nominal)
         trn(:,:,jk,jpphd) = 0.01
         !!
         !! diatom silicon                 (nominal)
         trn(:,:,jk,jppds) = 0.01
         !!
         !! microzooplankton               (nominal)
         trn(:,:,jk,jpzmi) = 0.01
         !!
         !! mesozooplankton                (nominal)
         trn(:,:,jk,jpzme) = 0.01
         !!
         !! detrital nitrogen              (nominal)
         trn(:,:,jk,jpdet) = 0.01
	 !!
         !! AXY (26/11/08): implicit detrital carbon change
	 !! detrital carbon                (nominal)
	 !! trn(:,:,jk,jpdtc) = 0.06625
      ENDDO
      DO jk = 14,jpk
         trn(:,:,jk,jpchn) = 0.
         trn(:,:,jk,jpchd) = 0.
         trn(:,:,jk,jpphn) = 0.
         trn(:,:,jk,jpphd) = 0.
         trn(:,:,jk,jppds) = 0.
         trn(:,:,jk,jpzmi) = 0.
         trn(:,:,jk,jpzme) = 0.
         trn(:,:,jk,jpdet) = 0.
         !! AXY (26/11/08): implicit detrital carbon change
	 !! trn(:,:,jk,jpdtc) = 0.
      ENDDO
      !!
      !! dissolved inorganic nitrogen   (nominal surface value; typically initialised from climatology)
      trn(:,:,:,jpdin) = 10.
      !!
      !! dissolved silicic acid         (nominal surface value; typically initialised from climatology)
      trn(:,:,:,jpsil) = 8.
      !!
      !! dissolved "total" iron         (nominal surface value; typically initialised from climatology)
      trn(:,:,:,jpfer) = 1.0e-4 !! = 0.1 umol Fe / m3
     
   END SUBROUTINE trc_ini_medusa
   
#else
   !!----------------------------------------------------------------------
   !!   Dummy module                                        No MEDUSA model
   !!----------------------------------------------------------------------
CONTAINS
   SUBROUTINE trc_ini_medusa             ! Empty routine
   END SUBROUTINE trc_ini_medusa
#endif

   !!======================================================================
END MODULE trcini_medusa
