MODULE sms_medusa 
   !!----------------------------------------------------------------------
   !!                     ***  sms_medusa.F90  ***  
   !! TOP :   MEDUSA  Source Minus Sink variables
   !!----------------------------------------------------------------------
   !! History :    -   !  1999-09 (M. Levy)  original code
   !!              -   !  2000-12 (O. Aumont, E. Kestenare)  add sediment 
   !!             1.0  !  2005-10 (C. Ethe) F90
   !!             1.0  !  2005-03  (A-S Kremeur) add fphylab, fzoolab, fdetlab, fdbod
   !!              -   !  2005-06  (A-S Kremeur) add sedpocb, sedpocn, sedpoca
   !!             2.0  !  2007-04  (C. Deltel, G. Madec)  Free form and modules
   !!                  !  2008-08  (K. Popova) adaptation for MEDUSA
   !!                  !  2008-11  (A. Yool) continuing adaptation for MEDUSA
   !!                  !  2010-03  (A. Yool) updated for branch inclusion
   !!----------------------------------------------------------------------

#if defined key_medusa
   !!----------------------------------------------------------------------
   !!   'key_medusa'                                         MEDUSA model
   !!----------------------------------------------------------------------
   USE par_oce
   USE par_trc

   IMPLICIT NONE
   PUBLIC

   !!----------------------------------------------------------------------
   !! NEMO/TOP 1.0 , LOCEAN-IPSL (2005) 
   !! $Id: sms_medusa.F90 1152 2008-06-26 14:11:13Z rblod $ 
   !! Software governed by the CeCILL licence (modipsl/doc/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------

!!----------------------------------------------------------------------
!! Biological parameters
!!----------------------------------------------------------------------
!!
!! Primary production and chl related quantities
   REAL(wp) ::  xxi       !:  conversion factor from gC to mmolN 
   REAL(wp) ::  xaln      !:  Chl-a specific initial slope of P-I curve for non-diatoms 
   REAL(wp) ::  xald      !:  Chl-a specific initial slope of P-I curve for diatoms
   INTEGER  ::  jphy      !:  phytoplankton T-dependent growth switch
   REAL(wp) ::  xvpn      !:  maximum growth rate for non-diatoms
   REAL(wp) ::  xvpd      !:  maximum growth rate for diatoms
   REAL(wp) ::  xthetam   !:  maximum Chl to C ratio for non-diatoms      
   REAL(wp) ::  xthetamd  !:  maximum Chl to C ratio for diatoms    
!!
!! Diatom silicon parameters
   REAL(wp) ::  xsin0     !:  minimum diatom Si:N ratio
   REAL(wp) ::  xnsi0     !:  minimum diatom N:Si ratio
   REAL(wp) ::  xuif      !:  hypothetical growth ratio at infinite Si:N ratio
!!
!! Nutrient limitation
   REAL(wp) ::  xnln      !:  half-sat constant for DIN uptake by non-diatoms 
   REAL(wp) ::  xnld      !:  half-sat constant for DIN uptake by diatoms 
   REAL(wp) ::  xsld      !:  half-sat constant for Si uptake by diatoms 
   REAL(wp) ::  xfln      !:  half-sat constant for Fe uptake by non-diatoms 
   REAL(wp) ::  xfld      !:  half-sat constant for Fe uptake by diatoms  
!!
!! Grazing
   REAL(wp) ::  xgmi      !:  microzoo maximum growth rate 
   REAL(wp) ::  xgme      !:  mesozoo maximum growth rate 
   REAL(wp) ::  xkmi      !:  microzoo grazing half-sat parameter
   REAL(wp) ::  xkme      !:  mesozoo grazing half-sat parameter
   REAL(wp) ::  xphi      !:  micro/mesozoo grazing inefficiency
   REAL(wp) ::  xbetan    !:  micro/mesozoo N assimilation efficiency
   REAL(wp) ::  xbetac    !:  micro/mesozoo C assimilation efficiency
   REAL(wp) ::  xkc       !:  micro/mesozoo net C growth efficiency
   REAL(wp) ::  xpmipn    !:  grazing preference of microzoo for non-diatoms
   REAL(wp) ::  xpmid     !:  grazing preference of microzoo for diatoms
   REAL(wp) ::  xpmepn    !:  grazing preference of mesozoo for non-diatoms 
   REAL(wp) ::  xpmepd    !:  grazing preference of mesozoo for diatoms
   REAL(wp) ::  xpmezmi   !:  grazing preference of mesozoo for microzoo
   REAL(wp) ::  xpmed     !:  grazing preference of mesozoo for detritus
!!
!! Metabolic losses
   REAL(wp) ::  xmetapn   !:  non-diatom metabolic loss rate
   REAL(wp) ::  xmetapd   !:  diatom     metabolic loss rate
   REAL(wp) ::  xmetazmi  !:  microzoo   metabolic loss rate
   REAL(wp) ::  xmetazme  !:  mesozoo    metabolic loss rate
!!
!! Mortality losses
   INTEGER  ::  jmpn      !:  non-diatom mortality functional form
   REAL(wp) ::  xmpn      !:  non-diatom mortality rate
   REAL(wp) ::  xkphn     !:  non-diatom mortality half-sat constant
   INTEGER  ::  jmpd      !:  diatom     mortality functional form
   REAL(wp) ::  xmpd      !:  diatom     mortality rate
   REAL(wp) ::  xkphd     !:  diatom     mortality half-sat constant
   INTEGER  ::  jmzmi     !:  microzoo   mortality functional form
   REAL(wp) ::  xmzmi     !:  microzoo   mortality rate
   REAL(wp) ::  xkzmi     !:  microzoo   mortality half-sat constant
   INTEGER  ::  jmzme     !:  mesozoo    mortality functional form
   REAL(wp) ::  xmzme     !:  mesozoo    mortality rate
   REAL(wp) ::  xkzme     !:  mesozoo    mortality half-sat constant
!!
!! Remineralisation
   INTEGER  ::  jmd       !:  detritus T-dependent remineralisation switch
   REAL(wp) ::  xmd       !:  detrital nitrogen remineralisation rate 
   REAL(wp) ::  xmdc      !:  detrital carbon remineralisation rate 
!!
!! Stochiometric ratios
   REAL(wp) ::  xthetapn  !:  non-diatom C:N ratio
   REAL(wp) ::  xthetapd  !:  diatom C:N ratio
   REAL(wp) ::  xthetazmi !:  microzoo C:N ratio
   REAL(wp) ::  xthetazme !:  mesozoo C:N ratio
   REAL(wp) ::  xthetad   !:  detritus C:N ratio
   REAL(wp) ::  xrfn      !:  phytoplankton Fe:N ratio
   REAL(wp) ::  xrsn      !:  diatom Si:N ratio (NOT USED HERE; RETAINED FOR LOBSTER)
!!
!! Iron parameters
   INTEGER  ::  jiron     !:  iron scavenging submodel switch
   REAL(wp) ::  xfe_mass  !:  iron atomic mass
   REAL(wp) ::  xfe_sol   !:  aeolian iron solubility
   REAL(wp) ::  xfe_sed   !:  sediment iron input
   REAL(wp) ::  xLgT      !:  total ligand concentration (umol/m3)
   REAL(wp) ::  xk_FeL    !:  dissociation constant for (Fe + L)
   REAL(wp) ::  xk_sc_Fe  !:  scavenging rate of "free" iron
!!
!! Gravitational sinking      
   REAL(wp) ::  vsed      !:  detritus gravitational sinking rate 
   REAL(wp) ::  xhr       !:  coefficient for Martin et al. (1987) remineralisation
!!
!! Fast-sinking detritus parameters
   REAL(wp) ::  xfdfrac1  !:  fast-sinking fraction of diatom nat. mort. losses
   REAL(wp) ::  xfdfrac2  !:  fast-sinking fraction of diatom grazing losses
   REAL(wp) ::  xcaco3a   !:  polar (high latitude) CaCO3 fraction
   REAL(wp) ::  xcaco3b   !:  equatorial (low latitude) CaCO3 fraction
   REAL(wp) ::  xmassc    !:  organic C mass:mole ratio, C106 H175 O40 N16 P1
   REAL(wp) ::  xmassca   !:  calcium carbonate mass:mole ratio, CaCO3
   REAL(wp) ::  xmasssi   !:  biogenic silicon mass:mole ratio, (H2SiO3)n
   REAL(wp) ::  xprotca   !:  calcium carbonate protection ratio
   REAL(wp) ::  xprotsi   !:  biogenic silicon protection ratio
   REAL(wp) ::  xfastc    !:  organic C remineralisation length scale
   REAL(wp) ::  xfastca   !:  calcium carbonate dissolution length scale
   REAL(wp) ::  xfastsi   !:  biogenic silicon dissolution length scale
!!
!! Miscellaneous
   REAL(wp) ::  xsdiss    !:  diatom frustule dissolution rate
!!
!! Additional parameters
   INTEGER  ::  jpkb      !:    vertical layer for diagnostic of the vertical flux 
   REAL(wp), DIMENSION(jpk,jp_medusa) ::   remdmp   !: depth dependent damping coefficient of passive tracers 

!!----------------------------------------------------------------------
!! CCD parameter
!!----------------------------------------------------------------------
!!
   REAL(wp), DIMENSION(jpi,jpj)     ::   ocal_ccd !: CCD depth

!!----------------------------------------------------------------------
!! Dust parameters
!!----------------------------------------------------------------------
!!
   REAL(wp), DIMENSION(jpi,jpj)     ::   dust     !: dust parameter 1
   REAL(wp), DIMENSION(jpi,jpj,2)   ::   dustmo   !: dust parameter 2

!!----------------------------------------------------------------------
!! Optical parameters
!!----------------------------------------------------------------------
!!
   REAL(wp) ::   xkr0       !: water coefficient absorption in red      (NAMELIST)
   REAL(wp) ::   xkg0       !: water coefficient absorption in green    (NAMELIST)
   REAL(wp) ::   xkrp       !: pigment coefficient absorption in red    (NAMELIST)
   REAL(wp) ::   xkgp       !: pigment coefficient absorption in green  (NAMELIST)
   REAL(wp) ::   xlr        !: exposant for pigment absorption in red   (NAMELIST)
   REAL(wp) ::   xlg        !: exposant for pigment absorption in green (NAMELIST)
   REAL(wp) ::   rpig       !: chla/chla+phea ratio                     (NAMELIST)
                                                        
   INTEGER , DIMENSION(jpi,jpj)     ::   neln    !: number of levels in the euphotic layer
   REAL(wp), DIMENSION(jpi,jpj)     ::   xze     !: euphotic layer depth
   REAL(wp), DIMENSION(jpi,jpj,jpk) ::   xpar    !: par (photosynthetic available radiation)

   !! Sediment parameters                               
   !! -------------------                               
   REAL(wp) ::   sedlam       !: time coefficient of POC remineralization in sediments
   REAL(wp) ::   sedlostpoc   !: ???
   REAL(wp) ::   areacot      !: ???
                                                        
   REAL(wp), DIMENSION(jpi,jpj)     :: dminl     !: fraction of sinking POC released in sediments
   REAL(wp), DIMENSION(jpi,jpj,jpk) :: dmin3     !: fraction of sinking POC released at each level
                                                        
   REAL(wp), DIMENSION(jpi,jpj) ::     sedpocb   !: mass of POC in sediments
   REAL(wp), DIMENSION(jpi,jpj) ::     sedpocn   !: mass of POC in sediments
   REAL(wp), DIMENSION(jpi,jpj) ::     sedpoca   !: mass of POC in sediments
                                                        
   REAL(wp), DIMENSION(jpi,jpj) ::     fbodf     !: rapid sinking particles
   REAL(wp), DIMENSION(jpi,jpj) ::     fbods     !: rapid sinking particles
   REAL(wp), DIMENSION(jpi,jpj) ::     fbodn     !: rapid sinking particles
                                                        
   REAL(wp), DIMENSION(jpi,jpj,jpk) :: ffln      !: 
   REAL(wp), DIMENSION(jpi,jpj,jpk) :: fflf      !: 
   REAL(wp), DIMENSION(jpi,jpj,jpk) :: ffls      !: 


   REAL(wp), DIMENSION(jpi,jpj) ::   cmask       !: ???

#else
   !!----------------------------------------------------------------------
   !!  Empty module :                                     NO MEDUSA model 
   !!----------------------------------------------------------------------
#endif

   !!======================================================================
END MODULE sms_medusa
      
