MODULE par_medusa
   !!======================================================================
   !!                        ***  par_medusa  ***
   !! TOP :   set the MEDUSA parameters
   !!======================================================================
   !! History :   2.0  !  2007-12  (C. Ethe, G. Madec)  revised architecture
   !!              -   !  2008-08  (K. Popova) adaptation for MEDUSA
   !!              -   !  2008-11  (A. Yool) continuing adaptation for MEDUSA
   !!              -   !  2010-03  (A. Yool) updated for branch inclusion
   !!----------------------------------------------------------------------
   !! NEMO/TOP 2.0 , LOCEAN-IPSL (2007) 
   !! $Id: par_my_trc.F90 1253 2009-01-13 09:55:38Z cetlod $ 
   !! Software governed by the CeCILL licence (modipsl/doc/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------
   USE par_lobster, ONLY : jp_lobster      !: number of tracers in LOBSTER
   USE par_lobster, ONLY : jp_lobster_2d   !: number of 2D diag in LOBSTER
   USE par_lobster, ONLY : jp_lobster_3d   !: number of 3D diag in LOBSTER
   USE par_lobster, ONLY : jp_lobster_trd  !: number of biological diag in LOBSTER

   USE par_pisces , ONLY : jp_pisces       !: number of tracers in PISCES
   USE par_pisces , ONLY : jp_pisces_2d    !: number of 2D diag in PISCES
   USE par_pisces , ONLY : jp_pisces_3d    !: number of 3D diag in PISCES
   USE par_pisces , ONLY : jp_pisces_trd   !: number of biological diag in PISCES

   USE par_cfc    , ONLY : jp_cfc          !: number of tracers in CFC
   USE par_cfc    , ONLY : jp_cfc_2d       !: number of tracers in CFC
   USE par_cfc    , ONLY : jp_cfc_3d       !: number of tracers in CFC
   USE par_cfc    , ONLY : jp_cfc_trd      !: number of tracers in CFC

   USE par_c14b   , ONLY : jp_c14b         !: number of tracers in C14
   USE par_c14b   , ONLY : jp_c14b_2d      !: number of tracers in C14
   USE par_c14b   , ONLY : jp_c14b_3d      !: number of tracers in C14
   USE par_c14b   , ONLY : jp_c14b_trd     !: number of tracers in C14

   USE par_my_trc   , ONLY : jp_my_trc     !: number of tracers in my_trc
   USE par_my_trc   , ONLY : jp_my_trc_2d  !: number of tracers in my_trc
   USE par_my_trc   , ONLY : jp_my_trc_3d  !: number of tracers in my_trc
   USE par_my_trc   , ONLY : jp_my_trc_trd !: number of tracers in my_trc

   IMPLICIT NONE
   PUBLIC

   INTEGER, PUBLIC, PARAMETER ::   jp_lpc      = jp_lobster     + jp_pisces     + jp_cfc     + jp_c14b     + jp_my_trc     !: 
   INTEGER, PUBLIC, PARAMETER ::   jp_lpc_2d   = jp_lobster_2d  + jp_pisces_2d  + jp_cfc_2d  + jp_c14b_2d  + jp_my_trc_2d !:
   INTEGER, PUBLIC, PARAMETER ::   jp_lpc_3d   = jp_lobster_3d  + jp_pisces_3d  + jp_cfc_3d  + jp_c14b_3d  + jp_my_trc_3d !:
   INTEGER, PUBLIC, PARAMETER ::   jp_lpc_trd  = jp_lobster_trd + jp_pisces_trd + jp_cfc_trd + jp_c14b_trd + jp_my_trc_trd !:

#if defined key_medusa
   !!---------------------------------------------------------------------
   !!   'key_medusa'                     user defined tracers (MEDUSA)
   !!---------------------------------------------------------------------
   LOGICAL, PUBLIC, PARAMETER ::   lk_medusa     = .TRUE.   !: PTS flag 
   INTEGER, PUBLIC, PARAMETER ::   jp_medusa     =  11      !: number of PTS tracers
   INTEGER, PUBLIC, PARAMETER ::   jp_medusa_2d  =  90      !: additional 2d output arrays ('key_trc_diaadd')
   INTEGER, PUBLIC, PARAMETER ::   jp_medusa_3d  =  4       !: additional 3d output arrays ('key_trc_diaadd')
   INTEGER, PUBLIC, PARAMETER ::   jp_medusa_trd =  0       !: number of sms trends for MEDUSA

   ! assign an index in trc arrays for each PTS prognostic variables
   INTEGER, PUBLIC, PARAMETER ::   jpmsa1 = jp_lpc + 1     !: 1st MEDUSA tracer
   INTEGER, PUBLIC, PARAMETER ::   jpmsa2 = jp_lpc + 2     !: 2nd MEDUSA tracer
   INTEGER, PUBLIC, PARAMETER ::   jpmsa3 = jp_lpc + 3     !: 3rd MEDUSA tracer
   INTEGER, PUBLIC, PARAMETER ::   jpmsa4 = jp_lpc + 4     !: 4th MEDUSA tracer
   INTEGER, PUBLIC, PARAMETER ::   jpmsa5 = jp_lpc + 5     !: 5th MEDUSA tracer
   INTEGER, PUBLIC, PARAMETER ::   jpmsa6 = jp_lpc + 6     !: 6th MEDUSA tracer
   INTEGER, PUBLIC, PARAMETER ::   jpmsa7 = jp_lpc + 7     !: 7th MEDUSA tracer
   INTEGER, PUBLIC, PARAMETER ::   jpmsa8 = jp_lpc + 8     !: 8th MEDUSA tracer
   INTEGER, PUBLIC, PARAMETER ::   jpmsa9 = jp_lpc + 9     !: 9th MEDUSA tracer
   INTEGER, PUBLIC, PARAMETER ::   jpmsa10= jp_lpc + 10    !:10th MEDUSA tracer
   INTEGER, PUBLIC, PARAMETER ::   jpmsa11= jp_lpc + 11    !:11th MEDUSA tracer
   INTEGER, PUBLIC, PARAMETER ::   jpchn  = jpmsa1         !:
   INTEGER, PUBLIC, PARAMETER ::   jpchd  = jpmsa2         !:
   INTEGER, PUBLIC, PARAMETER ::   jpphn  = jpmsa3         !:
   INTEGER, PUBLIC, PARAMETER ::   jpphd  = jpmsa4         !:
   INTEGER, PUBLIC, PARAMETER ::   jpzmi  = jpmsa5         !:
   INTEGER, PUBLIC, PARAMETER ::   jpzme  = jpmsa6         !:
   INTEGER, PUBLIC, PARAMETER ::   jpdin  = jpmsa7         !:
   INTEGER, PUBLIC, PARAMETER ::   jpsil  = jpmsa8         !:
   INTEGER, PUBLIC, PARAMETER ::   jpfer  = jpmsa9         !:
   INTEGER, PUBLIC, PARAMETER ::   jpdet  = jpmsa10        !:
   INTEGER, PUBLIC, PARAMETER ::   jppds  = jpmsa11        !:


#else
   !!---------------------------------------------------------------------
   !!   Default                           No user defined tracers (MEDUSA)
   !!---------------------------------------------------------------------
   LOGICAL, PUBLIC, PARAMETER ::   lk_medusa     = .FALSE.  !: MEDUSA flag 
   INTEGER, PUBLIC, PARAMETER ::   jp_medusa     =  0       !: No MEDUSA tracers
   INTEGER, PUBLIC, PARAMETER ::   jp_medusa_2d  =  0       !: No MEDUSA additional 2d output arrays 
   INTEGER, PUBLIC, PARAMETER ::   jp_medusa_3d  =  0       !: No MEDUSA additional 3d output arrays 
   INTEGER, PUBLIC, PARAMETER ::   jp_medusa_trd =  0       !: number of sms trends for MEDUSA
#endif

   ! Starting/ending PISCES do-loop indices (N.B. no PISCES : jpl_pcs < jpf_pcs the do-loop are never done)
   INTEGER, PUBLIC, PARAMETER ::   jp_msa0     = jp_lpc     + 1              !: First index of MEDUSA passive tracers
   INTEGER, PUBLIC, PARAMETER ::   jp_msa1     = jp_lpc     + jp_medusa      !: Last  index of MEDUSA passive tracers
   INTEGER, PUBLIC, PARAMETER ::   jp_msa0_2d  = jp_lpc_2d  + 1              !: First index of MEDUSA passive tracers
   INTEGER, PUBLIC, PARAMETER ::   jp_msa1_2d  = jp_lpc_2d  + jp_medusa_2d   !: Last  index of MEDUSA passive tracers
   INTEGER, PUBLIC, PARAMETER ::   jp_msa0_3d  = jp_lpc_3d  + 1              !: First index of MEDUSA passive tracers
   INTEGER, PUBLIC, PARAMETER ::   jp_msa1_3d  = jp_lpc_3d  + jp_medusa_3d   !: Last  index of MEDUSA passive tracers
   INTEGER, PUBLIC, PARAMETER ::   jp_msa0_trd = jp_lpc_trd + 1              !: First index of MEDUSA passive tracers
   INTEGER, PUBLIC, PARAMETER ::   jp_msa1_trd = jp_lpc_trd + jp_medusa_trd  !: Last  index of MEDUSA passive tracers

   !!======================================================================
END MODULE par_medusa
