! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.1_rs5 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_Function.f90
! Time                 : Fri Apr 15 13:29:03 2011
! Working directory    : /home/sander/e2/messy_d2.40f_rs/messy/mbm/caaba/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_Function

  USE messy_mecca_kpp_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(12)*F(1)
  A(2) = RCT(2)*V(5)*F(1)
  A(3) = RCT(3)*V(7)*F(1)
  A(4) = RCT(4)*V(26)*V(28)
  A(5) = RCT(5)*V(9)*V(28)
  A(6) = RCT(6)*V(26)*V(29)
  A(7) = RCT(7)*V(28)*V(29)
  A(8) = RCT(8)*V(29)*V(29)
  A(9) = RCT(9)*V(12)*V(19)
  A(10) = 1.8e-12*V(8)*V(28)
  A(11) = RCT(11)*V(12)*F(2)
  A(12) = RCT(12)*V(26)*V(27)
  A(13) = RCT(13)*V(26)*V(30)
  A(14) = RCT(14)*V(25)*V(27)
  A(15) = RCT(15)*V(25)*V(30)
  A(16) = RCT(16)*V(6)
  A(17) = RCT(17)*V(27)*V(28)
  A(18) = RCT(18)*V(27)*V(29)
  A(19) = RCT(19)*V(28)*V(30)
  A(20) = RCT(20)*V(29)*V(30)
  A(21) = 3.5e-12*V(25)*V(29)
  A(22) = RCT(22)*V(17)*V(28)
  A(23) = RCT(23)*V(18)*V(28)
  A(24) = RCT(24)*V(15)
  A(25) = RCT(25)*V(15)*V(28)
  A(26) = RCT(26)*V(2)*V(28)
  A(27) = RCT(27)*V(22)*V(26)
  A(28) = RCT(28)*V(22)*V(29)
  A(29) = RCT(29)*V(22)*V(29)
  A(30) = RCT(30)*V(22)*V(27)
  A(31) = RCT(31)*V(22)*V(27)
  A(32) = RCT(32)*V(22)*V(30)
  A(33) = RCT(33)*V(22)*V(30)
  A(34) = 1.2e-14*V(20)*V(26)
  A(35) = 1300*V(20)
  A(36) = RCT(36)*V(21)*V(28)
  A(37) = RCT(37)*V(14)*V(21)
  A(38) = RCT(38)*V(21)*V(30)
  A(39) = 1.66e-12*V(14)*V(28)
  A(40) = RCT(40)*V(13)*V(28)
  A(41) = RCT(41)*V(21)*F(1)
  A(42) = RCT(42)*V(3)*V(28)
  A(43) = RCT(43)*V(10)*V(28)
  A(44) = RCT(44)*V(24)*V(29)
  A(45) = RCT(45)*V(24)*V(27)
  A(46) = 1.3e-12*V(24)*V(25)
  A(47) = RCT(47)*V(24)
  A(48) = RCT(48)*V(24)
  A(49) = RCT(49)*V(16)*V(28)
  A(50) = RCT(50)*V(23)*V(28)
  A(51) = RCT(51)*V(23)*V(25)
  A(52) = RCT(52)*V(11)*V(28)
  A(53) = 4e-13*V(4)*V(28)
  A(54) = RCT(54)*F(1)
  A(55) = RCT(55)*V(26)
  A(56) = RCT(56)*V(26)
  A(57) = RCT(57)*V(8)
  A(58) = RCT(58)*V(30)
  A(59) = RCT(59)*V(25)
  A(60) = RCT(60)*V(25)
  A(61) = RCT(61)*V(6)
  A(62) = RCT(62)*V(17)
  A(63) = RCT(63)*V(18)
  A(64) = RCT(64)*V(15)
  A(65) = RCT(65)*V(16)
  A(66) = RCT(66)*V(23)
  A(67) = RCT(67)*V(23)

! Aggregate function
  Vdot(1) = A(32)
  Vdot(2) = -A(26)
  Vdot(3) = -A(42)
  Vdot(4) = -A(53)
  Vdot(5) = A(1)-A(2)+A(11)+2*A(54)+A(56)+A(58)+A(59)
  Vdot(6) = A(15)-A(16)-A(61)
  Vdot(7) = -A(3)+A(5)+A(52)+A(67)
  Vdot(8) = A(8)-A(10)-A(57)
  Vdot(9) = -A(5)+A(66)
  Vdot(10) = -A(43)+0.5*A(48)
  Vdot(11) = A(50)+A(51)-A(52)+A(66)+A(67)
  Vdot(12) = -A(1)-A(9)-A(11)+A(55)
  Vdot(13) = A(37)-A(40)
  Vdot(14) = A(35)-A(37)-A(39)+A(40)
  Vdot(15) = A(20)-A(24)-A(25)-A(64)
  Vdot(16) = A(44)-A(49)-A(65)
  Vdot(17) = A(17)-A(22)+A(38)-A(62)
  Vdot(18) = A(19)-A(23)+A(51)-A(63)
  Vdot(19) = A(5)+A(7)-A(9)+A(10)+A(22)+A(23)+A(25)+A(26)+A(29)+A(31)+A(32)+A(36)+A(39)+A(40)+A(42)+A(49)+A(50)+A(53)
  Vdot(20) = A(27)+A(28)+A(33)-A(34)-A(35)
  Vdot(21) = A(29)-A(36)-A(37)-A(38)+A(39)-A(41)
  Vdot(22) = A(26)-A(27)-A(28)-A(29)-A(30)-A(31)-A(32)-A(33)+A(34)
  Vdot(23) = A(43)+A(45)+A(46)+A(47)+0.5*A(48)+0.3*A(49)-A(50)-A(51)+A(65)-A(66)-A(67)
  Vdot(24) = A(42)-A(44)-A(45)-A(46)-A(47)-A(48)+0.7*A(49)
  Vdot(25) = A(13)-A(14)-A(15)+A(16)-A(21)+A(23)-A(46)-A(51)-A(59)-A(60)+A(61)+0.333*A(64)
  Vdot(26) = A(2)-A(4)-A(6)-A(12)-A(13)-A(27)-A(34)-A(55)-A(56)
  Vdot(27) = -A(12)-A(14)-A(17)-A(18)-A(30)-A(31)+A(33)+A(36)+A(37)+A(38)+A(41)-A(45)+A(58)+A(60)+A(62)
  Vdot(28) = -A(4)-A(5)+A(6)-A(7)+2*A(9)-A(10)-A(17)+A(18)-A(19)+A(21)-A(22)-A(23)-A(25)-A(26)+A(28)+A(30)-A(36)-A(39)&
               &-A(40)-A(42)-A(43)-0.7*A(49)-A(50)-A(52)-A(53)+2*A(57)+A(62)+A(63)+0.333*A(64)+A(65)
  Vdot(29) = A(3)+A(4)-A(6)-A(7)-2*A(8)+A(10)-A(18)-A(20)-A(21)+A(24)-A(28)-A(29)+A(30)+A(41)+A(43)-A(44)+A(45)+A(46)&
               &+A(47)+A(50)+A(51)+A(53)+0.667*A(64)+A(65)+A(67)
  Vdot(30) = A(12)-A(13)+2*A(14)-A(15)+A(16)+A(18)-A(19)-A(20)+A(21)+A(22)+A(24)+A(25)-A(32)-A(33)-A(38)+A(45)+A(46)&
               &-A(58)+A(59)+A(61)+A(63)+0.667*A(64)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE messy_mecca_kpp_Function

