  ! -*- f90 -*-

  ! **************************************************************************

  ! This file contains the subroutines jval_cal and jval_cal_*. They are
  ! identical to those in MESSy-1.7, except for cosmetic changes.

  ! **************************************************************************

  SUBROUTINE jval_cal(jrow)

    INTEGER, INTENT(IN) :: jrow

    ! CALLs to individual jval_cal_* subroutines:
    IF (lp(ip_O2))       CALL jval_cal_O2(jrow)
    IF (lp(ip_O3P))      CALL jval_cal_O3P(jrow)
    IF (lp(ip_O1D))      CALL jval_cal_O1D(jrow)
    IF (lp(ip_H2O2))     CALL jval_cal_H2O2(jrow)
    IF (lp(ip_NO2))      CALL jval_cal_NO2(jrow)
    IF (lp(ip_NO2O))     CALL jval_cal_NO2O(jrow)
    IF (lp(ip_NOO2))     CALL jval_cal_NOO2(jrow)
    IF (lp(ip_N2O5))     CALL jval_cal_N2O5(jrow)
    IF (lp(ip_HNO3))     CALL jval_cal_HNO3(jrow)
    IF (lp(ip_HNO4))     CALL jval_cal_HNO4(jrow)
    IF (lp(ip_PAN))      CALL jval_cal_PAN(jrow)
    IF (lp(ip_HONO))     CALL jval_cal_HONO(jrow)
    IF (lp(ip_CH3OOH))   CALL jval_cal_CH3OOH(jrow)
    IF (lp(ip_COH2))     CALL jval_cal_COH2(jrow)
    IF (lp(ip_CHOH))     CALL jval_cal_CHOH(jrow)
    IF (lp(ip_CH3CO3H))  CALL jval_cal_CH3CO3H(jrow)
    IF (lp(ip_CH3CHO))   CALL jval_cal_CH3CHO(jrow)
    IF (lp(ip_CH3COCH3)) CALL jval_cal_CH3COCH3(jrow)
    IF (lp(ip_MGLYOX))   CALL jval_cal_MGLYOX(jrow)
    IF (lp(ip_HOCl))     CALL jval_cal_HOCl(jrow)
    IF (lp(ip_OClO))     CALL jval_cal_OClO(jrow)
    IF (lp(ip_Cl2O2))    CALL jval_cal_Cl2O2(jrow)
    IF (lp(ip_ClNO3))    CALL jval_cal_ClNO3(jrow)
    IF (lp(ip_ClNO2))    CALL jval_cal_ClNO2(jrow)
    IF (lp(ip_Cl2))      CALL jval_cal_Cl2(jrow)
    IF (lp(ip_BrO))      CALL jval_cal_BrO(jrow)
    IF (lp(ip_HOBr))     CALL jval_cal_HOBr(jrow)
    IF (lp(ip_BrCl))     CALL jval_cal_BrCl(jrow)
    IF (lp(ip_BrNO3))    CALL jval_cal_BrNO3(jrow)
    IF (lp(ip_BrNO2))    CALL jval_cal_BrNO2(jrow)
    IF (lp(ip_Br2))      CALL jval_cal_Br2(jrow)
    IF (lp(ip_CCl4))     CALL jval_cal_CCl4(jrow)
    IF (lp(ip_CH3Cl))    CALL jval_cal_CH3Cl(jrow)
    IF (lp(ip_CH3CCl3))  CALL jval_cal_CH3CCl3(jrow)
    IF (lp(ip_CFCl3))    CALL jval_cal_CFCl3(jrow)
    IF (lp(ip_CF2Cl2))   CALL jval_cal_CF2Cl2(jrow)
    IF (lp(ip_CH3Br))    CALL jval_cal_CH3Br(jrow)
    IF (lp(ip_CF2ClBr))  CALL jval_cal_CF2ClBr(jrow)
    IF (lp(ip_CF3Br))    CALL jval_cal_CF3Br(jrow)
    IF (lp(ip_CH3I))     CALL jval_cal_CH3I(jrow)
    IF (lp(ip_C3H7I))    CALL jval_cal_C3H7I(jrow)
    IF (lp(ip_CH2ClI))   CALL jval_cal_CH2ClI(jrow)
    IF (lp(ip_CH2I2))    CALL jval_cal_CH2I2(jrow)
    IF (lp(ip_IO))       CALL jval_cal_IO(jrow)
    IF (lp(ip_HOI))      CALL jval_cal_HOI(jrow)
    IF (lp(ip_I2))       CALL jval_cal_I2(jrow)
    IF (lp(ip_ICl))      CALL jval_cal_ICl(jrow)
    IF (lp(ip_IBr))      CALL jval_cal_IBr(jrow)
    IF (lp(ip_INO2))     CALL jval_cal_INO2(jrow)
    IF (lp(ip_INO3))     CALL jval_cal_INO3(jrow)
    IF (lp(ip_SO2))      CALL jval_cal_SO2(jrow)
    IF (lp(ip_SO3))      CALL jval_cal_SO3(jrow)
    IF (lp(ip_OCS))      CALL jval_cal_OCS(jrow)
    IF (lp(ip_CS2))      CALL jval_cal_CS2(jrow)
    IF (lp(ip_H2O))      CALL jval_cal_H2O(jrow)
    IF (lp(ip_N2O))      CALL jval_cal_N2O(jrow)
    IF (lp(ip_NO))       CALL jval_cal_NO(jrow)
    IF (lp(ip_CO2))      CALL jval_cal_CO2(jrow)
    IF (lp(ip_HCl))      CALL jval_cal_HCl(jrow)
    IF (lp(ip_CHCl2Br))  CALL jval_cal_CHCl2Br(jrow)
    IF (lp(ip_CHClBr2))  CALL jval_cal_CHClBr2(jrow)
    IF (lp(ip_CH2ClBr))  CALL jval_cal_CH2ClBr(jrow)
    IF (lp(ip_CH2Br2))   CALL jval_cal_CH2Br2(jrow)
    IF (lp(ip_CHBr3))    CALL jval_cal_CHBr3(jrow)
    IF (lp(ip_SF6))      CALL jval_cal_SF6(jrow)
    IF (lp(ip_NO3NOO))   CALL jval_cal_NO3NOO(jrow)
    IF (lp(ip_ClONO2))   CALL jval_cal_ClONO2(jrow)
    IF (lp(ip_MACR))     CALL jval_cal_MACR(jrow)
    IF (lp(ip_MVK))      CALL jval_cal_MVK(jrow)
    IF (lp(ip_GLYOX))    CALL jval_cal_GLYOX(jrow)
    IF (lp(ip_HOCH2CHO)) CALL jval_cal_HOCH2CHO(jrow)
    IF (lp(ip_CH4))      CALL jval_cal_CH4(jrow)
    IF (lp(ip_H2SO4))    CALL jval_cal_H2SO4(jrow)

  END SUBROUTINE jval_cal

  ! **************************************************************************

  SUBROUTINE jval_cal_O2(jrow)

    ! O2 -> O + O Schumann-Runge bands: Koppers + Murtagh, Ann. Geophys. (1996); Herzberg bands: JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_O2

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_O2(dim58) = (/ &
      -8.2183E-22, -7.5708E-22, -6.9570E-22, -6.3768E-22, -5.8243E-22, -5.2913E-22, &
      -4.7808E-22, -4.2947E-22, -3.8362E-22, -3.4122E-22, -3.0251E-22, -2.6790E-22, &
      -2.3760E-22, -2.1142E-22, -1.8694E-22, -1.6567E-22, -1.4694E-22, -1.2963E-22, &
      -1.1419E-22, -1.0028E-22, -8.7287E-23, -7.5680E-23, -6.5376E-23, -5.5981E-23, &
      -4.7882E-23, -4.0766E-23, -3.4783E-23, -2.9760E-23, -2.5508E-23, -2.1894E-23, &
      -1.8788E-23, -1.6086E-23, -1.3715E-23, -1.1618E-23, -9.7779E-24, -8.1663E-24, &
      -6.7897E-24, -5.6263E-24, -4.6643E-24, -3.8835E-24, -3.2620E-24, -2.7741E-24, &
      -2.3911E-24, -2.0890E-24, -1.8410E-24, -1.6271E-24, -1.4312E-24, -1.2481E-24, &
      -1.0736E-24, -9.1030E-25, -7.6036E-25, -6.2472E-25, -5.0350E-25, -3.9726E-25, &
      -3.0975E-25, -2.5067E-25, -2.3447E-25, -2.5631E-25/)
    REAL, PARAMETER :: a0_1_2_O2(dim58) = (/ &
      3.7793E-20, 3.4931E-20, 3.2206E-20, 2.9618E-20, 2.7143E-20, 2.4745E-20, &
      2.2437E-20, 2.0230E-20, 1.8139E-20, 1.6198E-20, 1.4417E-20, 1.2818E-20, &
      1.1412E-20, 1.0192E-20, 9.0463E-21, 8.0468E-21, 7.1626E-21, 6.3423E-21, &
      5.6073E-21, 4.9425E-21, 4.3187E-21, 3.7592E-21, 3.2605E-21, 2.8039E-21, &
      2.4087E-21, 2.0600E-21, 1.7656E-21, 1.5175E-21, 1.3066E-21, 1.1266E-21, &
      9.7134E-22, 8.3568E-22, 7.1620E-22, 6.1008E-22, 5.1660E-22, 4.3441E-22, &
      3.6393E-22, 3.0413E-22, 2.5449E-22, 2.1405E-22, 1.8173E-22, 1.5626E-22, &
      1.3619E-22, 1.2030E-22, 1.0720E-22, 9.5872E-23, 8.5447E-23, 7.5670E-23, &
      6.6315E-23, 5.7532E-23, 4.9435E-23, 4.2083E-23, 3.5489E-23, 2.9688E-23, &
      2.4892E-23, 2.1643E-23, 2.0749E-23, 2.1959E-23/)
    REAL, PARAMETER :: a0_2_1_O2(dim58) = (/ &
      5.4893E-24, 4.9910E-24, 4.5286E-24, 4.1033E-24, 3.7097E-24, 3.3368E-24, &
      2.9851E-24, 2.6540E-24, 2.3434E-24, 2.0576E-24, 1.7978E-24, 1.5661E-24, &
      1.3778E-24, 1.2351E-24, 1.0531E-24, 9.0950E-25, 7.9314E-25, 6.7431E-25, &
      5.7891E-25, 4.9984E-25, 4.1944E-25, 3.5393E-25, 2.9938E-25, 2.4600E-25, &
      2.0324E-25, 1.6431E-25, 1.3426E-25, 1.1071E-25, 9.1312E-26, 7.5333E-26, &
      6.2129E-26, 5.1112E-26, 4.1850E-26, 3.4012E-26, 2.7413E-26, 2.1889E-26, &
      1.7368E-26, 1.3718E-26, 1.0836E-26, 8.5894E-27, 6.8820E-27, 5.5888E-27, &
      4.5734E-27, 3.7968E-27, 3.1593E-27, 2.6040E-27, 2.1105E-27, 1.6725E-27, &
      1.2896E-27, 9.7613E-28, 7.2546E-28, 5.4032E-28, 4.0244E-28, 2.9906E-28, &
      2.2089E-28, 1.6328E-28, 1.1931E-28, 1.0172E-28/)
    REAL, PARAMETER :: a0_2_2_O2(dim58) = (/ &
      -2.5135E-22, -2.2933E-22, -2.0879E-22, -1.8982E-22, -1.7220E-22, -1.5541E-22, &
      -1.3951E-22, -1.2448E-22, -1.1032E-22, -9.7233E-23, -8.5282E-23, -7.4577E-23, &
      -6.5840E-23, -5.9190E-23, -5.0670E-23, -4.3922E-23, -3.8430E-23, -3.2797E-23, &
      -2.8256E-23, -2.4477E-23, -2.0618E-23, -1.7460E-23, -1.4820E-23, -1.2225E-23, &
      -1.0139E-23, -8.2311E-24, -6.7526E-24, -5.5892E-24, -4.6273E-24, -3.8315E-24, &
      -3.1713E-24, -2.6182E-24, -2.1514E-24, -1.7549E-24, -1.4196E-24, -1.1379E-24, &
      -9.0640E-25, -7.1882E-25, -5.7007E-25, -4.5372E-25, -3.6493E-25, -2.9743E-25, &
      -2.4422E-25, -2.0337E-25, -1.6971E-25, -1.4028E-25, -1.1402E-25, -9.0638E-26, &
      -7.0114E-26, -5.3249E-26, -3.9713E-26, -2.9679E-26, -2.2178E-26, -1.6533E-26, &
      -1.2250E-26, -9.0811E-27, -6.6538E-27, -5.6796E-27/)
    REAL, PARAMETER :: a0_3_1_O2(dim58) = (/ &
      -1.1330E-26, -1.0224E-26, -9.2100E-27, -8.2949E-27, -7.4669E-27, -6.6897E-27, &
      -5.9624E-27, -5.2828E-27, -4.6454E-27, -4.0602E-27, -3.5298E-27, -3.0568E-27, &
      -2.7412E-27, -2.5965E-27, -2.1167E-27, -1.7930E-27, -1.5636E-27, -1.2740E-27, &
      -1.0735E-27, -9.2508E-28, -7.4518E-28, -6.1609E-28, -5.1750E-28, -4.0736E-28, &
      -3.2786E-28, -2.5062E-28, -1.9757E-28, -1.5981E-28, -1.2914E-28, -1.0429E-28, &
      -8.4200E-29, -6.7867E-29, -5.4443E-29, -4.3384E-29, -3.4274E-29, -2.6808E-29, &
      -2.0823E-29, -1.6120E-29, -1.2487E-29, -9.7168E-30, -7.6841E-30, -6.1691E-30, &
      -4.9535E-30, -4.0688E-30, -3.3467E-30, -2.7017E-30, -2.1353E-30, -1.6398E-30, &
      -1.2109E-30, -8.8107E-31, -6.1509E-31, -4.3973E-31, -3.1073E-31, -2.1638E-31, &
      -1.4626E-31, -1.0029E-31, -6.1246E-32, -5.2422E-32/)
    REAL, PARAMETER :: a0_3_2_O2(dim58) = (/ &
      5.1805E-25, 4.6918E-25, 4.2415E-25, 3.8334E-25, 3.4624E-25, 3.1127E-25, &
      2.7840E-25, 2.4754E-25, 2.1848E-25, 1.9168E-25, 1.6728E-25, 1.4543E-25, &
      1.3078E-25, 1.2404E-25, 1.0159E-25, 8.6370E-26, 7.5543E-26, 6.1814E-26, &
      5.2270E-26, 4.5176E-26, 3.6541E-26, 3.0319E-26, 2.5547E-26, 2.0194E-26, &
      1.6315E-26, 1.2530E-26, 9.9199E-27, 8.0548E-27, 6.5334E-27, 5.2960E-27, &
      4.2914E-27, 3.4715E-27, 2.7949E-27, 2.2353E-27, 1.7725E-27, 1.3918E-27, &
      1.0853E-27, 8.4357E-28, 6.5613E-28, 5.1263E-28, 4.0693E-28, 3.2785E-28, &
      2.6415E-28, 2.1761E-28, 1.7949E-28, 1.4530E-28, 1.1517E-28, 8.8709E-29, &
      6.5721E-29, 4.7975E-29, 3.3613E-29, 2.4108E-29, 1.7090E-29, 1.1939E-29, &
      8.0961E-30, 5.5681E-30, 3.4127E-30, 2.9238E-30/)
    REAL, PARAMETER :: a1_1_O2(dim55) = (/ &
      1.1050E-25, 1.0335E-25, 9.6473E-26, 8.6712E-26, 7.7755E-26, 6.8771E-26, &
      6.0414E-26, 5.3584E-26, 4.6852E-26, 4.2113E-26, 3.6912E-26, 3.3773E-26, &
      2.9784E-26, 2.7747E-26, 2.4601E-26, 2.3298E-26, 2.0744E-26, 1.9913E-26, &
      1.7826E-26, 1.7274E-26, 1.5500E-26, 1.5195E-26, 1.3657E-26, 1.3492E-26, &
      1.2148E-26, 1.2092E-26, 1.0879E-26, 1.0931E-26, 9.8272E-27, 9.9384E-27, &
      8.9537E-27, 9.0910E-27, 8.1814E-27, 8.3698E-27, 7.5249E-27, 7.7532E-27, &
      6.9467E-27, 7.1969E-27, 6.4636E-27, 6.6977E-27, 5.8268E-27, 5.0979E-27, &
      4.3878E-27, 3.9629E-27, 3.4818E-27, 3.2160E-27, 2.8555E-27, 2.6783E-27, &
      2.2639E-27, 2.0791E-27, 1.9106E-27, 1.7618E-27, 1.6251E-27, 1.4981E-27, &
      1.3869E-27 /)
    REAL, PARAMETER :: b1_1_O2(dim55) = (/ &
      3.4442E-24, 3.4657E-24, 3.5035E-24, 3.5816E-24, 3.6757E-24, 3.7925E-24, &
      3.9220E-24, 4.0449E-24, 4.1829E-24, 4.2919E-24, 4.4246E-24, 4.5125E-24, &
      4.6341E-24, 4.7014E-24, 4.8130E-24, 4.8625E-24, 4.9660E-24, 5.0017E-24, &
      5.0966E-24, 5.1232E-24, 5.2128E-24, 5.2289E-24, 5.3142E-24, 5.3239E-24, &
      5.4051E-24, 5.4087E-24, 5.4881E-24, 5.4846E-24, 5.5624E-24, 5.5543E-24, &
      5.6286E-24, 5.6179E-24, 5.6912E-24, 5.6755E-24, 5.7478E-24, 5.7277E-24, &
      5.8007E-24, 5.7774E-24, 5.8474E-24, 5.8245E-24, 5.9120E-24, 5.9944E-24, &
      6.0835E-24, 6.1421E-24, 6.2145E-24, 6.2578E-24, 6.3211E-24, 6.3544E-24, &
      6.4375E-24, 6.4769E-24, 6.5149E-24, 6.5503E-24, 6.5845E-24, 6.6179E-24, &
      6.6486E-24 /)
    REAL, PARAMETER :: a1_2_O2(dim55) = (/ &
      -1.2597E-28, -1.7276E-29, 2.1202E-29, 8.9127E-29, 1.1648E-28, 1.3931E-28, &
      1.5272E-28, 1.4578E-28, 1.5084E-28, 1.3084E-28, 1.3334E-28, 1.1012E-28, &
      1.1254E-28, 9.0414E-29, 9.3978E-29, 7.3988E-29, 7.8581E-29, 6.1295E-29, &
      6.6114E-29, 5.1351E-29, 5.6557E-29, 4.3435E-29, 4.8671E-29, 3.7256E-29, &
      4.2382E-29, 3.2244E-29, 3.7355E-29, 2.8016E-29, 3.3171E-29, 2.4612E-29, &
      2.9415E-29, 2.1866E-29, 2.6383E-29, 1.9416E-29, 2.3794E-29, 1.7273E-29, &
      2.1568E-29, 1.5554E-29, 1.9484E-29, 1.4132E-29, 1.4686E-29, 1.1148E-29, &
      9.7898E-30, 7.6690E-30, 7.0377E-30, 5.6336E-30, 5.3736E-30, 4.3723E-30, &
      5.0417E-30, 4.5808E-30, 4.2032E-30, 3.8818E-30, 3.6047E-30, 3.3723E-30, &
      3.1548E-30 /)
    REAL, PARAMETER :: b1_2_O2(dim55) = (/ &
      -7.4149E-27, -7.7410E-27, -7.9527E-27, -8.4961E-27, -8.7832E-27, -9.0800E-27, &
      -9.2880E-27, -9.1630E-27, -9.2668E-27, -8.8067E-27, -8.8704E-27, -8.2203E-27, &
      -8.2942E-27, -7.5640E-27, -7.6905E-27, -6.9309E-27, -7.1169E-27, -6.3736E-27, &
      -6.5929E-27, -5.8842E-27, -6.1472E-27, -5.4517E-27, -5.7423E-27, -5.0802E-27, &
      -5.3903E-27, -4.7516E-27, -5.0864E-27, -4.4513E-27, -4.8147E-27, -4.1900E-27, &
      -4.5526E-27, -3.9638E-27, -4.3274E-27, -3.7491E-27, -4.1235E-27, -3.5496E-27, &
      -3.9383E-27, -3.3790E-27, -3.7543E-27, -3.2298E-27, -3.2855E-27, -2.8856E-27, &
      -2.7152E-27, -2.4226E-27, -2.3276E-27, -2.0987E-27, -2.0530E-27, -1.8648E-27, &
      -1.9990E-27, -1.9009E-27, -1.8157E-27, -1.7392E-27, -1.6698E-27, -1.6087E-27, &
      -1.5488E-27 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_O2(dim58) = (/ &
      1.6313E-01, 1.6313E-01, 1.6313E-01, 1.5033E-01, 1.2271E-01, 8.0699E-02, &
      2.7953E-02, -3.1080E-02, -8.9210E-02, -1.3973E-01, -1.7625E-01, -1.9421E-01, &
      -1.8968E-01, -1.6239E-01, -1.1548E-01, -5.5354E-02, 1.1115E-02, 7.2937E-02, &
      1.2309E-01, 1.5084E-01, 1.5209E-01, 1.2658E-01, 7.7491E-02, 1.3151E-02, &
      -5.3841E-02, -1.0972E-01, -1.4160E-01, -1.4005E-01, -1.0220E-01, -3.1586E-02, &
      6.0093E-02, 1.5487E-01, 2.3362E-01, 2.7658E-01, 2.7465E-01, 2.2069E-01, &
      1.2617E-01, 2.9936E-03, -1.2934E-01, -2.5313E-01, -3.5165E-01, -4.1483E-01, &
      -4.4026E-01, -4.2883E-01, -3.8954E-01, -3.3760E-01, -2.8310E-01, -2.3620E-01, &
      -1.9962E-01, -1.7123E-01, -1.4599E-01, -1.1691E-01, -7.8799E-02, -3.1119E-02, &
      1.5819E-02, 4.0198E-02, 1.2886E-02, -5.1621E-02 /)
    REAL, PARAMETER :: c0_1_2_O2(dim58) = (/ &
      -6.6121E+00, -6.6121E+00, -6.6121E+00, -6.0413E+00, -4.8040E+00, -2.9134E+00, &
      -5.2923E-01, 2.1509E+00, 4.8016E+00, 7.1154E+00, 8.7953E+00, 9.6253E+00, &
      9.4146E+00, 8.1431E+00, 5.9477E+00, 3.1218E+00, -1.5497E-02, -2.9459E+00, &
      -5.3333E+00, -6.6594E+00, -6.7195E+00, -5.4899E+00, -3.1141E+00, 1.2847E-02, &
      3.2821E+00, 6.0202E+00, 7.5888E+00, 7.5119E+00, 5.6346E+00, 2.1181E+00, &
      -2.4658E+00, -7.2238E+00, -1.1192E+01, -1.3366E+01, -1.3268E+01, -1.0516E+01, &
      -5.6771E+00, 6.5426E-01, 7.4827E+00, 1.3895E+01, 1.9018E+01, 2.2316E+01, &
      2.3648E+01, 2.3047E+01, 2.0973E+01, 1.8220E+01, 1.5321E+01, 1.2816E+01, &
      1.0856E+01, 9.3281E+00, 7.9653E+00, 6.3888E+00, 4.3157E+00, 1.7124E+00, &
      -8.5978E-01, -2.2006E+00, -6.9303E-01, 2.8807E+00 /)
    REAL, PARAMETER :: c0_2_1_O2(dim58) = (/ &
      1.0067E-01, 1.0067E-01, 1.0067E-01, 8.8865E-02, 6.1607E-02, 1.8703E-02, &
      -2.9928E-02, -8.2111E-02, -1.2935E-01, -1.6186E-01, -1.8279E-01, -1.8464E-01, &
      -1.7619E-01, -1.4626E-01, -1.0857E-01, -6.3256E-02, -1.8559E-02, 2.6886E-02, &
      7.1887E-02, 1.1214E-01, 1.1752E-01, 1.1554E-01, 8.7678E-02, 5.0931E-02, &
      1.8629E-02, 4.8977E-03, 1.7167E-02, 4.9338E-02, 8.7722E-02, 1.1847E-01, &
      1.2938E-01, 1.2377E-01, 1.0500E-01, 8.3863E-02, 3.8984E-02, -2.2387E-02, &
      -9.2748E-02, -1.8991E-01, -2.5700E-01, -2.9953E-01, -2.7072E-01, -2.0761E-01, &
      -1.3340E-01, -5.4193E-02, -1.7096E-02, -1.2603E-02, -1.9185E-02, -1.6969E-02, &
      2.0296E-03, 3.2798E-02, 7.0451E-02, 9.8498E-02, 9.8113E-02, 6.3805E-02, &
      3.0444E-03, -5.1674E-02, -8.3758E-02, -1.0412E-01 /)
    REAL, PARAMETER :: c0_2_2_O2(dim58) = (/ &
      -4.2499E+00, -4.2499E+00, -4.2499E+00, -3.7233E+00, -2.5021E+00, -5.7147E-01, &
      1.6266E+00, 3.9958E+00, 6.1499E+00, 7.6388E+00, 8.6017E+00, 8.6869E+00, &
      8.2949E+00, 6.9003E+00, 5.1363E+00, 3.0066E+00, 8.9690E-01, -1.2572E+00, &
      -3.3992E+00, -5.3234E+00, -5.5815E+00, -5.4860E+00, -4.1376E+00, -2.3517E+00, &
      -7.7538E-01, -1.0253E-01, -7.0618E-01, -2.2954E+00, -4.1993E+00, -5.7305E+00, &
      -6.2762E+00, -5.9946E+00, -5.0484E+00, -3.9789E+00, -1.6990E+00, 1.4309E+00, &
      5.0334E+00, 1.0028E+01, 1.3489E+01, 1.5692E+01, 1.4195E+01, 1.0900E+01, &
      7.0114E+00, 2.8451E+00, 8.8633E-01, 6.4822E-01, 9.9838E-01, 8.8006E-01, &
      -1.3828E-01, -1.7936E+00, -3.8269E+00, -5.3470E+00, -5.3261E+00, -3.4529E+00, &
      -1.2319E-01, 2.8863E+00, 4.6573E+00, 5.7852E+00 /)

    jval_gp(ip_O2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_O2(0) = &
          p2(1.,c0_1_1_O2(i0(j,k))*dlv2(j,k) + &
          c0_1_2_O2(i0(j,k)), &
          c0_2_1_O2(i0(j,k))*dlv2(j,k) + &
          c0_2_2_O2(i0(j,k)), tnorm_sr(j,k)) * &
          p2(a0_1_1_O2(i0(j,k))*dlv2(j,k) + &
          a0_1_2_O2(i0(j,k)), &
          a0_2_1_O2(i0(j,k))*dlv2(j,k) + &
          a0_2_2_O2(i0(j,k)), &
          a0_3_1_O2(i0(j,k))*dlv2(j,k) + &
          a0_3_2_O2(i0(j,k)), v3_du1(j,k))
        sig_O2(1) = &
          (p1(b1_1_O2(i1(j,k)),a1_1_O2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_O2(i1(j,k)),a1_2_O2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        dj = 0. &
          + r_O2(j,k) * phi_la &
          + sig_O2(0) * fint(j,k,0) &
          + sig_O2(1) * fint(j,k,1)

        ! mz_cb_20051014: factor 0.95 to scale for bias:
        jval_gp(ip_O2)%ptr(iu0(j),k,jrow) = 0.95*MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_O2

  ! **************************************************************************

  SUBROUTINE jval_cal_O3P(jrow)

    ! O3 -> O(3P) + O2 Molina + Molina (1986)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_O3P

    ! T-const parameters:
    ! (the same values a0_*, a1_*, and b1_* are used for O1D and O3P)
    REAL, PARAMETER :: a0_1_1_O3P(dim58) = (/ &
      -5.0266E-21, -5.4393E-21, -5.8779E-21, -6.3301E-21, -6.7861E-21, -7.2489E-21, &
      -7.7158E-21, -8.1908E-21, -8.6591E-21, -9.1470E-21, -9.6073E-21, -1.0100E-20, &
      -1.1045E-20, -1.2851E-20, -1.2777E-20, -1.3153E-20, -1.3900E-20, -1.3768E-20, &
      -1.4009E-20, -1.4565E-20, -1.4284E-20, -1.4350E-20, -1.4658E-20, -1.4278E-20, &
      -1.4194E-20, -1.3586E-20, -1.3282E-20, -1.3232E-20, -1.3161E-20, -1.3038E-20, &
      -1.2881E-20, -1.2684E-20, -1.2426E-20, -1.2129E-20, -1.1816E-20, -1.1479E-20, &
      -1.1166E-20, -1.0886E-20, -1.0644E-20, -1.0432E-20, -1.0255E-20, -1.0076E-20, &
      -9.8596E-21, -9.5929E-21, -9.2271E-21, -8.7438E-21, -8.1461E-21, -7.4984E-21, &
      -6.7978E-21, -6.1194E-21, -5.4602E-21, -4.8508E-21, -4.2780E-21, -3.7223E-21, &
      -3.1841E-21, -2.6694E-21, -2.1642E-21, -1.7583E-21 /)
    REAL, PARAMETER :: a0_1_2_O3P(dim58) = (/ &
      6.5642E-19, 6.7466E-19, 6.9413E-19, 7.1430E-19, 7.3473E-19, 7.5556E-19, &
      7.7666E-19, 7.9823E-19, 8.1958E-19, 8.4192E-19, 8.6310E-19, 8.8585E-19, &
      9.2970E-19, 1.0139E-18, 1.0104E-18, 1.0281E-18, 1.0633E-18, 1.0571E-18, &
      1.0686E-18, 1.0951E-18, 1.0817E-18, 1.0848E-18, 1.0997E-18, 1.0812E-18, &
      1.0772E-18, 1.0474E-18, 1.0324E-18, 1.0299E-18, 1.0264E-18, 1.0203E-18, &
      1.0124E-18, 1.0025E-18, 9.8956E-19, 9.7450E-19, 9.5861E-19, 9.4142E-19, &
      9.2542E-19, 9.1102E-19, 8.9855E-19, 8.8755E-19, 8.7836E-19, 8.6901E-19, &
      8.5767E-19, 8.4363E-19, 8.2432E-19, 7.9871E-19, 7.6691E-19, 7.3232E-19, &
      6.9477E-19, 6.5827E-19, 6.2267E-19, 5.8965E-19, 5.5848E-19, 5.2814E-19, &
      4.9865E-19, 4.7034E-19, 4.4246E-19, 4.1997E-19 /)
    REAL, PARAMETER :: a0_2_1_O3P(dim58) = (/ &
      1.9659E-23, 2.1210E-23, 2.2803E-23, 2.4516E-23, 2.6124E-23, 2.7802E-23, &
      2.9458E-23, 3.1153E-23, 3.2770E-23, 3.4473E-23, 3.5961E-23, 3.7649E-23, &
      4.6093E-23, 6.6596E-23, 5.9393E-23, 5.8976E-23, 6.3617E-23, 5.7209E-23, &
      5.6189E-23, 5.9276E-23, 5.3213E-23, 5.1644E-23, 5.3096E-23, 4.7637E-23, &
      4.5648E-23, 3.8769E-23, 3.5279E-23, 3.4507E-23, 3.3714E-23, 3.2727E-23, &
      3.1749E-23, 3.0697E-23, 2.9494E-23, 2.8250E-23, 2.7014E-23, 2.5721E-23, &
      2.4544E-23, 2.3512E-23, 2.2609E-23, 2.1747E-23, 2.1044E-23, 2.0311E-23, &
      1.9467E-23, 1.8548E-23, 1.7366E-23, 1.5952E-23, 1.4283E-23, 1.2631E-23, &
      1.0890E-23, 9.2987E-24, 7.8249E-24, 6.5515E-24, 5.4049E-24, 4.3587E-24, &
      3.4177E-24, 2.6250E-24, 1.9674E-24, 1.5040E-24 /)
    REAL, PARAMETER :: a0_2_2_O3P(dim58) = (/ &
      -1.2080E-21, -1.2765E-21, -1.3473E-21, -1.4236E-21, -1.4957E-21, -1.5712E-21, &
      -1.6461E-21, -1.7230E-21, -1.7967E-21, -1.8747E-21, -1.9432E-21, -2.0212E-21, &
      -2.4130E-21, -3.3684E-21, -3.0313E-21, -3.0117E-21, -3.2308E-21, -2.9270E-21, &
      -2.8785E-21, -3.0260E-21, -2.7350E-21, -2.6594E-21, -2.7297E-21, -2.4643E-21, &
      -2.3673E-21, -2.0302E-21, -1.8585E-21, -1.8204E-21, -1.7811E-21, -1.7319E-21, &
      -1.6830E-21, -1.6302E-21, -1.5696E-21, -1.5066E-21, -1.4438E-21, -1.3779E-21, &
      -1.3176E-21, -1.2646E-21, -1.2179E-21, -1.1733E-21, -1.1368E-21, -1.0985E-21, &
      -1.0543E-21, -1.0059E-21, -9.4355E-22, -8.6860E-22, -7.7982E-22, -6.9157E-22, &
      -5.9824E-22, -5.1265E-22, -4.3307E-22, -3.6405E-22, -3.0167E-22, -2.4455E-22, &
      -1.9298E-22, -1.4939E-22, -1.1308E-22, -8.7411E-23 /)
    REAL, PARAMETER :: a1_1_O3P(dim55) = (/ &
      -1.4980E-19, -1.3571E-19, -1.1932E-19, -1.0352E-19, -8.8039E-20, -7.4782E-20, &
      -6.2892E-20, -5.3282E-20, -4.4994E-20, -3.8399E-20, -3.2893E-20, -2.8389E-20, &
      -2.4727E-20, -2.1657E-20, -1.9158E-20, -1.6987E-20, -1.5233E-20, -1.3660E-20, &
      -1.2392E-20, -1.1226E-20, -1.0276E-20, -9.3900E-21, -8.6675E-21, -7.9704E-21, &
      -7.4197E-21, -6.8524E-21, -6.4094E-21, -5.9559E-21, -5.6052E-21, -5.2215E-21, &
      -4.9439E-21, -4.6252E-21, -4.3935E-21, -4.1245E-21, -3.9346E-21, -3.6999E-21, &
      -3.5479E-21, -3.3425E-21, -3.2136E-21, -3.0369E-21, -2.6795E-21, -2.1831E-21, &
      -1.8278E-21, -1.5510E-21, -1.3413E-21, -1.1684E-21, -1.0327E-21, -9.1591E-22, &
      -8.2368E-22, -7.3990E-22, -6.6822E-22, -6.0616E-22, -5.5204E-22, -5.0431E-22, &
      -4.6223E-22 /)
    REAL, PARAMETER :: b1_1_O3P(dim55) = (/ &
      3.6658E-18, 3.6235E-18, 3.5334E-18, 3.4070E-18, 3.2444E-18, 3.0721E-18, &
      2.8878E-18, 2.7148E-18, 2.5449E-18, 2.3932E-18, 2.2528E-18, 2.1267E-18, &
      2.0150E-18, 1.9137E-18, 1.8250E-18, 1.7425E-18, 1.6715E-18, 1.6038E-18, &
      1.5461E-18, 1.4902E-18, 1.4422E-18, 1.3952E-18, 1.3551E-18, 1.3147E-18, &
      1.2814E-18, 1.2456E-18, 1.2166E-18, 1.1858E-18, 1.1610E-18, 1.1330E-18, &
      1.1121E-18, 1.0872E-18, 1.0686E-18, 1.0462E-18, 1.0300E-18, 1.0093E-18, &
      9.9558E-19, 9.7647E-19, 9.6417E-19, 9.4685E-19, 9.1093E-19, 8.5484E-19, &
      8.1025E-19, 7.7205E-19, 7.4050E-19, 7.1231E-19, 6.8849E-19, 6.6654E-19, &
      6.4804E-19, 6.3020E-19, 6.1404E-19, 5.9927E-19, 5.8571E-19, 5.7316E-19, &
      5.6156E-19 /)
    REAL, PARAMETER :: a1_2_O3P(dim55) = (/ &
      -1.8365E-22, -2.7734E-22, -3.6525E-22, -3.7423E-22, -3.8539E-22, -3.4576E-22, &
      -3.2002E-22, -2.6980E-22, -2.3721E-22, -1.9781E-22, -1.6855E-22, -1.4284E-22, &
      -1.2010E-22, -1.0352E-22, -8.7833E-23, -7.7229E-23, -6.5909E-23, -5.9348E-23, &
      -5.1247E-23, -4.6579E-23, -4.0686E-23, -3.7484E-23, -3.2802E-23, -3.0621E-23, &
      -2.6633E-23, -2.5508E-23, -2.2422E-23, -2.1415E-23, -1.8691E-23, -1.8357E-23, &
      -1.5881E-23, -1.5573E-23, -1.3623E-23, -1.3481E-23, -1.1729E-23, -1.1766E-23, &
      -1.0159E-23, -1.0300E-23, -8.9161E-24, -9.0750E-24, -7.2334E-24, -5.5942E-24, &
      -4.2937E-24, -3.5286E-24, -2.8579E-24, -2.4585E-24, -2.0684E-24, -1.8327E-24, &
      -1.5495E-24, -1.3959E-24, -1.2621E-24, -1.1443E-24, -1.0396E-24, -9.4767E-25, &
      -8.6212E-25 /)
    REAL, PARAMETER :: b1_2_O3P(dim55) = (/ &
      1.1387E-20, 1.1668E-20, 1.2151E-20, 1.2223E-20, 1.2340E-20, 1.1825E-20, &
      1.1426E-20, 1.0522E-20, 9.8541E-21, 8.9477E-21, 8.2016E-21, 7.4819E-21, &
      6.7882E-21, 6.2412E-21, 5.6842E-21, 5.2812E-21, 4.8228E-21, 4.5406E-21, &
      4.1721E-21, 3.9480E-21, 3.6504E-21, 3.4807E-21, 3.2208E-21, 3.0943E-21, &
      2.8531E-21, 2.7822E-21, 2.5800E-21, 2.5116E-21, 2.3196E-21, 2.2952E-21, &
      2.1082E-21, 2.0842E-21, 1.9273E-21, 1.9154E-21, 1.7657E-21, 1.7689E-21, &
      1.6234E-21, 1.6365E-21, 1.5044E-21, 1.5200E-21, 1.3349E-21, 1.1497E-21, &
      9.8646E-22, 8.8088E-22, 7.7993E-22, 7.1484E-22, 6.4637E-22, 6.0207E-22, &
      5.4527E-22, 5.1257E-22, 4.8238E-22, 4.5436E-22, 4.2812E-22, 4.0395E-22, &
      3.8038E-22 /)
    REAL, PARAMETER :: a1_3_O3P(dim55) = (/ &
      1.6680E-24, 1.4066E-24, 1.3810E-24, 8.8328E-25, 7.1115E-25, 2.9844E-25, &
      1.7647E-25, -6.1473E-26, -1.0765E-25, -1.9299E-25, -2.0479E-25, -2.0849E-25, &
      -2.0880E-25, -1.8668E-25, -1.7621E-25, -1.5145E-25, -1.4365E-25, -1.1802E-25, &
      -1.1260E-25, -9.3817E-26, -8.9202E-26, -7.4138E-26, -7.2234E-26, -6.0411E-26, &
      -6.0635E-26, -4.8532E-26, -4.8983E-26, -4.0391E-26, -4.2271E-26, -3.2967E-26, &
      -3.5608E-26, -2.8783E-26, -3.0394E-26, -2.4351E-26, -2.6300E-26, -2.0862E-26, &
      -2.2917E-26, -1.8059E-26, -1.9904E-26, -1.5722E-26, -1.4440E-26, -1.0210E-26, &
      -7.9274E-27, -5.8116E-27, -4.6554E-27, -3.5205E-27, -2.9141E-27, -2.2789E-27, &
      -2.0320E-27, -1.6590E-27, -1.3807E-27, -1.1759E-27, -1.0211E-27, -9.0077E-28, &
      -8.1225E-28 /)
    REAL, PARAMETER :: b1_3_O3P(dim55) = (/ &
      -9.2856E-24, -8.5014E-24, -8.3603E-24, -4.3786E-24, -2.5713E-24, 2.7939E-24, &
      4.6845E-24, 8.9675E-24, 9.9141E-24, 1.1877E-23, 1.2178E-23, 1.2282E-23, &
      1.2291E-23, 1.1561E-23, 1.1189E-23, 1.0248E-23, 9.9323E-24, 8.8306E-24, &
      8.5838E-24, 7.6822E-24, 7.4491E-24, 6.6507E-24, 6.5451E-24, 5.8593E-24, &
      5.8729E-24, 5.1104E-24, 5.1399E-24, 4.5557E-24, 4.6882E-24, 4.0090E-24, &
      4.2084E-24, 3.6761E-24, 3.8058E-24, 3.3042E-24, 3.4709E-24, 2.9923E-24, &
      3.1783E-24, 2.7265E-24, 2.9027E-24, 2.4928E-24, 2.3640E-24, 1.8860E-24, &
      1.5995E-24, 1.3076E-24, 1.1335E-24, 9.4856E-25, 8.4214E-25, 7.2271E-25, &
      6.7321E-25, 5.9376E-25, 5.3102E-25, 4.8227E-25, 4.4349E-25, 4.1185E-25, &
      3.8746E-25 /)
    REAL, PARAMETER :: a2_O3P(dim55) = (/ &
      -4.4164E-20, -3.9736E-20, -3.3484E-20, -2.6792E-20, -2.0676E-20, -1.5608E-20, &
      -1.1668E-20, -8.7240E-21, -6.5680E-21, -5.0040E-21, -3.8760E-21, -3.0520E-21, &
      -2.4440E-21, -1.9920E-21, -1.6520E-21, -1.3920E-21, -1.1840E-21, -1.0240E-21, &
      -8.9600E-22, -7.8400E-22, -7.0000E-22, -6.2800E-22, -5.6400E-22, -5.1200E-22, &
      -4.6400E-22, -4.2400E-22, -3.8800E-22, -3.5600E-22, -3.2800E-22, -3.0400E-22, &
      -2.8400E-22, -2.6000E-22, -2.4000E-22, -2.2400E-22, -2.1200E-22, -1.9200E-22, &
      -1.8400E-22, -1.6800E-22, -1.5600E-22, -1.4800E-22, -1.2080E-22, -8.6400E-23, &
      -6.2399E-23, -4.4800E-23, -3.2001E-23, -2.3199E-23, -1.6800E-23, -1.2000E-23, &
      -8.8002E-24, -6.3993E-24, -4.8007E-24, -3.2002E-24, -2.3999E-24, -1.5996E-24, &
      -8.0030E-25 /)
    REAL, PARAMETER :: b2_O3P(dim55) = (/ &
       7.3987E-19,  7.2659E-19,  6.9220E-19,  6.3867E-19,  5.7445E-19,  5.0856E-19, &
       4.4749E-19,  3.9450E-19,  3.5030E-19,  3.1433E-19,  2.8557E-19,  2.6250E-19, &
       2.4395E-19,  2.2904E-19,  2.1697E-19,  2.0709E-19,  1.9866E-19,  1.9178E-19, &
       1.8596E-19,  1.8058E-19,  1.7634E-19,  1.7252E-19,  1.6897E-19,  1.6596E-19, &
       1.6305E-19,  1.6053E-19,  1.5817E-19,  1.5600E-19,  1.5402E-19,  1.5227E-19, &
       1.5076E-19,  1.4889E-19,  1.4728E-19,  1.4595E-19,  1.4493E-19,  1.4317E-19, &
       1.4244E-19,  1.4095E-19,  1.3981E-19,  1.3902E-19,  1.3629E-19,  1.3240E-19, &
       1.2939E-19,  1.2696E-19,  1.2504E-19,  1.2360E-19,  1.2248E-19,  1.2158E-19, &
       1.2093E-19,  1.2042E-19,  1.2006E-19,  1.1968E-19,  1.1948E-19,  1.1927E-19, &
       1.1905E-19 /)
    REAL, PARAMETER :: a3_O3P(dim55) = (/ &
      -1.8156E-22, -1.4954E-22, -1.1634E-22, -8.7407E-23, -6.4525E-23, -4.7620E-23, &
      -3.5553E-23, -2.7037E-23, -2.1030E-23, -1.6741E-23, -1.3624E-23, -1.1290E-23, &
      -9.5128E-24, -8.1230E-24, -7.0196E-24, -6.1222E-24, -5.3914E-24, -4.7764E-24, &
      -4.2629E-24, -3.8299E-24, -3.4545E-24, -3.1390E-24, -2.8606E-24, -2.6158E-24, &
      -2.4081E-24, -2.2205E-24, -2.0535E-24, -1.9089E-24, -1.7732E-24, -1.6573E-24, &
      -1.5501E-24, -1.4497E-24, -1.3658E-24, -1.2819E-24, -1.2106E-24, -1.1422E-24, &
      -1.0823E-24, -1.0264E-24, -9.7084E-25, -9.2252E-25, -8.0112E-25, -6.4217E-25, &
      -5.2636E-25, -4.3850E-25, -3.7170E-25, -3.1709E-25, -2.7236E-25, -2.3642E-25, &
      -2.0527E-25, -1.7971E-25, -1.5655E-25, -1.3738E-25, -1.2070E-25, -1.0623E-25, &
      -9.3450E-26 /)
    REAL, PARAMETER :: b3_O3P(dim55) = (/ &
      2.3458E-20, 2.2640E-20, 2.0961E-20, 1.8773E-20, 1.6470E-20, 1.4345E-20, &
      1.2526E-20, 1.1030E-20, 9.8235E-21, 8.8548E-21, 8.0727E-21, 7.4288E-21, &
      6.8940E-21, 6.4409E-21, 6.0536E-21, 5.7161E-21, 5.4230E-21, 5.1609E-21, &
      4.9292E-21, 4.7230E-21, 4.5349E-21, 4.3688E-21, 4.2153E-21, 4.0743E-21, &
      3.9494E-21, 3.8318E-21, 3.7230E-21, 3.6252E-21, 3.5300E-21, 3.4458E-21, &
      3.3652E-21, 3.2872E-21, 3.2200E-21, 3.1506E-21, 3.0898E-21, 3.0299E-21, &
      2.9758E-21, 2.9240E-21, 2.8712E-21, 2.8240E-21, 2.7023E-21, 2.5232E-21, &
      2.3781E-21, 2.2571E-21, 2.1567E-21, 2.0678E-21, 1.9894E-21, 1.9219E-21, &
      1.8595E-21, 1.8051E-21, 1.7528E-21, 1.7072E-21, 1.6655E-21, 1.6274E-21, &
      1.5922E-21 /)
    REAL, PARAMETER :: a4_O3P(4) = (/ 4.1602E-20, 1.0618E-23, -3.8825E-27, 4.8451E-31 /)
    REAL, PARAMETER :: a5_O3P(3) = (/ 1.1769E-20, -3.7290E-24, 5.5891E-28 /)
    REAL, PARAMETER :: a6_O3P(2) = (/ 7.5434E-23, -8.5667E-28 /)
    REAL, PARAMETER :: a7_O3P(2) = (/ 2.4069E-21, -6.4666E-26 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_O3P(dim58) = (/ &
      -7.0191E-03, -7.0191E-03, -7.0191E-03, -8.1775E-03, -9.0525E-03, -1.0315E-02, &
      -1.1296E-02, -1.1692E-02, -1.2369E-02, -1.2926E-02, -1.2667E-02, -1.3050E-02, &
      -1.2699E-02, -1.2539E-02, -1.2559E-02, -1.2045E-02, -1.2295E-02, -1.2351E-02, &
      -1.2501E-02, -1.2481E-02, -1.2809E-02, -1.2848E-02, -1.2163E-02, -1.1147E-02, &
      -1.0137E-02, -7.6925E-03, -5.2963E-03, -2.6730E-03, -2.2028E-04, 2.1178E-03, &
      3.7890E-03, 4.4592E-03, 3.6196E-03, 1.6453E-03, -1.3751E-03, -4.4430E-03, &
      -8.0093E-03, -1.0779E-02, -1.2009E-02, -1.1375E-02, -8.2903E-03, -3.7170E-03, &
      3.1828E-03, 9.6868E-03, 1.6113E-02, 2.0800E-02, 2.2935E-02, 2.2651E-02, &
      2.1574E-02, 2.0290E-02, 2.0017E-02, 2.1864E-02, 2.5309E-02, 2.9336E-02, &
      3.2886E-02, 3.4905E-02, 3.6604E-02, 4.0160E-02 /)
    REAL, PARAMETER :: c0_1_2_O3P(dim58) = (/ &
      3.1254E-01, 3.1254E-01, 3.1254E-01, 3.6421E-01, 4.0341E-01, 4.6024E-01, &
      5.0458E-01, 5.2252E-01, 5.5342E-01, 5.7890E-01, 5.6701E-01, 5.8472E-01, &
      5.6840E-01, 5.6096E-01, 5.6190E-01, 5.3773E-01, 5.4953E-01, 5.5220E-01, &
      5.5935E-01, 5.5836E-01, 5.7414E-01, 5.7598E-01, 5.4284E-01, 4.9348E-01, &
      4.4419E-01, 3.2440E-01, 2.0651E-01, 7.6914E-02, -4.4740E-02, -1.6118E-01, &
      -2.4473E-01, -2.7838E-01, -2.3607E-01, -1.3616E-01, 1.7271E-02, 1.7373E-01, &
      3.5633E-01, 4.9868E-01, 5.6214E-01, 5.2933E-01, 3.6891E-01, 1.3019E-01, &
      -2.3136E-01, -5.7347E-01, -9.1277E-01, -1.1612E+00, -1.2748E+00, -1.2596E+00, &
      -1.2019E+00, -1.1328E+00, -1.1181E+00, -1.2182E+00, -1.4056E+00, -1.6255E+00, &
      -1.8200E+00, -1.9310E+00, -2.0248E+00, -2.2218E+00 /)
    REAL, PARAMETER :: c0_2_1_O3P(dim58) = (/ &
      8.0025E-04, 8.0025E-04, 8.0025E-04, -4.2989E-03, -1.7255E-03, -1.4436E-03, &
      -2.4649E-03, -2.5963E-03, -2.9353E-03, -2.8235E-03, -5.4407E-05, -3.7774E-04, &
      7.6838E-05, 4.3952E-03, 3.2172E-03, 3.2044E-03, 5.0126E-03, 5.1538E-03, &
      5.0230E-03, 5.7908E-03, 7.5288E-03, 5.7935E-03, 6.8681E-03, 5.7070E-03, &
      5.8363E-03, 6.7479E-03, 3.9212E-03, 4.5167E-03, 1.3028E-03, 1.6390E-03, &
      6.7867E-04, -1.5781E-03, -1.9784E-03, -1.4371E-03, -1.6170E-03, -2.1123E-03, &
      -3.3934E-04, 1.9431E-03, 5.8769E-03, 1.2693E-02, 1.5833E-02, 2.1979E-02, &
      2.2427E-02, 1.9646E-02, 1.3546E-02, 1.1175E-02, 5.9491E-03, 2.3821E-03, &
      4.9171E-03, 8.4691E-03, 4.6355E-03, -6.7929E-03, -1.3726E-02, -3.1842E-02, &
      -4.3998E-02, -3.8830E-02, -2.5365E-02, -2.4250E-03 /)
    REAL, PARAMETER :: c0_2_2_O3P(dim58) = (/ &
      -5.4338E-03, -5.4338E-03, -5.4338E-03, 2.2199E-01, 1.0670E-01, 9.4016E-02, &
      1.4018E-01, 1.4614E-01, 1.6160E-01, 1.5648E-01, 2.9102E-02, 4.4040E-02, &
      2.2948E-02, -1.7829E-01, -1.2316E-01, -1.2256E-01, -2.0790E-01, -2.1460E-01, &
      -2.0837E-01, -2.4507E-01, -3.2849E-01, -2.4485E-01, -2.9687E-01, -2.4043E-01, &
      -2.4675E-01, -2.9141E-01, -1.5234E-01, -1.8176E-01, -2.2346E-02, -3.9092E-02, &
      8.9268E-03, 1.2222E-01, 1.4239E-01, 1.1500E-01, 1.2414E-01, 1.4940E-01, &
      5.8625E-02, -5.8691E-02, -2.6168E-01, -6.1477E-01, -7.7800E-01, -1.0989E+00, &
      -1.1223E+00, -9.7603E-01, -6.5396E-01, -5.2830E-01, -2.5028E-01, -5.9807E-02, &
      -1.9569E-01, -3.8678E-01, -1.7977E-01, 4.3966E-01, 8.1682E-01, 1.8059E+00, &
      2.4721E+00, 2.1879E+00, 1.4446E+00, 1.7371E-01 /)
    REAL, PARAMETER :: c2_O3P(3) = (/ 1.00,  0.07,  0.20 /)
    REAL, PARAMETER :: c3_O3P(3) = (/ 1.00, -0.11,  0.09 /)
    REAL, PARAMETER :: c4_O3P(3) = (/ 1.00, -0.55, -0.41 /)
    REAL, PARAMETER :: c5_O3P(3) = (/ 1.00, -0.26, -0.53 /)

    jval_gp(ip_O3P)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_O3P(0) = &
          p2(1.,c0_1_1_O3P(i0(j,k))*dlv2(j,k) + &
          c0_1_2_O3P(i0(j,k)), &
          c0_2_1_O3P(i0(j,k))*dlv2(j,k) + &
          c0_2_2_O3P(i0(j,k)), tnorm_sr(j,k)) * &
          p1(a0_1_1_O3P(i0(j,k))*dlv2(j,k) + &
          a0_1_2_O3P(i0(j,k)), &
          a0_2_1_O3P(i0(j,k))*dlv2(j,k) + &
          a0_2_2_O3P(i0(j,k)),v3_du1(j,k))
        sig_O3P(1) = &
          (p1(b1_1_O3P(i1(j,k)),a1_1_O3P(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_O3P(i1(j,k)),a1_2_O3P(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k) + &
          p1(b1_3_O3P(i1(j,k)),a1_3_O3P(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k)**2)
        sig_O3P(2) = &
          p2(c2_O3P(1),c2_O3P(2),c2_O3P(3),tnorm(j,k))* &
          p1(b2_O3P(i2(j,k)), a2_O3P(i2(j,k)), &
          v3_du1(j,k))
        sig_O3P(3) = &
          p2(c3_O3P(1),c3_O3P(2),c3_O3P(3),tnorm(j,k))* &
          p1(b3_O3P(i3(j,k)), a3_O3P(i3(j,k)), &
          v3_du2(j,k))
        sig_O3P(4) = &
          p2(c4_O3P(1),c4_O3P(2),c4_O3P(3),tnorm(j,k))* &
          p3(a4_O3P(1),a4_O3P(2),a4_O3P(3), &
          a4_O3P(4),v3_du2(j,k))
        sig_O3P(5) = &
          p2(c5_O3P(1),c5_O3P(2),c5_O3P(3),tnorm(j,k))* &
          p2(a5_O3P(1),a5_O3P(2),a5_O3P(3),v3_du2(j,k))
        sig_O3P(6) = &
          p1(a6_O3P(1),a6_O3P(2),v3_du2(j,k))
        sig_O3P(7) = &
          p1(a7_O3P(1),a7_O3P(2),v3_du2(j,k))
        ! 0.13 = fixed quantum yield in intervals 0 and 1 (Talukdar et al. 1998)
        dj = 0. &
          + sig_O3P(0) * fint(j,k,0) * 0.13 &
          + sig_O3P(1) * fint(j,k,1) * 0.13 &
          + sig_O3P(2) * fint(j,k,2) &
          + sig_O3P(3) * fint(j,k,3) &
          + sig_O3P(4) * fint(j,k,4) &
          + sig_O3P(5) * fint(j,k,5) &
          + sig_O3P(6) * fint(j,k,6) &
          + sig_O3P(7) * fint(j,k,7)

        jval_gp(ip_O3P)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_O3P

  ! **************************************************************************

  SUBROUTINE jval_cal_O1D(jrow)

    ! O3 -> O(1D) + O2 Molina + Molina (1986)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_O1D

    ! T-const parameters:
    ! (the same values a0_*, a1_*, and b1_* are used for O1D and O3P)
    REAL, PARAMETER :: a0_1_1_O1D(dim58) = (/ &
      -5.0266E-21, -5.4393E-21, -5.8779E-21, -6.3301E-21, -6.7861E-21, -7.2489E-21, &
      -7.7158E-21, -8.1908E-21, -8.6591E-21, -9.1470E-21, -9.6073E-21, -1.0100E-20, &
      -1.1045E-20, -1.2851E-20, -1.2777E-20, -1.3153E-20, -1.3900E-20, -1.3768E-20, &
      -1.4009E-20, -1.4565E-20, -1.4284E-20, -1.4350E-20, -1.4658E-20, -1.4278E-20, &
      -1.4194E-20, -1.3586E-20, -1.3282E-20, -1.3232E-20, -1.3161E-20, -1.3038E-20, &
      -1.2881E-20, -1.2684E-20, -1.2426E-20, -1.2129E-20, -1.1816E-20, -1.1479E-20, &
      -1.1166E-20, -1.0886E-20, -1.0644E-20, -1.0432E-20, -1.0255E-20, -1.0076E-20, &
      -9.8596E-21, -9.5929E-21, -9.2271E-21, -8.7438E-21, -8.1461E-21, -7.4984E-21, &
      -6.7978E-21, -6.1194E-21, -5.4602E-21, -4.8508E-21, -4.2780E-21, -3.7223E-21, &
      -3.1841E-21, -2.6694E-21, -2.1642E-21, -1.7583E-21 /)
    REAL, PARAMETER :: a0_1_2_O1D(dim58) = (/ &
      6.5642E-19, 6.7466E-19, 6.9413E-19, 7.1430E-19, 7.3473E-19, 7.5556E-19, &
      7.7666E-19, 7.9823E-19, 8.1958E-19, 8.4192E-19, 8.6310E-19, 8.8585E-19, &
      9.2970E-19, 1.0139E-18, 1.0104E-18, 1.0281E-18, 1.0633E-18, 1.0571E-18, &
      1.0686E-18, 1.0951E-18, 1.0817E-18, 1.0848E-18, 1.0997E-18, 1.0812E-18, &
      1.0772E-18, 1.0474E-18, 1.0324E-18, 1.0299E-18, 1.0264E-18, 1.0203E-18, &
      1.0124E-18, 1.0025E-18, 9.8956E-19, 9.7450E-19, 9.5861E-19, 9.4142E-19, &
      9.2542E-19, 9.1102E-19, 8.9855E-19, 8.8755E-19, 8.7836E-19, 8.6901E-19, &
      8.5767E-19, 8.4363E-19, 8.2432E-19, 7.9871E-19, 7.6691E-19, 7.3232E-19, &
      6.9477E-19, 6.5827E-19, 6.2267E-19, 5.8965E-19, 5.5848E-19, 5.2814E-19, &
      4.9865E-19, 4.7034E-19, 4.4246E-19, 4.1997E-19 /)
    REAL, PARAMETER :: a0_2_1_O1D(dim58) = (/ &
      1.9659E-23, 2.1210E-23, 2.2803E-23, 2.4516E-23, 2.6124E-23, 2.7802E-23, &
      2.9458E-23, 3.1153E-23, 3.2770E-23, 3.4473E-23, 3.5961E-23, 3.7649E-23, &
      4.6093E-23, 6.6596E-23, 5.9393E-23, 5.8976E-23, 6.3617E-23, 5.7209E-23, &
      5.6189E-23, 5.9276E-23, 5.3213E-23, 5.1644E-23, 5.3096E-23, 4.7637E-23, &
      4.5648E-23, 3.8769E-23, 3.5279E-23, 3.4507E-23, 3.3714E-23, 3.2727E-23, &
      3.1749E-23, 3.0697E-23, 2.9494E-23, 2.8250E-23, 2.7014E-23, 2.5721E-23, &
      2.4544E-23, 2.3512E-23, 2.2609E-23, 2.1747E-23, 2.1044E-23, 2.0311E-23, &
      1.9467E-23, 1.8548E-23, 1.7366E-23, 1.5952E-23, 1.4283E-23, 1.2631E-23, &
      1.0890E-23, 9.2987E-24, 7.8249E-24, 6.5515E-24, 5.4049E-24, 4.3587E-24, &
      3.4177E-24, 2.6250E-24, 1.9674E-24, 1.5040E-24 /)
    REAL, PARAMETER :: a0_2_2_O1D(dim58) = (/ &
      -1.2080E-21, -1.2765E-21, -1.3473E-21, -1.4236E-21, -1.4957E-21, -1.5712E-21, &
      -1.6461E-21, -1.7230E-21, -1.7967E-21, -1.8747E-21, -1.9432E-21, -2.0212E-21, &
      -2.4130E-21, -3.3684E-21, -3.0313E-21, -3.0117E-21, -3.2308E-21, -2.9270E-21, &
      -2.8785E-21, -3.0260E-21, -2.7350E-21, -2.6594E-21, -2.7297E-21, -2.4643E-21, &
      -2.3673E-21, -2.0302E-21, -1.8585E-21, -1.8204E-21, -1.7811E-21, -1.7319E-21, &
      -1.6830E-21, -1.6302E-21, -1.5696E-21, -1.5066E-21, -1.4438E-21, -1.3779E-21, &
      -1.3176E-21, -1.2646E-21, -1.2179E-21, -1.1733E-21, -1.1368E-21, -1.0985E-21, &
      -1.0543E-21, -1.0059E-21, -9.4355E-22, -8.6860E-22, -7.7982E-22, -6.9157E-22, &
      -5.9824E-22, -5.1265E-22, -4.3307E-22, -3.6405E-22, -3.0167E-22, -2.4455E-22, &
      -1.9298E-22, -1.4939E-22, -1.1308E-22, -8.7411E-23 /)
    REAL, PARAMETER :: a1_1_O1D(dim55) = (/ &
      -1.4980E-19, -1.3571E-19, -1.1932E-19, -1.0352E-19, -8.8039E-20, -7.4782E-20, &
      -6.2892E-20, -5.3282E-20, -4.4994E-20, -3.8399E-20, -3.2893E-20, -2.8389E-20, &
      -2.4727E-20, -2.1657E-20, -1.9158E-20, -1.6987E-20, -1.5233E-20, -1.3660E-20, &
      -1.2392E-20, -1.1226E-20, -1.0276E-20, -9.3900E-21, -8.6675E-21, -7.9704E-21, &
      -7.4197E-21, -6.8524E-21, -6.4094E-21, -5.9559E-21, -5.6052E-21, -5.2215E-21, &
      -4.9439E-21, -4.6252E-21, -4.3935E-21, -4.1245E-21, -3.9346E-21, -3.6999E-21, &
      -3.5479E-21, -3.3425E-21, -3.2136E-21, -3.0369E-21, -2.6795E-21, -2.1831E-21, &
      -1.8278E-21, -1.5510E-21, -1.3413E-21, -1.1684E-21, -1.0327E-21, -9.1591E-22, &
      -8.2368E-22, -7.3990E-22, -6.6822E-22, -6.0616E-22, -5.5204E-22, -5.0431E-22, &
      -4.6223E-22 /)
    REAL, PARAMETER :: b1_1_O1D(dim55) = (/ &
      3.6658E-18, 3.6235E-18, 3.5334E-18, 3.4070E-18, 3.2444E-18, 3.0721E-18, &
      2.8878E-18, 2.7148E-18, 2.5449E-18, 2.3932E-18, 2.2528E-18, 2.1267E-18, &
      2.0150E-18, 1.9137E-18, 1.8250E-18, 1.7425E-18, 1.6715E-18, 1.6038E-18, &
      1.5461E-18, 1.4902E-18, 1.4422E-18, 1.3952E-18, 1.3551E-18, 1.3147E-18, &
      1.2814E-18, 1.2456E-18, 1.2166E-18, 1.1858E-18, 1.1610E-18, 1.1330E-18, &
      1.1121E-18, 1.0872E-18, 1.0686E-18, 1.0462E-18, 1.0300E-18, 1.0093E-18, &
      9.9558E-19, 9.7647E-19, 9.6417E-19, 9.4685E-19, 9.1093E-19, 8.5484E-19, &
      8.1025E-19, 7.7205E-19, 7.4050E-19, 7.1231E-19, 6.8849E-19, 6.6654E-19, &
      6.4804E-19, 6.3020E-19, 6.1404E-19, 5.9927E-19, 5.8571E-19, 5.7316E-19, &
      5.6156E-19 /)
    REAL, PARAMETER :: a1_2_O1D(dim55) = (/ &
      -1.8365E-22, -2.7734E-22, -3.6525E-22, -3.7423E-22, -3.8539E-22, -3.4576E-22, &
      -3.2002E-22, -2.6980E-22, -2.3721E-22, -1.9781E-22, -1.6855E-22, -1.4284E-22, &
      -1.2010E-22, -1.0352E-22, -8.7833E-23, -7.7229E-23, -6.5909E-23, -5.9348E-23, &
      -5.1247E-23, -4.6579E-23, -4.0686E-23, -3.7484E-23, -3.2802E-23, -3.0621E-23, &
      -2.6633E-23, -2.5508E-23, -2.2422E-23, -2.1415E-23, -1.8691E-23, -1.8357E-23, &
      -1.5881E-23, -1.5573E-23, -1.3623E-23, -1.3481E-23, -1.1729E-23, -1.1766E-23, &
      -1.0159E-23, -1.0300E-23, -8.9161E-24, -9.0750E-24, -7.2334E-24, -5.5942E-24, &
      -4.2937E-24, -3.5286E-24, -2.8579E-24, -2.4585E-24, -2.0684E-24, -1.8327E-24, &
      -1.5495E-24, -1.3959E-24, -1.2621E-24, -1.1443E-24, -1.0396E-24, -9.4767E-25, &
      -8.6212E-25 /)
    REAL, PARAMETER :: b1_2_O1D(dim55) = (/ &
      1.1387E-20, 1.1668E-20, 1.2151E-20, 1.2223E-20, 1.2340E-20, 1.1825E-20, &
      1.1426E-20, 1.0522E-20, 9.8541E-21, 8.9477E-21, 8.2016E-21, 7.4819E-21, &
      6.7882E-21, 6.2412E-21, 5.6842E-21, 5.2812E-21, 4.8228E-21, 4.5406E-21, &
      4.1721E-21, 3.9480E-21, 3.6504E-21, 3.4807E-21, 3.2208E-21, 3.0943E-21, &
      2.8531E-21, 2.7822E-21, 2.5800E-21, 2.5116E-21, 2.3196E-21, 2.2952E-21, &
      2.1082E-21, 2.0842E-21, 1.9273E-21, 1.9154E-21, 1.7657E-21, 1.7689E-21, &
      1.6234E-21, 1.6365E-21, 1.5044E-21, 1.5200E-21, 1.3349E-21, 1.1497E-21, &
      9.8646E-22, 8.8088E-22, 7.7993E-22, 7.1484E-22, 6.4637E-22, 6.0207E-22, &
      5.4527E-22, 5.1257E-22, 4.8238E-22, 4.5436E-22, 4.2812E-22, 4.0395E-22, &
      3.8038E-22 /)
    REAL, PARAMETER :: a1_3_O1D(dim55) = (/ &
      1.6680E-24, 1.4066E-24, 1.3810E-24, 8.8328E-25, 7.1115E-25, 2.9844E-25, &
      1.7647E-25, -6.1473E-26, -1.0765E-25, -1.9299E-25, -2.0479E-25, -2.0849E-25, &
      -2.0880E-25, -1.8668E-25, -1.7621E-25, -1.5145E-25, -1.4365E-25, -1.1802E-25, &
      -1.1260E-25, -9.3817E-26, -8.9202E-26, -7.4138E-26, -7.2234E-26, -6.0411E-26, &
      -6.0635E-26, -4.8532E-26, -4.8983E-26, -4.0391E-26, -4.2271E-26, -3.2967E-26, &
      -3.5608E-26, -2.8783E-26, -3.0394E-26, -2.4351E-26, -2.6300E-26, -2.0862E-26, &
      -2.2917E-26, -1.8059E-26, -1.9904E-26, -1.5722E-26, -1.4440E-26, -1.0210E-26, &
      -7.9274E-27, -5.8116E-27, -4.6554E-27, -3.5205E-27, -2.9141E-27, -2.2789E-27, &
      -2.0320E-27, -1.6590E-27, -1.3807E-27, -1.1759E-27, -1.0211E-27, -9.0077E-28, &
      -8.1225E-28 /)
    REAL, PARAMETER :: b1_3_O1D(dim55) = (/ &
      -9.2856E-24, -8.5014E-24, -8.3603E-24, -4.3786E-24, -2.5713E-24, 2.7939E-24, &
      4.6845E-24, 8.9675E-24, 9.9141E-24, 1.1877E-23, 1.2178E-23, 1.2282E-23, &
      1.2291E-23, 1.1561E-23, 1.1189E-23, 1.0248E-23, 9.9323E-24, 8.8306E-24, &
      8.5838E-24, 7.6822E-24, 7.4491E-24, 6.6507E-24, 6.5451E-24, 5.8593E-24, &
      5.8729E-24, 5.1104E-24, 5.1399E-24, 4.5557E-24, 4.6882E-24, 4.0090E-24, &
      4.2084E-24, 3.6761E-24, 3.8058E-24, 3.3042E-24, 3.4709E-24, 2.9923E-24, &
      3.1783E-24, 2.7265E-24, 2.9027E-24, 2.4928E-24, 2.3640E-24, 1.8860E-24, &
      1.5995E-24, 1.3076E-24, 1.1335E-24, 9.4856E-25, 8.4214E-25, 7.2271E-25, &
      6.7321E-25, 5.9376E-25, 5.3102E-25, 4.8227E-25, 4.4349E-25, 4.1185E-25, &
      3.8746E-25 /)

    REAL, PARAMETER :: a2_O1D(dim55) = (/ &
      -2.5820E-19, -2.3264E-19, -1.9660E-19, -1.5800E-19, -1.2268E-19, -9.3360E-20, &
      -7.0520E-20, -5.3360E-20, -4.0800E-20, -3.1640E-20, -2.4880E-20, -2.0000E-20, &
      -1.6320E-20, -1.3560E-20, -1.1440E-20, -9.7999E-21, -8.4800E-21, -7.4400E-21, &
      -6.5600E-21, -5.8800E-21, -5.2399E-21, -4.7600E-21, -4.3200E-21, -3.9600E-21, &
      -3.6001E-21, -3.3200E-21, -3.0400E-21, -2.8400E-21, -2.6000E-21, -2.4000E-21, &
      -2.2800E-21, -2.0799E-21, -1.9201E-21, -1.7999E-21, -1.7200E-21, -1.5600E-21, &
      -1.4800E-21, -1.3600E-21, -1.2800E-21, -1.2000E-21, -9.8400E-22, -7.0401E-22, &
      -5.1200E-22, -3.6800E-22, -2.6400E-22, -1.9200E-22, -1.3601E-22, -9.5994E-23, &
      -7.1998E-23, -5.6000E-23, -3.2004E-23, -3.2004E-23, -1.5998E-23, -1.5998E-23, &
      -7.9988E-24 /)
    REAL, PARAMETER :: b2_O1D(dim55) = (/ &
       5.4419E-18,  5.3652E-18,  5.1670E-18,  4.8582E-18,  4.4873E-18,  4.1062E-18, &
       3.7522E-18,  3.4433E-18,  3.1858E-18,  2.9751E-18,  2.8027E-18,  2.6661E-18, &
       2.5539E-18,  2.4628E-18,  2.3875E-18,  2.3252E-18,  2.2717E-18,  2.2270E-18, &
       2.1870E-18,  2.1543E-18,  2.1220E-18,  2.0966E-18,  2.0722E-18,  2.0513E-18, &
       2.0295E-18,  2.0119E-18,  1.9935E-18,  1.9799E-18,  1.9630E-18,  1.9484E-18, &
       1.9393E-18,  1.9237E-18,  1.9109E-18,  1.9009E-18,  1.8941E-18,  1.8800E-18, &
       1.8727E-18,  1.8616E-18,  1.8539E-18,  1.8461E-18,  1.8244E-18,  1.7928E-18, &
       1.7687E-18,  1.7488E-18,  1.7331E-18,  1.7214E-18,  1.7116E-18,  1.7040E-18, &
       1.6992E-18,  1.6958E-18,  1.6904E-18,  1.6904E-18,  1.6864E-18,  1.6864E-18, &
       1.6842E-18 /)
    REAL, PARAMETER :: a3_O1D(dim55) = (/ &
      -2.7854E-21, -2.3353E-21, -1.8568E-21, -1.4291E-21, -1.0859E-21, -8.2668E-22, &
      -6.3764E-22, -5.0120E-22, -4.0216E-22, -3.2987E-22, -2.7527E-22, -2.3363E-22, &
      -2.0088E-22, -1.7452E-22, -1.5381E-22, -1.3578E-22, -1.2141E-22, -1.0903E-22, &
      -9.8681E-23, -8.9457E-23, -8.1869E-23, -7.5080E-23, -6.9117E-23, -6.3898E-23, &
      -5.9105E-23, -5.5112E-23, -5.1138E-23, -4.8323E-23, -4.5128E-23, -4.2332E-23, &
      -3.9952E-23, -3.7540E-23, -3.5543E-23, -3.3945E-23, -3.1962E-23, -3.0352E-23, &
      -2.9153E-23, -2.7556E-23, -2.6368E-23, -2.5160E-23, -2.2125E-23, -1.8131E-23, &
      -1.5176E-23, -1.2859E-23, -1.1031E-23, -9.5847E-24, -8.3067E-24, -7.2684E-24, &
      -6.4696E-24, -5.5911E-24, -4.9521E-24, -4.3931E-24, -3.8369E-24, -3.4344E-24, &
      -3.0352E-24 /)
    REAL, PARAMETER :: b3_O1D(dim55) = (/ &
      5.6707E-19, 5.5558E-19, 5.3138E-19, 4.9904E-19, 4.6449E-19, 4.3192E-19, &
      4.0342E-19, 3.7944E-19, 3.5955E-19, 3.4323E-19, 3.2953E-19, 3.1804E-19, &
      3.0818E-19, 2.9959E-19, 2.9232E-19, 2.8554E-19, 2.7978E-19, 2.7450E-19, &
      2.6983E-19, 2.6544E-19, 2.6164E-19, 2.5806E-19, 2.5478E-19, 2.5177E-19, &
      2.4889E-19, 2.4638E-19, 2.4380E-19, 2.4189E-19, 2.3965E-19, 2.3762E-19, &
      2.3583E-19, 2.3396E-19, 2.3236E-19, 2.3103E-19, 2.2934E-19, 2.2793E-19, &
      2.2685E-19, 2.2537E-19, 2.2424E-19, 2.2306E-19, 2.2002E-19, 2.1552E-19, &
      2.1182E-19, 2.0863E-19, 2.0588E-19, 2.0352E-19, 2.0128E-19, 1.9933E-19, &
      1.9773E-19, 1.9586E-19, 1.9442E-19, 1.9309E-19, 1.9170E-19, 1.9064E-19, &
      1.8954E-19 /)
    REAL, PARAMETER :: a4_O1D(4) = (/ 5.8054E-20, -3.9682E-23, 1.3354E-26, -1.6655E-30 /)
    REAL, PARAMETER :: a5_O1D(4) = (/ 1.3351E-21, -6.1729E-25, 1.6203E-28, -1.7466E-32 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_O1D(dim58) = (/ &
      -7.0191E-03, -7.0191E-03, -7.0191E-03, -8.1775E-03, -9.0525E-03, -1.0315E-02, &
      -1.1296E-02, -1.1692E-02, -1.2369E-02, -1.2926E-02, -1.2667E-02, -1.3050E-02, &
      -1.2699E-02, -1.2539E-02, -1.2559E-02, -1.2045E-02, -1.2295E-02, -1.2351E-02, &
      -1.2501E-02, -1.2481E-02, -1.2809E-02, -1.2848E-02, -1.2163E-02, -1.1147E-02, &
      -1.0137E-02, -7.6925E-03, -5.2963E-03, -2.6730E-03, -2.2028E-04, 2.1178E-03, &
      3.7890E-03, 4.4592E-03, 3.6196E-03, 1.6453E-03, -1.3751E-03, -4.4430E-03, &
      -8.0093E-03, -1.0779E-02, -1.2009E-02, -1.1375E-02, -8.2903E-03, -3.7170E-03, &
      3.1828E-03, 9.6868E-03, 1.6113E-02, 2.0800E-02, 2.2935E-02, 2.2651E-02, &
      2.1574E-02, 2.0290E-02, 2.0017E-02, 2.1864E-02, 2.5309E-02, 2.9336E-02, &
      3.2886E-02, 3.4905E-02, 3.6604E-02, 4.0160E-02 /)
    REAL, PARAMETER :: c0_1_2_O1D(dim58) = (/ &
      3.1254E-01, 3.1254E-01, 3.1254E-01, 3.6421E-01, 4.0341E-01, 4.6024E-01, &
      5.0458E-01, 5.2252E-01, 5.5342E-01, 5.7890E-01, 5.6701E-01, 5.8472E-01, &
      5.6840E-01, 5.6096E-01, 5.6190E-01, 5.3773E-01, 5.4953E-01, 5.5220E-01, &
      5.5935E-01, 5.5836E-01, 5.7414E-01, 5.7598E-01, 5.4284E-01, 4.9348E-01, &
      4.4419E-01, 3.2440E-01, 2.0651E-01, 7.6914E-02, -4.4740E-02, -1.6118E-01, &
      -2.4473E-01, -2.7838E-01, -2.3607E-01, -1.3616E-01, 1.7271E-02, 1.7373E-01, &
      3.5633E-01, 4.9868E-01, 5.6214E-01, 5.2933E-01, 3.6891E-01, 1.3019E-01, &
      -2.3136E-01, -5.7347E-01, -9.1277E-01, -1.1612E+00, -1.2748E+00, -1.2596E+00, &
      -1.2019E+00, -1.1328E+00, -1.1181E+00, -1.2182E+00, -1.4056E+00, -1.6255E+00, &
      -1.8200E+00, -1.9310E+00, -2.0248E+00, -2.2218E+00 /)
    REAL, PARAMETER :: c0_2_1_O1D(dim58) = (/ &
      8.0025E-04, 8.0025E-04, 8.0025E-04, -4.2989E-03, -1.7255E-03, -1.4436E-03, &
      -2.4649E-03, -2.5963E-03, -2.9353E-03, -2.8235E-03, -5.4407E-05, -3.7774E-04, &
      7.6838E-05, 4.3952E-03, 3.2172E-03, 3.2044E-03, 5.0126E-03, 5.1538E-03, &
      5.0230E-03, 5.7908E-03, 7.5288E-03, 5.7935E-03, 6.8681E-03, 5.7070E-03, &
      5.8363E-03, 6.7479E-03, 3.9212E-03, 4.5167E-03, 1.3028E-03, 1.6390E-03, &
      6.7867E-04, -1.5781E-03, -1.9784E-03, -1.4371E-03, -1.6170E-03, -2.1123E-03, &
      -3.3934E-04, 1.9431E-03, 5.8769E-03, 1.2693E-02, 1.5833E-02, 2.1979E-02, &
      2.2427E-02, 1.9646E-02, 1.3546E-02, 1.1175E-02, 5.9491E-03, 2.3821E-03, &
      4.9171E-03, 8.4691E-03, 4.6355E-03, -6.7929E-03, -1.3726E-02, -3.1842E-02, &
      -4.3998E-02, -3.8830E-02, -2.5365E-02, -2.4250E-03 /)
    REAL, PARAMETER :: c0_2_2_O1D(dim58) = (/ &
      -5.4338E-03, -5.4338E-03, -5.4338E-03, 2.2199E-01, 1.0670E-01, 9.4016E-02, &
      1.4018E-01, 1.4614E-01, 1.6160E-01, 1.5648E-01, 2.9102E-02, 4.4040E-02, &
      2.2948E-02, -1.7829E-01, -1.2316E-01, -1.2256E-01, -2.0790E-01, -2.1460E-01, &
      -2.0837E-01, -2.4507E-01, -3.2849E-01, -2.4485E-01, -2.9687E-01, -2.4043E-01, &
      -2.4675E-01, -2.9141E-01, -1.5234E-01, -1.8176E-01, -2.2346E-02, -3.9092E-02, &
      8.9268E-03, 1.2222E-01, 1.4239E-01, 1.1500E-01, 1.2414E-01, 1.4940E-01, &
      5.8625E-02, -5.8691E-02, -2.6168E-01, -6.1477E-01, -7.7800E-01, -1.0989E+00, &
      -1.1223E+00, -9.7603E-01, -6.5396E-01, -5.2830E-01, -2.5028E-01, -5.9807E-02, &
      -1.9569E-01, -3.8678E-01, -1.7977E-01, 4.3966E-01, 8.1682E-01, 1.8059E+00, &
      2.4721E+00, 2.1879E+00, 1.4446E+00, 1.7371E-01 /)
    REAL, PARAMETER :: c2_O1D(4) = (/ 1.00,  0.08,  0.20,  0.00 /)
    REAL, PARAMETER :: c3_O1D(4) = (/ 1.00, -0.03, -0.03, -0.02 /)
    REAL, PARAMETER :: c4_O1D(4) = (/ 1.00,  0.58,  0.38, -1.24 /)
    REAL, PARAMETER :: c5_O1D(4) = (/ 1.00,  2.29,  4.84,  1.32 /)

    jval_gp(ip_O1D)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_O1D(0) = &
          p2(1.,c0_1_1_O1D(i0(j,k))*dlv2(j,k) + &
          c0_1_2_O1D(i0(j,k)), &
          c0_2_1_O1D(i0(j,k))*dlv2(j,k) + &
          c0_2_2_O1D(i0(j,k)), tnorm_sr(j,k)) * &
          p1(a0_1_1_O1D(i0(j,k))*dlv2(j,k) + &
          a0_1_2_O1D(i0(j,k)), &
          a0_2_1_O1D(i0(j,k))*dlv2(j,k) + &
          a0_2_2_O1D(i0(j,k)),v3_du1(j,k))
        sig_O1D(1) = &
          (p1(b1_1_O1D(i1(j,k)),a1_1_O1D(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_O1D(i1(j,k)),a1_2_O1D(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k) + &
          p1(b1_3_O1D(i1(j,k)),a1_3_O1D(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k)**2)
        sig_O1D(2) = &
          p3(c2_O1D(1),c2_O1D(2),c2_O1D(3),c2_O1D(4),tnorm(j,k))* &
          p1(b2_O1D(i2(j,k)), a2_O1D(i2(j,k)), &
          v3_du1(j,k))
        sig_O1D(3) = &
          p3(c3_O1D(1),c3_O1D(2),c3_O1D(3),c3_O1D(4),tnorm(j,k))* &
          p1(b3_O1D(i3(j,k)), a3_O1D(i3(j,k)), &
          v3_du2(j,k))
        sig_O1D(4) = &
          p3(c4_O1D(1),c4_O1D(2),c4_O1D(3),c4_O1D(4),tnorm(j,k))* &
          p3(a4_O1D(1),a4_O1D(2),a4_O1D(3), &
          a4_O1D(4),v3_du2(j,k))
        sig_O1D(5) = &
          p3(c5_O1D(1),c5_O1D(2),c5_O1D(3),c5_O1D(4),tnorm(j,k))* &
          p3(a5_O1D(1),a5_O1D(2),a5_O1D(3), &
          a5_O1D(4),v3_du2(j,k))
        ! 0.87 = fixed quantum yield in intervals 0 and 1 (Talukdar et al. 1998)
        dj = 0. &
          + sig_O1D(0) * fint(j,k,0) * 0.87 &
          + sig_O1D(1) * fint(j,k,1) * 0.87 &
          + sig_O1D(2) * fint(j,k,2) &
          + sig_O1D(3) * fint(j,k,3) &
          + sig_O1D(4) * fint(j,k,4) &
          + sig_O1D(5) * fint(j,k,5)

        jval_gp(ip_O1D)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_O1D

  ! **************************************************************************

  SUBROUTINE jval_cal_H2O2(jrow)

    ! H2O2 -> OH + OH JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_H2O2

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_H2O2(dim58) = (/ &
      -2.0796E-21, -2.2623E-21, -2.4819E-21, -2.7060E-21, -2.9318E-21, -3.1780E-21, &
      -3.4292E-21, -3.6830E-21, -3.9494E-21, -4.2335E-21, -4.5166E-21, -4.8262E-21, &
      -5.3484E-21, -6.3108E-21, -6.4069E-21, -6.7321E-21, -7.2476E-21, -7.3461E-21, &
      -7.6540E-21, -8.1536E-21, -8.2195E-21, -8.4956E-21, -8.9515E-21, -9.0080E-21, &
      -9.2647E-21, -9.1794E-21, -9.2878E-21, -9.5659E-21, -9.8229E-21, -1.0051E-20, &
      -1.0241E-20, -1.0388E-20, -1.0477E-20, -1.0535E-20, -1.0531E-20, -1.0517E-20, &
      -1.0508E-20, -1.0488E-20, -1.0497E-20, -1.0527E-20, -1.0563E-20, -1.0609E-20, &
      -1.0604E-20, -1.0539E-20, -1.0371E-20, -1.0072E-20, -9.6342E-21, -9.1113E-21, &
      -8.5022E-21, -7.8659E-21, -7.2385E-21, -6.6201E-21, -6.0122E-21, -5.4134E-21, &
      -4.8012E-21, -4.1789E-21, -3.4911E-21, -2.8800E-21 /)
    REAL, PARAMETER :: a0_1_2_H2O2(dim58) = (/ &
      6.6032E-19, 6.6840E-19, 6.7815E-19, 6.8814E-19, 6.9826E-19, 7.0934E-19, &
      7.2069E-19, 7.3221E-19, 7.4436E-19, 7.5737E-19, 7.7039E-19, 7.8470E-19, &
      8.0893E-19, 8.5378E-19, 8.5827E-19, 8.7356E-19, 8.9789E-19, 9.0256E-19, &
      9.1722E-19, 9.4110E-19, 9.4426E-19, 9.5757E-19, 9.7963E-19, 9.8238E-19, &
      9.9491E-19, 9.9073E-19, 9.9606E-19, 1.0098E-18, 1.0225E-18, 1.0339E-18, &
      1.0434E-18, 1.0508E-18, 1.0553E-18, 1.0582E-18, 1.0580E-18, 1.0573E-18, &
      1.0568E-18, 1.0558E-18, 1.0563E-18, 1.0578E-18, 1.0597E-18, 1.0621E-18, &
      1.0619E-18, 1.0584E-18, 1.0495E-18, 1.0337E-18, 1.0104E-18, 9.8248E-19, &
      9.4983E-19, 9.1560E-19, 8.8172E-19, 8.4820E-19, 8.1513E-19, 7.8243E-19, &
      7.4889E-19, 7.1466E-19, 6.7669E-19, 6.4284E-19 /)
    REAL, PARAMETER :: a0_2_1_H2O2(dim58) = (/ &
      7.1582E-24, 7.6273E-24, 8.3094E-24, 9.0476E-24, 9.6038E-24, 1.0360E-23, &
      1.1102E-23, 1.1777E-23, 1.2489E-23, 1.3256E-23, 1.3973E-23, 1.4796E-23, &
      1.8777E-23, 2.8690E-23, 2.5739E-23, 2.6039E-23, 2.8869E-23, 2.6170E-23, &
      2.6305E-23, 2.8705E-23, 2.6154E-23, 2.6074E-23, 2.7957E-23, 2.5651E-23, &
      2.5467E-23, 2.1933E-23, 2.0482E-23, 2.0822E-23, 2.1077E-23, 2.1296E-23, &
      2.1369E-23, 2.1439E-23, 2.1341E-23, 2.1181E-23, 2.0849E-23, 2.0537E-23, &
      2.0277E-23, 1.9932E-23, 1.9663E-23, 1.9472E-23, 1.9191E-23, 1.8990E-23, &
      1.8575E-23, 1.8058E-23, 1.7252E-23, 1.6199E-23, 1.4819E-23, 1.3390E-23, &
      1.1816E-23, 1.0309E-23, 8.9340E-24, 7.6670E-24, 6.4845E-24, 5.4249E-24, &
      4.4023E-24, 3.5176E-24, 2.7088E-24, 2.1096E-24 /)
    REAL, PARAMETER :: a0_2_2_H2O2(dim58) = (/ &
      -5.1869E-22, -5.3943E-22, -5.6971E-22, -6.0263E-22, -6.2756E-22, -6.6157E-22, &
      -6.9512E-22, -7.2578E-22, -7.5821E-22, -7.9337E-22, -8.2633E-22, -8.6436E-22, &
      -1.0491E-21, -1.5110E-21, -1.3729E-21, -1.3870E-21, -1.5206E-21, -1.3927E-21, &
      -1.3991E-21, -1.5138E-21, -1.3914E-21, -1.3875E-21, -1.4787E-21, -1.3666E-21, &
      -1.3576E-21, -1.1845E-21, -1.1130E-21, -1.1298E-21, -1.1425E-21, -1.1534E-21, &
      -1.1570E-21, -1.1606E-21, -1.1556E-21, -1.1475E-21, -1.1306E-21, -1.1148E-21, &
      -1.1014E-21, -1.0837E-21, -1.0698E-21, -1.0599E-21, -1.0453E-21, -1.0348E-21, &
      -1.0131E-21, -9.8588E-22, -9.4331E-22, -8.8751E-22, -8.1412E-22, -7.3781E-22, &
      -6.5342E-22, -5.7235E-22, -4.9810E-22, -4.2943E-22, -3.6510E-22, -3.0724E-22, &
      -2.5121E-22, -2.0254E-22, -1.5790E-22, -1.2471E-22 /)
    REAL, PARAMETER :: a1_1_H2O2(dim55) = (/ &
      4.5944E-21, 4.3238E-21, 4.0826E-21, 3.6934E-21, 3.3591E-21, 2.9946E-21, &
      2.6758E-21, 2.3885E-21, 2.1257E-21, 1.9264E-21, 1.7194E-21, 1.5805E-21, &
      1.4232E-21, 1.3260E-21, 1.2021E-21, 1.1368E-21, 1.0350E-21, 9.8959E-22, &
      9.0437E-22, 8.7330E-22, 8.0074E-22, 7.7839E-22, 7.1647E-22, 7.0115E-22, &
      6.4645E-22, 6.3717E-22, 5.8632E-22, 5.8220E-22, 5.3728E-22, 5.3596E-22, &
      4.9448E-22, 4.9644E-22, 4.5685E-22, 4.6143E-22, 4.2511E-22, 4.2982E-22, &
      3.9736E-22, 4.0350E-22, 3.7313E-22, 3.7993E-22, 3.3880E-22, 3.0134E-22, &
      2.6578E-22, 2.4289E-22, 2.1840E-22, 2.0325E-22, 1.8501E-22, 1.7444E-22, &
      1.5342E-22, 1.4278E-22, 1.3320E-22, 1.2418E-22, 1.1627E-22, 1.0876E-22, &
      1.0201E-22 /)
    REAL, PARAMETER :: b1_1_H2O2(dim55) = (/ &
      2.2346E-19, 2.2427E-19, 2.2560E-19, 2.2871E-19, 2.3222E-19, 2.3696E-19, &
      2.4190E-19, 2.4708E-19, 2.5246E-19, 2.5705E-19, 2.6233E-19, 2.6622E-19, &
      2.7101E-19, 2.7422E-19, 2.7862E-19, 2.8110E-19, 2.8522E-19, 2.8718E-19, &
      2.9105E-19, 2.9254E-19, 2.9621E-19, 2.9739E-19, 3.0083E-19, 3.0172E-19, &
      3.0503E-19, 3.0561E-19, 3.0894E-19, 3.0922E-19, 3.1239E-19, 3.1249E-19, &
      3.1562E-19, 3.1547E-19, 3.1865E-19, 3.1827E-19, 3.2138E-19, 3.2096E-19, &
      3.2390E-19, 3.2333E-19, 3.2623E-19, 3.2556E-19, 3.2970E-19, 3.3393E-19, &
      3.3839E-19, 3.4155E-19, 3.4524E-19, 3.4771E-19, 3.5091E-19, 3.5289E-19, &
      3.5711E-19, 3.5938E-19, 3.6154E-19, 3.6368E-19, 3.6566E-19, 3.6764E-19, &
      3.6950E-19 /)
    REAL, PARAMETER :: a1_2_H2O2(dim55) = (/ &
      -6.3423E-24, -1.7278E-24, -4.2555E-25, 2.6789E-24, 3.6136E-24, 4.9067E-24, &
      5.3034E-24, 5.4090E-24, 5.5160E-24, 4.9653E-24, 5.0082E-24, 4.2811E-24, &
      4.3035E-24, 3.6056E-24, 3.6599E-24, 3.0008E-24, 3.1217E-24, 2.5278E-24, &
      2.6784E-24, 2.1547E-24, 2.3242E-24, 1.8591E-24, 2.0270E-24, 1.6180E-24, &
      1.7953E-24, 1.4191E-24, 1.5996E-24, 1.2498E-24, 1.4337E-24, 1.1108E-24, &
      1.2867E-24, 9.9076E-25, 1.1675E-24, 8.8800E-25, 1.0587E-24, 8.0910E-25, &
      9.6103E-25, 7.3445E-25, 8.7710E-25, 6.6271E-25, 6.8056E-25, 5.2764E-25, &
      4.6532E-25, 3.7281E-25, 3.4224E-25, 2.8048E-25, 2.6649E-25, 2.2163E-25, &
      2.5235E-25, 2.3322E-25, 2.1672E-25, 2.0369E-25, 1.9194E-25, 1.8189E-25, &
      1.7270E-25 /)
    REAL, PARAMETER :: b1_2_H2O2(dim55) = (/ &
      -3.0824E-22, -3.2208E-22, -3.2924E-22, -3.5408E-22, -3.6389E-22, -3.8070E-22, &
      -3.8685E-22, -3.8875E-22, -3.9095E-22, -3.7828E-22, -3.7937E-22, -3.5901E-22, &
      -3.5970E-22, -3.3667E-22, -3.3860E-22, -3.1355E-22, -3.1845E-22, -2.9291E-22, &
      -2.9976E-22, -2.7462E-22, -2.8319E-22, -2.5853E-22, -2.6785E-22, -2.4413E-22, &
      -2.5486E-22, -2.3115E-22, -2.4298E-22, -2.1919E-22, -2.3216E-22, -2.0859E-22, &
      -2.2187E-22, -1.9878E-22, -2.1301E-22, -1.8981E-22, -2.0441E-22, -1.8244E-22, &
      -1.9619E-22, -1.7512E-22, -1.8874E-22, -1.6773E-22, -1.6952E-22, -1.5225E-22, &
      -1.4442E-22, -1.3166E-22, -1.2706E-22, -1.1699E-22, -1.1454E-22, -1.0610E-22, &
      -1.1226E-22, -1.0819E-22, -1.0446E-22, -1.0136E-22, -9.8421E-23, -9.5778E-23, &
      -9.3246E-23 /)
    REAL, PARAMETER :: a2_H2O2(dim55) = (/ &
      -1.5956E-21, -1.3840E-21, -1.1240E-21, -8.6760E-22, -6.4480E-22, -4.6960E-22, &
      -3.3880E-22, -2.4480E-22, -1.7920E-22, -1.3320E-22, -1.0120E-22, -7.8400E-23, &
      -6.2000E-23, -5.0800E-23, -4.2000E-23, -3.5200E-23, -3.0400E-23, -2.6400E-23, &
      -2.3200E-23, -2.0800E-23, -1.8400E-23, -1.6800E-23, -1.5200E-23, -1.3600E-23, &
      -1.2800E-23, -1.1600E-23, -1.0800E-23, -1.0000E-23, -8.8001E-24, -8.7998E-24, &
      -7.6000E-24, -7.6000E-24, -6.8000E-24, -6.4000E-24, -5.5999E-24, -5.5999E-24, &
      -5.1999E-24, -4.8002E-24, -4.3999E-24, -4.3999E-24, -3.4400E-24, -2.4800E-24, &
      -1.8400E-24, -1.2800E-24, -9.5998E-25, -6.3997E-25, -4.8002E-25, -3.2002E-25, &
      -3.2002E-25, -1.6001E-25, -7.9939E-26, -1.6001E-25, -0.0000E+00, -8.0004E-26, &
      -8.0004E-26 /)
    REAL, PARAMETER :: b2_H2O2(dim55) = (/ &
       3.2657E-20,  3.2022E-20,  3.0592E-20,  2.8541E-20,  2.6201E-20,  2.3924E-20, &
       2.1896E-20,  2.0204E-20,  1.8860E-20,  1.7802E-20,  1.6986E-20,  1.6347E-20, &
       1.5847E-20,  1.5477E-20,  1.5165E-20,  1.4907E-20,  1.4712E-20,  1.4540E-20, &
       1.4395E-20,  1.4279E-20,  1.4158E-20,  1.4073E-20,  1.3985E-20,  1.3892E-20, &
       1.3843E-20,  1.3768E-20,  1.3715E-20,  1.3661E-20,  1.3576E-20,  1.3576E-20, &
       1.3486E-20,  1.3486E-20,  1.3421E-20,  1.3388E-20,  1.3320E-20,  1.3320E-20, &
       1.3284E-20,  1.3246E-20,  1.3208E-20,  1.3208E-20,  1.3112E-20,  1.3003E-20, &
       1.2923E-20,  1.2846E-20,  1.2797E-20,  1.2745E-20,  1.2717E-20,  1.2687E-20, &
       1.2687E-20,  1.2653E-20,  1.2635E-20,  1.2654E-20,  1.2614E-20,  1.2635E-20, &
       1.2635E-20 /)
    REAL, PARAMETER :: a3_H2O2(dim55) = (/ &
      -1.6631E-23, -1.4231E-23, -1.1582E-23, -9.1664E-24, -7.1765E-24, -5.6430E-24, &
      -4.4986E-24, -3.6542E-24, -3.0232E-24, -2.5439E-24, -2.1814E-24, -1.8890E-24, &
      -1.6613E-24, -1.4656E-24, -1.3144E-24, -1.1741E-24, -1.0663E-24, -9.7045E-25, &
      -8.8294E-25, -8.1070E-25, -7.5079E-25, -6.9090E-25, -6.4323E-25, -5.9504E-25, &
      -5.5912E-25, -5.2316E-25, -4.8742E-25, -4.5926E-25, -4.3530E-25, -4.0735E-25, &
      -3.8753E-25, -3.6741E-25, -3.4746E-25, -3.3146E-25, -3.1163E-25, -2.9952E-25, &
      -2.8755E-25, -2.7157E-25, -2.5968E-25, -2.5160E-25, -2.1965E-25, -1.8211E-25, &
      -1.5175E-25, -1.2940E-25, -1.1111E-25, -9.5848E-26, -8.3067E-26, -7.2685E-26, &
      -6.3898E-26, -5.5110E-26, -4.9522E-26, -4.3129E-26, -3.7571E-26, -3.3547E-26, &
      -2.9554E-26 /)
    REAL, PARAMETER :: b3_H2O2(dim55) = (/ &
      7.3619E-21, 7.3006E-21, 7.1667E-21, 6.9840E-21, 6.7837E-21, 6.5910E-21, &
      6.4185E-21, 6.2701E-21, 6.1434E-21, 6.0351E-21, 5.9442E-21, 5.8635E-21, &
      5.7950E-21, 5.7312E-21, 5.6781E-21, 5.6253E-21, 5.5821E-21, 5.5412E-21, &
      5.5018E-21, 5.4674E-21, 5.4373E-21, 5.4058E-21, 5.3795E-21, 5.3518E-21, &
      5.3302E-21, 5.3076E-21, 5.2843E-21, 5.2653E-21, 5.2485E-21, 5.2282E-21, &
      5.2133E-21, 5.1977E-21, 5.1817E-21, 5.1684E-21, 5.1515E-21, 5.1409E-21, &
      5.1301E-21, 5.1153E-21, 5.1040E-21, 5.0961E-21, 5.0641E-21, 5.0218E-21, &
      4.9838E-21, 4.9530E-21, 4.9255E-21, 4.9006E-21, 4.8782E-21, 4.8587E-21, &
      4.8411E-21, 4.8224E-21, 4.8098E-21, 4.7946E-21, 4.7807E-21, 4.7701E-21, &
      4.7591E-21 /)
    REAL, PARAMETER :: a4_H2O2(3) = (/ 3.4815E-21, -3.7142E-25, 6.5669E-29 /)
    REAL, PARAMETER :: a5_H2O2(3) = (/ 1.2926E-21, -1.7659E-25, 2.4429E-29 /)
    REAL, PARAMETER :: a6_H2O2(2) = (/ 3.8026E-23, -5.8981E-28 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_H2O2(dim58) = (/ &
      -1.9755E-04, 1.9754E-04, -1.1887E-04, 2.0547E-05, -9.8569E-05, -4.0315E-05, &
      -1.1887E-04, 1.1950E-04, -1.3944E-04, -2.6773E-03, -7.4643E-03, -7.6696E-03, &
      -7.5775E-03, -8.0107E-03, -8.3656E-03, -8.5453E-03, -9.4767E-03, -9.7457E-03, &
      -1.0328E-02, -1.0687E-02, -1.1121E-02, -1.0982E-02, -1.0579E-02, -1.0153E-02, &
      -9.1310E-03, -7.8063E-03, -6.7677E-03, -5.9642E-03, -5.1789E-03, -5.4050E-03, &
      -6.1203E-03, -7.3522E-03, -9.2851E-03, -1.1287E-02, -1.3306E-02, -1.4660E-02, &
      -1.4989E-02, -1.3948E-02, -1.1629E-02, -7.8479E-03, -3.2903E-03, 1.7042E-03, &
      5.5600E-03, 9.0576E-03, 1.0556E-02, 1.1263E-02, 1.1234E-02, 1.2077E-02, &
      1.4181E-02, 1.8238E-02, 2.3593E-02, 2.9465E-02, 3.4337E-02, 3.8875E-02, &
      4.5866E-02, 6.2141E-02, 9.8341E-02, 1.4280E-01 /)
    REAL, PARAMETER :: c0_1_2_H2O2(dim58) = (/ &
      8.8664E-03, -8.7942E-03, 5.4125E-03, -8.7526E-04, 4.5207E-03, 1.8701E-03, &
      5.4600E-03, -5.4810E-03, 6.4562E-03, 1.2396E-01, 3.4656E-01, 3.5614E-01, &
      3.5182E-01, 3.7222E-01, 3.8901E-01, 3.9755E-01, 4.4198E-01, 4.5486E-01, &
      4.8287E-01, 5.0022E-01, 5.2125E-01, 5.1448E-01, 4.9476E-01, 4.7389E-01, &
      4.2348E-01, 3.5791E-01, 3.0629E-01, 2.6620E-01, 2.2685E-01, 2.3822E-01, &
      2.7435E-01, 3.3681E-01, 4.3519E-01, 5.3750E-01, 6.4107E-01, 7.1079E-01, &
      7.2780E-01, 6.7379E-01, 5.5296E-01, 3.5520E-01, 1.1593E-01, -1.4728E-01, &
      -3.5125E-01, -5.3698E-01, -6.1687E-01, -6.5466E-01, -6.5311E-01, -6.9856E-01, &
      -8.1239E-01, -1.0327E+00, -1.3245E+00, -1.6457E+00, -1.9132E+00, -2.1632E+00, &
      -2.5498E+00, -3.4531E+00, -5.4694E+00, -7.9546E+00 /)
    REAL, PARAMETER :: c0_2_1_H2O2(dim58) = (/ &
      1.2165E-04, -1.2164E-04, 1.9208E-05, -9.3793E-04, 9.4428E-04, -3.7774E-04, &
      -2.1448E-04, 2.4006E-04, -7.6526E-04, -3.9054E-04, -4.3463E-03, -3.9181E-03, &
      -1.7479E-03, -2.3753E-03, -3.8124E-03, -2.1961E-03, -2.2184E-03, -2.8970E-03, &
      -1.7927E-03, -3.3831E-03, -2.2219E-03, -1.8024E-03, -5.6660E-04, -2.1928E-03, &
      7.0416E-05, -1.0884E-03, -3.0730E-04, 5.7619E-04, -1.3797E-03, 2.0167E-04, &
      -2.9958E-03, -1.8796E-03, -1.0498E-03, -2.7886E-03, -1.7254E-03, 1.9205E-04, &
      3.7713E-03, 4.9232E-03, 1.0384E-02, 1.1696E-02, 1.3118E-02, 1.2596E-02, &
      8.2367E-03, 8.0289E-03, 5.5384E-03, 7.6878E-03, 7.1321E-03, 6.9018E-03, &
      4.4243E-03, -5.6244E-03, -1.5964E-02, -2.9691E-02, -3.3559E-02, -2.8451E-02, &
      -1.0700E-02, 2.1041E-02, 9.9543E-02, 2.3576E-01 /)
    REAL, PARAMETER :: c0_2_2_H2O2(dim58) = (/ &
      -3.6959E-03, 7.1793E-03, 8.5521E-04, 4.4022E-02, -4.1242E-02, 1.8910E-02, &
      1.1449E-02, -9.4143E-03, 3.6931E-02, 1.9581E-02, 2.0352E-01, 1.8353E-01, &
      8.1746E-02, 1.1129E-01, 1.7927E-01, 1.0250E-01, 1.0356E-01, 1.3606E-01, &
      8.2946E-02, 1.5976E-01, 1.0345E-01, 8.3018E-02, 2.2585E-02, 1.0243E-01, &
      -9.1447E-03, 4.8219E-02, 9.3963E-03, -3.4690E-02, 6.3302E-02, -1.6243E-02, &
      1.4523E-01, 8.8636E-02, 4.6399E-02, 1.3525E-01, 8.0712E-02, -1.8037E-02, &
      -2.0308E-01, -2.6287E-01, -5.4740E-01, -6.1602E-01, -6.9067E-01, -6.6315E-01, &
      -4.3253E-01, -4.2150E-01, -2.8875E-01, -4.0375E-01, -3.7391E-01, -3.6149E-01, &
      -2.2746E-01, 3.1818E-01, 8.8171E-01, 1.6325E+00, 1.8449E+00, 1.5635E+00, &
      5.8184E-01, -1.1798E+00, -5.5523E+00, -1.3167E+01 /)
    REAL, PARAMETER :: c2_H2O2(3) = (/ 1.00,  0.21,  0.36 /)
    REAL, PARAMETER :: c3_H2O2(3) = (/ 1.00,  0.32,  0.54 /)
    REAL, PARAMETER :: c4_H2O2(3) = (/ 1.00,  0.42,  0.68 /)
    REAL, PARAMETER :: c5_H2O2(3) = (/ 1.00,  0.63,  1.03 /)
    REAL, PARAMETER :: c6_H2O2(3) = (/ 1.00,  0.78,  1.28 /)

    jval_gp(ip_H2O2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_H2O2(0) = &
          p2(1.,c0_1_1_H2O2(i0(j,k))*dlv2(j,k) + &
          c0_1_2_H2O2(i0(j,k)), &
          c0_2_1_H2O2(i0(j,k))*dlv2(j,k) + &
          c0_2_2_H2O2(i0(j,k)), tnorm_sr(j,k)) * &
          p1(a0_1_1_H2O2(i0(j,k))*dlv2(j,k) + &
          a0_1_2_H2O2(i0(j,k)), &
          a0_2_1_H2O2(i0(j,k))*dlv2(j,k) + &
          a0_2_2_H2O2(i0(j,k)),v3_du1(j,k))
        sig_H2O2(1) = &
          (p1(b1_1_H2O2(i1(j,k)),a1_1_H2O2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_H2O2(i1(j,k)),a1_2_H2O2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_H2O2(2) = &
          p2(c2_H2O2(1),c2_H2O2(2),c2_H2O2(3),tnorm(j,k))* &
          p1(b2_H2O2(i2(j,k)), a2_H2O2(i2(j,k)), &
          v3_du1(j,k))
        sig_H2O2(3) = &
          p2(c3_H2O2(1),c3_H2O2(2),c3_H2O2(3),tnorm(j,k))* &
          p1(b3_H2O2(i3(j,k)), a3_H2O2(i3(j,k)), &
          v3_du2(j,k))
        sig_H2O2(4) = &
          p2(c4_H2O2(1),c4_H2O2(2),c4_H2O2(3),tnorm(j,k))* &
          p2(a4_H2O2(1),a4_H2O2(2),a4_H2O2(3),v3_du2(j,k))
        sig_H2O2(5) = &
          p2(c5_H2O2(1),c5_H2O2(2),c5_H2O2(3),tnorm(j,k))* &
          p2(a5_H2O2(1),a5_H2O2(2),a5_H2O2(3),v3_du2(j,k))
        sig_H2O2(6) = &
          p2(c6_H2O2(1),c6_H2O2(2),c6_H2O2(3),tnorm(j,k))* &
          p1(a6_H2O2(1),a6_H2O2(2),v3_du2(j,k))
        dj = 0. &
          + sig_H2O2(0) * fint(j,k,0) &
          + sig_H2O2(1) * fint(j,k,1) &
          + sig_H2O2(2) * fint(j,k,2) &
          + sig_H2O2(3) * fint(j,k,3) &
          + sig_H2O2(4) * fint(j,k,4) &
          + sig_H2O2(5) * fint(j,k,5) &
          + sig_H2O2(6) * fint(j,k,6)

        jval_gp(ip_H2O2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,5))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_H2O2

  ! **************************************************************************

  SUBROUTINE jval_cal_NO2(jrow)

    ! NO2 -> NO + O cross section: JPL 1997 and Moortgat priv. com.; quantum yield: JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_NO2

    ! T-const parameters:
    REAL, PARAMETER :: a2_NO2(dim55) = (/ &
      1.8652E-21, 1.7260E-21, 1.4996E-21, 1.2412E-21, 9.9360E-22, 7.8160E-22, &
      6.1040E-22, 4.7840E-22, 3.7840E-22, 3.0280E-22, 2.4640E-22, 2.0360E-22, &
      1.7120E-22, 1.4520E-22, 1.2560E-22, 1.0960E-22, 9.6400E-23, 8.6001E-23, &
      7.6799E-23, 6.9599E-23, 6.2801E-23, 5.7200E-23, 5.2800E-23, 4.8000E-23, &
      4.4402E-23, 4.1199E-23, 3.8001E-23, 3.5199E-23, 3.2800E-23, 3.0399E-23, &
      2.8000E-23, 2.6400E-23, 2.4800E-23, 2.2802E-23, 2.1600E-23, 2.0000E-23, &
      1.8800E-23, 1.7200E-23, 1.6399E-23, 1.5600E-23, 1.2560E-23, 9.1197E-24, &
      6.5601E-24, 4.7201E-24, 3.4400E-24, 2.4800E-24, 1.7598E-24, 1.2801E-24, &
      9.6005E-25, 6.4003E-25, 4.7976E-25, 3.2002E-25, 2.4040E-25, 2.3988E-25, &
      8.0133E-26 /)
    REAL, PARAMETER :: b2_NO2(dim55) = (/ &
      5.0357E-20, 5.0775E-20, 5.2020E-20, 5.4087E-20, 5.6687E-20, 5.9443E-20, &
      6.2097E-20, 6.4473E-20, 6.6523E-20, 6.8262E-20, 6.9700E-20, 7.0898E-20, &
      7.1886E-20, 7.2744E-20, 7.3440E-20, 7.4048E-20, 7.4583E-20, 7.5030E-20, &
      7.5449E-20, 7.5794E-20, 7.6138E-20, 7.6434E-20, 7.6679E-20, 7.6957E-20, &
      7.7175E-20, 7.7376E-20, 7.7586E-20, 7.7776E-20, 7.7946E-20, 7.8121E-20, &
      7.8302E-20, 7.8427E-20, 7.8556E-20, 7.8721E-20, 7.8824E-20, 7.8965E-20, &
      7.9074E-20, 7.9222E-20, 7.9299E-20, 7.9377E-20, 7.9683E-20, 8.0071E-20, &
      8.0393E-20, 8.0647E-20, 8.0839E-20, 8.0996E-20, 8.1122E-20, 8.1212E-20, &
      8.1277E-20, 8.1345E-20, 8.1381E-20, 8.1419E-20, 8.1439E-20, 8.1439E-20, &
      8.1483E-20 /)
    REAL, PARAMETER :: a3_NO2(dim55) = (/ &
      1.7533E-22, 1.5377E-22, 1.2860E-22, 1.0465E-22, 8.4265E-23, 6.8291E-23, &
      5.6332E-23, 4.7125E-23, 3.9936E-23, 3.4345E-23, 2.9964E-23, 2.6358E-23, &
      2.3562E-23, 2.1166E-23, 1.9177E-23, 1.7173E-23, 1.5974E-23, 1.4777E-23, &
      1.3584E-23, 1.2380E-23, 1.1582E-23, 1.0783E-23, 1.0388E-23, 9.5846E-24, &
      8.7856E-24, 8.3866E-24, 7.9908E-24, 7.5876E-24, 7.1886E-24, 6.7891E-24, &
      6.3921E-24, 5.9906E-24, 5.9906E-24, 5.5911E-24, 5.1936E-24, 5.1916E-24, &
      4.7926E-24, 4.7921E-24, 4.3948E-24, 4.3931E-24, 3.8338E-24, 3.1949E-24, &
      2.7156E-24, 2.3163E-24, 1.9983E-24, 1.6773E-24, 1.5176E-24, 1.3578E-24, &
      1.1182E-24, 1.0383E-24, 8.7861E-25, 7.9871E-25, 6.3952E-25, 6.3901E-25, &
      4.7920E-25 /)
    REAL, PARAMETER :: b3_NO2(dim55) = (/ &
      1.2290E-19, 1.2345E-19, 1.2473E-19, 1.2654E-19, 1.2859E-19, 1.3060E-19, &
      1.3240E-19, 1.3402E-19, 1.3546E-19, 1.3672E-19, 1.3782E-19, 1.3882E-19, &
      1.3966E-19, 1.4044E-19, 1.4114E-19, 1.4189E-19, 1.4237E-19, 1.4288E-19, &
      1.4342E-19, 1.4399E-19, 1.4439E-19, 1.4482E-19, 1.4503E-19, 1.4550E-19, &
      1.4598E-19, 1.4623E-19, 1.4648E-19, 1.4676E-19, 1.4704E-19, 1.4733E-19, &
      1.4763E-19, 1.4794E-19, 1.4794E-19, 1.4827E-19, 1.4861E-19, 1.4861E-19, &
      1.4897E-19, 1.4897E-19, 1.4935E-19, 1.4935E-19, 1.4991E-19, 1.5063E-19, &
      1.5123E-19, 1.5178E-19, 1.5226E-19, 1.5278E-19, 1.5306E-19, 1.5336E-19, &
      1.5384E-19, 1.5401E-19, 1.5437E-19, 1.5456E-19, 1.5496E-19, 1.5496E-19, &
      1.5540E-19 /)
    REAL, PARAMETER :: a4_NO2(3) = (/ 1.8459E-19, 9.5032E-24, -1.6393E-27 /)
    REAL, PARAMETER :: a5_NO2(3) = (/ 2.8825E-19, 1.2916E-23, -1.6499E-27 /)
    REAL, PARAMETER :: a6_NO2(2) = (/ 3.6241E-19, -5.3163E-27 /)

    jval_gp(ip_NO2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_NO2(2) = &
          p1(b2_NO2(i2(j,k)), a2_NO2(i2(j,k)), &
          v3_du1(j,k))
        sig_NO2(3) = &
          p1(b3_NO2(i3(j,k)), a3_NO2(i3(j,k)), &
          v3_du2(j,k))
        sig_NO2(4) = &
          p2(a4_NO2(1),a4_NO2(2),a4_NO2(3),v3_du2(j,k))
        sig_NO2(5) = &
          p2(a5_NO2(1),a5_NO2(2),a5_NO2(3),v3_du2(j,k))
        sig_NO2(6) = &
          p1(a6_NO2(1),a6_NO2(2),v3_du2(j,k))
        dj = 0. &
          + sig_NO2(2) * fint(j,k,2) &
          + sig_NO2(3) * fint(j,k,3) &
          + sig_NO2(4) * fint(j,k,4) &
          + sig_NO2(5) * fint(j,k,5) &
          + sig_NO2(6) * fint(j,k,6)

        jval_gp(ip_NO2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_NO2

  ! **************************************************************************

  SUBROUTINE jval_cal_NO2O(jrow)

    ! NO3 -> NO2 + O JPL 1997, JPL 2006

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_NO2O

    ! T-const parameters:
    REAL, PARAMETER :: a6_NO2O(2) = (/ 1.3689E-20, 1.6736E-26 /)
    REAL, PARAMETER :: a7_NO2O(2) = (/ 1.2678E-18, -2.7887E-23 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c7_NO2O(2) = (/ 1.00, -0.27 /)

    jval_gp(ip_NO2O)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_NO2O(6) = &
          p1(a6_NO2O(1),a6_NO2O(2),v3_du2(j,k))
        sig_NO2O(7) = &
          p1(c7_NO2O(1),c7_NO2O(2),tnorm(j,k)) * &
          p1(a7_NO2O(1),a7_NO2O(2),v3_du2(j,k))
        dj = 0. &
          + sig_NO2O(6) * fint(j,k,6) &
          + sig_NO2O(7) * fint(j,k,7)

        jval_gp(ip_NO2O)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_NO2O

  ! **************************************************************************

  SUBROUTINE jval_cal_NOO2(jrow)

    ! NO3 -> NO + O2 JPL 1997, JPL 2006

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_NOO2

    ! T-const parameters:
    REAL, PARAMETER :: a7_NOO2(2) = (/ 1.7143E-19, -8.6652E-24 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c7_NOO2(2) = (/ 1.00, -0.60 /)

    jval_gp(ip_NOO2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_NOO2(7) = &
          p1(c7_NOO2(1),c7_NOO2(2),tnorm(j,k)) * &
          p1(a7_NOO2(1),a7_NOO2(2),v3_du2(j,k))
        dj = 0. &
          + sig_NOO2(7) * fint(j,k,7)

        jval_gp(ip_NOO2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_NOO2

  ! **************************************************************************

  SUBROUTINE jval_cal_N2O5(jrow)

    ! N2O5 -> NO2 + NO3 and N2O5 -> NO3 + NO + O(3p) JPL 2006

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_N2O5

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_N2O5(dim58) = (/ &
      -7.2803E-22, -8.0657E-22, -9.0984E-22, -9.6774E-22, -1.1499E-21, -1.2200E-21, &
      -1.3400E-21, -1.3980E-21, -1.5261E-21, -1.6503E-21, -1.7698E-21, -2.0018E-21, &
      -2.1221E-21, -2.5436E-21, -2.6015E-21, -2.7794E-21, -3.0438E-21, -3.1846E-21, &
      -3.3958E-21, -3.6065E-21, -3.7966E-21, -3.9701E-21, -4.2652E-21, -4.3091E-21, &
      -4.6824E-21, -4.6983E-21, -4.9008E-21, -5.2607E-21, -5.3846E-21, -5.7036E-21, &
      -5.9475E-21, -6.2077E-21, -6.4234E-21, -6.6415E-21, -6.8840E-21, -7.0957E-21, &
      -7.3747E-21, -7.5728E-21, -7.9032E-21, -8.2517E-21, -8.6562E-21, -9.0493E-21, &
      -9.5248E-21, -9.9635E-21, -1.0376E-20, -1.0582E-20, -1.0870E-20, -1.0933E-20, &
      -1.0944E-20, -1.0793E-20, -1.0497E-20, -1.0174E-20, -9.7398E-21, -9.2892E-21, &
      -8.7767E-21, -8.0693E-21, -7.0277E-21, -5.7455E-21 /)
    REAL, PARAMETER :: a0_1_2_N2O5(dim58) = (/ &
      9.1965E-18, 9.2000E-18, 9.2046E-18, 9.2072E-18, 9.2153E-18, 9.2185E-18, &
      9.2239E-18, 9.2266E-18, 9.2324E-18, 9.2381E-18, 9.2436E-18, 9.2543E-18, &
      9.2599E-18, 9.2795E-18, 9.2822E-18, 9.2906E-18, 9.3031E-18, 9.3098E-18, &
      9.3198E-18, 9.3299E-18, 9.3390E-18, 9.3474E-18, 9.3616E-18, 9.3638E-18, &
      9.3820E-18, 9.3828E-18, 9.3927E-18, 9.4105E-18, 9.4167E-18, 9.4325E-18, &
      9.4447E-18, 9.4578E-18, 9.4687E-18, 9.4797E-18, 9.4920E-18, 9.5028E-18, &
      9.5171E-18, 9.5273E-18, 9.5443E-18, 9.5624E-18, 9.5834E-18, 9.6040E-18, &
      9.6289E-18, 9.6519E-18, 9.6737E-18, 9.6847E-18, 9.7000E-18, 9.7033E-18, &
      9.7039E-18, 9.6958E-18, 9.6798E-18, 9.6623E-18, 9.6387E-18, 9.6141E-18, &
      9.5860E-18, 9.5471E-18, 9.4896E-18, 9.4186E-18 /)
    REAL, PARAMETER :: a0_2_1_N2O5(dim58) = (/ &
      1.9129E-24, 2.1537E-24, 2.6279E-24, 2.6607E-24, 3.3765E-24, 3.4490E-24, &
      3.8617E-24, 3.6903E-24, 3.8980E-24, 3.9275E-24, 4.2879E-24, 5.5225E-24, &
      5.1968E-24, 8.9489E-24, 7.8774E-24, 7.9546E-24, 9.0639E-24, 8.2171E-24, &
      8.5815E-24, 9.0142E-24, 8.6907E-24, 8.6332E-24, 9.3846E-24, 8.2130E-24, &
      8.9729E-24, 7.4150E-24, 6.9896E-24, 7.8158E-24, 7.4808E-24, 7.8776E-24, &
      7.8752E-24, 8.2545E-24, 8.2509E-24, 8.3490E-24, 8.5459E-24, 8.4336E-24, &
      8.7477E-24, 8.4649E-24, 8.8386E-24, 8.7084E-24, 9.2842E-24, 9.4332E-24, &
      9.1289E-24, 9.7661E-24, 9.9039E-24, 9.1074E-24, 9.3002E-24, 8.7795E-24, &
      8.5604E-24, 8.1202E-24, 7.2660E-24, 7.0195E-24, 6.2325E-24, 5.7217E-24, &
      5.1244E-24, 4.3835E-24, 3.4986E-24, 2.7995E-24 /)
    REAL, PARAMETER :: a0_2_2_N2O5(dim58) = (/ &
      -1.8682E-22, -1.9746E-22, -2.1851E-22, -2.1998E-22, -2.5205E-22, -2.5531E-22, &
      -2.7396E-22, -2.6618E-22, -2.7566E-22, -2.7701E-22, -2.9358E-22, -3.5062E-22, &
      -3.3551E-22, -5.1036E-22, -4.6021E-22, -4.6384E-22, -5.1620E-22, -4.7606E-22, &
      -4.9341E-22, -5.1409E-22, -4.9856E-22, -4.9579E-22, -5.3216E-22, -4.7522E-22, &
      -5.1230E-22, -4.3596E-22, -4.1503E-22, -4.5585E-22, -4.3923E-22, -4.5899E-22, &
      -4.5887E-22, -4.7791E-22, -4.7773E-22, -4.8270E-22, -4.9270E-22, -4.8697E-22, &
      -5.0305E-22, -4.8851E-22, -5.0780E-22, -5.0106E-22, -5.3100E-22, -5.3878E-22, &
      -5.2283E-22, -5.5634E-22, -5.6362E-22, -5.2141E-22, -5.3166E-22, -5.0386E-22, &
      -4.9211E-22, -4.6843E-22, -4.2231E-22, -4.0895E-22, -3.6613E-22, -3.3824E-22, &
      -3.0551E-22, -2.6476E-22, -2.1592E-22, -1.7719E-22 /)
    REAL, PARAMETER :: a1_1_N2O5(dim55) = (/ &
      9.3594E-20, 9.1156E-20, 9.0718E-20, 8.4769E-20, 8.1296E-20, 7.4423E-20, &
      7.0031E-20, 6.3915E-20, 5.9713E-20, 5.4815E-20, 5.1223E-20, 4.7468E-20, &
      4.4485E-20, 4.1613E-20, 3.9104E-20, 3.6944E-20, 3.4773E-20, 3.3138E-20, &
      3.1211E-20, 2.9962E-20, 2.8274E-20, 2.7321E-20, 2.5783E-20, 2.5062E-20, &
      2.3661E-20, 2.3124E-20, 2.1831E-20, 2.1437E-20, 2.0251E-20, 1.9963E-20, &
      1.8855E-20, 1.8699E-20, 1.7637E-20, 1.7548E-20, 1.6559E-20, 1.6535E-20, &
      1.5594E-20, 1.5640E-20, 1.4749E-20, 1.4826E-20, 1.3484E-20, 1.2107E-20, &
      1.0818E-20, 9.9351E-21, 9.0119E-21, 8.4058E-21, 7.6849E-21, 7.2468E-21, &
      6.4203E-21, 5.9626E-21, 5.5463E-21, 5.1648E-21, 4.8143E-21, 4.4933E-21, &
      4.1959E-21 /)
    REAL, PARAMETER :: b1_1_N2O5(dim55) = (/ &
      2.0841E-18, 2.0914E-18, 2.0938E-18, 2.1414E-18, 2.1779E-18, 2.2672E-18, &
      2.3353E-18, 2.4454E-18, 2.5315E-18, 2.6442E-18, 2.7357E-18, 2.8409E-18, &
      2.9319E-18, 3.0267E-18, 3.1157E-18, 3.1978E-18, 3.2857E-18, 3.3560E-18, &
      3.4437E-18, 3.5036E-18, 3.5889E-18, 3.6394E-18, 3.7248E-18, 3.7666E-18, &
      3.8514E-18, 3.8852E-18, 3.9699E-18, 3.9967E-18, 4.0803E-18, 4.1013E-18, &
      4.1849E-18, 4.1971E-18, 4.2826E-18, 4.2900E-18, 4.3746E-18, 4.3767E-18, &
      4.4619E-18, 4.4575E-18, 4.5427E-18, 4.5351E-18, 4.6699E-18, 4.8255E-18, &
      4.9874E-18, 5.1092E-18, 5.2481E-18, 5.3469E-18, 5.4734E-18, 5.5558E-18, &
      5.7215E-18, 5.8190E-18, 5.9129E-18, 6.0037E-18, 6.0915E-18, 6.1759E-18, &
      6.2578E-18 /)
    REAL, PARAMETER :: a1_2_N2O5(dim55) = (/ &
      -2.4957E-22, -1.3951E-22, -1.3549E-22, -4.1666E-23, -3.5987E-23, 2.6734E-23, &
      2.7429E-23, 6.1261E-23, 5.8488E-23, 7.3448E-23, 6.9311E-23, 7.3724E-23, &
      7.0174E-23, 6.9187E-23, 6.7078E-23, 6.2986E-23, 6.2600E-23, 5.6960E-23, &
      5.7949E-23, 5.1593E-23, 5.3347E-23, 4.6606E-23, 4.9087E-23, 4.2301E-23, &
      4.5292E-23, 3.8424E-23, 4.1871E-23, 3.5023E-23, 3.8594E-23, 3.2104E-23, &
      3.5771E-23, 2.9241E-23, 3.3152E-23, 2.6910E-23, 3.0770E-23, 2.4794E-23, &
      2.8665E-23, 2.2794E-23, 2.6657E-23, 2.1084E-23, 2.1556E-23, 1.7447E-23, &
      1.5767E-23, 1.3030E-23, 1.2192E-23, 1.0243E-23, 9.9055E-24, 8.4127E-24, &
      9.6873E-24, 9.1348E-24, 8.6576E-24, 8.2543E-24, 7.8899E-24, 7.5512E-24, &
      7.2474E-24 /)
    REAL, PARAMETER :: b1_2_N2O5(dim55) = (/ &
      -6.2525E-21, -6.5827E-21, -6.6049E-21, -7.3554E-21, -7.4151E-21, -8.2304E-21, &
      -8.2412E-21, -8.8502E-21, -8.7933E-21, -9.1374E-21, -9.0319E-21, -9.1555E-21, &
      -9.0472E-21, -9.0146E-21, -8.9398E-21, -8.7843E-21, -8.7687E-21, -8.5261E-21, &
      -8.5711E-21, -8.2660E-21, -8.3546E-21, -7.9973E-21, -8.1350E-21, -7.7414E-21, &
      -7.9224E-21, -7.4897E-21, -7.7155E-21, -7.2498E-21, -7.5016E-21, -7.0278E-21, &
      -7.3047E-21, -6.7953E-21, -7.1101E-21, -6.5921E-21, -6.9221E-21, -6.3962E-21, &
      -6.7466E-21, -6.2005E-21, -6.5695E-21, -6.0233E-21, -6.0707E-21, -5.6064E-21, &
      -5.3956E-21, -5.0178E-21, -4.8918E-21, -4.5741E-21, -4.5149E-21, -4.2342E-21, &
      -4.4898E-21, -4.3721E-21, -4.2645E-21, -4.1685E-21, -4.0772E-21, -3.9881E-21, &
      -3.9044E-21 /)
    REAL, PARAMETER :: a2_N2O5(dim55) = (/ &
      -7.1760E-21, -6.2520E-21, -5.1160E-21, -3.9960E-21, -3.0280E-21, -2.2556E-21, &
      -1.6844E-21, -1.2728E-21, -9.8120E-22, -7.7640E-22, -6.3120E-22, -5.2720E-22, &
      -4.5080E-22, -3.9360E-22, -3.4880E-22, -3.1400E-22, -2.8520E-22, -2.6120E-22, &
      -2.4080E-22, -2.2320E-22, -2.0720E-22, -1.9280E-22, -1.8040E-22, -1.6840E-22, &
      -1.5800E-22, -1.4800E-22, -1.3880E-22, -1.3040E-22, -1.2200E-22, -1.1520E-22, &
      -1.0760E-22, -1.0160E-22, -9.5201E-23, -8.9201E-23, -8.4398E-23, -7.8799E-23, &
      -7.4402E-23, -6.9599E-23, -6.5601E-23, -6.1198E-23, -5.1120E-23, -3.7280E-23, &
      -2.7120E-23, -1.9600E-23, -1.4240E-23, -1.0320E-23, -7.3598E-24, -5.4403E-24, &
      -3.8402E-24, -2.8000E-24, -1.9997E-24, -1.4403E-24, -1.0397E-24, -7.2016E-25, &
      -5.5990E-25 /)
    REAL, PARAMETER :: b2_N2O5(dim55) = (/ &
      1.7163E-19, 1.6886E-19, 1.6261E-19, 1.5365E-19, 1.4348E-19, 1.3344E-19, &
      1.2459E-19, 1.1718E-19, 1.1120E-19, 1.0649E-19, 1.0279E-19, 9.9878E-20, &
      9.7547E-20, 9.5660E-20, 9.4069E-20, 9.2747E-20, 9.1581E-20, 9.0549E-20, &
      8.9620E-20, 8.8776E-20, 8.7968E-20, 8.7204E-20, 8.6516E-20, 8.5820E-20, &
      8.5191E-20, 8.4561E-20, 8.3958E-20, 8.3387E-20, 8.2795E-20, 8.2299E-20, &
      8.1725E-20, 8.1257E-20, 8.0742E-20, 8.0244E-20, 7.9833E-20, 7.9340E-20, &
      7.8942E-20, 7.8496E-20, 7.8114E-20, 7.7682E-20, 7.6670E-20, 7.5106E-20, &
      7.3831E-20, 7.2793E-20, 7.1986E-20, 7.1347E-20, 7.0828E-20, 7.0467E-20, &
      7.0146E-20, 6.9924E-20, 6.9744E-20, 6.9611E-20, 6.9510E-20, 6.9426E-20, &
      6.9382E-20 /)
    REAL, PARAMETER :: a3_N2O5(dim55) = (/ &
      -9.6294E-23, -8.2039E-23, -6.6379E-23, -5.2163E-23, -4.0575E-23, -3.1669E-23, &
      -2.5090E-23, -2.0208E-23, -1.6653E-23, -1.3938E-23, -1.1866E-23, -1.0264E-23, &
      -8.9457E-24, -7.9473E-24, -7.0316E-24, -6.3099E-24, -5.7109E-24, -5.1518E-24, &
      -4.7144E-24, -4.3530E-24, -3.9537E-24, -3.6742E-24, -3.3959E-24, -3.1550E-24, &
      -2.9552E-24, -2.7556E-24, -2.5570E-24, -2.4361E-24, -2.2763E-24, -2.1565E-24, &
      -2.0376E-24, -1.9169E-24, -1.8371E-24, -1.7173E-24, -1.6380E-24, -1.5575E-24, &
      -1.5176E-24, -1.3978E-24, -1.3584E-24, -1.3179E-24, -1.1502E-24, -9.4249E-25, &
      -7.9073E-25, -6.7093E-25, -5.6755E-25, -4.9521E-25, -4.3130E-25, -3.7540E-25, &
      -3.2748E-25, -2.8753E-25, -2.5559E-25, -2.2365E-25, -1.9184E-25, -1.7571E-25, &
      -1.5176E-25 /)
    REAL, PARAMETER :: b3_N2O5(dim55) = (/ &
      3.6427E-20, 3.6063E-20, 3.5271E-20, 3.4196E-20, 3.3030E-20, 3.1911E-20, &
      3.0919E-20, 3.0061E-20, 2.9347E-20, 2.8734E-20, 2.8214E-20, 2.7772E-20, &
      2.7375E-20, 2.7050E-20, 2.6728E-20, 2.6457E-20, 2.6217E-20, 2.5978E-20, &
      2.5781E-20, 2.5609E-20, 2.5409E-20, 2.5262E-20, 2.5108E-20, 2.4969E-20, &
      2.4849E-20, 2.4724E-20, 2.4595E-20, 2.4513E-20, 2.4401E-20, 2.4314E-20, &
      2.4225E-20, 2.4131E-20, 2.4067E-20, 2.3968E-20, 2.3900E-20, 2.3830E-20, &
      2.3794E-20, 2.3683E-20, 2.3645E-20, 2.3606E-20, 2.3437E-20, 2.3203E-20, &
      2.3013E-20, 2.2848E-20, 2.2693E-20, 2.2575E-20, 2.2463E-20, 2.2358E-20, &
      2.2262E-20, 2.2177E-20, 2.2105E-20, 2.2029E-20, 2.1949E-20, 2.1907E-20, &
      2.1841E-20 /)
    REAL, PARAMETER :: a4_N2O5(3) = (/ 1.5527E-20, -1.7867E-24, 3.1737E-28 /)
    REAL, PARAMETER :: a5_N2O5(3) = (/ 5.4351E-21, -7.9847E-25, 1.1026E-28 /)
    REAL, PARAMETER :: a6_N2O5(2) = (/ 2.7029E-22, -2.2083E-27 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c2_N2O5(4) = (/ 1.00,  0.47, -0.21,  0.06 /)
    REAL, PARAMETER :: c3_N2O5(4) = (/ 1.00,  1.80, -0.13, -0.50 /)
    REAL, PARAMETER :: c4_N2O5(4) = (/ 1.00,  2.32,  0.43, -0.99 /)
    REAL, PARAMETER :: c5_N2O5(4) = (/ 1.00,  3.28,  2.20, -1.37 /)
    REAL, PARAMETER :: c6_N2O5(4) = (/ 1.00,  5.13,  8.01,  2.30 /)

    jval_gp(ip_N2O5)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_N2O5(0) = &
          p1(a0_1_1_N2O5(i0(j,k))*dlv2(j,k) + &
          a0_1_2_N2O5(i0(j,k)), &
          a0_2_1_N2O5(i0(j,k))*dlv2(j,k) + &
          a0_2_2_N2O5(i0(j,k)),v3_du1(j,k))
        sig_N2O5(1) = &
          (p1(b1_1_N2O5(i1(j,k)),a1_1_N2O5(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_N2O5(i1(j,k)),a1_2_N2O5(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_N2O5(2) = &
          p3(c2_N2O5(1),c2_N2O5(2),c2_N2O5(3),c2_N2O5(4),tnorm(j,k))* &
          p1(b2_N2O5(i2(j,k)), a2_N2O5(i2(j,k)), &
          v3_du1(j,k))
        sig_N2O5(3) = &
          p3(c3_N2O5(1),c3_N2O5(2),c3_N2O5(3),c3_N2O5(4),tnorm(j,k))* &
          p1(b3_N2O5(i3(j,k)), a3_N2O5(i3(j,k)), &
          v3_du2(j,k))
        sig_N2O5(4) = &
          p3(c4_N2O5(1),c4_N2O5(2),c4_N2O5(3),c4_N2O5(4),tnorm(j,k))* &
          p2(a4_N2O5(1),a4_N2O5(2),a4_N2O5(3),v3_du2(j,k))
        sig_N2O5(5) = &
          p3(c5_N2O5(1),c5_N2O5(2),c5_N2O5(3),c5_N2O5(4),tnorm(j,k))* &
          p2(a5_N2O5(1),a5_N2O5(2),a5_N2O5(3),v3_du2(j,k))
        sig_N2O5(6) = &
          p3(c6_N2O5(1),c6_N2O5(2),c6_N2O5(3),c6_N2O5(4),tnorm(j,k))* &
          p1(a6_N2O5(1),a6_N2O5(2),v3_du2(j,k))
        dj = 0. &
          + sig_N2O5(0) * fint(j,k,0) * 0.28 &
          + sig_N2O5(1) * fint(j,k,1) * 0.28 &
          + sig_N2O5(2) * fint(j,k,2) * 0.7  &
          + sig_N2O5(3) * fint(j,k,3) * 0.95 &
          + sig_N2O5(4) * fint(j,k,4) &
          + sig_N2O5(5) * fint(j,k,5) &
          + sig_N2O5(6) * fint(j,k,6)

        jval_gp(ip_N2O5)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,4))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_N2O5

  ! **************************************************************************

  SUBROUTINE jval_cal_HNO3(jrow)

    ! HNO3 -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_HNO3

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_HNO3(dim58) = (/ &
      -8.4075E-20, -9.2334E-20, -1.0084E-19, -1.0995E-19, -1.1966E-19, -1.2947E-19, &
      -1.3997E-19, -1.5065E-19, -1.6197E-19, -1.7362E-19, -1.8588E-19, -1.9875E-19, &
      -2.2076E-19, -2.6001E-19, -2.6507E-19, -2.7889E-19, -3.0131E-19, -3.0627E-19, &
      -3.1978E-19, -3.4101E-19, -3.4533E-19, -3.5758E-19, -3.7753E-19, -3.8141E-19, &
      -3.9324E-19, -3.9104E-19, -3.9705E-19, -4.1008E-19, -4.2229E-19, -4.3345E-19, &
      -4.4290E-19, -4.5058E-19, -4.5602E-19, -4.5956E-19, -4.6167E-19, -4.6230E-19, &
      -4.6311E-19, -4.6404E-19, -4.6584E-19, -4.6876E-19, -4.7236E-19, -4.7588E-19, &
      -4.7817E-19, -4.7748E-19, -4.7222E-19, -4.6133E-19, -4.4412E-19, -4.2224E-19, &
      -3.9631E-19, -3.6845E-19, -3.4014E-19, -3.1199E-19, -2.8400E-19, -2.5540E-19, &
      -2.2627E-19, -1.9616E-19, -1.6332E-19, -1.3461E-19 /)
    REAL, PARAMETER :: a0_1_2_HNO3(dim58) = (/ &
      1.3153E-17, 1.3518E-17, 1.3896E-17, 1.4302E-17, 1.4737E-17, 1.5179E-17, &
      1.5653E-17, 1.6138E-17, 1.6655E-17, 1.7188E-17, 1.7752E-17, 1.8347E-17, &
      1.9368E-17, 2.1197E-17, 2.1434E-17, 2.2083E-17, 2.3141E-17, 2.3376E-17, &
      2.4020E-17, 2.5034E-17, 2.5242E-17, 2.5832E-17, 2.6798E-17, 2.6986E-17, &
      2.7564E-17, 2.7456E-17, 2.7752E-17, 2.8395E-17, 2.9001E-17, 2.9557E-17, &
      3.0029E-17, 3.0414E-17, 3.0689E-17, 3.0868E-17, 3.0975E-17, 3.1007E-17, &
      3.1049E-17, 3.1096E-17, 3.1190E-17, 3.1341E-17, 3.1528E-17, 3.1712E-17, &
      3.1832E-17, 3.1796E-17, 3.1518E-17, 3.0940E-17, 3.0025E-17, 2.8856E-17, &
      2.7467E-17, 2.5968E-17, 2.4439E-17, 2.2913E-17, 2.1391E-17, 1.9829E-17, &
      1.8233E-17, 1.6577E-17, 1.4764E-17, 1.3173E-17 /)
    REAL, PARAMETER :: a0_2_1_HNO3(dim58) = (/ &
      2.8355E-22, 3.0818E-22, 3.3267E-22, 3.5919E-22, 3.8734E-22, 4.1457E-22, &
      4.4307E-22, 4.7166E-22, 5.0090E-22, 5.3043E-22, 5.6111E-22, 5.9237E-22, &
      7.5318E-22, 1.1529E-21, 1.0367E-21, 1.0474E-21, 1.1669E-21, 1.0594E-21, &
      1.0648E-21, 1.1640E-21, 1.0644E-21, 1.0623E-21, 1.1422E-21, 1.0507E-21, &
      1.0458E-21, 9.0168E-22, 8.4490E-22, 8.6010E-22, 8.7375E-22, 8.8491E-22, &
      8.9266E-22, 8.9649E-22, 8.9583E-22, 8.9134E-22, 8.8361E-22, 8.7277E-22, &
      8.6304E-22, 8.5301E-22, 8.4520E-22, 8.3897E-22, 8.3338E-22, 8.2603E-22, &
      8.1505E-22, 7.9597E-22, 7.6619E-22, 7.2399E-22, 6.7041E-22, 6.0959E-22, &
      5.4426E-22, 4.7962E-22, 4.1797E-22, 3.6155E-22, 3.0900E-22, 2.5811E-22, &
      2.1074E-22, 1.6761E-22, 1.2929E-22, 1.0268E-22 /)
    REAL, PARAMETER :: a0_2_2_HNO3(dim58) = (/ &
      -2.1039E-20, -2.2128E-20, -2.3215E-20, -2.4398E-20, -2.5659E-20, -2.6884E-20, &
      -2.8173E-20, -2.9470E-20, -3.0804E-20, -3.2157E-20, -3.3568E-20, -3.5012E-20, &
      -4.2474E-20, -6.1099E-20, -5.5664E-20, -5.6163E-20, -6.1807E-20, -5.6712E-20, &
      -5.6969E-20, -6.1708E-20, -5.6928E-20, -5.6825E-20, -6.0695E-20, -5.6248E-20, &
      -5.6007E-20, -4.8946E-20, -4.6152E-20, -4.6904E-20, -4.7581E-20, -4.8136E-20, &
      -4.8524E-20, -4.8716E-20, -4.8683E-20, -4.8456E-20, -4.8063E-20, -4.7510E-20, &
      -4.7012E-20, -4.6496E-20, -4.6093E-20, -4.5771E-20, -4.5480E-20, -4.5096E-20, &
      -4.4521E-20, -4.3518E-20, -4.1945E-20, -3.9708E-20, -3.6858E-20, -3.3610E-20, &
      -3.0109E-20, -2.6631E-20, -2.3302E-20, -2.0243E-20, -1.7385E-20, -1.4607E-20, &
      -1.2010E-20, -9.6383E-21, -7.5233E-21, -6.0487E-21 /)
    REAL, PARAMETER :: a1_1_HNO3(dim55) = (/ &
      1.7772E-20, 1.7803E-20, 1.8719E-20, 1.7948E-20, 1.8240E-20, 1.7082E-20, &
      1.7065E-20, 1.5849E-20, 1.5742E-20, 1.4617E-20, 1.4517E-20, 1.3524E-20, &
      1.3457E-20, 1.2590E-20, 1.2555E-20, 1.1795E-20, 1.1785E-20, 1.1111E-20, &
      1.1118E-20, 1.0516E-20, 1.0535E-20, 9.9905E-21, 1.0019E-20, 9.5293E-21, &
      9.5649E-21, 9.1027E-21, 9.1490E-21, 8.7378E-21, 8.7699E-21, 8.4112E-21, &
      8.4341E-21, 8.0864E-21, 8.1257E-21, 7.8169E-21, 7.8401E-21, 7.5583E-21, &
      7.5924E-21, 7.3176E-21, 7.3251E-21, 7.1078E-21, 6.8725E-21, 6.3986E-21, &
      6.0286E-21, 5.6762E-21, 5.3779E-21, 5.1016E-21, 4.8433E-21, 4.6192E-21, &
      4.3428E-21, 4.1060E-21, 3.8855E-21, 3.6779E-21, 3.4797E-21, 3.3013E-21, &
      3.1274E-21 /)
    REAL, PARAMETER :: b1_1_HNO3(dim55) = (/ &
      2.4477E-19, 2.4468E-19, 2.3964E-19, 2.4581E-19, 2.4275E-19, 2.5780E-19, &
      2.5805E-19, 2.7996E-19, 2.8214E-19, 3.0803E-19, 3.1056E-19, 3.3836E-19, &
      3.4043E-19, 3.6902E-19, 3.7027E-19, 3.9915E-19, 3.9956E-19, 4.2855E-19, &
      4.2822E-19, 4.5711E-19, 4.5617E-19, 4.8501E-19, 4.8344E-19, 5.1183E-19, &
      5.0967E-19, 5.3879E-19, 5.3576E-19, 5.6372E-19, 5.6146E-19, 5.8764E-19, &
      5.8591E-19, 6.1304E-19, 6.0987E-19, 6.3550E-19, 6.3352E-19, 6.5832E-19, &
      6.5523E-19, 6.8079E-19, 6.8006E-19, 7.0136E-19, 7.2501E-19, 7.7856E-19, &
      8.2500E-19, 8.7362E-19, 9.1853E-19, 9.6355E-19, 1.0089E-18, 1.0510E-18, &
      1.1064E-18, 1.1569E-18, 1.2066E-18, 1.2560E-18, 1.3057E-18, 1.3526E-18, &
      1.4005E-18 /)
    REAL, PARAMETER :: a1_2_HNO3(dim55) = (/ &
      -7.1583E-23, -4.8169E-23, -5.6230E-23, -3.1875E-23, -3.8482E-23, -1.7504E-23, &
      -2.4125E-23, -7.6689E-24, -1.4425E-23, -1.7795E-24, -8.3829E-24, 1.5145E-24, &
      -4.6420E-24, 3.3132E-24, -2.2666E-24, 4.2976E-24, -6.9608E-25, 4.8528E-24, &
      4.0543E-25, 5.1360E-24, 1.1874E-24, 5.2801E-24, 1.7519E-24, 5.2875E-24, &
      2.1261E-24, 5.3070E-24, 2.4348E-24, 5.1725E-24, 2.6758E-24, 4.9865E-24, &
      2.8118E-24, 4.9402E-24, 2.9017E-24, 4.7306E-24, 2.9761E-24, 4.5943E-24, &
      2.9496E-24, 4.4463E-24, 3.1005E-24, 4.2422E-24, 3.4266E-24, 3.4489E-24, &
      3.1436E-24, 3.0948E-24, 2.9378E-24, 2.8461E-24, 2.8025E-24, 2.6737E-24, &
      2.9601E-24, 3.0766E-24, 3.1748E-24, 3.2472E-24, 3.3155E-24, 3.3317E-24, &
      3.3575E-24 /)
    REAL, PARAMETER :: b1_2_HNO3(dim55) = (/ &
      -1.1993E-21, -1.2696E-21, -1.2252E-21, -1.4201E-21, -1.3507E-21, -1.6234E-21, &
      -1.5208E-21, -1.8170E-21, -1.6785E-21, -1.9694E-21, -1.8010E-21, -2.0781E-21, &
      -1.8903E-21, -2.1528E-21, -1.9548E-21, -2.2042E-21, -2.0020E-21, -2.2406E-21, &
      -2.0382E-21, -2.2653E-21, -2.0659E-21, -2.2828E-21, -2.0870E-21, -2.2920E-21, &
      -2.1008E-21, -2.3012E-21, -2.1130E-21, -2.2992E-21, -2.1232E-21, -2.2919E-21, &
      -2.1277E-21, -2.2937E-21, -2.1296E-21, -2.2814E-21, -2.1314E-21, -2.2738E-21, &
      -2.1249E-21, -2.2641E-21, -2.1356E-21, -2.2475E-21, -2.1655E-21, -2.1680E-21, &
      -2.1297E-21, -2.1230E-21, -2.0994E-21, -2.0844E-21, -2.0768E-21, -2.0525E-21, &
      -2.1100E-21, -2.1348E-21, -2.1569E-21, -2.1742E-21, -2.1913E-21, -2.1955E-21, &
      -2.2026E-21 /)
    REAL, PARAMETER :: a2_HNO3(dim55) = (/ &
      -3.8880E-22, -3.5640E-22, -3.0620E-22, -2.5040E-22, -1.9780E-22, -1.5332E-22, &
      -1.1800E-22, -9.1080E-23, -7.0920E-23, -5.6040E-23, -4.5000E-23, -3.6760E-23, &
      -3.0480E-23, -2.5760E-23, -2.2000E-23, -1.9080E-23, -1.6720E-23, -1.4800E-23, &
      -1.3240E-23, -1.1840E-23, -1.0760E-23, -9.7598E-24, -8.8802E-24, -8.1600E-24, &
      -7.5199E-24, -6.9199E-24, -6.4000E-24, -5.9202E-24, -5.4801E-24, -5.1198E-24, &
      -4.7201E-24, -4.4400E-24, -4.1201E-24, -3.8399E-24, -3.5601E-24, -3.3598E-24, &
      -3.1200E-24, -2.9200E-24, -2.7601E-24, -2.5601E-24, -2.1040E-24, -1.5200E-24, &
      -1.0880E-24, -7.9199E-25, -5.6801E-25, -4.1601E-25, -2.9598E-25, -2.1600E-25, &
      -1.5199E-25, -1.1202E-25, -7.9972E-26, -5.6029E-26, -4.0002E-26, -3.1989E-26, &
      -2.4008E-26 /)
    REAL, PARAMETER :: b2_HNO3(dim55) = (/ &
      1.2813E-20, 1.2716E-20, 1.2440E-20, 1.1994E-20, 1.1441E-20, 1.0863E-20, &
      1.0316E-20, 9.8311E-21, 9.4179E-21, 9.0756E-21, 8.7941E-21, 8.5634E-21, &
      8.3718E-21, 8.2161E-21, 8.0826E-21, 7.9716E-21, 7.8761E-21, 7.7935E-21, &
      7.7225E-21, 7.6553E-21, 7.6008E-21, 7.5478E-21, 7.4990E-21, 7.4572E-21, &
      7.4185E-21, 7.3807E-21, 7.3466E-21, 7.3140E-21, 7.2829E-21, 7.2566E-21, &
      7.2265E-21, 7.2046E-21, 7.1789E-21, 7.1556E-21, 7.1317E-21, 7.1141E-21, &
      7.0924E-21, 7.0738E-21, 7.0585E-21, 7.0389E-21, 6.9930E-21, 6.9271E-21, &
      6.8728E-21, 6.8320E-21, 6.7983E-21, 6.7735E-21, 6.7524E-21, 6.7374E-21, &
      6.7246E-21, 6.7161E-21, 6.7088E-21, 6.7031E-21, 6.6991E-21, 6.6970E-21, &
      6.6948E-21 /)
    REAL, PARAMETER :: a3_HNO3(dim55) = (/ &
      -1.1015E-23, -9.3462E-24, -7.5326E-24, -5.9033E-24, -4.5727E-24, -3.5623E-24, &
      -2.8166E-24, -2.2684E-24, -1.8610E-24, -1.5655E-24, -1.3344E-24, -1.1542E-24, &
      -1.0104E-24, -8.9057E-25, -7.9505E-25, -7.1486E-25, -6.4297E-25, -5.8706E-25, &
      -5.3136E-25, -4.8722E-25, -4.5128E-25, -4.1134E-25, -3.8354E-25, -3.5943E-25, &
      -3.3147E-25, -3.0751E-25, -2.9165E-25, -2.7157E-25, -2.5160E-25, -2.3962E-25, &
      -2.2773E-25, -2.1565E-25, -1.9968E-25, -1.9169E-25, -1.8378E-25, -1.7172E-25, &
      -1.6374E-25, -1.5974E-25, -1.4782E-25, -1.4377E-25, -1.2460E-25, -1.0224E-25, &
      -8.5464E-26, -7.1086E-26, -6.1551E-26, -5.2716E-26, -4.4728E-26, -3.9936E-26, &
      -3.4345E-26, -2.9553E-26, -2.6358E-26, -2.3163E-26, -2.0783E-26, -1.7572E-26, &
      -1.5974E-26 /)
    REAL, PARAMETER :: b3_HNO3(dim55) = (/ &
      2.9694E-21, 2.9268E-21, 2.8351E-21, 2.7119E-21, 2.5779E-21, 2.4509E-21, &
      2.3385E-21, 2.2422E-21, 2.1604E-21, 2.0937E-21, 2.0357E-21, 1.9859E-21, &
      1.9427E-21, 1.9036E-21, 1.8701E-21, 1.8399E-21, 1.8111E-21, 1.7873E-21, &
      1.7621E-21, 1.7411E-21, 1.7231E-21, 1.7021E-21, 1.6868E-21, 1.6729E-21, &
      1.6560E-21, 1.6410E-21, 1.6307E-21, 1.6171E-21, 1.6031E-21, 1.5944E-21, &
      1.5855E-21, 1.5761E-21, 1.5633E-21, 1.5567E-21, 1.5499E-21, 1.5394E-21, &
      1.5322E-21, 1.5285E-21, 1.5171E-21, 1.5132E-21, 1.4939E-21, 1.4687E-21, &
      1.4477E-21, 1.4279E-21, 1.4136E-21, 1.3992E-21, 1.3852E-21, 1.3762E-21, &
      1.3650E-21, 1.3548E-21, 1.3476E-21, 1.3400E-21, 1.3340E-21, 1.3256E-21, &
      1.3212E-21 /)
    REAL, PARAMETER :: a4_HNO3(3) = (/ 7.1424E-22, -1.5946E-25, 2.8712E-29 /)
    REAL, PARAMETER :: a5_HNO3(3) = (/ 9.0844E-23, -2.9931E-26, 4.5300E-30 /)
    REAL, PARAMETER :: a6_HNO3(2) = (/ 5.0901E-25, -7.0735E-30 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_HNO3(dim58) = (/ &
      4.3762E-03, 4.7896E-03, 5.2828E-03, 5.5658E-03, 6.1131E-03, 6.6971E-03, &
      7.2313E-03, 7.7758E-03, 8.4852E-03, 2.3899E-03, -8.7609E-03, -8.3466E-03, &
      -8.2979E-03, -8.3311E-03, -8.4685E-03, -9.1133E-03, -1.0087E-02, -1.1024E-02, &
      -1.2183E-02, -1.2856E-02, -1.3323E-02, -1.2878E-02, -1.1613E-02, -9.4898E-03, &
      -6.4191E-03, -2.8434E-03, 1.0036E-03, 4.0680E-03, 6.0826E-03, 6.0871E-03, &
      4.1363E-03, -3.4312E-04, -6.5313E-03, -1.3664E-02, -2.0652E-02, -2.5879E-02, &
      -2.8045E-02, -2.5908E-02, -1.8898E-02, -7.1015E-03, 8.0582E-03, 2.4622E-02, &
      3.9601E-02, 5.0493E-02, 5.6481E-02, 5.8193E-02, 5.8261E-02, 6.0287E-02, &
      6.7569E-02, 8.2268E-02, 1.0283E-01, 1.2503E-01, 1.4360E-01, 1.5913E-01, &
      1.8489E-01, 2.4854E-01, 3.9059E-01, 5.6705E-01 /)
    REAL, PARAMETER :: c0_1_2_HNO3(dim58) = (/ &
      -1.5525E-02, -3.4006E-02, -5.6147E-02, -6.8911E-02, -9.3706E-02, -1.2028E-01, &
      -1.4469E-01, -1.6968E-01, -2.0238E-01, 7.9826E-02, 5.9834E-01, 5.7899E-01, &
      5.7670E-01, 5.7827E-01, 5.8477E-01, 6.1540E-01, 6.6184E-01, 7.0674E-01, &
      7.6246E-01, 7.9500E-01, 8.1763E-01, 7.9598E-01, 7.3410E-01, 6.2985E-01, &
      4.7846E-01, 3.0147E-01, 1.1027E-01, -4.2643E-02, -1.4357E-01, -1.4380E-01, &
      -4.5285E-02, 1.8182E-01, 4.9680E-01, 8.6128E-01, 1.2198E+00, 1.4889E+00, &
      1.6010E+00, 1.4900E+00, 1.1248E+00, 5.0785E-01, -2.8804E-01, -1.1609E+00, &
      -1.9533E+00, -2.5317E+00, -2.8509E+00, -2.9424E+00, -2.9461E+00, -3.0553E+00, &
      -3.4493E+00, -4.2474E+00, -5.3681E+00, -6.5825E+00, -7.6016E+00, -8.4577E+00, &
      -9.8822E+00, -1.3415E+01, -2.1327E+01, -3.1191E+01 /)
    REAL, PARAMETER :: c0_2_1_HNO3(dim58) = (/ &
      5.8586E-04, 1.6998E-03, 8.0355E-04, 8.0028E-04, 1.2644E-03, 1.2133E-03, &
      1.0052E-03, 1.1395E-03, 1.8699E-03, 5.7300E-04, -8.2894E-04, 8.5790E-04, &
      3.1693E-04, 2.2184E-03, 3.3002E-03, 3.5278E-03, 5.4771E-03, 5.2049E-03, &
      6.3031E-03, 6.1741E-03, 7.1844E-03, 7.6260E-03, 8.5342E-03, 9.6194E-03, &
      8.7221E-03, 1.0465E-02, 7.9547E-03, 6.4854E-03, 4.9651E-03, 3.4796E-03, &
      8.9616E-04, -3.8423E-04, 1.6643E-04, -9.3487E-04, 1.6966E-03, 5.4030E-03, &
      1.2511E-02, 2.2686E-02, 3.1771E-02, 3.7849E-02, 3.6638E-02, 2.8909E-02, &
      1.9428E-02, 8.2146E-03, 6.8413E-03, 8.0847E-03, 1.5122E-02, 1.6688E-02, &
      3.2334E-03, -2.7037E-02, -7.1803E-02, -1.1599E-01, -1.2671E-01, -9.2821E-02, &
      -4.5643E-03, 1.5758E-01, 5.2110E-01, 1.1128E+00 /)
    REAL, PARAMETER :: c0_2_2_HNO3(dim58) = (/ &
      1.1291E-02, -3.8500E-02, 1.7396E-03, 1.8868E-03, -1.9137E-02, -1.6810E-02, &
      -7.3021E-03, -1.3465E-02, -4.7140E-02, 1.2908E-02, 7.8098E-02, -6.7695E-04, &
      2.4694E-02, -6.4866E-02, -1.1604E-01, -1.2685E-01, -2.1983E-01, -2.0679E-01, &
      -2.5961E-01, -2.5338E-01, -3.0238E-01, -3.2389E-01, -3.6830E-01, -4.2158E-01, &
      -3.7734E-01, -4.6362E-01, -3.3885E-01, -2.6554E-01, -1.8937E-01, -1.1465E-01, &
      1.5814E-02, 8.0730E-02, 5.2701E-02, 1.0898E-01, -2.6017E-02, -2.1690E-01, &
      -5.8439E-01, -1.1125E+00, -1.5858E+00, -1.9037E+00, -1.8401E+00, -1.4328E+00, &
      -9.3123E-01, -3.3580E-01, -2.6260E-01, -3.2912E-01, -7.0703E-01, -7.9142E-01, &
      -6.3538E-02, 1.5801E+00, 4.0199E+00, 6.4367E+00, 7.0256E+00, 5.1582E+00, &
      2.7757E-01, -8.7214E+00, -2.8970E+01, -6.2047E+01 /)
    REAL, PARAMETER :: c1_HNO3(4) = (/ 1.00, 0.42, 0.07, 0.00 /)
    REAL, PARAMETER :: c2_HNO3(4) = (/ 1.00, 0.51, 0.16, 0.03 /)
    REAL, PARAMETER :: c3_HNO3(4) = (/ 1.00, 0.80, 0.31, 0.12 /)
    REAL, PARAMETER :: c4_HNO3(4) = (/ 1.00, 1.06, 0.57, 0.20 /)
    REAL, PARAMETER :: c5_HNO3(4) = (/ 1.00, 1.62, 1.40, 0.82 /)
    REAL, PARAMETER :: c6_HNO3(4) = (/ 1.00, 2.72, 3.88, 3.50 /)

    jval_gp(ip_HNO3)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_HNO3(0) = &
          p2(1.,c0_1_1_HNO3(i0(j,k))*dlv2(j,k) + &
          c0_1_2_HNO3(i0(j,k)), &
          c0_2_1_HNO3(i0(j,k))*dlv2(j,k) + &
          c0_2_2_HNO3(i0(j,k)), tnorm_sr(j,k)) * &
          p1(a0_1_1_HNO3(i0(j,k))*dlv2(j,k) + &
          a0_1_2_HNO3(i0(j,k)), &
          a0_2_1_HNO3(i0(j,k))*dlv2(j,k) + &
          a0_2_2_HNO3(i0(j,k)),v3_du1(j,k))
        sig_HNO3(1) = &
          p3(c1_HNO3(1),c1_HNO3(2), &
          c1_HNO3(3),c1_HNO3(4),tnorm(j,k)) * &
          (p1(b1_1_HNO3(i1(j,k)),a1_1_HNO3(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_HNO3(i1(j,k)),a1_2_HNO3(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_HNO3(2) = &
          p3(c2_HNO3(1),c2_HNO3(2),c2_HNO3(3),c2_HNO3(4),tnorm(j,k))* &
          p1(b2_HNO3(i2(j,k)), a2_HNO3(i2(j,k)), &
          v3_du1(j,k))
        sig_HNO3(3) = &
          p3(c3_HNO3(1),c3_HNO3(2),c3_HNO3(3),c3_HNO3(4),tnorm(j,k))* &
          p1(b3_HNO3(i3(j,k)), a3_HNO3(i3(j,k)), &
          v3_du2(j,k))
        sig_HNO3(4) = &
          p3(c4_HNO3(1),c4_HNO3(2),c4_HNO3(3),c4_HNO3(4),tnorm(j,k))* &
          p2(a4_HNO3(1),a4_HNO3(2),a4_HNO3(3),v3_du2(j,k))
        sig_HNO3(5) = &
          p3(c5_HNO3(1),c5_HNO3(2),c5_HNO3(3),c5_HNO3(4),tnorm(j,k))* &
          p2(a5_HNO3(1),a5_HNO3(2),a5_HNO3(3),v3_du2(j,k))
        sig_HNO3(6) = &
          p3(c6_HNO3(1),c6_HNO3(2),c6_HNO3(3),c6_HNO3(4),tnorm(j,k))* &
          p1(a6_HNO3(1),a6_HNO3(2),v3_du2(j,k))
        dj = 0. &
          + sig_HNO3(0) * fint(j,k,0) &
          + sig_HNO3(1) * fint(j,k,1) &
          + sig_HNO3(2) * fint(j,k,2) &
          + sig_HNO3(3) * fint(j,k,3) &
          + sig_HNO3(4) * fint(j,k,4) &
          + sig_HNO3(5) * fint(j,k,5) &
          + sig_HNO3(6) * fint(j,k,6)

        jval_gp(ip_HNO3)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,7))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_HNO3

  ! **************************************************************************

  SUBROUTINE jval_cal_HNO4(jrow)

    ! HNO4 -> products JPL 1997, IR overtones from Roehl et al. (2002)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_HNO4

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_HNO4(dim58) = (/ &
      -4.4683E-20, -4.9003E-20, -5.3635E-20, -5.8470E-20, -6.3586E-20, -6.8863E-20, &
      -7.4330E-20, -8.0046E-20, -8.6060E-20, -9.2246E-20, -9.8705E-20, -1.0555E-19, &
      -1.1728E-19, -1.3797E-19, -1.4079E-19, -1.4803E-19, -1.5994E-19, -1.6278E-19, &
      -1.6998E-19, -1.8121E-19, -1.8364E-19, -1.9028E-19, -2.0086E-19, -2.0314E-19, &
      -2.0940E-19, -2.0847E-19, -2.1180E-19, -2.1875E-19, -2.2546E-19, -2.3150E-19, &
      -2.3680E-19, -2.4095E-19, -2.4428E-19, -2.4635E-19, -2.4788E-19, -2.4860E-19, &
      -2.4955E-19, -2.5055E-19, -2.5196E-19, -2.5413E-19, -2.5665E-19, -2.5925E-19, &
      -2.6117E-19, -2.6158E-19, -2.5970E-19, -2.5473E-19, -2.4648E-19, -2.3571E-19, &
      -2.2268E-19, -2.0851E-19, -1.9410E-19, -1.7954E-19, -1.6467E-19, -1.4961E-19, &
      -1.3382E-19, -1.1718E-19, -9.8325E-20, -8.1557E-20 /)
    REAL, PARAMETER :: a0_1_2_HNO4(dim58) = (/ &
      9.8591E-18, 1.0050E-17, 1.0256E-17, 1.0471E-17, 1.0701E-17, 1.0938E-17, &
      1.1185E-17, 1.1445E-17, 1.1719E-17, 1.2002E-17, 1.2299E-17, 1.2616E-17, &
      1.3160E-17, 1.4124E-17, 1.4256E-17, 1.4596E-17, 1.5159E-17, 1.5293E-17, &
      1.5636E-17, 1.6173E-17, 1.6289E-17, 1.6609E-17, 1.7121E-17, 1.7232E-17, &
      1.7538E-17, 1.7492E-17, 1.7656E-17, 1.7999E-17, 1.8332E-17, 1.8633E-17, &
      1.8898E-17, 1.9106E-17, 1.9274E-17, 1.9379E-17, 1.9456E-17, 1.9493E-17, &
      1.9542E-17, 1.9593E-17, 1.9666E-17, 1.9778E-17, 1.9909E-17, 2.0045E-17, &
      2.0146E-17, 2.0167E-17, 2.0068E-17, 1.9805E-17, 1.9365E-17, 1.8790E-17, &
      1.8092E-17, 1.7330E-17, 1.6552E-17, 1.5763E-17, 1.4954E-17, 1.4132E-17, &
      1.3266E-17, 1.2351E-17, 1.1310E-17, 1.0381E-17 /)
    REAL, PARAMETER :: a0_2_1_HNO4(dim58) = (/ &
      1.5013E-22, 1.6331E-22, 1.7706E-22, 1.9097E-22, 2.0595E-22, 2.2032E-22, &
      2.3522E-22, 2.5014E-22, 2.6634E-22, 2.8120E-22, 2.9734E-22, 3.1413E-22, &
      3.9971E-22, 6.0956E-22, 5.4859E-22, 5.5328E-22, 6.1636E-22, 5.6026E-22, &
      5.6297E-22, 6.1427E-22, 5.6195E-22, 5.6093E-22, 6.0251E-22, 5.5470E-22, &
      5.5144E-22, 4.7560E-22, 4.4563E-22, 4.5322E-22, 4.6086E-22, 4.6632E-22, &
      4.7044E-22, 4.7208E-22, 4.7224E-22, 4.6908E-22, 4.6541E-22, 4.5989E-22, &
      4.5507E-22, 4.5029E-22, 4.4565E-22, 4.4297E-22, 4.4021E-22, 4.3714E-22, &
      4.3153E-22, 4.2187E-22, 4.0718E-22, 3.8535E-22, 3.5787E-22, 3.2667E-22, &
      2.9286E-22, 2.5947E-22, 2.2844E-22, 1.9927E-22, 1.7112E-22, 1.4508E-22, &
      1.1992E-22, 9.6883E-23, 7.4880E-23, 6.0502E-23 /)
    REAL, PARAMETER :: a0_2_2_HNO4(dim58) = (/ &
      -1.1178E-20, -1.1760E-20, -1.2371E-20, -1.2991E-20, -1.3662E-20, -1.4309E-20, &
      -1.4982E-20, -1.5659E-20, -1.6398E-20, -1.7079E-20, -1.7822E-20, -1.8597E-20, &
      -2.2568E-20, -3.2347E-20, -2.9494E-20, -2.9714E-20, -3.2692E-20, -3.0032E-20, &
      -3.0161E-20, -3.2613E-20, -3.0102E-20, -3.0053E-20, -3.2065E-20, -2.9742E-20, &
      -2.9583E-20, -2.5866E-20, -2.4392E-20, -2.4767E-20, -2.5146E-20, -2.5418E-20, &
      -2.5624E-20, -2.5706E-20, -2.5714E-20, -2.5554E-20, -2.5368E-20, -2.5086E-20, &
      -2.4840E-20, -2.4594E-20, -2.4355E-20, -2.4216E-20, -2.4072E-20, -2.3912E-20, &
      -2.3618E-20, -2.3110E-20, -2.2334E-20, -2.1177E-20, -1.9715E-20, -1.8049E-20, &
      -1.6237E-20, -1.4440E-20, -1.2765E-20, -1.1184E-20, -9.6526E-21, -8.2307E-21, &
      -6.8518E-21, -5.5849E-21, -4.3704E-21, -3.5738E-21 /)
    REAL, PARAMETER :: a1_1_HNO4(dim55) = (/ &
      3.4388E-20, 3.3440E-20, 3.3382E-20, 3.1197E-20, 3.0114E-20, 2.7626E-20, &
      2.6225E-20, 2.3982E-20, 2.2716E-20, 2.0882E-20, 1.9791E-20, 1.8371E-20, &
      1.7503E-20, 1.6374E-20, 1.5668E-20, 1.4771E-20, 1.4175E-20, 1.3460E-20, &
      1.2942E-20, 1.2378E-20, 1.1928E-20, 1.1449E-20, 1.1046E-20, 1.0658E-20, &
      1.0309E-20, 9.9566E-21, 9.6549E-21, 9.3782E-21, 9.0631E-21, 8.8479E-21, &
      8.5669E-21, 8.3767E-21, 8.1250E-21, 7.9601E-21, 7.7177E-21, 7.5811E-21, &
      7.3622E-21, 7.2609E-21, 7.0270E-21, 6.9525E-21, 6.5052E-21, 5.9431E-21, &
      5.4524E-21, 5.0744E-21, 4.7050E-21, 4.4289E-21, 4.1348E-21, 3.9235E-21, &
      3.5929E-21, 3.3732E-21, 3.1730E-21, 2.9829E-21, 2.8111E-21, 2.6488E-21, &
      2.4983E-21 /)
    REAL, PARAMETER :: b1_1_HNO4(dim55) = (/ &
      1.1548E-18, 1.1577E-18, 1.1580E-18, 1.1755E-18, 1.1868E-18, 1.2192E-18, &
      1.2409E-18, 1.2813E-18, 1.3072E-18, 1.3494E-18, 1.3772E-18, 1.4170E-18, &
      1.4435E-18, 1.4807E-18, 1.5058E-18, 1.5399E-18, 1.5640E-18, 1.5947E-18, &
      1.6183E-18, 1.6454E-18, 1.6681E-18, 1.6935E-18, 1.7158E-18, 1.7384E-18, &
      1.7595E-18, 1.7817E-18, 1.8014E-18, 1.8202E-18, 1.8425E-18, 1.8582E-18, &
      1.8794E-18, 1.8942E-18, 1.9145E-18, 1.9282E-18, 1.9489E-18, 1.9609E-18, &
      1.9807E-18, 1.9902E-18, 2.0125E-18, 2.0198E-18, 2.0647E-18, 2.1283E-18, &
      2.1898E-18, 2.2420E-18, 2.2976E-18, 2.3426E-18, 2.3942E-18, 2.4340E-18, &
      2.5002E-18, 2.5470E-18, 2.5922E-18, 2.6374E-18, 2.6805E-18, 2.7231E-18, &
      2.7646E-18 /)
    REAL, PARAMETER :: a1_2_HNO4(dim55) = (/ &
      -9.2764E-23, -5.2447E-23, -5.3707E-23, -1.8660E-23, -1.9605E-23, 4.7084E-24, &
      2.3734E-24, 1.7080E-23, 1.2966E-23, 2.1390E-23, 1.7444E-23, 2.1924E-23, &
      1.8201E-23, 2.0726E-23, 1.7755E-23, 1.9140E-23, 1.6896E-23, 1.7464E-23, &
      1.5887E-23, 1.5914E-23, 1.4743E-23, 1.4574E-23, 1.3881E-23, 1.3383E-23, &
      1.2792E-23, 1.2453E-23, 1.1906E-23, 1.1373E-23, 1.1309E-23, 1.0467E-23, &
      1.0507E-23, 9.7455E-24, 9.8212E-24, 9.0315E-24, 9.2653E-24, 8.4251E-24, &
      8.6950E-24, 7.7495E-24, 8.2157E-24, 7.2955E-24, 7.0367E-24, 5.9856E-24, &
      5.4081E-24, 4.6772E-24, 4.4028E-24, 3.8581E-24, 3.7468E-24, 3.3115E-24, &
      3.7575E-24, 3.6591E-24, 3.5777E-24, 3.5141E-24, 3.4370E-24, 3.3669E-24, &
      3.2982E-24 /)
    REAL, PARAMETER :: b1_2_HNO4(dim55) = (/ &
      -2.3058E-21, -2.4267E-21, -2.4198E-21, -2.7002E-21, -2.6903E-21, -3.0063E-21, &
      -2.9701E-21, -3.2349E-21, -3.1505E-21, -3.3443E-21, -3.2437E-21, -3.3691E-21, &
      -3.2556E-21, -3.3389E-21, -3.2334E-21, -3.2860E-21, -3.1952E-21, -3.2196E-21, &
      -3.1478E-21, -3.1491E-21, -3.0900E-21, -3.0810E-21, -3.0425E-21, -3.0137E-21, &
      -2.9779E-21, -2.9565E-21, -2.9207E-21, -2.8845E-21, -2.8799E-21, -2.8185E-21, &
      -2.8216E-21, -2.7621E-21, -2.7682E-21, -2.7027E-21, -2.7227E-21, -2.6487E-21, &
      -2.6732E-21, -2.5852E-21, -2.6297E-21, -2.5396E-21, -2.5136E-21, -2.3948E-21, &
      -2.3223E-21, -2.2215E-21, -2.1802E-21, -2.0914E-21, -2.0718E-21, -1.9900E-21, &
      -2.0794E-21, -2.0585E-21, -2.0401E-21, -2.0250E-21, -2.0057E-21, -1.9872E-21, &
      -1.9683E-21 /)
    REAL, PARAMETER :: a2_HNO4(dim55) = (/ &
      -9.0560E-21, -7.9600E-21, -6.5480E-21, -5.1244E-21, -3.8668E-21, -2.8572E-21, &
      -2.0936E-21, -1.5380E-21, -1.1412E-21, -8.5960E-22, -6.6040E-22, -5.1800E-22, &
      -4.1480E-22, -3.3920E-22, -2.8240E-22, -2.3880E-22, -2.0560E-22, -1.7880E-22, &
      -1.5720E-22, -1.4000E-22, -1.2520E-22, -1.1280E-22, -1.0240E-22, -9.3200E-23, &
      -8.5200E-23, -7.8001E-23, -7.2000E-23, -6.6800E-23, -6.1200E-23, -5.7201E-23, &
      -5.2800E-23, -4.9199E-23, -4.5601E-23, -4.2800E-23, -3.9600E-23, -3.6799E-23, &
      -3.4800E-23, -3.2000E-23, -3.0400E-23, -2.8000E-23, -2.3200E-23, -1.6640E-23, &
      -1.2000E-23, -8.6402E-24, -6.2400E-24, -4.4800E-24, -3.1999E-24, -2.4001E-24, &
      -1.6800E-24, -1.1999E-24, -8.7991E-25, -6.4003E-25, -4.0015E-25, -3.2002E-25, &
      -2.3988E-25 /)
    REAL, PARAMETER :: b2_HNO4(dim55) = (/ &
       1.6843E-19,  1.6514E-19,  1.5737E-19,  1.4599E-19,  1.3278E-19,  1.1966E-19, &
       1.0782E-19,  9.7819E-20,  8.9685E-20,  8.3208E-20,  7.8128E-20,  7.4141E-20, &
       7.0993E-20,  6.8499E-20,  6.6482E-20,  6.4825E-20,  6.3481E-20,  6.2328E-20, &
       6.1346E-20,  6.0520E-20,  5.9773E-20,  5.9115E-20,  5.8538E-20,  5.8005E-20, &
       5.7521E-20,  5.7067E-20,  5.6674E-20,  5.6320E-20,  5.5926E-20,  5.5634E-20, &
       5.5301E-20,  5.5021E-20,  5.4731E-20,  5.4498E-20,  5.4225E-20,  5.3978E-20, &
       5.3797E-20,  5.3537E-20,  5.3384E-20,  5.3149E-20,  5.2667E-20,  5.1925E-20, &
       5.1343E-20,  5.0879E-20,  5.0518E-20,  5.0231E-20,  5.0007E-20,  4.9856E-20, &
       4.9712E-20,  4.9610E-20,  4.9537E-20,  4.9480E-20,  4.9420E-20,  4.9399E-20, &
       4.9377E-20 /)
    REAL, PARAMETER :: a3_HNO4(dim55) = (/ &
      -7.7762E-23, -6.5423E-23, -5.2320E-23, -4.0460E-23, -3.0950E-23, -2.3722E-23, &
      -1.8418E-23, -1.4537E-23, -1.1781E-23, -9.6645E-24, -8.1502E-24, -6.9090E-24, &
      -5.9904E-24, -5.1917E-24, -4.5945E-24, -4.1134E-24, -3.6342E-24, -3.3147E-24, &
      -2.9964E-24, -2.7157E-24, -2.5160E-24, -2.2764E-24, -2.1174E-24, -1.9569E-24, &
      -1.8371E-24, -1.7172E-24, -1.5981E-24, -1.4976E-24, -1.4098E-24, -1.3299E-24, &
      -1.2585E-24, -1.1901E-24, -1.1262E-24, -1.0703E-24, -1.0228E-24, -9.7045E-25, &
      -9.2251E-25, -8.8657E-25, -8.4700E-25, -8.1070E-25, -7.1645E-25, -5.9345E-25, &
      -4.9920E-25, -4.2572E-25, -3.6690E-25, -3.1789E-25, -2.7636E-25, -2.4201E-25, &
      -2.1247E-25, -1.8610E-25, -1.6373E-25, -1.4457E-25, -1.2790E-25, -1.1262E-25, &
      -9.9039E-26 /)
    REAL, PARAMETER :: b3_HNO4(dim55) = (/ &
      2.0239E-20, 1.9924E-20, 1.9261E-20, 1.8364E-20, 1.7407E-20, 1.6499E-20, &
      1.5699E-20, 1.5017E-20, 1.4464E-20, 1.3986E-20, 1.3606E-20, 1.3263E-20, &
      1.2987E-20, 1.2726E-20, 1.2517E-20, 1.2336E-20, 1.2144E-20, 1.2008E-20, &
      1.1864E-20, 1.1730E-20, 1.1630E-20, 1.1504E-20, 1.1416E-20, 1.1324E-20, &
      1.1252E-20, 1.1177E-20, 1.1099E-20, 1.1031E-20, 1.0970E-20, 1.0911E-20, &
      1.0858E-20, 1.0805E-20, 1.0753E-20, 1.0707E-20, 1.0667E-20, 1.0621E-20, &
      1.0578E-20, 1.0544E-20, 1.0507E-20, 1.0471E-20, 1.0377E-20, 1.0238E-20, &
      1.0120E-20, 1.0019E-20, 9.9305E-21, 9.8507E-21, 9.7779E-21, 9.7134E-21, &
      9.6542E-21, 9.5981E-21, 9.5476E-21, 9.5020E-21, 9.4603E-21, 9.4201E-21, &
      9.3827E-21 /)
    REAL, PARAMETER :: a4_HNO4(3) = (/ 5.5298E-21, -1.0315E-24, 1.9101E-28 /)
    REAL, PARAMETER :: a5_HNO4(3) = (/ 9.5751E-22, -3.3529E-25, 4.6060E-29 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_HNO4(dim58) = (/ &
      -7.2181E-05, -4.4865E-05, -2.8612E-05, 2.9130E-05, -1.1794E-04, -8.8563E-05, &
      2.9131E-05, -1.7671E-04, -3.1089E-05, -4.4153E-03, -1.1909E-02, -1.2287E-02, &
      -1.2526E-02, -1.2980E-02, -1.3760E-02, -1.4466E-02, -1.5534E-02, -1.6542E-02, &
      -1.7770E-02, -1.8700E-02, -1.9211E-02, -1.9553E-02, -1.9266E-02, -1.8586E-02, &
      -1.7124E-02, -1.5698E-02, -1.4015E-02, -1.2763E-02, -1.2197E-02, -1.2582E-02, &
      -1.4092E-02, -1.6998E-02, -2.0717E-02, -2.5024E-02, -2.9144E-02, -3.2165E-02, &
      -3.3513E-02, -3.2489E-02, -2.8579E-02, -2.2063E-02, -1.3619E-02, -4.5237E-03, &
      4.0242E-03, 1.0422E-02, 1.4822E-02, 1.6793E-02, 1.8416E-02, 2.1008E-02, &
      2.6836E-02, 3.6682E-02, 5.0067E-02, 6.4288E-02, 7.7256E-02, 8.8850E-02, &
      1.0605E-01, 1.4554E-01, 2.3078E-01, 3.3551E-01 /)
    REAL, PARAMETER :: c0_1_2_HNO4(dim58) = (/ &
      3.2004E-03, 1.9794E-03, 1.2496E-03, -1.3546E-03, 5.3079E-03, 3.9711E-03, &
      -1.4076E-03, 8.0407E-03, 1.3274E-03, 2.0431E-01, 5.5275E-01, 5.7045E-01, &
      5.8164E-01, 6.0303E-01, 6.3989E-01, 6.7343E-01, 7.2437E-01, 7.7266E-01, &
      8.3172E-01, 8.7665E-01, 9.0146E-01, 9.1809E-01, 9.0408E-01, 8.7069E-01, &
      7.9861E-01, 7.2803E-01, 6.4435E-01, 5.8187E-01, 5.5353E-01, 5.7290E-01, &
      6.4915E-01, 7.9650E-01, 9.8579E-01, 1.2059E+00, 1.4172E+00, 1.5728E+00, &
      1.6425E+00, 1.5894E+00, 1.3856E+00, 1.0449E+00, 6.0158E-01, 1.2223E-01, &
      -3.2996E-01, -6.6966E-01, -9.0419E-01, -1.0096E+00, -1.0968E+00, -1.2365E+00, &
      -1.5518E+00, -2.0864E+00, -2.8159E+00, -3.5938E+00, -4.3057E+00, -4.9446E+00, &
      -5.8960E+00, -8.0873E+00, -1.2835E+01, -1.8690E+01 /)
    REAL, PARAMETER :: c0_2_1_HNO4(dim58) = (/ &
      -6.5308E-04, 4.4815E-05, -3.3935E-04, 3.9374E-04, -8.6426E-05, -1.1588E-03, &
      1.4854E-03, -8.7701E-04, -2.5295E-04, -1.5525E-03, -6.5195E-03, -5.3298E-03, &
      -5.5959E-03, -3.7358E-03, -3.9853E-03, -4.5075E-03, -3.7677E-03, -3.9085E-03, &
      -5.0483E-03, -4.1928E-03, -4.7544E-03, -3.9667E-03, -3.4540E-03, -2.2120E-03, &
      -2.6342E-03, -2.0072E-03, -1.0564E-03, -1.2612E-03, -2.0744E-03, -3.9054E-03, &
      -4.5513E-03, -3.8008E-03, -6.4905E-03, -7.4246E-03, -5.6500E-03, -3.7002E-03, &
      8.5798E-04, 7.8394E-03, 1.4488E-02, 2.1034E-02, 2.3516E-02, 2.2436E-02, &
      1.9332E-02, 1.6490E-02, 1.4662E-02, 1.6947E-02, 1.8835E-02, 1.8839E-02, &
      9.8314E-03, -5.0162E-03, -3.4518E-02, -6.0306E-02, -7.2201E-02, -5.9828E-02, &
      -2.3871E-02, 5.2611E-02, 2.3544E-01, 5.5139E-01 /)
    REAL, PARAMETER :: c0_2_2_HNO4(dim58) = (/ &
      3.1907E-02, 7.1124E-04, 1.7960E-02, -1.5102E-02, 6.6494E-03, 5.5444E-02, &
      -6.5397E-02, 4.3037E-02, 1.4268E-02, 7.4439E-02, 3.0540E-01, 2.4984E-01, &
      2.6232E-01, 1.7471E-01, 1.8651E-01, 2.1132E-01, 1.7603E-01, 1.8277E-01, &
      2.3760E-01, 1.9628E-01, 2.2352E-01, 1.8515E-01, 1.6009E-01, 9.9101E-02, &
      1.1992E-01, 8.8881E-02, 4.1623E-02, 5.1845E-02, 9.2586E-02, 1.8468E-01, &
      2.1730E-01, 1.7925E-01, 3.1616E-01, 3.6389E-01, 2.7285E-01, 1.7244E-01, &
      -6.3219E-02, -4.2556E-01, -7.7196E-01, -1.1143E+00, -1.2446E+00, -1.1877E+00, &
      -1.0235E+00, -8.7258E-01, -7.7516E-01, -8.9740E-01, -9.9880E-01, -9.9900E-01, &
      -5.1169E-01, 2.9454E-01, 1.9024E+00, 3.3130E+00, 3.9660E+00, 3.2843E+00, &
      1.2959E+00, -2.9489E+00, -1.3133E+01, -3.0794E+01 /)

    jval_gp(ip_HNO4)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_HNO4(0) = &
          p1(a0_1_1_HNO4(i0(j,k))*dlv2(j,k) + &
          a0_1_2_HNO4(i0(j,k)), &
          a0_2_1_HNO4(i0(j,k))*dlv2(j,k) + &
          a0_2_2_HNO4(i0(j,k)),v3_du1(j,k)) * &
          p2(1.,c0_1_1_HNO4(i0(j,k))*dlv2(j,k)+ &
          c0_1_2_HNO4(i0(j,k)), &
          c0_2_1_HNO4(i0(j,k))*dlv2(j,k)+ &
          c0_2_2_HNO4(i0(j,k)),tnorm_sr(j,k))
        sig_HNO4(1) = (p1(b1_1_HNO4(i1(j,k)),a1_1_HNO4(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_HNO4(i1(j,k)),a1_2_HNO4(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_HNO4(2) = &
          p1(b2_HNO4(i2(j,k)), a2_HNO4(i2(j,k)), &
          v3_du1(j,k))
        sig_HNO4(3) = &
          p1(b3_HNO4(i3(j,k)), a3_HNO4(i3(j,k)), &
          v3_du2(j,k))
        sig_HNO4(4) = &
          p2(a4_HNO4(1),a4_HNO4(2),a4_HNO4(3),v3_du2(j,k))
        sig_HNO4(5) = &
          p2(a5_HNO4(1),a5_HNO4(2),a5_HNO4(3),v3_du2(j,k))
        dj = 0. &
          + sig_HNO4(0) * fint(j,k,0) &
          + sig_HNO4(1) * fint(j,k,1) &
          + sig_HNO4(2) * fint(j,k,2) &
          + sig_HNO4(3) * fint(j,k,3) &
          + sig_HNO4(4) * fint(j,k,4) &
          + sig_HNO4(5) * fint(j,k,5) + 1.E-5 ! mz_cb_20060511
          ! constant 1.E-5 added to correct for IR photolysis (Roehl, 2002)
        jval_gp(ip_HNO4)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,4))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_HNO4

  ! **************************************************************************

  SUBROUTINE jval_cal_PAN(jrow)

    ! PAN -> products JPL 1997, quantum yield = 1

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_PAN

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_PAN(dim58) = (/ &
      -3.9131E-21, -4.2480E-21, -4.7250E-21, -5.1075E-21, -5.6108E-21, -6.0939E-21, &
      -6.6774E-21, -7.2134E-21, -7.8083E-21, -8.4086E-21, -9.0972E-21, -9.8705E-21, &
      -1.0921E-20, -1.2861E-20, -1.3341E-20, -1.4180E-20, -1.5517E-20, -1.6012E-20, &
      -1.6994E-20, -1.8318E-20, -1.8896E-20, -1.9861E-20, -2.1179E-20, -2.1870E-20, &
      -2.2773E-20, -2.3278E-20, -2.4051E-20, -2.5175E-20, -2.6245E-20, -2.7434E-20, &
      -2.8480E-20, -2.9492E-20, -3.0401E-20, -3.1282E-20, -3.2082E-20, -3.2811E-20, &
      -3.3693E-20, -3.4537E-20, -3.5426E-20, -3.6680E-20, -3.7909E-20, -3.9221E-20, &
      -4.0562E-20, -4.1809E-20, -4.2838E-20, -4.3463E-20, -4.3627E-20, -4.3265E-20, &
      -4.2558E-20, -4.1321E-20, -3.9913E-20, -3.8089E-20, -3.6153E-20, -3.3945E-20, &
      -3.1446E-20, -2.8367E-20, -2.4477E-20, -2.0407E-20 /)
    REAL, PARAMETER :: a0_1_2_PAN(dim58) = (/ &
      3.8148E-18, 3.8296E-18, 3.8508E-18, 3.8678E-18, 3.8904E-18, 3.9121E-18, &
      3.9385E-18, 3.9628E-18, 3.9900E-18, 4.0175E-18, 4.0491E-18, 4.0849E-18, &
      4.1336E-18, 4.2240E-18, 4.2464E-18, 4.2859E-18, 4.3490E-18, 4.3725E-18, &
      4.4192E-18, 4.4825E-18, 4.5103E-18, 4.5567E-18, 4.6205E-18, 4.6541E-18, &
      4.6982E-18, 4.7230E-18, 4.7610E-18, 4.8165E-18, 4.8696E-18, 4.9288E-18, &
      4.9811E-18, 5.0319E-18, 5.0777E-18, 5.1223E-18, 5.1629E-18, 5.2001E-18, &
      5.2452E-18, 5.2886E-18, 5.3345E-18, 5.3995E-18, 5.4634E-18, 5.5318E-18, &
      5.6021E-18, 5.6677E-18, 5.7220E-18, 5.7552E-18, 5.7639E-18, 5.7446E-18, &
      5.7067E-18, 5.6401E-18, 5.5641E-18, 5.4652E-18, 5.3599E-18, 5.2394E-18, &
      5.1024E-18, 4.9330E-18, 4.7183E-18, 4.4929E-18 /)
    REAL, PARAMETER :: a0_2_1_PAN(dim58) = (/ &
      1.2381E-23, 1.2519E-23, 1.4615E-23, 1.4831E-23, 1.6211E-23, 1.7187E-23, &
      1.8832E-23, 1.9709E-23, 2.1142E-23, 2.1983E-23, 2.3328E-23, 2.4784E-23, &
      3.0812E-23, 4.7565E-23, 4.3156E-23, 4.3429E-23, 4.9182E-23, 4.4588E-23, &
      4.5428E-23, 5.0058E-23, 4.6369E-23, 4.6332E-23, 5.0524E-23, 4.7470E-23, &
      4.6957E-23, 4.1514E-23, 3.9298E-23, 4.0364E-23, 4.0979E-23, 4.2595E-23, &
      4.3629E-23, 4.4318E-23, 4.4931E-23, 4.5685E-23, 4.6088E-23, 4.6032E-23, &
      4.6748E-23, 4.7135E-23, 4.7057E-23, 4.8478E-23, 4.9355E-23, 5.0083E-23, &
      5.0454E-23, 5.1059E-23, 5.1093E-23, 5.0009E-23, 4.8476E-23, 4.6033E-23, &
      4.3708E-23, 4.0467E-23, 3.8036E-23, 3.3534E-23, 3.0892E-23, 2.7456E-23, &
      2.4070E-23, 2.0028E-23, 1.6476E-23, 1.2913E-23 /)
    REAL, PARAMETER :: a0_2_2_PAN(dim58) = (/ &
      -1.0350E-21, -1.0411E-21, -1.1342E-21, -1.1438E-21, -1.2056E-21, -1.2496E-21, &
      -1.3239E-21, -1.3637E-21, -1.4291E-21, -1.4676E-21, -1.5295E-21, -1.5967E-21, &
      -1.8764E-21, -2.6571E-21, -2.4508E-21, -2.4636E-21, -2.7351E-21, -2.5174E-21, &
      -2.5574E-21, -2.7787E-21, -2.6016E-21, -2.5998E-21, -2.8027E-21, -2.6543E-21, &
      -2.6293E-21, -2.3626E-21, -2.2536E-21, -2.3062E-21, -2.3367E-21, -2.4172E-21, &
      -2.4689E-21, -2.5035E-21, -2.5344E-21, -2.5725E-21, -2.5930E-21, -2.5901E-21, &
      -2.6268E-21, -2.6467E-21, -2.6426E-21, -2.7163E-21, -2.7619E-21, -2.7998E-21, &
      -2.8193E-21, -2.8511E-21, -2.8529E-21, -2.7955E-21, -2.7139E-21, -2.5835E-21, &
      -2.4588E-21, -2.2845E-21, -2.1532E-21, -1.9092E-21, -1.7655E-21, -1.5779E-21, &
      -1.3923E-21, -1.1700E-21, -9.7392E-22, -7.7657E-22 /)
    REAL, PARAMETER :: a1_1_PAN(dim55) = (/ &
      3.1194E-20, 3.0154E-20, 2.9736E-20, 2.7624E-20, 2.6269E-20, 2.3969E-20, &
      2.2412E-20, 2.0393E-20, 1.9024E-20, 1.7429E-20, 1.6248E-20, 1.5065E-20, &
      1.4110E-20, 1.3208E-20, 1.2416E-20, 1.1745E-20, 1.1077E-20, 1.0541E-20, &
      9.9683E-21, 9.5871E-21, 9.0646E-21, 8.7440E-21, 8.2961E-21, 8.0439E-21, &
      7.6227E-21, 7.4632E-21, 7.0587E-21, 6.9264E-21, 6.5638E-21, 6.4686E-21, &
      6.1295E-21, 6.0746E-21, 5.7310E-21, 5.7185E-21, 5.4101E-21, 5.3901E-21, &
      5.1035E-21, 5.0925E-21, 4.8277E-21, 4.8488E-21, 4.4173E-21, 3.9690E-21, &
      3.5478E-21, 3.2584E-21, 2.9516E-21, 2.7504E-21, 2.5099E-21, 2.3637E-21, &
      2.0838E-21, 1.9321E-21, 1.7968E-21, 1.6681E-21, 1.5556E-21, 1.4519E-21, &
      1.3549E-21 /)
    REAL, PARAMETER :: b1_1_PAN(dim55) = (/ &
      7.4088E-19, 7.4399E-19, 7.4630E-19, 7.6319E-19, 7.7741E-19, 8.0732E-19, &
      8.3146E-19, 8.6780E-19, 8.9585E-19, 9.3255E-19, 9.6267E-19, 9.9579E-19, &
      1.0249E-18, 1.0547E-18, 1.0828E-18, 1.1083E-18, 1.1353E-18, 1.1584E-18, &
      1.1845E-18, 1.2028E-18, 1.2291E-18, 1.2461E-18, 1.2710E-18, 1.2856E-18, &
      1.3111E-18, 1.3211E-18, 1.3476E-18, 1.3566E-18, 1.3822E-18, 1.3892E-18, &
      1.4148E-18, 1.4190E-18, 1.4467E-18, 1.4477E-18, 1.4741E-18, 1.4759E-18, &
      1.5018E-18, 1.5028E-18, 1.5281E-18, 1.5260E-18, 1.5694E-18, 1.6201E-18, &
      1.6729E-18, 1.7129E-18, 1.7590E-18, 1.7918E-18, 1.8340E-18, 1.8615E-18, &
      1.9176E-18, 1.9499E-18, 1.9805E-18, 2.0111E-18, 2.0393E-18, 2.0665E-18, &
      2.0933E-18 /)
    REAL, PARAMETER :: a1_2_PAN(dim55) = (/ &
      -7.5113E-23, -3.9593E-23, -3.7585E-23, -8.3380E-24, -6.1654E-24, 1.2423E-23, &
      1.2486E-23, 2.2234E-23, 2.0440E-23, 2.4637E-23, 2.2971E-23, 2.3826E-23, &
      2.2412E-23, 2.1838E-23, 2.0970E-23, 1.9514E-23, 1.9232E-23, 1.7684E-23, &
      1.7643E-23, 1.5613E-23, 1.6109E-23, 1.4346E-23, 1.4814E-23, 1.2970E-23, &
      1.3684E-23, 1.1678E-23, 1.2714E-23, 1.0756E-23, 1.1756E-23, 9.8646E-24, &
      1.0880E-23, 9.0051E-24, 1.0277E-23, 8.2357E-24, 9.4731E-24, 7.6966E-24, &
      8.8714E-24, 7.1582E-24, 8.3208E-24, 6.5827E-24, 6.7994E-24, 5.5699E-24, &
      5.0937E-24, 4.2445E-24, 4.0078E-24, 3.3814E-24, 3.2940E-24, 2.8045E-24, &
      3.2552E-24, 3.0727E-24, 2.9063E-24, 2.7691E-24, 2.6308E-24, 2.5075E-24, &
      2.4011E-24 /)
    REAL, PARAMETER :: b1_2_PAN(dim55) = (/ &
      -2.0885E-21, -2.1950E-21, -2.2061E-21, -2.4401E-21, -2.4629E-21, -2.7045E-21, &
      -2.7055E-21, -2.8810E-21, -2.8442E-21, -2.9407E-21, -2.8982E-21, -2.9222E-21, &
      -2.8790E-21, -2.8601E-21, -2.8293E-21, -2.7740E-21, -2.7625E-21, -2.6960E-21, &
      -2.6941E-21, -2.5967E-21, -2.6217E-21, -2.5283E-21, -2.5543E-21, -2.4473E-21, &
      -2.4905E-21, -2.3641E-21, -2.4320E-21, -2.2988E-21, -2.3693E-21, -2.2313E-21, &
      -2.3080E-21, -2.1617E-21, -2.2641E-21, -2.0946E-21, -2.2004E-21, -2.0441E-21, &
      -2.1504E-21, -1.9911E-21, -2.1021E-21, -1.9318E-21, -1.9536E-21, -1.8146E-21, &
      -1.7549E-21, -1.6377E-21, -1.6021E-21, -1.5000E-21, -1.4846E-21, -1.3926E-21, &
      -1.4830E-21, -1.4441E-21, -1.4066E-21, -1.3739E-21, -1.3393E-21, -1.3069E-21, &
      -1.2775E-21 /)
    REAL, PARAMETER :: a2_PAN(dim55) = (/ &
      -2.2016E-21, -1.8904E-21, -1.5176E-21, -1.1552E-21, -8.4560E-22, -6.0432E-22, &
      -4.2716E-22, -3.0184E-22, -2.1508E-22, -1.5564E-22, -1.1492E-22, -8.6840E-23, &
      -6.7240E-23, -5.3360E-23, -4.3320E-23, -3.5920E-23, -3.0360E-23, -2.6080E-23, &
      -2.2640E-23, -1.9960E-23, -1.7760E-23, -1.5880E-23, -1.4360E-23, -1.3000E-23, &
      -1.1880E-23, -1.0840E-23, -9.9599E-24, -9.1601E-24, -8.4799E-24, -7.8401E-24, &
      -7.2800E-24, -6.7199E-24, -6.2400E-24, -5.8400E-24, -5.4400E-24, -5.0400E-24, &
      -4.7199E-24, -4.4001E-24, -4.1201E-24, -3.8399E-24, -3.1440E-24, -2.2640E-24, &
      -1.6240E-24, -1.1680E-24, -8.4799E-25, -6.0801E-25, -4.3999E-25, -3.1200E-25, &
      -2.3200E-25, -1.6001E-25, -1.2001E-25, -8.7985E-26, -5.5996E-26, -4.8015E-26, &
      -3.1989E-26 /)
    REAL, PARAMETER :: b2_PAN(dim55) = (/ &
       3.1199E-20,  3.0265E-20,  2.8215E-20,  2.5316E-20,  2.2065E-20,  1.8928E-20, &
       1.6182E-20,  1.3926E-20,  1.2148E-20,  1.0781E-20,  9.7424E-21,  8.9561E-21, &
       8.3583E-21,  7.9003E-21,  7.5439E-21,  7.2627E-21,  7.0375E-21,  6.8534E-21, &
       6.6969E-21,  6.5683E-21,  6.4572E-21,  6.3575E-21,  6.2732E-21,  6.1943E-21, &
       6.1265E-21,  6.0610E-21,  6.0034E-21,  5.9490E-21,  5.9010E-21,  5.8543E-21, &
       5.8120E-21,  5.7684E-21,  5.7297E-21,  5.6965E-21,  5.6623E-21,  5.6271E-21, &
       5.5982E-21,  5.5684E-21,  5.5417E-21,  5.5142E-21,  5.4443E-21,  5.3448E-21, &
       5.2645E-21,  5.2016E-21,  5.1534E-21,  5.1143E-21,  5.0848E-21,  5.0608E-21, &
       5.0447E-21,  5.0294E-21,  5.0204E-21,  5.0127E-21,  5.0047E-21,  5.0026E-21, &
       4.9982E-21 /)
    REAL, PARAMETER :: a3_PAN(dim55) = (/ &
      -7.8561E-24, -6.5902E-24, -5.2520E-24, -4.0500E-24, -3.0911E-24, -2.3642E-24, &
      -1.8378E-24, -1.4497E-24, -1.1749E-24, -9.7005E-25, -8.1582E-25, -6.9729E-25, &
      -6.0343E-25, -5.2796E-25, -4.6624E-25, -4.1493E-25, -3.7141E-25, -3.3506E-25, &
      -3.0324E-25, -2.7596E-25, -2.5200E-25, -2.3123E-25, -2.1295E-25, -1.9688E-25, &
      -1.8211E-25, -1.6933E-25, -1.5781E-25, -1.4697E-25, -1.3778E-25, -1.2939E-25, &
      -1.2106E-25, -1.1422E-25, -1.0783E-25, -1.0144E-25, -9.6285E-26, -9.0655E-26, &
      -8.6261E-26, -8.1868E-26, -7.7907E-26, -7.4281E-26, -6.4617E-26, -5.1997E-26, &
      -4.2812E-26, -3.5703E-26, -3.0136E-26, -2.5798E-26, -2.2045E-26, -1.9090E-26, &
      -1.6533E-26, -1.4377E-26, -1.2540E-26, -1.1022E-26, -9.5922E-27, -8.3864E-27, &
      -7.3485E-27 /)
    REAL, PARAMETER :: b3_PAN(dim55) = (/ &
      1.8351E-21, 1.8028E-21, 1.7351E-21, 1.6442E-21, 1.5477E-21, 1.4564E-21, &
      1.3770E-21, 1.3088E-21, 1.2536E-21, 1.2074E-21, 1.1687E-21, 1.1360E-21, &
      1.1077E-21, 1.0831E-21, 1.0614E-21, 1.0421E-21, 1.0247E-21, 1.0092E-21, &
      9.9484E-22, 9.8185E-22, 9.6984E-22, 9.5891E-22, 9.4883E-22, 9.3958E-22, &
      9.3069E-22, 9.2268E-22, 9.1518E-22, 9.0784E-22, 9.0140E-22, 8.9531E-22, &
      8.8904E-22, 8.8373E-22, 8.7861E-22, 8.7332E-22, 8.6893E-22, 8.6400E-22, &
      8.6003E-22, 8.5596E-22, 8.5219E-22, 8.4865E-22, 8.3897E-22, 8.2474E-22, &
      8.1324E-22, 8.0344E-22, 7.9508E-22, 7.8802E-22, 7.8144E-22, 7.7589E-22, &
      7.7076E-22, 7.6617E-22, 7.6203E-22, 7.5842E-22, 7.5484E-22, 7.5167E-22, &
      7.4881E-22 /)
    REAL, PARAMETER :: a4_PAN(3) = (/ 4.5535E-22, -7.9318E-26, 1.4366E-29 /)
    REAL, PARAMETER :: a5_PAN(3) = (/ 1.0338E-22, -2.1603E-26, 3.1324E-30 /)
    REAL, PARAMETER :: a6_PAN(1) = (/ 2.3057E-24 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_PAN(dim58) = (/ &
      -1.9494E-03, -1.9494E-03, -1.9494E-03, -1.9521E-03, -2.3483E-03, -2.4709E-03, &
      -2.7484E-03, -2.9324E-03, -3.1501E-03, -3.8810E-03, -3.5215E-03, -3.8951E-03, &
      -4.3891E-03, -4.5179E-03, -4.4628E-03, -5.3575E-03, -5.6435E-03, -5.8995E-03, &
      -6.7068E-03, -7.0305E-03, -7.9031E-03, -8.4100E-03, -9.0219E-03, -9.8695E-03, &
      -1.0147E-02, -1.0797E-02, -1.0950E-02, -1.1517E-02, -1.1706E-02, -1.1697E-02, &
      -1.2176E-02, -1.2991E-02, -1.3890E-02, -1.4902E-02, -1.6518E-02, -1.8357E-02, &
      -2.0035E-02, -2.1801E-02, -2.3196E-02, -2.4268E-02, -2.4177E-02, -2.3766E-02, &
      -2.2453E-02, -2.0841E-02, -1.8552E-02, -1.6195E-02, -1.4161E-02, -1.2733E-02, &
      -1.0822E-02, -9.2644E-03, -6.0927E-03, -1.9238E-03, 3.8967E-03, 1.1259E-02, &
      1.8770E-02, 2.6671E-02, 3.5769E-02, 4.6991E-02 /)
    REAL, PARAMETER :: c0_1_2_PAN(dim58) = (/ &
      5.1023E-01, 5.1023E-01, 5.1023E-01, 5.1035E-01, 5.2810E-01, 5.3362E-01, &
      5.4616E-01, 5.5451E-01, 5.6444E-01, 5.9791E-01, 5.8138E-01, 5.9864E-01, &
      6.2156E-01, 6.2756E-01, 6.2498E-01, 6.6703E-01, 6.8053E-01, 6.9267E-01, &
      7.3109E-01, 7.4657E-01, 7.8845E-01, 8.1288E-01, 8.4250E-01, 8.8370E-01, &
      8.9722E-01, 9.2909E-01, 9.3662E-01, 9.6465E-01, 9.7402E-01, 9.7354E-01, &
      9.9749E-01, 1.0384E+00, 1.0837E+00, 1.1349E+00, 1.2170E+00, 1.3108E+00, &
      1.3967E+00, 1.4875E+00, 1.5595E+00, 1.6150E+00, 1.6103E+00, 1.5888E+00, &
      1.5200E+00, 1.4352E+00, 1.3144E+00, 1.1894E+00, 1.0813E+00, 1.0050E+00, &
      9.0257E-01, 8.1876E-01, 6.4748E-01, 4.2153E-01, 1.0490E-01, -2.9706E-01, &
      -7.0867E-01, -1.1432E+00, -1.6455E+00, -2.2671E+00 /)
    REAL, PARAMETER :: c1_PAN(4) = (/ 1.00,  0.20,  0.00,  0.00 /)
    REAL, PARAMETER :: c2_PAN(4) = (/ 1.00,  1.73,  1.49,  0.00 /)
    REAL, PARAMETER :: c3_PAN(4) = (/ 1.00,  2.57,  3.45,  2.95 /)
    REAL, PARAMETER :: c4_PAN(4) = (/ 1.00,  2.28,  2.69,  2.03 /)
    REAL, PARAMETER :: c5_PAN(4) = (/ 1.00,  2.57,  3.45,  2.95 /)

    jval_gp(ip_PAN)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_PAN(0) = &
          p1(1.,c0_1_1_PAN(i0(j,k))*dlv2(j,k) + &
          c0_1_2_PAN(i0(j,k)),tnorm_sr(j,k)) * &
          p1(a0_1_1_PAN(i0(j,k))*dlv2(j,k) + &
          a0_1_2_PAN(i0(j,k)), &
          a0_2_1_PAN(i0(j,k))*dlv2(j,k) + &
          a0_2_2_PAN(i0(j,k)),v3_du1(j,k))
        sig_PAN(1) = &
          p1(c1_PAN(1),c1_PAN(2),tnorm(j,k)) * &
          p1(b1_1_PAN(i1(j,k)),a1_1_PAN(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_PAN(i1(j,k)),a1_2_PAN(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k)
        sig_PAN(2) = &
          p2(c2_PAN(1),c2_PAN(2),c2_PAN(3),tnorm(j,k))* &
          p1(b2_PAN(i2(j,k)), a2_PAN(i2(j,k)), &
          v3_du1(j,k))
        sig_PAN(3) = &
          p3(c3_PAN(1),c3_PAN(2),c3_PAN(3),c3_PAN(4),tnorm(j,k))* &
          p1(b3_PAN(i3(j,k)), a3_PAN(i3(j,k)), &
          v3_du2(j,k))
        sig_PAN(4) = &
          p3(c4_PAN(1),c4_PAN(2),c4_PAN(3),c4_PAN(4),tnorm(j,k))* &
          p2(a4_PAN(1),a4_PAN(2),a4_PAN(3),v3_du2(j,k))
        sig_PAN(5) = &
          p3(c5_PAN(1),c5_PAN(2),c5_PAN(3),c5_PAN(4),tnorm(j,k))* &
          p2(a5_PAN(1),a5_PAN(2),a5_PAN(3),v3_du2(j,k))
        sig_PAN(6) = &
          a6_PAN(1)
        dj = 0. &
          + sig_PAN(0) * fint(j,k,0) &
          + sig_PAN(1) * fint(j,k,1) &
          + sig_PAN(2) * fint(j,k,2) &
          + sig_PAN(3) * fint(j,k,3) &
          + sig_PAN(4) * fint(j,k,4) &
          + sig_PAN(5) * fint(j,k,5) &
          + sig_PAN(6) * fint(j,k,6)

        jval_gp(ip_PAN)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_PAN

  ! **************************************************************************

  SUBROUTINE jval_cal_HONO(jrow)

    ! HONO -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_HONO

    ! T-const parameters:
    REAL, PARAMETER :: a4_HONO(3) = (/ 1.1392E-20, 7.9033E-24, -1.4381E-27 /)
    REAL, PARAMETER :: a5_HONO(3) = (/ 6.8536E-20, 6.4883E-24, -8.6474E-28 /)
    REAL, PARAMETER :: a6_HONO(1) = (/ 7.4921E-20 /)

    jval_gp(ip_HONO)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_HONO(4) = &
          p2(a4_HONO(1),a4_HONO(2),a4_HONO(3),v3_du2(j,k))
        sig_HONO(5) = &
          p2(a5_HONO(1),a5_HONO(2),a5_HONO(3),v3_du2(j,k))
        sig_HONO(6) = &
          a6_HONO(1)
        dj = 0. &
          + sig_HONO(4) * fint(j,k,4) &
          + sig_HONO(5) * fint(j,k,5) &
          + sig_HONO(6) * fint(j,k,6)

        jval_gp(ip_HONO)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_HONO

  ! **************************************************************************

  SUBROUTINE jval_cal_CH3OOH(jrow)

    ! CH3OOH -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH3OOH

    ! T-const parameters:
    REAL, PARAMETER :: a1_1_CH3OOH(dim55) = (/ &
      4.3416E-21, 4.1597E-21, 4.0255E-21, 3.7060E-21, 3.4546E-21, 3.1227E-21, &
      2.8514E-21, 2.5778E-21, 2.3344E-21, 2.1326E-21, 1.9277E-21, 1.7835E-21, &
      1.6142E-21, 1.5132E-21, 1.3709E-21, 1.3003E-21, 1.1786E-21, 1.1302E-21, &
      1.0232E-21, 9.9171E-22, 8.9282E-22, 8.7714E-22, 7.8637E-22, 7.8007E-22, &
      6.9713E-22, 6.9661E-22, 6.1940E-22, 6.2639E-22, 5.5374E-22, 5.6583E-22, &
      4.9574E-22, 5.1232E-22, 4.4788E-22, 4.6518E-22, 4.0323E-22, 4.2488E-22, &
      3.6670E-22, 3.8842E-22, 3.3270E-22, 3.5692E-22, 2.9286E-22, 2.4563E-22, &
      1.9657E-22, 1.7003E-22, 1.3761E-22, 1.2232E-22, 9.9131E-23, 9.0216E-23, &
      6.2655E-23, 5.4203E-23, 4.6903E-23, 4.0507E-23, 3.5070E-23, 3.0556E-23, &
      2.6658E-23 /)
    REAL, PARAMETER :: b1_1_CH3OOH(dim55) = (/ &
      1.4232E-19, 1.4286E-19, 1.4360E-19, 1.4615E-19, 1.4879E-19, 1.5311E-19, &
      1.5732E-19, 1.6224E-19, 1.6723E-19, 1.7187E-19, 1.7710E-19, 1.8113E-19, &
      1.8630E-19, 1.8963E-19, 1.9468E-19, 1.9736E-19, 2.0229E-19, 2.0438E-19, &
      2.0924E-19, 2.1075E-19, 2.1575E-19, 2.1658E-19, 2.2162E-19, 2.2198E-19, &
      2.2700E-19, 2.2703E-19, 2.3209E-19, 2.3162E-19, 2.3674E-19, 2.3585E-19, &
      2.4115E-19, 2.3985E-19, 2.4504E-19, 2.4361E-19, 2.4890E-19, 2.4700E-19, &
      2.5226E-19, 2.5024E-19, 2.5556E-19, 2.5319E-19, 2.5963E-19, 2.6496E-19, &
      2.7112E-19, 2.7478E-19, 2.7966E-19, 2.8216E-19, 2.8622E-19, 2.8790E-19, &
      2.9343E-19, 2.9523E-19, 2.9687E-19, 2.9840E-19, 2.9976E-19, 3.0094E-19, &
      3.0202E-19 /)
    REAL, PARAMETER :: a1_2_CH3OOH(dim55) = (/ &
      -8.5817E-24, -3.8942E-24, -2.9820E-24, 5.5541E-25, 1.3337E-24, 3.2830E-24, &
      3.7493E-24, 4.3694E-24, 4.6428E-24, 4.4797E-24, 4.6802E-24, 4.1603E-24, &
      4.3946E-24, 3.7254E-24, 3.9913E-24, 3.3008E-24, 3.6001E-24, 2.9142E-24, &
      3.2581E-24, 2.5855E-24, 2.9675E-24, 2.2893E-24, 2.6971E-24, 2.0484E-24, &
      2.4598E-24, 1.8399E-24, 2.2455E-24, 1.6597E-24, 2.0594E-24, 1.4945E-24, &
      1.8949E-24, 1.3546E-24, 1.7353E-24, 1.2365E-24, 1.6013E-24, 1.1182E-24, &
      1.4691E-24, 1.0245E-24, 1.3617E-24, 9.3596E-25, 1.0312E-24, 7.8812E-25, &
      7.0931E-25, 5.4993E-25, 5.0891E-25, 3.9777E-25, 3.7944E-25, 2.9804E-25, &
      3.4799E-25, 3.0353E-25, 2.6562E-25, 2.3375E-25, 2.0700E-25, 1.8316E-25, &
      1.6219E-25 /)
    REAL, PARAMETER :: b1_2_CH3OOH(dim55) = (/ &
      -2.9004E-22, -3.0410E-22, -3.0912E-22, -3.3742E-22, -3.4559E-22, -3.7093E-22, &
      -3.7816E-22, -3.8932E-22, -3.9493E-22, -3.9117E-22, -3.9629E-22, -3.8173E-22, &
      -3.8887E-22, -3.6679E-22, -3.7623E-22, -3.4999E-22, -3.6211E-22, -3.3262E-22, &
      -3.4827E-22, -3.1598E-22, -3.3527E-22, -2.9933E-22, -3.2196E-22, -2.8434E-22, &
      -3.0923E-22, -2.7017E-22, -2.9674E-22, -2.5691E-22, -2.8509E-22, -2.4385E-22, &
      -2.7408E-22, -2.3193E-22, -2.6258E-22, -2.2118E-22, -2.5237E-22, -2.0985E-22, &
      -2.4161E-22, -2.0027E-22, -2.3247E-22, -1.9075E-22, -2.0031E-22, -1.7285E-22, &
      -1.6296E-22, -1.4097E-22, -1.3479E-22, -1.1667E-22, -1.1346E-22, -9.8156E-23, &
      -1.0817E-22, -9.8701E-23, -9.0152E-23, -8.2567E-23, -7.5867E-23, -6.9597E-23, &
      -6.3818E-23 /)
    REAL, PARAMETER :: a2_CH3OOH(dim55) = (/ &
      -7.4360E-22, -6.4840E-22, -5.2880E-22, -4.1000E-22, -3.0640E-22, -2.2420E-22, &
      -1.6272E-22, -1.1836E-22, -8.7040E-23, -6.5080E-23, -4.9640E-23, -3.8760E-23, &
      -3.0920E-23, -2.5240E-23, -2.1040E-23, -1.7800E-23, -1.5360E-23, -1.3360E-23, &
      -1.1800E-23, -1.0520E-23, -9.4399E-24, -8.5600E-24, -7.7600E-24, -7.0801E-24, &
      -6.5199E-24, -5.9602E-24, -5.5198E-24, -5.1201E-24, -4.7201E-24, -4.3598E-24, &
      -4.0800E-24, -3.8002E-24, -3.5598E-24, -3.2800E-24, -3.0800E-24, -2.8803E-24, &
      -2.6799E-24, -2.4799E-24, -2.3600E-24, -2.2001E-24, -1.8000E-24, -1.3040E-24, &
      -9.3601E-25, -6.7196E-25, -4.8804E-25, -3.5200E-25, -2.5597E-25, -1.8398E-25, &
      -1.2802E-25, -9.5966E-26, -7.2055E-26, -4.7951E-26, -4.0002E-26, -2.4040E-26, &
      -1.5962E-26 /)
    REAL, PARAMETER :: b2_CH3OOH(dim55) = (/ &
      1.7304E-20, 1.7018E-20, 1.6360E-20, 1.5410E-20, 1.4322E-20, 1.3254E-20, &
      1.2301E-20, 1.1502E-20, 1.0860E-20, 1.0355E-20, 9.9613E-21, 9.6567E-21, &
      9.4176E-21, 9.2301E-21, 9.0810E-21, 8.9579E-21, 8.8591E-21, 8.7731E-21, &
      8.7021E-21, 8.6407E-21, 8.5861E-21, 8.5395E-21, 8.4951E-21, 8.4556E-21, &
      8.4218E-21, 8.3865E-21, 8.3576E-21, 8.3305E-21, 8.3023E-21, 8.2760E-21, &
      8.2548E-21, 8.2330E-21, 8.2137E-21, 8.1904E-21, 8.1733E-21, 8.1558E-21, &
      8.1376E-21, 8.1190E-21, 8.1076E-21, 8.0919E-21, 8.0517E-21, 7.9957E-21, &
      7.9495E-21, 7.9130E-21, 7.8853E-21, 7.8632E-21, 7.8463E-21, 7.8328E-21, &
      7.8216E-21, 7.8147E-21, 7.8093E-21, 7.8036E-21, 7.8016E-21, 7.7974E-21, &
      7.7952E-21 /)
    REAL, PARAMETER :: a3_CH3OOH(dim55) = (/ &
      -9.7532E-24, -8.3596E-24, -6.8096E-24, -5.3880E-24, -4.2173E-24, -3.3107E-24, &
      -2.6328E-24, -2.1246E-24, -1.7532E-24, -1.4657E-24, -1.2505E-24, -1.0783E-24, &
      -9.3850E-25, -8.2668E-25, -7.3511E-25, -6.5494E-25, -5.9105E-25, -5.3515E-25, &
      -4.9142E-25, -4.4329E-25, -4.1133E-25, -3.7939E-25, -3.5158E-25, -3.2747E-25, &
      -3.0352E-25, -2.8355E-25, -2.6767E-25, -2.5160E-25, -2.3563E-25, -2.2364E-25, &
      -2.1174E-25, -1.9967E-25, -1.9169E-25, -1.7972E-25, -1.7179E-25, -1.6374E-25, &
      -1.5575E-25, -1.5175E-25, -1.3983E-25, -1.3978E-25, -1.2140E-25, -1.0064E-25, &
      -8.4665E-26, -7.2684E-26, -6.2351E-26, -5.3515E-26, -4.7124E-26, -4.1533E-26, &
      -3.5943E-26, -3.1150E-26, -2.7955E-26, -2.4761E-26, -2.1582E-26, -1.9171E-26, &
      -1.6772E-26 /)
    REAL, PARAMETER :: b3_CH3OOH(dim55) = (/ &
      4.8215E-21, 4.7859E-21, 4.7075E-21, 4.6000E-21, 4.4822E-21, 4.3682E-21, &
      4.2660E-21, 4.1767E-21, 4.1021E-21, 4.0372E-21, 3.9832E-21, 3.9357E-21, &
      3.8936E-21, 3.8572E-21, 3.8250E-21, 3.7949E-21, 3.7693E-21, 3.7454E-21, &
      3.7257E-21, 3.7028E-21, 3.6868E-21, 3.6700E-21, 3.6546E-21, 3.6407E-21, &
      3.6263E-21, 3.6138E-21, 3.6035E-21, 3.5926E-21, 3.5814E-21, 3.5727E-21, &
      3.5638E-21, 3.5544E-21, 3.5480E-21, 3.5381E-21, 3.5313E-21, 3.5243E-21, &
      3.5171E-21, 3.5134E-21, 3.5020E-21, 3.5020E-21, 3.4835E-21, 3.4601E-21, &
      3.4401E-21, 3.4236E-21, 3.4081E-21, 3.3937E-21, 3.3825E-21, 3.3720E-21, &
      3.3608E-21, 3.3506E-21, 3.3434E-21, 3.3358E-21, 3.3278E-21, 3.3215E-21, &
      3.3149E-21 /)
    REAL, PARAMETER :: a4_CH3OOH(3) = (/ 2.5000E-21, -2.3136E-25, 4.2195E-29 /)
    REAL, PARAMETER :: a5_CH3OOH(3) = (/ 1.0684E-21, -1.2783E-25, 1.7414E-29 /)
    REAL, PARAMETER :: a6_CH3OOH(2) = (/ 4.5039E-23, -5.7788E-28 /)

    jval_gp(ip_CH3OOH)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH3OOH(1) = &
          (p1(b1_1_CH3OOH(i1(j,k)),a1_1_CH3OOH(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CH3OOH(i1(j,k)),a1_2_CH3OOH(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CH3OOH(2) = &
          p1(b2_CH3OOH(i2(j,k)), a2_CH3OOH(i2(j,k)), &
          v3_du1(j,k))
        sig_CH3OOH(3) = &
          p1(b3_CH3OOH(i3(j,k)), a3_CH3OOH(i3(j,k)), &
          v3_du2(j,k))
        sig_CH3OOH(4) = &
          p2(a4_CH3OOH(1),a4_CH3OOH(2),a4_CH3OOH(3),v3_du2(j,k))
        sig_CH3OOH(5) = &
          p2(a5_CH3OOH(1),a5_CH3OOH(2),a5_CH3OOH(3),v3_du2(j,k))
        sig_CH3OOH(6) = &
          p1(a6_CH3OOH(1),a6_CH3OOH(2),v3_du2(j,k))
        dj = 0. &
          + sig_CH3OOH(1) * fint(j,k,1) &
          + sig_CH3OOH(2) * fint(j,k,2) &
          + sig_CH3OOH(3) * fint(j,k,3) &
          + sig_CH3OOH(4) * fint(j,k,4) &
          + sig_CH3OOH(5) * fint(j,k,5) &
          + sig_CH3OOH(6) * fint(j,k,6)

        jval_gp(ip_CH3OOH)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,4))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CH3OOH

  ! **************************************************************************

  SUBROUTINE jval_cal_COH2(jrow)

    ! HCHO -> CO + H2 JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_COH2

    ! T-const parameters:
    REAL, PARAMETER :: a3_COH2(dim55) = (/ &
      2.6280E-23, 2.5327E-23, 2.3301E-23, 2.0849E-23, 1.8407E-23, 1.6202E-23, &
      1.4299E-23, 1.2668E-23, 1.1286E-23, 1.0104E-23, 9.0891E-24, 8.1909E-24, &
      7.4161E-24, 6.7212E-24, 6.1167E-24, 5.5671E-24, 5.0759E-24, 4.6366E-24, &
      4.2469E-24, 3.8858E-24, 3.5623E-24, 3.2708E-24, 3.0044E-24, 2.7596E-24, &
      2.5399E-24, 2.3362E-24, 2.1494E-24, 1.9848E-24, 1.8251E-24, 1.6813E-24, &
      1.5501E-24, 1.4297E-24, 1.3179E-24, 1.2140E-24, 1.1186E-24, 1.0344E-24, &
      9.5048E-25, 8.7461E-25, 8.0702E-25, 7.4282E-25, 5.8227E-25, 3.7699E-25, &
      2.3642E-25, 1.3818E-25, 7.0345E-26, 2.2363E-26, -9.5877E-27, -3.1150E-26, &
      -4.5526E-26, -5.4313E-26, -5.9107E-26, -6.1501E-26, -6.1550E-26, -5.9901E-26, &
      -5.8307E-26 /)
    REAL, PARAMETER :: b3_COH2(dim55) = (/ &
      2.7041E-21, 2.7284E-21, 2.8309E-21, 3.0162E-21, 3.2621E-21, 3.5392E-21, &
      3.8260E-21, 4.1127E-21, 4.3902E-21, 4.6571E-21, 4.9117E-21, 5.1595E-21, &
      5.3927E-21, 5.6192E-21, 5.8315E-21, 6.0381E-21, 6.2352E-21, 6.4224E-21, &
      6.5982E-21, 6.7702E-21, 6.9323E-21, 7.0857E-21, 7.2326E-21, 7.3737E-21, &
      7.5058E-21, 7.6334E-21, 7.7551E-21, 7.8664E-21, 7.9785E-21, 8.0830E-21, &
      8.1816E-21, 8.2751E-21, 8.3647E-21, 8.4506E-21, 8.5319E-21, 8.6058E-21, &
      8.6814E-21, 8.7517E-21, 8.8161E-21, 8.8788E-21, 9.0397E-21, 9.2711E-21, &
      9.4471E-21, 9.5824E-21, 9.6844E-21, 9.7625E-21, 9.8185E-21, 9.8590E-21, &
      9.8878E-21, 9.9065E-21, 9.9173E-21, 9.9230E-21, 9.9231E-21, 9.9188E-21, &
      9.9144E-21 /)
    REAL, PARAMETER :: a4_COH2(4) = (/ 5.6603E-21, -8.8868E-25, 5.7696E-28, -8.6593E-32 /)
    REAL, PARAMETER :: a5_COH2(3) = (/ 9.4867E-21, -1.5445E-25, -2.5734E-29 /)
    REAL, PARAMETER :: a6_COH2(2) = (/ 8.4033E-22, -1.3376E-26 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c3_COH2(2) = (/ 1.00, -0.18 /)
    REAL, PARAMETER :: c5_COH2(2) = (/ 1.00, -0.33 /)
    REAL, PARAMETER :: c6_COH2(2) = (/ 1.00, -0.32 /)

    jval_gp(ip_COH2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_COH2(3) = &
          p1(c3_COH2(1),c3_COH2(2),tnorm(j,k)) * &
          p1(b3_COH2(i3(j,k)), a3_COH2(i3(j,k)), &
          v3_du2(j,k))
        sig_COH2(4) = &
          p3(a4_COH2(1),a4_COH2(2),a4_COH2(3), &
          a4_COH2(4),v3_du2(j,k))
        sig_COH2(5) = &
          p1(c5_COH2(1),c5_COH2(2),tnorm(j,k)) * &
          p2(a5_COH2(1),a5_COH2(2),a5_COH2(3),v3_du2(j,k))
        sig_COH2(6) = &
          p1(c6_COH2(1),c6_COH2(2),tnorm(j,k)) * &
          p1(a6_COH2(1),a6_COH2(2),v3_du2(j,k))
        dj = 0. &
          + sig_COH2(3) * fint(j,k,3) &
          + sig_COH2(4) * fint(j,k,4) &
          + sig_COH2(5) * fint(j,k,5) &
          + sig_COH2(6) * fint(j,k,6)

        jval_gp(ip_COH2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,4))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_COH2

  ! **************************************************************************

  SUBROUTINE jval_cal_CHOH(jrow)

    ! HCHO -> CHO + H JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CHOH

    ! T-const parameters:
    REAL, PARAMETER :: a3_CHOH(dim55) = (/ &
      7.9795E-23, 7.6966E-23, 7.0812E-23, 6.3386E-23, 5.5990E-23, 4.9321E-23, &
      4.3508E-23, 3.8618E-23, 3.4385E-23, 3.0831E-23, 2.7687E-23, 2.5040E-23, &
      2.2644E-23, 2.0527E-23, 1.8698E-23, 1.7053E-23, 1.5535E-23, 1.4177E-23, &
      1.3024E-23, 1.1901E-23, 1.0943E-23, 1.0024E-23, 9.2290E-24, 8.5063E-24, &
      7.7876E-24, 7.1885E-24, 6.6320E-24, 6.1103E-24, 5.5909E-24, 5.1917E-24, &
      4.7944E-24, 4.4329E-24, 4.0734E-24, 3.7540E-24, 3.4358E-24, 3.1949E-24, &
      2.9553E-24, 2.7157E-24, 2.5170E-24, 2.3163E-24, 1.8131E-24, 1.1821E-24, &
      7.5078E-25, 4.3931E-25, 2.3181E-25, 8.7851E-26, -1.5975E-26, -8.7851E-26, &
      -1.2780E-25, -1.5975E-25, -1.7570E-25, -1.7573E-25, -1.8385E-25, -1.8370E-25, &
      -1.7573E-25 /)
    REAL, PARAMETER :: b3_CHOH(dim55) = (/ &
      8.2042E-21, 8.2764E-21, 8.5877E-21, 9.1492E-21, 9.8936E-21, 1.0732E-20, &
      1.1608E-20, 1.2467E-20, 1.3317E-20, 1.4120E-20, 1.4909E-20, 1.5639E-20, &
      1.6360E-20, 1.7050E-20, 1.7693E-20, 1.8311E-20, 1.8920E-20, 1.9498E-20, &
      2.0019E-20, 2.0554E-20, 2.1034E-20, 2.1518E-20, 2.1956E-20, 2.2372E-20, &
      2.2805E-20, 2.3180E-20, 2.3542E-20, 2.3895E-20, 2.4260E-20, 2.4550E-20, &
      2.4848E-20, 2.5129E-20, 2.5417E-20, 2.5681E-20, 2.5952E-20, 2.6164E-20, &
      2.6380E-20, 2.6602E-20, 2.6791E-20, 2.6987E-20, 2.7491E-20, 2.8203E-20, &
      2.8743E-20, 2.9172E-20, 2.9484E-20, 2.9718E-20, 2.9900E-20, 3.0035E-20, &
      3.0115E-20, 3.0183E-20, 3.0219E-20, 3.0219E-20, 3.0239E-20, 3.0239E-20, &
      3.0217E-20 /)
    REAL, PARAMETER :: a4_CHOH(4) = (/ 1.6451E-20, -3.2895E-24, 1.8503E-27, -2.7031E-31 /)
    REAL, PARAMETER :: a5_CHOH(3) = (/ 9.3405E-21, -1.9800E-24, 2.7963E-28 /)
    REAL, PARAMETER :: a6_CHOH(2) = (/ 1.6924E-23, -3.3867E-28 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c3_CHOH(2) = (/ 1.00, -0.18 /)
    REAL, PARAMETER :: c5_CHOH(2) = (/ 1.00, -0.27 /)
    REAL, PARAMETER :: c6_CHOH(2) = (/ 1.00, -0.37 /)

    jval_gp(ip_CHOH)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CHOH(3) = &
          p1(c3_CHOH(1),c3_CHOH(2),tnorm(j,k)) * &
          p1(b3_CHOH(i3(j,k)), a3_CHOH(i3(j,k)), &
          v3_du2(j,k))
        sig_CHOH(4) = &
          p3(a4_CHOH(1),a4_CHOH(2),a4_CHOH(3), &
          a4_CHOH(4),v3_du2(j,k))
        sig_CHOH(5) = &
          p1(c5_CHOH(1),c5_CHOH(2),tnorm(j,k)) * &
          p2(a5_CHOH(1),a5_CHOH(2),a5_CHOH(3),v3_du2(j,k))
        sig_CHOH(6) = &
          p1(c6_CHOH(1),c6_CHOH(2),tnorm(j,k)) * &
          p1(a6_CHOH(1),a6_CHOH(2),v3_du2(j,k))
        dj = 0. &
          + sig_CHOH(3) * fint(j,k,3) &
          + sig_CHOH(4) * fint(j,k,4) &
          + sig_CHOH(5) * fint(j,k,5) &
          + sig_CHOH(6) * fint(j,k,6)

        jval_gp(ip_CHOH)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,5))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CHOH

  ! **************************************************************************

  SUBROUTINE jval_cal_CH3CO3H(jrow)

    ! CH3CO3H -> products Giguere + Olmos, Can. J. Chem. 34, 689 (1956), extrapolated

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH3CO3H

    ! T-const parameters:
    REAL, PARAMETER :: a1_1_CH3CO3H(dim55) = (/ &
      6.7385E-22, 5.5762E-22, 4.3644E-22, 3.3950E-22, 2.4109E-22, 1.8373E-22, &
      1.2092E-22, 9.0240E-23, 5.5028E-23, 4.3892E-23, 2.2877E-23, 1.8694E-23, &
      9.6935E-24, 8.6854E-24, 2.1713E-24, 4.1721E-24, 9.4609E-25, 4.8080E-25, &
      6.9276E-25, -5.2216E-25, -6.2039E-26, 1.1219E-24, 7.9099E-25, -1.7061E-25, &
      -3.6189E-26, -8.2718E-26, -7.3412E-25, -6.4106E-25, -0.0000E+00, -5.1699E-27, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -1.0340E-26, -0.0000E+00, 5.1699E-27, &
      -0.0000E+00, 1.0340E-26, -0.0000E+00, -0.0000E+00, -1.0340E-27, 1.0340E-27, &
      -1.0340E-27, -1.0340E-27, 4.1359E-27, -2.0680E-27, -1.0340E-27, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b1_1_CH3CO3H(dim55) = (/ &
       1.0964E-19,  1.0999E-19,  1.1065E-19,  1.1143E-19,  1.1246E-19,  1.1321E-19, &
       1.1418E-19,  1.1473E-19,  1.1545E-19,  1.1571E-19,  1.1625E-19,  1.1636E-19, &
       1.1664E-19,  1.1667E-19,  1.1690E-19,  1.1683E-19,  1.1696E-19,  1.1698E-19, &
       1.1697E-19,  1.1703E-19,  1.1700E-19,  1.1694E-19,  1.1696E-19,  1.1701E-19, &
       1.1701E-19,  1.1701E-19,  1.1705E-19,  1.1705E-19,  1.1700E-19,  1.1700E-19, &
       1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19, &
       1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19, &
       1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19, &
       1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19,  1.1700E-19, &
       1.1700E-19 /)
    REAL, PARAMETER :: a1_2_CH3CO3H(dim55) = (/ &
      1.7845E-24, 1.9757E-24, 2.2473E-24, 2.0325E-24, 2.1218E-24, 1.6201E-24, &
      1.5692E-24, 1.1341E-24, 1.0225E-24, 6.7143E-25, 6.1732E-25, 4.0374E-25, &
      3.3889E-25, 2.1310E-25, 1.9805E-25, 1.1380E-25, 9.5281E-26, 7.5907E-26, &
      4.9910E-26, 4.0049E-26, 2.9180E-26, 7.5055E-27, 8.4115E-27, 1.2615E-26, &
      6.6604E-27, 5.1365E-27, 1.1934E-26, 8.2646E-27, -0.0000E+00, 2.7492E-29, &
      -0.0000E+00, -3.1987E-29, -0.0000E+00, 7.8315E-29, -0.0000E+00, -3.4281E-29, &
      -0.0000E+00, -6.5000E-29, -0.0000E+00, 1.2952E-29, 8.6536E-30, -9.0667E-30, &
      6.0715E-30, 1.7933E-30, -1.2811E-29, 7.8565E-30, 3.0238E-30, 2.4877E-30, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b1_2_CH3CO3H(dim55) = (/ &
      -4.6929E-23, -4.7503E-23, -4.8997E-23, -4.7278E-23, -4.8215E-23, -4.1694E-23, &
      -4.0906E-23, -3.3072E-23, -3.0785E-23, -2.2711E-23, -2.1331E-23, -1.5351E-23, &
      -1.3373E-23, -9.2220E-24, -8.6874E-24, -5.4863E-24, -4.7361E-24, -3.9030E-24, &
      -2.7201E-24, -2.2468E-24, -1.6979E-24, -5.4915E-25, -5.9943E-25, -8.4321E-25, &
      -4.8299E-25, -3.8698E-25, -8.3219E-25, -5.8270E-25, -4.0828E-29, -2.0478E-27, &
      2.7902E-29, 2.5229E-27, -5.2064E-29, -6.5522E-27, 1.4372E-28, 3.1605E-27, &
      5.8019E-29, 6.1030E-27, -1.0448E-28, -1.3737E-27, -9.4179E-28, 1.0606E-27, &
      -8.3924E-28, -2.4885E-28, 1.9491E-27, -1.4197E-27, -5.7156E-28, -4.7078E-28, &
      2.8007E-29, 2.8007E-29, 2.8007E-29, 2.8007E-29, 2.8007E-29, 2.8007E-29, &
      2.8007E-29 /)
    REAL, PARAMETER :: a2_CH3CO3H(dim55) = (/ &
      -7.0648E-22, -6.0620E-22, -4.8636E-22, -3.6980E-22, -2.7044E-22, -1.9304E-22, &
      -1.3624E-22, -9.6160E-23, -6.8400E-23, -4.9440E-23, -3.6480E-23, -2.7520E-23, &
      -2.1320E-23, -1.6920E-23, -1.3760E-23, -1.1440E-23, -9.6400E-24, -8.2800E-24, &
      -7.2400E-24, -6.4000E-24, -5.6800E-24, -5.0800E-24, -4.6001E-24, -4.2000E-24, &
      -3.8000E-24, -3.4800E-24, -3.2400E-24, -2.9600E-24, -2.7200E-24, -2.5601E-24, &
      -2.3600E-24, -2.1600E-24, -2.0400E-24, -1.8801E-24, -1.7599E-24, -1.6401E-24, &
      -1.5600E-24, -1.4000E-24, -1.3600E-24, -1.2400E-24, -1.0240E-24, -7.3600E-25, &
      -5.3600E-25, -3.7600E-25, -2.8000E-25, -2.0001E-25, -1.4400E-25, -1.0400E-25, &
      -7.2007E-26, -5.5996E-26, -4.0002E-26, -2.3991E-26, -2.4008E-26, -7.9972E-27, &
      -1.5994E-26 /)
    REAL, PARAMETER :: b2_CH3CO3H(dim55) = (/ &
       1.1022E-20,  1.0721E-20,  1.0062E-20,  9.1298E-21,  8.0865E-21,  7.0803E-21, &
       6.1999E-21,  5.4785E-21,  4.9094E-21,  4.4733E-21,  4.1428E-21,  3.8920E-21, &
       3.7029E-21,  3.5577E-21,  3.4455E-21,  3.3573E-21,  3.2844E-21,  3.2259E-21, &
       3.1786E-21,  3.1383E-21,  3.1019E-21,  3.0701E-21,  3.0435E-21,  3.0203E-21, &
       2.9961E-21,  2.9759E-21,  2.9602E-21,  2.9412E-21,  2.9243E-21,  2.9126E-21, &
       2.8975E-21,  2.8819E-21,  2.8722E-21,  2.8589E-21,  2.8487E-21,  2.8381E-21, &
       2.8309E-21,  2.8160E-21,  2.8122E-21,  2.8004E-21,  2.7787E-21,  2.7462E-21, &
       2.7211E-21,  2.6990E-21,  2.6845E-21,  2.6715E-21,  2.6617E-21,  2.6542E-21, &
       2.6477E-21,  2.6443E-21,  2.6407E-21,  2.6369E-21,  2.6369E-21,  2.6327E-21, &
       2.6349E-21 /)
    REAL, PARAMETER :: a3_CH3CO3H(dim55) = (/ &
      -3.0876E-24, -1.8195E-24, -9.8836E-25, -5.8737E-25, -3.9421E-25, -2.9009E-25, &
      -2.2694E-25, -1.8504E-25, -1.5472E-25, -1.3195E-25, -1.1434E-25, -9.9777E-26, &
      -8.7798E-26, -7.8227E-26, -6.9655E-26, -6.2821E-26, -5.6650E-26, -5.1497E-26, &
      -4.7089E-26, -4.3151E-26, -3.9487E-26, -3.6644E-26, -3.3904E-26, -3.1336E-26, &
      -2.9231E-26, -2.7226E-26, -2.5343E-26, -2.3801E-26, -2.2052E-26, -2.0890E-26, &
      -1.9521E-26, -1.8322E-26, -1.7094E-26, -1.6095E-26, -1.5240E-26, -1.4358E-26, &
      -1.3357E-26, -1.2671E-26, -1.1986E-26, -1.1282E-26, -9.4487E-27, -7.0525E-27, &
      -5.3046E-27, -3.9712E-27, -3.0126E-27, -2.2588E-27, -1.7117E-27, -1.3010E-27, &
      -9.9246E-28, -7.5307E-28, -5.8213E-28, -4.4492E-28, -3.4223E-28, -2.7395E-28, &
      -1.7105E-28 /)
    REAL, PARAMETER :: b3_CH3CO3H(dim55) = (/ &
      1.3135E-21, 1.2388E-21, 1.1413E-21, 1.0708E-21, 1.0256E-21, 9.9509E-22, &
      9.7292E-22, 9.5576E-22, 9.4157E-22, 9.2959E-22, 9.1930E-22, 9.0993E-22, &
      9.0152E-22, 8.9425E-22, 8.8723E-22, 8.8124E-22, 8.7547E-22, 8.7034E-22, &
      8.6571E-22, 8.6133E-22, 8.5705E-22, 8.5356E-22, 8.5004E-22, 8.4658E-22, &
      8.4363E-22, 8.4070E-22, 8.3784E-22, 8.3541E-22, 8.3255E-22, 8.3058E-22, &
      8.2818E-22, 8.2600E-22, 8.2371E-22, 8.2178E-22, 8.2008E-22, 8.1828E-22, &
      8.1617E-22, 8.1469E-22, 8.1317E-22, 8.1156E-22, 8.0728E-22, 8.0098E-22, &
      7.9587E-22, 7.9158E-22, 7.8822E-22, 7.8536E-22, 7.8312E-22, 7.8132E-22, &
      7.7988E-22, 7.7869E-22, 7.7779E-22, 7.7703E-22, 7.7643E-22, 7.7601E-22, &
      7.7535E-22 /)
    REAL, PARAMETER :: a4_CH3CO3H(3) = (/ 5.4265E-22, -3.7091E-26, 3.5279E-30 /)
    REAL, PARAMETER :: a5_CH3CO3H(3) = (/ 1.7817E-22, -2.0151E-26, 1.6302E-30 /)

    jval_gp(ip_CH3CO3H)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH3CO3H(0) = 1.17E-19
        sig_CH3CO3H(1) = &
          (p1(b1_1_CH3CO3H(i1(j,k)),a1_1_CH3CO3H(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CH3CO3H(i1(j,k)),a1_2_CH3CO3H(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CH3CO3H(2) = &
          p1(b2_CH3CO3H(i2(j,k)), a2_CH3CO3H(i2(j,k)), &
          v3_du1(j,k))
        sig_CH3CO3H(3) = &
          p1(b3_CH3CO3H(i3(j,k)), a3_CH3CO3H(i3(j,k)), &
          v3_du2(j,k))
        sig_CH3CO3H(4) = &
          p2(a4_CH3CO3H(1),a4_CH3CO3H(2),a4_CH3CO3H(3),v3_du2(j,k))
        sig_CH3CO3H(5) = &
          p2(a5_CH3CO3H(1),a5_CH3CO3H(2),a5_CH3CO3H(3),v3_du2(j,k))
        dj = 0. &
          + sig_CH3CO3H(0) * fint(j,k,0) &
          + sig_CH3CO3H(1) * fint(j,k,1) &
          + sig_CH3CO3H(2) * fint(j,k,2) &
          + sig_CH3CO3H(3) * fint(j,k,3) &
          + sig_CH3CO3H(4) * fint(j,k,4) &
          + sig_CH3CO3H(5) * fint(j,k,5)

        jval_gp(ip_CH3CO3H)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CH3CO3H

  ! **************************************************************************

  SUBROUTINE jval_cal_CH3CHO(jrow)

    ! CH3CHO -> CH3 + CHO cross section: Calvert + Pitts Photochemistry (1966); quantum yield: Atkinson + Lloyd, JPCRD 13, 315-444 (1984)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH3CHO

    ! T-const parameters:
    REAL, PARAMETER :: a2_CH3CHO(dim55) = (/ &
      7.0640E-22, 6.1720E-22, 5.0200E-22, 3.8600E-22, 2.8400E-22, 2.0240E-22, &
      1.4120E-22, 9.7200E-23, 6.6400E-23, 4.5200E-23, 3.0400E-23, 2.0000E-23, &
      1.3200E-23, 8.3998E-24, 5.2003E-24, 2.8001E-24, 1.1994E-24, -0.0000E+00, &
      -8.0004E-25, -1.1994E-24, -1.6001E-24, -2.0001E-24, -1.6001E-24, -2.4001E-24, &
      -2.0001E-24, -2.0001E-24, -1.9995E-24, -2.0001E-24, -2.0001E-24, -2.0001E-24, &
      -1.6001E-24, -1.6001E-24, -1.6001E-24, -1.5994E-24, -1.6001E-24, -1.2001E-24, &
      -1.6001E-24, -1.2001E-24, -1.2001E-24, -1.2001E-24, -8.8004E-25, -7.1991E-25, &
      -5.6003E-25, -3.2002E-25, -3.2002E-25, -1.6001E-25, -1.6001E-25, -8.0004E-26, &
      -8.0004E-26, -8.0004E-26, -0.0000E+00, -0.0000E+00, -8.0004E-26, -0.0000E+00, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b2_CH3CHO(dim55) = (/ &
       1.7693E-20,  1.7960E-20,  1.8594E-20,  1.9522E-20,  2.0593E-20,  2.1654E-20, &
       2.2602E-20,  2.3394E-20,  2.4026E-20,  2.4513E-20,  2.4891E-20,  2.5182E-20, &
       2.5389E-20,  2.5548E-20,  2.5661E-20,  2.5753E-20,  2.5817E-20,  2.5869E-20, &
       2.5905E-20,  2.5925E-20,  2.5945E-20,  2.5966E-20,  2.5944E-20,  2.5990E-20, &
       2.5966E-20,  2.5966E-20,  2.5966E-20,  2.5966E-20,  2.5966E-20,  2.5966E-20, &
       2.5936E-20,  2.5936E-20,  2.5936E-20,  2.5936E-20,  2.5936E-20,  2.5901E-20, &
       2.5937E-20,  2.5900E-20,  2.5900E-20,  2.5900E-20,  2.5867E-20,  2.5849E-20, &
       2.5829E-20,  2.5796E-20,  2.5796E-20,  2.5770E-20,  2.5770E-20,  2.5755E-20, &
       2.5755E-20,  2.5755E-20,  2.5737E-20,  2.5737E-20,  2.5757E-20,  2.5736E-20, &
       2.5736E-20 /)
    REAL, PARAMETER :: a3_CH3CHO(dim55) = (/ &
      -3.7343E-23, -3.2592E-23, -2.7159E-23, -2.2047E-23, -1.7732E-23, -1.4337E-23, &
      -1.1746E-23, -9.7444E-24, -8.2668E-24, -7.0687E-24, -6.1526E-24, -5.3914E-24, &
      -4.7524E-24, -4.2732E-24, -3.8354E-24, -3.4345E-24, -3.1549E-24, -2.8355E-24, &
      -2.5969E-24, -2.3962E-24, -2.1965E-24, -2.0367E-24, -1.8777E-24, -1.7572E-24, &
      -1.6374E-24, -1.5176E-24, -1.3983E-24, -1.3179E-24, -1.2380E-24, -1.1581E-24, &
      -1.1186E-24, -1.0384E-24, -9.5845E-25, -9.1854E-25, -8.7896E-25, -7.9870E-25, &
      -7.9873E-25, -7.1885E-25, -7.1914E-25, -6.3898E-25, -5.8307E-25, -4.5527E-25, &
      -3.7540E-25, -3.0352E-25, -2.5579E-25, -2.1566E-25, -1.7571E-25, -1.5975E-25, &
      -1.2780E-25, -1.1182E-25, -9.5851E-26, -8.7857E-26, -7.1940E-26, -6.3901E-26, &
      -5.5907E-26 /)
    REAL, PARAMETER :: b3_CH3CHO(dim55) = (/ &
      1.7392E-20, 1.7270E-20, 1.6996E-20, 1.6609E-20, 1.6175E-20, 1.5748E-20, &
      1.5357E-20, 1.5006E-20, 1.4709E-20, 1.4438E-20, 1.4209E-20, 1.3999E-20, &
      1.3806E-20, 1.3650E-20, 1.3496E-20, 1.3346E-20, 1.3233E-20, 1.3097E-20, &
      1.2990E-20, 1.2894E-20, 1.2794E-20, 1.2710E-20, 1.2622E-20, 1.2553E-20, &
      1.2481E-20, 1.2406E-20, 1.2328E-20, 1.2274E-20, 1.2218E-20, 1.2159E-20, &
      1.2130E-20, 1.2067E-20, 1.2003E-20, 1.1970E-20, 1.1937E-20, 1.1866E-20, &
      1.1866E-20, 1.1792E-20, 1.1793E-20, 1.1714E-20, 1.1658E-20, 1.1514E-20, &
      1.1414E-20, 1.1315E-20, 1.1243E-20, 1.1178E-20, 1.1108E-20, 1.1078E-20, &
      1.1014E-20, 1.0980E-20, 1.0944E-20, 1.0925E-20, 1.0885E-20, 1.0864E-20, &
      1.0842E-20 /)
    REAL, PARAMETER :: a4_CH3CHO(3) = (/ 7.1505E-21, -1.3438E-24, 2.3819E-28 /)
    REAL, PARAMETER :: a5_CH3CHO(3) = (/ 1.1867E-21, -3.8231E-25, 5.4683E-29 /)

    jval_gp(ip_CH3CHO)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH3CHO(2) = &
          p1(b2_CH3CHO(i2(j,k)), a2_CH3CHO(i2(j,k)), &
          v3_du1(j,k))
        sig_CH3CHO(3) = &
          p1(b3_CH3CHO(i3(j,k)), a3_CH3CHO(i3(j,k)), &
          v3_du2(j,k))
        sig_CH3CHO(4) = &
          p2(a4_CH3CHO(1),a4_CH3CHO(2),a4_CH3CHO(3),v3_du2(j,k))
        sig_CH3CHO(5) = &
          p2(a5_CH3CHO(1),a5_CH3CHO(2),a5_CH3CHO(3),v3_du2(j,k))
        dj = 0. &
          + sig_CH3CHO(2) * fint(j,k,2) &
          + sig_CH3CHO(3) * fint(j,k,3) &
          + sig_CH3CHO(4) * fint(j,k,4) &
          + sig_CH3CHO(5) * fint(j,k,5)

        jval_gp(ip_CH3CHO)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CH3CHO

  ! **************************************************************************

  SUBROUTINE jval_cal_CH3COCH3(jrow)

    ! CH3COCH3 -> products Gierzcak et al., CP, (1998)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH3COCH3

    REAL :: c1, c2, f2, f3, f4, f5
    REAL :: drel
    ! factors that correct the Jval depending on  the "new" quantum yield
    REAL :: nqyf(MAXWAV)
    REAL :: bqyf(MAXWAV)
    REAL :: wqyf(MAXWAV)
    REAL :: gqyf(MAXWAV)
    REAL :: A,B,a0,b0,D0,a1,b1,D1,a2,b2,D2,a3,b3,D3,E3,A4,B4,D4
    REAL :: PHI_ch3co, PHI_co, PhiS
    REAL, PARAMETER :: wave(7) = (/ &
      2.0513E-05, 2.8777E-05, 3.0200E-05, 3.0900E-05, &
      3.2000E-05, 3.7000E-05, 5.8000E-05 /)

    ! T-const parameters:
    REAL, PARAMETER :: a2_CH3COCH3(dim55) = (/ &
      1.0640E-22, 7.0800E-23, 3.8400E-23, 1.2800E-23, -4.3996E-24, -1.4800E-23, &
      -2.0400E-23, -2.2000E-23, -2.2400E-23, -2.1600E-23, -2.0000E-23, -1.8400E-23, &
      -1.6800E-23, -1.5199E-23, -1.4000E-23, -1.2400E-23, -1.1601E-23, -1.0400E-23, &
      -9.5998E-24, -8.7998E-24, -8.4004E-24, -7.1997E-24, -7.2003E-24, -6.3997E-24, &
      -6.0003E-24, -5.5996E-24, -5.2003E-24, -4.8002E-24, -4.3996E-24, -4.4002E-24, &
      -4.0002E-24, -3.5995E-24, -3.2002E-24, -3.2002E-24, -3.2002E-24, -2.7995E-24, &
      -2.4001E-24, -2.8001E-24, -2.0001E-24, -2.4001E-24, -1.7600E-24, -1.2801E-24, &
      -9.5992E-25, -6.4003E-25, -4.8002E-25, -4.0002E-25, -2.4001E-25, -1.6001E-25, &
      -1.5988E-25, -8.0004E-26, -8.0004E-26, -0.0000E+00, -8.0004E-26, -0.0000E+00, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b2_CH3COCH3(dim55) = (/ &
      1.9411E-20, 1.9518E-20, 1.9696E-20, 1.9901E-20, 2.0081E-20, 2.0216E-20, &
      2.0303E-20, 2.0332E-20, 2.0340E-20, 2.0322E-20, 2.0281E-20, 2.0236E-20, &
      2.0187E-20, 2.0135E-20, 2.0092E-20, 2.0031E-20, 1.9999E-20, 1.9947E-20, &
      1.9911E-20, 1.9872E-20, 1.9852E-20, 1.9789E-20, 1.9789E-20, 1.9742E-20, &
      1.9718E-20, 1.9693E-20, 1.9667E-20, 1.9639E-20, 1.9611E-20, 1.9611E-20, &
      1.9581E-20, 1.9550E-20, 1.9518E-20, 1.9518E-20, 1.9518E-20, 1.9482E-20, &
      1.9446E-20, 1.9483E-20, 1.9407E-20, 1.9446E-20, 1.9382E-20, 1.9328E-20, &
      1.9287E-20, 1.9243E-20, 1.9219E-20, 1.9206E-20, 1.9178E-20, 1.9163E-20, &
      1.9163E-20, 1.9146E-20, 1.9146E-20, 1.9127E-20, 1.9147E-20, 1.9126E-20, &
      1.9126E-20 /)
    REAL, PARAMETER :: a3_CH3COCH3(dim55) = (/ &
      -4.9569E-23, -4.1283E-23, -3.2563E-23, -2.4847E-23, -1.8694E-23, -1.4097E-23, &
      -1.0771E-23, -8.3866E-24, -6.6773E-24, -5.4393E-24, -4.5146E-24, -3.8179E-24, &
      -3.2668E-24, -2.8355E-24, -2.4890E-24, -2.1965E-24, -1.9569E-24, -1.7572E-24, &
      -1.5861E-24, -1.4337E-24, -1.3099E-24, -1.1981E-24, -1.1027E-24, -1.0144E-24, &
      -9.4249E-25, -8.7061E-25, -8.1501E-25, -7.5879E-25, -7.1086E-25, -6.6694E-25, &
      -6.2724E-25, -5.9105E-25, -5.5512E-25, -5.2715E-25, -4.9940E-25, -4.7125E-25, &
      -4.4728E-25, -4.2732E-25, -4.0751E-25, -3.8738E-25, -3.3786E-25, -2.7476E-25, &
      -2.2764E-25, -1.9089E-25, -1.6307E-25, -1.3978E-25, -1.2061E-25, -1.0463E-25, &
      -9.1054E-26, -7.9873E-26, -7.0287E-26, -6.0702E-26, -5.4357E-26, -4.7924E-26, &
      -4.1533E-26 /)
    REAL, PARAMETER :: b3_CH3COCH3(dim55) = (/ &
      8.4433E-21, 8.2317E-21, 7.7906E-21, 7.2073E-21, 6.5880E-21, 6.0102E-21, &
      5.5088E-21, 5.0897E-21, 4.7465E-21, 4.4669E-21, 4.2349E-21, 4.0427E-21, &
      3.8768E-21, 3.7362E-21, 3.6146E-21, 3.5046E-21, 3.4085E-21, 3.3234E-21, &
      3.2462E-21, 3.1736E-21, 3.1116E-21, 3.0527E-21, 3.0001E-21, 2.9492E-21, &
      2.9060E-21, 2.8610E-21, 2.8248E-21, 2.7867E-21, 2.7531E-21, 2.7212E-21, &
      2.6914E-21, 2.6632E-21, 2.6344E-21, 2.6113E-21, 2.5877E-21, 2.5630E-21, &
      2.5414E-21, 2.5229E-21, 2.5040E-21, 2.4844E-21, 2.4347E-21, 2.3636E-21, &
      2.3046E-21, 2.2540E-21, 2.2122E-21, 2.1742E-21, 2.1406E-21, 2.1106E-21, &
      2.0834E-21, 2.0596E-21, 2.0380E-21, 2.0152E-21, 1.9993E-21, 1.9824E-21, &
      1.9648E-21 /)
    REAL, PARAMETER :: dsa3_1_CH3COCH3(dim55) = (/ &
      -8.7405E-04, -8.6062E-04, -7.8720E-04, -6.7922E-04, -5.6261E-04, -4.5646E-04, &
      -3.6784E-04, -2.9810E-04, -2.4464E-04, -2.0400E-04, -1.7227E-04, -1.4859E-04, &
      -1.2845E-04, -1.1290E-04, -1.0034E-04, -8.9182E-05, -8.0034E-05, -7.2459E-05, &
      -6.5823E-05, -5.9828E-05, -5.4890E-05, -5.0366E-05, -4.6642E-05, -4.2921E-05, &
      -4.0045E-05, -3.6948E-05, -3.4929E-05, -3.2514E-05, -3.0457E-05, -2.8703E-05, &
      -2.6914E-05, -2.5648E-05, -2.3776E-05, -2.2798E-05, -2.1749E-05, -2.0374E-05, &
      -1.9275E-05, -1.8577E-05, -1.7802E-05, -1.6807E-05, -1.4674E-05, -1.1985E-05, &
      -9.9764E-06, -8.3432E-06, -7.1492E-06, -6.1589E-06, -5.3040E-06, -4.5950E-06, &
      -3.9953E-06, -3.5412E-06, -3.1346E-06, -2.6308E-06, -2.4255E-06, -2.1664E-06, &
      -1.8061E-06 /)
    REAL, PARAMETER :: dsa3_2_CH3COCH3(dim55) = (/ &
      9.1117E-05, 8.7876E-05, 7.8667E-05, 6.6481E-05, 5.4159E-05, 4.3326E-05, &
      3.4607E-05, 2.7929E-05, 2.2909E-05, 1.9017E-05, 1.6106E-05, 1.3845E-05, &
      1.2039E-05, 1.0606E-05, 9.3262E-06, 8.4146E-06, 7.5131E-06, 6.7728E-06, &
      6.1316E-06, 5.6864E-06, 5.1595E-06, 4.7200E-06, 4.4147E-06, 4.0797E-06, &
      3.7396E-06, 3.5361E-06, 3.2833E-06, 3.0966E-06, 2.8868E-06, 2.7184E-06, &
      2.5599E-06, 2.4247E-06, 2.2602E-06, 2.1846E-06, 2.0593E-06, 1.9635E-06, &
      1.8519E-06, 1.7552E-06, 1.6601E-06, 1.5794E-06, 1.4238E-06, 1.1506E-06, &
      9.4632E-07, 8.1659E-07, 6.8318E-07, 5.8587E-07, 5.1928E-07, 4.4674E-07, &
      3.9776E-07, 3.3260E-07, 2.9642E-07, 2.7725E-07, 2.2566E-07, 1.9834E-07, &
      1.8531E-07 /)
    REAL, PARAMETER :: dsb3_1_CH3COCH3(dim55) = (/ &
      3.4148E-01, 3.4114E-01, 3.3742E-01, 3.2926E-01, 3.1752E-01, 3.0418E-01, &
      2.9082E-01, 2.7856E-01, 2.6783E-01, 2.5865E-01, 2.5069E-01, 2.4416E-01, &
      2.3810E-01, 2.3303E-01, 2.2862E-01, 2.2442E-01, 2.2075E-01, 2.1752E-01, &
      2.1453E-01, 2.1168E-01, 2.0920E-01, 2.0682E-01, 2.0477E-01, 2.0262E-01, &
      2.0089E-01, 1.9895E-01, 1.9764E-01, 1.9600E-01, 1.9456E-01, 1.9329E-01, &
      1.9194E-01, 1.9096E-01, 1.8946E-01, 1.8865E-01, 1.8776E-01, 1.8655E-01, &
      1.8556E-01, 1.8491E-01, 1.8417E-01, 1.8320E-01, 1.8106E-01, 1.7803E-01, &
      1.7552E-01, 1.7327E-01, 1.7147E-01, 1.6986E-01, 1.6836E-01, 1.6703E-01, &
      1.6583E-01, 1.6486E-01, 1.6395E-01, 1.6275E-01, 1.6223E-01, 1.6155E-01, &
      1.6056E-01 /)
    REAL, PARAMETER :: dsb3_2_CH3COCH3(dim55) = (/ &
      6.6324E-02, 6.6407E-02, 6.6873E-02, 6.7794E-02, 6.9034E-02, 7.0396E-02, &
      7.1710E-02, 7.2884E-02, 7.3892E-02, 7.4771E-02, 7.5501E-02, 7.6125E-02, &
      7.6668E-02, 7.7136E-02, 7.7585E-02, 7.7928E-02, 7.8289E-02, 7.8605E-02, &
      7.8894E-02, 7.9106E-02, 7.9370E-02, 7.9601E-02, 7.9770E-02, 7.9963E-02, &
      8.0167E-02, 8.0295E-02, 8.0459E-02, 8.0586E-02, 8.0733E-02, 8.0855E-02, &
      8.0974E-02, 8.1079E-02, 8.1211E-02, 8.1274E-02, 8.1381E-02, 8.1465E-02, &
      8.1565E-02, 8.1655E-02, 8.1745E-02, 8.1824E-02, 8.1980E-02, 8.2288E-02, &
      8.2544E-02, 8.2723E-02, 8.2923E-02, 8.3081E-02, 8.3198E-02, 8.3334E-02, &
      8.3433E-02, 8.3571E-02, 8.3653E-02, 8.3698E-02, 8.3828E-02, 8.3899E-02, &
      8.3935E-02 /)
    REAL, PARAMETER :: a4_CH3COCH3(3) = (/ 7.9742E-22, -2.1322E-25, 4.0290E-29 /)
    REAL, PARAMETER :: a5_CH3COCH3(4) = (/ 7.7582E-23, -3.6187E-26, 9.1185E-30, -9.5885E-34 /)

    jval_gp(ip_CH3COCH3)%ptr(:,:,jrow) = vinit

    SELECT CASE(qy_CH3COCH3)
    CASE(1)
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH3COCH3(2) = &
          p1(b2_CH3COCH3(i2(j,k)), a2_CH3COCH3(i2(j,k)), &
          v3_du1(j,k))
        sig_CH3COCH3(3) = &
          p1(b3_CH3COCH3(i3(j,k)), a3_CH3COCH3(i3(j,k)),v3_du2(j,k))
        sig_CH3COCH3(4) = &
          p2(a4_CH3COCH3(1),a4_CH3COCH3(2),a4_CH3COCH3(3), v3_du2(j,k))
        sig_CH3COCH3(5) = &
          p3(a5_CH3COCH3(1),a5_CH3COCH3(2),a5_CH3COCH3(3), &
          a5_CH3COCH3(4),v3_du2(j,k))
        ! correction for density dependence
        drel = dens(j,k)/dens_ref
        C1 = p1(DSb3_1_CH3COCH3(i3(j,k)), DSa3_1_CH3COCH3(i3(j,k)), &
          v3_du2(j,k))
        C2 = p1(DSb3_2_CH3COCH3(i3(j,k)), DSa3_2_CH3COCH3(i3(j,k)), &
          v3_du2(j,k))
        F2 = 1./p1(4.3154E-01, 5.6559E-02, DREL)
        F3 = 1./p1(C1,C2,DREL)
        F4 = 1./p1(1.4094E-01, 8.5977E-02, DREL)
        F5 = 1./p1(2.0675E-01, 7.9342E-02, DREL)

        dj=&
          sig_CH3COCH3(2) * F2 * fint(j,k,2)  + &
          sig_CH3COCH3(3) * F3 * fint(j,k,3)  + &
          sig_CH3COCH3(4) * F4 * fint(j,k,4)  + &
          sig_CH3COCH3(5) * F5 * fint(j,k,5)
        jval_gp(ip_CH3COCH3)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

    CASE(2)
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH3COCH3(2) = &
          p1(b2_CH3COCH3(i2(j,k)), a2_CH3COCH3(i2(j,k)),v3_du1(j,k))
        sig_CH3COCH3(3) = &
          p1(b3_CH3COCH3(i3(j,k)), a3_CH3COCH3(i3(j,k)),v3_du2(j,k))
        sig_CH3COCH3(4) = &
          p2(a4_CH3COCH3(1),a4_CH3COCH3(2),a4_CH3COCH3(3),v3_du2(j,k))
        sig_CH3COCH3(5) = &
          p3(a5_CH3COCH3(1),a5_CH3COCH3(2),a5_CH3COCH3(3), &
          a5_CH3COCH3(4),v3_du2(j,k))
        ! correction for density dependence
        drel = dens(j,k)/dens_ref
        C1 = p1(DSb3_1_CH3COCH3(i3(j,k)), DSa3_1_CH3COCH3(i3(j,k)), &
          v3_du2(j,k))
        C2 = p1(DSb3_2_CH3COCH3(i3(j,k)), DSa3_2_CH3COCH3(i3(j,k)), &
          v3_du2(j,k))
        F2 = 1./p1(4.3154E-01, 5.6559E-02, DREL)
        F3 = 1./p1(C1,C2,DREL)
        F4 = 1./p1(1.4094E-01, 8.5977E-02, DREL)
        F5 = 1./p1(2.0675E-01, 7.9342E-02, DREL)

        ! calculate some correction factors for acetone photolysis,
        ! due to new measurements of the quantum yield
        ! we can skip calculation of 1 & 6 & 7 wavelenght
        !  wavelength(7)
        ! 1 : 2.0513E-05, --> 205
        ! 2 : 2.8777E-05, --> 287 ! used
        ! 3 : 3.0200E-05, --> 302 ! used
        ! 4 : 3.0900E-05, --> 309 ! used
        ! 5 : 3.2000E-05, --> 320 ! used
        ! 6 : 3.7000E-05, --> 370
        ! 7:  5.8000E-05, --> 580
        ! the following lines have been made to increase calculation speed.
        ! If new wavelenght used, check the comments down (real calculation on
        ! all the wavelnght range!)
        ! Quantum Yield of Acetone based on the paper of Gierzack-1998
            A = -15.696 + 0.05707 *WAVE(2) *1.e7
            B = EXP(-88.81 + 0.15161 * WAVE(2)*1.e7 )
            GQYF(2) =  MIN(1.,1./(A + B * DENS(J,K)))

            A = -15.696 + 0.05707 *WAVE(3) *1.e7
            B = EXP(-88.81 + 0.15161 * WAVE(3)*1.e7 )
            GQYF(3) = MIN(1.,1./(A + B * DENS(J,K)))

            A = -130.2 + 0.42884 * WAVE(4)*1.e7
            B = EXP(-55.947 + .044913 * WAVE(4)*1.e7 )
            GQYF(4) =  MIN(1.,1./(A + B * DENS(J,K)))

            A = -130.2 + 0.42884 * WAVE(5)*1.e7
            B = EXP(-55.947 + .044913 * WAVE(5)*1.e7 )
            GQYF(5) =  MIN(1.,1./(A + B * DENS(J,K)))

        ! Quantum yield of Acetone based on the paper of Blitz-2004
            a0 = 0.35*((TEMP(J,K)/295.)**(-1.28))
            b0 =(0.068)*((TEMP(J,K)/295.)**(-2.65))
            D0 = (a0/(1.-a0))*EXP(b0*(WAVE(2)*1.e7-248.))
            PHI_co=(1./(1.+D0))
            a1 = 1.6*1.E-19*((TEMP(J,K)/295.)**(-2.38))
            b1 = 0.55*1.E-3*((TEMP(J,K)/295.)**(-3.19))
            D1 = a1*EXP(-b1*((1.E7/(WAVE(2)*1.e7))-33113.))
            PHI_ch3co = (1.-PHI_co)/(1.+DENS(J,K)*D1)
            BQYF(2)=MIN(1.E+0,PHI_co+PHI_ch3co)

            a0 = 0.35*((TEMP(J,K)/295.)**(-1.28))
            b0 =(0.068)*((TEMP(J,K)/295.)**(-2.65))
            D0 = (a0/(1.-a0))*EXP(b0*(WAVE(3)*1.e7-248.))
            PHI_co=(1./(1.+D0))
            a1 = 1.6*1.E-19*((TEMP(J,K)/295.)**(-2.38))
            b1 = 0.55*1.E-3*((TEMP(J,K)/295.)**(-3.19))
            D1 = a1*EXP(-b1*((1.E7/(WAVE(3)*1.e7))-33113.))
            PHI_ch3co = (1.-PHI_co)/(1.+DENS(J,K)*D1)
            BQYF(3)=MIN(1.E+0,PHI_co+PHI_ch3co)

            a0 = 0.35*((TEMP(J,K)/295.)**(-1.28))
            b0 =(0.068)*((TEMP(J,K)/295.)**(-2.65))
            D0 = (a0/(1.-a0))*EXP(b0*(WAVE(4)*1.e7-248.))
            PHI_co=(1./(1.+D0))
            a2 = 1.62*1.E-17*((TEMP(J,K)/295.)**(-10.03))
            b2 = 1.79*1.E-03*((TEMP(J,K)/295.)**(-1.364))
            D2 = a2 *EXP(-b2*((1.E7/(WAVE(4)*1.e7))-30488.))
            a3 = 26.29 * ((TEMP(J,K)/295.)**(-6.59))
            b3 = 5.72*1.E-7 *((TEMP(J,K)/295.)**(-2.93))
            E3 = 30006. * ((TEMP(J,K)/295.)**(-0.064))
            D3 = a3*EXP(-b3*(((1.E7/(WAVE(4)*1.e7))-E3)**2))
            A4 = 1.67*1.E-15*((TEMP(J,K)/295.)**(-7.25))
            B4 = 2.08*1.E-05*((TEMP(J,K)/295.)**(-1.16))
            D4 = A4 *EXP(-B4*((1.E7/(WAVE(4)*1.e7))-30488.))
            PHI_ch3co = (1.-PHI_co) * (1.+D4*DENS(J,K)+D3) &
              / ((1.+D2*DENS(J,K)+D3)*(1.+D4*DENS(J,K)))
            BQYF(4)=MIN(1.E+0,PHI_co+PHI_ch3co)

            a0 = 0.35*((TEMP(J,K)/295.)**(-1.28))
            b0 =(0.068)*((TEMP(J,K)/295.)**(-2.65))
            D0 = (a0/(1.-a0))*EXP(b0*(WAVE(5)*1.e7-248.))
            PHI_co=(1./(1.+D0))
            a2 = 1.62*1.E-17*((TEMP(J,K)/295.)**(-10.03))
            b2 = 1.79*1.E-03*((TEMP(J,K)/295.)**(-1.364))
            D2 = a2 *EXP(-b2*((1.E7/(WAVE(5)*1.e7))-30488.))
            a3 = 26.29 * ((TEMP(J,K)/295.)**(-6.59))
            b3 = 5.72*1.E-7 *((TEMP(J,K)/295.)**(-2.93))
            E3 = 30006. * ((TEMP(J,K)/295.)**(-0.064))
            D3 = a3*EXP(-b3*(((1.E7/(WAVE(5)*1.e7))-E3)**2))
            A4 = 1.67*1.E-15*((TEMP(J,K)/295.)**(-7.25))
            B4 = 2.08*1.E-05*((TEMP(J,K)/295.)**(-1.16))
            D4 = A4 *EXP(-B4*((1.E7/(WAVE(5)*1.e7))-30488.))
            PHI_ch3co = (1.-PHI_co) * (1.+D4*DENS(J,K)+D3) &
              / ((1.+D2*DENS(J,K)+D3)*(1.+D4*DENS(J,K)))
            BQYF(5)=MIN(1.E+0,PHI_co+PHI_ch3co)

        ! quantum yield correction
          nqyf(2) = bqyf(2)/gqyf(2) ! BLITZ 2004
          nqyf(3) = bqyf(3)/gqyf(3)
          nqyf(4) = bqyf(4)/gqyf(4)
          nqyf(5) = bqyf(5)/gqyf(5)

        ! factors that correct the Jval depending on the "new" quantum yield
        dj=&
          sig_CH3COCH3(2) * F2 * fint(j,k,2) * nqyf(2) + &
          sig_CH3COCH3(3) * F3 * fint(j,k,3) * nqyf(3) + &
          sig_CH3COCH3(4) * F4 * fint(j,k,4) * nqyf(4) + &
          sig_CH3COCH3(5) * F5 * fint(j,k,5) * nqyf(5)
        jval_gp(ip_CH3COCH3)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

    CASE(3)

    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH3COCH3(2) = &
          p1(b2_CH3COCH3(i2(j,k)), a2_CH3COCH3(i2(j,k)),v3_du1(j,k))
        sig_CH3COCH3(3) = &
          p1(b3_CH3COCH3(i3(j,k)), a3_CH3COCH3(i3(j,k)),v3_du2(j,k))
        sig_CH3COCH3(4) = &
          p2(a4_CH3COCH3(1),a4_CH3COCH3(2),a4_CH3COCH3(3), v3_du2(j,k))
        sig_CH3COCH3(5) = &
          p3(a5_CH3COCH3(1),a5_CH3COCH3(2),a5_CH3COCH3(3), &
          a5_CH3COCH3(4),v3_du2(j,k))
        ! correction for density dependence
        drel = dens(j,k)/dens_ref
        C1 = p1(DSb3_1_CH3COCH3(i3(j,k)), DSa3_1_CH3COCH3(i3(j,k)), &
          v3_du2(j,k))
        C2 = p1(DSb3_2_CH3COCH3(i3(j,k)), DSa3_2_CH3COCH3(i3(j,k)), &
          v3_du2(j,k))
        F2 = 1./p1(4.3154E-01, 5.6559E-02, DREL)
        F3 = 1./p1(C1,C2,DREL)
        F4 = 1./p1(1.4094E-01, 8.5977E-02, DREL)
        F5 = 1./p1(2.0675E-01, 7.9342E-02, DREL)

        ! calculate some correction factors for acetone photolysis,
        ! due to new measurements of the quantum yield
        ! we can skip calculation of 1 & 6 & 7 wavelenght
        !  wavelength(7)
        ! 1 : 2.0513E-05, --> 205
        ! 2 : 2.8777E-05, --> 287 ! used
        ! 3 : 3.0200E-05, --> 302 ! used
        ! 4 : 3.0900E-05, --> 309 ! used
        ! 5 : 3.2000E-05, --> 320 ! used
        ! 6 : 3.7000E-05, --> 370
        ! 7:  5.8000E-05, --> 580
        ! the following lines have been made to increase calculation speed.
        ! If new wavelenght used, check the comments down (real calculation on
        ! all the wavelnght range!)
        ! Quantum Yield of Acetone based on the paper of Gierzack-1998
            A = -15.696 + 0.05707 *WAVE(2) *1.e7
            B = EXP(-88.81 + 0.15161 * WAVE(2)*1.e7 )
            GQYF(2) =  MIN(1.,1./(A + B * DENS(J,K)))

            A = -15.696 + 0.05707 *WAVE(3) *1.e7
            B = EXP(-88.81 + 0.15161 * WAVE(3)*1.e7 )
            GQYF(3) = MIN(1.,1./(A + B * DENS(J,K)))

            A = -130.2 + 0.42884 * WAVE(4)*1.e7
            B = EXP(-55.947 + .044913 * WAVE(4)*1.e7 )
            GQYF(4) =  MIN(1.,1./(A + B * DENS(J,K)))

            A = -130.2 + 0.42884 * WAVE(5)*1.e7
            B = EXP(-55.947 + .044913 * WAVE(5)*1.e7 )
            GQYF(5) =  MIN(1.,1./(A + B * DENS(J,K)))

        ! quantum yield of acetone based on Warneck
        ! Atmos. Environ. 35, 5773-5777 (2001)

          PhiS=(1.-0.113)*((1.+EXP(((WAVE(2)*1.E7)-307.5)/3.))**(-1.))+0.113
          WQYF(2) = &
            ((1./PhiS)+7.138E-7*DENS(J,K)*EXP((-8780.6/(WAVE(2)*1.E7))))**(-1.)

          PhiS=(1.-0.113)*((1.+EXP(((WAVE(3)*1.E7)-307.5)/3.))**(-1.))+0.113
          WQYF(3) = &
            ((1./PhiS)+7.138E-7*DENS(J,K)*EXP((-8780.6/(WAVE(3)*1.E7))))**(-1.)

          PhiS=(1.-0.113)*((1.+EXP(((WAVE(4)*1.E7)-307.5)/3.))**(-1.))+0.113
          WQYF(4) = &
            ((1./PhiS)+7.138E-7*DENS(J,K)*EXP((-8780.6/(WAVE(4)*1.E7))))**(-1.)

          PhiS=(1.-0.113)*((1.+EXP(((WAVE(5)*1.E7)-307.5)/3.))**(-1.))+0.113
          WQYF(5) = &
            ((1./PhiS)+7.138E-7*DENS(J,K)*EXP((-8780.6/(WAVE(5)*1.E7))))**(-1.)

        ! quantum yield correction
          nqyf(2) = wqyf(2)/gqyf(2) ! IUPAC
          nqyf(3) = wqyf(3)/gqyf(3)
          nqyf(4) = wqyf(4)/gqyf(4)
          nqyf(5) = wqyf(5)/gqyf(5)

        ! factors that correct the Jval depending on the "new" quantum yield
        dj=&
          sig_CH3COCH3(2) * F2 * fint(j,k,2) * nqyf(2) + &
          sig_CH3COCH3(3) * F3 * fint(j,k,3) * nqyf(3) + &
          sig_CH3COCH3(4) * F4 * fint(j,k,4) * nqyf(4) + &
          sig_CH3COCH3(5) * F5 * fint(j,k,5) * nqyf(5)
        jval_gp(ip_CH3COCH3)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

    END SELECT

  END SUBROUTINE jval_cal_CH3COCH3

  ! **************************************************************************

  SUBROUTINE jval_cal_MGLYOX(jrow)

    ! MGLYOX -> products Koch + Moortgat (1998), Meller et al. (1991)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_MGLYOX

    REAL :: f6, f7
    REAL :: prel

    ! T-const parameters:
    REAL, PARAMETER :: a2_MGLYOX(dim55) = (/ &
      6.3800E-22, 5.2200E-22, 3.9880E-22, 2.8800E-22, 1.9840E-22, 1.3200E-22, &
      8.6000E-23, 5.5200E-23, 3.5200E-23, 2.1999E-23, 1.4000E-23, 8.8004E-24, &
      5.1996E-24, 3.2002E-24, 2.4001E-24, 1.1994E-24, 8.0004E-25, 4.0067E-25, &
      0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
      0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
      0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
      0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
      0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
      0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
      0.0000E+00 /)
    REAL, PARAMETER :: b2_MGLYOX(dim55) = (/ &
      2.3144E-20, 2.3492E-20, 2.4170E-20, 2.5056E-20, 2.5997E-20, 2.6860E-20, &
      2.7573E-20, 2.8127E-20, 2.8537E-20, 2.8841E-20, 2.9045E-20, 2.9191E-20, &
      2.9300E-20, 2.9366E-20, 2.9395E-20, 2.9440E-20, 2.9457E-20, 2.9474E-20, &
      2.9492E-20, 2.9473E-20, 2.9493E-20, 2.9493E-20, 2.9493E-20, 2.9493E-20, &
      2.9493E-20, 2.9493E-20, 2.9493E-20, 2.9493E-20, 2.9465E-20, 2.9494E-20, &
      2.9494E-20, 2.9494E-20, 2.9494E-20, 2.9461E-20, 2.9495E-20, 2.9495E-20, &
      2.9495E-20, 2.9495E-20, 2.9457E-20, 2.9496E-20, 2.9488E-20, 2.9488E-20, &
      2.9498E-20, 2.9487E-20, 2.9499E-20, 2.9499E-20, 2.9485E-20, 2.9500E-20, &
      2.9500E-20, 2.9500E-20, 2.9500E-20, 2.9500E-20, 2.9500E-20, 2.9500E-20, &
      2.9500E-20 /)
    REAL, PARAMETER :: a3_MGLYOX(dim55) = (/ &
      -3.9314E-23, -2.1567E-23, -1.0662E-23, -5.8360E-24, -3.7488E-24, -2.7725E-24, &
      -2.2591E-24, -1.9514E-24, -1.7457E-24, -1.6087E-24, -1.5064E-24, -1.4034E-24, &
      -1.3349E-24, -1.2495E-24, -1.1980E-24, -1.1297E-24, -1.0782E-24, -1.0265E-24, &
      -9.7599E-25, -9.2470E-25, -8.8888E-25, -8.3905E-25, -8.0475E-25, -7.5346E-25, &
      -7.1793E-25, -7.0206E-25, -6.5066E-25, -6.3356E-25, -5.9829E-25, -5.6507E-25, &
      -5.3082E-25, -5.1372E-25, -4.7866E-25, -4.6232E-25, -4.4517E-25, -4.1028E-25, &
      -4.1098E-25, -3.7668E-25, -3.4248E-25, -3.4190E-25, -2.9099E-25, -2.2252E-25, &
      -1.6770E-25, -1.3010E-25, -9.9280E-26, -7.5283E-26, -5.8208E-26, -4.4502E-26, &
      -3.4225E-26, -2.7389E-26, -2.0531E-26, -1.3690E-26, -1.0276E-26, -1.0265E-26, &
      -6.8450E-27 /)
    REAL, PARAMETER :: b3_MGLYOX(dim55) = (/ &
      4.0886E-20, 3.9840E-20, 3.8560E-20, 3.7712E-20, 3.7223E-20, 3.6937E-20, &
      3.6757E-20, 3.6631E-20, 3.6535E-20, 3.6463E-20, 3.6403E-20, 3.6337E-20, &
      3.6289E-20, 3.6224E-20, 3.6182E-20, 3.6122E-20, 3.6073E-20, 3.6022E-20, &
      3.5969E-20, 3.5912E-20, 3.5870E-20, 3.5809E-20, 3.5765E-20, 3.5696E-20, &
      3.5646E-20, 3.5623E-20, 3.5545E-20, 3.5518E-20, 3.5460E-20, 3.5404E-20, &
      3.5344E-20, 3.5313E-20, 3.5247E-20, 3.5216E-20, 3.5182E-20, 3.5110E-20, &
      3.5112E-20, 3.5037E-20, 3.4962E-20, 3.4960E-20, 3.4841E-20, 3.4661E-20, &
      3.4501E-20, 3.4380E-20, 3.4272E-20, 3.4181E-20, 3.4111E-20, 3.4051E-20, &
      3.4003E-20, 3.3969E-20, 3.3933E-20, 3.3895E-20, 3.3875E-20, 3.3875E-20, &
      3.3853E-20 /)
    REAL, PARAMETER :: a4_MGLYOX(3) = (/ 2.3571E-20, -1.4561E-24, 1.4153E-28 /)
    REAL, PARAMETER :: a5_MGLYOX(3) = (/ 9.5590E-21, -1.0975E-24, 8.9459E-29 /)
    REAL, PARAMETER :: a6_MGLYOX(1) = (/ 2.1329E-21 /)
    REAL, PARAMETER :: a7_MGLYOX(2) = (/ 3.8083E-23, 2.6202E-27 /)

    jval_gp(ip_MGLYOX)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j  = 1,kproma_day
        PREL = (MIN(1.E5,PRESS(J,K))/PRESS_REF)  !relative pressure
        sig_MGLYOX(2) = &
          p1(b2_MGLYOX(i2(j,k)), a2_MGLYOX(i2(j,k)), &
          v3_du1(j,k))
        sig_MGLYOX(3) = &
          p1(b3_MGLYOX(i3(j,k)), a3_MGLYOX(i3(j,k)), &
          v3_du2(j,k))
        sig_MGLYOX(4) = &
          p2(a4_MGLYOX(1),a4_MGLYOX(2),a4_MGLYOX(3),v3_du2(j,k))
        sig_MGLYOX(5) = &
          p2(a5_MGLYOX(1),a5_MGLYOX(2),a5_MGLYOX(3),v3_du2(j,k))
        sig_MGLYOX(6) = &
          a6_MGLYOX(1)
        sig_MGLYOX(7) = &
          p1(a7_MGLYOX(1),a7_MGLYOX(2),v3_du2(j,k))
        F6 = 1./p1(8.7005E-02, 9.1257E-02, PREL)
        F7 = 1./p1(5.3416E-02, 9.4662E-02, PREL)
        dj = 0. &
          + sig_MGLYOX(2) * fint(j,k,2) &
          + sig_MGLYOX(3) * fint(j,k,3) &
          + sig_MGLYOX(4) * fint(j,k,4) &
          + sig_MGLYOX(5) * fint(j,k,5) &
          + sig_MGLYOX(6) * F6 * fint(j,k,6) &
          + sig_MGLYOX(7) * F7 * fint(j,k,7)

        jval_gp(ip_MGLYOX)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_MGLYOX

  ! **************************************************************************

  SUBROUTINE jval_cal_HOCl(jrow)

    ! HOCl -> OH + Cl JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_HOCl

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_HOCl(dim58) = (/ &
      -1.9164E-23, -2.0811E-23, -2.3069E-23, -2.5525E-23, -2.7402E-23, -3.0533E-23, &
      -3.2150E-23, -3.5545E-23, -3.8514E-23, -4.1457E-23, -4.4937E-23, -4.8048E-23, &
      -5.3646E-23, -6.2911E-23, -6.5982E-23, -7.0085E-23, -7.5086E-23, -7.9519E-23, &
      -8.4437E-23, -9.0893E-23, -9.4540E-23, -9.9026E-23, -1.0643E-22, -1.0981E-22, &
      -1.1540E-22, -1.1829E-22, -1.2365E-22, -1.2931E-22, -1.3615E-22, -1.4214E-22, &
      -1.4883E-22, -1.5493E-22, -1.6060E-22, -1.6558E-22, -1.7220E-22, -1.7768E-22, &
      -1.8302E-22, -1.9041E-22, -1.9780E-22, -2.0620E-22, -2.1568E-22, -2.2744E-22, &
      -2.3703E-22, -2.4864E-22, -2.5831E-22, -2.6625E-22, -2.7198E-22, -2.7393E-22, &
      -2.7385E-22, -2.6860E-22, -2.6290E-22, -2.5430E-22, -2.4430E-22, -2.3216E-22, &
      -2.1892E-22, -2.0185E-22, -1.7599E-22, -1.4402E-22 /)
    REAL, PARAMETER :: a0_1_2_HOCl(dim58) = (/ &
      7.0956E-20, 7.1029E-20, 7.1129E-20, 7.1239E-20, 7.1323E-20, 7.1464E-20, &
      7.1537E-20, 7.1691E-20, 7.1826E-20, 7.1961E-20, 7.2121E-20, 7.2265E-20, &
      7.2525E-20, 7.2957E-20, 7.3100E-20, 7.3293E-20, 7.3529E-20, 7.3739E-20, &
      7.3973E-20, 7.4282E-20, 7.4457E-20, 7.4673E-20, 7.5032E-20, 7.5196E-20, &
      7.5469E-20, 7.5610E-20, 7.5874E-20, 7.6154E-20, 7.6493E-20, 7.6791E-20, &
      7.7126E-20, 7.7432E-20, 7.7718E-20, 7.7970E-20, 7.8306E-20, 7.8585E-20, &
      7.8859E-20, 7.9239E-20, 7.9620E-20, 8.0055E-20, 8.0548E-20, 8.1162E-20, &
      8.1665E-20, 8.2275E-20, 8.2786E-20, 8.3207E-20, 8.3511E-20, 8.3615E-20, &
      8.3611E-20, 8.3329E-20, 8.3021E-20, 8.2555E-20, 8.2011E-20, 8.1348E-20, &
      8.0622E-20, 7.9684E-20, 7.8256E-20, 7.6485E-20 /)
    REAL, PARAMETER :: a0_2_1_HOCl(dim58) = (/ &
      5.9321E-26, 6.1029E-26, 6.8919E-26, 7.3138E-26, 7.8794E-26, 8.8792E-26, &
      8.1497E-26, 9.8355E-26, 1.0083E-25, 1.0192E-25, 1.1125E-25, 1.1247E-25, &
      1.4744E-25, 2.1478E-25, 2.0322E-25, 2.0199E-25, 2.1924E-25, 2.0794E-25, &
      2.0978E-25, 2.3150E-25, 2.1390E-25, 2.1166E-25, 2.3390E-25, 2.1561E-25, &
      2.1678E-25, 1.8975E-25, 1.8312E-25, 1.8496E-25, 1.9031E-25, 1.9553E-25, &
      2.0025E-25, 2.0409E-25, 2.0676E-25, 2.0500E-25, 2.1446E-25, 2.1178E-25, &
      2.1455E-25, 2.1643E-25, 2.1760E-25, 2.2375E-25, 2.2536E-25, 2.3376E-25, &
      2.3369E-25, 2.4136E-25, 2.3947E-25, 2.3636E-25, 2.3385E-25, 2.2207E-25, &
      2.1536E-25, 1.9616E-25, 1.8607E-25, 1.7299E-25, 1.5934E-25, 1.4291E-25, &
      1.2763E-25, 1.0852E-25, 9.1891E-26, 7.5763E-26 /)
    REAL, PARAMETER :: a0_2_2_HOCl(dim58) = (/ &
      -5.1795E-24, -5.2550E-24, -5.6053E-24, -5.7934E-24, -6.0468E-24, -6.4967E-24, &
      -6.1670E-24, -6.9324E-24, -7.0451E-24, -7.0951E-24, -7.5242E-24, -7.5805E-24, &
      -9.2032E-24, -1.2341E-23, -1.1801E-23, -1.1743E-23, -1.2557E-23, -1.2021E-23, &
      -1.2109E-23, -1.3147E-23, -1.2302E-23, -1.2194E-23, -1.3271E-23, -1.2382E-23, &
      -1.2439E-23, -1.1114E-23, -1.0788E-23, -1.0879E-23, -1.1145E-23, -1.1404E-23, &
      -1.1640E-23, -1.1833E-23, -1.1968E-23, -1.1878E-23, -1.2359E-23, -1.2223E-23, &
      -1.2364E-23, -1.2461E-23, -1.2521E-23, -1.2840E-23, -1.2924E-23, -1.3362E-23, &
      -1.3358E-23, -1.3762E-23, -1.3662E-23, -1.3497E-23, -1.3364E-23, -1.2734E-23, &
      -1.2375E-23, -1.1342E-23, -1.0797E-23, -1.0088E-23, -9.3458E-24, -8.4484E-24, &
      -7.6115E-24, -6.5601E-24, -5.6422E-24, -4.7488E-24 /)
    REAL, PARAMETER :: a1_1_HOCl(dim55) = (/ &
      -3.2344E-21, -2.9963E-21, -2.7456E-21, -2.4330E-21, -2.1331E-21, -1.8581E-21, &
      -1.5833E-21, -1.3835E-21, -1.1639E-21, -1.0345E-21, -8.6780E-22, -7.8753E-22, &
      -6.6120E-22, -6.1357E-22, -5.1619E-22, -4.8899E-22, -4.1187E-22, -3.9770E-22, &
      -3.3473E-22, -3.2887E-22, -2.7616E-22, -2.7572E-22, -2.3073E-22, -2.3389E-22, &
      -1.9478E-22, -2.0026E-22, -1.6611E-22, -1.7308E-22, -1.4235E-22, -1.5056E-22, &
      -1.2317E-22, -1.3183E-22, -1.0725E-22, -1.1624E-22, -9.3637E-23, -1.0305E-22, &
      -8.2279E-23, -9.1755E-23, -7.2722E-23, -8.2056E-23, -6.2688E-23, -5.0502E-23, &
      -3.7835E-23, -3.1962E-23, -2.4353E-23, -2.1360E-23, -1.6307E-23, -1.4748E-23, &
      -8.9578E-24, -7.5051E-24, -6.3176E-24, -5.2609E-24, -4.3685E-24, -3.6132E-24, &
      -2.9313E-24 /)
    REAL, PARAMETER :: b1_1_HOCl(dim55) = (/ &
      1.3448E-19, 1.3377E-19, 1.3239E-19, 1.2989E-19, 1.2674E-19, 1.2317E-19, &
      1.1891E-19, 1.1531E-19, 1.1081E-19, 1.0783E-19, 1.0358E-19, 1.0133E-19, &
      9.7480E-20, 9.5908E-20, 9.2451E-20, 9.1418E-20, 8.8294E-20, 8.7685E-20, &
      8.4820E-20, 8.4539E-20, 8.1877E-20, 8.1854E-20, 7.9356E-20, 7.9540E-20, &
      7.7173E-20, 7.7519E-20, 7.5282E-20, 7.5756E-20, 7.3590E-20, 7.4189E-20, &
      7.2121E-20, 7.2796E-20, 7.0817E-20, 7.1564E-20, 6.9631E-20, 7.0460E-20, &
      6.8580E-20, 6.9461E-20, 6.7643E-20, 6.8558E-20, 6.6612E-20, 6.5235E-20, &
      6.3645E-20, 6.2834E-20, 6.1689E-20, 6.1202E-20, 6.0315E-20, 6.0022E-20, &
      5.8861E-20, 5.8551E-20, 5.8283E-20, 5.8032E-20, 5.7808E-20, 5.7610E-20, &
      5.7422E-20 /)
    REAL, PARAMETER :: a1_2_HOCl(dim55) = (/ &
      2.4366E-24, -6.0757E-25, -2.0946E-24, -3.8247E-24, -4.8141E-24, -5.0919E-24, &
      -5.6434E-24, -5.0456E-24, -5.3216E-24, -4.3491E-24, -4.5319E-24, -3.5462E-24, &
      -3.7215E-24, -2.8322E-24, -3.0180E-24, -2.2580E-24, -2.4556E-24, -1.8157E-24, &
      -2.0184E-24, -1.4761E-24, -1.6794E-24, -1.2165E-24, -1.4134E-24, -1.0136E-24, &
      -1.2028E-24, -8.5491E-25, -1.0318E-24, -7.2686E-25, -8.9438E-25, -6.2366E-25, &
      -7.7942E-25, -5.3927E-25, -6.8262E-25, -4.6826E-25, -6.0344E-25, -4.0919E-25, &
      -5.3503E-25, -3.5967E-25, -4.7612E-25, -3.1757E-25, -3.3695E-25, -2.3951E-25, &
      -2.0317E-25, -1.4868E-25, -1.3174E-25, -9.8455E-26, -9.0532E-26, -6.8735E-26, &
      -7.7818E-26, -6.5566E-26, -5.5638E-26, -4.7755E-26, -4.1222E-26, -3.5787E-26, &
      -3.1249E-26 /)
    REAL, PARAMETER :: b1_2_HOCl(dim55) = (/ &
      2.1696E-22, 2.2610E-22, 2.3428E-22, 2.4812E-22, 2.5851E-22, 2.6212E-22, &
      2.7067E-22, 2.5990E-22, 2.6556E-22, 2.4320E-22, 2.4786E-22, 2.2026E-22, &
      2.2561E-22, 1.9626E-22, 2.0285E-22, 1.7397E-22, 1.8198E-22, 1.5446E-22, &
      1.6368E-22, 1.3765E-22, 1.4792E-22, 1.2339E-22, 1.3432E-22, 1.1113E-22, &
      1.2257E-22, 1.0066E-22, 1.1224E-22, 9.1505E-23, 1.0332E-22, 8.3553E-23, &
      9.5313E-23, 7.6581E-23, 8.8121E-23, 7.0329E-23, 8.1887E-23, 6.4793E-23, &
      7.6182E-23, 5.9873E-23, 7.0994E-23, 5.5456E-23, 5.7404E-23, 4.6393E-23, &
      4.1833E-23, 3.4313E-23, 3.1762E-23, 2.6338E-23, 2.4947E-23, 2.0849E-23, &
      2.2670E-23, 2.0061E-23, 1.7822E-23, 1.5946E-23, 1.4309E-23, 1.2880E-23, &
      1.1630E-23 /)
    REAL, PARAMETER :: a2_HOCl(dim55) = (/ &
      -2.2908E-21, -1.8804E-21, -1.4352E-21, -1.0292E-21, -7.0120E-22, -4.5800E-22, &
      -2.8880E-22, -1.7600E-22, -1.0320E-22, -5.7200E-23, -2.8401E-23, -1.0800E-23, &
      -3.9937E-25, 5.9996E-24, 9.6005E-24, 1.1199E-23, 1.2400E-23, 1.2400E-23, &
      1.2400E-23, 1.2001E-23, 1.1199E-23, 1.1201E-23, 1.0401E-23, 9.5992E-24, &
      9.1998E-24, 8.8004E-24, 8.3998E-24, 7.5997E-24, 7.2003E-24, 6.7997E-24, &
      6.4003E-24, 5.9996E-24, 5.6003E-24, 5.6003E-24, 4.8002E-24, 4.8002E-24, &
      4.3996E-24, 4.0002E-24, 4.0002E-24, 3.5995E-24, 3.0399E-24, 2.1602E-24, &
      1.5998E-24, 1.2002E-24, 7.9978E-25, 5.6016E-25, 4.8002E-25, 3.2002E-25, &
      2.3988E-25, 1.6001E-25, 8.0133E-26, 7.9875E-26, 8.0133E-26, 7.9875E-26, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b2_HOCl(dim55) = (/ &
       7.2418E-20,  7.1187E-20,  6.8739E-20,  6.5491E-20,  6.2047E-20,  5.8885E-20, &
       5.6262E-20,  5.4232E-20,  5.2740E-20,  5.1682E-20,  5.0947E-20,  5.0454E-20, &
       5.0137E-20,  4.9926E-20,  4.9798E-20,  4.9737E-20,  4.9689E-20,  4.9689E-20, &
       4.9689E-20,  4.9708E-20,  4.9748E-20,  4.9748E-20,  4.9793E-20,  4.9839E-20, &
       4.9863E-20,  4.9889E-20,  4.9915E-20,  4.9969E-20,  4.9997E-20,  5.0027E-20, &
       5.0057E-20,  5.0088E-20,  5.0120E-20,  5.0120E-20,  5.0189E-20,  5.0189E-20, &
       5.0225E-20,  5.0262E-20,  5.0262E-20,  5.0301E-20,  5.0357E-20,  5.0457E-20, &
       5.0527E-20,  5.0582E-20,  5.0643E-20,  5.0682E-20,  5.0696E-20,  5.0726E-20, &
       5.0742E-20,  5.0759E-20,  5.0777E-20,  5.0777E-20,  5.0777E-20,  5.0777E-20, &
       5.0799E-20 /)
    REAL, PARAMETER :: a3_HOCl(dim55) = (/ &
      2.2446E-23, 1.8493E-23, 1.4338E-23, 1.0744E-23, 7.9473E-24, 5.7908E-24, &
      4.3548E-24, 3.2748E-24, 2.5558E-24, 2.0368E-24, 1.6379E-24, 1.3580E-24, &
      1.1183E-24, 9.9826E-25, 7.9908E-25, 7.1876E-25, 6.3901E-25, 5.5926E-25, &
      4.7919E-25, 4.3951E-25, 3.9925E-25, 3.1950E-25, 3.1963E-25, 2.3950E-25, &
      2.7976E-25, 1.9950E-25, 1.9983E-25, 1.5975E-25, 1.5975E-25, 1.5975E-25, &
      1.1980E-25, 8.0005E-26, 1.1975E-25, 7.9747E-26, 8.0037E-26, 4.0003E-26, &
      7.9747E-26, 4.0003E-26, 4.0018E-26, 3.9745E-26, 8.0005E-27, -8.0005E-27, &
      -2.3950E-26, -3.1950E-26, -3.9983E-26, -3.9899E-26, -4.7951E-26, -3.9899E-26, &
      -4.7951E-26, -3.9951E-26, -3.9899E-26, -3.9951E-26, -3.1976E-26, -3.1950E-26, &
      -3.1950E-26 /)
    REAL, PARAMETER :: b3_HOCl(dim55) = (/ &
      5.7986E-20, 5.8087E-20, 5.8297E-20, 5.8569E-20, 5.8850E-20, 5.9121E-20, &
      5.9338E-20, 5.9527E-20, 5.9672E-20, 5.9789E-20, 5.9889E-20, 5.9966E-20, &
      6.0038E-20, 6.0078E-20, 6.0148E-20, 6.0178E-20, 6.0210E-20, 6.0244E-20, &
      6.0280E-20, 6.0299E-20, 6.0319E-20, 6.0361E-20, 6.0361E-20, 6.0407E-20, &
      6.0383E-20, 6.0433E-20, 6.0433E-20, 6.0460E-20, 6.0460E-20, 6.0460E-20, &
      6.0490E-20, 6.0521E-20, 6.0489E-20, 6.0522E-20, 6.0522E-20, 6.0557E-20, &
      6.0521E-20, 6.0558E-20, 6.0558E-20, 6.0558E-20, 6.0590E-20, 6.0608E-20, &
      6.0628E-20, 6.0639E-20, 6.0651E-20, 6.0651E-20, 6.0665E-20, 6.0650E-20, &
      6.0666E-20, 6.0649E-20, 6.0649E-20, 6.0649E-20, 6.0629E-20, 6.0629E-20, &
      6.0629E-20 /)
    REAL, PARAMETER :: a4_HOCl(2) = (/ 5.8378E-20, -5.3884E-25 /)
    REAL, PARAMETER :: a5_HOCl(2) = (/ 3.9739E-20, -1.6332E-24 /)
    REAL, PARAMETER :: a6_HOCl(1) = (/ 4.8547E-21 /)

    jval_gp(ip_HOCl)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_HOCl(0) = &
          p1(a0_1_1_HOCl(i0(j,k))*dlv2(j,k) + &
          a0_1_2_HOCl(i0(j,k)), &
          a0_2_1_HOCl(i0(j,k))*dlv2(j,k) + &
          a0_2_2_HOCl(i0(j,k)),v3_du1(j,k))
        sig_HOCl(1) = &
          (p1(b1_1_HOCl(i1(j,k)),a1_1_HOCl(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_HOCl(i1(j,k)),a1_2_HOCl(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_HOCl(2) = &
          p1(b2_HOCl(i2(j,k)), a2_HOCl(i2(j,k)), &
          v3_du1(j,k))
        sig_HOCl(3) = &
          p1(b3_HOCl(i3(j,k)), a3_HOCl(i3(j,k)), &
          v3_du2(j,k))
        sig_HOCl(4) = &
          p1(a4_HOCl(1),a4_HOCl(2),v3_du2(j,k))
        sig_HOCl(5) = &
          p1(a5_HOCl(1),a5_HOCl(2),v3_du2(j,k))
        sig_HOCl(6) = &
          a6_HOCl(1)
        dj = 0. &
          + sig_HOCl(0) * fint(j,k,0) &
          + sig_HOCl(1) * fint(j,k,1) &
          + sig_HOCl(2) * fint(j,k,2) &
          + sig_HOCl(3) * fint(j,k,3) &
          + sig_HOCl(4) * fint(j,k,4) &
          + sig_HOCl(5) * fint(j,k,5) &
          + sig_HOCl(6) * fint(j,k,6)

        jval_gp(ip_HOCl)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,3))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_HOCl

  ! **************************************************************************

  SUBROUTINE jval_cal_OClO(jrow)

    ! OClO -> products Wahner et al., JPC 91, 2734 (1987)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_OClO

    ! T-const parameters:
    REAL, PARAMETER :: a3_OClO(dim55) = (/ &
      2.0808E-21, 1.8253E-21, 1.5257E-21, 1.2541E-21, 1.0264E-21, 8.5463E-22, &
      7.2713E-22, 6.3498E-22, 5.6709E-22, 5.1917E-22, 4.8342E-22, 4.6326E-22, &
      4.4329E-22, 4.3531E-22, 4.2349E-22, 4.2332E-22, 4.1933E-22, 4.1534E-22, &
      4.1949E-22, 4.1933E-22, 4.2332E-22, 4.2332E-22, 4.3148E-22, 4.2732E-22, &
      4.3530E-22, 4.3530E-22, 4.3548E-22, 4.4329E-22, 4.3930E-22, 4.4329E-22, &
      4.4347E-22, 4.4728E-22, 4.4329E-22, 4.4728E-22, 4.4347E-22, 4.4729E-22, &
      4.4329E-22, 4.3930E-22, 4.4346E-22, 4.3530E-22, 4.3051E-22, 4.1374E-22, &
      3.9137E-22, 3.6821E-22, 3.4373E-22, 3.1709E-22, 2.9153E-22, 2.6757E-22, &
      2.4441E-22, 2.2204E-22, 2.0128E-22, 1.8211E-22, 1.6467E-22, 1.4856E-22, &
      1.3339E-22 /)
    REAL, PARAMETER :: b3_OClO(dim55) = (/ &
      1.3095E-18, 1.3160E-18, 1.3311E-18, 1.3517E-18, 1.3746E-18, 1.3962E-18, &
      1.4154E-18, 1.4316E-18, 1.4452E-18, 1.4561E-18, 1.4650E-18, 1.4706E-18, &
      1.4766E-18, 1.4792E-18, 1.4833E-18, 1.4834E-18, 1.4850E-18, 1.4867E-18, &
      1.4848E-18, 1.4849E-18, 1.4829E-18, 1.4829E-18, 1.4784E-18, 1.4808E-18, &
      1.4760E-18, 1.4760E-18, 1.4759E-18, 1.4706E-18, 1.4734E-18, 1.4705E-18, &
      1.4704E-18, 1.4674E-18, 1.4706E-18, 1.4673E-18, 1.4706E-18, 1.4672E-18, &
      1.4708E-18, 1.4745E-18, 1.4706E-18, 1.4785E-18, 1.4833E-18, 1.5022E-18, &
      1.5302E-18, 1.5622E-18, 1.5989E-18, 1.6423E-18, 1.6871E-18, 1.7321E-18, &
      1.7785E-18, 1.8261E-18, 1.8729E-18, 1.9185E-18, 1.9622E-18, 2.0046E-18, &
      2.0464E-18 /)
    REAL, PARAMETER :: a4_OClO(3) = (/ 2.3926E-18, 2.6479E-22, -7.5432E-26 /)
    REAL, PARAMETER :: a5_OClO(2) = (/ 3.6402E-18, 1.7309E-22 /)
    REAL, PARAMETER :: a6_OClO(1) = (/ 2.9141E-18 /)
    REAL, PARAMETER :: a7_OClO(2) = (/ 3.1742E-20, 2.0031E-24 /)

    jval_gp(ip_OClO)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_OClO(3) = &
          p1(b3_OClO(i3(j,k)), a3_OClO(i3(j,k)), &
          v3_du2(j,k))
        sig_OClO(4) = &
          p2(a4_OClO(1),a4_OClO(2),a4_OClO(3),v3_du2(j,k))
        sig_OClO(5) = &
          p1(a5_OClO(1),a5_OClO(2),v3_du2(j,k))
        sig_OClO(6) = &
          a6_OClO(1)
        sig_OClO(7) = &
          p1(a7_OClO(1),a7_OClO(2),v3_du2(j,k))
        dj = 0. &
          + sig_OClO(3) * fint(j,k,3) &
          + sig_OClO(4) * fint(j,k,4) &
          + sig_OClO(5) * fint(j,k,5) &
          + sig_OClO(6) * fint(j,k,6) &
          + sig_OClO(7) * fint(j,k,7)

        jval_gp(ip_OClO)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_OClO

  ! **************************************************************************

  SUBROUTINE jval_cal_Cl2O2(jrow)

    ! Cl2O2 -> Cl + ClO2 JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_Cl2O2

    ! T-const parameters:
    REAL, PARAMETER :: a1_1_Cl2O2(dim55) = (/ &
      -7.3676E-20, -6.4158E-20, -5.3585E-20, -4.3921E-20, -3.4766E-20, -2.7170E-20, &
      -2.0710E-20, -1.5485E-20, -1.1366E-20, -8.0213E-21, -5.5036E-21, -3.4615E-21, &
      -1.9788E-21, -6.4247E-22, 1.5551E-22, 1.0059E-21, 1.4875E-21, 1.9825E-21, &
      2.2527E-21, 2.6161E-21, 2.7099E-21, 2.9590E-21, 2.9926E-21, 3.1382E-21, &
      3.1248E-21, 3.2472E-21, 3.2050E-21, 3.2392E-21, 3.2183E-21, 3.2546E-21, &
      3.1755E-21, 3.2176E-21, 3.1315E-21, 3.1607E-21, 3.0805E-21, 3.0755E-21, &
      3.0105E-21, 3.0176E-21, 2.9381E-21, 2.9336E-21, 2.7960E-21, 2.6145E-21, &
      2.4352E-21, 2.2732E-21, 2.1167E-21, 1.9817E-21, 1.8499E-21, 1.7413E-21, &
      1.6090E-21, 1.5117E-21, 1.4240E-21, 1.3366E-21, 1.2617E-21, 1.1889E-21, &
      1.1264E-21 /)
    REAL, PARAMETER :: b1_1_Cl2O2(dim55) = (/ &
      3.4148E-18, 3.3863E-18, 3.3281E-18, 3.2508E-18, 3.1547E-18, 3.0559E-18, &
      2.9558E-18, 2.8617E-18, 2.7773E-18, 2.7004E-18, 2.6362E-18, 2.5790E-18, &
      2.5338E-18, 2.4897E-18, 2.4614E-18, 2.4290E-18, 2.4095E-18, 2.3883E-18, &
      2.3760E-18, 2.3585E-18, 2.3538E-18, 2.3406E-18, 2.3387E-18, 2.3303E-18, &
      2.3311E-18, 2.3234E-18, 2.3261E-18, 2.3238E-18, 2.3253E-18, 2.3226E-18, &
      2.3286E-18, 2.3253E-18, 2.3323E-18, 2.3298E-18, 2.3367E-18, 2.3371E-18, &
      2.3430E-18, 2.3423E-18, 2.3499E-18, 2.3504E-18, 2.3642E-18, 2.3847E-18, &
      2.4072E-18, 2.4296E-18, 2.4531E-18, 2.4751E-18, 2.4983E-18, 2.5187E-18, &
      2.5452E-18, 2.5659E-18, 2.5857E-18, 2.6065E-18, 2.6253E-18, 2.6444E-18, &
      2.6616E-18 /)
    REAL, PARAMETER :: a1_2_Cl2O2(dim55) = (/ &
      -1.9913E-22, -2.3642E-22, -2.7474E-22, -2.6136E-22, -2.5340E-22, -2.1901E-22, &
      -1.8923E-22, -1.5732E-22, -1.2728E-22, -1.0503E-22, -8.1621E-23, -6.7287E-23, &
      -5.0400E-23, -4.3986E-23, -3.0892E-23, -2.8070E-23, -1.9259E-23, -1.7639E-23, &
      -1.1278E-23, -1.1829E-23, -6.0977E-24, -7.4663E-24, -3.2290E-24, -4.3506E-24, &
      -8.6234E-25, -2.3785E-24, 3.1157E-25, -5.7083E-25, 1.0210E-24, 1.0524E-25, &
      2.0379E-24, 6.5447E-25, 2.6438E-24, 1.1194E-24, 2.7549E-24, 1.7541E-24, &
      2.9461E-24, 1.8035E-24, 2.9124E-24, 2.1765E-24, 2.7855E-24, 2.6329E-24, &
      2.6965E-24, 2.5272E-24, 2.5414E-24, 2.3570E-24, 2.3656E-24, 2.1441E-24, &
      2.4209E-24, 2.2875E-24, 2.1459E-24, 2.0518E-24, 1.9378E-24, 1.8275E-24, &
      1.6841E-24 /)
    REAL, PARAMETER :: b1_2_Cl2O2(dim55) = (/ &
      5.2781E-21, 5.3900E-21, 5.6008E-21, 5.4938E-21, 5.4101E-21, 4.9631E-21, &
      4.5015E-21, 3.9271E-21, 3.3113E-21, 2.7995E-21, 2.2026E-21, 1.8013E-21, &
      1.2862E-21, 1.0745E-21, 6.0970E-22, 5.0246E-22, 1.4561E-22, 7.5971E-23, &
      -2.1348E-22, -1.8704E-22, -4.7645E-22, -4.0392E-22, -6.3909E-22, -5.7404E-22, &
      -7.8508E-22, -6.8956E-22, -8.6576E-22, -8.0575E-22, -9.1798E-22, -8.5113E-22, &
      -9.9704E-22, -8.8914E-22, -1.0493E-21, -9.2275E-22, -1.0626E-21, -9.7451E-22, &
      -1.0824E-21, -9.7613E-22, -1.0820E-21, -1.0099E-21, -1.0711E-21, -1.0539E-21, &
      -1.0619E-21, -1.0385E-21, -1.0406E-21, -1.0106E-21, -1.0121E-21, -9.7045E-22, &
      -1.0259E-21, -9.9752E-22, -9.6558E-22, -9.4319E-22, -9.1463E-22, -8.8562E-22, &
      -8.4614E-22 /)
    REAL, PARAMETER :: a2_Cl2O2(dim55) = (/ &
      -1.0832E-19, -9.3560E-20, -7.5760E-20, -5.8360E-20, -4.3360E-20, -3.1600E-20, &
      -2.2800E-20, -1.6560E-20, -1.2160E-20, -9.0800E-21, -6.9600E-21, -5.4000E-21, &
      -4.3200E-21, -3.5600E-21, -2.9600E-21, -2.4800E-21, -2.1600E-21, -1.8800E-21, &
      -1.6800E-21, -1.4800E-21, -1.3600E-21, -1.2000E-21, -1.0800E-21, -9.9998E-22, &
      -9.2003E-22, -8.8000E-22, -7.5997E-22, -7.2002E-22, -6.7998E-22, -6.0004E-22, &
      -6.0000E-22, -5.1997E-22, -5.2001E-22, -4.4002E-22, -4.3998E-22, -4.0002E-22, &
      -3.9998E-22, -3.5999E-22, -3.2004E-22, -3.1999E-22, -2.5600E-22, -1.8400E-22, &
      -1.2801E-22, -9.5994E-23, -7.2006E-23, -4.7993E-23, -3.2004E-23, -3.2004E-23, &
      -1.5998E-23, -1.5998E-23, -7.9988E-24, -7.9988E-24, -0.0000E+00, -8.0071E-24, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b2_Cl2O2(dim55) = (/ &
       2.6205E-18,  2.5762E-18,  2.4783E-18,  2.3391E-18,  2.1816E-18,  2.0287E-18, &
       1.8923E-18,  1.7800E-18,  1.6898E-18,  1.6189E-18,  1.5649E-18,  1.5212E-18, &
       1.4883E-18,  1.4632E-18,  1.4419E-18,  1.4236E-18,  1.4107E-18,  1.3986E-18, &
       1.3895E-18,  1.3799E-18,  1.3739E-18,  1.3654E-18,  1.3587E-18,  1.3541E-18, &
       1.3493E-18,  1.3467E-18,  1.3389E-18,  1.3362E-18,  1.3333E-18,  1.3275E-18, &
       1.3275E-18,  1.3213E-18,  1.3213E-18,  1.3146E-18,  1.3146E-18,  1.3111E-18, &
       1.3111E-18,  1.3074E-18,  1.3036E-18,  1.3036E-18,  1.2971E-18,  1.2890E-18, &
       1.2820E-18,  1.2775E-18,  1.2739E-18,  1.2700E-18,  1.2672E-18,  1.2672E-18, &
       1.2640E-18,  1.2640E-18,  1.2622E-18,  1.2622E-18,  1.2602E-18,  1.2623E-18, &
       1.2601E-18 /)
    REAL, PARAMETER :: a3_Cl2O2(dim55) = (/ &
      -1.4825E-21, -1.2709E-21, -1.0368E-21, -8.2199E-22, -6.4497E-22, -5.0919E-22, &
      -4.0671E-22, -3.3107E-22, -2.7476E-22, -2.3163E-22, -1.9896E-22, -1.7292E-22, &
      -1.5216E-22, -1.3458E-22, -1.2066E-22, -1.0863E-22, -9.8244E-23, -8.9455E-23, &
      -8.1902E-23, -7.5081E-23, -6.9488E-23, -6.4297E-23, -5.9928E-23, -5.5911E-23, &
      -5.1918E-23, -4.9122E-23, -4.5944E-23, -4.3131E-23, -4.0735E-23, -3.8338E-23, &
      -3.6755E-23, -3.4345E-23, -3.2747E-23, -3.1550E-23, -2.9565E-23, -2.8354E-23, &
      -2.7156E-23, -2.5959E-23, -2.4771E-23, -2.3960E-23, -2.1007E-23, -1.7412E-23, &
      -1.4697E-23, -1.2540E-23, -1.0712E-23, -9.3450E-24, -8.0670E-24, -7.1086E-24, &
      -6.2299E-24, -5.4313E-24, -4.7925E-24, -4.2334E-24, -3.7569E-24, -3.2749E-24, &
      -2.8752E-24 /)
    REAL, PARAMETER :: b3_Cl2O2(dim55) = (/ &
      8.1681E-19, 8.1141E-19, 7.9957E-19, 7.8332E-19, 7.6551E-19, 7.4844E-19, &
      7.3299E-19, 7.1970E-19, 7.0839E-19, 6.9865E-19, 6.9046E-19, 6.8327E-19, &
      6.7702E-19, 6.7129E-19, 6.6640E-19, 6.6188E-19, 6.5772E-19, 6.5397E-19, &
      6.5056E-19, 6.4731E-19, 6.4451E-19, 6.4178E-19, 6.3937E-19, 6.3705E-19, &
      6.3465E-19, 6.3290E-19, 6.3083E-19, 6.2893E-19, 6.2725E-19, 6.2551E-19, &
      6.2432E-19, 6.2244E-19, 6.2116E-19, 6.2017E-19, 6.1848E-19, 6.1742E-19, &
      6.1634E-19, 6.1523E-19, 6.1410E-19, 6.1331E-19, 6.1035E-19, 6.0630E-19, &
      6.0290E-19, 5.9992E-19, 5.9718E-19, 5.9495E-19, 5.9271E-19, 5.9091E-19, &
      5.8915E-19, 5.8745E-19, 5.8601E-19, 5.8468E-19, 5.8349E-19, 5.8222E-19, &
      5.8112E-19 /)
    REAL, PARAMETER :: a4_Cl2O2(2) = (/ 4.3132E-19, -1.9835E-23 /)
    REAL, PARAMETER :: a5_Cl2O2(2) = (/ 1.9960E-19, -1.1005E-23 /)
    REAL, PARAMETER :: a6_Cl2O2(1) = (/ 2.7897E-20 /)

    jval_gp(ip_Cl2O2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_Cl2O2(1) = &
          (p1(b1_1_Cl2O2(i1(j,k)),a1_1_Cl2O2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_Cl2O2(i1(j,k)),a1_2_Cl2O2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_Cl2O2(2) = &
          p1(b2_Cl2O2(i2(j,k)), a2_Cl2O2(i2(j,k)), &
          v3_du1(j,k))
        sig_Cl2O2(3) = &
          p1(b3_Cl2O2(i3(j,k)), a3_Cl2O2(i3(j,k)), &
          v3_du2(j,k))
        sig_Cl2O2(4) = &
          p1(a4_Cl2O2(1),a4_Cl2O2(2),v3_du2(j,k))
        sig_Cl2O2(5) = &
          p1(a5_Cl2O2(1),a5_Cl2O2(2),v3_du2(j,k))
        sig_Cl2O2(6) = &
          a6_Cl2O2(1)
        dj = 0. &
          + sig_Cl2O2(1) * fint(j,k,1) &
          + sig_Cl2O2(2) * fint(j,k,2) &
          + sig_Cl2O2(3) * fint(j,k,3) &
          + sig_Cl2O2(4) * fint(j,k,4) &
          + sig_Cl2O2(5) * fint(j,k,5) &
          + sig_Cl2O2(6) * fint(j,k,6)

        jval_gp(ip_Cl2O2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,2))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_Cl2O2

  ! --------------------------------------------------------------------------
! op_pj_20091013+
! NOTE: In case you use this rotine, remember to remove factor 1.4 in
!       #J6100 (gas.eqn) ...
! op_pj_20091013-
!!$  SUBROUTINE jval_cal_cl2o2_new(jrow)
!!$
!!$    ! Cl2O2 -> Cl + ClO2: Burkholder 90 (intervals 2 to 6) + JPL 97 (intervals 0, 1, scaled 7)
!!$  ! following recommendation of Chen et al, Science 324, 781, 2009
!!$
!!$    INTEGER, INTENT(IN) :: jrow
!!$
!!$    INTEGER :: k, j
!!$    REAL :: dj
!!$    REAL, DIMENSION(0:MAXWAV) :: sig_cl2o2 ! effective cross section
!!$  ! interval 0
!!$    REAL, PARAMETER :: a0_1_1_Cl2o2(dim58) = (/ &
!!$ -1.9200E-20, -2.1037E-20, -2.2990E-20, -2.5014E-20, -2.7278E-20, -2.9458E-20, &
!!$ -3.1654E-20, -3.4253E-20, -3.6690E-20, -3.9286E-20, -4.1951E-20, -4.4832E-20, &
!!$ -4.9705E-20, -5.8637E-20, -5.9618E-20, -6.2536E-20, -6.7550E-20, -6.8497E-20, &
!!$ -7.1285E-20, -7.6026E-20, -7.6720E-20, -7.9321E-20, -8.3605E-20, -8.4292E-20, &
!!$ -8.6642E-20, -8.6004E-20, -8.7018E-20, -8.9722E-20, -9.2204E-20, -9.4422E-20, &
!!$ -9.6279E-20, -9.7702E-20, -9.8671E-20, -9.9178E-20, -9.9356E-20, -9.9336E-20, &
!!$ -9.9252E-20, -9.9168E-20, -9.9351E-20, -9.9745E-20, -1.0018E-19, -1.0065E-19, &
!!$ -1.0083E-19, -1.0029E-19, -9.8830E-20, -9.6131E-20, -9.2252E-20, -8.7236E-20, &
!!$ -8.1612E-20, -7.5615E-20, -6.9733E-20, -6.3775E-20, -5.8036E-20, -5.2207E-20, &
!!$ -4.6231E-20, -4.0144E-20, -3.3486E-20, -2.7616E-20 /)
!!$    REAL, PARAMETER :: a0_1_2_Cl2o2(dim58) = (/ &
!!$  5.5411E-18,  5.6223E-18,  5.7090E-18,  5.7993E-18,  5.9007E-18,  5.9988E-18, &
!!$  6.0981E-18,  6.2161E-18,  6.3272E-18,  6.4461E-18,  6.5687E-18,  6.7018E-18, &
!!$  6.9279E-18,  7.3441E-18,  7.3900E-18,  7.5272E-18,  7.7639E-18,  7.8087E-18, &
!!$  7.9415E-18,  8.1681E-18,  8.2014E-18,  8.3267E-18,  8.5341E-18,  8.5675E-18, &
!!$  8.6822E-18,  8.6509E-18,  8.7008E-18,  8.8344E-18,  8.9575E-18,  9.0679E-18, &
!!$  9.1608E-18,  9.2322E-18,  9.2811E-18,  9.3067E-18,  9.3157E-18,  9.3147E-18, &
!!$  9.3104E-18,  9.3061E-18,  9.3155E-18,  9.3359E-18,  9.3588E-18,  9.3831E-18, &
!!$  9.3924E-18,  9.3640E-18,  9.2871E-18,  9.1440E-18,  8.9376E-18,  8.6698E-18, &
!!$  8.3684E-18,  8.0457E-18,  7.7281E-18,  7.4051E-18,  7.0929E-18,  6.7747E-18, &
!!$  6.4472E-18,  6.1124E-18,  5.7449E-18,  5.4197E-18 /)
!!$    REAL, PARAMETER :: a0_2_1_Cl2o2(dim58) = (/ &
!!$  6.5625E-23,  7.1130E-23,  7.6552E-23,  8.2917E-23,  8.9768E-23,  9.5660E-23, &
!!$  1.0135E-22,  1.0970E-22,  1.1539E-22,  1.2250E-22,  1.2903E-22,  1.3648E-22, &
!!$  1.7303E-22,  2.6528E-22,  2.3820E-22,  2.3996E-22,  2.6728E-22,  2.4264E-22, &
!!$  2.4274E-22,  2.6563E-22,  2.4212E-22,  2.4144E-22,  2.5913E-22,  2.3799E-22, &
!!$  2.3603E-22,  2.0364E-22,  1.9020E-22,  1.9338E-22,  1.9600E-22,  1.9803E-22, &
!!$  1.9928E-22,  1.9951E-22,  1.9894E-22,  1.9749E-22,  1.9480E-22,  1.9242E-22, &
!!$  1.8963E-22,  1.8646E-22,  1.8456E-22,  1.8263E-22,  1.8057E-22,  1.7828E-22, &
!!$  1.7533E-22,  1.7046E-22,  1.6319E-22,  1.5316E-22,  1.4138E-22,  1.2741E-22, &
!!$  1.1309E-22,  9.8881E-23,  8.6196E-23,  7.3927E-23,  6.3059E-23,  5.2770E-23, &
!!$  4.2795E-23,  3.4001E-23,  2.6147E-23,  2.0802E-23 /)
!!$    REAL, PARAMETER :: a0_2_2_Cl2o2(dim58) = (/ &
!!$ -4.7888E-21, -5.0322E-21, -5.2729E-21, -5.5568E-21, -5.8637E-21, -6.1289E-21, &
!!$ -6.3859E-21, -6.7653E-21, -7.0247E-21, -7.3504E-21, -7.6505E-21, -7.9949E-21, &
!!$ -9.6908E-21, -1.3989E-20, -1.2722E-20, -1.2805E-20, -1.4094E-20, -1.2926E-20, &
!!$ -1.2931E-20, -1.4025E-20, -1.2897E-20, -1.2864E-20, -1.3721E-20, -1.2693E-20, &
!!$ -1.2597E-20, -1.1010E-20, -1.0349E-20, -1.0506E-20, -1.0636E-20, -1.0737E-20, &
!!$ -1.0800E-20, -1.0811E-20, -1.0782E-20, -1.0709E-20, -1.0572E-20, -1.0451E-20, &
!!$ -1.0308E-20, -1.0145E-20, -1.0047E-20, -9.9473E-21, -9.8400E-21, -9.7204E-21, &
!!$ -9.5661E-21, -9.3100E-21, -8.9262E-21, -8.3941E-21, -7.7676E-21, -7.0214E-21, &
!!$ -6.2542E-21, -5.4897E-21, -4.8047E-21, -4.1397E-21, -3.5485E-21, -2.9867E-21, &
!!$ -2.4401E-21, -1.9564E-21, -1.5229E-21, -1.2268E-21 /)
!!$    ! interval 1
!!$    REAL, PARAMETER :: a1_1_cl2o2(dim55) = (/ &
!!$      -7.3676E-20, -6.4158E-20, -5.3585E-20, -4.3921E-20, -3.4766E-20, -2.7170E-20, &
!!$      -2.0710E-20, -1.5485E-20, -1.1366E-20, -8.0213E-21, -5.5036E-21, -3.4615E-21, &
!!$      -1.9788E-21, -6.4247E-22, 1.5551E-22, 1.0059E-21, 1.4875E-21, 1.9825E-21, &
!!$      2.2527E-21, 2.6161E-21, 2.7099E-21, 2.9590E-21, 2.9926E-21, 3.1382E-21, &
!!$      3.1248E-21, 3.2472E-21, 3.2050E-21, 3.2392E-21, 3.2183E-21, 3.2546E-21, &
!!$      3.1755E-21, 3.2176E-21, 3.1315E-21, 3.1607E-21, 3.0805E-21, 3.0755E-21, &
!!$      3.0105E-21, 3.0176E-21, 2.9381E-21, 2.9336E-21, 2.7960E-21, 2.6145E-21, &
!!$      2.4352E-21, 2.2732E-21, 2.1167E-21, 1.9817E-21, 1.8499E-21, 1.7413E-21, &
!!$      1.6090E-21, 1.5117E-21, 1.4240E-21, 1.3366E-21, 1.2617E-21, 1.1889E-21, &
!!$      1.1264E-21 /)
!!$    REAL, PARAMETER :: b1_1_cl2o2(dim55) = (/ &
!!$      3.4148E-18, 3.3863E-18, 3.3281E-18, 3.2508E-18, 3.1547E-18, 3.0559E-18, &
!!$      2.9558E-18, 2.8617E-18, 2.7773E-18, 2.7004E-18, 2.6362E-18, 2.5790E-18, &
!!$      2.5338E-18, 2.4897E-18, 2.4614E-18, 2.4290E-18, 2.4095E-18, 2.3883E-18, &
!!$      2.3760E-18, 2.3585E-18, 2.3538E-18, 2.3406E-18, 2.3387E-18, 2.3303E-18, &
!!$      2.3311E-18, 2.3234E-18, 2.3261E-18, 2.3238E-18, 2.3253E-18, 2.3226E-18, &
!!$      2.3286E-18, 2.3253E-18, 2.3323E-18, 2.3298E-18, 2.3367E-18, 2.3371E-18, &
!!$      2.3430E-18, 2.3423E-18, 2.3499E-18, 2.3504E-18, 2.3642E-18, 2.3847E-18, &
!!$      2.4072E-18, 2.4296E-18, 2.4531E-18, 2.4751E-18, 2.4983E-18, 2.5187E-18, &
!!$      2.5452E-18, 2.5659E-18, 2.5857E-18, 2.6065E-18, 2.6253E-18, 2.6444E-18, &
!!$      2.6616E-18 /)
!!$    REAL, PARAMETER :: a1_2_cl2o2(dim55) = (/ &
!!$      -1.9913E-22, -2.3642E-22, -2.7474E-22, -2.6136E-22, -2.5340E-22, -2.1901E-22, &
!!$      -1.8923E-22, -1.5732E-22, -1.2728E-22, -1.0503E-22, -8.1621E-23, -6.7287E-23, &
!!$      -5.0400E-23, -4.3986E-23, -3.0892E-23, -2.8070E-23, -1.9259E-23, -1.7639E-23, &
!!$      -1.1278E-23, -1.1829E-23, -6.0977E-24, -7.4663E-24, -3.2290E-24, -4.3506E-24, &
!!$      -8.6234E-25, -2.3785E-24, 3.1157E-25, -5.7083E-25, 1.0210E-24, 1.0524E-25, &
!!$      2.0379E-24, 6.5447E-25, 2.6438E-24, 1.1194E-24, 2.7549E-24, 1.7541E-24, &
!!$      2.9461E-24, 1.8035E-24, 2.9124E-24, 2.1765E-24, 2.7855E-24, 2.6329E-24, &
!!$      2.6965E-24, 2.5272E-24, 2.5414E-24, 2.3570E-24, 2.3656E-24, 2.1441E-24, &
!!$      2.4209E-24, 2.2875E-24, 2.1459E-24, 2.0518E-24, 1.9378E-24, 1.8275E-24, &
!!$      1.6841E-24 /)
!!$    REAL, PARAMETER :: b1_2_cl2o2(dim55) = (/ &
!!$      5.2781E-21, 5.3900E-21, 5.6008E-21, 5.4938E-21, 5.4101E-21, 4.9631E-21, &
!!$      4.5015E-21, 3.9271E-21, 3.3113E-21, 2.7995E-21, 2.2026E-21, 1.8013E-21, &
!!$      1.2862E-21, 1.0745E-21, 6.0970E-22, 5.0246E-22, 1.4561E-22, 7.5971E-23, &
!!$      -2.1348E-22, -1.8704E-22, -4.7645E-22, -4.0392E-22, -6.3909E-22, -5.7404E-22, &
!!$      -7.8508E-22, -6.8956E-22, -8.6576E-22, -8.0575E-22, -9.1798E-22, -8.5113E-22, &
!!$      -9.9704E-22, -8.8914E-22, -1.0493E-21, -9.2275E-22, -1.0626E-21, -9.7451E-22, &
!!$      -1.0824E-21, -9.7613E-22, -1.0820E-21, -1.0099E-21, -1.0711E-21, -1.0539E-21, &
!!$      -1.0619E-21, -1.0385E-21, -1.0406E-21, -1.0106E-21, -1.0121E-21, -9.7045E-22, &
!!$      -1.0259E-21, -9.9752E-22, -9.6558E-22, -9.4319E-22, -9.1463E-22, -8.8562E-22, &
!!$      -8.4614E-22 /)
!!$
!!$    ! interval 2
!!$    REAL, PARAMETER :: a2_cl2o2(dim55) = (/ &
!!$ -1.0448E-19, -9.1240E-20, -7.4800E-20, -5.8280E-20, -4.3960E-20, -3.2520E-20, &
!!$ -2.3880E-20, -1.7680E-20, -1.3200E-20, -1.0040E-20, -7.8000E-21, -6.2000E-21, &
!!$ -5.0400E-21, -4.1601E-21, -3.5200E-21, -3.0400E-21, -2.6000E-21, -2.3200E-21, &
!!$ -2.0400E-21, -1.8401E-21, -1.6400E-21, -1.5200E-21, -1.3600E-21, -1.2400E-21, &
!!$ -1.1600E-21, -1.0400E-21, -1.0000E-21, -9.1999E-22, -8.4000E-22, -7.6001E-22, &
!!$ -7.1998E-22, -6.8003E-22, -6.3999E-22, -5.6000E-22, -5.6000E-22, -5.2001E-22, &
!!$ -4.7997E-22, -4.4002E-22, -3.9998E-22, -4.0002E-22, -3.1999E-22, -2.3200E-22, &
!!$ -1.6800E-22, -1.2000E-22, -8.8004E-23, -6.3999E-23, -4.0002E-23, -3.1995E-23, &
!!$ -2.4005E-23, -2.3997E-23, -7.9988E-24, -7.9988E-24, -8.0071E-24, -7.9988E-24, &
!!$ -0.0000E+00 /)
!!$    REAL, PARAMETER :: b2_cl2o2(dim55) = (/ &
!!$  3.0704E-18,  3.0307E-18,  2.9403E-18,  2.8081E-18,  2.6578E-18,  2.5091E-18, &
!!$  2.3751E-18,  2.2635E-18,  2.1717E-18,  2.0990E-18,  2.0419E-18,  1.9971E-18, &
!!$  1.9617E-18,  1.9327E-18,  1.9100E-18,  1.8917E-18,  1.8739E-18,  1.8619E-18, &
!!$  1.8491E-18,  1.8395E-18,  1.8294E-18,  1.8231E-18,  1.8142E-18,  1.8072E-18, &
!!$  1.8024E-18,  1.7948E-18,  1.7922E-18,  1.7868E-18,  1.7811E-18,  1.7753E-18, &
!!$  1.7723E-18,  1.7691E-18,  1.7659E-18,  1.7593E-18,  1.7593E-18,  1.7558E-18, &
!!$  1.7521E-18,  1.7484E-18,  1.7446E-18,  1.7446E-18,  1.7366E-18,  1.7266E-18, &
!!$  1.7186E-18,  1.7120E-18,  1.7071E-18,  1.7032E-18,  1.6990E-18,  1.6975E-18, &
!!$  1.6959E-18,  1.6959E-18,  1.6923E-18,  1.6923E-18,  1.6923E-18,  1.6923E-18, &
!!$  1.6901E-18 /)
!!$
!!$    ! interval 3
!!$    REAL, PARAMETER :: a3_cl2o2(dim55) = (/ &
!!$ -1.9435E-21, -1.2214E-21, -7.1436E-22, -4.4737E-22, -3.0743E-22, -2.2660E-22, &
!!$ -1.7508E-22, -1.4019E-22, -1.1484E-22, -9.6184E-23, -8.1992E-23, -7.0683E-23, &
!!$ -6.1783E-23, -5.4434E-23, -4.8434E-23, -4.3136E-23, -3.9021E-23, -3.5073E-23, &
!!$ -3.2192E-23, -2.9281E-23, -2.6667E-23, -2.4829E-23, -2.2774E-23, -2.1061E-23, &
!!$ -1.9658E-23, -1.8151E-23, -1.6952E-23, -1.5925E-23, -1.4701E-23, -1.3870E-23, &
!!$ -1.2842E-23, -1.2157E-23, -1.1282E-23, -1.0788E-23, -9.9317E-24, -9.4021E-24, &
!!$ -8.9039E-24, -8.2187E-24, -7.8770E-24, -7.3509E-24, -6.1964E-24, -4.5874E-24, &
!!$ -3.4223E-24, -2.5676E-24, -1.9172E-24, -1.4717E-24, -1.0954E-24, -8.2176E-25, &
!!$ -6.5022E-25, -4.7929E-25, -3.7663E-25, -2.7371E-25, -2.0549E-25, -1.7115E-25, &
!!$ -1.3677E-25 /)
!!$    REAL, PARAMETER :: b3_cl2o2(dim55) = (/ &
!!$    1.0781E-18,  1.0355E-18,  9.7602E-19,  9.2909E-19,  8.9631E-19,  8.7266E-19, &
!!$    8.5457E-19,  8.4029E-19,  8.2842E-19,  8.1861E-19,  8.1031E-19,  8.0303E-19, &
!!$    7.9679E-19,  7.9120E-19,  7.8629E-19,  7.8165E-19,  7.7780E-19,  7.7387E-19, &
!!$    7.7084E-19,  7.6761E-19,  7.6455E-19,  7.6230E-19,  7.5966E-19,  7.5735E-19, &
!!$    7.5538E-19,  7.5318E-19,  7.5136E-19,  7.4974E-19,  7.4774E-19,  7.4633E-19, &
!!$    7.4453E-19,  7.4329E-19,  7.4165E-19,  7.4070E-19,  7.3899E-19,  7.3791E-19, &
!!$    7.3686E-19,  7.3538E-19,  7.3462E-19,  7.3342E-19,  7.3072E-19,  7.2649E-19, &
!!$    7.2309E-19,  7.2034E-19,  7.1806E-19,  7.1637E-19,  7.1483E-19,  7.1363E-19, &
!!$    7.1283E-19,  7.1198E-19,  7.1144E-19,  7.1087E-19,  7.1047E-19,  7.1026E-19, &
!!$    7.1004E-19 /)
!!$
!!$    REAL, PARAMETER :: a4_cl2o2(2) = (/ 4.8920E-19, -1.1455E-23 /)
!!$    REAL, PARAMETER :: a5_cl2o2(2) = (/ 2.2897E-19, -5.7478E-24 /)
!!$    REAL, PARAMETER :: a6_cl2o2(2) = (/ 4.2841E-20, -1.5825E-25 /)
!!$    REAL, PARAMETER :: a7_cl2o2(2) = (/ 3.2973E-22,  2.2367E-26 /)
!!$
!!$    !-------------------------------------------------------------------------
!!$
!!$    jval_gp(ip_cl2o2)%ptr(:,:,jrow) = vinit
!!$    DO k = 1,klev
!!$      DO j = 1,kproma_day
!!$        sig_cl2o2(0) = p1(a0_1_1_Cl2o2(i0(j,k))*dlv2(j,k)+ &
!!$          a0_1_2_Cl2o2(i0(j,k)), &
!!$          a0_2_1_Cl2o2(i0(j,k))*dlv2(j,k)+ &
!!$          a0_2_2_Cl2o2(i0(j,k)),v3_du1(j,k))
!!$        sig_cl2o2(1) = p1(b1_1_cl2o2(i1(j,k)),a1_1_cl2o2(i1(j,k)), &
!!$          v3_du1(j,k)) + &
!!$          p1(b1_2_cl2o2(i1(j,k)),a1_2_cl2o2(i1(j,k)), &
!!$          v3_du1(j,k)) *v2s_m(j,k)
!!$        sig_cl2o2(2) = p1(b2_cl2o2(i2(j,k)), a2_cl2o2(i2(j,k)), &
!!$          v3_du1(j,k))
!!$        sig_cl2o2(3) = p1(b3_cl2o2(i3(j,k)), a3_cl2o2(i3(j,k)), &
!!$          v3_du2(j,k))
!!$        sig_cl2o2(4) = p1(a4_cl2o2(1),a4_cl2o2(2),v3_du2(j,k))
!!$        sig_cl2o2(5) = p1(a5_cl2o2(1),a5_cl2o2(2),v3_du2(j,k))
!!$        sig_cl2o2(6) = p1(a6_cl2o2(1),a6_cl2o2(2),v3_du2(j,k))
!!$        sig_cl2o2(7) = p1(a7_cl2o2(1),a7_cl2o2(2),v3_du2(j,k))
!!$        dj = &
!!$          sig_cl2o2(0) * fint(j,k,0) + &
!!$          sig_cl2o2(1) * fint(j,k,1) + &
!!$          sig_cl2o2(2) * fint(j,k,2) + &
!!$          sig_cl2o2(3) * fint(j,k,3) + &
!!$          sig_cl2o2(4) * fint(j,k,4) + &
!!$          sig_cl2o2(5) * fint(j,k,5) + &
!!$          sig_cl2o2(6) * fint(j,k,6) + &
!!$          sig_cl2o2(7) * fint(j,k,7)
!!$        jval_gp(ip_cl2o2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,2))
!!$      ENDDO
!!$    ENDDO
!!$
!!$  END SUBROUTINE jval_cal_cl2o2_new

  ! **************************************************************************

  SUBROUTINE jval_cal_ClNO3(jrow)

    ! ClNO3 -> Cl + NO3 JPL 1997, quantum yields for 2 pathways JPL 2006

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_ClNO3

    ! (the same values a* b*, and c* are used for ClNO3 and ClONO2)
    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_ClNO3(dim58) = (/ &
      -1.4964E-21, -1.7393E-21, -1.8528E-21, -2.1237E-21, -2.2925E-21, -2.4287E-21, &
      -2.6449E-21, -2.9315E-21, -3.0666E-21, -3.5105E-21, -3.6068E-21, -3.9809E-21, &
      -4.4437E-21, -5.1606E-21, -5.3209E-21, -5.7159E-21, -6.2137E-21, -6.5006E-21, &
      -6.8051E-21, -7.3329E-21, -7.5549E-21, -7.8802E-21, -8.4548E-21, -8.6120E-21, &
      -9.0183E-21, -9.1815E-21, -9.4636E-21, -9.8815E-21, -1.0309E-20, -1.0735E-20, &
      -1.1151E-20, -1.1464E-20, -1.1746E-20, -1.2148E-20, -1.2357E-20, -1.2571E-20, &
      -1.2890E-20, -1.3100E-20, -1.3388E-20, -1.3762E-20, -1.4153E-20, -1.4515E-20, &
      -1.4952E-20, -1.5267E-20, -1.5545E-20, -1.5633E-20, -1.5545E-20, -1.5314E-20, &
      -1.4775E-20, -1.4228E-20, -1.3558E-20, -1.2829E-20, -1.1962E-20, -1.1069E-20, &
      -1.0064E-20, -8.8386E-21, -7.4899E-21, -6.1485E-21 /)
    REAL, PARAMETER :: a0_1_2_ClNO3(dim58) = (/ &
      2.9967E-18, 3.0075E-18, 3.0125E-18, 3.0246E-18, 3.0321E-18, 3.0383E-18, &
      3.0480E-18, 3.0611E-18, 3.0672E-18, 3.0875E-18, 3.0920E-18, 3.1093E-18, &
      3.1307E-18, 3.1641E-18, 3.1716E-18, 3.1902E-18, 3.2137E-18, 3.2273E-18, &
      3.2418E-18, 3.2670E-18, 3.2777E-18, 3.2934E-18, 3.3212E-18, 3.3288E-18, &
      3.3486E-18, 3.3566E-18, 3.3705E-18, 3.3912E-18, 3.4124E-18, 3.4336E-18, &
      3.4544E-18, 3.4701E-18, 3.4843E-18, 3.5046E-18, 3.5153E-18, 3.5262E-18, &
      3.5425E-18, 3.5533E-18, 3.5682E-18, 3.5875E-18, 3.6079E-18, 3.6268E-18, &
      3.6497E-18, 3.6662E-18, 3.6809E-18, 3.6856E-18, 3.6809E-18, 3.6686E-18, &
      3.6397E-18, 3.6102E-18, 3.5741E-18, 3.5345E-18, 3.4874E-18, 3.4386E-18, &
      3.3836E-18, 3.3162E-18, 3.2417E-18, 3.1674E-18 /)
    REAL, PARAMETER :: a0_2_1_ClNO3(dim58) = (/ &
      4.3277E-24, 5.2619E-24, 5.7210E-24, 6.4090E-24, 6.9793E-24, 7.2265E-24, &
      6.9824E-24, 8.3681E-24, 7.9749E-24, 9.7330E-24, 9.1414E-24, 1.0514E-23, &
      1.3106E-23, 1.9560E-23, 1.7431E-23, 1.8112E-23, 2.0312E-23, 1.9262E-23, &
      1.8499E-23, 2.0846E-23, 1.9234E-23, 1.9342E-23, 2.0975E-23, 1.9485E-23, &
      1.9319E-23, 1.7385E-23, 1.6087E-23, 1.6723E-23, 1.6995E-23, 1.8050E-23, &
      1.7959E-23, 1.8236E-23, 1.8279E-23, 1.9077E-23, 1.8897E-23, 1.8942E-23, &
      1.9472E-23, 1.9103E-23, 1.9412E-23, 1.9824E-23, 2.0185E-23, 2.0205E-23, &
      2.0596E-23, 2.0572E-23, 2.0387E-23, 2.0024E-23, 1.9510E-23, 1.8428E-23, &
      1.6844E-23, 1.5780E-23, 1.4380E-23, 1.3081E-23, 1.1508E-23, 1.0146E-23, &
      8.9510E-24, 7.0335E-24, 5.6473E-24, 4.3765E-24 /)
    REAL, PARAMETER :: a0_2_2_ClNO3(dim58) = (/ &
      -3.8181E-22, -4.2310E-22, -4.4349E-22, -4.7417E-22, -4.9972E-22, -5.1085E-22, &
      -4.9981E-22, -5.6272E-22, -5.4479E-22, -6.2532E-22, -5.9810E-22, -6.6151E-22, &
      -7.8179E-22, -1.0825E-21, -9.8290E-22, -1.0149E-21, -1.1188E-21, -1.0690E-21, &
      -1.0326E-21, -1.1448E-21, -1.0675E-21, -1.0727E-21, -1.1517E-21, -1.0793E-21, &
      -1.0712E-21, -9.7646E-22, -9.1258E-22, -9.4397E-22, -9.5748E-22, -1.0100E-21, &
      -1.0055E-21, -1.0194E-21, -1.0215E-21, -1.0619E-21, -1.0528E-21, -1.0550E-21, &
      -1.0822E-21, -1.0633E-21, -1.0792E-21, -1.1005E-21, -1.1193E-21, -1.1203E-21, &
      -1.1408E-21, -1.1396E-21, -1.1298E-21, -1.1106E-21, -1.0832E-21, -1.0254E-21, &
      -9.4052E-22, -8.8330E-22, -8.0769E-22, -7.3728E-22, -6.5171E-22, -5.7737E-22, &
      -5.1187E-22, -4.0640E-22, -3.2989E-22, -2.5948E-22 /)
    REAL, PARAMETER :: a1_1_ClNO3(dim55) = (/ &
      5.2365E-20, 4.7024E-20, 4.0797E-20, 3.4897E-20, 2.8326E-20, 2.3624E-20, &
      1.8143E-20, 1.5047E-20, 1.0949E-20, 9.1648E-21, 6.2142E-21, 5.3427E-21, &
      3.2129E-21, 2.8530E-21, 1.3188E-21, 1.2533E-21, 1.1035E-22, 2.0117E-22, &
      -6.9971E-22, -5.0210E-22, -1.1916E-21, -9.6309E-22, -1.5270E-21, -1.2795E-21, &
      -1.7268E-21, -1.4903E-21, -1.8428E-21, -1.6475E-21, -1.9144E-21, -1.7208E-21, &
      -1.9621E-21, -1.7537E-21, -1.9545E-21, -1.7993E-21, -1.9444E-21, -1.7961E-21, &
      -1.9134E-21, -1.7774E-21, -1.8949E-21, -1.7568E-21, -1.7655E-21, -1.6516E-21, &
      -1.5497E-21, -1.4450E-21, -1.3435E-21, -1.2553E-21, -1.1630E-21, -1.0950E-21, &
      -9.8153E-22, -9.0507E-22, -8.3989E-22, -7.7623E-22, -7.1930E-22, -6.6853E-22, &
      -6.2196E-22 /)
    REAL, PARAMETER :: b1_1_ClNO3(dim55) = (/ &
      2.4490E-18, 2.4650E-18, 2.4992E-18, 2.5464E-18, 2.6154E-18, 2.6766E-18, &
      2.7615E-18, 2.8172E-18, 2.9013E-18, 2.9423E-18, 3.0175E-18, 3.0419E-18, &
      3.1069E-18, 3.1188E-18, 3.1732E-18, 3.1757E-18, 3.2220E-18, 3.2181E-18, &
      3.2591E-18, 3.2496E-18, 3.2844E-18, 3.2723E-18, 3.3036E-18, 3.2893E-18, &
      3.3163E-18, 3.3014E-18, 3.3245E-18, 3.3112E-18, 3.3300E-18, 3.3159E-18, &
      3.3341E-18, 3.3179E-18, 3.3340E-18, 3.3212E-18, 3.3336E-18, 3.3205E-18, &
      3.3311E-18, 3.3185E-18, 3.3297E-18, 3.3162E-18, 3.3170E-18, 3.3042E-18, &
      3.2914E-18, 3.2769E-18, 3.2617E-18, 3.2473E-18, 3.2311E-18, 3.2183E-18, &
      3.1956E-18, 3.1793E-18, 3.1646E-18, 3.1494E-18, 3.1352E-18, 3.1218E-18, &
      3.1090E-18 /)
    REAL, PARAMETER :: a1_2_ClNO3(dim55) = (/ &
      1.6922E-23, 5.9678E-23, 9.5014E-23, 1.0744E-22, 1.3115E-22, 1.1798E-22, &
      1.3062E-22, 1.0507E-22, 1.1192E-22, 8.4261E-23, 8.8989E-23, 6.3902E-23, &
      6.8200E-23, 4.7690E-23, 5.1517E-23, 3.5162E-23, 3.8979E-23, 2.6016E-23, &
      2.9860E-23, 1.9301E-23, 2.2853E-23, 1.4439E-23, 1.7623E-23, 1.0896E-23, &
      1.3577E-23, 8.2076E-24, 1.0501E-23, 6.2812E-24, 8.1960E-24, 4.6563E-24, &
      6.4152E-24, 3.3932E-24, 4.9049E-24, 2.5740E-24, 3.7295E-24, 1.8278E-24, &
      2.8011E-24, 1.2377E-24, 2.1314E-24, 7.4426E-25, 7.1886E-25, -9.7961E-26, &
      -4.6094E-25, -7.1817E-25, -8.6924E-25, -9.1268E-25, -9.9914E-25, -9.4380E-25, &
      -1.1736E-24, -1.1980E-24, -1.1933E-24, -1.1899E-24, -1.1679E-24, -1.1399E-24, &
      -1.1060E-24 /)
    REAL, PARAMETER :: b1_2_ClNO3(dim55) = (/ &
      -3.5235E-21, -3.6518E-21, -3.8461E-21, -3.9455E-21, -4.1945E-21, -4.0233E-21, &
      -4.2192E-21, -3.7593E-21, -3.8997E-21, -3.2636E-21, -3.3842E-21, -2.6818E-21, &
      -2.8128E-21, -2.1360E-21, -2.2719E-21, -1.6504E-21, -1.8049E-21, -1.2476E-21, &
      -1.4225E-21, -9.1563E-22, -1.0950E-21, -6.4906E-22, -8.2579E-22, -4.3561E-22, &
      -5.9780E-22, -2.5953E-22, -4.0975E-22, -1.2280E-22, -2.5780E-22, 5.9845E-25, &
      -1.3220E-22, 1.0352E-22, -1.8169E-23, 1.7530E-22, 7.6499E-23, 2.4385E-22, &
      1.5577E-22, 3.0116E-22, 2.1581E-22, 3.5175E-22, 3.5430E-22, 4.4661E-22, &
      4.9216E-22, 5.2766E-22, 5.5039E-22, 5.5747E-22, 5.7265E-22, 5.6224E-22, &
      6.0831E-22, 6.1353E-22, 6.1245E-22, 6.1166E-22, 6.0614E-22, 5.9877E-22, &
      5.8943E-22 /)
    REAL, PARAMETER :: a2_ClNO3(dim55) = (/ &
      -1.0424E-20, -9.0560E-21, -7.3640E-21, -5.6840E-21, -4.2240E-21, -3.0752E-21, &
      -2.2156E-21, -1.6000E-21, -1.1668E-21, -8.6560E-22, -6.5520E-22, -5.0760E-22, &
      -4.0200E-22, -3.2600E-22, -2.7000E-22, -2.2760E-22, -1.9520E-22, -1.6920E-22, &
      -1.4920E-22, -1.3240E-22, -1.1840E-22, -1.0680E-22, -9.6798E-23, -8.8400E-23, &
      -8.0800E-23, -7.4400E-23, -6.8002E-23, -6.3199E-23, -5.8399E-23, -5.4002E-23, &
      -5.0399E-23, -4.6400E-23, -4.3600E-23, -4.0400E-23, -3.7601E-23, -3.5199E-23, &
      -3.2800E-23, -3.0800E-23, -2.8401E-23, -2.6801E-23, -2.2080E-23, -1.5760E-23, &
      -1.1440E-23, -8.1601E-24, -6.0002E-24, -4.2398E-24, -3.1200E-24, -2.1600E-24, &
      -1.6001E-24, -1.1999E-24, -7.9978E-25, -6.4003E-25, -4.0015E-25, -3.2002E-25, &
      -2.3988E-25 /)
    REAL, PARAMETER :: b2_ClNO3(dim55) = (/ &
      1.9757E-19, 1.9347E-19, 1.8416E-19, 1.7072E-19, 1.5539E-19, 1.4046E-19, &
      1.2713E-19, 1.1605E-19, 1.0717E-19, 1.0024E-19, 9.4880E-20, 9.0747E-20, &
      8.7526E-20, 8.5018E-20, 8.3030E-20, 8.1419E-20, 8.0107E-20, 7.8989E-20, &
      7.8079E-20, 7.7272E-20, 7.6565E-20, 7.5951E-20, 7.5395E-20, 7.4908E-20, &
      7.4448E-20, 7.4045E-20, 7.3626E-20, 7.3300E-20, 7.2961E-20, 7.2640E-20, &
      7.2368E-20, 7.2056E-20, 7.1831E-20, 7.1565E-20, 7.1326E-20, 7.1115E-20, &
      7.0897E-20, 7.0711E-20, 7.0482E-20, 7.0325E-20, 6.9851E-20, 6.9137E-20, &
      6.8595E-20, 6.8142E-20, 6.7817E-20, 6.7530E-20, 6.7334E-20, 6.7153E-20, &
      6.7041E-20, 6.6956E-20, 6.6865E-20, 6.6827E-20, 6.6767E-20, 6.6746E-20, &
      6.6724E-20 /)
    REAL, PARAMETER :: a3_ClNO3(dim55) = (/ &
      -9.5255E-23, -7.9722E-23, -6.3144E-23, -4.8368E-23, -3.6581E-23, -2.7716E-23, &
      -2.1254E-23, -1.6613E-23, -1.3259E-23, -1.0903E-23, -9.0691E-24, -7.7476E-24, &
      -6.6693E-24, -5.8706E-24, -5.1938E-24, -4.6326E-24, -4.2332E-24, -3.8339E-24, &
      -3.4759E-24, -3.2747E-24, -2.9952E-24, -2.7955E-24, -2.5969E-24, -2.4760E-24, &
      -2.3163E-24, -2.1566E-24, -2.0775E-24, -1.9569E-24, -1.8370E-24, -1.7971E-24, &
      -1.6780E-24, -1.5974E-24, -1.5176E-24, -1.4377E-24, -1.3983E-24, -1.3578E-24, &
      -1.2780E-24, -1.2380E-24, -1.1586E-24, -1.1182E-24, -1.0064E-24, -8.3866E-25, &
      -7.0287E-25, -5.9904E-25, -5.1159E-25, -4.4728E-25, -3.8339E-25, -3.3545E-25, &
      -2.8754E-25, -2.5559E-25, -2.2365E-25, -1.9968E-25, -1.6786E-25, -1.5176E-25, &
      -1.3578E-25 /)
    REAL, PARAMETER :: b3_ClNO3(dim55) = (/ &
      3.2253E-20, 3.1856E-20, 3.1018E-20, 2.9900E-20, 2.8714E-20, 2.7600E-20, &
      2.6626E-20, 2.5810E-20, 2.5136E-20, 2.4604E-20, 2.4144E-20, 2.3780E-20, &
      2.3455E-20, 2.3195E-20, 2.2957E-20, 2.2746E-20, 2.2586E-20, 2.2416E-20, &
      2.2254E-20, 2.2158E-20, 2.2018E-20, 2.1913E-20, 2.1804E-20, 2.1734E-20, &
      2.1638E-20, 2.1538E-20, 2.1486E-20, 2.1405E-20, 2.1321E-20, 2.1292E-20, &
      2.1202E-20, 2.1140E-20, 2.1076E-20, 2.1010E-20, 2.0976E-20, 2.0941E-20, &
      2.0869E-20, 2.0832E-20, 2.0756E-20, 2.0716E-20, 2.0604E-20, 2.0415E-20, &
      2.0245E-20, 2.0102E-20, 1.9971E-20, 1.9866E-20, 1.9754E-20, 1.9664E-20, &
      1.9568E-20, 1.9500E-20, 1.9428E-20, 1.9371E-20, 1.9291E-20, 1.9249E-20, &
      1.9205E-20 /)
    REAL, PARAMETER :: a4_ClNO3(3) = (/ 1.3462E-20, -1.5949E-24, 2.8270E-28 /)
    REAL, PARAMETER :: a5_ClNO3(3) = (/ 4.9350E-21, -6.2621E-25, 8.8046E-29 /)
    REAL, PARAMETER :: a6_ClNO3(1) = (/ 9.9971E-22 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_ClNO3(dim58) = (/ &
      -7.5614E-04, -4.5783E-04, -9.4689E-04, -9.8414E-04, -6.8564E-04, -1.3215E-03, &
      -1.2880E-03, -1.1412E-03, -1.1796E-03, -2.1917E-03, -2.7985E-03, -2.8382E-03, &
      -3.4397E-03, -3.5192E-03, -3.6009E-03, -4.0583E-03, -4.0602E-03, -4.3299E-03, &
      -5.0119E-03, -5.3204E-03, -5.6690E-03, -5.4158E-03, -6.3635E-03, -6.2238E-03, &
      -6.5364E-03, -6.6975E-03, -6.5581E-03, -6.8013E-03, -6.7778E-03, -7.8844E-03, &
      -7.9385E-03, -8.4472E-03, -9.1070E-03, -9.7697E-03, -1.0626E-02, -1.1897E-02, &
      -1.2041E-02, -1.1871E-02, -1.2166E-02, -1.1549E-02, -1.1125E-02, -1.0686E-02, &
      -9.3035E-03, -8.5937E-03, -8.6383E-03, -7.9996E-03, -7.1333E-03, -6.8137E-03, &
      -5.7360E-03, -4.3062E-03, -1.9380E-03, 1.9304E-04, 2.3934E-03, 4.8932E-03, &
      8.9011E-03, 1.6857E-02, 3.3874E-02, 5.5800E-02 /)
    REAL, PARAMETER :: c0_1_2_ClNO3(dim58) = (/ &
      2.3617E-01, 2.2284E-01, 2.4480E-01, 2.4648E-01, 2.3295E-01, 2.6189E-01, &
      2.6035E-01, 2.5362E-01, 2.5539E-01, 3.0225E-01, 3.3046E-01, 3.3232E-01, &
      3.6053E-01, 3.6427E-01, 3.6814E-01, 3.8987E-01, 3.8995E-01, 4.0287E-01, &
      4.3568E-01, 4.5058E-01, 4.6749E-01, 4.5515E-01, 5.0150E-01, 4.9464E-01, &
      5.1005E-01, 5.1802E-01, 5.1110E-01, 5.2323E-01, 5.2205E-01, 5.7772E-01, &
      5.8045E-01, 6.0624E-01, 6.3982E-01, 6.7369E-01, 7.1761E-01, 7.8307E-01, &
      7.9053E-01, 7.8168E-01, 7.9707E-01, 7.6481E-01, 7.4255E-01, 7.1939E-01, &
      6.4627E-01, 6.0857E-01, 6.1095E-01, 5.7678E-01, 5.3026E-01, 5.1303E-01, &
      4.5473E-01, 3.7709E-01, 2.4802E-01, 1.3146E-01, 1.0659E-02, -1.2708E-01, &
      -3.4872E-01, -7.9029E-01, -1.7381E+00, -2.9638E+00 /)
    REAL, PARAMETER :: c2_ClNO3(3) = (/ 1.00,  0.67, 0.23 /)
    REAL, PARAMETER :: c3_ClNO3(3) = (/ 1.00,  0.90, 0.64 /)
    REAL, PARAMETER :: c4_ClNO3(3) = (/ 1.00,  1.06, 0.85 /)
    REAL, PARAMETER :: c5_ClNO3(3) = (/ 1.00,  1.12, 1.73 /)
    REAL, PARAMETER :: c6_ClNO3(3) = (/ 1.00,  0.67, 0.31 /)

    jval_gp(ip_ClNO3)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_ClNO3(0) = &
          p1(1.,c0_1_1_ClNO3(i0(j,k))*dlv2(j,k) + &
          c0_1_2_ClNO3(i0(j,k)),tnorm_sr(j,k)) * &
          p1(a0_1_1_ClNO3(i0(j,k))*dlv2(j,k) + &
          a0_1_2_ClNO3(i0(j,k)), &
          a0_2_1_ClNO3(i0(j,k))*dlv2(j,k) + &
          a0_2_2_ClNO3(i0(j,k)),v3_du1(j,k))
        sig_ClNO3(1) = &
          (p1(b1_1_ClNO3(i1(j,k)),a1_1_ClNO3(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_ClNO3(i1(j,k)),a1_2_ClNO3(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_ClNO3(2) = &
          p2(c2_ClNO3(1),c2_ClNO3(2),c2_ClNO3(3),tnorm(j,k))* &
          p1(b2_ClNO3(i2(j,k)), a2_ClNO3(i2(j,k)), &
          v3_du1(j,k))
        sig_ClNO3(3) = &
          p2(c3_ClNO3(1),c3_ClNO3(2),c3_ClNO3(3),tnorm(j,k))* &
          p1(b3_ClNO3(i3(j,k)), a3_ClNO3(i3(j,k)), &
          v3_du2(j,k))
        sig_ClNO3(4) = &
          p2(c4_ClNO3(1),c4_ClNO3(2),c4_ClNO3(3),tnorm(j,k))* &
          p2(a4_ClNO3(1),a4_ClNO3(2),a4_ClNO3(3),v3_du2(j,k))
        sig_ClNO3(5) = &
          p2(c5_ClNO3(1),c5_ClNO3(2),c5_ClNO3(3),tnorm(j,k))* &
          p2(a5_ClNO3(1),a5_ClNO3(2),a5_ClNO3(3),v3_du2(j,k))
        sig_ClNO3(6) = &
          p2(c6_ClNO3(1),c6_ClNO3(2),c6_ClNO3(3),tnorm(j,k))* &
          a6_ClNO3(1)
        dj = 0. &
          + sig_ClNO3(0) * fint(j,k,0) * 0.6  &
          + sig_ClNO3(1) * fint(j,k,1) * 0.6  &
          + sig_ClNO3(2) * fint(j,k,2) * 0.6  &
          + sig_ClNO3(3) * fint(j,k,3) * 0.6  &
          + sig_ClNO3(4) * fint(j,k,4) * 0.65 &
          + sig_ClNO3(5) * fint(j,k,5) * 0.75 &
          + sig_ClNO3(6) * fint(j,k,6)

        jval_gp(ip_ClNO3)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,2))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_ClNO3

  ! **************************************************************************

  SUBROUTINE jval_cal_ClNO2(jrow)

    ! ClNO2 -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_ClNO2

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_ClNO2(dim58) = (/ &
      1.3169E-19, 1.4158E-19, 1.5181E-19, 1.6167E-19, 1.7145E-19, 1.8050E-19, &
      1.8909E-19, 1.9710E-19, 2.0422E-19, 2.1076E-19, 2.1628E-19, 2.2130E-19, &
      2.2812E-19, 2.3933E-19, 2.3840E-19, 2.3867E-19, 2.4030E-19, 2.3360E-19, &
      2.2768E-19, 2.2136E-19, 2.0596E-19, 1.8994E-19, 1.7297E-19, 1.4635E-19, &
      1.1846E-19, 8.3006E-20, 4.6601E-20, 9.6406E-21, -3.0600E-20, -7.3142E-20, &
      -1.1779E-19, -1.6385E-19, -2.1110E-19, -2.5849E-19, -3.0602E-19, -3.5317E-19, &
      -4.0057E-19, -4.4790E-19, -4.9629E-19, -5.4588E-19, -5.9674E-19, -6.4801E-19, &
      -6.9820E-19, -7.4396E-19, -7.8136E-19, -8.0630E-19, -8.1381E-19, -8.0351E-19, &
      -7.7493E-19, -7.3135E-19, -6.7754E-19, -6.1738E-19, -5.5410E-19, -4.8999E-19, &
      -4.2595E-19, -3.6272E-19, -2.9767E-19, -2.4458E-19 /)
    REAL, PARAMETER :: a0_1_2_ClNO2(dim58) = (/ &
      1.4283E-18, 9.9128E-19, 5.3704E-19, 9.6941E-20, -3.4115E-19, -7.4844E-19, &
      -1.1364E-18, -1.5001E-18, -1.8247E-18, -2.1246E-18, -2.3782E-18, -2.6103E-18, &
      -2.9265E-18, -3.4491E-18, -3.4054E-18, -3.4180E-18, -3.4952E-18, -3.1777E-18, &
      -2.8956E-18, -2.5935E-18, -1.8542E-18, -1.0825E-18, -2.6088E-19, 1.0329E-18, &
      2.3937E-18, 4.1311E-18, 5.9222E-18, 7.7480E-18, 9.7439E-18, 1.1863E-17, &
      1.4095E-17, 1.6407E-17, 1.8789E-17, 2.1186E-17, 2.3601E-17, 2.6006E-17, &
      2.8432E-17, 3.0866E-17, 3.3362E-17, 3.5931E-17, 3.8576E-17, 4.1252E-17, &
      4.3882E-17, 4.6289E-17, 4.8264E-17, 4.9585E-17, 4.9985E-17, 4.9435E-17, &
      4.7903E-17, 4.5558E-17, 4.2653E-17, 3.9392E-17, 3.5950E-17, 3.2449E-17, &
      2.8940E-17, 2.5462E-17, 2.1872E-17, 1.8930E-17 /)
    REAL, PARAMETER :: a0_2_1_ClNO2(dim58) = (/ &
      -8.4967E-22, -9.1706E-22, -9.9412E-22, -1.0735E-21, -1.1552E-21, -1.2368E-21, &
      -1.3197E-21, -1.4065E-21, -1.4905E-21, -1.5782E-21, -1.6645E-21, -1.7542E-21, &
      -1.9576E-21, -2.3698E-21, -2.3321E-21, -2.3973E-21, -2.5588E-21, -2.4904E-21, &
      -2.5197E-21, -2.6106E-21, -2.4984E-21, -2.4583E-21, -2.4762E-21, -2.3111E-21, &
      -2.2057E-21, -1.9768E-21, -1.8120E-21, -1.6981E-21, -1.5676E-21, -1.4236E-21, &
      -1.2671E-21, -1.0981E-21, -9.1411E-22, -7.2599E-22, -5.3224E-22, -3.3588E-22, &
      -1.3818E-22, 5.3623E-23, 2.4646E-22, 4.3823E-22, 6.3103E-22, 8.1867E-22, &
      1.0040E-21, 1.1724E-21, 1.3150E-21, 1.4206E-21, 1.4730E-21, 1.4679E-21, &
      1.4064E-21, 1.2976E-21, 1.1551E-21, 9.9292E-22, 8.2684E-22, 6.6868E-22, &
      5.2048E-22, 3.9647E-22, 2.9109E-22, 2.2926E-22 /)
    REAL, PARAMETER :: a0_2_2_ClNO2(dim58) = (/ &
      4.5216E-20, 4.8195E-20, 5.1616E-20, 5.5158E-20, 5.8815E-20, 6.2487E-20, &
      6.6237E-20, 7.0179E-20, 7.4008E-20, 7.8023E-20, 8.1994E-20, 8.6137E-20, &
      9.5574E-20, 1.1478E-19, 1.1302E-19, 1.1608E-19, 1.2371E-19, 1.2046E-19, &
      1.2186E-19, 1.2621E-19, 1.2082E-19, 1.1889E-19, 1.1975E-19, 1.1173E-19, &
      1.0659E-19, 9.5369E-20, 8.7259E-20, 8.1635E-20, 7.5162E-20, 6.7988E-20, &
      6.0166E-20, 5.1680E-20, 4.2408E-20, 3.2889E-20, 2.3046E-20, 1.3032E-20, &
      2.9097E-21, -6.9488E-21, -1.6899E-20, -2.6833E-20, -3.6858E-20, -4.6653E-20, &
      -5.6366E-20, -6.5223E-20, -7.2750E-20, -7.8346E-20, -8.1135E-20, -8.0863E-20, &
      -7.7567E-20, -7.1714E-20, -6.4018E-20, -5.5229E-20, -4.6194E-20, -3.7559E-20, &
      -2.9437E-20, -2.2617E-20, -1.6800E-20, -1.3375E-20 /)
    REAL, PARAMETER :: a0_3_1_ClNO2(dim58) = (/ &
      1.5547E-24, 1.6709E-24, 1.8186E-24, 1.9834E-24, 2.1459E-24, 2.3155E-24, &
      2.4907E-24, 2.6836E-24, 2.8657E-24, 3.0636E-24, 3.2618E-24, 3.4704E-24, &
      4.3892E-24, 6.5421E-24, 5.9260E-24, 5.9695E-24, 6.5581E-24, 5.9491E-24, &
      5.9240E-24, 6.2605E-24, 5.6627E-24, 5.4947E-24, 5.6393E-24, 5.0373E-24, &
      4.7709E-24, 4.0377E-24, 3.6426E-24, 3.4953E-24, 3.3235E-24, 3.1277E-24, &
      2.9173E-24, 2.6820E-24, 2.4137E-24, 2.1422E-24, 1.8557E-24, 1.5638E-24, &
      1.2650E-24, 9.8426E-25, 7.0218E-25, 4.2347E-25, 1.4425E-25, -1.2114E-25, &
      -3.9424E-25, -6.4140E-25, -8.6143E-25, -1.0437E-24, -1.1625E-24, -1.2090E-24, &
      -1.1837E-24, -1.1008E-24, -9.6727E-25, -8.0129E-25, -6.3519E-25, -4.8281E-25, &
      -3.3848E-25, -2.3412E-25, -1.4857E-25, -1.1725E-25 /)
    REAL, PARAMETER :: a0_3_2_ClNO2(dim58) = (/ &
      -9.3581E-23, -9.8717E-23, -1.0528E-22, -1.1263E-22, -1.1991E-22, -1.2754E-22, &
      -1.3546E-22, -1.4421E-22, -1.5252E-22, -1.6158E-22, -1.7070E-22, -1.8034E-22, &
      -2.2297E-22, -3.2329E-22, -2.9446E-22, -2.9651E-22, -3.2429E-22, -2.9542E-22, &
      -2.9423E-22, -3.1031E-22, -2.8162E-22, -2.7352E-22, -2.8052E-22, -2.5126E-22, &
      -2.3826E-22, -2.0234E-22, -1.8289E-22, -1.7562E-22, -1.6710E-22, -1.5734E-22, &
      -1.4683E-22, -1.3501E-22, -1.2149E-22, -1.0776E-22, -9.3201E-23, -7.8314E-23, &
      -6.3015E-23, -4.8584E-23, -3.4029E-23, -1.9591E-23, -5.0719E-24, 8.7814E-24, &
      2.3092E-23, 3.6092E-23, 4.7710E-23, 5.7369E-23, 6.3689E-23, 6.6174E-23, &
      6.4817E-23, 6.0359E-23, 5.3147E-23, 4.4151E-23, 3.5115E-23, 2.6795E-23, &
      1.8886E-23, 1.3146E-23, 8.4236E-24, 6.6883E-24 /)
    REAL, PARAMETER :: a1_1_ClNO2(dim55) = (/ &
      4.4864E-20, 4.0191E-20, 3.4714E-20, 2.9552E-20, 2.3767E-20, 1.9747E-20, &
      1.4838E-20, 1.2225E-20, 8.5388E-21, 7.0787E-21, 4.3870E-21, 3.7104E-21, &
      1.7157E-21, 1.5069E-21, 1.5303E-23, 7.6597E-23, -1.0356E-21, -8.9187E-22, &
      -1.7560E-21, -1.5203E-21, -2.2020E-21, -1.9369E-21, -2.5089E-21, -2.2284E-21, &
      -2.6821E-21, -2.4153E-21, -2.8012E-21, -2.5177E-21, -2.8498E-21, -2.5926E-21, &
      -2.8621E-21, -2.6394E-21, -2.8640E-21, -2.6239E-21, -2.8343E-21, -2.6198E-21, &
      -2.7899E-21, -2.6058E-21, -2.7237E-21, -2.5770E-21, -2.5694E-21, -2.4080E-21, &
      -2.2673E-21, -2.1143E-21, -1.9699E-21, -1.8405E-21, -1.7018E-21, -1.5968E-21, &
      -1.4202E-21, -1.2960E-21, -1.1886E-21, -1.0838E-21, -9.9288E-22, -9.0709E-22, &
      -8.2558E-22 /)
    REAL, PARAMETER :: b1_1_ClNO2(dim55) = (/ &
      2.5910E-18, 2.6051E-18, 2.6352E-18, 2.6765E-18, 2.7372E-18, 2.7895E-18, &
      2.8656E-18, 2.9126E-18, 2.9882E-18, 3.0218E-18, 3.0904E-18, 3.1093E-18, &
      3.1702E-18, 3.1771E-18, 3.2300E-18, 3.2277E-18, 3.2727E-18, 3.2666E-18, &
      3.3059E-18, 3.2946E-18, 3.3290E-18, 3.3149E-18, 3.3467E-18, 3.3304E-18, &
      3.3579E-18, 3.3411E-18, 3.3663E-18, 3.3471E-18, 3.3705E-18, 3.3517E-18, &
      3.3720E-18, 3.3547E-18, 3.3727E-18, 3.3528E-18, 3.3708E-18, 3.3519E-18, &
      3.3673E-18, 3.3502E-18, 3.3615E-18, 3.3471E-18, 3.3463E-18, 3.3281E-18, &
      3.3104E-18, 3.2893E-18, 3.2676E-18, 3.2465E-18, 3.2221E-18, 3.2024E-18, &
      3.1670E-18, 3.1405E-18, 3.1163E-18, 3.0914E-18, 3.0686E-18, 3.0460E-18, &
      3.0236E-18 /)
    REAL, PARAMETER :: a1_2_ClNO2(dim55) = (/ &
      1.9492E-23, 5.5412E-23, 8.6652E-23, 9.6832E-23, 1.1846E-22, 1.0509E-22, &
      1.1822E-22, 9.3976E-23, 1.0177E-22, 7.5654E-23, 8.1497E-23, 5.7833E-23, &
      6.3404E-23, 4.3466E-23, 4.8745E-23, 3.2505E-23, 3.7216E-23, 2.4473E-23, &
      2.8908E-23, 1.8416E-23, 2.2458E-23, 1.3980E-23, 1.7648E-23, 1.0661E-23, &
      1.3867E-23, 8.1184E-24, 1.0996E-23, 6.1166E-24, 8.7049E-24, 4.6068E-24, &
      6.7797E-24, 3.5020E-24, 5.4316E-24, 2.4419E-24, 4.1490E-24, 1.7364E-24, &
      3.2311E-24, 1.1639E-24, 2.3242E-24, 7.2029E-25, 7.6025E-25, -2.1417E-25, &
      -6.5003E-25, -1.0120E-24, -1.2196E-24, -1.3017E-24, -1.4528E-24, -1.3946E-24, &
      -1.7799E-24, -1.8638E-24, -1.8920E-24, -1.9114E-24, -1.8928E-24, -1.8702E-24, &
      -1.8399E-24 /)
    REAL, PARAMETER :: b1_2_ClNO2(dim55) = (/ &
      -3.0160E-21, -3.1238E-21, -3.2956E-21, -3.3770E-21, -3.6041E-21, -3.4303E-21, &
      -3.6339E-21, -3.1974E-21, -3.3572E-21, -2.7566E-21, -2.9056E-21, -2.2430E-21, &
      -2.4129E-21, -1.7549E-21, -1.9423E-21, -1.3252E-21, -1.5160E-21, -9.6805E-22, &
      -1.1698E-21, -6.6624E-22, -8.7035E-22, -4.2101E-22, -6.2458E-22, -2.1935E-22, &
      -4.1332E-22, -5.1159E-23, -2.3963E-22, 9.2155E-23, -9.0324E-23, 2.0884E-22, &
      4.4787E-23, 3.0045E-22, 1.4512E-22, 3.9326E-22, 2.4730E-22, 4.5961E-22, &
      3.2434E-22, 5.1659E-22, 4.0579E-22, 5.6296E-22, 5.5895E-22, 6.6906E-22, &
      7.2376E-22, 7.7370E-22, 8.0496E-22, 8.1834E-22, 8.4485E-22, 8.3391E-22, &
      9.1118E-22, 9.2903E-22, 9.3540E-22, 9.4002E-22, 9.3535E-22, 9.2940E-22, &
      9.2105E-22 /)
    REAL, PARAMETER :: a2_ClNO2(dim55) = (/ &
      -1.6656E-20, -1.4268E-20, -1.1428E-20, -8.6720E-21, -6.3320E-21, -4.5080E-21, &
      -3.1680E-21, -2.2240E-21, -1.5760E-21, -1.1280E-21, -8.2400E-22, -6.1200E-22, &
      -4.7200E-22, -3.6800E-22, -2.9200E-22, -2.4000E-22, -2.0400E-22, -1.6800E-22, &
      -1.4800E-22, -1.2800E-22, -1.1200E-22, -1.0000E-22, -9.1998E-23, -7.9999E-23, &
      -7.6002E-23, -6.7999E-23, -6.0002E-23, -5.6000E-23, -5.1999E-23, -4.8002E-23, &
      -4.3996E-23, -4.4001E-23, -3.6003E-23, -3.5998E-23, -3.2002E-23, -3.1996E-23, &
      -2.8000E-23, -2.8000E-23, -2.4004E-23, -2.3999E-23, -1.9200E-23, -1.3600E-23, &
      -9.6005E-24, -7.1996E-24, -5.6000E-24, -3.2002E-24, -2.3999E-24, -2.3999E-24, &
      -1.6006E-24, -7.9926E-25, -8.0030E-25, -0.0000E+00, -8.0030E-25, -0.0000E+00, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b2_ClNO2(dim55) = (/ &
       3.7540E-19,  3.6823E-19,  3.5261E-19,  3.3057E-19,  3.0600E-19,  2.8228E-19, &
       2.6151E-19,  2.4452E-19,  2.3124E-19,  2.2093E-19,  2.1318E-19,  2.0725E-19, &
       2.0298E-19,  1.9954E-19,  1.9685E-19,  1.9487E-19,  1.9341E-19,  1.9186E-19, &
       1.9095E-19,  1.8999E-19,  1.8919E-19,  1.8855E-19,  1.8811E-19,  1.8741E-19, &
       1.8717E-19,  1.8666E-19,  1.8614E-19,  1.8587E-19,  1.8559E-19,  1.8529E-19, &
       1.8499E-19,  1.8499E-19,  1.8435E-19,  1.8435E-19,  1.8401E-19,  1.8401E-19, &
       1.8364E-19,  1.8364E-19,  1.8326E-19,  1.8326E-19,  1.8278E-19,  1.8215E-19, &
       1.8164E-19,  1.8131E-19,  1.8107E-19,  1.8068E-19,  1.8054E-19,  1.8054E-19, &
       1.8038E-19,  1.8021E-19,  1.8021E-19,  1.8002E-19,  1.8022E-19,  1.8001E-19, &
       1.8001E-19 /)
    REAL, PARAMETER :: a3_ClNO2(dim55) = (/ &
      -9.4656E-23, -8.2278E-23, -6.8296E-23, -5.5518E-23, -4.4729E-23, -3.5543E-23, &
      -2.9564E-23, -2.4361E-23, -2.0767E-23, -1.7572E-23, -1.5581E-23, -1.3179E-23, &
      -1.2380E-23, -1.0783E-23, -9.5884E-24, -8.7861E-24, -7.9871E-24, -7.5876E-24, &
      -6.7923E-24, -6.3896E-24, -5.5911E-24, -5.5911E-24, -5.1936E-24, -4.7926E-24, &
      -4.3931E-24, -3.9935E-24, -3.9951E-24, -3.9935E-24, -3.5940E-24, -3.1950E-24, &
      -3.1963E-24, -3.1945E-24, -2.7955E-24, -2.7955E-24, -2.3975E-24, -2.7955E-24, &
      -2.3960E-24, -1.9970E-24, -2.3970E-24, -1.9965E-24, -1.9170E-24, -1.5974E-24, &
      -1.2779E-24, -1.1981E-24, -9.5918E-25, -8.7861E-25, -7.1891E-25, -6.3891E-25, &
      -6.3901E-25, -4.7920E-25, -4.7931E-25, -3.9930E-25, -3.1976E-25, -3.1950E-25, &
      -3.1950E-25 /)
    REAL, PARAMETER :: b3_ClNO2(dim55) = (/ &
      1.5394E-19, 1.5362E-19, 1.5291E-19, 1.5195E-19, 1.5086E-19, 1.4971E-19, &
      1.4881E-19, 1.4789E-19, 1.4717E-19, 1.4645E-19, 1.4595E-19, 1.4529E-19, &
      1.4505E-19, 1.4453E-19, 1.4411E-19, 1.4380E-19, 1.4348E-19, 1.4331E-19, &
      1.4295E-19, 1.4276E-19, 1.4236E-19, 1.4236E-19, 1.4214E-19, 1.4191E-19, &
      1.4167E-19, 1.4142E-19, 1.4142E-19, 1.4142E-19, 1.4114E-19, 1.4085E-19, &
      1.4085E-19, 1.4085E-19, 1.4053E-19, 1.4053E-19, 1.4019E-19, 1.4054E-19, &
      1.4018E-19, 1.3981E-19, 1.4019E-19, 1.3980E-19, 1.3972E-19, 1.3936E-19, &
      1.3896E-19, 1.3885E-19, 1.3849E-19, 1.3836E-19, 1.3808E-19, 1.3793E-19, &
      1.3793E-19, 1.3759E-19, 1.3759E-19, 1.3740E-19, 1.3720E-19, 1.3720E-19, &
      1.3720E-19 /)
    REAL, PARAMETER :: a4_ClNO2(2) = (/ 1.2026E-19, -2.5947E-24 /)
    REAL, PARAMETER :: a5_ClNO2(2) = (/ 6.8705E-20, -3.6556E-24 /)
    REAL, PARAMETER :: a6_ClNO2(1) = (/ 5.2493E-21 /)

    jval_gp(ip_ClNO2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_ClNO2(0) = &
          p2(a0_1_1_ClNO2(i0(j,k))*dlv2(j,k) + &
          a0_1_2_ClNO2(i0(j,k)), &
          a0_2_1_ClNO2(i0(j,k))*dlv2(j,k) + &
          a0_2_2_ClNO2(i0(j,k)), &
          a0_3_1_ClNO2(i0(j,k))*dlv2(j,k) + &
          a0_3_2_ClNO2(i0(j,k)), v3_du1(j,k))
        sig_ClNO2(1) = &
          (p1(b1_1_ClNO2(i1(j,k)),a1_1_ClNO2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_ClNO2(i1(j,k)),a1_2_ClNO2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_ClNO2(2) = &
          p1(b2_ClNO2(i2(j,k)), a2_ClNO2(i2(j,k)), &
          v3_du1(j,k))
        sig_ClNO2(3) = &
          p1(b3_ClNO2(i3(j,k)), a3_ClNO2(i3(j,k)), &
          v3_du2(j,k))
        sig_ClNO2(4) = &
          p1(a4_ClNO2(1),a4_ClNO2(2),v3_du2(j,k))
        sig_ClNO2(5) = &
          p1(a5_ClNO2(1),a5_ClNO2(2),v3_du2(j,k))
        sig_ClNO2(6) = &
          a6_ClNO2(1)
        dj = 0. &
          + sig_ClNO2(0) * fint(j,k,0) &
          + sig_ClNO2(1) * fint(j,k,1) &
          + sig_ClNO2(2) * fint(j,k,2) &
          + sig_ClNO2(3) * fint(j,k,3) &
          + sig_ClNO2(4) * fint(j,k,4) &
          + sig_ClNO2(5) * fint(j,k,5) &
          + sig_ClNO2(6) * fint(j,k,6)

        jval_gp(ip_ClNO2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,2))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_ClNO2

  ! **************************************************************************

  SUBROUTINE jval_cal_Cl2(jrow)

    ! Cl2 -> 2 Cl JPL 2003

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_Cl2

    ! T-const parameters:
    REAL, PARAMETER :: a1_1_Cl2(dim55) = (/ &
      -1.3077E-23, -1.0730E-23, -8.2563E-24, -6.3871E-24, -4.5063E-24, -3.3632E-24, &
      -2.1859E-24, -1.6133E-24, -9.6362E-25, -7.2063E-25, -3.8927E-25, -3.0321E-25, &
      -1.4245E-25, -1.2033E-25, -4.4735E-26, -4.4486E-26, -9.6453E-27, -1.4752E-26, &
      1.0914E-27, -3.9021E-27, 3.2364E-27, -3.7111E-28, 2.8259E-27, 5.2472E-28, &
      1.9490E-27, 5.7870E-28, 1.2106E-27, 4.2872E-28, 7.0857E-28, 2.7548E-28, &
      3.9913E-28, 1.6443E-28, 2.1890E-28, 9.3738E-29, 1.1773E-28, 5.1825E-29, &
      6.2376E-29, 2.8031E-29, 3.2662E-29, 1.4911E-29, 8.4028E-30, 1.4260E-30, &
      2.8596E-31, 4.6246E-32, 8.8653E-33, 1.3967E-33, 2.6124E-34, 4.0495E-35, &
      7.7778E-36, 9.4692E-37, 1.1430E-37, 1.3939E-38, 0.0000E+00, -0.0000E+00, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b1_1_Cl2(dim55) = (/ &
      1.3870E-22, 1.3166E-22, 1.1805E-22, 1.0309E-22, 8.3346E-23, 6.8486E-23, &
      5.0238E-23, 3.9932E-23, 2.6613E-23, 2.1024E-23, 1.2574E-23, 1.0164E-23, &
      5.2612E-24, 4.5311E-24, 1.8476E-24, 1.8382E-24, 4.2715E-25, 6.4672E-25, &
      -7.4136E-26, 1.6555E-25, -1.9494E-25, -3.7441E-27, -1.8118E-25, -4.7710E-26, &
      -1.3388E-25, -4.7549E-26, -8.8937E-26, -3.5771E-26, -5.5501E-26, -2.3885E-26, &
      -3.3221E-26, -1.4914E-26, -1.9299E-26, -8.9106E-27, -1.0962E-26, -5.1622E-27, &
      -6.1171E-27, -2.9230E-27, -3.3653E-27, -1.6257E-27, -9.7163E-28, -1.8325E-28, &
      -4.0173E-29, -7.0922E-30, -1.4664E-30, -2.4901E-31, -4.9730E-32, -8.2300E-33, &
      -1.6701E-33, -2.1516E-34, -2.7403E-35, -3.5165E-36, -2.4663E-38, 0.0000E+00, &
      0.0000E+00 /)
    REAL, PARAMETER :: a1_2_Cl2(dim55) = (/ &
      -3.6362E-26, -3.9941E-26, -4.5792E-26, -4.0442E-26, -4.1000E-26, -3.1783E-26, &
      -2.9858E-26, -2.1225E-26, -1.9007E-26, -1.2732E-26, -1.1072E-26, -7.1161E-27, &
      -6.0801E-27, -3.7934E-27, -3.2092E-27, -1.9587E-27, -1.6486E-27, -9.8945E-28, &
      -8.3117E-28, -4.9217E-28, -4.1344E-28, -2.4214E-28, -2.0367E-28, -1.1818E-28, &
      -9.9618E-29, -5.7351E-29, -4.8464E-29, -2.7705E-29, -2.3483E-29, -1.3339E-29, &
      -1.1343E-29, -6.4070E-30, -5.4660E-30, -3.0710E-30, -2.6290E-30, -1.4698E-30, &
      -1.2626E-30, -7.0265E-31, -6.0565E-31, -3.3559E-31, -1.4646E-31, -2.1814E-32, &
      -3.6431E-33, -5.3836E-34, -9.0049E-35, -1.3243E-35, -2.2212E-36, -3.2563E-37, &
      -5.6587E-38, 0.0000E+00, 0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b1_2_Cl2(dim55) = (/ &
      9.0972E-25, 9.2046E-25, 9.5263E-25, 9.0983E-25, 9.1569E-25, 7.9588E-25, &
      7.6604E-25, 6.1063E-25, 5.6517E-25, 4.2085E-25, 3.7852E-25, 2.6775E-25, &
      2.3615E-25, 1.6069E-25, 1.3995E-25, 9.2436E-26, 7.9877E-26, 5.1532E-26, &
      4.4330E-26, 2.8059E-26, 2.4083E-26, 1.5004E-26, 1.2869E-26, 7.9104E-27, &
      6.7872E-27, 4.1244E-27, 3.5423E-27, 2.1306E-27, 1.8330E-27, 1.0925E-27, &
      9.4181E-28, 5.5678E-28, 4.8102E-28, 2.8224E-28, 2.4445E-28, 1.4244E-28, &
      1.2369E-28, 7.1613E-29, 6.2350E-29, 3.5884E-29, 1.6876E-29, 2.7913E-30, &
      5.1081E-31, 8.2347E-32, 1.4876E-32, 2.3568E-33, 4.2246E-34, 6.6093E-35, &
      1.2151E-35, 9.7600E-38, 1.1755E-38, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
      0.0000E+00 /)
    REAL, PARAMETER :: a2_Cl2(dim55) = (/ &
      1.6844E-21, 1.5964E-21, 1.4212E-21, 1.2064E-21, 9.9200E-22, 8.0280E-22, &
      6.4640E-22, 5.2320E-22, 4.2760E-22, 3.5400E-22, 2.9800E-22, 2.5440E-22, &
      2.2000E-22, 1.9320E-22, 1.7080E-22, 1.5280E-22, 1.3760E-22, 1.2480E-22, &
      1.1400E-22, 1.0480E-22, 9.5999E-23, 8.9201E-23, 8.1999E-23, 7.6400E-23, &
      7.1200E-23, 6.6000E-23, 6.1600E-23, 5.7600E-23, 5.3999E-23, 5.0000E-23, &
      4.7200E-23, 4.4000E-23, 4.1200E-23, 3.8800E-23, 3.6000E-23, 3.4000E-23, &
      3.1600E-23, 3.0001E-23, 2.8000E-23, 2.5999E-23, 2.1760E-23, 1.5680E-23, &
      1.1440E-23, 8.2403E-24, 5.9996E-24, 4.3205E-24, 3.1200E-24, 2.2396E-24, &
      1.6001E-24, 1.1203E-24, 8.7991E-25, 6.4003E-25, 3.9963E-25, 3.2002E-25, &
      2.4040E-25 /)
    REAL, PARAMETER :: b2_Cl2(dim55) = (/ &
       2.1962E-20,  2.2226E-20,  2.3189E-20,  2.4908E-20,  2.7159E-20,  2.9619E-20, &
       3.2043E-20,  3.4260E-20,  3.6220E-20,  3.7913E-20,  3.9341E-20,  4.0562E-20, &
       4.1611E-20,  4.2495E-20,  4.3291E-20,  4.3975E-20,  4.4590E-20,  4.5141E-20, &
       4.5632E-20,  4.6074E-20,  4.6518E-20,  4.6878E-20,  4.7278E-20,  4.7603E-20, &
       4.7917E-20,  4.8245E-20,  4.8533E-20,  4.8805E-20,  4.9059E-20,  4.9351E-20, &
       4.9562E-20,  4.9812E-20,  5.0037E-20,  5.0237E-20,  5.0476E-20,  5.0652E-20, &
       5.0869E-20,  5.1018E-20,  5.1209E-20,  5.1405E-20,  5.1831E-20,  5.2518E-20, &
       5.3050E-20,  5.3492E-20,  5.3829E-20,  5.4103E-20,  5.4313E-20,  5.4479E-20, &
       5.4607E-20,  5.4709E-20,  5.4764E-20,  5.4821E-20,  5.4881E-20,  5.4902E-20, &
       5.4924E-20 /)
    REAL, PARAMETER :: a3_Cl2(dim55) = (/ &
      2.2246E-22, 1.9491E-22, 1.6295E-22, 1.3220E-22, 1.0703E-22, 8.7061E-23, &
      7.1115E-23, 5.9904E-23, 5.0319E-23, 4.3930E-23, 3.7954E-23, 3.3546E-23, &
      2.9952E-23, 2.6757E-23, 2.4371E-23, 2.2364E-23, 1.9968E-23, 1.8770E-23, &
      1.6780E-23, 1.5974E-23, 1.4377E-23, 1.3978E-23, 1.2385E-23, 1.1981E-23, &
      1.1182E-23, 1.0384E-23, 9.9881E-24, 9.5846E-24, 8.7861E-24, 7.9871E-24, &
      7.9903E-24, 7.5881E-24, 7.1881E-24, 6.7896E-24, 6.3921E-24, 6.3896E-24, &
      5.9906E-24, 5.5911E-24, 5.1936E-24, 5.1921E-24, 4.6326E-24, 3.8338E-24, &
      3.1949E-24, 2.7156E-24, 2.3181E-24, 1.9968E-24, 1.7572E-24, 1.5175E-24, &
      1.3579E-24, 1.1980E-24, 1.0384E-24, 8.7851E-25, 7.9935E-25, 7.1891E-25, &
      5.5911E-25 /)
    REAL, PARAMETER :: b3_Cl2(dim55) = (/ &
      1.0983E-19, 1.1053E-19, 1.1215E-19, 1.1447E-19, 1.1701E-19, 1.1952E-19, &
      1.2192E-19, 1.2389E-19, 1.2582E-19, 1.2726E-19, 1.2876E-19, 1.2997E-19, &
      1.3106E-19, 1.3210E-19, 1.3294E-19, 1.3369E-19, 1.3465E-19, 1.3516E-19, &
      1.3606E-19, 1.3644E-19, 1.3724E-19, 1.3745E-19, 1.3833E-19, 1.3856E-19, &
      1.3905E-19, 1.3955E-19, 1.3980E-19, 1.4008E-19, 1.4064E-19, 1.4122E-19, &
      1.4121E-19, 1.4153E-19, 1.4185E-19, 1.4218E-19, 1.4252E-19, 1.4252E-19, &
      1.4288E-19, 1.4325E-19, 1.4363E-19, 1.4363E-19, 1.4419E-19, 1.4509E-19, &
      1.4589E-19, 1.4655E-19, 1.4715E-19, 1.4767E-19, 1.4809E-19, 1.4854E-19, &
      1.4886E-19, 1.4920E-19, 1.4956E-19, 1.4994E-19, 1.5014E-19, 1.5035E-19, &
      1.5079E-19 /)
    REAL, PARAMETER :: a4_Cl2(3) = (/ 1.8311E-19, 1.0272E-23, -1.8054E-27 /)
    REAL, PARAMETER :: a5_Cl2(2) = (/ 2.4599E-19, 1.9809E-24 /)
    REAL, PARAMETER :: a6_Cl2(1) = (/ 6.4250E-20 /)
    REAL, PARAMETER :: a7_Cl2(2) = (/ 6.1680E-22, 3.9054E-26 /)

    jval_gp(ip_Cl2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_Cl2(1) = &
          (p1(b1_1_Cl2(i1(j,k)),a1_1_Cl2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_Cl2(i1(j,k)),a1_2_Cl2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_Cl2(2) = &
          p1(b2_Cl2(i2(j,k)), a2_Cl2(i2(j,k)), &
          v3_du1(j,k))
        sig_Cl2(3) = &
          p1(b3_Cl2(i3(j,k)), a3_Cl2(i3(j,k)), &
          v3_du2(j,k))
        sig_Cl2(4) = &
          p2(a4_Cl2(1),a4_Cl2(2),a4_Cl2(3),v3_du2(j,k))
        sig_Cl2(5) = &
          p1(a5_Cl2(1),a5_Cl2(2),v3_du2(j,k))
        sig_Cl2(6) = &
          a6_Cl2(1)
        sig_Cl2(7) = &
          p1(a7_Cl2(1),a7_Cl2(2),v3_du2(j,k))
        dj = 0. &
          + sig_Cl2(1) * fint(j,k,1) &
          + sig_Cl2(2) * fint(j,k,2) &
          + sig_Cl2(3) * fint(j,k,3) &
          + sig_Cl2(4) * fint(j,k,4) &
          + sig_Cl2(5) * fint(j,k,5) &
          + sig_Cl2(6) * fint(j,k,6) &
          + sig_Cl2(7) * fint(j,k,7)

        jval_gp(ip_Cl2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_Cl2

  ! **************************************************************************

  SUBROUTINE jval_cal_BrO(jrow)

    ! BrO -> Br + O Wahner, pers. comm., 1990

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_BrO

    ! T-const parameters:
    REAL, PARAMETER :: a5_BrO(2) = (/ 5.8009E-18, 7.3423E-23 /)
    REAL, PARAMETER :: a6_BrO(1) = (/ 1.0424E-18 /)

    jval_gp(ip_BrO)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_BrO(5) = &
          p1(a5_BrO(1),a5_BrO(2),v3_du2(j,k))
        sig_BrO(6) = &
          a6_BrO(1)
        dj = 0. &
          + sig_BrO(5) * fint(j,k,5) &
          + sig_BrO(6) * fint(j,k,6)

        jval_gp(ip_BrO)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,4))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_BrO

  ! **************************************************************************

  SUBROUTINE jval_cal_HOBr(jrow)

    ! HOBr -> OH + Br JPL 2003, based on Ingham et al. 1998, JPC

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_HOBr

    ! T-const parameters:
    REAL, PARAMETER :: a2_HOBr(dim55) = (/ &
      6.1080E-21, 5.1400E-21, 4.0480E-21, 3.0160E-21, 2.1560E-21, 1.4960E-21, &
      1.0240E-21, 6.8800E-22, 4.6800E-22, 3.1600E-22, 2.1200E-22, 1.4400E-22, &
      9.9996E-23, 6.8005E-23, 4.7997E-23, 3.2002E-23, 1.9997E-23, 1.2004E-23, &
      8.0030E-24, 3.9911E-24, 4.0015E-24, -4.0015E-24, -0.0000E+00, -3.9911E-24, &
      -4.0015E-24, -4.0015E-24, -4.0015E-24, -4.0015E-24, -4.0015E-24, -7.9926E-24, &
      -4.0015E-24, -4.0015E-24, -4.0015E-24, -4.0015E-24, -4.0015E-24, -4.0015E-24, &
      -3.9911E-24, -4.0015E-24, -4.0015E-24, -4.0015E-24, -3.1991E-24, -1.6006E-24, &
      -2.4009E-24, -8.0030E-25, -7.9823E-25, -8.0030E-25, -8.0030E-25, -8.0030E-25, &
      -8.0030E-25, -8.0030E-25, -8.0030E-25, -8.0030E-25, -8.0030E-25, -8.0030E-25, &
      -8.0030E-25 /)
    REAL, PARAMETER :: b2_HOBr(dim55) = (/ &
       1.8050E-19,  1.8340E-19,  1.8941E-19,  1.9766E-19,  2.0669E-19,  2.1527E-19, &
       2.2259E-19,  2.2864E-19,  2.3315E-19,  2.3664E-19,  2.3929E-19,  2.4120E-19, &
       2.4254E-19,  2.4360E-19,  2.4431E-19,  2.4491E-19,  2.4540E-19,  2.4574E-19, &
       2.4593E-19,  2.4612E-19,  2.4612E-19,  2.4654E-19,  2.4632E-19,  2.4655E-19, &
       2.4655E-19,  2.4655E-19,  2.4655E-19,  2.4655E-19,  2.4655E-19,  2.4684E-19, &
       2.4654E-19,  2.4654E-19,  2.4654E-19,  2.4654E-19,  2.4654E-19,  2.4654E-19, &
       2.4654E-19,  2.4654E-19,  2.4654E-19,  2.4654E-19,  2.4646E-19,  2.4628E-19, &
       2.4638E-19,  2.4616E-19,  2.4616E-19,  2.4616E-19,  2.4602E-19,  2.4617E-19, &
       2.4601E-19,  2.4601E-19,  2.4619E-19,  2.4600E-19,  2.4600E-19,  2.4600E-19, &
       2.4600E-19 /)
    REAL, PARAMETER :: a3_HOBr(dim55) = (/ &
      -2.1088E-22, -1.8453E-22, -1.5377E-22, -1.2501E-22, -1.0064E-22, -8.1070E-23, &
      -6.6720E-23, -5.5511E-23, -4.7125E-23, -3.9936E-23, -3.5158E-23, -3.1150E-23, &
      -2.7157E-23, -2.4760E-23, -2.1974E-23, -1.9968E-23, -1.8370E-23, -1.6374E-23, &
      -1.5581E-23, -1.3978E-23, -1.3179E-23, -1.1981E-23, -1.1187E-23, -1.0783E-23, &
      -9.5846E-24, -9.5851E-24, -8.3899E-24, -8.3861E-24, -7.5881E-24, -7.5881E-24, &
      -6.7918E-24, -6.3896E-24, -6.3896E-24, -5.9906E-24, -5.5933E-24, -5.1916E-24, &
      -5.1921E-24, -4.7921E-24, -4.7945E-24, -4.3931E-24, -3.9935E-24, -3.1949E-24, &
      -2.7955E-24, -2.3162E-24, -1.9185E-24, -1.7572E-24, -1.4377E-24, -1.2779E-24, &
      -1.1182E-24, -1.0384E-24, -7.9871E-25, -7.9871E-25, -6.3952E-25, -6.3890E-25, &
      -4.7920E-25 /)
    REAL, PARAMETER :: b3_HOBr(dim55) = (/ &
      2.0178E-19, 2.0110E-19, 1.9955E-19, 1.9737E-19, 1.9492E-19, 1.9246E-19, &
      1.9030E-19, 1.8833E-19, 1.8664E-19, 1.8502E-19, 1.8382E-19, 1.8271E-19, &
      1.8151E-19, 1.8073E-19, 1.7975E-19, 1.7900E-19, 1.7836E-19, 1.7751E-19, &
      1.7715E-19, 1.7639E-19, 1.7599E-19, 1.7536E-19, 1.7492E-19, 1.7468E-19, &
      1.7396E-19, 1.7396E-19, 1.7319E-19, 1.7318E-19, 1.7262E-19, 1.7262E-19, &
      1.7202E-19, 1.7171E-19, 1.7171E-19, 1.7138E-19, 1.7104E-19, 1.7069E-19, &
      1.7069E-19, 1.7032E-19, 1.7032E-19, 1.6993E-19, 1.6953E-19, 1.6863E-19, &
      1.6813E-19, 1.6747E-19, 1.6687E-19, 1.6661E-19, 1.6605E-19, 1.6575E-19, &
      1.6543E-19, 1.6526E-19, 1.6472E-19, 1.6472E-19, 1.6432E-19, 1.6432E-19, &
      1.6388E-19 /)
    REAL, PARAMETER :: a4_HOBr(2) = (/ 1.3602E-19, -3.5996E-24 /)
    REAL, PARAMETER :: a5_HOBr(2) = (/ 1.0954E-19, -6.1416E-26 /)
    REAL, PARAMETER :: a6_HOBr(1) = (/ 5.5431E-20 /)
    REAL, PARAMETER :: a7_HOBr(2) = (/ 4.1974E-21, 2.3287E-25 /)

    jval_gp(ip_HOBr)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_HOBr(2) = &
          p1(b2_HOBr(i2(j,k)), a2_HOBr(i2(j,k)), &
          v3_du1(j,k))
        sig_HOBr(3) = &
          p1(b3_HOBr(i3(j,k)), a3_HOBr(i3(j,k)), &
          v3_du2(j,k))
        sig_HOBr(4) = &
          p1(a4_HOBr(1),a4_HOBr(2),v3_du2(j,k))
        sig_HOBr(5) = &
          p1(a5_HOBr(1),a5_HOBr(2),v3_du2(j,k))
        sig_HOBr(6) = &
          a6_HOBr(1)
        sig_HOBr(7) = &
          p1(a7_HOBr(1),a7_HOBr(2),v3_du2(j,k))
        dj = 0. &
          + sig_HOBr(2) * fint(j,k,2) &
          + sig_HOBr(3) * fint(j,k,3) &
          + sig_HOBr(4) * fint(j,k,4) &
          + sig_HOBr(5) * fint(j,k,5) &
          + sig_HOBr(6) * fint(j,k,6) &
          + sig_HOBr(7) * fint(j,k,7)

        jval_gp(ip_HOBr)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_HOBr

  ! **************************************************************************

  SUBROUTINE jval_cal_BrCl(jrow)

    ! BrCl -> Br + Cl JPL 2003

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_BrCl

    ! T-const parameters:
    REAL, PARAMETER :: a5_BrCl(3) = (/ 7.0688E-20, 9.9542E-24, -1.1430E-27 /)
    REAL, PARAMETER :: a6_BrCl(1) = (/ 2.8913E-19 /)
    REAL, PARAMETER :: a7_BrCl(2) = (/ 2.7530E-20, 1.4343E-24 /)

    jval_gp(ip_BrCl)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_BrCl(5) = &
          p2(a5_BrCl(1),a5_BrCl(2),a5_BrCl(3),v3_du2(j,k))
        sig_BrCl(6) = &
          a6_BrCl(1)
        sig_BrCl(7) = &
          p1(a7_BrCl(1),a7_BrCl(2),v3_du2(j,k))
        dj = 0. &
          + sig_BrCl(5) * fint(j,k,5) &
          + sig_BrCl(6) * fint(j,k,6) &
          + sig_BrCl(7) * fint(j,k,7)

        jval_gp(ip_BrCl)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_BrCl

  ! **************************************************************************

  SUBROUTINE jval_cal_BrNO3(jrow)

    ! BrNO3 -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_BrNO3

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_BrNO3(dim58) = (/ &
      -7.3837E-22, -7.5694E-22, -8.4367E-22, -9.1605E-22, -9.8235E-22, -1.0856E-21, &
      -1.1849E-21, -1.2615E-21, -1.3772E-21, -1.5076E-21, -1.6106E-21, -1.7371E-21, &
      -1.9235E-21, -2.2871E-21, -2.3430E-21, -2.5519E-21, -2.6964E-21, -2.9241E-21, &
      -2.9967E-21, -3.2198E-21, -3.4409E-21, -3.4883E-21, -3.9218E-21, -3.9266E-21, &
      -4.1405E-21, -4.2557E-21, -4.4769E-21, -4.6197E-21, -4.9380E-21, -5.0832E-21, &
      -5.3706E-21, -5.6060E-21, -5.7575E-21, -6.0026E-21, -6.1662E-21, -6.3576E-21, &
      -6.6426E-21, -6.8263E-21, -7.1567E-21, -7.3997E-21, -7.7960E-21, -8.0981E-21, &
      -8.6438E-21, -8.9275E-21, -9.2470E-21, -9.6102E-21, -9.7929E-21, -9.8536E-21, &
      -9.8355E-21, -9.7077E-21, -9.4552E-21, -9.1653E-21, -8.7679E-21, -8.3628E-21, &
      -7.8874E-21, -7.2938E-21, -6.3183E-21, -5.1503E-21 /)
    REAL, PARAMETER :: a0_1_2_BrNO3(dim58) = (/ &
      5.3006E-18, 5.3014E-18, 5.3052E-18, 5.3085E-18, 5.3114E-18, 5.3161E-18, &
      5.3206E-18, 5.3241E-18, 5.3293E-18, 5.3353E-18, 5.3400E-18, 5.3459E-18, &
      5.3545E-18, 5.3715E-18, 5.3741E-18, 5.3839E-18, 5.3907E-18, 5.4015E-18, &
      5.4050E-18, 5.4156E-18, 5.4263E-18, 5.4285E-18, 5.4495E-18, 5.4498E-18, &
      5.4602E-18, 5.4658E-18, 5.4767E-18, 5.4838E-18, 5.4996E-18, 5.5068E-18, &
      5.5212E-18, 5.5330E-18, 5.5406E-18, 5.5530E-18, 5.5613E-18, 5.5711E-18, &
      5.5857E-18, 5.5951E-18, 5.6122E-18, 5.6248E-18, 5.6454E-18, 5.6611E-18, &
      5.6897E-18, 5.7047E-18, 5.7215E-18, 5.7408E-18, 5.7505E-18, 5.7537E-18, &
      5.7528E-18, 5.7459E-18, 5.7323E-18, 5.7165E-18, 5.6949E-18, 5.6728E-18, &
      5.6468E-18, 5.6141E-18, 5.5603E-18, 5.4955E-18 /)
    REAL, PARAMETER :: a0_2_1_BrNO3(dim58) = (/ &
      2.7598E-24, 2.4165E-24, 2.4271E-24, 2.7118E-24, 2.6756E-24, 2.7337E-24, &
      3.4383E-24, 3.1538E-24, 3.3797E-24, 4.0115E-24, 4.0945E-24, 3.9128E-24, &
      5.5289E-24, 7.8306E-24, 6.9821E-24, 7.4123E-24, 7.9264E-24, 7.8349E-24, &
      7.2301E-24, 8.0662E-24, 7.8803E-24, 7.3704E-24, 8.8836E-24, 7.6089E-24, &
      7.7285E-24, 6.8460E-24, 6.6996E-24, 6.4240E-24, 7.1136E-24, 6.7986E-24, &
      7.3243E-24, 7.5115E-24, 7.2485E-24, 7.5739E-24, 7.5620E-24, 7.4829E-24, &
      7.8898E-24, 7.5709E-24, 8.2384E-24, 7.8976E-24, 8.1556E-24, 8.1070E-24, &
      8.9144E-24, 8.5821E-24, 8.4186E-24, 8.6313E-24, 8.3261E-24, 8.0758E-24, &
      7.6237E-24, 7.0989E-24, 6.7615E-24, 6.2005E-24, 5.6707E-24, 5.1691E-24, &
      4.5811E-24, 4.0919E-24, 3.1725E-24, 2.6672E-24 /)
    REAL, PARAMETER :: a0_2_2_BrNO3(dim58) = (/ &
      -2.1404E-22, -1.9886E-22, -1.9933E-22, -2.1203E-22, -2.1041E-22, -2.1302E-22, &
      -2.4487E-22, -2.3195E-22, -2.4226E-22, -2.7119E-22, -2.7501E-22, -2.6662E-22, &
      -3.4161E-22, -4.4886E-22, -4.0915E-22, -4.2937E-22, -4.5364E-22, -4.4930E-22, &
      -4.2051E-22, -4.6048E-22, -4.5155E-22, -4.2698E-22, -5.0022E-22, -4.3827E-22, &
      -4.4410E-22, -4.0086E-22, -3.9366E-22, -3.8004E-22, -4.1425E-22, -3.9856E-22, &
      -4.2484E-22, -4.3424E-22, -4.2099E-22, -4.3745E-22, -4.3685E-22, -4.3281E-22, &
      -4.5364E-22, -4.3725E-22, -4.7170E-22, -4.5404E-22, -4.6746E-22, -4.6493E-22, &
      -5.0723E-22, -4.8975E-22, -4.8112E-22, -4.9239E-22, -4.7615E-22, -4.6279E-22, &
      -4.3856E-22, -4.1032E-22, -3.9211E-22, -3.6170E-22, -3.3287E-22, -3.0549E-22, &
      -2.7327E-22, -2.4636E-22, -1.9561E-22, -1.6762E-22 /)
    REAL, PARAMETER :: a1_1_BrNO3(dim55) = (/ &
      3.8656E-20, 3.6060E-20, 3.3878E-20, 3.0537E-20, 2.7835E-20, 2.4767E-20, &
      2.2338E-20, 2.0009E-20, 1.8129E-20, 1.6448E-20, 1.5071E-20, 1.3881E-20, &
      1.2871E-20, 1.2025E-20, 1.1250E-20, 1.0640E-20, 1.0053E-20, 9.5464E-21, &
      9.0850E-21, 8.6973E-21, 8.3283E-21, 8.0009E-21, 7.6694E-21, 7.4115E-21, &
      7.1484E-21, 6.9048E-21, 6.6686E-21, 6.4823E-21, 6.2651E-21, 6.1203E-21, &
      5.9074E-21, 5.7866E-21, 5.6038E-21, 5.4917E-21, 5.3224E-21, 5.2273E-21, &
      5.0837E-21, 5.0011E-21, 4.8413E-21, 4.8010E-21, 4.4856E-21, 4.1020E-21, &
      3.7628E-21, 3.4994E-21, 3.2488E-21, 3.0546E-21, 2.8504E-21, 2.7045E-21, &
      2.4742E-21, 2.3167E-21, 2.1764E-21, 2.0424E-21, 1.9214E-21, 1.8074E-21, &
      1.6987E-21 /)
    REAL, PARAMETER :: b1_1_BrNO3(dim55) = (/ &
      2.3738E-18, 2.3816E-18, 2.3936E-18, 2.4203E-18, 2.4487E-18, 2.4885E-18, &
      2.5262E-18, 2.5681E-18, 2.6067E-18, 2.6453E-18, 2.6804E-18, 2.7137E-18, &
      2.7445E-18, 2.7725E-18, 2.8000E-18, 2.8232E-18, 2.8469E-18, 2.8687E-18, &
      2.8897E-18, 2.9083E-18, 2.9270E-18, 2.9443E-18, 2.9627E-18, 2.9777E-18, &
      2.9936E-18, 3.0089E-18, 3.0244E-18, 3.0371E-18, 3.0524E-18, 3.0630E-18, &
      3.0790E-18, 3.0884E-18, 3.1032E-18, 3.1125E-18, 3.1269E-18, 3.1353E-18, &
      3.1483E-18, 3.1560E-18, 3.1712E-18, 3.1752E-18, 3.2069E-18, 3.2503E-18, &
      3.2928E-18, 3.3292E-18, 3.3669E-18, 3.3985E-18, 3.4344E-18, 3.4618E-18, &
      3.5080E-18, 3.5415E-18, 3.5732E-18, 3.6051E-18, 3.6354E-18, 3.6653E-18, &
      3.6953E-18 /)
    REAL, PARAMETER :: a1_2_BrNO3(dim55) = (/ &
      -4.6986E-23, -9.2806E-24, -1.4178E-24, 2.2800E-23, 2.6590E-23, 3.7415E-23, &
      3.6968E-23, 3.8950E-23, 3.6036E-23, 3.4484E-23, 3.1345E-23, 2.8688E-23, &
      2.5926E-23, 2.3392E-23, 2.1462E-23, 1.9163E-23, 1.7690E-23, 1.6270E-23, &
      1.5130E-23, 1.3851E-23, 1.2931E-23, 1.1956E-23, 1.1578E-23, 1.0578E-23, &
      1.0173E-23, 9.4740E-24, 9.2689E-24, 8.5397E-24, 8.3852E-24, 7.6937E-24, &
      7.7771E-24, 7.0354E-24, 7.0825E-24, 6.4945E-24, 6.6273E-24, 5.9753E-24, &
      6.0933E-24, 5.5311E-24, 5.7935E-24, 5.0636E-24, 4.8941E-24, 4.1281E-24, &
      3.7196E-24, 3.2254E-24, 3.0195E-24, 2.6656E-24, 2.5872E-24, 2.2904E-24, &
      2.6055E-24, 2.5591E-24, 2.5064E-24, 2.4664E-24, 2.4178E-24, 2.3730E-24, &
      2.3359E-24 /)
    REAL, PARAMETER :: b1_2_BrNO3(dim55) = (/ &
      -2.6070E-21, -2.7201E-21, -2.7633E-21, -2.9571E-21, -2.9969E-21, -3.1376E-21, &
      -3.1306E-21, -3.1663E-21, -3.1066E-21, -3.0709E-21, -2.9908E-21, -2.9165E-21, &
      -2.8322E-21, -2.7486E-21, -2.6801E-21, -2.5927E-21, -2.5331E-21, -2.4720E-21, &
      -2.4201E-21, -2.3587E-21, -2.3123E-21, -2.2606E-21, -2.2396E-21, -2.1816E-21, &
      -2.1571E-21, -2.1131E-21, -2.0996E-21, -2.0501E-21, -2.0392E-21, -1.9887E-21, &
      -1.9950E-21, -1.9371E-21, -1.9409E-21, -1.8921E-21, -1.9035E-21, -1.8461E-21, &
      -1.8568E-21, -1.8045E-21, -1.8295E-21, -1.7580E-21, -1.7410E-21, -1.6544E-21, &
      -1.6032E-21, -1.5350E-21, -1.5040E-21, -1.4463E-21, -1.4325E-21, -1.3767E-21, &
      -1.4399E-21, -1.4300E-21, -1.4181E-21, -1.4086E-21, -1.3965E-21, -1.3847E-21, &
      -1.3744E-21 /)
    REAL, PARAMETER :: a2_BrNO3(dim55) = (/ &
      -9.9440E-21, -8.5120E-21, -6.8160E-21, -5.1680E-21, -3.7760E-21, -2.6880E-21, &
      -1.8960E-21, -1.3400E-21, -9.5200E-22, -6.9600E-22, -5.1199E-22, -3.9200E-22, &
      -3.0800E-22, -2.4800E-22, -2.0000E-22, -1.7200E-22, -1.4800E-22, -1.2800E-22, &
      -1.1200E-22, -9.9996E-23, -9.2003E-23, -8.4000E-23, -7.1996E-23, -6.8005E-23, &
      -6.4003E-23, -5.9991E-23, -5.2009E-23, -4.7997E-23, -4.7997E-23, -4.4006E-23, &
      -3.5993E-23, -4.0005E-23, -3.2002E-23, -3.2002E-23, -3.1991E-23, -2.8000E-23, &
      -2.4009E-23, -2.8000E-23, -1.9997E-23, -2.3999E-23, -1.7600E-23, -1.2799E-23, &
      -8.8012E-24, -7.2006E-24, -4.7997E-24, -3.1991E-24, -2.4009E-24, -1.5985E-24, &
      -1.6006E-24, -8.0030E-25, -8.0030E-25, -0.0000E+00, -8.0030E-25, -0.0000E+00, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b2_BrNO3(dim55) = (/ &
       3.4735E-19,  3.4306E-19,  3.3373E-19,  3.2054E-19,  3.0593E-19,  2.9178E-19, &
       2.7951E-19,  2.6950E-19,  2.6155E-19,  2.5566E-19,  2.5097E-19,  2.4761E-19, &
       2.4504E-19,  2.4306E-19,  2.4136E-19,  2.4030E-19,  2.3932E-19,  2.3846E-19, &
       2.3774E-19,  2.3716E-19,  2.3676E-19,  2.3633E-19,  2.3567E-19,  2.3543E-19, &
       2.3519E-19,  2.3494E-19,  2.3442E-19,  2.3414E-19,  2.3414E-19,  2.3385E-19, &
       2.3325E-19,  2.3356E-19,  2.3292E-19,  2.3292E-19,  2.3292E-19,  2.3256E-19, &
       2.3220E-19,  2.3257E-19,  2.3181E-19,  2.3220E-19,  2.3156E-19,  2.3102E-19, &
       2.3051E-19,  2.3029E-19,  2.2993E-19,  2.2967E-19,  2.2953E-19,  2.2938E-19, &
       2.2938E-19,  2.2921E-19,  2.2921E-19,  2.2902E-19,  2.2922E-19,  2.2901E-19, &
       2.2901E-19 /)
    REAL, PARAMETER :: a3_BrNO3(dim55) = (/ &
      -1.9131E-22, -1.6655E-22, -1.3699E-22, -1.1064E-22, -8.7460E-23, -6.9888E-23, &
      -5.6732E-23, -4.5927E-23, -3.8738E-23, -3.2348E-23, -2.7967E-23, -2.4361E-23, &
      -2.1166E-23, -1.8770E-23, -1.6780E-23, -1.5176E-23, -1.3578E-23, -1.2380E-23, &
      -1.1187E-23, -1.0383E-23, -9.5846E-24, -8.7861E-24, -7.9903E-24, -7.5881E-24, &
      -7.1886E-24, -6.3896E-24, -6.3926E-24, -5.9901E-24, -5.5911E-24, -5.1916E-24, &
      -4.7945E-24, -4.7926E-24, -4.3925E-24, -4.3930E-24, -3.9951E-24, -3.5946E-24, &
      -3.5940E-24, -3.5946E-24, -3.5955E-24, -3.1950E-24, -2.7955E-24, -2.3961E-24, &
      -1.9968E-24, -1.6773E-24, -1.5187E-24, -1.2780E-24, -1.0383E-24, -1.0383E-24, &
      -7.9871E-25, -7.9881E-25, -6.3890E-25, -5.5911E-25, -4.7969E-25, -4.7920E-25, &
      -3.9930E-25 /)
    REAL, PARAMETER :: b3_BrNO3(dim55) = (/ &
      1.8325E-19, 1.8261E-19, 1.8112E-19, 1.7913E-19, 1.7679E-19, 1.7458E-19, &
      1.7260E-19, 1.7070E-19, 1.6926E-19, 1.6782E-19, 1.6672E-19, 1.6572E-19, &
      1.6476E-19, 1.6398E-19, 1.6328E-19, 1.6268E-19, 1.6204E-19, 1.6153E-19, &
      1.6099E-19, 1.6060E-19, 1.6020E-19, 1.5978E-19, 1.5935E-19, 1.5911E-19, &
      1.5887E-19, 1.5837E-19, 1.5837E-19, 1.5810E-19, 1.5782E-19, 1.5753E-19, &
      1.5723E-19, 1.5723E-19, 1.5691E-19, 1.5691E-19, 1.5657E-19, 1.5622E-19, &
      1.5622E-19, 1.5622E-19, 1.5622E-19, 1.5583E-19, 1.5543E-19, 1.5498E-19, &
      1.5448E-19, 1.5404E-19, 1.5380E-19, 1.5341E-19, 1.5299E-19, 1.5299E-19, &
      1.5251E-19, 1.5251E-19, 1.5215E-19, 1.5196E-19, 1.5176E-19, 1.5176E-19, &
      1.5154E-19 /)
    REAL, PARAMETER :: a4_BrNO3(2) = (/ 1.3122E-19, -2.2919E-24 /)
    REAL, PARAMETER :: a5_BrNO3(2) = (/ 9.1104E-20, -2.3309E-24 /)
    REAL, PARAMETER :: a6_BrNO3(1) = (/ 3.2278E-20 /)
    REAL, PARAMETER :: a7_BrNO3(2) = (/ 1.7073E-21, 1.0189E-25 /)

    jval_gp(ip_BrNO3)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_BrNO3(0) = &
          p1(a0_1_1_BrNO3(i0(j,k))*dlv2(j,k) + &
          a0_1_2_BrNO3(i0(j,k)), &
          a0_2_1_BrNO3(i0(j,k))*dlv2(j,k) + &
          a0_2_2_BrNO3(i0(j,k)),v3_du1(j,k))
        sig_BrNO3(1) = &
          (p1(b1_1_BrNO3(i1(j,k)),a1_1_BrNO3(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_BrNO3(i1(j,k)),a1_2_BrNO3(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_BrNO3(2) = &
          p1(b2_BrNO3(i2(j,k)), a2_BrNO3(i2(j,k)), &
          v3_du1(j,k))
        sig_BrNO3(3) = &
          p1(b3_BrNO3(i3(j,k)), a3_BrNO3(i3(j,k)), &
          v3_du2(j,k))
        sig_BrNO3(4) = &
          p1(a4_BrNO3(1),a4_BrNO3(2),v3_du2(j,k))
        sig_BrNO3(5) = &
          p1(a5_BrNO3(1),a5_BrNO3(2),v3_du2(j,k))
        sig_BrNO3(6) = &
          a6_BrNO3(1)
        sig_BrNO3(7) = &
          p1(a7_BrNO3(1),a7_BrNO3(2),v3_du2(j,k))
        dj = 0. &
          + sig_BrNO3(0) * fint(j,k,0) &
          + sig_BrNO3(1) * fint(j,k,1) &
          + sig_BrNO3(2) * fint(j,k,2) &
          + sig_BrNO3(3) * fint(j,k,3) &
          + sig_BrNO3(4) * fint(j,k,4) &
          + sig_BrNO3(5) * fint(j,k,5) &
          + sig_BrNO3(6) * fint(j,k,6) &
          + sig_BrNO3(7) * fint(j,k,7)

        jval_gp(ip_BrNO3)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_BrNO3

  ! **************************************************************************

  SUBROUTINE jval_cal_BrNO2(jrow)

    ! BrNO2 -> products Scheffler et al. (1997)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_BrNO2

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_BrNO2(dim58) = (/ &
      6.8474E-19, 7.3869E-19, 7.9658E-19, 8.5345E-19, 9.1357E-19, 9.7297E-19, &
      1.0317E-18, 1.0916E-18, 1.1524E-18, 1.2101E-18, 1.2699E-18, 1.3302E-18, &
      1.3981E-18, 1.4838E-18, 1.5320E-18, 1.5836E-18, 1.6415E-18, 1.6746E-18, &
      1.7078E-18, 1.7409E-18, 1.7425E-18, 1.7454E-18, 1.7438E-18, 1.7176E-18, &
      1.6894E-18, 1.6449E-18, 1.6028E-18, 1.5651E-18, 1.5211E-18, 1.4753E-18, &
      1.4249E-18, 1.3671E-18, 1.3070E-18, 1.2436E-18, 1.1784E-18, 1.1171E-18, &
      1.0566E-18, 1.0032E-18, 9.5845E-19, 9.1792E-19, 8.8281E-19, 8.4880E-19, &
      8.1272E-19, 7.7098E-19, 7.1868E-19, 6.5709E-19, 5.9013E-19, 5.1742E-19, &
      4.4324E-19, 3.7913E-19, 3.1547E-19, 2.6133E-19, 2.1218E-19, 1.6924E-19, &
      1.2943E-19, 9.6087E-20, 6.8233E-20, 5.3801E-20 /)
    REAL, PARAMETER :: a0_1_2_BrNO2(dim58) = (/ &
      1.1130E-17, 8.7454E-18, 6.1753E-18, 3.6387E-18, 9.4528E-19, -1.7277E-18, &
      -4.3818E-18, -7.1005E-18, -9.8748E-18, -1.2519E-17, -1.5269E-17, -1.8052E-17, &
      -2.1203E-17, -2.5197E-17, -2.7452E-17, -2.9877E-17, -3.2613E-17, -3.4181E-17, &
      -3.5760E-17, -3.7343E-17, -3.7421E-17, -3.7559E-17, -3.7481E-17, -3.6210E-17, &
      -3.4831E-17, -3.2653E-17, -3.0582E-17, -2.8718E-17, -2.6537E-17, -2.4253E-17, &
      -2.1736E-17, -1.8833E-17, -1.5807E-17, -1.2597E-17, -9.2826E-18, -6.1581E-18, &
      -3.0629E-18, -3.1409E-19, 1.9936E-18, 4.0927E-18, 5.9184E-18, 7.6938E-18, &
      9.5845E-18, 1.1780E-17, 1.4541E-17, 1.7806E-17, 2.1368E-17, 2.5251E-17, &
      2.9227E-17, 3.2676E-17, 3.6113E-17, 3.9048E-17, 4.1721E-17, 4.4066E-17, &
      4.6248E-17, 4.8082E-17, 4.9619E-17, 5.0419E-17 /)
    REAL, PARAMETER :: a0_2_1_BrNO2(dim58) = (/ &
      -3.9597E-21, -4.2625E-21, -4.5966E-21, -4.9128E-21, -5.2770E-21, -5.6095E-21, &
      -5.9318E-21, -6.2906E-21, -6.6510E-21, -6.9751E-21, -7.2926E-21, -7.6859E-21, &
      -8.3646E-21, -9.7590E-21, -9.6930E-21, -9.9147E-21, -1.0444E-20, -1.0259E-20, &
      -1.0337E-20, -1.0633E-20, -1.0200E-20, -1.0053E-20, -9.9983E-21, -9.4448E-21, &
      -9.0250E-21, -8.2908E-21, -7.7560E-21, -7.4097E-21, -7.0223E-21, -6.6606E-21, &
      -6.2735E-21, -5.8539E-21, -5.4517E-21, -5.0545E-21, -4.6411E-21, -4.2903E-21, &
      -3.9272E-21, -3.6168E-21, -3.3822E-21, -3.1558E-21, -2.9937E-21, -2.8234E-21, &
      -2.6608E-21, -2.4902E-21, -2.2560E-21, -2.0122E-21, -1.7674E-21, -1.4964E-21, &
      -1.1984E-21, -1.0349E-21, -7.9339E-22, -6.2724E-22, -4.7428E-22, -3.6377E-22, &
      -2.5035E-22, -1.7992E-22, -1.0945E-22, -9.6447E-23 /)
    REAL, PARAMETER :: a0_2_2_BrNO2(dim58) = (/ &
      2.3506E-19, 2.4845E-19, 2.6329E-19, 2.7738E-19, 2.9370E-19, 3.0866E-19, &
      3.2323E-19, 3.3952E-19, 3.5596E-19, 3.7080E-19, 3.8540E-19, 4.0357E-19, &
      4.3507E-19, 5.0005E-19, 4.9696E-19, 5.0738E-19, 5.3234E-19, 5.2359E-19, &
      5.2732E-19, 5.4147E-19, 5.2069E-19, 5.1359E-19, 5.1094E-19, 4.8404E-19, &
      4.6355E-19, 4.2758E-19, 4.0126E-19, 3.8416E-19, 3.6494E-19, 3.4693E-19, &
      3.2757E-19, 3.0651E-19, 2.8624E-19, 2.6614E-19, 2.4514E-19, 2.2725E-19, &
      2.0866E-19, 1.9270E-19, 1.8060E-19, 1.6887E-19, 1.6044E-19, 1.5155E-19, &
      1.4303E-19, 1.3406E-19, 1.2169E-19, 1.0877E-19, 9.5744E-20, 8.1274E-20, &
      6.5303E-20, 5.6505E-20, 4.3464E-20, 3.4459E-20, 2.6138E-20, 2.0104E-20, &
      1.3888E-20, 1.0015E-20, 6.1251E-21, 5.4045E-21 /)
    REAL, PARAMETER :: a0_3_1_BrNO2(dim58) = (/ &
      6.9427E-24, 7.4862E-24, 8.1082E-24, 8.6340E-24, 9.4024E-24, 1.0030E-23, &
      1.0561E-23, 1.1332E-23, 1.2063E-23, 1.2711E-23, 1.3225E-23, 1.4217E-23, &
      1.7019E-23, 2.4035E-23, 2.2038E-23, 2.2035E-23, 2.3768E-23, 2.1763E-23, &
      2.1468E-23, 2.2443E-23, 2.0152E-23, 1.9445E-23, 1.9406E-23, 1.7313E-23, &
      1.6042E-23, 1.3586E-23, 1.2076E-23, 1.1405E-23, 1.0632E-23, 9.9744E-24, &
      9.2345E-24, 8.4514E-24, 7.7441E-24, 7.0641E-24, 6.3225E-24, 5.7506E-24, &
      5.1076E-24, 4.5890E-24, 4.2088E-24, 3.8449E-24, 3.6267E-24, 3.3706E-24, &
      3.1448E-24, 2.9258E-24, 2.5883E-24, 2.2725E-24, 1.9980E-24, 1.6477E-24, &
      1.1866E-24, 1.1536E-24, 7.8182E-25, 6.0034E-25, 4.2295E-25, 3.2981E-25, &
      1.8573E-25, 1.4628E-25, 5.6168E-26, 8.7466E-26 /)
    REAL, PARAMETER :: a0_3_2_BrNO2(dim58) = (/ &
      -4.1315E-22, -4.3718E-22, -4.6479E-22, -4.8824E-22, -5.2267E-22, -5.5093E-22, &
      -5.7492E-22, -6.0991E-22, -6.4323E-22, -6.7294E-22, -6.9656E-22, -7.4240E-22, &
      -8.7243E-22, -1.1994E-21, -1.1059E-21, -1.1057E-21, -1.1875E-21, -1.0925E-21, &
      -1.0785E-21, -1.1251E-21, -1.0151E-21, -9.8104E-22, -9.7915E-22, -8.7744E-22, &
      -8.1540E-22, -6.9508E-22, -6.2078E-22, -5.8761E-22, -5.4928E-22, -5.1653E-22, &
      -4.7953E-22, -4.4023E-22, -4.0458E-22, -3.7017E-22, -3.3250E-22, -3.0333E-22, &
      -2.7041E-22, -2.4375E-22, -2.2413E-22, -2.0528E-22, -1.9394E-22, -1.8057E-22, &
      -1.6874E-22, -1.5722E-22, -1.3940E-22, -1.2266E-22, -1.0805E-22, -8.9349E-23, &
      -6.4637E-23, -6.2860E-23, -4.2784E-23, -3.2947E-23, -2.3298E-23, -1.8212E-23, &
      -1.0317E-23, -8.1471E-24, -3.1728E-24, -4.9067E-24 /)
    REAL, PARAMETER :: a1_1_BrNO2(dim55) = (/ &
      3.5417E-19, 3.5669E-19, 3.7478E-19, 3.6017E-19, 3.6339E-19, 3.4050E-19, &
      3.3614E-19, 3.1192E-19, 3.0507E-19, 2.8299E-19, 2.7569E-19, 2.5689E-19, &
      2.5026E-19, 2.3456E-19, 2.2833E-19, 2.1554E-19, 2.0965E-19, 1.9895E-19, &
      1.9382E-19, 1.8466E-19, 1.7982E-19, 1.7223E-19, 1.6783E-19, 1.6116E-19, &
      1.5691E-19, 1.5171E-19, 1.4749E-19, 1.4301E-19, 1.3896E-19, 1.3519E-19, &
      1.3140E-19, 1.2840E-19, 1.2452E-19, 1.2204E-19, 1.1845E-19, 1.1638E-19, &
      1.1283E-19, 1.1129E-19, 1.0766E-19, 1.0650E-19, 9.9412E-20, 9.0539E-20, &
      8.2489E-20, 7.6402E-20, 7.0278E-20, 6.5855E-20, 6.0860E-20, 5.7517E-20, &
      5.1768E-20, 4.8195E-20, 4.4945E-20, 4.1935E-20, 3.9176E-20, 3.6622E-20, &
      3.4284E-20 /)
    REAL, PARAMETER :: b1_1_BrNO2(dim55) = (/ &
      7.7396E-18, 7.7320E-18, 7.6326E-18, 7.7495E-18, 7.7157E-18, 8.0131E-18, &
      8.0808E-18, 8.5167E-18, 8.6572E-18, 9.1650E-18, 9.3512E-18, 9.8775E-18, &
      1.0080E-17, 1.0598E-17, 1.0819E-17, 1.1305E-17, 1.1544E-17, 1.2004E-17, &
      1.2237E-17, 1.2677E-17, 1.2921E-17, 1.3324E-17, 1.3568E-17, 1.3954E-17, &
      1.4212E-17, 1.4539E-17, 1.4816E-17, 1.5121E-17, 1.5406E-17, 1.5681E-17, &
      1.5967E-17, 1.6201E-17, 1.6514E-17, 1.6720E-17, 1.7027E-17, 1.7208E-17, &
      1.7530E-17, 1.7673E-17, 1.8020E-17, 1.8133E-17, 1.8846E-17, 1.9848E-17, &
      2.0859E-17, 2.1699E-17, 2.2620E-17, 2.3341E-17, 2.4218E-17, 2.4846E-17, &
      2.5999E-17, 2.6760E-17, 2.7493E-17, 2.8209E-17, 2.8901E-17, 2.9572E-17, &
      3.0216E-17 /)
    REAL, PARAMETER :: a1_2_BrNO2(dim55) = (/ &
      -1.4400E-21, -9.6853E-22, -1.0888E-21, -6.0408E-22, -6.8025E-22, -2.7933E-22, &
      -3.5135E-22, -5.7887E-23, -1.3396E-22, 7.1426E-23, -4.3815E-25, 1.3970E-22, &
      7.4591E-23, 1.6984E-22, 1.1813E-22, 1.8230E-22, 1.4216E-22, 1.8493E-22, &
      1.5234E-22, 1.8418E-22, 1.5888E-22, 1.7751E-22, 1.5875E-22, 1.7170E-22, &
      1.5843E-22, 1.6193E-22, 1.5483E-22, 1.5457E-22, 1.5082E-22, 1.4702E-22, &
      1.4581E-22, 1.3789E-22, 1.4076E-22, 1.3053E-22, 1.3510E-22, 1.2371E-22, &
      1.2945E-22, 1.1669E-22, 1.2450E-22, 1.1073E-22, 1.0945E-22, 9.4901E-23, &
      8.8320E-23, 7.6988E-23, 7.3780E-23, 6.4643E-23, 6.3705E-23, 5.5934E-23, &
      6.4987E-23, 6.3137E-23, 6.1322E-23, 5.9676E-23, 5.7990E-23, 5.6367E-23, &
      5.4628E-23 /)
    REAL, PARAMETER :: b1_2_BrNO2(dim55) = (/ &
      -2.3705E-20, -2.5119E-20, -2.4457E-20, -2.8335E-20, -2.7536E-20, -3.2747E-20, &
      -3.1631E-20, -3.6914E-20, -3.5354E-20, -4.0078E-20, -3.8245E-20, -4.2169E-20, &
      -4.0183E-20, -4.3327E-20, -4.1491E-20, -4.3930E-20, -4.2304E-20, -4.4143E-20, &
      -4.2660E-20, -4.4188E-20, -4.2911E-20, -4.3898E-20, -4.2857E-20, -4.3608E-20, &
      -4.2805E-20, -4.3026E-20, -4.2561E-20, -4.2543E-20, -4.2279E-20, -4.2002E-20, &
      -4.1910E-20, -4.1292E-20, -4.1523E-20, -4.0674E-20, -4.1065E-20, -4.0062E-20, &
      -4.0582E-20, -3.9395E-20, -4.0141E-20, -3.8792E-20, -3.8663E-20, -3.7019E-20, &
      -3.6193E-20, -3.4629E-20, -3.4146E-20, -3.2657E-20, -3.2492E-20, -3.1031E-20, &
      -3.2846E-20, -3.2452E-20, -3.2043E-20, -3.1652E-20, -3.1229E-20, -3.0802E-20, &
      -3.0323E-20 /)
    REAL, PARAMETER :: a2_BrNO2(dim55) = (/ &
      -7.3560E-20, -6.4120E-20, -5.2480E-20, -4.0824E-20, -3.0660E-20, -2.2564E-20, &
      -1.6492E-20, -1.2088E-20, -8.9600E-21, -6.7560E-21, -5.2000E-21, -4.0880E-21, &
      -3.2880E-21, -2.6960E-21, -2.2560E-21, -1.9200E-21, -1.6560E-21, -1.4480E-21, &
      -1.2760E-21, -1.1400E-21, -1.0240E-21, -9.2799E-22, -8.4000E-22, -7.6800E-22, &
      -7.0399E-22, -6.4400E-22, -6.0002E-22, -5.4799E-22, -5.1200E-22, -4.7201E-22, &
      -4.4000E-22, -4.0799E-22, -3.8001E-22, -3.5600E-22, -3.3201E-22, -3.0800E-22, &
      -2.8798E-22, -2.6801E-22, -2.5200E-22, -2.3599E-22, -1.9360E-22, -1.3920E-22, &
      -1.0000E-22, -7.1998E-23, -5.2803E-23, -3.7599E-23, -2.7198E-23, -1.9203E-23, &
      -1.4397E-23, -9.5994E-24, -7.2006E-24, -5.6000E-24, -3.9994E-24, -2.4030E-24, &
      -2.3988E-24 /)
    REAL, PARAMETER :: b2_BrNO2(dim55) = (/ &
       1.4719E-18,  1.4436E-18,  1.3795E-18,  1.2863E-18,  1.1796E-18,  1.0743E-18, &
       9.8021E-19,  9.0093E-19,  8.3681E-19,  7.8612E-19,  7.4644E-19,  7.1530E-19, &
       6.9090E-19,  6.7137E-19,  6.5575E-19,  6.4298E-19,  6.3229E-19,  6.2334E-19, &
       6.1552E-19,  6.0899E-19,  6.0313E-19,  5.9804E-19,  5.9316E-19,  5.8898E-19, &
       5.8511E-19,  5.8133E-19,  5.7845E-19,  5.7491E-19,  5.7238E-19,  5.6946E-19, &
       5.6704E-19,  5.6454E-19,  5.6229E-19,  5.6030E-19,  5.5825E-19,  5.5613E-19, &
       5.5432E-19,  5.5246E-19,  5.5094E-19,  5.4937E-19,  5.4511E-19,  5.3896E-19, &
       5.3404E-19,  5.3018E-19,  5.2729E-19,  5.2481E-19,  5.2298E-19,  5.2148E-19, &
       5.2052E-19,  5.1949E-19,  5.1895E-19,  5.1857E-19,  5.1817E-19,  5.1775E-19, &
       5.1775E-19 /)
    REAL, PARAMETER :: a3_BrNO2(dim55) = (/ &
      -7.4447E-22, -6.2747E-22, -5.0204E-22, -3.8863E-22, -2.9712E-22, -2.2803E-22, &
      -1.7699E-22, -1.4018E-22, -1.1302E-22, -9.3451E-23, -7.7907E-23, -6.6294E-23, &
      -5.7508E-23, -4.9921E-23, -4.3947E-23, -3.8738E-23, -3.5144E-23, -3.1150E-23, &
      -2.8366E-23, -2.5958E-23, -2.3562E-23, -2.1566E-23, -1.9577E-23, -1.8770E-23, &
      -1.6773E-23, -1.5975E-23, -1.4782E-23, -1.3978E-23, -1.3179E-23, -1.2380E-23, &
      -1.1586E-23, -1.0783E-23, -1.0384E-23, -9.5846E-24, -9.5885E-24, -8.7861E-24, &
      -8.3866E-24, -7.9871E-24, -7.5906E-24, -7.1886E-24, -6.4697E-24, -5.2716E-24, &
      -4.4729E-24, -3.7539E-24, -3.2775E-24, -2.7955E-24, -2.3961E-24, -2.1565E-24, &
      -1.8371E-24, -1.6773E-24, -1.4376E-24, -1.2780E-24, -1.1191E-24, -9.5841E-25, &
      -8.7861E-25 /)
    REAL, PARAMETER :: b3_BrNO2(dim55) = (/ &
      2.5709E-19, 2.5410E-19, 2.4776E-19, 2.3919E-19, 2.2998E-19, 2.2129E-19, &
      2.1360E-19, 2.0713E-19, 2.0167E-19, 1.9725E-19, 1.9336E-19, 1.9015E-19, &
      1.8751E-19, 1.8503E-19, 1.8294E-19, 1.8098E-19, 1.7954E-19, 1.7783E-19, &
      1.7658E-19, 1.7543E-19, 1.7423E-19, 1.7318E-19, 1.7208E-19, 1.7162E-19, &
      1.7042E-19, 1.6992E-19, 1.6914E-19, 1.6860E-19, 1.6804E-19, 1.6746E-19, &
      1.6686E-19, 1.6623E-19, 1.6591E-19, 1.6525E-19, 1.6526E-19, 1.6455E-19, &
      1.6419E-19, 1.6382E-19, 1.6345E-19, 1.6305E-19, 1.6233E-19, 1.6098E-19, &
      1.5998E-19, 1.5899E-19, 1.5828E-19, 1.5749E-19, 1.5679E-19, 1.5634E-19, &
      1.5570E-19, 1.5536E-19, 1.5482E-19, 1.5444E-19, 1.5404E-19, 1.5362E-19, &
      1.5340E-19 /)
    REAL, PARAMETER :: a4_BrNO2(3) = (/ 1.1664E-19, -6.6744E-24, 1.4191E-27 /)
    REAL, PARAMETER :: a5_BrNO2(2) = (/ 1.2291E-19, 2.5352E-24 /)
    REAL, PARAMETER :: a6_BrNO2(1) = (/ 1.4964E-19 /)
    REAL, PARAMETER :: a7_BrNO2(2) = (/ 1.4836E-20, 7.7791E-25 /)

    jval_gp(ip_BrNO2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_BrNO2(0) = &
          p2(a0_1_1_BrNO2(i0(j,k))*dlv2(j,k) + &
          a0_1_2_BrNO2(i0(j,k)), &
          a0_2_1_BrNO2(i0(j,k))*dlv2(j,k) + &
          a0_2_2_BrNO2(i0(j,k)), &
          a0_3_1_BrNO2(i0(j,k))*dlv2(j,k) + &
          a0_3_2_BrNO2(i0(j,k)), v3_du1(j,k))
        sig_BrNO2(1) = &
          (p1(b1_1_BrNO2(i1(j,k)),a1_1_BrNO2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_BrNO2(i1(j,k)),a1_2_BrNO2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_BrNO2(2) = &
          p1(b2_BrNO2(i2(j,k)), a2_BrNO2(i2(j,k)), &
          v3_du1(j,k))
        sig_BrNO2(3) = &
          p1(b3_BrNO2(i3(j,k)), a3_BrNO2(i3(j,k)), &
          v3_du2(j,k))
        sig_BrNO2(4) = &
          p2(a4_BrNO2(1),a4_BrNO2(2),a4_BrNO2(3),v3_du2(j,k))
        sig_BrNO2(5) = &
          p1(a5_BrNO2(1),a5_BrNO2(2),v3_du2(j,k))
        sig_BrNO2(6) = &
          a6_BrNO2(1)
        sig_BrNO2(7) = &
          p1(a7_BrNO2(1),a7_BrNO2(2),v3_du2(j,k))
        dj = 0. &
          + sig_BrNO2(0) * fint(j,k,0) &
          + sig_BrNO2(1) * fint(j,k,1) &
          + sig_BrNO2(2) * fint(j,k,2) &
          + sig_BrNO2(3) * fint(j,k,3) &
          + sig_BrNO2(4) * fint(j,k,4) &
          + sig_BrNO2(5) * fint(j,k,5) &
          + sig_BrNO2(6) * fint(j,k,6) &
          + sig_BrNO2(7) * fint(j,k,7)

        jval_gp(ip_BrNO2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_BrNO2

  ! **************************************************************************

  SUBROUTINE jval_cal_Br2(jrow)

    ! Br2 -> products Hubinger + Nee (1995)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_Br2

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_Br2(dim58) = (/ &
      4.9590E-23, 5.4088E-23, 5.8745E-23, 6.3687E-23, 6.8652E-23, 7.3817E-23, &
      7.9070E-23, 8.4385E-23, 8.9800E-23, 9.5357E-23, 1.0092E-22, 1.0685E-22, &
      1.1783E-22, 1.3876E-22, 1.3904E-22, 1.4425E-22, 1.5408E-22, 1.5385E-22, &
      1.5823E-22, 1.6640E-22, 1.6529E-22, 1.6804E-22, 1.7441E-22, 1.7216E-22, &
      1.7369E-22, 1.6817E-22, 1.6663E-22, 1.6808E-22, 1.6894E-22, 1.6915E-22, &
      1.6842E-22, 1.6665E-22, 1.6414E-22, 1.6061E-22, 1.5657E-22, 1.5206E-22, &
      1.4745E-22, 1.4302E-22, 1.3882E-22, 1.3475E-22, 1.3102E-22, 1.2711E-22, &
      1.2276E-22, 1.1747E-22, 1.1128E-22, 1.0403E-22, 9.5874E-23, 8.7779E-23, &
      8.0001E-23, 7.3049E-23, 6.7081E-23, 6.1902E-23, 5.6987E-23, 5.2466E-23, &
      4.7401E-23, 4.2137E-23, 3.5692E-23, 2.9749E-23 /)
    REAL, PARAMETER :: a0_1_2_Br2(dim58) = (/ &
      4.2172E-22, 2.2291E-22, 1.6120E-23, -2.0427E-22, -4.2673E-22, -6.5913E-22, &
      -8.9656E-22, -1.1379E-21, -1.3848E-21, -1.6393E-21, -1.8950E-21, -2.1691E-21, &
      -2.6788E-21, -3.6541E-21, -3.6670E-21, -3.9121E-21, -4.3761E-21, -4.3652E-21, &
      -4.5734E-21, -4.9643E-21, -4.9107E-21, -5.0435E-21, -5.3515E-21, -5.2421E-21, &
      -5.3167E-21, -5.0463E-21, -4.9707E-21, -5.0423E-21, -5.0850E-21, -5.0955E-21, &
      -5.0589E-21, -4.9701E-21, -4.8438E-21, -4.6650E-21, -4.4595E-21, -4.2297E-21, &
      -3.9939E-21, -3.7659E-21, -3.5493E-21, -3.3386E-21, -3.1445E-21, -2.9405E-21, &
      -2.7123E-21, -2.4341E-21, -2.1075E-21, -1.7234E-21, -1.2892E-21, -8.5693E-22, &
      -4.4000E-22, -6.5999E-23, 2.5628E-22, 5.3696E-22, 8.0437E-22, 1.0512E-21, &
      1.3288E-21, 1.6183E-21, 1.9740E-21, 2.3032E-21 /)
    REAL, PARAMETER :: a0_2_1_Br2(dim58) = (/ &
      -1.8186E-25, -1.9761E-25, -2.1307E-25, -2.3071E-25, -2.4690E-25, -2.6443E-25, &
      -2.8217E-25, -2.9983E-25, -3.1742E-25, -3.3579E-25, -3.5328E-25, -3.7306E-25, &
      -4.6853E-25, -7.0259E-25, -6.2857E-25, -6.2991E-25, -6.9146E-25, -6.2434E-25, &
      -6.2087E-25, -6.6704E-25, -6.0503E-25, -5.9522E-25, -6.2643E-25, -5.6864E-25, &
      -5.5572E-25, -4.7588E-25, -4.4023E-25, -4.3879E-25, -4.3510E-25, -4.3038E-25, &
      -4.2361E-25, -4.1313E-25, -4.0154E-25, -3.8704E-25, -3.7135E-25, -3.5503E-25, &
      -3.3802E-25, -3.2190E-25, -3.0637E-25, -2.9064E-25, -2.7625E-25, -2.6062E-25, &
      -2.4407E-25, -2.2453E-25, -2.0320E-25, -1.7911E-25, -1.5383E-25, -1.2963E-25, &
      -1.0788E-25, -8.9855E-26, -7.5477E-26, -6.4525E-26, -5.4884E-26, -4.7632E-26, &
      -3.9315E-26, -3.2643E-26, -2.5715E-26, -2.0121E-26 /)
    REAL, PARAMETER :: a0_2_2_Br2(dim58) = (/ &
      1.1951E-23, 1.2648E-23, 1.3334E-23, 1.4120E-23, 1.4846E-23, 1.5635E-23, &
      1.6437E-23, 1.7238E-23, 1.8041E-23, 1.8882E-23, 1.9686E-23, 2.0600E-23, &
      2.5030E-23, 3.5937E-23, 3.2473E-23, 3.2536E-23, 3.5441E-23, 3.2260E-23, &
      3.2095E-23, 3.4302E-23, 3.1325E-23, 3.0852E-23, 3.2363E-23, 2.9554E-23, &
      2.8924E-23, 2.5011E-23, 2.3258E-23, 2.3186E-23, 2.3003E-23, 2.2769E-23, &
      2.2430E-23, 2.1904E-23, 2.1320E-23, 2.0586E-23, 1.9789E-23, 1.8957E-23, &
      1.8086E-23, 1.7257E-23, 1.6456E-23, 1.5641E-23, 1.4892E-23, 1.4077E-23, &
      1.3209E-23, 1.2182E-23, 1.1055E-23, 9.7789E-24, 8.4340E-24, 7.1416E-24, &
      5.9757E-24, 5.0060E-24, 4.2296E-24, 3.6360E-24, 3.1115E-24, 2.7155E-24, &
      2.2598E-24, 1.8928E-24, 1.5104E-24, 1.2005E-24 /)
    REAL, PARAMETER :: a1_1_Br2(dim55) = (/ &
      -2.0687E-23, -2.5279E-23, -3.1878E-23, -3.3445E-23, -3.6969E-23, -3.6144E-23, &
      -3.7303E-23, -3.5351E-23, -3.5092E-23, -3.2889E-23, -3.1986E-23, -2.9943E-23, &
      -2.8785E-23, -2.7072E-23, -2.5857E-23, -2.4442E-23, -2.3289E-23, -2.2150E-23, &
      -2.1027E-23, -2.0165E-23, -1.9095E-23, -1.8444E-23, -1.7430E-23, -1.6947E-23, &
      -1.5999E-23, -1.5632E-23, -1.4744E-23, -1.4488E-23, -1.3641E-23, -1.3479E-23, &
      -1.2698E-23, -1.2593E-23, -1.1850E-23, -1.1800E-23, -1.1104E-23, -1.1114E-23, &
      -1.0433E-23, -1.0484E-23, -9.8384E-24, -9.9288E-24, -8.9774E-24, -8.0311E-24, &
      -7.1360E-24, -6.5393E-24, -5.9026E-24, -5.4989E-24, -5.0057E-24, -4.7196E-24, &
      -4.1560E-24, -3.8574E-24, -3.5876E-24, -3.3417E-24, -3.1172E-24, -2.9109E-24, &
      -2.7232E-24 /)
    REAL, PARAMETER :: b1_1_Br2(dim55) = (/ &
      8.6583E-21, 8.6721E-21, 8.7083E-21, 8.7209E-21, 8.7579E-21, 8.7472E-21, &
      8.7651E-21, 8.7300E-21, 8.7247E-21, 8.6740E-21, 8.6510E-21, 8.5938E-21, &
      8.5584E-21, 8.5019E-21, 8.4588E-21, 8.4050E-21, 8.3583E-21, 8.3093E-21, &
      8.2582E-21, 8.2169E-21, 8.1628E-21, 8.1283E-21, 8.0721E-21, 8.0440E-21, &
      7.9867E-21, 7.9636E-21, 7.9054E-21, 7.8880E-21, 7.8283E-21, 7.8165E-21, &
      7.7575E-21, 7.7493E-21, 7.6895E-21, 7.6853E-21, 7.6258E-21, 7.6267E-21, &
      7.5651E-21, 7.5699E-21, 7.5082E-21, 7.5170E-21, 7.4214E-21, 7.3145E-21, &
      7.2022E-21, 7.1198E-21, 7.0240E-21, 6.9582E-21, 6.8716E-21, 6.8178E-21, &
      6.7049E-21, 6.6413E-21, 6.5804E-21, 6.5219E-21, 6.4656E-21, 6.4114E-21, &
      6.3597E-21 /)
    REAL, PARAMETER :: a1_2_Br2(dim55) = (/ &
      2.4304E-25, 1.9058E-25, 2.1221E-25, 1.4288E-25, 1.4861E-25, 8.3863E-26, &
      8.3626E-26, 3.5303E-26, 3.3884E-26, 2.8369E-27, 2.2596E-27, -1.6103E-26, &
      -1.6272E-26, -2.5538E-26, -2.5882E-26, -2.9833E-26, -3.0317E-26, -3.0853E-26, &
      -3.2070E-26, -3.0297E-26, -3.2011E-26, -2.8817E-26, -3.1019E-26, -2.7078E-26, &
      -2.9575E-26, -2.5286E-26, -2.7989E-26, -2.3418E-26, -2.6340E-26, -2.1736E-26, &
      -2.4577E-26, -2.0079E-26, -2.2945E-26, -1.8599E-26, -2.1481E-26, -1.7097E-26, &
      -2.0110E-26, -1.5828E-26, -1.8797E-26, -1.4630E-26, -1.5168E-26, -1.2249E-26, &
      -1.1100E-26, -9.1114E-27, -8.5225E-27, -7.1048E-27, -6.8661E-27, -5.7741E-27, &
      -6.6526E-27, -6.2201E-27, -5.8467E-27, -5.5280E-27, -5.2432E-27, -4.9887E-27, &
      -4.7480E-27 /)
    REAL, PARAMETER :: b1_2_Br2(dim55) = (/ &
      1.3046E-24, 1.4620E-24, 1.3430E-24, 1.8977E-24, 1.8376E-24, 2.6792E-24, &
      2.6829E-24, 3.5527E-24, 3.5818E-24, 4.2959E-24, 4.3106E-24, 4.8248E-24, &
      4.8299E-24, 5.1357E-24, 5.1479E-24, 5.2980E-24, 5.3176E-24, 5.3407E-24, &
      5.3961E-24, 5.3110E-24, 5.3975E-24, 5.2283E-24, 5.3505E-24, 5.1219E-24, &
      5.2730E-24, 5.0027E-24, 5.1798E-24, 4.8689E-24, 5.0749E-24, 4.7389E-24, &
      4.9533E-24, 4.6025E-24, 4.8332E-24, 4.4725E-24, 4.7189E-24, 4.3332E-24, &
      4.6058E-24, 4.2075E-24, 4.4911E-24, 4.0827E-24, 4.1368E-24, 3.8070E-24, &
      3.6627E-24, 3.3883E-24, 3.2997E-24, 3.0686E-24, 3.0267E-24, 2.8215E-24, &
      2.9976E-24, 2.9055E-24, 2.8213E-24, 2.7454E-24, 2.6741E-24, 2.6071E-24, &
      2.5408E-24 /)
    REAL, PARAMETER :: a2_Br2(dim55) = (/ &
      -8.4440E-23, -7.2520E-23, -5.8280E-23, -4.4360E-23, -3.2480E-23, -2.3280E-23, &
      -1.6440E-23, -1.1680E-23, -8.3200E-24, -6.0400E-24, -4.4800E-24, -3.4000E-24, &
      -2.6400E-24, -2.1200E-24, -1.7200E-24, -1.4000E-24, -1.2400E-24, -1.0400E-24, &
      -9.2000E-25, -8.0004E-25, -7.1999E-25, -6.4001E-25, -5.9999E-25, -5.6000E-25, &
      -4.7999E-25, -4.4001E-25, -3.9998E-25, -4.0002E-25, -3.5999E-25, -3.2001E-25, &
      -3.2001E-25, -2.7998E-25, -2.4000E-25, -2.4000E-25, -2.4000E-25, -2.0001E-25, &
      -2.0001E-25, -2.0001E-25, -1.5998E-25, -1.6002E-25, -1.3600E-25, -9.5998E-26, &
      -7.1999E-26, -4.7999E-26, -3.1997E-26, -3.2005E-26, -1.6002E-26, -1.5994E-26, &
      -8.0052E-27, -7.9972E-27, -0.0000E+00, -7.9972E-27, -0.0000E+00, -0.0000E+00, &
      -8.0052E-27 /)
    REAL, PARAMETER :: b2_Br2(dim55) = (/ &
       2.0601E-21,  2.0244E-21,  1.9460E-21,  1.8347E-21,  1.7099E-21,  1.5903E-21, &
       1.4843E-21,  1.3986E-21,  1.3298E-21,  1.2773E-21,  1.2375E-21,  1.2073E-21, &
       1.1841E-21,  1.1670E-21,  1.1528E-21,  1.1406E-21,  1.1341E-21,  1.1255E-21, &
       1.1201E-21,  1.1143E-21,  1.1103E-21,  1.1060E-21,  1.1038E-21,  1.1015E-21, &
       1.0966E-21,  1.0941E-21,  1.0915E-21,  1.0915E-21,  1.0887E-21,  1.0858E-21, &
       1.0858E-21,  1.0826E-21,  1.0794E-21,  1.0794E-21,  1.0794E-21,  1.0759E-21, &
       1.0759E-21,  1.0759E-21,  1.0721E-21,  1.0721E-21,  1.0697E-21,  1.0651E-21, &
       1.0621E-21,  1.0588E-21,  1.0564E-21,  1.0564E-21,  1.0536E-21,  1.0536E-21, &
       1.0520E-21,  1.0520E-21,  1.0502E-21,  1.0521E-21,  1.0501E-21,  1.0501E-21, &
       1.0523E-21 /)
    REAL, PARAMETER :: a3_Br2(dim55) = (/ &
      8.9464E-26, 1.3220E-25, 1.5976E-25, 1.7295E-25, 1.7572E-25, 1.7093E-25, &
      1.6301E-25, 1.5335E-25, 1.4257E-25, 1.3219E-25, 1.2265E-25, 1.1382E-25, &
      1.0543E-25, 9.7845E-26, 9.1091E-26, 8.5066E-26, 7.9473E-26, 7.3880E-26, &
      6.9915E-26, 6.5496E-26, 6.3101E-26, 5.5907E-26, 5.5933E-26, 5.1919E-26, &
      4.7922E-26, 4.7922E-26, 4.3948E-26, 3.9938E-26, 3.9934E-26, 3.9938E-26, &
      3.5956E-26, 3.5942E-26, 3.1950E-26, 3.1950E-26, 3.1962E-26, 2.7953E-26, &
      2.7957E-26, 2.7953E-26, 2.3971E-26, 2.3961E-26, 2.2364E-26, 1.8371E-26, &
      1.5974E-26, 1.3578E-26, 1.1191E-26, 1.0384E-26, 8.7860E-27, 7.9868E-27, &
      6.3899E-27, 5.5907E-27, 5.5915E-27, 4.7922E-27, 3.9970E-27, 3.1946E-27, &
      3.1954E-27 /)
    REAL, PARAMETER :: b3_Br2(dim55) = (/ &
      9.3957E-22, 9.3847E-22, 9.3708E-22, 9.3608E-22, 9.3580E-22, 9.3641E-22, &
      9.3760E-22, 9.3930E-22, 9.4146E-22, 9.4381E-22, 9.4620E-22, 9.4864E-22, &
      9.5116E-22, 9.5363E-22, 9.5600E-22, 9.5827E-22, 9.6051E-22, 9.6290E-22, &
      9.6469E-22, 9.6679E-22, 9.6799E-22, 9.7178E-22, 9.7176E-22, 9.7408E-22, &
      9.7648E-22, 9.7648E-22, 9.7907E-22, 9.8178E-22, 9.8178E-22, 9.8178E-22, &
      9.8477E-22, 9.8479E-22, 9.8799E-22, 9.8799E-22, 9.8798E-22, 9.9149E-22, &
      9.9149E-22, 9.9149E-22, 9.9528E-22, 9.9529E-22, 9.9689E-22, 1.0014E-21, &
      1.0044E-21, 1.0077E-21, 1.0113E-21, 1.0126E-21, 1.0154E-21, 1.0169E-21, &
      1.0201E-21, 1.0218E-21, 1.0218E-21, 1.0237E-21, 1.0257E-21, 1.0278E-21, &
      1.0278E-21 /)
    REAL, PARAMETER :: a4_Br2(3) = (/ 1.1842E-21, 4.0102E-26, -7.4229E-30 /)
    REAL, PARAMETER :: a5_Br2(3) = (/ 3.1627E-21, 4.3880E-25, -4.4491E-29 /)
    REAL, PARAMETER :: a6_Br2(1) = (/ 3.8293E-19 /)
    REAL, PARAMETER :: a7_Br2(2) = (/ 1.6383E-19, 6.5112E-24 /)

    jval_gp(ip_Br2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_Br2(0) = &
          p1(a0_1_1_Br2(i0(j,k))*dlv2(j,k) + &
          a0_1_2_Br2(i0(j,k)), &
          a0_2_1_Br2(i0(j,k))*dlv2(j,k) + &
          a0_2_2_Br2(i0(j,k)),v3_du1(j,k))
        sig_Br2(1) = &
          (p1(b1_1_Br2(i1(j,k)),a1_1_Br2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_Br2(i1(j,k)),a1_2_Br2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_Br2(2) = &
          p1(b2_Br2(i2(j,k)), a2_Br2(i2(j,k)), &
          v3_du1(j,k))
        sig_Br2(3) = &
          p1(b3_Br2(i3(j,k)), a3_Br2(i3(j,k)), &
          v3_du2(j,k))
        sig_Br2(4) = &
          p2(a4_Br2(1),a4_Br2(2),a4_Br2(3),v3_du2(j,k))
        sig_Br2(5) = &
          p2(a5_Br2(1),a5_Br2(2),a5_Br2(3),v3_du2(j,k))
        sig_Br2(6) = &
          a6_Br2(1)
        sig_Br2(7) = &
          p1(a7_Br2(1),a7_Br2(2),v3_du2(j,k))
        dj = 0. &
          + sig_Br2(0) * fint(j,k,0) &
          + sig_Br2(1) * fint(j,k,1) &
          + sig_Br2(2) * fint(j,k,2) &
          + sig_Br2(3) * fint(j,k,3) &
          + sig_Br2(4) * fint(j,k,4) &
          + sig_Br2(5) * fint(j,k,5) &
          + sig_Br2(6) * fint(j,k,6) &
          + sig_Br2(7) * fint(j,k,7)

        jval_gp(ip_Br2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_Br2

  ! **************************************************************************

  SUBROUTINE jval_cal_CCl4(jrow)

    ! CCl4 -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CCl4

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CCl4(dim58) = (/ &
      -7.3771E-20, -7.9418E-20, -8.5000E-20, -9.1022E-20, -9.6928E-20, -1.0279E-19, &
      -1.0853E-19, -1.1408E-19, -1.1947E-19, -1.2476E-19, -1.2976E-19, -1.3457E-19, &
      -1.4055E-19, -1.4813E-19, -1.5127E-19, -1.5491E-19, -1.5895E-19, -1.5995E-19, &
      -1.6110E-19, -1.6152E-19, -1.5887E-19, -1.5545E-19, -1.5156E-19, -1.4467E-19, &
      -1.3774E-19, -1.2911E-19, -1.2107E-19, -1.1361E-19, -1.0632E-19, -9.9215E-20, &
      -9.2315E-20, -8.5555E-20, -7.8949E-20, -7.2466E-20, -6.6319E-20, -6.0490E-20, &
      -5.5266E-20, -5.0598E-20, -4.6531E-20, -4.3054E-20, -3.9949E-20, -3.7101E-20, &
      -3.4280E-20, -3.1344E-20, -2.8165E-20, -2.4818E-20, -2.1357E-20, -1.7998E-20, &
      -1.4914E-20, -1.2208E-20, -9.9383E-21, -8.0465E-21, -6.4544E-21, -5.1373E-21, &
      -4.0288E-21, -3.1524E-21, -2.4120E-21, -1.9009E-21 /)
    REAL, PARAMETER :: a0_1_2_CCl4(dim58) = (/ &
      4.8472E-18, 5.0968E-18, 5.3446E-18, 5.6132E-18, 5.8778E-18, 6.1414E-18, &
      6.4009E-18, 6.6529E-18, 6.8988E-18, 7.1412E-18, 7.3710E-18, 7.5934E-18, &
      7.8707E-18, 8.2241E-18, 8.3710E-18, 8.5419E-18, 8.7325E-18, 8.7804E-18, &
      8.8350E-18, 8.8552E-18, 8.7279E-18, 8.5628E-18, 8.3744E-18, 8.0395E-18, &
      7.7015E-18, 7.2786E-18, 6.8832E-18, 6.5146E-18, 6.1528E-18, 5.7992E-18, &
      5.4542E-18, 5.1148E-18, 4.7819E-18, 4.4539E-18, 4.1416E-18, 3.8443E-18, &
      3.5769E-18, 3.3369E-18, 3.1271E-18, 2.9470E-18, 2.7855E-18, 2.6369E-18, &
      2.4890E-18, 2.3346E-18, 2.1667E-18, 1.9893E-18, 1.8052E-18, 1.6259E-18, &
      1.4606E-18, 1.3150E-18, 1.1924E-18, 1.0899E-18, 1.0032E-18, 9.3133E-19, &
      8.7058E-19, 8.2238E-19, 7.8151E-19, 7.5320E-19 /)
    REAL, PARAMETER :: a0_2_1_CCl4(dim58) = (/ &
      4.6561E-22, 5.0140E-22, 5.3547E-22, 5.7779E-22, 6.1561E-22, 6.5316E-22, &
      6.9181E-22, 7.2857E-22, 7.6387E-22, 8.0175E-22, 8.3428E-22, 8.6766E-22, &
      9.4287E-22, 1.0926E-21, 1.0732E-21, 1.0890E-21, 1.1353E-21, 1.1007E-21, &
      1.0968E-21, 1.1071E-21, 1.0504E-21, 1.0100E-21, 9.8291E-22, 9.0091E-22, &
      8.3731E-22, 7.4227E-22, 6.7072E-22, 6.1592E-22, 5.6386E-22, 5.1404E-22, &
      4.6734E-22, 4.2287E-22, 3.8088E-22, 3.4045E-22, 3.0295E-22, 2.6809E-22, &
      2.3754E-22, 2.1068E-22, 1.8788E-22, 1.6916E-22, 1.5292E-22, 1.3857E-22, &
      1.2505E-22, 1.1168E-22, 9.7510E-23, 8.3209E-23, 6.8879E-23, 5.5222E-23, &
      4.3383E-23, 3.3210E-23, 2.5143E-23, 1.8863E-23, 1.3521E-23, 9.7089E-24, &
      6.4942E-24, 4.3899E-24, 2.8342E-24, 1.9449E-24 /)
    REAL, PARAMETER :: a0_2_2_CCl4(dim58) = (/ &
      -2.6200E-20, -2.7782E-20, -2.9295E-20, -3.1182E-20, -3.2877E-20, -3.4566E-20, &
      -3.6313E-20, -3.7982E-20, -3.9592E-20, -4.1327E-20, -4.2823E-20, -4.4365E-20, &
      -4.7855E-20, -5.4832E-20, -5.3926E-20, -5.4668E-20, -5.6851E-20, -5.5212E-20, &
      -5.5028E-20, -5.5517E-20, -5.2798E-20, -5.0851E-20, -4.9539E-20, -4.5554E-20, &
      -4.2450E-20, -3.7793E-20, -3.4273E-20, -3.1566E-20, -2.8984E-20, -2.6503E-20, &
      -2.4168E-20, -2.1935E-20, -1.9819E-20, -1.7773E-20, -1.5868E-20, -1.4091E-20, &
      -1.2526E-20, -1.1146E-20, -9.9693E-21, -8.9994E-21, -8.1550E-21, -7.4060E-21, &
      -6.6974E-21, -5.9943E-21, -5.2461E-21, -4.4881E-21, -3.7257E-21, -2.9964E-21, &
      -2.3619E-21, -1.8146E-21, -1.3789E-21, -1.0386E-21, -7.4800E-22, -5.3985E-22, &
      -3.6369E-22, -2.4794E-22, -1.6207E-22, -1.1281E-22 /)
    REAL, PARAMETER :: a0_3_1_CCl4(dim58) = (/ &
      -8.8813E-25, -9.5669E-25, -1.0202E-24, -1.1177E-24, -1.1921E-24, -1.2666E-24, &
      -1.3510E-24, -1.4279E-24, -1.5018E-24, -1.5920E-24, -1.6596E-24, -1.7374E-24, &
      -2.0694E-24, -2.8474E-24, -2.5890E-24, -2.5661E-24, -2.7219E-24, -2.4663E-24, &
      -2.4042E-24, -2.4482E-24, -2.1910E-24, -2.0574E-24, -2.0073E-24, -1.7415E-24, &
      -1.5781E-24, -1.2974E-24, -1.1234E-24, -1.0187E-24, -9.2114E-25, -8.2790E-25, &
      -7.4239E-25, -6.6213E-25, -5.8776E-25, -5.1665E-25, -4.5146E-25, -3.9135E-25, &
      -3.3954E-25, -2.9423E-25, -2.5660E-25, -2.2675E-25, -2.0140E-25, -1.7955E-25, &
      -1.5986E-25, -1.4123E-25, -1.2156E-25, -1.0215E-25, -8.3039E-26, -6.4859E-26, &
      -4.9696E-26, -3.6748E-26, -2.6694E-26, -1.9658E-26, -1.2782E-26, -9.0123E-27, &
      -5.3583E-27, -3.3784E-27, -1.9658E-27, -6.6170E-28 /)
    REAL, PARAMETER :: a0_3_2_CCl4(dim58) = (/ &
      5.0334E-23, 5.3364E-23, 5.6183E-23, 6.0531E-23, 6.3867E-23, 6.7218E-23, &
      7.1034E-23, 7.4527E-23, 7.7894E-23, 8.2027E-23, 8.5134E-23, 8.8732E-23, &
      1.0413E-22, 1.4039E-22, 1.2829E-22, 1.2722E-22, 1.3458E-22, 1.2246E-22, &
      1.1950E-22, 1.2160E-22, 1.0926E-22, 1.0282E-22, 1.0039E-22, 8.7476E-23, &
      7.9505E-23, 6.5751E-23, 5.7191E-23, 5.2018E-23, 4.7177E-23, 4.2534E-23, &
      3.8259E-23, 3.4230E-23, 3.0481E-23, 2.6883E-23, 2.3571E-23, 2.0506E-23, &
      1.7853E-23, 1.5524E-23, 1.3582E-23, 1.2036E-23, 1.0718E-23, 9.5777E-24, &
      8.5456E-24, 7.5658E-24, 6.5273E-24, 5.4983E-24, 4.4818E-24, 3.5110E-24, &
      2.6982E-24, 2.0016E-24, 1.4587E-24, 1.0774E-24, 7.0327E-25, 4.9747E-25, &
      2.9723E-25, 1.8834E-25, 1.1036E-25, 3.8113E-26 /)
    REAL, PARAMETER :: a1_1_CCl4(dim55) = (/ &
      8.4093E-21, 8.1641E-21, 8.0705E-21, 7.5080E-21, 7.1335E-21, 6.5073E-21, &
      6.0526E-21, 5.5049E-21, 5.0766E-21, 4.6505E-21, 4.2822E-21, 3.9639E-21, &
      3.6564E-21, 3.4218E-21, 3.1601E-21, 2.9924E-21, 2.7672E-21, 2.6440E-21, &
      2.4459E-21, 2.3587E-21, 2.1821E-21, 2.1199E-21, 1.9611E-21, 1.9222E-21, &
      1.7738E-21, 1.7502E-21, 1.6144E-21, 1.6032E-21, 1.4785E-21, 1.4749E-21, &
      1.3595E-21, 1.3656E-21, 1.2556E-21, 1.2670E-21, 1.1650E-21, 1.1825E-21, &
      1.0843E-21, 1.1072E-21, 1.0127E-21, 1.0395E-21, 9.1722E-22, 8.0836E-22, &
      7.0275E-22, 6.3670E-22, 5.6278E-22, 5.1961E-22, 4.6399E-22, 4.3446E-22, &
      3.6928E-22, 3.3925E-22, 3.1207E-22, 2.8756E-22, 2.6564E-22, 2.4569E-22, &
      2.2745E-22 /)
    REAL, PARAMETER :: b1_1_CCl4(dim55) = (/ &
      1.3938E-19, 1.4012E-19, 1.4063E-19, 1.4513E-19, 1.4906E-19, 1.5720E-19, &
      1.6425E-19, 1.7411E-19, 1.8289E-19, 1.9269E-19, 2.0208E-19, 2.1099E-19, &
      2.2038E-19, 2.2811E-19, 2.3741E-19, 2.4378E-19, 2.5290E-19, 2.5820E-19, &
      2.6721E-19, 2.7139E-19, 2.8032E-19, 2.8361E-19, 2.9243E-19, 2.9468E-19, &
      3.0366E-19, 3.0515E-19, 3.1404E-19, 3.1480E-19, 3.2359E-19, 3.2386E-19, &
      3.3257E-19, 3.3209E-19, 3.4095E-19, 3.4000E-19, 3.4872E-19, 3.4718E-19, &
      3.5607E-19, 3.5394E-19, 3.6297E-19, 3.6034E-19, 3.7263E-19, 3.8493E-19, &
      3.9818E-19, 4.0730E-19, 4.1842E-19, 4.2546E-19, 4.3522E-19, 4.4077E-19, &
      4.5384E-19, 4.6024E-19, 4.6637E-19, 4.7220E-19, 4.7769E-19, 4.8294E-19, &
      4.8796E-19 /)
    REAL, PARAMETER :: a1_2_CCl4(dim55) = (/ &
      -2.0991E-23, -1.1220E-23, -1.0327E-23, -2.1818E-24, -1.1146E-24, 3.9473E-24, &
      4.5100E-24, 6.9021E-24, 7.1084E-24, 7.7412E-24, 7.8188E-24, 7.5564E-24, &
      7.6545E-24, 6.9582E-24, 7.1679E-24, 6.2479E-24, 6.5599E-24, 5.5855E-24, &
      5.9870E-24, 4.9826E-24, 5.4468E-24, 4.4636E-24, 4.9653E-24, 3.9873E-24, &
      4.5310E-24, 3.5979E-24, 4.1436E-24, 3.2527E-24, 3.7811E-24, 2.9477E-24, &
      3.4747E-24, 2.6729E-24, 3.1952E-24, 2.4379E-24, 2.9423E-24, 2.2214E-24, &
      2.7232E-24, 2.0242E-24, 2.5213E-24, 1.8569E-24, 1.9663E-24, 1.5467E-24, &
      1.3914E-24, 1.1166E-24, 1.0420E-24, 8.5015E-25, 8.1803E-25, 6.7476E-25, &
      7.8393E-25, 7.1810E-25, 6.6276E-25, 6.1525E-25, 5.7320E-25, 5.3609E-25, &
      5.0286E-25 /)
    REAL, PARAMETER :: b1_2_CCl4(dim55) = (/ &
      -5.6083E-22, -5.9014E-22, -5.9505E-22, -6.6021E-22, -6.7142E-22, -7.3722E-22, &
      -7.4594E-22, -7.8900E-22, -7.9323E-22, -8.0779E-22, -8.0977E-22, -8.0242E-22, &
      -8.0541E-22, -7.8243E-22, -7.8988E-22, -7.5492E-22, -7.6755E-22, -7.2565E-22, &
      -7.4392E-22, -6.9571E-22, -7.1915E-22, -6.6704E-22, -6.9488E-22, -6.3816E-22, &
      -6.7106E-22, -6.1227E-22, -6.4801E-22, -5.8743E-22, -6.2469E-22, -5.6385E-22, &
      -6.0363E-22, -5.4110E-22, -5.8314E-22, -5.2028E-22, -5.6341E-22, -4.9997E-22, &
      -5.4539E-22, -4.8038E-22, -5.2785E-22, -4.6274E-22, -4.7373E-22, -4.2632E-22, &
      -4.0684E-22, -3.6891E-22, -3.5768E-22, -3.2641E-22, -3.2077E-22, -2.9384E-22, &
      -3.1573E-22, -3.0170E-22, -2.8922E-22, -2.7792E-22, -2.6738E-22, -2.5762E-22, &
      -2.4847E-22 /)

    jval_gp(ip_CCl4)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CCl4(0) = &
          p2(a0_1_1_CCl4(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CCl4(i0(j,k)), &
          a0_2_1_CCl4(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CCl4(i0(j,k)), &
          a0_3_1_CCl4(i0(j,k))*dlv2(j,k) + &
          a0_3_2_CCl4(i0(j,k)), v3_du1(j,k))
        sig_CCl4(1) = &
          (p1(b1_1_CCl4(i1(j,k)),a1_1_CCl4(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CCl4(i1(j,k)),a1_2_CCl4(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        dj = 0. &
          + sig_CCl4(0) * fint(j,k,0) &
          + sig_CCl4(1) * fint(j,k,1)

        jval_gp(ip_CCl4)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CCl4

  ! **************************************************************************

  SUBROUTINE jval_cal_CH3Cl(jrow)

    ! CH3Cl -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH3Cl

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CH3Cl(dim58) = (/ &
      -3.0179E-21, -3.2744E-21, -3.5423E-21, -3.8200E-21, -4.1048E-21, -4.3919E-21, &
      -4.6848E-21, -4.9802E-21, -5.2791E-21, -5.5802E-21, -5.8876E-21, -6.2013E-21, &
      -6.5554E-21, -6.9827E-21, -7.2660E-21, -7.5777E-21, -7.9151E-21, -8.1522E-21, &
      -8.4019E-21, -8.6581E-21, -8.7903E-21, -8.9265E-21, -9.0557E-21, -9.0679E-21, &
      -9.0823E-21, -8.9976E-21, -8.9250E-21, -8.8562E-21, -8.7540E-21, -8.6164E-21, &
      -8.4373E-21, -8.2195E-21, -7.9670E-21, -7.6829E-21, -7.3885E-21, -7.0859E-21, &
      -6.8025E-21, -6.5394E-21, -6.3081E-21, -6.1078E-21, -5.9288E-21, -5.7572E-21, &
      -5.5737E-21, -5.3584E-21, -5.0915E-21, -4.7720E-21, -4.4021E-21, -4.0050E-21, &
      -3.6015E-21, -3.2135E-21, -2.8531E-21, -2.5237E-21, -2.2193E-21, -1.9302E-21, &
      -1.6563E-21, -1.3957E-21, -1.1341E-21, -9.2909E-22 /)
    REAL, PARAMETER :: a0_1_2_CH3Cl(dim58) = (/ &
      2.2085E-19, 2.3219E-19, 2.4408E-19, 2.5647E-19, 2.6923E-19, 2.8215E-19, &
      2.9538E-19, 3.0880E-19, 3.2243E-19, 3.3622E-19, 3.5036E-19, 3.6485E-19, &
      3.8128E-19, 4.0119E-19, 4.1445E-19, 4.2910E-19, 4.4503E-19, 4.5627E-19, &
      4.6815E-19, 4.8040E-19, 4.8674E-19, 4.9331E-19, 4.9956E-19, 5.0016E-19, &
      5.0086E-19, 4.9671E-19, 4.9314E-19, 4.8974E-19, 4.8467E-19, 4.7781E-19, &
      4.6886E-19, 4.5793E-19, 4.4520E-19, 4.3083E-19, 4.1587E-19, 4.0044E-19, &
      3.8593E-19, 3.7240E-19, 3.6047E-19, 3.5009E-19, 3.4078E-19, 3.3183E-19, &
      3.2221E-19, 3.1089E-19, 2.9680E-19, 2.7986E-19, 2.6018E-19, 2.3898E-19, &
      2.1735E-19, 1.9648E-19, 1.7701E-19, 1.5916E-19, 1.4260E-19, 1.2681E-19, &
      1.1181E-19, 9.7470E-20, 8.3034E-20, 7.1674E-20 /)
    REAL, PARAMETER :: a0_2_1_CH3Cl(dim58) = (/ &
      1.6053E-23, 1.7340E-23, 1.8672E-23, 2.0118E-23, 2.1595E-23, 2.3058E-23, &
      2.4563E-23, 2.6095E-23, 2.7637E-23, 2.9131E-23, 3.0738E-23, 3.2370E-23, &
      3.5433E-23, 4.1331E-23, 4.1420E-23, 4.2862E-23, 4.5548E-23, 4.5230E-23, &
      4.6067E-23, 4.7915E-23, 4.6777E-23, 4.6699E-23, 4.7291E-23, 4.5403E-23, &
      4.4380E-23, 4.1447E-23, 3.9554E-23, 3.8455E-23, 3.7217E-23, 3.5844E-23, &
      3.4297E-23, 3.2648E-23, 3.0873E-23, 2.9000E-23, 2.7141E-23, 2.5313E-23, &
      2.3599E-23, 2.2043E-23, 2.0674E-23, 1.9490E-23, 1.8443E-23, 1.7426E-23, &
      1.6411E-23, 1.5302E-23, 1.4004E-23, 1.2571E-23, 1.1016E-23, 9.4319E-24, &
      7.9459E-24, 6.5804E-24, 5.3948E-24, 4.3942E-24, 3.5386E-24, 2.7591E-24, &
      2.1105E-24, 1.5759E-24, 1.1307E-24, 9.1441E-25 /)
    REAL, PARAMETER :: a0_2_2_CH3Cl(dim58) = (/ &
      -1.0032E-21, -1.0600E-21, -1.1192E-21, -1.1837E-21, -1.2498E-21, -1.3157E-21, &
      -1.3837E-21, -1.4533E-21, -1.5236E-21, -1.5920E-21, -1.6659E-21, -1.7413E-21, &
      -1.8834E-21, -2.1583E-21, -2.1624E-21, -2.2302E-21, -2.3570E-21, -2.3419E-21, &
      -2.3818E-21, -2.4701E-21, -2.4155E-21, -2.4117E-21, -2.4404E-21, -2.3486E-21, &
      -2.2987E-21, -2.1550E-21, -2.0618E-21, -2.0075E-21, -1.9461E-21, -1.8778E-21, &
      -1.8004E-21, -1.7176E-21, -1.6282E-21, -1.5334E-21, -1.4390E-21, -1.3457E-21, &
      -1.2580E-21, -1.1780E-21, -1.1073E-21, -1.0460E-21, -9.9156E-22, -9.3847E-22, &
      -8.8531E-22, -8.2696E-22, -7.5842E-22, -6.8247E-22, -5.9977E-22, -5.1517E-22, &
      -4.3552E-22, -3.6206E-22, -2.9804E-22, -2.4380E-22, -1.9726E-22, -1.5470E-22, &
      -1.1916E-22, -8.9753E-23, -6.5181E-23, -5.3196E-23 /)
    REAL, PARAMETER :: a0_3_1_CH3Cl(dim58) = (/ &
      -2.5714E-26, -2.7779E-26, -2.9841E-26, -3.2316E-26, -3.4933E-26, -3.7399E-26, &
      -4.0044E-26, -4.2859E-26, -4.5683E-26, -4.8250E-26, -5.1387E-26, -5.4576E-26, &
      -6.6573E-26, -9.5240E-26, -8.8049E-26, -8.9482E-26, -9.7948E-26, -9.0628E-26, &
      -9.0480E-26, -9.5942E-26, -8.7757E-26, -8.5713E-26, -8.7585E-26, -7.9112E-26, &
      -7.5372E-26, -6.4352E-26, -5.8358E-26, -5.6110E-26, -5.3667E-26, -5.1066E-26, &
      -4.8176E-26, -4.5268E-26, -4.2175E-26, -3.8967E-26, -3.5858E-26, -3.2857E-26, &
      -3.0023E-26, -2.7522E-26, -2.5337E-26, -2.3502E-26, -2.1950E-26, -2.0412E-26, &
      -1.8976E-26, -1.7480E-26, -1.5679E-26, -1.3808E-26, -1.1785E-26, -9.7578E-27, &
      -7.9696E-27, -6.2940E-27, -4.9138E-27, -3.8071E-27, -2.8996E-27, -2.0577E-27, &
      -1.4304E-27, -9.5374E-28, -5.7494E-28, -5.5864E-28 /)
    REAL, PARAMETER :: a0_3_2_CH3Cl(dim58) = (/ &
      1.6111E-24, 1.7024E-24, 1.7939E-24, 1.9043E-24, 2.0216E-24, 2.1325E-24, &
      2.2521E-24, 2.3798E-24, 2.5086E-24, 2.6262E-24, 2.7705E-24, 2.9178E-24, &
      3.4745E-24, 4.8104E-24, 4.4738E-24, 4.5412E-24, 4.9408E-24, 4.5938E-24, &
      4.5868E-24, 4.8479E-24, 4.4550E-24, 4.3564E-24, 4.4471E-24, 4.0353E-24, &
      3.8528E-24, 3.3128E-24, 3.0179E-24, 2.9069E-24, 2.7856E-24, 2.6561E-24, &
      2.5116E-24, 2.3656E-24, 2.2097E-24, 2.0475E-24, 1.8895E-24, 1.7364E-24, &
      1.5914E-24, 1.4628E-24, 1.3500E-24, 1.2550E-24, 1.1743E-24, 1.0940E-24, &
      1.0188E-24, 9.4007E-25, 8.4500E-25, 7.4581E-25, 6.3820E-25, 5.2994E-25, &
      4.3409E-25, 3.4395E-25, 2.6941E-25, 2.0943E-25, 1.6006E-25, 1.1409E-25, &
      7.9720E-26, 5.3502E-26, 3.2592E-26, 3.1689E-26 /)
    REAL, PARAMETER :: a1_1_CH3Cl(dim55) = (/ &
      3.4654E-23, 3.5209E-23, 3.7951E-23, 3.6807E-23, 3.8250E-23, 3.6132E-23, &
      3.6827E-23, 3.4394E-23, 3.4777E-23, 3.2397E-23, 3.2679E-23, 3.0494E-23, &
      3.0753E-23, 2.8780E-23, 2.9055E-23, 2.7261E-23, 2.7549E-23, 2.5927E-23, &
      2.6197E-23, 2.4734E-23, 2.5018E-23, 2.3655E-23, 2.3949E-23, 2.2704E-23, &
      2.2966E-23, 2.1824E-23, 2.2091E-23, 2.1025E-23, 2.1283E-23, 2.0309E-23, &
      2.0558E-23, 1.9624E-23, 1.9885E-23, 1.9015E-23, 1.9255E-23, 1.8455E-23, &
      1.8684E-23, 1.7946E-23, 1.8132E-23, 1.7455E-23, 1.7026E-23, 1.5941E-23, &
      1.5122E-23, 1.4295E-23, 1.3631E-23, 1.2970E-23, 1.2390E-23, 1.1846E-23, &
      1.1245E-23, 1.0674E-23, 1.0134E-23, 9.6267E-24, 9.1446E-24, 8.6917E-24, &
      8.2647E-24 /)
    REAL, PARAMETER :: b1_1_CH3Cl(dim55) = (/ &
      3.7164E-22, 3.6997E-22, 3.5489E-22, 3.6404E-22, 3.4889E-22, 3.7643E-22, &
      3.6565E-22, 4.0945E-22, 4.0159E-22, 4.5634E-22, 4.4915E-22, 5.1033E-22, &
      5.0241E-22, 5.6753E-22, 5.5777E-22, 6.2592E-22, 6.1428E-22, 6.8404E-22, &
      6.7171E-22, 7.4193E-22, 7.2762E-22, 7.9984E-22, 7.8356E-22, 8.5572E-22, &
      8.3991E-22, 9.1181E-22, 8.9435E-22, 9.6684E-22, 9.4865E-22, 1.0197E-21, &
      1.0010E-21, 1.0738E-21, 1.0528E-21, 1.1250E-21, 1.1045E-21, 1.1749E-21, &
      1.1542E-21, 1.2228E-21, 1.2051E-21, 1.2714E-21, 1.3145E-21, 1.4371E-21, &
      1.5398E-21, 1.6540E-21, 1.7540E-21, 1.8617E-21, 1.9635E-21, 2.0658E-21, &
      2.1862E-21, 2.3080E-21, 2.4296E-21, 2.5504E-21, 2.6711E-21, 2.7903E-21, &
      2.9079E-21 /)
    REAL, PARAMETER :: a1_2_CH3Cl(dim55) = (/ &
      -1.6303E-25, -1.1481E-25, -1.3837E-25, -8.4640E-26, -1.0411E-25, -5.4715E-26, &
      -7.3202E-26, -3.1940E-26, -5.0190E-26, -1.6824E-26, -3.4362E-26, -7.3451E-27, &
      -2.3648E-26, -1.2592E-27, -1.6321E-26, 2.5655E-27, -1.1031E-26, 5.0820E-27, &
      -7.0622E-27, 6.7781E-27, -4.2270E-27, 7.9820E-27, -2.0615E-27, 8.6230E-27, &
      -3.3448E-28, 9.1077E-27, 9.8024E-28, 9.3062E-27, 2.0020E-27, 9.3636E-27, &
      2.7012E-27, 9.4813E-27, 3.2444E-27, 9.3471E-27, 3.7444E-27, 9.2145E-27, &
      4.0902E-27, 8.9307E-27, 4.4271E-27, 8.7947E-27, 6.2506E-27, 6.7990E-27, &
      6.1435E-27, 6.3910E-27, 6.0064E-27, 6.0726E-27, 5.9304E-27, 5.8523E-27, &
      6.2993E-27, 6.7242E-27, 7.0869E-27, 7.3865E-27, 7.6366E-27, 7.8112E-27, &
      7.9408E-27 /)
    REAL, PARAMETER :: b1_2_CH3Cl(dim55) = (/ &
      -2.3469E-24, -2.4916E-24, -2.3620E-24, -2.7919E-24, -2.5874E-24, -3.2295E-24, &
      -2.9430E-24, -3.6857E-24, -3.3116E-24, -4.0790E-24, -3.6318E-24, -4.3883E-24, &
      -3.8910E-24, -4.6299E-24, -4.0952E-24, -4.8129E-24, -4.2622E-24, -4.9551E-24, &
      -4.4025E-24, -5.0668E-24, -4.5111E-24, -5.1581E-24, -4.6007E-24, -5.2204E-24, &
      -4.6785E-24, -5.2734E-24, -4.7410E-24, -5.3072E-24, -4.7922E-24, -5.3296E-24, &
      -4.8266E-24, -5.3555E-24, -4.8534E-24, -5.3599E-24, -4.8809E-24, -5.3623E-24, &
      -4.8985E-24, -5.3487E-24, -4.9186E-24, -5.3466E-24, -5.0909E-24, -5.1529E-24, &
      -5.0706E-24, -5.1048E-24, -5.0469E-24, -5.0577E-24, -5.0327E-24, -5.0180E-24, &
      -5.1077E-24, -5.1982E-24, -5.2800E-24, -5.3513E-24, -5.4139E-24, -5.4598E-24, &
      -5.4955E-24 /)
    ! T-dep parameters:

    jval_gp(ip_CH3Cl)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH3Cl(0) = &
          p2(a0_1_1_CH3Cl(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CH3Cl(i0(j,k)), &
          a0_2_1_CH3Cl(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CH3Cl(i0(j,k)), &
          a0_3_1_CH3Cl(i0(j,k))*dlv2(j,k) + &
          a0_3_2_CH3Cl(i0(j,k)), v3_du1(j,k))
        sig_CH3Cl(1) = &
          (p1(b1_1_CH3Cl(i1(j,k)),a1_1_CH3Cl(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CH3Cl(i1(j,k)),a1_2_CH3Cl(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        dj = 0. &
          + sig_CH3Cl(0) * fint(j,k,0) &
          + sig_CH3Cl(1) * fint(j,k,1)

        jval_gp(ip_CH3Cl)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CH3Cl

  ! **************************************************************************

  SUBROUTINE jval_cal_CH3CCl3(jrow)

    ! CH3CCl3 -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH3CCl3

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CH3CCl3(dim58) = (/ &
      -2.0841E-20, -2.2618E-20, -2.4572E-20, -2.6549E-20, -2.8635E-20, -3.0635E-20, &
      -3.2870E-20, -3.5078E-20, -3.7165E-20, -3.9574E-20, -4.1820E-20, -4.4294E-20, &
      -4.8682E-20, -5.6968E-20, -5.7176E-20, -5.9326E-20, -6.3308E-20, -6.3333E-20, &
      -6.5025E-20, -6.8389E-20, -6.7917E-20, -6.9124E-20, -7.1567E-20, -7.0775E-20, &
      -7.1393E-20, -6.9434E-20, -6.9004E-20, -6.9725E-20, -7.0234E-20, -7.0510E-20, &
      -7.0554E-20, -7.0316E-20, -6.9709E-20, -6.8980E-20, -6.7943E-20, -6.6886E-20, &
      -6.5831E-20, -6.5111E-20, -6.4409E-20, -6.3944E-20, -6.3795E-20, -6.3560E-20, &
      -6.3280E-20, -6.2644E-20, -6.1454E-20, -5.9634E-20, -5.7086E-20, -5.4022E-20, &
      -5.0551E-20, -4.6930E-20, -4.3317E-20, -3.9777E-20, -3.6249E-20, -3.2734E-20, &
      -2.9128E-20, -2.5371E-20, -2.1256E-20, -1.7601E-20 /)
    REAL, PARAMETER :: a0_1_2_CH3CCl3(dim58) = (/ &
      2.3941E-18, 2.4726E-18, 2.5594E-18, 2.6476E-18, 2.7410E-18, 2.8310E-18, &
      2.9321E-18, 3.0323E-18, 3.1274E-18, 3.2378E-18, 3.3411E-18, 3.4554E-18, &
      3.6590E-18, 4.0451E-18, 4.0548E-18, 4.1559E-18, 4.3439E-18, 4.3450E-18, &
      4.4256E-18, 4.5864E-18, 4.5637E-18, 4.6219E-18, 4.7401E-18, 4.7016E-18, &
      4.7318E-18, 4.6358E-18, 4.6147E-18, 4.6503E-18, 4.6755E-18, 4.6893E-18, &
      4.6915E-18, 4.6795E-18, 4.6489E-18, 4.6121E-18, 4.5594E-18, 4.5055E-18, &
      4.4514E-18, 4.4144E-18, 4.3782E-18, 4.3541E-18, 4.3464E-18, 4.3341E-18, &
      4.3195E-18, 4.2860E-18, 4.2232E-18, 4.1267E-18, 3.9911E-18, 3.8275E-18, &
      3.6415E-18, 3.4467E-18, 3.2516E-18, 3.0597E-18, 2.8678E-18, 2.6759E-18, &
      2.4783E-18, 2.2716E-18, 2.0445E-18, 1.8420E-18 /)
    REAL, PARAMETER :: a0_2_1_CH3CCl3(dim58) = (/ &
      7.7740E-23, 8.3580E-23, 9.0852E-23, 9.6562E-23, 1.0475E-22, 1.1054E-22, &
      1.1824E-22, 1.2566E-22, 1.3142E-22, 1.3955E-22, 1.4643E-22, 1.5376E-22, &
      1.9022E-22, 2.8145E-22, 2.5157E-22, 2.5125E-22, 2.7472E-22, 2.4788E-22, &
      2.4536E-22, 2.6241E-22, 2.3708E-22, 2.3309E-22, 2.4327E-22, 2.2076E-22, &
      2.1423E-22, 1.8349E-22, 1.6917E-22, 1.6809E-22, 1.6593E-22, 1.6325E-22, &
      1.6023E-22, 1.5694E-22, 1.5207E-22, 1.4750E-22, 1.4217E-22, 1.3687E-22, &
      1.3173E-22, 1.2771E-22, 1.2353E-22, 1.1992E-22, 1.1739E-22, 1.1422E-22, &
      1.1106E-22, 1.0692E-22, 1.0149E-22, 9.4822E-23, 8.6867E-23, 7.8202E-23, &
      6.9244E-23, 6.0697E-23, 5.2709E-23, 4.5503E-23, 3.8695E-23, 3.2505E-23, &
      2.6619E-23, 2.1191E-23, 1.6440E-23, 1.3101E-23 /)
    REAL, PARAMETER :: a0_2_2_CH3CCl3(dim58) = (/ &
      -5.0591E-21, -5.3173E-21, -5.6402E-21, -5.8948E-21, -6.2617E-21, -6.5221E-21, &
      -6.8701E-21, -7.2070E-21, -7.4697E-21, -7.8421E-21, -8.1588E-21, -8.4972E-21, &
      -1.0189E-20, -1.4440E-20, -1.3042E-20, -1.3027E-20, -1.4135E-20, -1.2863E-20, &
      -1.2743E-20, -1.3557E-20, -1.2341E-20, -1.2149E-20, -1.2642E-20, -1.1548E-20, &
      -1.1230E-20, -9.7231E-21, -9.0188E-21, -8.9653E-21, -8.8582E-21, -8.7248E-21, &
      -8.5736E-21, -8.4087E-21, -8.1633E-21, -7.9319E-21, -7.6608E-21, -7.3907E-21, &
      -7.1277E-21, -6.9210E-21, -6.7052E-21, -6.5184E-21, -6.3866E-21, -6.2212E-21, &
      -6.0554E-21, -5.8379E-21, -5.5511E-21, -5.1977E-21, -4.7746E-21, -4.3118E-21, &
      -3.8317E-21, -3.3719E-21, -2.9405E-21, -2.5499E-21, -2.1796E-21, -1.8416E-21, &
      -1.5190E-21, -1.2205E-21, -9.5827E-22, -7.7329E-22 /)
    REAL, PARAMETER :: a1_1_CH3CCl3(dim55) = (/ &
      3.9991E-21, 3.9825E-21, 4.1231E-21, 3.9293E-21, 3.9221E-21, 3.6522E-21, &
      3.5774E-21, 3.3063E-21, 3.2163E-21, 2.9793E-21, 2.8930E-21, 2.6957E-21, &
      2.6211E-21, 2.4547E-21, 2.3960E-21, 2.2567E-21, 2.2046E-21, 2.0873E-21, &
      2.0432E-21, 1.9417E-21, 1.9044E-21, 1.8183E-21, 1.7814E-21, 1.7097E-21, &
      1.6770E-21, 1.6118E-21, 1.5821E-21, 1.5271E-21, 1.5010E-21, 1.4516E-21, &
      1.4240E-21, 1.3839E-21, 1.3567E-21, 1.3220E-21, 1.2969E-21, 1.2670E-21, &
      1.2428E-21, 1.2149E-21, 1.1922E-21, 1.1697E-21, 1.1064E-21, 1.0164E-21, &
      9.3936E-22, 8.7678E-22, 8.1781E-22, 7.7107E-22, 7.2250E-22, 6.8652E-22, &
      6.3266E-22, 5.9463E-22, 5.6000E-22, 5.2742E-22, 4.9716E-22, 4.6935E-22, &
      4.4331E-22 /)
    REAL, PARAMETER :: b1_1_CH3CCl3(dim55) = (/ &
      5.1346E-20, 5.1396E-20, 5.0623E-20, 5.2173E-20, 5.2249E-20, 5.5758E-20, &
      5.6917E-20, 6.1797E-20, 6.3642E-20, 6.9093E-20, 7.1294E-20, 7.6818E-20, &
      7.9092E-20, 8.4585E-20, 8.6668E-20, 9.1960E-20, 9.4072E-20, 9.9115E-20, &
      1.0112E-19, 1.0599E-19, 1.0788E-19, 1.1244E-19, 1.1449E-19, 1.1865E-19, &
      1.2063E-19, 1.2473E-19, 1.2668E-19, 1.3042E-19, 1.3226E-19, 1.3587E-19, &
      1.3795E-19, 1.4108E-19, 1.4327E-19, 1.4614E-19, 1.4829E-19, 1.5092E-19, &
      1.5311E-19, 1.5571E-19, 1.5787E-19, 1.6008E-19, 1.6644E-19, 1.7661E-19, &
      1.8628E-19, 1.9492E-19, 2.0379E-19, 2.1141E-19, 2.1994E-19, 2.2670E-19, &
      2.3750E-19, 2.4560E-19, 2.5341E-19, 2.6116E-19, 2.6874E-19, 2.7606E-19, &
      2.8323E-19 /)
    REAL, PARAMETER :: a1_2_CH3CCl3(dim55) = (/ &
      -1.4592E-23, -9.4657E-24, -1.0525E-23, -5.4679E-24, -6.2146E-24, -2.1559E-24, &
      -2.9408E-24, -3.5836E-26, -8.9460E-25, 1.0864E-24, 2.6162E-25, 1.6225E-24, &
      8.7206E-25, 1.8498E-24, 1.1608E-24, 1.8903E-24, 1.3319E-24, 1.8704E-24, &
      1.3958E-24, 1.8187E-24, 1.4172E-24, 1.7312E-24, 1.4280E-24, 1.6418E-24, &
      1.3894E-24, 1.5680E-24, 1.3589E-24, 1.4792E-24, 1.3056E-24, 1.3927E-24, &
      1.2686E-24, 1.3162E-24, 1.2199E-24, 1.2418E-24, 1.1700E-24, 1.1701E-24, &
      1.1176E-24, 1.1114E-24, 1.0761E-24, 1.0462E-24, 9.8060E-25, 8.7126E-25, &
      7.9753E-25, 7.1196E-25, 6.7410E-25, 6.0598E-25, 5.9285E-25, 5.3253E-25, &
      6.0297E-25, 5.9730E-25, 5.8982E-25, 5.8399E-25, 5.7721E-25, 5.6868E-25, &
      5.5901E-25 /)
    REAL, PARAMETER :: b1_2_CH3CCl3(dim55) = (/ &
      -2.6822E-22, -2.8360E-22, -2.7777E-22, -3.1823E-22, -3.1039E-22, -3.6315E-22, &
      -3.5099E-22, -4.0328E-22, -3.8567E-22, -4.3123E-22, -4.1020E-22, -4.4831E-22, &
      -4.2542E-22, -4.5769E-22, -4.3322E-22, -4.6094E-22, -4.3833E-22, -4.6149E-22, &
      -4.3989E-22, -4.6019E-22, -4.3991E-22, -4.5656E-22, -4.3973E-22, -4.5213E-22, &
      -4.3686E-22, -4.4811E-22, -4.3442E-22, -4.4259E-22, -4.3036E-22, -4.3672E-22, &
      -4.2735E-22, -4.3106E-22, -4.2331E-22, -4.2512E-22, -4.1898E-22, -4.1899E-22, &
      -4.1424E-22, -4.1366E-22, -4.1030E-22, -4.0737E-22, -4.0077E-22, -3.8842E-22, &
      -3.7916E-22, -3.6735E-22, -3.6166E-22, -3.5055E-22, -3.4825E-22, -3.3691E-22, &
      -3.5103E-22, -3.4982E-22, -3.4814E-22, -3.4675E-22, -3.4505E-22, -3.4281E-22, &
      -3.4014E-22 /)
    ! T-dep parameters:

    jval_gp(ip_CH3CCl3)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH3CCl3(0) = &
          p1(a0_1_1_CH3CCl3(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CH3CCl3(i0(j,k)), &
          a0_2_1_CH3CCl3(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CH3CCl3(i0(j,k)),v3_du1(j,k))
        sig_CH3CCl3(1) = &
          (p1(b1_1_CH3CCl3(i1(j,k)),a1_1_CH3CCl3(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CH3CCl3(i1(j,k)),a1_2_CH3CCl3(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        dj = 0. &
          + sig_CH3CCl3(0) * fint(j,k,0) &
          + sig_CH3CCl3(1) * fint(j,k,1)

        jval_gp(ip_CH3CCl3)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CH3CCl3

  ! **************************************************************************

  SUBROUTINE jval_cal_CFCl3(jrow)

    ! CFCl3 -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CFCl3

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CFCl3(dim58) = (/ &
      -2.8710E-20, -3.1049E-20, -3.3490E-20, -3.6150E-20, -3.8790E-20, -4.1475E-20, &
      -4.4262E-20, -4.6919E-20, -4.9686E-20, -5.2525E-20, -5.5319E-20, -5.8119E-20, &
      -6.1312E-20, -6.5269E-20, -6.7754E-20, -7.0613E-20, -7.3767E-20, -7.5667E-20, &
      -7.7784E-20, -7.9894E-20, -8.1039E-20, -8.2068E-20, -8.2952E-20, -8.2862E-20, &
      -8.2873E-20, -8.2127E-20, -8.1584E-20, -8.1218E-20, -8.0701E-20, -8.0028E-20, &
      -7.9115E-20, -7.7956E-20, -7.6522E-20, -7.4843E-20, -7.3064E-20, -7.1212E-20, &
      -6.9510E-20, -6.7969E-20, -6.6702E-20, -6.5694E-20, -6.4859E-20, -6.4082E-20, &
      -6.3142E-20, -6.1800E-20, -5.9879E-20, -5.7291E-20, -5.3997E-20, -5.0276E-20, &
      -4.6221E-20, -4.2181E-20, -3.8274E-20, -3.4567E-20, -3.0994E-20, -2.7509E-20, &
      -2.4079E-20, -2.0641E-20, -1.7048E-20, -1.4003E-20 /)
    REAL, PARAMETER :: a0_1_2_CFCl3(dim58) = (/ &
      2.5669E-18, 2.6703E-18, 2.7787E-18, 2.8973E-18, 3.0156E-18, 3.1364E-18, &
      3.2624E-18, 3.3830E-18, 3.5092E-18, 3.6392E-18, 3.7677E-18, 3.8971E-18, &
      4.0452E-18, 4.2297E-18, 4.3459E-18, 4.4803E-18, 4.6292E-18, 4.7192E-18, &
      4.8200E-18, 4.9209E-18, 4.9758E-18, 5.0254E-18, 5.0682E-18, 5.0638E-18, &
      5.0643E-18, 5.0278E-18, 5.0011E-18, 4.9830E-18, 4.9573E-18, 4.9238E-18, &
      4.8782E-18, 4.8200E-18, 4.7478E-18, 4.6628E-18, 4.5724E-18, 4.4780E-18, &
      4.3908E-18, 4.3116E-18, 4.2463E-18, 4.1940E-18, 4.1506E-18, 4.1101E-18, &
      4.0608E-18, 3.9902E-18, 3.8888E-18, 3.7516E-18, 3.5764E-18, 3.3777E-18, &
      3.1603E-18, 2.9430E-18, 2.7320E-18, 2.5311E-18, 2.3367E-18, 2.1464E-18, &
      1.9585E-18, 1.7694E-18, 1.5710E-18, 1.4023E-18 /)
    REAL, PARAMETER :: a0_2_1_CFCl3(dim58) = (/ &
      1.5802E-22, 1.7050E-22, 1.8169E-22, 1.9752E-22, 2.0848E-22, 2.2537E-22, &
      2.3858E-22, 2.5287E-22, 2.6562E-22, 2.8117E-22, 2.9488E-22, 3.0787E-22, &
      3.3473E-22, 3.8831E-22, 3.8746E-22, 3.9960E-22, 4.2341E-22, 4.1643E-22, &
      4.2035E-22, 4.3374E-22, 4.2164E-22, 4.1744E-22, 4.1799E-22, 3.9773E-22, &
      3.8519E-22, 3.5730E-22, 3.3883E-22, 3.2767E-22, 3.1611E-22, 3.0449E-22, &
      2.9245E-22, 2.8008E-22, 2.6717E-22, 2.5375E-22, 2.4041E-22, 2.2758E-22, &
      2.1593E-22, 2.0519E-22, 1.9617E-22, 1.8841E-22, 1.8143E-22, 1.7500E-22, &
      1.6785E-22, 1.5921E-22, 1.4871E-22, 1.3621E-22, 1.2183E-22, 1.0718E-22, &
      9.1825E-23, 7.8087E-23, 6.5613E-23, 5.4691E-23, 4.4955E-23, 3.6090E-23, &
      2.8488E-23, 2.1681E-23, 1.6188E-23, 1.2421E-23 /)
    REAL, PARAMETER :: a0_2_2_CFCl3(dim58) = (/ &
      -9.7274E-21, -1.0279E-20, -1.0776E-20, -1.1482E-20, -1.1973E-20, -1.2733E-20, &
      -1.3330E-20, -1.3979E-20, -1.4560E-20, -1.5272E-20, -1.5903E-20, -1.6503E-20, &
      -1.7749E-20, -2.0246E-20, -2.0206E-20, -2.0777E-20, -2.1901E-20, -2.1570E-20, &
      -2.1757E-20, -2.2397E-20, -2.1816E-20, -2.1614E-20, -2.1640E-20, -2.0655E-20, &
      -2.0043E-20, -1.8677E-20, -1.7768E-20, -1.7217E-20, -1.6643E-20, -1.6065E-20, &
      -1.5463E-20, -1.4842E-20, -1.4191E-20, -1.3512E-20, -1.2834E-20, -1.2180E-20, &
      -1.1583E-20, -1.1032E-20, -1.0566E-20, -1.0164E-20, -9.8014E-21, -9.4655E-21, &
      -9.0911E-21, -8.6363E-21, -8.0821E-21, -7.4197E-21, -6.6545E-21, -5.8724E-21, &
      -5.0492E-21, -4.3100E-21, -3.6365E-21, -3.0445E-21, -2.5148E-21, -2.0308E-21, &
      -1.6142E-21, -1.2398E-21, -9.3665E-22, -7.2795E-22 /)
    REAL, PARAMETER :: a0_3_1_CFCl3(dim58) = (/ &
      -2.6533E-25, -2.8846E-25, -3.0325E-25, -3.3667E-25, -3.4565E-25, -3.8756E-25, &
      -4.0602E-25, -4.3608E-25, -4.5467E-25, -4.8811E-25, -5.1376E-25, -5.3590E-25, &
      -6.4328E-25, -9.0470E-25, -8.3557E-25, -8.4530E-25, -9.1894E-25, -8.4158E-25, &
      -8.2865E-25, -8.6986E-25, -7.9225E-25, -7.6543E-25, -7.6995E-25, -6.8770E-25, &
      -6.4658E-25, -5.4648E-25, -4.9022E-25, -4.6566E-25, -4.4087E-25, -4.1691E-25, &
      -3.9299E-25, -3.6941E-25, -3.4608E-25, -3.2223E-25, -2.9896E-25, -2.7753E-25, &
      -2.5853E-25, -2.4074E-25, -2.2658E-25, -2.1453E-25, -2.0369E-25, -1.9459E-25, &
      -1.8447E-25, -1.7242E-25, -1.5845E-25, -1.4225E-25, -1.2373E-25, -1.0613E-25, &
      -8.6780E-26, -7.0958E-26, -5.6706E-26, -4.4557E-26, -3.4500E-26, -2.5267E-26, &
      -1.8500E-26, -1.2408E-26, -8.4102E-27, -5.2676E-27 /)
    REAL, PARAMETER :: a0_3_2_CFCl3(dim58) = (/ &
      1.6098E-23, 1.7120E-23, 1.7777E-23, 1.9267E-23, 1.9670E-23, 2.1556E-23, &
      2.2390E-23, 2.3755E-23, 2.4602E-23, 2.6134E-23, 2.7314E-23, 2.8337E-23, &
      3.3319E-23, 4.5502E-23, 4.2266E-23, 4.2723E-23, 4.6199E-23, 4.2532E-23, &
      4.1917E-23, 4.3887E-23, 4.0162E-23, 3.8869E-23, 3.9087E-23, 3.5090E-23, &
      3.3084E-23, 2.8179E-23, 2.5411E-23, 2.4198E-23, 2.2968E-23, 2.1774E-23, &
      2.0578E-23, 1.9395E-23, 1.8219E-23, 1.7012E-23, 1.5830E-23, 1.4737E-23, &
      1.3765E-23, 1.2850E-23, 1.2119E-23, 1.1495E-23, 1.0931E-23, 1.0456E-23, &
      9.9259E-24, 9.2922E-24, 8.5548E-24, 7.6960E-24, 6.7108E-24, 5.7710E-24, &
      4.7338E-24, 3.8825E-24, 3.1129E-24, 2.4545E-24, 1.9074E-24, 1.4032E-24, &
      1.0324E-24, 6.9736E-25, 4.7667E-25, 3.0257E-25 /)
    REAL, PARAMETER :: a1_1_CFCl3(dim55) = (/ &
      2.5191E-21, 2.5153E-21, 2.6195E-21, 2.5027E-21, 2.5139E-21, 2.3459E-21, &
      2.3131E-21, 2.1419E-21, 2.0975E-21, 1.9443E-21, 1.9026E-21, 1.7718E-21, &
      1.7363E-21, 1.6264E-21, 1.5973E-21, 1.5042E-21, 1.4796E-21, 1.3986E-21, &
      1.3786E-21, 1.3100E-21, 1.2930E-21, 1.2312E-21, 1.2166E-21, 1.1639E-21, &
      1.1507E-21, 1.1026E-21, 1.0912E-21, 1.0484E-21, 1.0390E-21, 1.0020E-21, &
      9.9021E-22, 9.5933E-22, 9.4702E-22, 9.1912E-22, 9.0977E-22, 8.8381E-22, &
      8.7465E-22, 8.5130E-22, 8.4226E-22, 8.2174E-22, 7.8423E-22, 7.2481E-22, &
      6.7524E-22, 6.3262E-22, 5.9434E-22, 5.6193E-22, 5.2959E-22, 5.0425E-22, &
      4.6883E-22, 4.4221E-22, 4.1697E-22, 3.9391E-22, 3.7198E-22, 3.5173E-22, &
      3.3274E-22 /)
    REAL, PARAMETER :: b1_1_CFCl3(dim55) = (/ &
      3.1774E-20, 3.1786E-20, 3.1213E-20, 3.2148E-20, 3.2029E-20, 3.4214E-20, &
      3.4723E-20, 3.7804E-20, 3.8714E-20, 4.2237E-20, 4.3302E-20, 4.6963E-20, &
      4.8047E-20, 5.1671E-20, 5.2706E-20, 5.6244E-20, 5.7241E-20, 6.0722E-20, &
      6.1634E-20, 6.4927E-20, 6.5783E-20, 6.9061E-20, 6.9869E-20, 7.2924E-20, &
      7.3723E-20, 7.6755E-20, 7.7502E-20, 8.0411E-20, 8.1078E-20, 8.3774E-20, &
      8.4666E-20, 8.7075E-20, 8.8066E-20, 9.0381E-20, 9.1181E-20, 9.3466E-20, &
      9.4295E-20, 9.6466E-20, 9.7329E-20, 9.9340E-20, 1.0311E-19, 1.0982E-19, &
      1.1604E-19, 1.2193E-19, 1.2769E-19, 1.3297E-19, 1.3865E-19, 1.4341E-19, &
      1.5051E-19, 1.5618E-19, 1.6188E-19, 1.6736E-19, 1.7285E-19, 1.7818E-19, &
      1.8341E-19 /)
    REAL, PARAMETER :: a1_2_CFCl3(dim55) = (/ &
      -9.5649E-24, -6.2955E-24, -7.1174E-24, -3.8294E-24, -4.4447E-24, -1.7367E-24, &
      -2.3649E-24, -3.6468E-25, -1.0269E-24, 3.9897E-25, -2.4873E-25, 7.8302E-25, &
      1.8904E-25, 9.5612E-25, 4.2856E-25, 1.0202E-24, 5.6738E-25, 1.0437E-24, &
      6.4693E-25, 1.0222E-24, 6.8170E-25, 9.9942E-25, 7.0682E-25, 9.5362E-25, &
      7.0657E-25, 9.2005E-25, 7.0139E-25, 8.8149E-25, 6.8894E-25, 8.2484E-25, &
      6.8211E-25, 7.8391E-25, 6.6145E-25, 7.5173E-25, 6.3601E-25, 7.1314E-25, &
      6.1330E-25, 6.7921E-25, 5.9457E-25, 6.4020E-25, 5.7423E-25, 5.2505E-25, &
      4.7971E-25, 4.4130E-25, 4.1666E-25, 3.8459E-25, 3.7644E-25, 3.4583E-25, &
      3.8783E-25, 3.9052E-25, 3.9371E-25, 3.9391E-25, 3.9473E-25, 3.9296E-25, &
      3.9039E-25 /)
    REAL, PARAMETER :: b1_2_CFCl3(dim55) = (/ &
      -1.6924E-22, -1.7904E-22, -1.7452E-22, -2.0083E-22, -1.9437E-22, -2.2957E-22, &
      -2.1983E-22, -2.5584E-22, -2.4226E-22, -2.7506E-22, -2.5854E-22, -2.8743E-22, &
      -2.6931E-22, -2.9463E-22, -2.7590E-22, -2.9838E-22, -2.8004E-22, -3.0053E-22, &
      -2.8247E-22, -3.0048E-22, -2.8329E-22, -3.0013E-22, -2.8389E-22, -2.9820E-22, &
      -2.8326E-22, -2.9671E-22, -2.8238E-22, -2.9463E-22, -2.8106E-22, -2.9098E-22, &
      -2.8020E-22, -2.8814E-22, -2.7828E-22, -2.8578E-22, -2.7588E-22, -2.8267E-22, &
      -2.7363E-22, -2.7976E-22, -2.7168E-22, -2.7615E-22, -2.6952E-22, -2.6396E-22, &
      -2.5827E-22, -2.5297E-22, -2.4927E-22, -2.4404E-22, -2.4261E-22, -2.3685E-22, &
      -2.4527E-22, -2.4585E-22, -2.4657E-22, -2.4661E-22, -2.4682E-22, -2.4635E-22, &
      -2.4564E-22 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_CFCl3(dim58) = (/ &
      -7.4135E-03, -7.4135E-03, -7.4135E-03, -8.3670E-03, -1.0724E-02, -1.2199E-02, &
      -1.2550E-02, -1.5321E-02, -1.5536E-02, -1.5233E-02, -1.6398E-02, -1.4632E-02, &
      -1.4438E-02, -1.3856E-02, -1.3003E-02, -1.3147E-02, -1.2333E-02, -1.3057E-02, &
      -1.2491E-02, -1.3864E-02, -1.3997E-02, -1.4419E-02, -1.3894E-02, -1.2772E-02, &
      -1.0296E-02, -6.4524E-03, -1.7497E-03, 3.6450E-03, 9.1419E-03, 1.4232E-02, &
      1.7267E-02, 1.8225E-02, 1.5875E-02, 1.0563E-02, 2.4545E-03, -7.4094E-03, &
      -1.7248E-02, -2.5723E-02, -3.0723E-02, -3.0705E-02, -2.4746E-02, -1.3100E-02, &
      3.5236E-03, 2.2234E-02, 4.0282E-02, 5.4192E-02, 6.2036E-02, 6.4280E-02, &
      6.3074E-02, 6.1964E-02, 6.4920E-02, 7.4574E-02, 9.0956E-02, 1.1159E-01, &
      1.3069E-01, 1.4570E-01, 1.6183E-01, 1.8407E-01 /)
    REAL, PARAMETER :: c0_1_2_CFCl3(dim58) = (/ &
      4.8795E-01, 4.8795E-01, 4.8795E-01, 5.3048E-01, 6.3606E-01, 7.0245E-01, &
      7.1833E-01, 8.4410E-01, 8.5391E-01, 8.4004E-01, 8.9365E-01, 8.1206E-01, &
      8.0303E-01, 7.7590E-01, 7.3601E-01, 7.4275E-01, 7.0433E-01, 7.3868E-01, &
      7.1171E-01, 7.7736E-01, 7.8376E-01, 8.0408E-01, 7.7868E-01, 7.2412E-01, &
      6.0332E-01, 4.1497E-01, 1.8360E-01, -8.2897E-02, -3.5554E-01, -6.0903E-01, &
      -7.6080E-01, -8.0888E-01, -6.9045E-01, -4.2166E-01, -9.7321E-03, 4.9333E-01, &
      9.9704E-01, 1.4327E+00, 1.6907E+00, 1.6898E+00, 1.3799E+00, 7.7196E-01, &
      -9.9121E-02, -1.0833E+00, -2.0362E+00, -2.7735E+00, -3.1908E+00, -3.3106E+00, &
      -3.2459E+00, -3.1862E+00, -3.3458E+00, -3.8691E+00, -4.7603E+00, -5.8871E+00, &
      -6.9337E+00, -7.7593E+00, -8.6497E+00, -9.8818E+00 /)
    REAL, PARAMETER :: c0_2_1_CFCl3(dim58) = (/ &
      -5.4000E-03, -5.4000E-03, -5.4000E-03, -5.3648E-03, 1.8984E-03, -5.3136E-03, &
      1.0948E-03, -4.1041E-03, -1.8790E-03, 5.8807E-03, -5.8890E-03, 1.3925E-03, &
      5.5517E-03, 3.1595E-03, 4.5585E-03, 1.6467E-02, 3.7290E-03, 7.5259E-03, &
      1.1912E-02, 9.2545E-03, 1.1600E-02, 8.3766E-03, 7.8479E-03, 6.4751E-03, &
      5.6250E-03, 4.3022E-03, 3.0986E-03, -7.9066E-04, -2.7368E-03, -6.5338E-03, &
      -9.6004E-03, -1.2954E-02, -1.4198E-02, -1.4275E-02, -1.5939E-02, -1.3656E-02, &
      -1.1115E-02, -6.1878E-03, 3.5403E-03, 1.7544E-02, 3.2526E-02, 4.4947E-02, &
      5.1742E-02, 4.8818E-02, 3.8119E-02, 2.6378E-02, 1.8302E-02, 2.0347E-02, &
      2.4035E-02, 2.9882E-02, 2.4317E-02, 3.4125E-03, -3.9168E-02, -8.9782E-02, &
      -1.2482E-01, -1.2072E-01, -7.2562E-02, -2.0539E-03 /)
    REAL, PARAMETER :: c0_2_2_CFCl3(dim58) = (/ &
      2.7176E-01, 2.7176E-01, 2.7176E-01, 2.7019E-01, -5.5198E-02, 2.6934E-01, &
      -2.0317E-02, 2.1571E-01, 1.1425E-01, -2.4115E-01, 3.0026E-01, -3.6146E-02, &
      -2.2913E-01, -1.1766E-01, -1.8313E-01, -7.4283E-01, -1.4160E-01, -3.2157E-01, &
      -5.3036E-01, -4.0332E-01, -5.1592E-01, -3.6053E-01, -3.3495E-01, -2.6823E-01, &
      -2.2674E-01, -1.6193E-01, -1.0271E-01, 8.9422E-02, 1.8595E-01, 3.7504E-01, &
      5.2837E-01, 6.9675E-01, 7.5941E-01, 7.6334E-01, 8.4787E-01, 7.3143E-01, &
      6.0131E-01, 3.4806E-01, -1.5391E-01, -8.7928E-01, -1.6584E+00, -2.3068E+00, &
      -2.6628E+00, -2.5090E+00, -1.9441E+00, -1.3218E+00, -8.9216E-01, -1.0014E+00, &
      -1.1991E+00, -1.5136E+00, -1.2131E+00, -8.0092E-02, 2.2363E+00, 4.9998E+00, &
      6.9199E+00, 6.6946E+00, 4.0361E+00, 1.2993E-01 /)
    REAL, PARAMETER :: c1_CFCl3(3) = (/ 1.00,  0.52, 0.13 /)

    jval_gp(ip_CFCl3)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CFCl3(0) = &
          p2(1.,c0_1_1_CFCl3(i0(j,k))*dlv2(j,k) + &
          c0_1_2_CFCl3(i0(j,k)), &
          c0_2_1_CFCl3(i0(j,k))*dlv2(j,k) + &
          c0_2_2_CFCl3(i0(j,k)), tnorm_sr(j,k)) * &
          p2(a0_1_1_CFCl3(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CFCl3(i0(j,k)), &
          a0_2_1_CFCl3(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CFCl3(i0(j,k)), &
          a0_3_1_CFCl3(i0(j,k))*dlv2(j,k) + &
          a0_3_2_CFCl3(i0(j,k)), v3_du1(j,k))
        sig_CFCl3(1) = &
          p2(c1_CFCl3(1),c1_CFCl3(2), &
          c1_CFCl3(3),tnorm(j,k)) * &
          p1(b1_1_CFCl3(i1(j,k)),a1_1_CFCl3(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CFCl3(i1(j,k)),a1_2_CFCl3(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k)
        dj = 0. &
          + sig_CFCl3(0) * fint(j,k,0) &
          + sig_CFCl3(1) * fint(j,k,1)

        jval_gp(ip_CFCl3)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CFCl3

  ! **************************************************************************

  SUBROUTINE jval_cal_CF2Cl2(jrow)

    ! CF2Cl2 -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CF2Cl2

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CF2Cl2(dim58) = (/ &
      -2.1045E-20, -2.2704E-20, -2.4455E-20, -2.6208E-20, -2.8024E-20, -2.9830E-20, &
      -3.1629E-20, -3.3399E-20, -3.5164E-20, -3.6908E-20, -3.8622E-20, -4.0363E-20, &
      -4.2347E-20, -4.4830E-20, -4.6169E-20, -4.7666E-20, -4.9299E-20, -5.0132E-20, &
      -5.1021E-20, -5.1816E-20, -5.1734E-20, -5.1543E-20, -5.1254E-20, -5.0149E-20, &
      -4.9080E-20, -4.7464E-20, -4.6011E-20, -4.4704E-20, -4.3319E-20, -4.1937E-20, &
      -4.0457E-20, -3.8910E-20, -3.7287E-20, -3.5614E-20, -3.3936E-20, -3.2302E-20, &
      -3.0801E-20, -2.9470E-20, -2.8298E-20, -2.7302E-20, -2.6458E-20, -2.5639E-20, &
      -2.4774E-20, -2.3756E-20, -2.2520E-20, -2.1047E-20, -1.9342E-20, -1.7534E-20, &
      -1.5698E-20, -1.3942E-20, -1.2332E-20, -1.0859E-20, -9.5002E-21, -8.2307E-21, &
      -7.0289E-21, -5.8900E-21, -4.7724E-21, -3.8920E-21 /)
    REAL, PARAMETER :: a0_1_2_CF2Cl2(dim58) = (/ &
      1.3652E-18, 1.4385E-18, 1.5163E-18, 1.5945E-18, 1.6758E-18, 1.7571E-18, &
      1.8384E-18, 1.9188E-18, 1.9993E-18, 2.0791E-18, 2.1580E-18, 2.2384E-18, &
      2.3305E-18, 2.4462E-18, 2.5088E-18, 2.5792E-18, 2.6562E-18, 2.6957E-18, &
      2.7380E-18, 2.7760E-18, 2.7721E-18, 2.7629E-18, 2.7489E-18, 2.6952E-18, &
      2.6431E-18, 2.5639E-18, 2.4924E-18, 2.4278E-18, 2.3591E-18, 2.2903E-18, &
      2.2163E-18, 2.1386E-18, 2.0569E-18, 1.9722E-18, 1.8869E-18, 1.8036E-18, &
      1.7268E-18, 1.6584E-18, 1.5979E-18, 1.5463E-18, 1.5024E-18, 1.4596E-18, &
      1.4143E-18, 1.3608E-18, 1.2955E-18, 1.2174E-18, 1.1267E-18, 1.0302E-18, &
      9.3177E-19, 8.3730E-19, 7.5034E-19, 6.7052E-19, 5.9661E-19, 5.2729E-19, &
      4.6143E-19, 3.9879E-19, 3.3710E-19, 2.8833E-19 /)
    REAL, PARAMETER :: a0_2_1_CF2Cl2(dim58) = (/ &
      1.2473E-22, 1.3416E-22, 1.4475E-22, 1.5463E-22, 1.6569E-22, 1.7633E-22, &
      1.8694E-22, 1.9726E-22, 2.0758E-22, 2.1806E-22, 2.2780E-22, 2.3821E-22, &
      2.5924E-22, 3.0053E-22, 2.9710E-22, 3.0369E-22, 3.1861E-22, 3.1142E-22, &
      3.1280E-22, 3.1922E-22, 3.0618E-22, 2.9855E-22, 2.9515E-22, 2.7573E-22, &
      2.6201E-22, 2.3786E-22, 2.2059E-22, 2.0867E-22, 1.9634E-22, 1.8492E-22, &
      1.7308E-22, 1.6179E-22, 1.5032E-22, 1.3928E-22, 1.2843E-22, 1.1828E-22, &
      1.0907E-22, 1.0129E-22, 9.4130E-23, 8.8177E-23, 8.3443E-23, 7.8694E-23, &
      7.3953E-23, 6.8799E-23, 6.2939E-23, 5.6377E-23, 4.9256E-23, 4.2119E-23, &
      3.5296E-23, 2.9136E-23, 2.3857E-23, 1.9317E-23, 1.5404E-23, 1.2063E-23, &
      9.1715E-24, 6.8060E-24, 4.9208E-24, 3.7915E-24 /)
    REAL, PARAMETER :: a0_2_2_CF2Cl2(dim58) = (/ &
      -7.3028E-21, -7.7192E-21, -8.1896E-21, -8.6302E-21, -9.1258E-21, -9.6043E-21, &
      -1.0084E-20, -1.0552E-20, -1.1023E-20, -1.1503E-20, -1.1951E-20, -1.2432E-20, &
      -1.3408E-20, -1.5332E-20, -1.5171E-20, -1.5481E-20, -1.6186E-20, -1.5845E-20, &
      -1.5910E-20, -1.6217E-20, -1.5591E-20, -1.5224E-20, -1.5059E-20, -1.4115E-20, &
      -1.3446E-20, -1.2262E-20, -1.1413E-20, -1.0824E-20, -1.0212E-20, -9.6438E-21, &
      -9.0515E-21, -8.4849E-21, -7.9066E-21, -7.3479E-21, -6.7971E-21, -6.2794E-21, &
      -5.8078E-21, -5.4075E-21, -5.0383E-21, -4.7300E-21, -4.4838E-21, -4.2359E-21, &
      -3.9875E-21, -3.7164E-21, -3.4070E-21, -3.0592E-21, -2.6803E-21, -2.2992E-21, &
      -1.9335E-21, -1.6021E-21, -1.3170E-21, -1.0710E-21, -8.5807E-22, -6.7567E-22, &
      -5.1721E-22, -3.8711E-22, -2.8305E-22, -2.2049E-22 /)
    REAL, PARAMETER :: a0_3_1_CF2Cl2(dim58) = (/ &
      -2.2477E-25, -2.4194E-25, -2.6242E-25, -2.8032E-25, -3.0285E-25, -3.2359E-25, &
      -3.4440E-25, -3.6461E-25, -3.8520E-25, -4.0782E-25, -4.2693E-25, -4.4912E-25, &
      -5.3897E-25, -7.4829E-25, -6.8282E-25, -6.8316E-25, -7.3175E-25, -6.6701E-25, &
      -6.5555E-25, -6.7692E-25, -6.1031E-25, -5.8049E-25, -5.7580E-25, -5.0691E-25, &
      -4.6844E-25, -3.9084E-25, -3.4475E-25, -3.2122E-25, -2.9693E-25, -2.7538E-25, &
      -2.5276E-25, -2.3254E-25, -2.1170E-25, -1.9244E-25, -1.7360E-25, -1.5637E-25, &
      -1.4078E-25, -1.2832E-25, -1.1635E-25, -1.0677E-25, -9.9973E-26, -9.2785E-26, &
      -8.5939E-26, -7.8902E-26, -7.0985E-26, -6.2290E-26, -5.3036E-26, -4.4003E-26, &
      -3.5574E-26, -2.8129E-26, -2.1995E-26, -1.6858E-26, -1.2569E-26, -9.1631E-27, &
      -6.3185E-27, -4.2025E-27, -2.6946E-27, -1.9652E-27 /)
    REAL, PARAMETER :: a0_3_2_CF2Cl2(dim58) = (/ &
      1.3134E-23, 1.3893E-23, 1.4802E-23, 1.5601E-23, 1.6610E-23, 1.7544E-23, &
      1.8484E-23, 1.9402E-23, 2.0341E-23, 2.1377E-23, 2.2255E-23, 2.3281E-23, &
      2.7450E-23, 3.7204E-23, 3.4140E-23, 3.4156E-23, 3.6450E-23, 3.3381E-23, &
      3.2835E-23, 3.3857E-23, 3.0659E-23, 2.9222E-23, 2.8995E-23, 2.5647E-23, &
      2.3770E-23, 1.9967E-23, 1.7700E-23, 1.6537E-23, 1.5333E-23, 1.4260E-23, &
      1.3128E-23, 1.2113E-23, 1.1063E-23, 1.0089E-23, 9.1315E-24, 8.2526E-24, &
      7.4546E-24, 6.8142E-24, 6.1963E-24, 5.7002E-24, 5.3468E-24, 4.9716E-24, &
      4.6128E-24, 4.2427E-24, 3.8247E-24, 3.3639E-24, 2.8715E-24, 2.3892E-24, &
      1.9374E-24, 1.5368E-24, 1.2056E-24, 9.2718E-25, 6.9383E-25, 5.0789E-25, &
      3.5200E-25, 2.3563E-25, 1.5239E-25, 1.1198E-25 /)
    REAL, PARAMETER :: a1_1_CF2Cl2(dim55) = (/ &
      1.1582E-22, 1.2083E-22, 1.2360E-22, 1.2370E-22, 1.2232E-22, 1.1974E-22, &
      1.1649E-22, 1.1313E-22, 1.0943E-22, 1.0626E-22, 1.0270E-22, 9.9914E-23, &
      9.6738E-23, 9.4398E-23, 9.1580E-23, 8.9596E-23, 8.7065E-23, 8.5432E-23, &
      8.3134E-23, 8.1726E-23, 7.9630E-23, 7.8463E-23, 7.6519E-23, 7.5501E-23, &
      7.3720E-23, 7.2850E-23, 7.1155E-23, 7.0437E-23, 6.8845E-23, 6.8219E-23, &
      6.6707E-23, 6.6189E-23, 6.4742E-23, 6.4335E-23, 6.2914E-23, 6.2597E-23, &
      6.1227E-23, 6.0961E-23, 5.9642E-23, 5.9465E-23, 5.7005E-23, 5.3993E-23, &
      5.0999E-23, 4.8619E-23, 4.6106E-23, 4.4096E-23, 4.1892E-23, 4.0141E-23, &
      3.7758E-23, 3.6026E-23, 3.4429E-23, 3.2927E-23, 3.1450E-23, 3.0111E-23, &
      2.8856E-23 /)
    REAL, PARAMETER :: b1_1_CF2Cl2(dim55) = (/ &
      1.3491E-21, 1.3341E-21, 1.3188E-21, 1.3180E-21, 1.3325E-21, 1.3660E-21, &
      1.4164E-21, 1.4769E-21, 1.5527E-21, 1.6257E-21, 1.7165E-21, 1.7944E-21, &
      1.8913E-21, 1.9685E-21, 2.0685E-21, 2.1439E-21, 2.2464E-21, 2.3167E-21, &
      2.4212E-21, 2.4888E-21, 2.5946E-21, 2.6565E-21, 2.7644E-21, 2.8235E-21, &
      2.9312E-21, 2.9860E-21, 3.0970E-21, 3.1459E-21, 3.2581E-21, 3.3038E-21, &
      3.4179E-21, 3.4583E-21, 3.5748E-21, 3.6086E-21, 3.7301E-21, 3.7580E-21, &
      3.8820E-21, 3.9068E-21, 4.0327E-21, 4.0500E-21, 4.2972E-21, 4.6376E-21, &
      5.0133E-21, 5.3418E-21, 5.7201E-21, 6.0476E-21, 6.4345E-21, 6.7636E-21, &
      7.2415E-21, 7.6105E-21, 7.9705E-21, 8.3278E-21, 8.6979E-21, 9.0500E-21, &
      9.3958E-21 /)
    REAL, PARAMETER :: a1_2_CF2Cl2(dim55) = (/ &
      -5.6849E-25, -4.6917E-25, -3.9598E-25, -3.0355E-25, -2.3388E-25, -1.7265E-25, &
      -1.2164E-25, -9.2478E-26, -5.5629E-26, -4.7048E-26, -1.9853E-26, -2.1532E-26, &
      3.8370E-28, -6.6479E-27, 1.2362E-26, 2.5660E-27, 2.0571E-26, 8.6238E-27, &
      2.5329E-26, 1.3341E-26, 2.9312E-26, 1.5861E-26, 3.1705E-26, 1.8278E-26, &
      3.3116E-26, 1.9763E-26, 3.4642E-26, 2.0624E-26, 3.5192E-26, 2.1604E-26, &
      3.5600E-26, 2.2224E-26, 3.6187E-26, 2.2117E-26, 3.6552E-26, 2.2537E-26, &
      3.6579E-26, 2.2940E-26, 3.6773E-26, 2.2881E-26, 3.1711E-26, 2.9027E-26, &
      3.2842E-26, 3.0351E-26, 3.3941E-26, 3.1550E-26, 3.4919E-26, 3.2224E-26, &
      4.1415E-26, 4.0920E-26, 3.9992E-26, 3.8919E-26, 3.8167E-26, 3.6660E-26, &
      3.4974E-26 /)
    REAL, PARAMETER :: b1_2_CF2Cl2(dim55) = (/ &
      -1.1155E-23, -1.1453E-23, -1.1856E-23, -1.2595E-23, -1.3327E-23, -1.4123E-23, &
      -1.4913E-23, -1.5438E-23, -1.6194E-23, -1.6391E-23, -1.7085E-23, -1.7038E-23, &
      -1.7706E-23, -1.7474E-23, -1.8149E-23, -1.7777E-23, -1.8506E-23, -1.7992E-23, &
      -1.8752E-23, -1.8177E-23, -1.8983E-23, -1.8270E-23, -1.9150E-23, -1.8371E-23, &
      -1.9269E-23, -1.8427E-23, -1.9402E-23, -1.8449E-23, -1.9476E-23, -1.8484E-23, &
      -1.9541E-23, -1.8497E-23, -1.9621E-23, -1.8453E-23, -1.9688E-23, -1.8454E-23, &
      -1.9725E-23, -1.8457E-23, -1.9778E-23, -1.8416E-23, -1.9304E-23, -1.9000E-23, &
      -1.9479E-23, -1.9135E-23, -1.9676E-23, -1.9286E-23, -1.9877E-23, -1.9371E-23, &
      -2.1213E-23, -2.1108E-23, -2.0899E-23, -2.0643E-23, -2.0455E-23, -2.0059E-23, &
      -1.9594E-23 /)
    REAL, PARAMETER :: a1_3_CF2Cl2(dim55) = (/ &
      4.3006E-28, -1.7643E-28, -3.3492E-28, -6.2941E-28, -7.0087E-28, -7.4077E-28, &
      -7.5938E-28, -6.5397E-28, -6.8117E-28, -5.3221E-28, -5.7019E-28, -4.2068E-28, &
      -4.7411E-28, -3.3586E-28, -3.9762E-28, -2.7107E-28, -3.4057E-28, -2.2330E-28, &
      -2.9162E-28, -1.8762E-28, -2.5657E-28, -1.5617E-28, -2.2607E-28, -1.3363E-28, &
      -1.9971E-28, -1.1441E-28, -1.8040E-28, -9.8237E-29, -1.6191E-28, -8.6495E-29, &
      -1.4674E-28, -7.6310E-29, -1.3514E-28, -6.5681E-29, -1.2503E-28, -5.8864E-29, &
      -1.1525E-28, -5.3337E-29, -1.0747E-28, -4.7328E-29, -7.4074E-29, -5.2892E-29, &
      -5.6479E-29, -4.1027E-29, -4.5503E-29, -3.3116E-29, -3.7699E-29, -2.6647E-29, &
      -4.5487E-29, -4.0522E-29, -3.5457E-29, -3.0480E-29, -2.6732E-29, -2.1980E-29, &
      -1.7349E-29 /)
    REAL, PARAMETER :: b1_3_CF2Cl2(dim55) = (/ &
      3.0628E-26, 3.2447E-26, 3.3319E-26, 3.5675E-26, 3.6425E-26, 3.6944E-26, &
      3.7232E-26, 3.5335E-26, 3.5893E-26, 3.2466E-26, 3.3435E-26, 2.9249E-26, &
      3.0878E-26, 2.6316E-26, 2.8509E-26, 2.3700E-26, 2.6514E-26, 2.1472E-26, &
      2.4580E-26, 1.9588E-26, 2.3070E-26, 1.7749E-26, 2.1628E-26, 1.6267E-26, &
      2.0265E-26, 1.4891E-26, 1.9213E-26, 1.3626E-26, 1.8115E-26, 1.2610E-26, &
      1.7158E-26, 1.1665E-26, 1.6400E-26, 1.0636E-26, 1.5710E-26, 9.8874E-27, &
      1.4990E-26, 9.2324E-27, 1.4402E-26, 8.5082E-27, 1.1196E-26, 8.8026E-27, &
      9.2528E-27, 7.1203E-27, 7.7940E-27, 5.7750E-27, 6.5793E-27, 4.5015E-27, &
      8.2789E-27, 7.2213E-27, 6.0792E-27, 4.8946E-27, 3.9557E-27, 2.7061E-27, &
      1.4303E-27 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_CF2Cl2(dim58) = (/ &
      -1.2339E-03, -1.2339E-03, -1.2339E-03, -3.9143E-03, -6.7290E-03, -9.1209E-03, &
      -1.1538E-02, -1.2530E-02, -1.2909E-02, -1.2025E-02, -1.0583E-02, -7.2904E-03, &
      -4.3194E-03, -2.8953E-04, 3.3111E-03, 7.8456E-03, 1.0965E-02, 1.3988E-02, &
      1.7099E-02, 1.9950E-02, 2.2098E-02, 2.6069E-02, 3.1086E-02, 3.8320E-02, &
      4.7920E-02, 5.9708E-02, 7.4404E-02, 9.0087E-02, 1.0507E-01, 1.1843E-01, &
      1.2757E-01, 1.3080E-01, 1.2347E-01, 1.0984E-01, 8.7767E-02, 6.0274E-02, &
      3.2805E-02, 6.8417E-03, -7.2153E-03, -1.1136E-02, 4.5504E-03, 3.5622E-02, &
      8.1204E-02, 1.3389E-01, 1.8360E-01, 2.2074E-01, 2.4173E-01, 2.4241E-01, &
      2.3312E-01, 2.2292E-01, 2.2146E-01, 2.3608E-01, 2.6784E-01, 3.0897E-01, &
      3.4563E-01, 3.7132E-01, 4.0030E-01, 4.4671E-01 /)
    REAL, PARAMETER :: c0_1_2_CF2Cl2(dim58) = (/ &
      3.9361E-01, 3.9361E-01, 3.9361E-01, 5.1315E-01, 6.3925E-01, 7.4689E-01, &
      8.5615E-01, 9.0119E-01, 9.1847E-01, 8.7797E-01, 8.1166E-01, 6.5952E-01, &
      5.2167E-01, 3.3388E-01, 1.6537E-01, -4.7753E-02, -1.9497E-01, -3.3828E-01, &
      -4.8634E-01, -6.2263E-01, -7.2574E-01, -9.1714E-01, -1.1600E+00, -1.5115E+00, &
      -1.9800E+00, -2.5576E+00, -3.2807E+00, -4.0554E+00, -4.7987E+00, -5.4641E+00, &
      -5.9207E+00, -6.0831E+00, -5.7138E+00, -5.0237E+00, -3.9026E+00, -2.5005E+00, &
      -1.0941E+00, 2.4044E-01, 9.6578E-01, 1.1689E+00, 3.5318E-01, -1.2688E+00, &
      -3.6572E+00, -6.4287E+00, -9.0531E+00, -1.1022E+01, -1.2138E+01, -1.2175E+01, &
      -1.1676E+01, -1.1128E+01, -1.1049E+01, -1.1841E+01, -1.3569E+01, -1.5815E+01, &
      -1.7824E+01, -1.9237E+01, -2.0837E+01, -2.3408E+01 /)
    REAL, PARAMETER :: c0_2_1_CF2Cl2(dim58) = (/ &
      1.2029E-02, 1.2029E-02, 1.2029E-02, 1.6427E-02, 1.4515E-02, 1.8025E-02, &
      1.8448E-02, 1.9509E-02, 2.4475E-02, 2.7531E-02, 3.1471E-02, 3.5936E-02, &
      4.1702E-02, 4.5293E-02, 5.1222E-02, 5.9312E-02, 5.7930E-02, 6.6568E-02, &
      6.6601E-02, 6.7576E-02, 6.6520E-02, 6.1638E-02, 6.0235E-02, 5.0105E-02, &
      4.4213E-02, 4.0177E-02, 2.4584E-02, 1.5039E-02, 5.9057E-03, -8.3552E-03, &
      -1.2283E-02, -2.4529E-02, -2.3978E-02, -2.4076E-02, -2.5661E-02, -2.6973E-02, &
      -1.9560E-02, -8.7936E-03, 1.8514E-02, 4.8117E-02, 1.0692E-01, 1.6090E-01, &
      1.9386E-01, 2.1011E-01, 1.9577E-01, 1.7237E-01, 1.7151E-01, 1.6792E-01, &
      1.7947E-01, 1.9964E-01, 1.9489E-01, 1.4913E-01, 6.1518E-02, -4.6480E-02, &
      -1.1395E-01, -7.9329E-02, 8.7193E-02, 3.0660E-01 /)
    REAL, PARAMETER :: c0_2_2_CF2Cl2(dim58) = (/ &
      -2.7716E-01, -2.7716E-01, -2.7716E-01, -4.7331E-01, -3.8765E-01, -5.4557E-01, &
      -5.6472E-01, -6.1288E-01, -8.3933E-01, -9.7929E-01, -1.1605E+00, -1.3668E+00, &
      -1.6344E+00, -1.8017E+00, -2.0792E+00, -2.4594E+00, -2.3942E+00, -2.8036E+00, &
      -2.8052E+00, -2.8518E+00, -2.8011E+00, -2.5658E+00, -2.4979E+00, -2.0056E+00, &
      -1.7180E+00, -1.5203E+00, -7.5310E-01, -2.8157E-01, 1.7143E-01, 8.8162E-01, &
      1.0780E+00, 1.6928E+00, 1.6650E+00, 1.6700E+00, 1.7505E+00, 1.8174E+00, &
      1.4378E+00, 8.8444E-01, -5.2465E-01, -2.0581E+00, -5.1158E+00, -7.9335E+00, &
      -9.6605E+00, -1.0515E+01, -9.7581E+00, -8.5180E+00, -8.4721E+00, -8.2804E+00, &
      -8.8995E+00, -9.9851E+00, -9.7285E+00, -7.2480E+00, -2.4821E+00, 3.4146E+00, &
      7.1117E+00, 5.2078E+00, -3.9842E+00, -1.6139E+01 /)
    REAL, PARAMETER :: c1_CF2Cl2(4) = (/ 1.00,  2.10, 2.33,  1.70 /)

    jval_gp(ip_CF2Cl2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CF2Cl2(0) = &
          p2(1.,c0_1_1_CF2Cl2(i0(j,k))*dlv2(j,k) + &
          c0_1_2_CF2Cl2(i0(j,k)), &
          c0_2_1_CF2Cl2(i0(j,k))*dlv2(j,k) + &
          c0_2_2_CF2Cl2(i0(j,k)), tnorm_sr(j,k)) * &
          p2(a0_1_1_CF2Cl2(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CF2Cl2(i0(j,k)), &
          a0_2_1_CF2Cl2(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CF2Cl2(i0(j,k)), &
          a0_3_1_CF2Cl2(i0(j,k))*dlv2(j,k) + &
          a0_3_2_CF2Cl2(i0(j,k)), v3_du1(j,k))
        sig_CF2Cl2(1) = &
          p3(c1_CF2Cl2(1),c1_CF2Cl2(2), &
          c1_CF2Cl2(3),c1_CF2Cl2(4),tnorm(j,k)) * &
          (p1(b1_1_CF2Cl2(i1(j,k)),a1_1_CF2Cl2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CF2Cl2(i1(j,k)),a1_2_CF2Cl2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k) + &
          p1(b1_3_CF2Cl2(i1(j,k)),a1_3_CF2Cl2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k)**2)
        dj = 0. &
          + sig_CF2Cl2(0) * fint(j,k,0) &
          + sig_CF2Cl2(1) * fint(j,k,1)

        jval_gp(ip_CF2Cl2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CF2Cl2

  ! **************************************************************************

  SUBROUTINE jval_cal_CH3Br(jrow)

    ! CH3Br -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH3Br

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CH3Br(dim58) = (/ &
      9.8695E-21, 1.0733E-20, 1.1634E-20, 1.2566E-20, 1.3535E-20, 1.4508E-20, &
      1.5500E-20, 1.6504E-20, 1.7530E-20, 1.8568E-20, 1.9648E-20, 2.0730E-20, &
      2.2809E-20, 2.6772E-20, 2.6753E-20, 2.7680E-20, 2.9457E-20, 2.9321E-20, &
      3.0031E-20, 3.1443E-20, 3.1082E-20, 3.1442E-20, 3.2423E-20, 3.1810E-20, &
      3.1859E-20, 3.0641E-20, 3.0131E-20, 3.0127E-20, 3.0021E-20, 2.9778E-20, &
      2.9390E-20, 2.8841E-20, 2.8172E-20, 2.7367E-20, 2.6484E-20, 2.5561E-20, &
      2.4651E-20, 2.3769E-20, 2.2948E-20, 2.2191E-20, 2.1458E-20, 2.0728E-20, &
      1.9961E-20, 1.9092E-20, 1.8083E-20, 1.6939E-20, 1.5669E-20, 1.4337E-20, &
      1.2986E-20, 1.1704E-20, 1.0492E-20, 9.3793E-21, 8.3334E-21, 7.3138E-21, &
      6.3333E-21, 5.3587E-21, 4.3677E-21, 3.5842E-21 /)
    REAL, PARAMETER :: a0_1_2_CH3Br(dim58) = (/ &
      1.0236E-19, 6.4200E-20, 2.4174E-20, -1.7397E-20, -6.0775E-20, -1.0459E-19, &
      -1.4942E-19, -1.9498E-19, -2.4177E-19, -2.8932E-19, -3.3902E-19, -3.8899E-19, &
      -4.8545E-19, -6.7012E-19, -6.6924E-19, -7.1282E-19, -7.9667E-19, -7.9022E-19, &
      -8.2405E-19, -8.9153E-19, -8.7418E-19, -8.9153E-19, -9.3902E-19, -9.0922E-19, &
      -9.1161E-19, -8.5194E-19, -8.2684E-19, -8.2667E-19, -8.2143E-19, -8.0929E-19, &
      -7.8990E-19, -7.6233E-19, -7.2861E-19, -6.8790E-19, -6.4305E-19, -5.9595E-19, &
      -5.4936E-19, -5.0402E-19, -4.6168E-19, -4.2247E-19, -3.8435E-19, -3.4622E-19, &
      -3.0606E-19, -2.6032E-19, -2.0706E-19, -1.4642E-19, -7.8861E-20, -7.7327E-21, &
      6.4684E-20, 1.3365E-19, 1.9912E-19, 2.5940E-19, 3.1630E-19, 3.7197E-19, &
      4.2570E-19, 4.7931E-19, 5.3401E-19, 5.7742E-19 /)
    REAL, PARAMETER :: a0_2_1_CH3Br(dim58) = (/ &
      -3.7096E-23, -4.0140E-23, -4.3306E-23, -4.6569E-23, -5.0017E-23, -5.3455E-23, &
      -5.6832E-23, -6.0231E-23, -6.3792E-23, -6.7208E-23, -7.0910E-23, -7.4468E-23, &
      -9.2770E-23, -1.3741E-22, -1.2291E-22, -1.2279E-22, -1.3398E-22, -1.2094E-22, &
      -1.1982E-22, -1.2778E-22, -1.1568E-22, -1.1329E-22, -1.1818E-22, -1.0698E-22, &
      -1.0370E-22, -8.8639E-23, -8.1637E-23, -8.0522E-23, -7.9165E-23, -7.7427E-23, &
      -7.5350E-23, -7.2823E-23, -7.0083E-23, -6.6985E-23, -6.3711E-23, -6.0432E-23, &
      -5.7272E-23, -5.4132E-23, -5.1300E-23, -4.8578E-23, -4.5953E-23, -4.3339E-23, &
      -4.0628E-23, -3.7669E-23, -3.4455E-23, -3.0946E-23, -2.7363E-23, -2.3795E-23, &
      -2.0352E-23, -1.7346E-23, -1.4556E-23, -1.2240E-23, -1.0160E-23, -8.2402E-24, &
      -6.5911E-24, -5.1251E-24, -3.7697E-24, -3.0095E-24 /)
    REAL, PARAMETER :: a0_2_2_CH3Br(dim58) = (/ &
      2.3629E-21, 2.4975E-21, 2.6381E-21, 2.7836E-21, 2.9381E-21, 3.0928E-21, &
      3.2454E-21, 3.3997E-21, 3.5621E-21, 3.7186E-21, 3.8889E-21, 4.0532E-21, &
      4.9025E-21, 6.9827E-21, 6.3039E-21, 6.2986E-21, 6.8268E-21, 6.2085E-21, &
      6.1551E-21, 6.5359E-21, 5.9551E-21, 5.8395E-21, 6.0763E-21, 5.5323E-21, &
      5.3717E-21, 4.6340E-21, 4.2895E-21, 4.2344E-21, 4.1671E-21, 4.0806E-21, &
      3.9767E-21, 3.8499E-21, 3.7118E-21, 3.5550E-21, 3.3887E-21, 3.2214E-21, &
      3.0596E-21, 2.8983E-21, 2.7521E-21, 2.6111E-21, 2.4746E-21, 2.3382E-21, &
      2.1961E-21, 2.0405E-21, 1.8708E-21, 1.6848E-21, 1.4942E-21, 1.3036E-21, &
      1.1191E-21, 9.5739E-22, 8.0675E-22, 6.8119E-22, 5.6803E-22, 4.6322E-22, &
      3.7285E-22, 2.9222E-22, 2.1740E-22, 1.7529E-22 /)
    REAL, PARAMETER :: a1_1_CH3Br(dim55) = (/ &
      1.2436E-20, 1.1803E-20, 1.1260E-20, 1.0261E-20, 9.4053E-21, 8.4245E-21, &
      7.5638E-21, 6.7766E-21, 6.0433E-21, 5.4763E-21, 4.8885E-21, 4.4961E-21, &
      4.0287E-21, 3.7615E-21, 3.3831E-21, 3.2026E-21, 2.8923E-21, 2.7686E-21, &
      2.5064E-21, 2.4245E-21, 2.1965E-21, 2.1471E-21, 1.9454E-21, 1.9185E-21, &
      1.7381E-21, 1.7263E-21, 1.5646E-21, 1.5654E-21, 1.4170E-21, 1.4273E-21, &
      1.2926E-21, 1.3083E-21, 1.1840E-21, 1.2060E-21, 1.0894E-21, 1.1184E-21, &
      1.0072E-21, 1.0391E-21, 9.3573E-22, 9.7059E-22, 8.4366E-22, 7.3783E-22, &
      6.3396E-22, 5.7209E-22, 5.0132E-22, 4.6216E-22, 4.0957E-22, 3.8357E-22, &
      3.2222E-22, 2.9557E-22, 2.7124E-22, 2.4951E-22, 2.2980E-22, 2.1202E-22, &
      1.9559E-22 /)
    REAL, PARAMETER :: b1_1_CH3Br(dim55) = (/ &
      2.8391E-19, 2.8580E-19, 2.8879E-19, 2.9678E-19, 3.0577E-19, 3.1852E-19, &
      3.3186E-19, 3.4603E-19, 3.6106E-19, 3.7410E-19, 3.8909E-19, 4.0008E-19, &
      4.1433E-19, 4.2315E-19, 4.3658E-19, 4.4344E-19, 4.5601E-19, 4.6133E-19, &
      4.7326E-19, 4.7719E-19, 4.8871E-19, 4.9132E-19, 5.0252E-19, 5.0408E-19, &
      5.1499E-19, 5.1574E-19, 5.2632E-19, 5.2627E-19, 5.3673E-19, 5.3598E-19, &
      5.4615E-19, 5.4493E-19, 5.5493E-19, 5.5310E-19, 5.6308E-19, 5.6053E-19, &
      5.7059E-19, 5.6762E-19, 5.7749E-19, 5.7408E-19, 5.8683E-19, 5.9879E-19, &
      6.1183E-19, 6.2037E-19, 6.3102E-19, 6.3740E-19, 6.4663E-19, 6.5152E-19, &
      6.6382E-19, 6.6949E-19, 6.7498E-19, 6.8015E-19, 6.8509E-19, 6.8977E-19, &
      6.9429E-19 /)
    REAL, PARAMETER :: a1_2_CH3Br(dim55) = (/ &
      -2.0544E-23, -7.3964E-24, -3.9306E-24, 5.3467E-24, 8.1191E-24, 1.2401E-23, &
      1.3897E-23, 1.4557E-23, 1.5217E-23, 1.3950E-23, 1.4307E-23, 1.2304E-23, &
      1.2669E-23, 1.0512E-23, 1.0980E-23, 8.9100E-24, 9.4632E-24, 7.5869E-24, &
      8.2115E-24, 6.4987E-24, 7.1805E-24, 5.6087E-24, 6.3197E-24, 4.8762E-24, &
      5.5975E-24, 4.2857E-24, 4.9876E-24, 3.7796E-24, 4.4721E-24, 3.3647E-24, &
      4.0167E-24, 3.0044E-24, 3.6342E-24, 2.6925E-24, 3.3046E-24, 2.4184E-24, &
      3.0076E-24, 2.1896E-24, 2.7524E-24, 1.9822E-24, 2.0882E-24, 1.5991E-24, &
      1.4176E-24, 1.1149E-24, 1.0290E-24, 8.2572E-25, 7.8906E-25, 6.4231E-25, &
      7.4370E-25, 6.7401E-25, 6.1749E-25, 5.6912E-25, 5.2778E-25, 4.9166E-25, &
      4.5970E-25 /)
    REAL, PARAMETER :: b1_2_CH3Br(dim55) = (/ &
      -8.3182E-22, -8.7126E-22, -8.9032E-22, -9.6454E-22, -9.9365E-22, -1.0493E-21, &
      -1.0725E-21, -1.0844E-21, -1.0979E-21, -1.0688E-21, -1.0779E-21, -1.0218E-21, &
      -1.0329E-21, -9.6175E-22, -9.7834E-22, -8.9970E-22, -9.2210E-22, -8.4142E-22, &
      -8.6984E-22, -7.8762E-22, -8.2206E-22, -7.3875E-22, -7.7821E-22, -6.9449E-22, &
      -7.3813E-22, -6.5548E-22, -7.0146E-22, -6.1932E-22, -6.6813E-22, -5.8729E-22, &
      -6.3652E-22, -5.5756E-22, -6.0826E-22, -5.3010E-22, -5.8243E-22, -5.0445E-22, &
      -5.5777E-22, -4.8170E-22, -5.3544E-22, -4.5997E-22, -4.7061E-22, -4.1535E-22, &
      -3.9257E-22, -3.5080E-22, -3.3788E-22, -3.0474E-22, -2.9830E-22, -2.7071E-22, &
      -2.9104E-22, -2.7620E-22, -2.6345E-22, -2.5194E-22, -2.4159E-22, -2.3209E-22, &
      -2.2328E-22 /)
    REAL, PARAMETER :: a2_CH3Br(dim55) = (/ &
      -1.5908E+08, -1.3350E+08, -1.0396E+08, -7.6032E+07, -5.2904E+07, -3.5448E+07, &
      -2.3106E+07, -1.4771E+07, -9.3124E+06, -5.8152E+06, -3.6080E+06, -2.2279E+06, &
      -1.3718E+06, -8.4296E+05, -5.1728E+05, -3.1720E+05, -1.9440E+05, -1.1911E+05, &
      -7.2980E+04, -4.4712E+04, -2.7400E+04, -1.6791E+04, -1.0292E+04, -6.3104E+03, &
      -3.8692E+03, -2.3733E+03, -1.4557E+03, -8.9312E+02, -5.4804E+02, -3.3632E+02, &
      -2.0644E+02, -1.2672E+02, -7.7796E+01, -4.7764E+01, -2.9328E+01, -1.8010E+01, &
      -1.1060E+01, -6.7924E+00, -4.1716E+00, -2.5624E+00, -7.4456E-01, -6.5120E-02, &
      -5.6965E-03, -4.9834E-04, -4.3593E-05, -3.8132E-06, -3.3352E-07, -2.9169E-08, &
      -2.5509E-09, -2.2307E-10, -1.9508E-11, -1.7058E-12, -1.4916E-13, -1.3043E-14, &
      -1.1405E-15 /)
    REAL, PARAMETER :: b2_CH3Br(dim55) = (/ &
       1.6378E+09,  1.5611E+09,  1.3986E+09,  1.1752E+09,  9.3235E+08,  7.0542E+08, &
       5.1412E+08,  3.6410E+08,  2.5219E+08,  1.7176E+08,  1.1547E+08,  7.6830E+07, &
       5.0719E+07,  3.3266E+07,  2.1705E+07,  1.4102E+07,  9.1280E+06,  5.8907E+06, &
       3.7918E+06,  2.4350E+06,  1.5607E+06,  9.9842E+05,  6.3776E+05,  4.0681E+05, &
       2.5911E+05,  1.6487E+05,  1.0477E+05,  6.6513E+04,  4.2185E+04,  2.6729E+04, &
       1.6923E+04,  1.0705E+04,  6.7665E+03,  4.2738E+03,  2.6976E+03,  1.7016E+03, &
       1.0726E+03,  6.7571E+02,  4.2542E+02,  2.6772E+02,  8.5027E+01,  8.2506E+00, &
       7.9295E-01,  7.5597E-02,  7.1580E-03,  6.7378E-04,  6.3101E-05,  5.8833E-06, &
       5.4640E-07,  5.0570E-08,  4.6662E-09,  4.2935E-10,  3.9409E-11,  3.6090E-12, &
       3.2982E-13 /)

    jval_gp(ip_CH3Br)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH3Br(0) = &
          p1(a0_1_1_CH3Br(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CH3Br(i0(j,k)), &
          a0_2_1_CH3Br(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CH3Br(i0(j,k)),v3_du1(j,k))
        sig_CH3Br(1) = &
          (p1(b1_1_CH3Br(i1(j,k)),a1_1_CH3Br(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CH3Br(i1(j,k)),a1_2_CH3Br(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CH3Br(2) = &
          p1(b2_CH3Br(i2(j,k)), a2_CH3Br(i2(j,k)), &
          v3_du1(j,k))*1.E-30
        dj = 0. &
          + sig_CH3Br(0) * fint(j,k,0) &
          + sig_CH3Br(1) * fint(j,k,1) &
          + sig_CH3Br(2) * fint(j,k,2)

        jval_gp(ip_CH3Br)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CH3Br

  ! **************************************************************************

  SUBROUTINE jval_cal_CF2ClBr(jrow)

    ! CF2ClBr -> products JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CF2ClBr

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CF2ClBr(dim58) = (/ &
      1.3498E-20, 1.4684E-20, 1.5981E-20, 1.7296E-20, 1.8654E-20, 2.0034E-20, &
      2.1489E-20, 2.2927E-20, 2.4445E-20, 2.5986E-20, 2.7562E-20, 2.9189E-20, &
      3.1034E-20, 3.3167E-20, 3.4772E-20, 3.6516E-20, 3.8402E-20, 3.9880E-20, &
      4.1420E-20, 4.3038E-20, 4.4141E-20, 4.5298E-20, 4.6439E-20, 4.7111E-20, &
      4.7835E-20, 4.8120E-20, 4.8471E-20, 4.8888E-20, 4.9110E-20, 4.9208E-20, &
      4.9074E-20, 4.8713E-20, 4.8153E-20, 4.7384E-20, 4.6519E-20, 4.5521E-20, &
      4.4617E-20, 4.3755E-20, 4.3019E-20, 4.2369E-20, 4.1844E-20, 4.1321E-20, &
      4.0741E-20, 4.0003E-20, 3.8831E-20, 3.7594E-20, 3.5617E-20, 3.3720E-20, &
      3.1356E-20, 2.9116E-20, 2.6861E-20, 2.4695E-20, 2.2541E-20, 2.0307E-20, &
      1.8124E-20, 1.5854E-20, 1.3246E-20, 1.0956E-20 /)
    REAL, PARAMETER :: a0_1_2_CF2ClBr(dim58) = (/ &
      7.6532E-20, 2.4130E-20, -3.3451E-20, -9.2094E-20, -1.5293E-19, -2.1502E-19, &
      -2.8080E-19, -3.4608E-19, -4.1531E-19, -4.8590E-19, -5.5839E-19, -6.3356E-19, &
      -7.1916E-19, -8.1855E-19, -8.9369E-19, -9.7563E-19, -1.0647E-18, -1.1347E-18, &
      -1.2080E-18, -1.2854E-18, -1.3383E-18, -1.3941E-18, -1.4493E-18, -1.4819E-18, &
      -1.5173E-18, -1.5312E-18, -1.5485E-18, -1.5691E-18, -1.5801E-18, -1.5850E-18, &
      -1.5783E-18, -1.5602E-18, -1.5320E-18, -1.4931E-18, -1.4491E-18, -1.3982E-18, &
      -1.3519E-18, -1.3076E-18, -1.2697E-18, -1.2360E-18, -1.2087E-18, -1.1814E-18, &
      -1.1510E-18, -1.1122E-18, -1.0503E-18, -9.8475E-19, -8.7953E-19, -7.7825E-19, &
      -6.5153E-19, -5.3102E-19, -4.0923E-19, -2.9188E-19, -1.7469E-19, -5.2716E-20, &
      6.6944E-20, 1.9179E-19, 3.3575E-19, 4.6262E-19 /)
    REAL, PARAMETER :: a0_2_1_CF2ClBr(dim58) = (/ &
      -6.6796E-23, -7.1895E-23, -7.8356E-23, -8.4432E-23, -9.0483E-23, -9.6628E-23, &
      -1.0392E-22, -1.0975E-22, -1.1689E-22, -1.2381E-22, -1.3067E-22, -1.3757E-22, &
      -1.5116E-22, -1.7531E-22, -1.7726E-22, -1.8441E-22, -1.9709E-22, -1.9722E-22, &
      -2.0209E-22, -2.1184E-22, -2.0862E-22, -2.1017E-22, -2.1465E-22, -2.0849E-22, &
      -2.0639E-22, -1.9526E-22, -1.8881E-22, -1.8641E-22, -1.8275E-22, -1.7917E-22, &
      -1.7453E-22, -1.6915E-22, -1.6313E-22, -1.5649E-22, -1.4967E-22, -1.4200E-22, &
      -1.3590E-22, -1.2948E-22, -1.2413E-22, -1.1809E-22, -1.1359E-22, -1.0784E-22, &
      -1.0291E-22, -9.7699E-23, -8.9985E-23, -8.4226E-23, -7.2708E-23, -6.6490E-23, &
      -5.6542E-23, -4.9105E-23, -4.1673E-23, -3.6082E-23, -3.0452E-23, -2.3609E-23, &
      -2.0237E-23, -1.5871E-23, -1.1676E-23, -8.9461E-24 /)
    REAL, PARAMETER :: a0_2_2_CF2ClBr(dim58) = (/ &
      4.4052E-21, 4.6306E-21, 4.9174E-21, 5.1884E-21, 5.4595E-21, 5.7360E-21, &
      6.0656E-21, 6.3302E-21, 6.6560E-21, 6.9729E-21, 7.2883E-21, 7.6073E-21, &
      8.2376E-21, 9.3633E-21, 9.4545E-21, 9.7904E-21, 1.0389E-20, 1.0395E-20, &
      1.0627E-20, 1.1093E-20, 1.0939E-20, 1.1013E-20, 1.1230E-20, 1.0931E-20, &
      1.0828E-20, 1.0283E-20, 9.9654E-21, 9.8469E-21, 9.6654E-21, 9.4869E-21, &
      9.2551E-21, 8.9850E-21, 8.6814E-21, 8.3455E-21, 7.9990E-21, 7.6080E-21, &
      7.2957E-21, 6.9659E-21, 6.6894E-21, 6.3765E-21, 6.1429E-21, 5.8425E-21, &
      5.5840E-21, 5.3101E-21, 4.9028E-21, 4.5976E-21, 3.9848E-21, 3.6528E-21, &
      3.1196E-21, 2.7195E-21, 2.3181E-21, 2.0151E-21, 1.7088E-21, 1.3352E-21, &
      1.1504E-21, 9.1030E-22, 6.7871E-22, 5.2748E-22 /)
    REAL, PARAMETER :: a0_3_1_CF2ClBr(dim58) = (/ &
      9.8644E-26, 1.0497E-25, 1.1611E-25, 1.2560E-25, 1.3432E-25, 1.4358E-25, &
      1.5765E-25, 1.6472E-25, 1.7774E-25, 1.8978E-25, 2.0107E-25, 2.1223E-25, &
      2.6254E-25, 3.7613E-25, 3.5203E-25, 3.6009E-25, 3.9884E-25, 3.7168E-25, &
      3.7397E-25, 4.0168E-25, 3.7007E-25, 3.6485E-25, 3.7676E-25, 3.4353E-25, &
      3.3159E-25, 2.8501E-25, 2.6071E-25, 2.5442E-25, 2.4567E-25, 2.3813E-25, &
      2.2883E-25, 2.1878E-25, 2.0806E-25, 1.9669E-25, 1.8546E-25, 1.7143E-25, &
      1.6394E-25, 1.5260E-25, 1.4535E-25, 1.3509E-25, 1.2834E-25, 1.1811E-25, &
      1.1169E-25, 1.0470E-25, 9.3357E-26, 8.8221E-26, 6.8953E-26, 6.3976E-26, &
      5.0877E-26, 4.2565E-26, 3.3130E-26, 3.0095E-26, 2.2305E-26, 1.2999E-26, &
      1.3685E-26, 9.0264E-27, 4.9206E-27, 3.4715E-27 /)
    REAL, PARAMETER :: a0_3_2_CF2ClBr(dim58) = (/ &
      -6.4682E-24, -6.7476E-24, -7.2424E-24, -7.6657E-24, -8.0563E-24, -8.4731E-24, &
      -9.1089E-24, -9.4298E-24, -1.0024E-23, -1.0575E-23, -1.1094E-23, -1.1610E-23, &
      -1.3944E-23, -1.9238E-23, -1.8110E-23, -1.8489E-23, -2.0318E-23, -1.9030E-23, &
      -1.9139E-23, -2.0464E-23, -1.8946E-23, -1.8695E-23, -1.9272E-23, -1.7656E-23, &
      -1.7074E-23, -1.4791E-23, -1.3596E-23, -1.3285E-23, -1.2851E-23, -1.2476E-23, &
      -1.2011E-23, -1.1506E-23, -1.0966E-23, -1.0390E-23, -9.8198E-24, -9.1046E-24, &
      -8.7208E-24, -8.1378E-24, -7.7637E-24, -7.2325E-24, -6.8815E-24, -6.3474E-24, &
      -6.0110E-24, -5.6435E-24, -5.0445E-24, -4.7723E-24, -3.7472E-24, -3.4814E-24, &
      -2.7793E-24, -2.3322E-24, -1.8227E-24, -1.6581E-24, -1.2344E-24, -7.2627E-25, &
      -7.6387E-25, -5.0765E-25, -2.8101E-25, -2.0073E-25 /)
    REAL, PARAMETER :: a1_1_CF2ClBr(dim55) = (/ &
      2.0028E-20, 1.8759E-20, 1.7529E-20, 1.5764E-20, 1.4118E-20, 1.2489E-20, &
      1.0926E-20, 9.6872E-21, 8.4009E-21, 7.5491E-21, 6.5409E-21, 5.9860E-21, &
      5.1993E-21, 4.8511E-21, 4.2080E-21, 3.9972E-21, 3.4924E-21, 3.3461E-21, &
      2.9265E-21, 2.8615E-21, 2.4921E-21, 2.4583E-21, 2.1419E-21, 2.1321E-21, &
      1.8618E-21, 1.8804E-21, 1.6256E-21, 1.6513E-21, 1.4329E-21, 1.4744E-21, &
      1.2639E-21, 1.3276E-21, 1.1220E-21, 1.1869E-21, 1.0121E-21, 1.0717E-21, &
      9.1772E-22, 9.7181E-22, 8.2296E-22, 8.8546E-22, 7.2581E-22, 6.0565E-22, &
      4.8820E-22, 4.2438E-22, 3.4663E-22, 3.1229E-22, 2.5741E-22, 2.3951E-22, &
      1.7559E-22, 1.5618E-22, 1.3591E-22, 1.2245E-22, 1.1025E-22, 9.6003E-23, &
      8.6482E-23 /)
    REAL, PARAMETER :: b1_1_CF2ClBr(dim55) = (/ &
      6.1395E-19, 6.1776E-19, 6.2453E-19, 6.3865E-19, 6.5593E-19, 6.7710E-19, &
      7.0133E-19, 7.2363E-19, 7.5000E-19, 7.6959E-19, 7.9530E-19, 8.1084E-19, &
      8.3483E-19, 8.4632E-19, 8.6915E-19, 8.7716E-19, 8.9760E-19, 9.0390E-19, &
      9.2299E-19, 9.2611E-19, 9.4476E-19, 9.4655E-19, 9.6411E-19, 9.6469E-19, &
      9.8104E-19, 9.7987E-19, 9.9655E-19, 9.9481E-19, 1.0102E-18, 1.0072E-18, &
      1.0231E-18, 1.0181E-18, 1.0346E-18, 1.0293E-18, 1.0442E-18, 1.0390E-18, &
      1.0529E-18, 1.0479E-18, 1.0621E-18, 1.0560E-18, 1.0720E-18, 1.0856E-18, &
      1.1003E-18, 1.1091E-18, 1.1208E-18, 1.1264E-18, 1.1361E-18, 1.1394E-18, &
      1.1522E-18, 1.1564E-18, 1.1609E-18, 1.1641E-18, 1.1672E-18, 1.1710E-18, &
      1.1736E-18 /)
    REAL, PARAMETER :: a1_2_CF2ClBr(dim55) = (/ &
      -2.3441E-23, -3.4988E-24, 3.8777E-24, 1.6411E-23, 2.1992E-23, 2.6012E-23, &
      2.9170E-23, 2.7558E-23, 2.9184E-23, 2.4997E-23, 2.6122E-23, 2.1214E-23, &
      2.2291E-23, 1.7535E-23, 1.8858E-23, 1.4527E-23, 1.5790E-23, 1.2128E-23, &
      1.3434E-23, 1.0084E-23, 1.1485E-23, 8.5938E-24, 9.9287E-24, 7.3665E-24, &
      8.6518E-24, 6.2857E-24, 7.5692E-24, 5.5349E-24, 6.7235E-24, 4.8236E-24, &
      5.9329E-24, 4.2419E-24, 5.3530E-24, 3.7087E-24, 4.7498E-24, 3.3437E-24, &
      4.2717E-24, 2.9522E-24, 3.8837E-24, 2.6791E-24, 2.8173E-24, 2.0852E-24, &
      1.7974E-24, 1.3634E-24, 1.2378E-24, 9.5241E-25, 8.9751E-25, 6.9227E-25, &
      8.0034E-25, 6.9451E-25, 6.1591E-25, 5.4002E-25, 4.7683E-25, 4.3358E-25, &
      3.8370E-25 /)
    REAL, PARAMETER :: b1_2_CF2ClBr(dim55) = (/ &
      -1.3410E-21, -1.4008E-21, -1.4414E-21, -1.5417E-21, -1.6003E-21, -1.6525E-21, &
      -1.7015E-21, -1.6725E-21, -1.7058E-21, -1.6095E-21, -1.6382E-21, -1.5008E-21, &
      -1.5336E-21, -1.3767E-21, -1.4236E-21, -1.2591E-21, -1.3102E-21, -1.1527E-21, &
      -1.2122E-21, -1.0513E-21, -1.1221E-21, -9.6888E-22, -1.0430E-21, -8.9436E-22, &
      -9.7212E-22, -8.2306E-22, -9.0712E-22, -7.6879E-22, -8.5259E-22, -7.1390E-22, &
      -7.9765E-22, -6.6576E-22, -7.5519E-22, -6.1872E-22, -7.0773E-22, -5.8399E-22, &
      -6.6798E-22, -5.4527E-22, -6.3422E-22, -5.1618E-22, -5.3006E-22, -4.4734E-22, &
      -4.1121E-22, -3.5133E-22, -3.3241E-22, -2.8590E-22, -2.7627E-22, -2.3768E-22, &
      -2.5935E-22, -2.3681E-22, -2.1908E-22, -2.0102E-22, -1.8519E-22, -1.7382E-22, &
      -1.6008E-22 /)
    REAL, PARAMETER :: a2_CF2ClBr(dim55) = (/ &
      -1.1401E-21, -9.5800E-22, -7.4976E-22, -5.5316E-22, -3.9004E-22, -2.6636E-22, &
      -1.7820E-22, -1.1796E-22, -7.7896E-23, -5.1644E-23, -3.4604E-23, -2.3556E-23, &
      -1.6372E-23, -1.1660E-23, -8.5400E-24, -6.4360E-24, -4.9920E-24, -3.9880E-24, &
      -3.2600E-24, -2.7280E-24, -2.3240E-24, -2.0160E-24, -1.7720E-24, -1.5720E-24, &
      -1.4080E-24, -1.2680E-24, -1.1520E-24, -1.0480E-24, -9.6000E-25, -8.8400E-25, &
      -8.1199E-25, -7.5201E-25, -6.9200E-25, -6.4400E-25, -6.0000E-25, -5.5200E-25, &
      -5.1601E-25, -4.7999E-25, -4.4800E-25, -4.2000E-25, -3.4080E-25, -2.4400E-25, &
      -1.7440E-25, -1.2560E-25, -9.0400E-26, -6.5599E-26, -4.7199E-26, -3.3600E-26, &
      -2.4002E-26, -1.7600E-26, -1.2799E-26, -9.6006E-27, -6.3997E-27, -4.8003E-27, &
      -3.1989E-27 /)
    REAL, PARAMETER :: b2_CF2ClBr(dim55) = (/ &
       1.2482E-20,  1.1936E-20,  1.0790E-20,  9.2177E-21,  7.5049E-21,  5.8971E-21, &
       4.5306E-21,  3.4463E-21,  2.6250E-21,  2.0212E-21,  1.5867E-21,  1.2773E-21, &
       1.0582E-21,  9.0270E-22,  7.9194E-22,  7.1199E-22,  6.5351E-22,  6.1033E-22, &
       5.7721E-22,  5.5167E-22,  5.3127E-22,  5.1495E-22,  5.0141E-22,  4.8981E-22, &
       4.7988E-22,  4.7106E-22,  4.6347E-22,  4.5639E-22,  4.5019E-22,  4.4464E-22, &
       4.3921E-22,  4.3453E-22,  4.2970E-22,  4.2571E-22,  4.2195E-22,  4.1773E-22, &
       4.1447E-22,  4.1112E-22,  4.0806E-22,  4.0532E-22,  3.9736E-22,  3.8642E-22, &
       3.7769E-22,  3.7095E-22,  3.6566E-22,  3.6161E-22,  3.5838E-22,  3.5583E-22, &
       3.5390E-22,  3.5254E-22,  3.5146E-22,  3.5069E-22,  3.4989E-22,  3.4947E-22, &
       3.4903E-22 /)

    jval_gp(ip_CF2ClBr)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CF2ClBr(0) = &
          p2(a0_1_1_CF2ClBr(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CF2ClBr(i0(j,k)), &
          a0_2_1_CF2ClBr(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CF2ClBr(i0(j,k)), &
          a0_3_1_CF2ClBr(i0(j,k))*dlv2(j,k) + &
          a0_3_2_CF2ClBr(i0(j,k)), v3_du1(j,k))
        sig_CF2ClBr(1) = &
          (p1(b1_1_CF2ClBr(i1(j,k)),a1_1_CF2ClBr(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CF2ClBr(i1(j,k)),a1_2_CF2ClBr(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CF2ClBr(2) = &
          p1(b2_CF2ClBr(i2(j,k)), a2_CF2ClBr(i2(j,k)), &
          v3_du1(j,k))
        dj = 0. &
          + sig_CF2ClBr(0) * fint(j,k,0) &
          + sig_CF2ClBr(1) * fint(j,k,1) &
          + sig_CF2ClBr(2) * fint(j,k,2)

        jval_gp(ip_CF2ClBr)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CF2ClBr

  ! **************************************************************************

  SUBROUTINE jval_cal_cf3br(jrow)

    ! CF3Br -> products
    ! JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_cf3br 

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_cf3br(dim58) = (/ &
      1.3854E-21, 1.5073E-21, 1.6332E-21, 1.7654E-21, 1.9000E-21, 2.0365E-21, &
      2.1763E-21, 2.3179E-21, 2.4619E-21, 2.6092E-21, 2.7590E-21, 2.9129E-21, &
      3.2055E-21, 3.7585E-21, 3.7582E-21, 3.8913E-21, 4.1401E-21, 4.1247E-21, &
      4.2257E-21, 4.4262E-21, 4.3782E-21, 4.4315E-21, 4.5676E-21, 4.4867E-21, &
      4.4963E-21, 4.3315E-21, 4.2587E-21, 4.2652E-21, 4.2485E-21, 4.2205E-21, &
      4.1739E-21, 4.0960E-21, 4.0104E-21, 3.9003E-21, 3.7856E-21, 3.6608E-21, &
      3.5434E-21, 3.4269E-21, 3.3282E-21, 3.2214E-21, 3.1472E-21, 3.0468E-21, &
      2.9581E-21, 2.8571E-21, 2.7369E-21, 2.5933E-21, 2.4351E-21, 2.2576E-21, &
      2.0831E-21, 1.9199E-21, 1.7469E-21, 1.5933E-21, 1.4406E-21, 1.2961E-21, &
      1.1410E-21, 9.8921E-22, 8.2527E-22, 6.8060E-22 /)
    REAL, PARAMETER :: a0_1_2_cf3br(dim58) = (/ &
      1.4458E-20, 9.0742E-21, 3.4811E-21, -2.4141E-21, -8.4427E-21, -1.4589E-20, &
      -2.0905E-20, -2.7336E-20, -3.3901E-20, -4.0647E-20, -4.7535E-20, -5.4646E-20, &
      -6.8226E-20, -9.3995E-20, -9.3980E-20, -1.0024E-19, -1.1198E-19, -1.1125E-19, &
      -1.1606E-19, -1.2564E-19, -1.2333E-19, -1.2590E-19, -1.3249E-19, -1.2856E-19, &
      -1.2903E-19, -1.2096E-19, -1.1737E-19, -1.1769E-19, -1.1687E-19, -1.1547E-19, &
      -1.1314E-19, -1.0923E-19, -1.0491E-19, -9.9346E-20, -9.3517E-20, -8.7156E-20, &
      -8.1144E-20, -7.5157E-20, -7.0062E-20, -6.4531E-20, -6.0671E-20, -5.5432E-20, &
      -5.0783E-20, -4.5471E-20, -3.9121E-20, -3.1511E-20, -2.3098E-20, -1.3617E-20, &
      -4.2653E-21, 4.5142E-21, 1.3858E-20, 2.2185E-20, 3.0489E-20, 3.8380E-20, &
      4.6877E-20, 5.5227E-20, 6.4277E-20, 7.2292E-20 /)
    REAL, PARAMETER :: a0_2_1_cf3br(dim58) = (/ &
      -5.2038E-24, -5.6312E-24, -6.0743E-24, -6.5437E-24, -7.0131E-24, -7.4893E-24, &
      -7.9699E-24, -8.4505E-24, -8.9399E-24, -9.4310E-24, -9.9300E-24, -1.0439E-23, &
      -1.2988E-23, -1.9204E-23, -1.7179E-23, -1.7171E-23, -1.8722E-23, -1.6900E-23, &
      -1.6743E-23, -1.7859E-23, -1.6164E-23, -1.5825E-23, -1.6483E-23, -1.4944E-23, &
      -1.4473E-23, -1.2403E-23, -1.1369E-23, -1.1271E-23, -1.1007E-23, -1.0793E-23, &
      -1.0543E-23, -1.0110E-23, -9.7791E-24, -9.3151E-24, -8.8649E-24, -8.4355E-24, &
      -7.9576E-24, -7.5235E-24, -7.1836E-24, -6.7376E-24, -6.4460E-24, -6.0445E-24, &
      -5.6818E-24, -5.3149E-24, -4.8795E-24, -4.4032E-24, -3.9282E-24, -3.4135E-24, &
      -3.0052E-24, -2.5880E-24, -2.1969E-24, -1.8709E-24, -1.5832E-24, -1.3547E-24, &
      -1.0368E-24, -8.4706E-25, -6.6086E-25, -5.1357E-25 /)
    REAL, PARAMETER :: a0_2_2_cf3br(dim58) = (/ &
      3.3204E-22, 3.5093E-22, 3.7060E-22, 3.9154E-22, 4.1257E-22, 4.3400E-22, &
      4.5572E-22, 4.7754E-22, 4.9986E-22, 5.2235E-22, 5.4530E-22, 5.6881E-22, &
      6.8707E-22, 9.7676E-22, 8.8197E-22, 8.8160E-22, 9.5481E-22, 8.6844E-22, &
      8.6098E-22, 9.1431E-22, 8.3295E-22, 8.1663E-22, 8.4848E-22, 7.7366E-22, &
      7.5072E-22, 6.4926E-22, 5.9839E-22, 5.9356E-22, 5.8047E-22, 5.6981E-22, &
      5.5732E-22, 5.3556E-22, 5.1889E-22, 4.9541E-22, 4.7254E-22, 4.5064E-22, &
      4.2617E-22, 4.0386E-22, 3.8632E-22, 3.6322E-22, 3.4805E-22, 3.2709E-22, &
      3.0809E-22, 2.8879E-22, 2.6580E-22, 2.4056E-22, 2.1529E-22, 1.8780E-22, &
      1.6592E-22, 1.4347E-22, 1.2235E-22, 1.0468E-22, 8.9030E-23, 7.6556E-23, &
      5.9134E-23, 4.8699E-23, 3.8421E-23, 3.0261E-23 /)
    REAL, PARAMETER :: a1_1_cf3br(dim55) = (/ &
      2.2966E-21, 2.1603E-21, 2.0271E-21, 1.8291E-21, 1.6438E-21, 1.4567E-21, &
      1.2777E-21, 1.1340E-21, 9.8396E-22, 8.8481E-22, 7.6605E-22, 7.0121E-22, &
      6.0762E-22, 5.6658E-22, 4.9178E-22, 4.6565E-22, 4.0423E-22, 3.9041E-22, &
      3.3764E-22, 3.3168E-22, 2.8569E-22, 2.8446E-22, 2.4347E-22, 2.4602E-22, &
      2.1053E-22, 2.1566E-22, 1.8284E-22, 1.8964E-22, 1.5963E-22, 1.6657E-22, &
      1.4175E-22, 1.4939E-22, 1.2422E-22, 1.3336E-22, 1.1188E-22, 1.1992E-22, &
      9.9329E-23, 1.0809E-22, 9.0194E-23, 9.8760E-23, 7.8060E-23, 6.4918E-23, &
      5.0450E-23, 4.4056E-23, 3.4598E-23, 3.0947E-23, 2.4847E-23, 2.2508E-23, &
      1.5031E-23, 1.3354E-23, 1.1186E-23, 9.8104E-24, 8.4600E-24, 7.0104E-24, &
      6.0622E-24 /)
    REAL, PARAMETER :: b1_1_cf3br(dim55) = (/ &
      5.4600E-20, 5.5009E-20, 5.5742E-20, 5.7326E-20, 5.9272E-20, 6.1703E-20, &
      6.4478E-20, 6.7065E-20, 7.0141E-20, 7.2421E-20, 7.5450E-20, 7.7265E-20, &
      8.0120E-20, 8.1474E-20, 8.4129E-20, 8.5123E-20, 8.7610E-20, 8.8204E-20, &
      9.0605E-20, 9.0891E-20, 9.3214E-20, 9.3279E-20, 9.5554E-20, 9.5406E-20, &
      9.7553E-20, 9.7230E-20, 9.9380E-20, 9.8918E-20, 1.0103E-19, 1.0053E-19, &
      1.0240E-19, 1.0180E-19, 1.0383E-19, 1.0307E-19, 1.0491E-19, 1.0420E-19, &
      1.0606E-19, 1.0525E-19, 1.0696E-19, 1.0612E-19, 1.0820E-19, 1.0968E-19, &
      1.1150E-19, 1.1238E-19, 1.1381E-19, 1.1440E-19, 1.1547E-19, 1.1591E-19, &
      1.1741E-19, 1.1777E-19, 1.1826E-19, 1.1858E-19, 1.1892E-19, 1.1930E-19, &
      1.1956E-19 /)
    REAL, PARAMETER :: a1_2_cf3br(dim55) = (/ &
      -2.9653E-24, -6.3129E-25, 2.3402E-25, 1.7352E-24, 2.4079E-24, 2.9337E-24, &
      3.3238E-24, 3.1725E-24, 3.3949E-24, 2.9171E-24, 3.0717E-24, 2.4976E-24, &
      2.6451E-24, 2.0818E-24, 2.2374E-24, 1.7307E-24, 1.8982E-24, 1.4346E-24, &
      1.6156E-24, 1.1994E-24, 1.3860E-24, 1.0181E-24, 1.2045E-24, 8.7354E-25, &
      1.0451E-24, 7.4266E-25, 9.2128E-25, 6.5012E-25, 8.0963E-25, 5.7418E-25, &
      7.1762E-25, 4.9753E-25, 6.4107E-25, 4.4451E-25, 5.7017E-25, 3.8961E-25, &
      5.1793E-25, 3.4951E-25, 4.5986E-25, 3.1055E-25, 3.3762E-25, 2.4529E-25, &
      2.1520E-25, 1.5901E-25, 1.4606E-25, 1.1122E-25, 1.0424E-25, 8.0884E-26, &
      9.3966E-26, 8.0337E-26, 7.0267E-26, 6.1231E-26, 5.3663E-26, 4.8239E-26, &
      4.2865E-26 /)
    REAL, PARAMETER :: b1_2_cf3br(dim55) = (/ &
      -1.5357E-22, -1.6057E-22, -1.6533E-22, -1.7734E-22, -1.8440E-22, -1.9124E-22, &
      -1.9728E-22, -1.9456E-22, -1.9912E-22, -1.8813E-22, -1.9207E-22, -1.7600E-22, &
      -1.8050E-22, -1.6191E-22, -1.6743E-22, -1.4818E-22, -1.5496E-22, -1.3503E-22, &
      -1.4326E-22, -1.2328E-22, -1.3271E-22, -1.1321E-22, -1.2355E-22, -1.0436E-22, &
      -1.1474E-22, -9.5684E-23, -1.0738E-22, -8.8945E-23, -1.0019E-22, -8.3003E-23, &
      -9.3833E-23, -7.6666E-23, -8.8220E-23, -7.1906E-23, -8.2650E-23, -6.6760E-23, &
      -7.8374E-23, -6.2711E-23, -7.3249E-23, -5.8617E-23, -6.1337E-23, -5.0904E-23, &
      -4.7128E-23, -3.9374E-23, -3.7424E-23, -3.1746E-23, -3.0520E-23, -2.6130E-23, &
      -2.8753E-23, -2.5850E-23, -2.3579E-23, -2.1428E-23, -1.9532E-23, -1.8106E-23, &
      -1.6625E-23 /)

    jval_gp(ip_cf3br)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CF3Br(0) = p1( &
          a0_1_1_CF3Br(i0(j,k))*dlv2(j,k) + a0_1_2_CF3Br(i0(j,k)), &
          a0_2_1_CF3Br(i0(j,k))*dlv2(j,k) + a0_2_2_CF3Br(i0(j,k)), &
          v3_du1(j,k))
        sig_CF3Br(1) = p1( &
          b1_1_CF3Br(i1(j,k)),a1_1_CF3Br(i1(j,k)),v3_du1(j,k)) + &
          p1(b1_2_CF3Br(i1(j,k)),a1_2_CF3Br(i1(j,k)),v3_du1(j,k)) &
          * v2s_m(j,k)
        dj = &
          sig_CF3Br(0) * fint(j,k,0) + &
          sig_CF3Br(1) * fint(j,k,1)
        jval_gp(ip_cf3br)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_cf3br

  ! **************************************************************************

  SUBROUTINE jval_cal_CH3I(jrow)

    ! CH3I -> products Roehl et al., JGR. 102, 12819-12829 (1997)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH3I

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CH3I(dim58) = (/ &
      1.0275E-20, 1.1319E-20, 1.2428E-20, 1.3623E-20, 1.4884E-20, 1.6215E-20, &
      1.7644E-20, 1.9136E-20, 2.0744E-20, 2.2439E-20, 2.4263E-20, 2.6226E-20, &
      2.9201E-20, 3.4092E-20, 3.5513E-20, 3.7909E-20, 4.1313E-20, 4.2930E-20, &
      4.5499E-20, 4.9024E-20, 5.0711E-20, 5.3337E-20, 5.6944E-20, 5.8724E-20, &
      6.1521E-20, 6.2634E-20, 6.4807E-20, 6.7906E-20, 7.0996E-20, 7.4047E-20, &
      7.6959E-20, 7.9721E-20, 8.2290E-20, 8.4666E-20, 8.6984E-20, 8.9193E-20, &
      9.1550E-20, 9.4075E-20, 9.6894E-20, 1.0009E-19, 1.0357E-19, 1.0729E-19, &
      1.1105E-19, 1.1443E-19, 1.1727E-19, 1.1922E-19, 1.1974E-19, 1.1927E-19, &
      1.1757E-19, 1.1504E-19, 1.1182E-19, 1.0809E-19, 1.0364E-19, 9.8379E-20, &
      9.2081E-20, 8.4180E-20, 7.4104E-20, 6.4631E-20 /)
    REAL, PARAMETER :: a0_1_2_CH3I(dim58) = (/ &
      2.9539E-20, -1.6587E-20, -6.5836E-20, -1.1911E-19, -1.7564E-19, -2.3552E-19, &
      -3.0009E-19, -3.6783E-19, -4.4116E-19, -5.1880E-19, -6.0271E-19, -6.9340E-19, &
      -8.3143E-19, -1.0593E-18, -1.1259E-18, -1.2385E-18, -1.3991E-18, -1.4758E-18, &
      -1.5981E-18, -1.7666E-18, -1.8475E-18, -1.9741E-18, -2.1487E-18, -2.2352E-18, &
      -2.3717E-18, -2.4263E-18, -2.5331E-18, -2.6862E-18, -2.8395E-18, -2.9914E-18, &
      -3.1370E-18, -3.2757E-18, -3.4052E-18, -3.5254E-18, -3.6431E-18, -3.7558E-18, &
      -3.8765E-18, -4.0063E-18, -4.1517E-18, -4.3172E-18, -4.4984E-18, -4.6926E-18, &
      -4.8896E-18, -5.0670E-18, -5.2171E-18, -5.3203E-18, -5.3482E-18, -5.3232E-18, &
      -5.2320E-18, -5.0959E-18, -4.9221E-18, -4.7198E-18, -4.4780E-18, -4.1905E-18, &
      -3.8453E-18, -3.4108E-18, -2.8546E-18, -2.3298E-18 /)
    REAL, PARAMETER :: a0_2_1_CH3I(dim58) = (/ &
      -3.1474E-23, -3.4140E-23, -3.6869E-23, -3.9816E-23, -4.2742E-23, -4.5713E-23, &
      -4.8824E-23, -5.1849E-23, -5.5074E-23, -5.8232E-23, -6.1492E-23, -6.4946E-23, &
      -8.1762E-23, -1.2408E-22, -1.1276E-22, -1.1462E-22, -1.2836E-22, -1.1775E-22, &
      -1.1921E-22, -1.3143E-22, -1.2137E-22, -1.2233E-22, -1.3302E-22, -1.2384E-22, &
      -1.2483E-22, -1.0871E-22, -1.0299E-22, -1.0618E-22, -1.0936E-22, -1.1244E-22, &
      -1.1519E-22, -1.1765E-22, -1.1960E-22, -1.2114E-22, -1.2244E-22, -1.2349E-22, &
      -1.2466E-22, -1.2598E-22, -1.2777E-22, -1.3018E-22, -1.3271E-22, -1.3565E-22, &
      -1.3835E-22, -1.3963E-22, -1.3999E-22, -1.3860E-22, -1.3474E-22, -1.2903E-22, &
      -1.2239E-22, -1.1487E-22, -1.0663E-22, -9.9044E-23, -9.0349E-23, -8.1533E-23, &
      -7.2380E-23, -6.2378E-23, -5.1980E-23, -4.4486E-23 /)
    REAL, PARAMETER :: a0_2_2_CH3I(dim58) = (/ &
      2.7039E-21, 2.8217E-21, 2.9429E-21, 3.0743E-21, 3.2054E-21, 3.3391E-21, &
      3.4797E-21, 3.6171E-21, 3.7641E-21, 3.9087E-21, 4.0587E-21, 4.2183E-21, &
      4.9985E-21, 6.9706E-21, 6.4407E-21, 6.5281E-21, 7.1768E-21, 6.6740E-21, &
      6.7433E-21, 7.3272E-21, 6.8445E-21, 6.8909E-21, 7.4084E-21, 6.9622E-21, &
      7.0105E-21, 6.2206E-21, 5.9392E-21, 6.0969E-21, 6.2545E-21, 6.4079E-21, &
      6.5451E-21, 6.6687E-21, 6.7670E-21, 6.8449E-21, 6.9109E-21, 6.9645E-21, &
      7.0245E-21, 7.0922E-21, 7.1846E-21, 7.3095E-21, 7.4411E-21, 7.5944E-21, &
      7.7362E-21, 7.8031E-21, 7.8226E-21, 7.7486E-21, 7.5435E-21, 7.2384E-21, &
      6.8824E-21, 6.4781E-21, 6.0328E-21, 5.6218E-21, 5.1488E-21, 4.6675E-21, &
      4.1659E-21, 3.6158E-21, 3.0418E-21, 2.6267E-21 /)
    REAL, PARAMETER :: a1_1_CH3I(dim55) = (/ &
      -5.1800E-21, -4.4615E-21, -3.6864E-21, -3.0356E-21, -2.3551E-21, -1.9033E-21, &
      -1.4068E-21, -1.1423E-21, -8.1028E-22, -6.7443E-22, -4.5656E-22, -3.9514E-22, &
      -2.4853E-22, -2.2658E-22, -1.2258E-22, -1.2115E-22, -4.2807E-23, -5.1732E-23, &
      1.0549E-23, -3.7404E-24, 4.8248E-23, 3.0849E-23, 7.6044E-23, 5.6662E-23, &
      9.7152E-23, 7.6778E-23, 1.1338E-22, 9.2404E-23, 1.2615E-22, 1.0504E-22, &
      1.3640E-22, 1.1520E-22, 1.4455E-22, 1.2349E-22, 1.5118E-22, 1.3026E-22, &
      1.5655E-22, 1.3572E-22, 1.6086E-22, 1.4031E-22, 1.5841E-22, 1.5955E-22, &
      1.6618E-22, 1.6368E-22, 1.6674E-22, 1.6268E-22, 1.6365E-22, 1.5889E-22, &
      1.6206E-22, 1.5716E-22, 1.5221E-22, 1.4724E-22, 1.4230E-22, 1.3741E-22, &
      1.3260E-22 /)
    REAL, PARAMETER :: b1_1_CH3I(dim55) = (/ &
      1.3345E-19, 1.3129E-19, 1.2703E-19, 1.2182E-19, 1.1468E-19, 1.0880E-19, &
      1.0111E-19, 9.6346E-20, 8.9540E-20, 8.6415E-20, 8.0859E-20, 7.9140E-20, &
      7.4668E-20, 7.3944E-20, 7.0252E-20, 7.0198E-20, 6.7025E-20, 6.7408E-20, &
      6.4575E-20, 6.5260E-20, 6.2635E-20, 6.3557E-20, 6.1049E-20, 6.2173E-20, &
      5.9723E-20, 6.1007E-20, 5.8609E-20, 6.0036E-20, 5.7657E-20, 5.9198E-20, &
      5.6830E-20, 5.8483E-20, 5.6121E-20, 5.7869E-20, 5.5501E-20, 5.7343E-20, &
      5.4963E-20, 5.6901E-20, 5.4500E-20, 5.6514E-20, 5.4694E-20, 5.4566E-20, &
      5.3733E-20, 5.4078E-20, 5.3618E-20, 5.4281E-20, 5.4110E-20, 5.5005E-20, &
      5.4369E-20, 5.5413E-20, 5.6528E-20, 5.7711E-20, 5.8948E-20, 6.0236E-20, &
      6.1561E-20 /)
    REAL, PARAMETER :: a1_2_CH3I(dim55) = (/ &
      -7.5927E-24, -1.0403E-23, -1.3160E-23, -1.2817E-23, -1.4089E-23, -1.1746E-23, &
      -1.2046E-23, -9.2004E-24, -9.1932E-24, -6.6415E-24, -6.6593E-24, -4.6448E-24, &
      -4.7728E-24, -3.2514E-24, -3.4728E-24, -2.3210E-24, -2.6004E-24, -1.7076E-24, &
      -2.0118E-24, -1.2972E-24, -1.6084E-24, -1.0141E-24, -1.3227E-24, -8.1250E-25, &
      -1.1125E-24, -6.6558E-25, -9.5208E-25, -5.5326E-25, -8.2627E-25, -4.6662E-25, &
      -7.2515E-25, -3.9738E-25, -6.4173E-25, -3.4125E-25, -5.7183E-25, -2.9456E-25, &
      -5.1286E-25, -2.5506E-25, -4.6208E-25, -2.2224E-25, -3.0119E-25, -1.9879E-25, &
      -1.8216E-25, -1.1724E-25, -1.1167E-25, -6.7362E-26, -6.5647E-26, -3.4188E-26, &
      -5.4045E-26, -3.0400E-26, -1.0068E-26, 7.5291E-27, 2.2591E-26, 3.5555E-26, &
      4.6579E-26 /)
    REAL, PARAMETER :: b1_2_CH3I(dim55) = (/ &
      3.5379E-22, 3.6222E-22, 3.7738E-22, 3.7464E-22, 3.8800E-22, 3.5753E-22, &
      3.6219E-22, 3.1096E-22, 3.1081E-22, 2.5212E-22, 2.5258E-22, 1.9617E-22, &
      2.0008E-22, 1.4987E-22, 1.5773E-22, 1.1396E-22, 1.2528E-22, 8.6885E-23, &
      1.0073E-22, 6.6427E-23, 8.2145E-23, 5.0643E-23, 6.7770E-23, 3.8181E-23, &
      5.6330E-23, 2.8175E-23, 4.6941E-23, 1.9821E-23, 3.9068E-23, 1.2813E-23, &
      3.2332E-23, 6.7665E-24, 2.6437E-23, 1.4967E-24, 2.1212E-23, -3.1886E-24, &
      1.6568E-23, -7.4076E-24, 1.2363E-23, -1.1141E-23, -3.2066E-24, -1.4778E-23, &
      -1.6866E-23, -2.5824E-23, -2.6663E-23, -3.3885E-23, -3.4186E-23, -4.0100E-23, &
      -3.6119E-23, -4.1155E-23, -4.5740E-23, -4.9928E-23, -5.3701E-23, -5.7110E-23, &
      -6.0148E-23 /)
    REAL, PARAMETER :: a2_CH3I(dim55) = (/ &
      -3.1184E-20, -2.7860E-20, -2.3320E-20, -1.8548E-20, -1.4228E-20, -1.0680E-20, &
      -7.9440E-21, -5.9120E-21, -4.4320E-21, -3.3680E-21, -2.5960E-21, -2.0440E-21, &
      -1.6320E-21, -1.3320E-21, -1.1040E-21, -9.2800E-22, -7.9200E-22, -6.8400E-22, &
      -5.9600E-22, -5.2800E-22, -4.6800E-22, -4.2000E-22, -3.8000E-22, -3.4400E-22, &
      -3.1200E-22, -2.8400E-22, -2.6000E-22, -2.4400E-22, -2.2000E-22, -2.0400E-22, &
      -1.9200E-22, -1.7600E-22, -1.6400E-22, -1.5200E-22, -1.4000E-22, -1.3200E-22, &
      -1.2400E-22, -1.1600E-22, -1.0400E-22, -9.9998E-23, -8.2400E-23, -5.8400E-23, &
      -4.2400E-23, -3.0400E-23, -2.1600E-23, -1.6000E-23, -1.1200E-23, -8.7997E-24, &
      -5.6000E-24, -4.0005E-24, -3.1996E-24, -2.4004E-24, -1.5996E-24, -8.0030E-25, &
      -7.9978E-25 /)
    REAL, PARAMETER :: b2_CH3I(dim55) = (/ &
       5.2986E-19,  5.1989E-19,  4.9492E-19,  4.5674E-19,  4.1138E-19,  3.6526E-19, &
       3.2285E-19,  2.8628E-19,  2.5594E-19,  2.3146E-19,  2.1178E-19,  1.9632E-19, &
       1.8376E-19,  1.7386E-19,  1.6576E-19,  1.5907E-19,  1.5357E-19,  1.4892E-19, &
       1.4492E-19,  1.4165E-19,  1.3862E-19,  1.3608E-19,  1.3386E-19,  1.3177E-19, &
       1.2984E-19,  1.2807E-19,  1.2650E-19,  1.2541E-19,  1.2372E-19,  1.2255E-19, &
       1.2165E-19,  1.2040E-19,  1.1943E-19,  1.1844E-19,  1.1741E-19,  1.1671E-19, &
       1.1598E-19,  1.1524E-19,  1.1409E-19,  1.1370E-19,  1.1193E-19,  1.0922E-19, &
       1.0721E-19,  1.0556E-19,  1.0423E-19,  1.0332E-19,  1.0248E-19,  1.0202E-19, &
       1.0138E-19,  1.0104E-19,  1.0086E-19,  1.0067E-19,  1.0047E-19,  1.0026E-19, &
       1.0026E-19 /)
    REAL, PARAMETER :: a3_CH3I(dim55) = (/ &
      -1.5425E-22, -1.2877E-22, -1.0181E-22, -7.7925E-23, -5.8826E-23, -4.4529E-23, &
      -3.4119E-23, -2.6637E-23, -2.1326E-23, -1.7372E-23, -1.4463E-23, -1.2260E-23, &
      -1.0503E-23, -9.1454E-24, -7.9904E-24, -7.1086E-24, -6.3099E-24, -5.6709E-24, &
      -5.1139E-24, -4.6725E-24, -4.2332E-24, -3.8738E-24, -3.5557E-24, -3.3147E-24, &
      -3.0352E-24, -2.8354E-24, -2.6368E-24, -2.4761E-24, -2.3163E-24, -2.1566E-24, &
      -2.0376E-24, -1.9569E-24, -1.7971E-24, -1.7173E-24, -1.6380E-24, -1.5176E-24, &
      -1.4776E-24, -1.3978E-24, -1.3184E-24, -1.2780E-24, -1.1102E-24, -9.0256E-25, &
      -7.5080E-25, -6.3099E-25, -5.4357E-25, -4.6326E-25, -4.0735E-25, -3.4345E-25, &
      -3.1150E-25, -2.6358E-25, -2.3961E-25, -2.0766E-25, -1.7586E-25, -1.6773E-25, &
      -1.3578E-25 /)
    REAL, PARAMETER :: b3_CH3I(dim55) = (/ &
      3.1662E-20, 3.1012E-20, 2.9648E-20, 2.7842E-20, 2.5920E-20, 2.4123E-20, &
      2.2554E-20, 2.1239E-20, 2.0172E-20, 1.9279E-20, 1.8549E-20, 1.7942E-20, &
      1.7413E-20, 1.6970E-20, 1.6565E-20, 1.6233E-20, 1.5913E-20, 1.5641E-20, &
      1.5389E-20, 1.5179E-20, 1.4959E-20, 1.4770E-20, 1.4594E-20, 1.4455E-20, &
      1.4287E-20, 1.4162E-20, 1.4033E-20, 1.3924E-20, 1.3812E-20, 1.3696E-20, &
      1.3606E-20, 1.3544E-20, 1.3416E-20, 1.3350E-20, 1.3282E-20, 1.3177E-20, &
      1.3141E-20, 1.3067E-20, 1.2991E-20, 1.2952E-20, 1.2783E-20, 1.2549E-20, &
      1.2359E-20, 1.2194E-20, 1.2063E-20, 1.1932E-20, 1.1834E-20, 1.1714E-20, &
      1.1650E-20, 1.1548E-20, 1.1494E-20, 1.1418E-20, 1.1338E-20, 1.1317E-20, &
      1.1229E-20 /)
    REAL, PARAMETER :: a4_CH3I(3) = (/ 6.4225E-21, -1.1673E-24, 2.1221E-28 /)
    REAL, PARAMETER :: a5_CH3I(3) = (/ 1.3487E-21, -3.0865E-25, 4.4431E-29 /)
    REAL, PARAMETER :: a6_CH3I(1) = (/ 1.9074E-23 /)

    jval_gp(ip_CH3I)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH3I(0) = &
          p1(a0_1_1_CH3I(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CH3I(i0(j,k)), &
          a0_2_1_CH3I(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CH3I(i0(j,k)),v3_du1(j,k))
        sig_CH3I(1) = &
          (p1(b1_1_CH3I(i1(j,k)),a1_1_CH3I(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CH3I(i1(j,k)),a1_2_CH3I(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CH3I(2) = &
          p1(b2_CH3I(i2(j,k)), a2_CH3I(i2(j,k)), &
          v3_du1(j,k))
        sig_CH3I(3) = &
          p1(b3_CH3I(i3(j,k)), a3_CH3I(i3(j,k)), &
          v3_du2(j,k))
        sig_CH3I(4) = &
          p2(a4_CH3I(1),a4_CH3I(2),a4_CH3I(3),v3_du2(j,k))
        sig_CH3I(5) = &
          p2(a5_CH3I(1),a5_CH3I(2),a5_CH3I(3),v3_du2(j,k))
        sig_CH3I(6) = &
          a6_CH3I(1)
        dj = 0. &
          + sig_CH3I(0) * fint(j,k,0) &
          + sig_CH3I(1) * fint(j,k,1) &
          + sig_CH3I(2) * fint(j,k,2) &
          + sig_CH3I(3) * fint(j,k,3) &
          + sig_CH3I(4) * fint(j,k,4) &
          + sig_CH3I(5) * fint(j,k,5) &
          + sig_CH3I(6) * fint(j,k,6)

        jval_gp(ip_CH3I)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,2))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CH3I

  ! **************************************************************************

  SUBROUTINE jval_cal_C3H7I(jrow)

    ! C3H7I -> products Roehl et al., JGR. 102, 12819-12829 (1997)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_C3H7I

    ! T-const parameters:
    REAL, PARAMETER :: a1_1_C3H7I(dim55) = (/ &
      -5.2179E-21, -4.4134E-21, -3.4985E-21, -2.7903E-21, -2.0032E-21, -1.5282E-21, &
      -9.5752E-22, -6.9971E-22, -3.2049E-22, -2.0686E-22, 3.9922E-23, 7.2766E-23, &
      2.3662E-22, 2.2883E-22, 3.4291E-22, 3.1597E-22, 4.0015E-22, 3.6480E-22, &
      4.3039E-22, 3.9192E-22, 4.4549E-22, 4.0634E-22, 4.5169E-22, 4.1330E-22, &
      4.5273E-22, 4.1522E-22, 4.5027E-22, 4.1422E-22, 4.4591E-22, 4.1126E-22, &
      4.4005E-22, 4.0705E-22, 4.3331E-22, 4.0187E-22, 4.2604E-22, 3.9606E-22, &
      4.1852E-22, 3.8998E-22, 4.1076E-22, 3.8334E-22, 3.8631E-22, 3.6402E-22, &
      3.4904E-22, 3.2869E-22, 3.1319E-22, 2.9444E-22, 2.7888E-22, 2.6253E-22, &
      2.4466E-22, 2.2609E-22, 2.0815E-22, 1.9124E-22, 1.7475E-22, 1.5931E-22, &
      1.4464E-22 /)
    REAL, PARAMETER :: b1_1_C3H7I(dim55) = (/ &
      1.2187E-19, 1.1946E-19, 1.1442E-19, 1.0876E-19, 1.0049E-19, 9.4319E-20, &
      8.5473E-20, 8.0833E-20, 7.3059E-20, 7.0445E-20, 6.4152E-20, 6.3233E-20, &
      5.8235E-20, 5.8492E-20, 5.4442E-20, 5.5466E-20, 5.2057E-20, 5.3577E-20, &
      5.0592E-20, 5.2439E-20, 4.9734E-20, 5.1809E-20, 4.9291E-20, 5.1518E-20, &
      4.9133E-20, 5.1496E-20, 4.9200E-20, 5.1652E-20, 4.9417E-20, 5.1947E-20, &
      4.9773E-20, 5.2347E-20, 5.0233E-20, 5.2843E-20, 5.0776E-20, 5.3414E-20, &
      5.1382E-20, 5.4036E-20, 5.2051E-20, 5.4739E-20, 5.4440E-20, 5.6960E-20, &
      5.8839E-20, 6.1648E-20, 6.3981E-20, 6.7036E-20, 6.9768E-20, 7.2840E-20, &
      7.6424E-20, 8.0380E-20, 8.4425E-20, 8.8450E-20, 9.2579E-20, 9.6642E-20, &
      1.0068E-19 /)
    REAL, PARAMETER :: a1_2_C3H7I(dim55) = (/ &
      -1.1057E-23, -1.3449E-23, -1.7040E-23, -1.5821E-23, -1.7573E-23, -1.4171E-23, &
      -1.4820E-23, -1.0923E-23, -1.1186E-23, -7.7550E-24, -8.0064E-24, -5.3009E-24, &
      -5.6409E-24, -3.5888E-24, -4.0007E-24, -2.4463E-24, -2.8953E-24, -1.6918E-24, &
      -2.1475E-24, -1.1896E-24, -1.6327E-24, -8.4845E-25, -1.2691E-24, -6.1194E-25, &
      -1.0052E-24, -4.4170E-25, -8.0648E-25, -3.1723E-25, -6.5532E-25, -2.2488E-25, &
      -5.3514E-25, -1.5416E-25, -4.3936E-25, -9.8478E-26, -3.6094E-25, -5.4890E-26, &
      -2.9601E-25, -2.0059E-26, -2.4198E-25, 8.9514E-27, -7.7313E-26, 1.7531E-26, &
      3.2619E-26, 8.4613E-26, 9.3630E-26, 1.2402E-25, 1.3248E-25, 1.4677E-25, &
      1.6775E-25, 1.9402E-25, 2.1550E-25, 2.3284E-25, 2.4720E-25, 2.5745E-25, &
      2.6491E-25 /)
    REAL, PARAMETER :: b1_2_C3H7I(dim55) = (/ &
      3.5654E-22, 3.6371E-22, 3.8346E-22, 3.7371E-22, 3.9211E-22, 3.4789E-22, &
      3.5795E-22, 2.8779E-22, 2.9318E-22, 2.1427E-22, 2.2068E-22, 1.4493E-22, &
      1.5530E-22, 8.7578E-23, 1.0220E-22, 4.3135E-23, 6.1320E-23, 9.5673E-24, &
      3.0301E-23, -1.5678E-23, 6.6975E-24, -3.4865E-23, -1.1521E-23, -4.9635E-23, &
      -2.5841E-23, -6.1343E-23, -3.7450E-23, -7.0719E-23, -4.6883E-23, -7.8305E-23, &
      -5.4881E-23, -8.4597E-23, -6.1639E-23, -8.9932E-23, -6.7491E-23, -9.4424E-23, &
      -7.2603E-23, -9.8266E-23, -7.7073E-23, -1.0166E-22, -9.2994E-23, -1.0371E-22, &
      -1.0561E-22, -1.1278E-22, -1.1414E-22, -1.1909E-22, -1.2058E-22, -1.2326E-22, &
      -1.2747E-22, -1.3306E-22, -1.3791E-22, -1.4203E-22, -1.4563E-22, -1.4833E-22, &
      -1.5038E-22 /)
    REAL, PARAMETER :: a2_C3H7I(dim55) = (/ &
      -3.5692E-20, -3.3076E-20, -2.8688E-20, -2.3628E-20, -1.8768E-20, -1.4592E-20, &
      -1.1240E-20, -8.6600E-21, -6.7160E-21, -5.2680E-21, -4.1920E-21, -3.3920E-21, &
      -2.7800E-21, -2.3200E-21, -1.9600E-21, -1.6800E-21, -1.4560E-21, -1.2760E-21, &
      -1.1280E-21, -1.0040E-21, -8.9999E-22, -8.1600E-22, -7.3599E-22, -6.7200E-22, &
      -6.1600E-22, -5.6400E-22, -5.2000E-22, -4.7600E-22, -4.4400E-22, -4.1200E-22, &
      -3.8001E-22, -3.5200E-22, -3.3200E-22, -3.0400E-22, -2.8400E-22, -2.6800E-22, &
      -2.4800E-22, -2.3200E-22, -2.1600E-22, -2.0400E-22, -1.6640E-22, -1.1920E-22, &
      -8.5599E-23, -6.2400E-23, -4.4800E-23, -3.1999E-23, -2.3200E-23, -1.6800E-23, &
      -1.2000E-23, -8.7991E-24, -6.4003E-24, -4.0015E-24, -3.9994E-24, -1.6006E-24, &
      -2.3988E-24 /)
    REAL, PARAMETER :: b2_C3H7I(dim55) = (/ &
       8.5650E-19,  8.4865E-19,  8.2451E-19,  7.8403E-19,  7.3300E-19,  6.7872E-19, &
       6.2676E-19,  5.8032E-19,  5.4047E-19,  5.0716E-19,  4.7973E-19,  4.5733E-19, &
       4.3866E-19,  4.2348E-19,  4.1070E-19,  4.0006E-19,  3.9099E-19,  3.8325E-19, &
       3.7651E-19,  3.7056E-19,  3.6531E-19,  3.6086E-19,  3.5642E-19,  3.5271E-19, &
       3.4932E-19,  3.4604E-19,  3.4316E-19,  3.4017E-19,  3.3791E-19,  3.3558E-19, &
       3.3316E-19,  3.3098E-19,  3.2937E-19,  3.2704E-19,  3.2533E-19,  3.2392E-19, &
       3.2211E-19,  3.2063E-19,  3.1910E-19,  3.1792E-19,  3.1414E-19,  3.0881E-19, &
       3.0459E-19,  3.0139E-19,  2.9874E-19,  2.9666E-19,  2.9511E-19,  2.9391E-19, &
       2.9295E-19,  2.9226E-19,  2.9172E-19,  2.9115E-19,  2.9115E-19,  2.9052E-19, &
       2.9074E-19 /)
    REAL, PARAMETER :: a3_C3H7I(dim55) = (/ &
      -4.6797E-22, -3.9310E-22, -3.1328E-22, -2.4192E-22, -1.8446E-22, -1.4109E-22, &
      -1.0939E-22, -8.6421E-23, -6.9768E-23, -5.7468E-23, -4.8262E-23, -4.1094E-23, &
      -3.5543E-23, -3.1030E-23, -2.7407E-23, -2.4321E-23, -2.1765E-23, -1.9649E-23, &
      -1.7779E-23, -1.6174E-23, -1.4816E-23, -1.3578E-23, -1.2545E-23, -1.1581E-23, &
      -1.0783E-23, -1.0024E-23, -9.3488E-24, -8.7460E-24, -8.1868E-24, -7.7077E-24, &
      -7.2712E-24, -6.8291E-24, -6.5096E-24, -6.1103E-24, -5.7930E-24, -5.5112E-24, &
      -5.2716E-24, -4.9919E-24, -4.7543E-24, -4.5128E-24, -3.9856E-24, -3.2428E-24, &
      -2.6917E-24, -2.2684E-24, -1.9344E-24, -1.6613E-24, -1.4377E-24, -1.2460E-24, &
      -1.0863E-24, -9.5049E-25, -8.3066E-25, -7.3483E-25, -6.3949E-25, -5.6708E-25, &
      -4.9521E-25 /)
    REAL, PARAMETER :: b3_C3H7I(dim55) = (/ &
      1.0390E-19, 1.0199E-19, 9.7955E-20, 9.2559E-20, 8.6776E-20, 8.1325E-20, &
      7.6546E-20, 7.2509E-20, 6.9166E-20, 6.6388E-20, 6.4078E-20, 6.2100E-20, &
      6.0430E-20, 5.8959E-20, 5.7687E-20, 5.6526E-20, 5.5501E-20, 5.4599E-20, &
      5.3755E-20, 5.2991E-20, 5.2311E-20, 5.1659E-20, 5.1089E-20, 5.0534E-20, &
      5.0054E-20, 4.9578E-20, 4.9139E-20, 4.8731E-20, 4.8338E-20, 4.7990E-20, &
      4.7662E-20, 4.7319E-20, 4.7063E-20, 4.6733E-20, 4.6462E-20, 4.6215E-20, &
      4.5999E-20, 4.5740E-20, 4.5514E-20, 4.5278E-20, 4.4750E-20, 4.3912E-20, &
      4.3222E-20, 4.2639E-20, 4.2137E-20, 4.1693E-20, 4.1300E-20, 4.0940E-20, &
      4.0620E-20, 4.0331E-20, 4.0061E-20, 3.9833E-20, 3.9594E-20, 3.9404E-20, &
      3.9206E-20 /)
    REAL, PARAMETER :: a4_C3H7I(3) = (/ 2.1779E-20, -4.3651E-24, 7.8616E-28 /)
    REAL, PARAMETER :: a5_C3H7I(3) = (/ 4.0003E-21, -9.8103E-25, 1.4348E-28 /)
    REAL, PARAMETER :: a6_C3H7I(1) = (/ 7.5650E-23 /)

    jval_gp(ip_C3H7I)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_C3H7I(1) = &
          (p1(b1_1_C3H7I(i1(j,k)),a1_1_C3H7I(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_C3H7I(i1(j,k)),a1_2_C3H7I(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_C3H7I(2) = &
          p1(b2_C3H7I(i2(j,k)), a2_C3H7I(i2(j,k)), &
          v3_du1(j,k))
        sig_C3H7I(3) = &
          p1(b3_C3H7I(i3(j,k)), a3_C3H7I(i3(j,k)), &
          v3_du2(j,k))
        sig_C3H7I(4) = &
          p2(a4_C3H7I(1),a4_C3H7I(2),a4_C3H7I(3),v3_du2(j,k))
        sig_C3H7I(5) = &
          p2(a5_C3H7I(1),a5_C3H7I(2),a5_C3H7I(3),v3_du2(j,k))
        sig_C3H7I(6) = &
          a6_C3H7I(1)
        dj = 0. &
          + sig_C3H7I(1) * fint(j,k,1) &
          + sig_C3H7I(2) * fint(j,k,2) &
          + sig_C3H7I(3) * fint(j,k,3) &
          + sig_C3H7I(4) * fint(j,k,4) &
          + sig_C3H7I(5) * fint(j,k,5) &
          + sig_C3H7I(6) * fint(j,k,6)

        jval_gp(ip_C3H7I)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,2))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_C3H7I

  ! **************************************************************************

  SUBROUTINE jval_cal_CH2ClI(jrow)

    ! CH2ClI -> products JPL 2003

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH2ClI

    ! T-const parameters:
    REAL, PARAMETER :: a1_1_CH2ClI(dim55) = (/ &
      -2.7209E-23, 6.7423E-22, 1.7270E-21, 2.1650E-21, 2.9683E-21, 3.1092E-21, &
      3.6459E-21, 3.5757E-21, 3.9073E-21, 3.7270E-21, 3.9280E-21, 3.7063E-21, &
      3.8281E-21, 3.6015E-21, 3.6736E-21, 3.4580E-21, 3.4988E-21, 3.3047E-21, &
      3.3206E-21, 3.1466E-21, 3.1493E-21, 2.9942E-21, 2.9830E-21, 2.8495E-21, &
      2.8279E-21, 2.7085E-21, 2.6823E-21, 2.5813E-21, 2.5431E-21, 2.4593E-21, &
      2.4146E-21, 2.3454E-21, 2.2947E-21, 2.2379E-21, 2.1815E-21, 2.1362E-21, &
      2.0757E-21, 2.0420E-21, 1.9759E-21, 1.9524E-21, 1.8077E-21, 1.6215E-21, &
      1.4376E-21, 1.2985E-21, 1.1430E-21, 1.0375E-21, 9.0050E-22, 8.1993E-22, &
      6.4036E-22, 5.4374E-22, 4.5552E-22, 3.7539E-22, 3.0242E-22, 2.3575E-22, &
      1.7554E-22 /)
    REAL, PARAMETER :: b1_1_CH2ClI(dim55) = (/ &
      1.9657E-19, 1.9447E-19, 1.8868E-19, 1.8518E-19, 1.7674E-19, 1.7491E-19, &
      1.6659E-19, 1.6785E-19, 1.6106E-19, 1.6520E-19, 1.6008E-19, 1.6628E-19, &
      1.6257E-19, 1.7005E-19, 1.6749E-19, 1.7568E-19, 1.7403E-19, 1.8237E-19, &
      1.8165E-19, 1.9000E-19, 1.8987E-19, 1.9809E-19, 1.9871E-19, 2.0645E-19, &
      2.0776E-19, 2.1528E-19, 2.1700E-19, 2.2386E-19, 2.2656E-19, 2.3267E-19, &
      2.3605E-19, 2.4145E-19, 2.4553E-19, 2.5024E-19, 2.5506E-19, 2.5905E-19, &
      2.6453E-19, 2.6767E-19, 2.7397E-19, 2.7628E-19, 2.9082E-19, 3.1186E-19, &
      3.3494E-19, 3.5413E-19, 3.7753E-19, 3.9474E-19, 4.1878E-19, 4.3393E-19, &
      4.6993E-19, 4.9051E-19, 5.1040E-19, 5.2948E-19, 5.4776E-19, 5.6529E-19, &
      5.8188E-19 /)
    REAL, PARAMETER :: a1_2_CH2ClI(dim55) = (/ &
      -2.7869E-23, -2.4283E-23, -3.0019E-23, -2.2819E-23, -2.6471E-23, -1.7994E-23, &
      -2.0466E-23, -1.2566E-23, -1.4524E-23, -7.9994E-24, -9.7571E-24, -4.6718E-24, &
      -6.2835E-24, -2.4007E-24, -3.8343E-24, -8.7153E-25, -2.1256E-24, 1.1206E-25, &
      -9.1515E-25, 7.9650E-25, -6.3573E-26, 1.2301E-24, 5.6451E-25, 1.5236E-24, &
      1.0131E-24, 1.7324E-24, 1.3401E-24, 1.8399E-24, 1.6019E-24, 1.9079E-24, &
      1.7767E-24, 1.9479E-24, 1.9080E-24, 1.9572E-24, 2.0123E-24, 1.9514E-24, &
      2.0801E-24, 1.9294E-24, 2.1310E-24, 1.9064E-24, 2.0498E-24, 1.9317E-24, &
      1.9713E-24, 1.7929E-24, 1.8521E-24, 1.6490E-24, 1.7295E-24, 1.5168E-24, &
      1.9344E-24, 1.8992E-24, 1.8547E-24, 1.8019E-24, 1.7425E-24, 1.6783E-24, &
      1.6088E-24 /)
    REAL, PARAMETER :: b1_2_CH2ClI(dim55) = (/ &
      4.7337E-24, -6.0236E-24, 2.5524E-23, -3.2074E-23, 6.2672E-24, -1.0393E-22, &
      -6.5617E-23, -2.0782E-22, -1.6768E-22, -3.1774E-22, -2.7292E-22, -4.1531E-22, &
      -3.6615E-22, -4.9429E-22, -4.4339E-22, -5.5598E-22, -5.0519E-22, -6.0141E-22, &
      -5.5467E-22, -6.3683E-22, -5.9340E-22, -6.6196E-22, -6.2502E-22, -6.8065E-22, &
      -6.4976E-22, -6.9508E-22, -6.6938E-22, -7.0337E-22, -6.8659E-22, -7.0893E-22, &
      -6.9902E-22, -7.1237E-22, -7.0917E-22, -7.1324E-22, -7.1795E-22, -7.1260E-22, &
      -7.2425E-22, -7.1023E-22, -7.2949E-22, -7.0747E-22, -7.2189E-22, -7.0854E-22, &
      -7.1351E-22, -6.8889E-22, -6.9780E-22, -6.6469E-22, -6.7883E-22, -6.3884E-22, &
      -7.2256E-22, -7.1506E-22, -7.0504E-22, -6.9245E-22, -6.7759E-22, -6.6071E-22, &
      -6.4154E-22 /)
    REAL, PARAMETER :: a2_CH2ClI(dim55) = (/ &
      -1.1052E-20, -1.2292E-20, -1.2372E-20, -1.1576E-20, -1.0292E-20, -8.8560E-21, &
      -7.4800E-21, -6.2640E-21, -5.2400E-21, -4.4000E-21, -3.7240E-21, -3.1760E-21, &
      -2.7360E-21, -2.3720E-21, -2.0800E-21, -1.8400E-21, -1.6360E-21, -1.4680E-21, &
      -1.3200E-21, -1.2000E-21, -1.0920E-21, -9.9599E-22, -9.1602E-22, -8.4399E-22, &
      -7.7600E-22, -7.2000E-22, -6.6400E-22, -6.1999E-22, -5.7601E-22, -5.3200E-22, &
      -4.9999E-22, -4.6401E-22, -4.3200E-22, -4.0402E-22, -3.7599E-22, -3.5600E-22, &
      -3.2800E-22, -3.0800E-22, -2.8800E-22, -2.7200E-22, -2.2320E-22, -1.6000E-22, &
      -1.1600E-22, -8.4000E-23, -6.0802E-23, -4.3200E-23, -3.1197E-23, -2.3202E-23, &
      -1.5998E-23, -1.2002E-23, -8.8012E-24, -5.6000E-24, -4.7976E-24, -3.2012E-24, &
      -2.3988E-24 /)
    REAL, PARAMETER :: b2_CH2ClI(dim55) = (/ &
       1.0296E-18,  1.0333E-18,  1.0338E-18,  1.0274E-18,  1.0139E-18,  9.9527E-19, &
       9.7394E-19,  9.5205E-19,  9.3106E-19,  9.1174E-19,  8.9450E-19,  8.7916E-19, &
       8.6574E-19,  8.5373E-19,  8.4336E-19,  8.3424E-19,  8.2598E-19,  8.1875E-19, &
       8.1202E-19,  8.0626E-19,  8.0081E-19,  7.9572E-19,  7.9128E-19,  7.8710E-19, &
       7.8299E-19,  7.7946E-19,  7.7579E-19,  7.7280E-19,  7.6970E-19,  7.6649E-19, &
       7.6407E-19,  7.6126E-19,  7.5869E-19,  7.5636E-19,  7.5397E-19,  7.5221E-19, &
       7.4967E-19,  7.4781E-19,  7.4590E-19,  7.4434E-19,  7.3943E-19,  7.3229E-19, &
       7.2677E-19,  7.2235E-19,  7.1886E-19,  7.1599E-19,  7.1389E-19,  7.1238E-19, &
       7.1094E-19,  7.1009E-19,  7.0936E-19,  7.0860E-19,  7.0840E-19,  7.0798E-19, &
       7.0776E-19 /)
    REAL, PARAMETER :: a3_CH2ClI(dim55) = (/ &
      -1.1143E-21, -9.4860E-22, -7.6763E-22, -6.0231E-22, -4.6805E-22, -3.6462E-22, &
      -2.8845E-22, -2.3163E-22, -1.9010E-22, -1.5895E-22, -1.3504E-22, -1.1661E-22, &
      -1.0144E-22, -8.9057E-23, -7.9505E-23, -7.0687E-23, -6.3898E-23, -5.7508E-23, &
      -5.2737E-23, -4.7924E-23, -4.3930E-23, -4.0735E-23, -3.7555E-23, -3.5143E-23, &
      -3.2348E-23, -3.0351E-23, -2.8366E-23, -2.6358E-23, -2.5160E-23, -2.3562E-23, &
      -2.1974E-23, -2.1166E-23, -1.9968E-23, -1.8770E-23, -1.7978E-23, -1.6773E-23, &
      -1.6374E-23, -1.5575E-23, -1.4382E-23, -1.4377E-23, -1.2380E-23, -1.0144E-23, &
      -8.4665E-24, -7.1885E-24, -6.1551E-24, -5.2716E-24, -4.6326E-24, -3.9935E-24, &
      -3.4345E-24, -3.0351E-24, -2.7156E-24, -2.3962E-24, -2.0783E-24, -1.8371E-24, &
      -1.5974E-24 /)
    REAL, PARAMETER :: b3_CH2ClI(dim55) = (/ &
      3.4405E-19, 3.3982E-19, 3.3066E-19, 3.1816E-19, 3.0465E-19, 2.9165E-19, &
      2.8017E-19, 2.7018E-19, 2.6184E-19, 2.5481E-19, 2.4881E-19, 2.4372E-19, &
      2.3916E-19, 2.3512E-19, 2.3177E-19, 2.2845E-19, 2.2573E-19, 2.2301E-19, &
      2.2085E-19, 2.1856E-19, 2.1656E-19, 2.1488E-19, 2.1313E-19, 2.1174E-19, &
      2.1005E-19, 2.0880E-19, 2.0751E-19, 2.0615E-19, 2.0531E-19, 2.0415E-19, &
      2.0296E-19, 2.0233E-19, 2.0137E-19, 2.0038E-19, 1.9970E-19, 1.9865E-19, &
      1.9829E-19, 1.9755E-19, 1.9641E-19, 1.9641E-19, 1.9440E-19, 1.9188E-19, &
      1.8978E-19, 1.8802E-19, 1.8647E-19, 1.8503E-19, 1.8391E-19, 1.8271E-19, &
      1.8159E-19, 1.8074E-19, 1.8002E-19, 1.7926E-19, 1.7846E-19, 1.7783E-19, &
      1.7717E-19 /)
    REAL, PARAMETER :: a4_CH2ClI(3) = (/ 1.1572E-19, -1.6561E-23, 2.9737E-27 /)
    REAL, PARAMETER :: a5_CH2ClI(3) = (/ 3.3683E-20, -5.8233E-24, 8.1331E-28 /)
    REAL, PARAMETER :: a6_CH2ClI(1) = (/ 1.0152E-21 /)

    jval_gp(ip_CH2ClI)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH2ClI(1) = &
          (p1(b1_1_CH2ClI(i1(j,k)),a1_1_CH2ClI(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CH2ClI(i1(j,k)),a1_2_CH2ClI(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CH2ClI(2) = &
          p1(b2_CH2ClI(i2(j,k)), a2_CH2ClI(i2(j,k)), &
          v3_du1(j,k))
        sig_CH2ClI(3) = &
          p1(b3_CH2ClI(i3(j,k)), a3_CH2ClI(i3(j,k)), &
          v3_du2(j,k))
        sig_CH2ClI(4) = &
          p2(a4_CH2ClI(1),a4_CH2ClI(2),a4_CH2ClI(3),v3_du2(j,k))
        sig_CH2ClI(5) = &
          p2(a5_CH2ClI(1),a5_CH2ClI(2),a5_CH2ClI(3),v3_du2(j,k))
        sig_CH2ClI(6) = &
          a6_CH2ClI(1)
        dj = 0. &
          + sig_CH2ClI(1) * fint(j,k,1) &
          + sig_CH2ClI(2) * fint(j,k,2) &
          + sig_CH2ClI(3) * fint(j,k,3) &
          + sig_CH2ClI(4) * fint(j,k,4) &
          + sig_CH2ClI(5) * fint(j,k,5) &
          + sig_CH2ClI(6) * fint(j,k,6)

        jval_gp(ip_CH2ClI)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,2))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CH2ClI

  ! **************************************************************************

  SUBROUTINE jval_cal_CH2I2(jrow)

    ! CH2I2 -> products JPL 2003

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH2I2

    ! T-const parameters:
    REAL, PARAMETER :: a1_1_CH2I2(dim55) = (/ &
      5.9448E-20, 5.6575E-20, 5.3445E-20, 4.8554E-20, 4.3528E-20, 3.8660E-20, &
      3.3419E-20, 2.9609E-20, 2.4977E-20, 2.2372E-20, 1.8491E-20, 1.6908E-20, &
      1.3682E-20, 1.2774E-20, 1.0129E-20, 9.6692E-21, 7.3974E-21, 7.3092E-21, &
      5.3088E-21, 5.4677E-21, 3.6747E-21, 3.9943E-21, 2.3935E-21, 2.8000E-21, &
      1.3587E-21, 1.8318E-21, 5.0408E-22, 1.0379E-21, -1.7454E-22, 3.8497E-22, &
      -7.6547E-22, -1.6527E-22, -1.2421E-21, -6.2998E-22, -1.6432E-21, -1.0130E-21, &
      -1.9882E-21, -1.3538E-21, -2.2660E-21, -1.6400E-21, -2.4138E-21, -2.6953E-21, &
      -3.1082E-21, -3.1845E-21, -3.4303E-21, -3.4163E-21, -3.5669E-21, -3.5088E-21, &
      -3.7389E-21, -3.6854E-21, -3.6250E-21, -3.5582E-21, -3.4921E-21, -3.4177E-21, &
      -3.3459E-21 /)
    REAL, PARAMETER :: b1_1_CH2I2(dim55) = (/ &
      2.1064E-18, 2.1150E-18, 2.1323E-18, 2.1714E-18, 2.2242E-18, 2.2874E-18, &
      2.3687E-18, 2.4373E-18, 2.5322E-18, 2.5921E-18, 2.6911E-18, 2.7354E-18, &
      2.8338E-18, 2.8638E-18, 2.9577E-18, 2.9751E-18, 3.0672E-18, 3.0709E-18, &
      3.1620E-18, 3.1543E-18, 3.2449E-18, 3.2279E-18, 3.3168E-18, 3.2932E-18, &
      3.3804E-18, 3.3506E-18, 3.4376E-18, 3.4013E-18, 3.4867E-18, 3.4459E-18, &
      3.5328E-18, 3.4859E-18, 3.5726E-18, 3.5218E-18, 3.6085E-18, 3.5530E-18, &
      3.6413E-18, 3.5823E-18, 3.6694E-18, 3.6080E-18, 3.6858E-18, 3.7176E-18, &
      3.7694E-18, 3.7799E-18, 3.8169E-18, 3.8147E-18, 3.8411E-18, 3.8302E-18, &
      3.8763E-18, 3.8649E-18, 3.8513E-18, 3.8354E-18, 3.8188E-18, 3.7993E-18, &
      3.7795E-18 /)
    REAL, PARAMETER :: a1_2_CH2I2(dim55) = (/ &
      -9.2144E-23, -2.7512E-23, 1.4933E-24, 4.4006E-23, 7.0280E-23, 8.4114E-23, &
      1.0369E-22, 9.6238E-23, 1.1055E-22, 9.2009E-23, 1.0390E-22, 8.1078E-23, &
      9.2474E-23, 6.9429E-23, 8.0187E-23, 5.8716E-23, 6.9478E-23, 4.9389E-23, &
      6.0322E-23, 4.1755E-23, 5.2584E-23, 3.5567E-23, 4.5929E-23, 3.0580E-23, &
      4.0406E-23, 2.6385E-23, 3.5756E-23, 2.2958E-23, 3.1676E-23, 1.9921E-23, &
      2.8460E-23, 1.7452E-23, 2.5440E-23, 1.5328E-23, 2.2912E-23, 1.3465E-23, &
      2.0717E-23, 1.1942E-23, 1.8702E-23, 1.0613E-23, 1.2890E-23, 9.0190E-24, &
      8.1035E-24, 5.6658E-24, 5.3134E-24, 3.6865E-24, 3.5590E-24, 2.4139E-24, &
      3.1823E-24, 2.4444E-24, 1.8145E-24, 1.2757E-24, 8.2430E-25, 4.1943E-25, &
      8.6644E-26 /)
    REAL, PARAMETER :: b1_2_CH2I2(dim55) = (/ &
      -3.9406E-21, -4.1345E-21, -4.2941E-21, -4.6342E-21, -4.9100E-21, -5.0899E-21, &
      -5.3933E-21, -5.2592E-21, -5.5527E-21, -5.1261E-21, -5.4293E-21, -4.7903E-21, &
      -5.1379E-21, -4.3774E-21, -4.7593E-21, -3.9434E-21, -4.3793E-21, -3.5155E-21, &
      -4.0129E-21, -3.1217E-21, -3.6685E-21, -2.7667E-21, -3.3417E-21, -2.4515E-21, &
      -3.0460E-21, -2.1626E-21, -2.7764E-21, -1.9062E-21, -2.5208E-21, -1.6627E-21, &
      -2.3074E-21, -1.4488E-21, -2.0918E-21, -1.2525E-21, -1.9010E-21, -1.0696E-21, &
      -1.7259E-21, -9.0982E-22, -1.5554E-21, -7.6271E-22, -9.9151E-22, -5.5410E-22, &
      -4.3921E-22, -1.0280E-22, -4.9768E-23, 2.1541E-22, 2.3779E-22, 4.5308E-22, &
      2.9900E-22, 4.5619E-22, 5.9821E-22, 7.2646E-22, 8.3953E-22, 9.4601E-22, &
      1.0377E-21 /)
    REAL, PARAMETER :: a2_CH2I2(dim55) = (/ &
      9.3160E-20, 8.5120E-20, 7.2640E-20, 5.8760E-20, 4.5720E-20, 3.4720E-20, &
      2.6080E-20, 1.9520E-20, 1.4720E-20, 1.1120E-20, 8.6000E-21, 6.6800E-21, &
      5.2801E-21, 4.2800E-21, 3.4799E-21, 2.8400E-21, 2.4400E-21, 2.0400E-21, &
      1.7599E-21, 1.5200E-21, 1.3601E-21, 1.1600E-21, 1.0399E-21, 9.6003E-22, &
      8.3992E-22, 7.6001E-22, 6.8011E-22, 6.3991E-22, 5.6000E-22, 5.1997E-22, &
      4.8010E-22, 4.4006E-22, 3.9986E-22, 4.0002E-22, 3.5999E-22, 3.2012E-22, &
      2.7992E-22, 2.8008E-22, 2.7992E-22, 2.4005E-22, 1.9201E-22, 1.4400E-22, &
      9.5986E-23, 7.1998E-23, 5.6017E-23, 3.1995E-23, 2.3988E-23, 2.4021E-23, &
      1.5981E-23, 8.0071E-24, 8.0071E-24, -0.0000E+00, 8.0071E-24, -0.0000E+00, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b2_CH2I2(dim55) = (/ &
       2.5036E-18,  2.5277E-18,  2.5964E-18,  2.7074E-18,  2.8443E-18,  2.9873E-18, &
       3.1213E-18,  3.2393E-18,  3.3377E-18,  3.4205E-18,  3.4848E-18,  3.5386E-18, &
       3.5813E-18,  3.6143E-18,  3.6427E-18,  3.6670E-18,  3.6832E-18,  3.7004E-18, &
       3.7131E-18,  3.7246E-18,  3.7327E-18,  3.7433E-18,  3.7500E-18,  3.7546E-18, &
       3.7619E-18,  3.7669E-18,  3.7722E-18,  3.7749E-18,  3.7805E-18,  3.7834E-18, &
       3.7865E-18,  3.7896E-18,  3.7928E-18,  3.7928E-18,  3.7962E-18,  3.7997E-18, &
       3.8034E-18,  3.8034E-18,  3.8034E-18,  3.8073E-18,  3.8121E-18,  3.8175E-18, &
       3.8236E-18,  3.8269E-18,  3.8293E-18,  3.8332E-18,  3.8346E-18,  3.8346E-18, &
       3.8362E-18,  3.8379E-18,  3.8379E-18,  3.8398E-18,  3.8378E-18,  3.8399E-18, &
       3.8399E-18 /)
    REAL, PARAMETER :: a3_CH2I2(dim55) = (/ &
      -1.2181E-21, -1.0744E-21, -9.0663E-22, -7.4690E-22, -6.0702E-22, -4.9520E-22, &
      -4.1151E-22, -3.4744E-22, -2.9554E-22, -2.5958E-22, -2.2373E-22, -1.9968E-22, &
      -1.7971E-22, -1.6374E-22, -1.4382E-22, -1.3579E-22, -1.2380E-22, -1.1182E-22, &
      -1.0388E-22, -9.9838E-23, -8.7863E-23, -8.7855E-23, -7.9909E-23, -7.1883E-23, &
      -7.1883E-23, -6.7894E-23, -5.9932E-23, -5.9900E-23, -5.9908E-23, -5.1914E-23, &
      -5.1934E-23, -4.7925E-23, -4.7925E-23, -4.3927E-23, -4.3953E-23, -3.9930E-23, &
      -3.9938E-23, -3.5941E-23, -3.5956E-23, -3.5950E-23, -3.1150E-23, -2.6358E-23, &
      -2.2364E-23, -1.9968E-23, -1.6787E-23, -1.4377E-23, -1.2779E-23, -1.1182E-23, &
      -1.0384E-23, -8.7855E-24, -7.1883E-24, -7.1883E-24, -6.3956E-24, -4.7916E-24, &
      -4.7933E-24 /)
    REAL, PARAMETER :: b3_CH2I2(dim55) = (/ &
      3.6456E-18, 3.6419E-18, 3.6335E-18, 3.6214E-18, 3.6073E-18, 3.5932E-18, &
      3.5806E-18, 3.5694E-18, 3.5589E-18, 3.5508E-18, 3.5418E-18, 3.5352E-18, &
      3.5292E-18, 3.5240E-18, 3.5170E-18, 3.5140E-18, 3.5092E-18, 3.5041E-18, &
      3.5005E-18, 3.4985E-18, 3.4925E-18, 3.4925E-18, 3.4882E-18, 3.4835E-18, &
      3.4835E-18, 3.4810E-18, 3.4758E-18, 3.4758E-18, 3.4758E-18, 3.4700E-18, &
      3.4700E-18, 3.4669E-18, 3.4669E-18, 3.4636E-18, 3.4636E-18, 3.4601E-18, &
      3.4601E-18, 3.4564E-18, 3.4564E-18, 3.4564E-18, 3.4516E-18, 3.4462E-18, &
      3.4412E-18, 3.4379E-18, 3.4331E-18, 3.4292E-18, 3.4264E-18, 3.4234E-18, &
      3.4218E-18, 3.4184E-18, 3.4148E-18, 3.4148E-18, 3.4128E-18, 3.4086E-18, &
      3.4086E-18 /)
    REAL, PARAMETER :: a4_CH2I2(2) = (/ 3.1275E-18, -4.9804E-23 /)
    REAL, PARAMETER :: a5_CH2I2(2) = (/ 1.8840E-18, -1.0077E-22 /)
    REAL, PARAMETER :: a6_CH2I2(1) = (/ 8.5983E-20 /)

    jval_gp(ip_CH2I2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH2I2(1) = &
          (p1(b1_1_CH2I2(i1(j,k)),a1_1_CH2I2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CH2I2(i1(j,k)),a1_2_CH2I2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CH2I2(2) = &
          p1(b2_CH2I2(i2(j,k)), a2_CH2I2(i2(j,k)), &
          v3_du1(j,k))
        sig_CH2I2(3) = &
          p1(b3_CH2I2(i3(j,k)), a3_CH2I2(i3(j,k)), &
          v3_du2(j,k))
        sig_CH2I2(4) = &
          p1(a4_CH2I2(1),a4_CH2I2(2),v3_du2(j,k))
        sig_CH2I2(5) = &
          p1(a5_CH2I2(1),a5_CH2I2(2),v3_du2(j,k))
        sig_CH2I2(6) = &
          a6_CH2I2(1)
        dj = 0. &
          + sig_CH2I2(1) * fint(j,k,1) &
          + sig_CH2I2(2) * fint(j,k,2) &
          + sig_CH2I2(3) * fint(j,k,3) &
          + sig_CH2I2(4) * fint(j,k,4) &
          + sig_CH2I2(5) * fint(j,k,5) &
          + sig_CH2I2(6) * fint(j,k,6)

        jval_gp(ip_CH2I2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CH2I2

  ! **************************************************************************

  SUBROUTINE jval_cal_IO(jrow)

    ! IO -> I + O ref = ???

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_IO

    ! T-const parameters:
    REAL, PARAMETER :: a6_IO(1) = (/ 6.4896E-18 /)
    REAL, PARAMETER :: a7_IO(2) = (/ 2.0085E-18, 1.2586E-22 /)

    jval_gp(ip_IO)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_IO(6) = &
          a6_IO(1)
        sig_IO(7) = &
          p1(a7_IO(1),a7_IO(2),v3_du2(j,k))
        dj = 0. &
          + sig_IO(6) * fint(j,k,6) &
          + sig_IO(7) * fint(j,k,7)

        jval_gp(ip_IO)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_IO

  ! **************************************************************************

  SUBROUTINE jval_cal_HOI(jrow)

    ! HOI -> products Jenkin, PhD thesis (1991)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_HOI

    ! T-const parameters:
    REAL, PARAMETER :: a3_HOI(dim55) = (/ &
      4.4716E-23, 4.3803E-23, 4.1026E-23, 3.7433E-23, 3.3742E-23, 3.0355E-23, &
      2.7367E-23, 2.4800E-23, 2.2604E-23, 2.0687E-23, 1.9017E-23, 1.7532E-23, &
      1.6214E-23, 1.5056E-23, 1.4023E-23, 1.3059E-23, 1.2220E-23, 1.1382E-23, &
      1.0707E-23, 1.0064E-23, 9.4249E-24, 8.9057E-24, 8.3900E-24, 7.9073E-24, &
      7.4680E-24, 7.0687E-24, 6.7119E-24, 6.3898E-24, 6.0303E-24, 5.7508E-24, &
      5.4335E-24, 5.2316E-24, 4.9521E-24, 4.7125E-24, 4.5145E-24, 4.3131E-24, &
      4.1534E-24, 3.9537E-24, 3.7954E-24, 3.6342E-24, 3.2268E-24, 2.6677E-24, &
      2.2444E-24, 1.9089E-24, 1.6387E-24, 1.4217E-24, 1.2221E-24, 1.0783E-24, &
      9.3450E-25, 8.2269E-25, 7.2683E-25, 6.3898E-25, 5.5955E-25, 4.9521E-25, &
      4.3929E-25 /)
    REAL, PARAMETER :: b3_HOI(dim55) = (/ &
      4.4059E-21, 4.4293E-21, 4.5697E-21, 4.8414E-21, 5.2129E-21, 5.6385E-21, &
      6.0890E-21, 6.5401E-21, 6.9811E-21, 7.4141E-21, 7.8330E-21, 8.2428E-21, &
      8.6394E-21, 9.0169E-21, 9.3794E-21, 9.7420E-21, 1.0078E-20, 1.0436E-20, &
      1.0740E-20, 1.1046E-20, 1.1367E-20, 1.1640E-20, 1.1924E-20, 1.2203E-20, &
      1.2467E-20, 1.2717E-20, 1.2949E-20, 1.3167E-20, 1.3419E-20, 1.3623E-20, &
      1.3861E-20, 1.4018E-20, 1.4242E-20, 1.4440E-20, 1.4609E-20, 1.4785E-20, &
      1.4929E-20, 1.5114E-20, 1.5265E-20, 1.5423E-20, 1.5831E-20, 1.6461E-20, &
      1.6991E-20, 1.7453E-20, 1.7859E-20, 1.8213E-20, 1.8563E-20, 1.8833E-20, &
      1.9121E-20, 1.9359E-20, 1.9575E-20, 1.9784E-20, 1.9983E-20, 2.0152E-20, &
      2.0306E-20 /)
    REAL, PARAMETER :: a4_HOI(3) = (/ 4.6729E-20, 9.6658E-24, -1.4608E-27 /)
    REAL, PARAMETER :: a5_HOI(3) = (/ 1.5734E-19, 1.3935E-23, -1.8080E-27 /)
    REAL, PARAMETER :: a6_HOI(1) = (/ 1.6615E-19 /)
    REAL, PARAMETER :: a7_HOI(2) = (/ 1.2457E-20, 7.8754E-25 /)

    jval_gp(ip_HOI)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_HOI(3) = &
          p1(b3_HOI(i3(j,k)), a3_HOI(i3(j,k)), &
          v3_du2(j,k))
        sig_HOI(4) = &
          p2(a4_HOI(1),a4_HOI(2),a4_HOI(3),v3_du2(j,k))
        sig_HOI(5) = &
          p2(a5_HOI(1),a5_HOI(2),a5_HOI(3),v3_du2(j,k))
        sig_HOI(6) = &
          a6_HOI(1)
        sig_HOI(7) = &
          p1(a7_HOI(1),a7_HOI(2),v3_du2(j,k))
        dj = 0. &
          + sig_HOI(3) * fint(j,k,3) &
          + sig_HOI(4) * fint(j,k,4) &
          + sig_HOI(5) * fint(j,k,5) &
          + sig_HOI(6) * fint(j,k,6) &
          + sig_HOI(7) * fint(j,k,7)

        jval_gp(ip_HOI)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_HOI

  ! **************************************************************************

  SUBROUTINE jval_cal_I2(jrow)

    ! I2 -> products Tellinghuisen, JCP, 1973

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_I2

    ! T-const parameters:
    REAL, PARAMETER :: a6_I2(1) = (/ 4.5135E-21 /)
    REAL, PARAMETER :: a7_I2(2) = (/ 1.0793E-18, -1.6181E-24 /)

    jval_gp(ip_I2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_I2(6) = &
          a6_I2(1)
        sig_I2(7) = &
          p1(a7_I2(1),a7_I2(2),v3_du2(j,k))
        dj = 0. &
          + sig_I2(6) * fint(j,k,6) &
          + sig_I2(7) * fint(j,k,7)

        jval_gp(ip_I2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_I2

  ! **************************************************************************

  SUBROUTINE jval_cal_ICl(jrow)

    ! ICl -> products

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_ICl

    ! T-const parameters:
    REAL, PARAMETER :: a1_1_ICl(dim55) = (/ &
      -9.9331E-21, -9.3985E-21, -8.8650E-21, -8.0358E-21, -7.2302E-21, -6.4273E-21, &
      -5.6112E-21, -4.9823E-21, -4.2718E-21, -3.8342E-21, -3.2480E-21, -2.9655E-21, &
      -2.4862E-21, -2.3132E-21, -1.9186E-21, -1.8208E-21, -1.4903E-21, -1.4434E-21, &
      -1.1632E-21, -1.1506E-21, -9.0999E-22, -9.2071E-22, -7.1269E-22, -7.3881E-22, &
      -5.5734E-22, -5.9371E-22, -4.3535E-22, -4.7755E-22, -3.3869E-22, -3.8432E-22, &
      -2.6246E-22, -3.0925E-22, -2.0205E-22, -2.4878E-22, -1.5448E-22, -1.9992E-22, &
      -1.1688E-22, -1.6056E-22, -8.7412E-23, -1.2878E-22, -6.5655E-23, -3.8838E-23, &
      -1.3383E-23, -7.8686E-24, 8.2494E-25, 5.6057E-25, 3.3939E-24, 2.0675E-24, &
      4.3291E-24, 2.8039E-24, 1.8002E-24, 1.1471E-24, 7.2601E-25, 4.5673E-25, &
      2.8574E-25 /)
    REAL, PARAMETER :: b1_1_ICl(dim55) = (/ &
      2.4762E-19, 2.4602E-19, 2.4309E-19, 2.3645E-19, 2.2799E-19, 2.1756E-19, &
      2.0491E-19, 1.9359E-19, 1.7902E-19, 1.6896E-19, 1.5401E-19, 1.4610E-19, &
      1.3148E-19, 1.2577E-19, 1.1176E-19, 1.0805E-19, 9.4661E-20, 9.2643E-20, &
      7.9896E-20, 7.9289E-20, 6.7140E-20, 6.7708E-20, 5.6163E-20, 5.7678E-20, &
      4.6699E-20, 4.8990E-20, 3.8618E-20, 4.1488E-20, 3.1698E-20, 3.5029E-20, &
      2.5828E-20, 2.9478E-20, 2.0848E-20, 2.4727E-20, 1.6664E-20, 2.0663E-20, &
      1.3148E-20, 1.7210E-20, 1.0224E-20, 1.4279E-20, 7.9344E-21, 4.9041E-21, &
      1.7094E-21, 9.4850E-22, -3.5989E-22, -3.1679E-22, -8.1405E-22, -5.6468E-22, &
      -1.0181E-21, -6.9327E-22, -4.6693E-22, -3.1149E-22, -2.0601E-22, -1.3519E-22, &
      -8.8079E-23 /)
    REAL, PARAMETER :: a1_2_ICl(dim55) = (/ &
      1.4180E-23, 3.8393E-24, -2.0714E-25, -7.0249E-24, -1.0613E-23, -1.3034E-23, &
      -1.5519E-23, -1.4753E-23, -1.6488E-23, -1.4050E-23, -1.5464E-23, -1.2390E-23, &
      -1.3712E-23, -1.0597E-23, -1.1874E-23, -8.9390E-24, -1.0197E-23, -7.5230E-24, &
      -8.7298E-24, -6.3342E-24, -7.4754E-24, -5.3427E-24, -6.4032E-24, -4.5153E-24, &
      -5.4915E-24, -3.8223E-24, -4.7086E-24, -3.2402E-24, -4.0399E-24, -2.7493E-24, &
      -3.4654E-24, -2.3343E-24, -2.9731E-24, -1.9831E-24, -2.5500E-24, -1.6855E-24, &
      -2.1876E-24, -1.4325E-24, -1.8760E-24, -1.2180E-24, -1.2179E-24, -7.6311E-25, &
      -5.5822E-25, -3.4790E-25, -2.5675E-25, -1.5937E-25, -1.1864E-25, -7.3388E-26, &
      -6.3228E-26, -3.9536E-26, -2.4618E-26, -1.5269E-26, -9.4357E-27, -5.8105E-27, &
      -3.5661E-27 /)
    REAL, PARAMETER :: b1_2_ICl(dim55) = (/ &
      6.6099E-22, 6.9202E-22, 7.1427E-22, 7.6881E-22, 8.0648E-22, 8.3796E-22, &
      8.7647E-22, 8.6270E-22, 8.9825E-22, 8.4218E-22, 8.7824E-22, 7.9217E-22, &
      8.3248E-22, 7.2971E-22, 7.7503E-22, 6.6350E-22, 7.1444E-22, 5.9947E-22, &
      6.5438E-22, 5.3939E-22, 5.9702E-22, 4.8399E-22, 5.4285E-22, 4.3335E-22, &
      4.9241E-22, 3.8725E-22, 4.4530E-22, 3.4545E-22, 4.0183E-22, 3.0762E-22, &
      3.6168E-22, 2.7346E-22, 3.2488E-22, 2.4271E-22, 2.9118E-22, 2.1510E-22, &
      2.6054E-22, 1.9032E-22, 2.3267E-22, 1.6819E-22, 1.6818E-22, 1.1679E-22, &
      9.1073E-23, 6.2048E-23, 4.8330E-23, 3.2458E-23, 2.5309E-23, 1.6802E-23, &
      1.4765E-23, 9.7186E-24, 6.3545E-24, 4.1295E-24, 2.6682E-24, 1.7148E-24, &
      1.0965E-24 /)
    REAL, PARAMETER :: a2_ICl(dim55) = (/ &
      -8.6960E-21, -7.6760E-21, -6.3520E-21, -4.9960E-21, -3.7960E-21, -2.8280E-21, &
      -2.0920E-21, -1.5520E-21, -1.1600E-21, -8.8400E-22, -6.8400E-22, -5.4400E-22, &
      -4.3600E-22, -3.6000E-22, -3.0400E-22, -2.5600E-22, -2.2400E-22, -1.9200E-22, &
      -1.7200E-22, -1.5200E-22, -1.4000E-22, -1.2400E-22, -1.1200E-22, -1.0000E-22, &
      -9.5999E-23, -8.4000E-23, -8.0001E-23, -7.6000E-23, -6.7999E-23, -5.9999E-23, &
      -6.0002E-23, -5.1999E-23, -5.2001E-23, -4.8000E-23, -4.3998E-23, -4.0002E-23, &
      -3.9999E-23, -3.1999E-23, -3.6000E-23, -3.2002E-23, -2.5600E-23, -1.8400E-23, &
      -1.2800E-23, -9.5999E-24, -7.2001E-24, -4.7997E-24, -3.2002E-24, -3.2002E-24, &
      -1.5996E-24, -1.6001E-24, -8.0030E-25, -7.9978E-25, -0.0000E+00, -8.0030E-25, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b2_ICl(dim55) = (/ &
       2.2232E-19,  2.1926E-19,  2.1198E-19,  2.0113E-19,  1.8853E-19,  1.7594E-19, &
       1.6454E-19,  1.5482E-19,  1.4678E-19,  1.4043E-19,  1.3533E-19,  1.3141E-19, &
       1.2812E-19,  1.2561E-19,  1.2362E-19,  1.2180E-19,  1.2050E-19,  1.1913E-19, &
       1.1822E-19,  1.1726E-19,  1.1665E-19,  1.1580E-19,  1.1514E-19,  1.1444E-19, &
       1.1420E-19,  1.1344E-19,  1.1318E-19,  1.1291E-19,  1.1234E-19,  1.1176E-19, &
       1.1176E-19,  1.1114E-19,  1.1114E-19,  1.1080E-19,  1.1046E-19,  1.1011E-19, &
       1.1011E-19,  1.0937E-19,  1.0975E-19,  1.0936E-19,  1.0871E-19,  1.0790E-19, &
       1.0720E-19,  1.0675E-19,  1.0639E-19,  1.0600E-19,  1.0572E-19,  1.0572E-19, &
       1.0540E-19,  1.0540E-19,  1.0522E-19,  1.0522E-19,  1.0502E-19,  1.0523E-19, &
       1.0501E-19 /)
    REAL, PARAMETER :: a3_ICl(dim55) = (/ &
      -1.0736E-22, -9.1225E-23, -7.3648E-23, -5.7715E-23, -4.4728E-23, -3.4784E-23, &
      -2.7447E-23, -2.2045E-23, -1.8051E-23, -1.5096E-23, -1.2825E-23, -1.1022E-23, &
      -9.6246E-24, -8.4663E-24, -7.5509E-24, -6.7093E-24, -6.0703E-24, -5.4712E-24, &
      -4.9941E-24, -4.5927E-24, -4.1533E-24, -3.8738E-24, -3.5957E-24, -3.3147E-24, &
      -3.0750E-24, -2.9154E-24, -2.6767E-24, -2.5559E-24, -2.3563E-24, -2.2364E-24, &
      -2.1175E-24, -1.9968E-24, -1.9169E-24, -1.7971E-24, -1.6779E-24, -1.6374E-24, &
      -1.5575E-24, -1.4776E-24, -1.3983E-24, -1.3179E-24, -1.1901E-24, -9.6646E-25, &
      -8.0671E-25, -6.8691E-25, -5.8352E-25, -5.0321E-25, -4.3928E-25, -3.8341E-25, &
      -3.2748E-25, -2.9553E-25, -2.5558E-25, -2.2365E-25, -1.9183E-25, -1.7573E-25, &
      -1.5175E-25 /)
    REAL, PARAMETER :: b3_ICl(dim55) = (/ &
      6.8152E-20, 6.7740E-20, 6.6851E-20, 6.5646E-20, 6.4339E-20, 6.3089E-20, &
      6.1983E-20, 6.1034E-20, 6.0232E-20, 5.9564E-20, 5.8994E-20, 5.8497E-20, &
      5.8077E-20, 5.7699E-20, 5.7378E-20, 5.7061E-20, 5.6805E-20, 5.6549E-20, &
      5.6334E-20, 5.6143E-20, 5.5923E-20, 5.5776E-20, 5.5622E-20, 5.5460E-20, &
      5.5316E-20, 5.5216E-20, 5.5061E-20, 5.4979E-20, 5.4839E-20, 5.4752E-20, &
      5.4663E-20, 5.4569E-20, 5.4505E-20, 5.4406E-20, 5.4304E-20, 5.4269E-20, &
      5.4197E-20, 5.4123E-20, 5.4047E-20, 5.3969E-20, 5.3840E-20, 5.3588E-20, &
      5.3388E-20, 5.3223E-20, 5.3068E-20, 5.2937E-20, 5.2825E-20, 5.2720E-20, &
      5.2608E-20, 5.2540E-20, 5.2450E-20, 5.2374E-20, 5.2294E-20, 5.2252E-20, &
      5.2186E-20 /)
    REAL, PARAMETER :: a4_ICl(2) = (/ 4.5861E-20, -7.2364E-25 /)
    REAL, PARAMETER :: a5_ICl(2) = (/ 3.7756E-20, -4.5438E-25 /)
    REAL, PARAMETER :: a6_ICl(1) = (/ 1.4751E-19 /)
    REAL, PARAMETER :: a7_ICl(2) = (/ 1.3766E-19, 5.4808E-24 /)

    jval_gp(ip_ICl)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_ICl(1) = &
          (p1(b1_1_ICl(i1(j,k)),a1_1_ICl(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_ICl(i1(j,k)),a1_2_ICl(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_ICl(2) = &
          p1(b2_ICl(i2(j,k)), a2_ICl(i2(j,k)), &
          v3_du1(j,k))
        sig_ICl(3) = &
          p1(b3_ICl(i3(j,k)), a3_ICl(i3(j,k)), &
          v3_du2(j,k))
        sig_ICl(4) = &
          p1(a4_ICl(1),a4_ICl(2),v3_du2(j,k))
        sig_ICl(5) = &
          p1(a5_ICl(1),a5_ICl(2),v3_du2(j,k))
        sig_ICl(6) = &
          a6_ICl(1)
        sig_ICl(7) = &
          p1(a7_ICl(1),a7_ICl(2),v3_du2(j,k))
        dj = 0. &
          + sig_ICl(1) * fint(j,k,1) &
          + sig_ICl(2) * fint(j,k,2) &
          + sig_ICl(3) * fint(j,k,3) &
          + sig_ICl(4) * fint(j,k,4) &
          + sig_ICl(5) * fint(j,k,5) &
          + sig_ICl(6) * fint(j,k,6) &
          + sig_ICl(7) * fint(j,k,7)

        jval_gp(ip_ICl)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_ICl

  ! **************************************************************************

  SUBROUTINE jval_cal_IBr(jrow)

    ! IBr -> products Seery and Britton (1964)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_IBr

    ! T-const parameters:
    REAL, PARAMETER :: a1_1_IBr(dim55) = (/ &
      -2.0482E-21, -1.8817E-21, -1.7093E-21, -1.5103E-21, -1.3136E-21, -1.1437E-21, &
      -9.6957E-22, -8.4808E-22, -7.0985E-22, -6.3107E-22, -5.2515E-22, -4.7674E-22, &
      -3.9452E-22, -3.6646E-22, -3.0099E-22, -2.8580E-22, -2.3246E-22, -2.2547E-22, &
      -1.8094E-22, -1.7927E-22, -1.4153E-22, -1.4339E-22, -1.1089E-22, -1.1508E-22, &
      -8.6914E-23, -9.2581E-23, -6.8000E-23, -7.4585E-23, -5.3053E-23, -6.0117E-23, &
      -4.1205E-23, -4.8477E-23, -3.1809E-23, -3.9063E-23, -2.4397E-23, -3.1453E-23, &
      -1.8514E-23, -2.5311E-23, -1.3890E-23, -2.0344E-23, -1.0448E-23, -6.2061E-24, &
      -2.1742E-24, -1.2828E-24, 1.0693E-25, 7.4662E-26, 5.3134E-25, 3.2444E-25, &
      6.8814E-25, 4.4672E-25, 2.8739E-25, 1.8342E-25, 1.1624E-25, 7.3212E-26, &
      4.5843E-26 /)
    REAL, PARAMETER :: b1_1_IBr(dim55) = (/ &
      4.4173E-20, 4.3674E-20, 4.2725E-20, 4.1133E-20, 3.9068E-20, 3.6860E-20, &
      3.4160E-20, 3.1974E-20, 2.9140E-20, 2.7328E-20, 2.4627E-20, 2.3271E-20, &
      2.0764E-20, 1.9838E-20, 1.7513E-20, 1.6936E-20, 1.4776E-20, 1.4476E-20, &
      1.2449E-20, 1.2369E-20, 1.0463E-20, 1.0562E-20, 8.7583E-21, 9.0014E-21, &
      7.2970E-21, 7.6541E-21, 6.0440E-21, 6.4918E-21, 4.9738E-21, 5.4895E-21, &
      4.0616E-21, 4.6288E-21, 3.2870E-21, 3.8891E-21, 2.6352E-21, 3.2561E-21, &
      2.0852E-21, 2.7172E-21, 1.6265E-21, 2.2591E-21, 1.2645E-21, 7.8517E-22, &
      2.7916E-22, 1.5615E-22, -5.3001E-23, -4.7742E-23, -1.2789E-22, -8.8992E-23, &
      -1.6191E-22, -1.1049E-22, -7.4563E-23, -4.9818E-23, -3.2988E-23, -2.1673E-23, &
      -1.4132E-23 /)
    REAL, PARAMETER :: a1_2_IBr(dim55) = (/ &
      1.0220E-24, -7.7121E-25, -1.6601E-24, -2.5789E-24, -3.1951E-24, -3.2562E-24, &
      -3.6031E-24, -3.1590E-24, -3.3640E-24, -2.7332E-24, -2.8946E-24, -2.2533E-24, &
      -2.4189E-24, -1.8298E-24, -2.0075E-24, -1.4898E-24, -1.6717E-24, -1.2214E-24, &
      -1.4022E-24, -1.0114E-24, -1.1837E-24, -8.4303E-25, -1.0054E-24, -7.0742E-25, &
      -8.5721E-25, -5.9626E-25, -7.3294E-25, -5.0408E-25, -6.2777E-25, -4.2723E-25, &
      -5.3831E-25, -3.6259E-25, -4.6199E-25, -3.0813E-25, -3.9648E-25, -2.6209E-25, &
      -3.4050E-25, -2.2296E-25, -2.9237E-25, -1.8974E-25, -1.9022E-25, -1.1958E-25, &
      -8.7775E-26, -5.4864E-26, -4.0608E-26, -2.5265E-26, -1.8851E-26, -1.1682E-26, &
      -1.0085E-26, -6.3162E-27, -3.9385E-27, -2.4457E-27, -1.5128E-27, -9.3238E-28, &
      -5.7263E-28 /)
    REAL, PARAMETER :: b1_2_IBr(dim55) = (/ &
      1.3758E-22, 1.4296E-22, 1.4785E-22, 1.5520E-22, 1.6167E-22, 1.6247E-22, &
      1.6784E-22, 1.5985E-22, 1.6405E-22, 1.4954E-22, 1.5366E-22, 1.3570E-22, &
      1.4075E-22, 1.2131E-22, 1.2762E-22, 1.0795E-22, 1.1531E-22, 9.5953E-23, &
      1.0418E-22, 8.5421E-23, 9.4121E-23, 7.6066E-23, 8.5080E-23, 6.7795E-23, &
      7.6857E-23, 6.0417E-23, 6.9370E-23, 5.3807E-23, 6.2528E-23, 4.7888E-23, &
      5.6275E-23, 4.2568E-23, 5.0570E-23, 3.7800E-23, 4.5354E-23, 3.3527E-23, &
      4.0623E-23, 2.9692E-23, 3.6321E-23, 2.6263E-23, 2.6312E-23, 1.8329E-23, &
      1.4338E-23, 9.7958E-24, 7.6502E-24, 5.1493E-24, 4.0237E-24, 2.6760E-24, &
      2.3557E-24, 1.5530E-24, 1.0168E-24, 6.6153E-25, 4.2784E-25, 2.7520E-25, &
      1.7608E-25 /)
    REAL, PARAMETER :: a2_IBr(dim55) = (/ &
      -8.1200E-22, -9.2400E-22, -9.5200E-22, -9.0400E-22, -8.2000E-22, -7.0800E-22, &
      -6.0800E-22, -5.1600E-22, -4.3200E-22, -3.6800E-22, -3.1200E-22, -2.7200E-22, &
      -2.3200E-22, -2.0400E-22, -1.7600E-22, -1.6000E-22, -1.4000E-22, -1.2800E-22, &
      -1.1600E-22, -1.0400E-22, -9.5999E-23, -8.8002E-23, -7.9999E-23, -7.2001E-23, &
      -7.2001E-23, -6.0002E-23, -5.9996E-23, -5.6000E-23, -4.8002E-23, -4.8002E-23, &
      -4.3996E-23, -4.4001E-23, -3.6003E-23, -3.5998E-23, -3.5998E-23, -2.8000E-23, &
      -3.2002E-23, -2.8000E-23, -2.3999E-23, -2.4004E-23, -1.9999E-23, -1.4400E-23, &
      -1.0401E-23, -7.1996E-24, -5.6000E-24, -3.2002E-24, -3.2002E-24, -1.5996E-24, &
      -1.6006E-24, -1.5996E-24, -8.0030E-25, -0.0000E+00, -7.9926E-25, -0.0000E+00, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b2_IBr(dim55) = (/ &
       2.0405E-19,  2.0438E-19,  2.0454E-19,  2.0415E-19,  2.0327E-19,  2.0181E-19, &
       2.0026E-19,  1.9861E-19,  1.9689E-19,  1.9541E-19,  1.9399E-19,  1.9287E-19, &
       1.9165E-19,  1.9072E-19,  1.8973E-19,  1.8912E-19,  1.8831E-19,  1.8779E-19, &
       1.8725E-19,  1.8667E-19,  1.8627E-19,  1.8584E-19,  1.8540E-19,  1.8494E-19, &
       1.8494E-19,  1.8418E-19,  1.8418E-19,  1.8391E-19,  1.8334E-19,  1.8334E-19, &
       1.8304E-19,  1.8304E-19,  1.8240E-19,  1.8240E-19,  1.8240E-19,  1.8169E-19, &
       1.8206E-19,  1.8168E-19,  1.8130E-19,  1.8130E-19,  1.8090E-19,  1.8027E-19, &
       1.7977E-19,  1.7932E-19,  1.7908E-19,  1.7869E-19,  1.7869E-19,  1.7839E-19, &
       1.7839E-19,  1.7839E-19,  1.7821E-19,  1.7802E-19,  1.7822E-19,  1.7801E-19, &
       1.7801E-19 /)
    REAL, PARAMETER :: a3_IBr(dim55) = (/ &
      -1.7374E-22, -1.5217E-22, -1.2661E-22, -1.0305E-22, -8.2667E-23, -6.7093E-23, &
      -5.4735E-23, -4.5926E-23, -3.8339E-23, -3.3546E-23, -2.8765E-23, -2.5559E-23, &
      -2.2364E-23, -2.0367E-23, -1.8378E-23, -1.6374E-23, -1.5176E-23, -1.3978E-23, &
      -1.2785E-23, -1.1582E-23, -1.1182E-23, -9.9838E-24, -9.5885E-24, -8.7861E-24, &
      -8.3866E-24, -7.9871E-24, -7.1915E-24, -7.1883E-24, -6.3898E-24, -6.3898E-24, &
      -5.9927E-24, -5.5911E-24, -5.1918E-24, -5.1915E-24, -4.7945E-24, -4.7923E-24, &
      -4.3928E-24, -4.3931E-24, -3.9951E-24, -3.9938E-24, -3.5143E-24, -2.8754E-24, &
      -2.4760E-24, -2.1565E-24, -1.8385E-24, -1.5176E-24, -1.4377E-24, -1.1981E-24, &
      -1.0384E-24, -9.5846E-25, -7.9871E-25, -7.1886E-25, -6.3947E-25, -5.5911E-25, &
      -4.7926E-25 /)
    REAL, PARAMETER :: b3_IBr(dim55) = (/ &
      1.3327E-19, 1.3272E-19, 1.3142E-19, 1.2964E-19, 1.2759E-19, 1.2563E-19, &
      1.2377E-19, 1.2222E-19, 1.2070E-19, 1.1962E-19, 1.1842E-19, 1.1753E-19, &
      1.1657E-19, 1.1592E-19, 1.1522E-19, 1.1447E-19, 1.1399E-19, 1.1348E-19, &
      1.1294E-19, 1.1237E-19, 1.1217E-19, 1.1153E-19, 1.1132E-19, 1.1085E-19, &
      1.1061E-19, 1.1036E-19, 1.0985E-19, 1.0984E-19, 1.0928E-19, 1.0928E-19, &
      1.0898E-19, 1.0867E-19, 1.0835E-19, 1.0835E-19, 1.0801E-19, 1.0801E-19, &
      1.0765E-19, 1.0765E-19, 1.0727E-19, 1.0727E-19, 1.0679E-19, 1.0607E-19, &
      1.0557E-19, 1.0513E-19, 1.0465E-19, 1.0413E-19, 1.0399E-19, 1.0354E-19, &
      1.0322E-19, 1.0305E-19, 1.0269E-19, 1.0250E-19, 1.0230E-19, 1.0209E-19, &
      1.0187E-19 /)
    REAL, PARAMETER :: a4_IBr(3) = (/ 8.1090E-20, -6.1089E-24, 1.0893E-27 /)
    REAL, PARAMETER :: a5_IBr(3) = (/ 4.1568E-20, -3.9111E-24, 5.1052E-28 /)
    REAL, PARAMETER :: a6_IBr(1) = (/ 1.1457E-19 /)
    REAL, PARAMETER :: a7_IBr(2) = (/ 4.6597E-19, 1.0902E-23 /)

    jval_gp(ip_IBr)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_IBr(1) = &
          (p1(b1_1_IBr(i1(j,k)),a1_1_IBr(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_IBr(i1(j,k)),a1_2_IBr(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_IBr(2) = &
          p1(b2_IBr(i2(j,k)), a2_IBr(i2(j,k)), &
          v3_du1(j,k))
        sig_IBr(3) = &
          p1(b3_IBr(i3(j,k)), a3_IBr(i3(j,k)), &
          v3_du2(j,k))
        sig_IBr(4) = &
          p2(a4_IBr(1),a4_IBr(2),a4_IBr(3),v3_du2(j,k))
        sig_IBr(5) = &
          p2(a5_IBr(1),a5_IBr(2),a5_IBr(3),v3_du2(j,k))
        sig_IBr(6) = &
          a6_IBr(1)
        sig_IBr(7) = &
          p1(a7_IBr(1),a7_IBr(2),v3_du2(j,k))
        dj = 0. &
          + sig_IBr(1) * fint(j,k,1) &
          + sig_IBr(2) * fint(j,k,2) &
          + sig_IBr(3) * fint(j,k,3) &
          + sig_IBr(4) * fint(j,k,4) &
          + sig_IBr(5) * fint(j,k,5) &
          + sig_IBr(6) * fint(j,k,6) &
          + sig_IBr(7) * fint(j,k,7)

        jval_gp(ip_IBr)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_IBr

  ! **************************************************************************

  SUBROUTINE jval_cal_INO2(jrow)

    ! INO2 -> products Broeske and Zabel (1998), Broeske (2000)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_INO2

    ! T-const parameters:
    REAL, PARAMETER :: a1_1_INO2(dim55) = (/ &
      -6.3712E-20, -5.9182E-20, -5.4732E-20, -4.8806E-20, -4.3256E-20, -3.7922E-20, &
      -3.2944E-20, -2.8955E-20, -2.5066E-20, -2.2371E-20, -1.9519E-20, -1.7746E-20, &
      -1.5682E-20, -1.4517E-20, -1.3028E-20, -1.2223E-20, -1.1165E-20, -1.0583E-20, &
      -9.7792E-21, -9.3614E-21, -8.7539E-21, -8.4322E-21, -7.9742E-21, -7.7045E-21, &
      -7.3569E-21, -7.1291E-21, -6.8736E-21, -6.6481E-21, -6.4728E-21, -6.2877E-21, &
      -6.1382E-21, -5.9591E-21, -5.8799E-21, -5.6982E-21, -5.6383E-21, -5.4619E-21, &
      -5.4409E-21, -5.2712E-21, -5.2630E-21, -5.0958E-21, -4.9386E-21, -4.6261E-21, &
      -4.4027E-21, -4.1769E-21, -4.0038E-21, -3.8183E-21, -3.6599E-21, -3.4980E-21, &
      -3.3171E-21, -3.1275E-21, -2.9424E-21, -2.7627E-21, -2.5894E-21, -2.4238E-21, &
      -2.2650E-21 /)
    REAL, PARAMETER :: b1_1_INO2(dim55) = (/ &
      2.7744E-18, 2.7608E-18, 2.7363E-18, 2.6889E-18, 2.6307E-18, 2.5613E-18, &
      2.4842E-18, 2.4124E-18, 2.3326E-18, 2.2707E-18, 2.1979E-18, 2.1483E-18, &
      2.0853E-18, 2.0469E-18, 1.9940E-18, 1.9634E-18, 1.9206E-18, 1.8955E-18, &
      1.8590E-18, 1.8389E-18, 1.8083E-18, 1.7912E-18, 1.7658E-18, 1.7501E-18, &
      1.7291E-18, 1.7148E-18, 1.6980E-18, 1.6827E-18, 1.6703E-18, 1.6568E-18, &
      1.6455E-18, 1.6316E-18, 1.6252E-18, 1.6101E-18, 1.6050E-18, 1.5895E-18, &
      1.5876E-18, 1.5718E-18, 1.5710E-18, 1.5546E-18, 1.5388E-18, 1.5035E-18, &
      1.4755E-18, 1.4443E-18, 1.4183E-18, 1.3880E-18, 1.3602E-18, 1.3298E-18, &
      1.2935E-18, 1.2531E-18, 1.2114E-18, 1.1686E-18, 1.1252E-18, 1.0816E-18, &
      1.0379E-18 /)
    REAL, PARAMETER :: a1_2_INO2(dim55) = (/ &
      6.1383E-23, -1.6418E-24, -2.5926E-23, -6.2546E-23, -7.8940E-23, -8.8625E-23, &
      -9.4947E-23, -8.8455E-23, -8.9020E-23, -7.6017E-23, -7.4514E-23, -6.1218E-23, &
      -5.9359E-23, -4.7906E-23, -4.6331E-23, -3.7395E-23, -3.5903E-23, -2.9246E-23, &
      -2.8104E-23, -2.3144E-23, -2.2191E-23, -1.8462E-23, -1.7620E-23, -1.5066E-23, &
      -1.4130E-23, -1.2343E-23, -1.1416E-23, -1.0347E-23, -9.3110E-24, -8.6256E-24, &
      -7.6751E-24, -7.3541E-24, -6.2687E-24, -6.3091E-24, -5.2399E-24, -5.5096E-24, &
      -4.3779E-24, -4.7998E-24, -3.7087E-24, -4.2448E-24, -3.0809E-24, -2.4783E-24, &
      -1.8756E-24, -1.7641E-24, -1.5288E-24, -1.5589E-24, -1.5086E-24, -1.5493E-24, &
      -1.7407E-24, -1.9978E-24, -2.2390E-24, -2.4532E-24, -2.6368E-24, -2.7861E-24, &
      -2.9035E-24 /)
    REAL, PARAMETER :: b1_2_INO2(dim55) = (/ &
      4.2835E-21, 4.4726E-21, 4.6062E-21, 4.8991E-21, 5.0713E-21, 5.1972E-21, &
      5.2952E-21, 5.1783E-21, 5.1899E-21, 4.8908E-21, 4.8525E-21, 4.4802E-21, &
      4.4235E-21, 4.0455E-21, 3.9896E-21, 3.6501E-21, 3.5896E-21, 3.3034E-21, &
      3.2514E-21, 3.0134E-21, 2.9652E-21, 2.7676E-21, 2.7208E-21, 2.5727E-21, &
      2.5161E-21, 2.4035E-21, 2.3428E-21, 2.2701E-21, 2.1971E-21, 2.1470E-21, &
      2.0753E-21, 2.0502E-21, 1.9629E-21, 1.9662E-21, 1.8748E-21, 1.8985E-21, &
      1.7961E-21, 1.8353E-21, 1.7311E-21, 1.7837E-21, 1.6667E-21, 1.5986E-21, &
      1.5230E-21, 1.5076E-21, 1.4722E-21, 1.4771E-21, 1.4683E-21, 1.4759E-21, &
      1.5143E-21, 1.5690E-21, 1.6234E-21, 1.6744E-21, 1.7204E-21, 1.7597E-21, &
      1.7920E-21 /)
    REAL, PARAMETER :: a2_INO2(dim55) = (/ &
      -3.2480E-20, -2.6360E-20, -2.0000E-20, -1.4300E-20, -9.8200E-21, -6.5680E-21, &
      -4.3360E-21, -2.8720E-21, -1.9360E-21, -1.3440E-21, -9.7599E-22, -7.3603E-22, &
      -5.9197E-22, -4.9201E-22, -4.2401E-22, -3.7599E-22, -3.4001E-22, -3.1197E-22, &
      -2.8802E-22, -2.6801E-22, -2.5200E-22, -2.3599E-22, -2.1999E-22, -2.0799E-22, &
      -1.9600E-22, -1.7999E-22, -1.7201E-22, -1.6399E-22, -1.4802E-22, -1.4397E-22, &
      -1.3603E-22, -1.2399E-22, -1.1998E-22, -1.0799E-22, -1.0402E-22, -1.0001E-22, &
      -9.1982E-23, -8.8012E-23, -7.9988E-23, -7.6018E-23, -6.3197E-23, -4.6405E-23, &
      -3.3600E-23, -2.3997E-23, -1.7602E-23, -1.2796E-23, -8.8012E-24, -7.2047E-24, &
      -4.7976E-24, -3.2012E-24, -2.3988E-24, -1.5965E-24, -1.6047E-24, -7.9409E-25, &
      -8.0237E-25 /)
    REAL, PARAMETER :: b2_INO2(dim55) = (/ &
      1.2325E-18, 1.2142E-18, 1.1792E-18, 1.1336E-18, 1.0866E-18, 1.0443E-18, &
      1.0097E-18, 9.8334E-19, 9.6415E-19, 9.5053E-19, 9.4115E-19, 9.3443E-19, &
      9.3004E-19, 9.2674E-19, 9.2432E-19, 9.2250E-19, 9.2104E-19, 9.1983E-19, &
      9.1875E-19, 9.1778E-19, 9.1698E-19, 9.1613E-19, 9.1524E-19, 9.1454E-19, &
      9.1382E-19, 9.1281E-19, 9.1229E-19, 9.1174E-19, 9.1062E-19, 9.1032E-19, &
      9.0972E-19, 9.0878E-19, 9.0846E-19, 9.0746E-19, 9.0712E-19, 9.0677E-19, &
      9.0604E-19, 9.0568E-19, 9.0491E-19, 9.0452E-19, 9.0323E-19, 9.0133E-19, &
      8.9973E-19, 8.9840E-19, 8.9744E-19, 8.9666E-19, 8.9595E-19, 8.9565E-19, &
      8.9517E-19, 8.9483E-19, 8.9465E-19, 8.9446E-19, 8.9446E-19, 8.9425E-19, &
      8.9425E-19 /)
    REAL, PARAMETER :: a3_INO2(dim55) = (/ &
      -1.5105E-21, -1.2941E-21, -1.0548E-21, -8.3436E-22, -6.5256E-22, -5.1238E-22, &
      -4.0711E-22, -3.2867E-22, -2.7037E-22, -2.2564E-22, -1.9217E-22, -1.6494E-22, &
      -1.4297E-22, -1.2580E-22, -1.1107E-22, -9.9041E-23, -8.8259E-23, -7.9474E-23, &
      -7.1914E-23, -6.5495E-23, -5.9505E-23, -5.4313E-23, -4.9940E-23, -4.5927E-23, &
      -4.2332E-23, -3.9138E-23, -3.6356E-23, -3.3946E-23, -3.1550E-23, -2.9153E-23, &
      -2.7567E-23, -2.5559E-23, -2.3961E-23, -2.2364E-23, -2.1175E-23, -1.9569E-23, &
      -1.8770E-23, -1.7572E-23, -1.6380E-23, -1.5575E-23, -1.3179E-23, -1.0064E-23, &
      -7.7476E-24, -6.0703E-24, -4.8763E-24, -3.7539E-24, -3.1149E-24, -2.3962E-24, &
      -1.9967E-24, -1.5974E-24, -1.2780E-24, -1.0383E-24, -7.9945E-25, -6.3901E-25, &
      -5.5911E-25 /)
    REAL, PARAMETER :: b3_INO2(dim55) = (/ &
      5.2230E-19, 5.1677E-19, 5.0467E-19, 4.8800E-19, 4.6970E-19, 4.5208E-19, &
      4.3621E-19, 4.2243E-19, 4.1072E-19, 4.0062E-19, 3.9222E-19, 3.8471E-19, &
      3.7810E-19, 3.7250E-19, 3.6733E-19, 3.6281E-19, 3.5848E-19, 3.5474E-19, &
      3.5133E-19, 3.4827E-19, 3.4527E-19, 3.4253E-19, 3.4012E-19, 3.3781E-19, &
      3.3565E-19, 3.3365E-19, 3.3184E-19, 3.3020E-19, 3.2852E-19, 3.2678E-19, &
      3.2559E-19, 3.2403E-19, 3.2275E-19, 3.2143E-19, 3.2042E-19, 3.1901E-19, &
      3.1829E-19, 3.1718E-19, 3.1604E-19, 3.1526E-19, 3.1286E-19, 3.0934E-19, &
      3.0644E-19, 3.0413E-19, 3.0234E-19, 3.0051E-19, 2.9939E-19, 2.9804E-19, &
      2.9724E-19, 2.9639E-19, 2.9567E-19, 2.9510E-19, 2.9450E-19, 2.9408E-19, &
      2.9386E-19 /)
    REAL, PARAMETER :: a4_INO2(3) = (/ 2.5297E-19, -9.5048E-24, 1.9109E-27 /)
    REAL, PARAMETER :: a5_INO2(2) = (/ 3.1208E-19, 8.3266E-24 /)
    REAL, PARAMETER :: a6_INO2(1) = (/ 9.6028E-20 /)

    jval_gp(ip_INO2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_INO2(1) = &
          (p1(b1_1_INO2(i1(j,k)),a1_1_INO2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_INO2(i1(j,k)),a1_2_INO2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_INO2(2) = &
          p1(b2_INO2(i2(j,k)), a2_INO2(i2(j,k)), &
          v3_du1(j,k))
        sig_INO2(3) = &
          p1(b3_INO2(i3(j,k)), a3_INO2(i3(j,k)), &
          v3_du2(j,k))
        sig_INO2(4) = &
          p2(a4_INO2(1),a4_INO2(2),a4_INO2(3),v3_du2(j,k))
        sig_INO2(5) = &
          p1(a5_INO2(1),a5_INO2(2),v3_du2(j,k))
        sig_INO2(6) = &
          a6_INO2(1)
        dj = 0. &
          + sig_INO2(1) * fint(j,k,1) &
          + sig_INO2(2) * fint(j,k,2) &
          + sig_INO2(3) * fint(j,k,3) &
          + sig_INO2(4) * fint(j,k,4) &
          + sig_INO2(5) * fint(j,k,5) &
          + sig_INO2(6) * fint(j,k,6)

        jval_gp(ip_INO2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_INO2

  ! **************************************************************************

  SUBROUTINE jval_cal_INO3(jrow)

    ! INO3 -> products Moessinger et al. (2002)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_INO3

    ! T-const parameters:
    REAL, PARAMETER :: a2_INO3(dim55) = (/ &
      -1.2352E-19, -1.0716E-19, -8.7440E-20, -6.8040E-20, -5.1320E-20, -3.8120E-20, &
      -2.8240E-20, -2.1080E-20, -1.6000E-20, -1.2400E-20, -9.8401E-21, -8.0399E-21, &
      -6.6403E-21, -5.6798E-21, -4.8800E-21, -4.2802E-21, -3.7600E-21, -3.4000E-21, &
      -3.0798E-21, -2.7601E-21, -2.5600E-21, -2.3201E-21, -2.1599E-21, -2.0001E-21, &
      -1.8400E-21, -1.7199E-21, -1.6001E-21, -1.4800E-21, -1.3999E-21, -1.2801E-21, &
      -1.1997E-21, -1.1600E-21, -1.0800E-21, -1.0002E-21, -9.1982E-22, -8.8012E-22, &
      -8.4008E-22, -7.6001E-22, -7.1998E-22, -6.7994E-22, -5.6798E-22, -4.2398E-22, &
      -3.0401E-22, -2.2400E-22, -1.6802E-22, -1.1997E-22, -8.8012E-23, -7.1998E-23, &
      -4.8043E-23, -3.1962E-23, -2.4021E-23, -2.4021E-23, -8.0071E-24, -1.5948E-23, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b2_INO3(dim55) = (/ &
      9.0318E-18, 8.9827E-18, 8.8742E-18, 8.7190E-18, 8.5435E-18, 8.3719E-18, &
      8.2187E-18, 8.0898E-18, 7.9857E-18, 7.9029E-18, 7.8376E-18, 7.7872E-18, &
      7.7445E-18, 7.7128E-18, 7.6844E-18, 7.6616E-18, 7.6406E-18, 7.6251E-18, &
      7.6105E-18, 7.5952E-18, 7.5851E-18, 7.5724E-18, 7.5635E-18, 7.5542E-18, &
      7.5445E-18, 7.5370E-18, 7.5291E-18, 7.5209E-18, 7.5153E-18, 7.5066E-18, &
      7.5005E-18, 7.4974E-18, 7.4909E-18, 7.4843E-18, 7.4774E-18, 7.4740E-18, &
      7.4703E-18, 7.4629E-18, 7.4591E-18, 7.4551E-18, 7.4439E-18, 7.4276E-18, &
      7.4126E-18, 7.4015E-18, 7.3931E-18, 7.3853E-18, 7.3796E-18, 7.3766E-18, &
      7.3718E-18, 7.3684E-18, 7.3666E-18, 7.3666E-18, 7.3626E-18, 7.3647E-18, &
      7.3603E-18 /)
    REAL, PARAMETER :: a3_INO3(dim55) = (/ &
      -5.2424E-21, -3.0827E-21, -1.6361E-21, -9.2590E-22, -5.8371E-22, -4.0390E-22, &
      -2.9779E-22, -2.3280E-22, -1.8826E-22, -1.5403E-22, -1.3180E-22, -1.1296E-22, &
      -9.9260E-23, -8.5592E-23, -7.7013E-23, -6.8467E-23, -5.9904E-23, -5.6459E-23, &
      -4.9659E-23, -4.4518E-23, -4.2738E-23, -3.7669E-23, -3.5955E-23, -3.2535E-23, &
      -3.0768E-23, -2.9114E-23, -2.5686E-23, -2.5679E-23, -2.2228E-23, -2.2259E-23, &
      -2.0545E-23, -1.8838E-23, -1.7095E-23, -1.7124E-23, -1.5410E-23, -1.5384E-23, &
      -1.3697E-23, -1.3697E-23, -1.1990E-23, -1.1962E-23, -9.5858E-24, -7.1900E-24, &
      -5.4749E-24, -4.1090E-24, -3.0810E-24, -2.3949E-24, -1.7118E-24, -1.3692E-24, &
      -1.0276E-24, -1.0265E-24, -3.4265E-25, -6.8365E-25, -3.4265E-25, -0.0000E+00, &
      -3.4254E-25 /)
    REAL, PARAMETER :: b3_INO3(dim55) = (/ &
      5.9917E-18, 5.8645E-18, 5.6947E-18, 5.5699E-18, 5.4897E-18, 5.4371E-18, &
      5.3998E-18, 5.3732E-18, 5.3524E-18, 5.3344E-18, 5.3214E-18, 5.3093E-18, &
      5.2996E-18, 5.2893E-18, 5.2822E-18, 5.2747E-18, 5.2667E-18, 5.2633E-18, &
      5.2562E-18, 5.2504E-18, 5.2484E-18, 5.2421E-18, 5.2399E-18, 5.2353E-18, &
      5.2329E-18, 5.2304E-18, 5.2252E-18, 5.2252E-18, 5.2196E-18, 5.2196E-18, &
      5.2166E-18, 5.2135E-18, 5.2103E-18, 5.2103E-18, 5.2069E-18, 5.2069E-18, &
      5.2033E-18, 5.2033E-18, 5.1995E-18, 5.1995E-18, 5.1939E-18, 5.1876E-18, &
      5.1826E-18, 5.1782E-18, 5.1746E-18, 5.1720E-18, 5.1692E-18, 5.1677E-18, &
      5.1661E-18, 5.1661E-18, 5.1625E-18, 5.1644E-18, 5.1624E-18, 5.1603E-18, &
      5.1625E-18 /)
    REAL, PARAMETER :: a4_INO3(2) = (/ 4.9236E-18, -9.1420E-24 /)
    REAL, PARAMETER :: a5_INO3(2) = (/ 4.3272E-18, -2.6861E-23 /)
    REAL, PARAMETER :: a6_INO3(1) = (/ 1.7711E-18 /)
    REAL, PARAMETER :: a7_INO3(2) = (/ 8.2877E-21, 4.8144E-25 /)

    jval_gp(ip_INO3)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_INO3(2) = &
          p1(b2_INO3(i2(j,k)), a2_INO3(i2(j,k)), &
          v3_du1(j,k))
        sig_INO3(3) = &
          p1(b3_INO3(i3(j,k)), a3_INO3(i3(j,k)), &
          v3_du2(j,k))
        sig_INO3(4) = &
          p1(a4_INO3(1),a4_INO3(2),v3_du2(j,k))
        sig_INO3(5) = &
          p1(a5_INO3(1),a5_INO3(2),v3_du2(j,k))
        sig_INO3(6) = &
          a6_INO3(1)
        sig_INO3(7) = &
          p1(a7_INO3(1),a7_INO3(2),v3_du2(j,k))
        dj = 0. &
          + sig_INO3(2) * fint(j,k,2) &
          + sig_INO3(3) * fint(j,k,3) &
          + sig_INO3(4) * fint(j,k,4) &
          + sig_INO3(5) * fint(j,k,5) &
          + sig_INO3(6) * fint(j,k,6) &
          + sig_INO3(7) * fint(j,k,7)

        jval_gp(ip_INO3)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_INO3

  ! **************************************************************************

  SUBROUTINE jval_cal_SO2(jrow)

    ! SO2 -> products 135-315 nm: Warneck, et al., J. Chem. Phys. 40, 1132 (1964); threshold 220 nm (JPL 1997)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_SO2

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_SO2(dim58) = (/ &
      2.4997E-20, 2.7039E-20, 2.9270E-20, 3.1483E-20, 3.3940E-20, 3.6297E-20, &
      3.8728E-20, 4.1225E-20, 4.3797E-20, 4.6388E-20, 4.9135E-20, 5.2012E-20, &
      5.6748E-20, 6.4553E-20, 6.5685E-20, 6.8374E-20, 7.2770E-20, 7.3606E-20, &
      7.6251E-20, 7.9796E-20, 8.0446E-20, 8.2451E-20, 8.5241E-20, 8.5733E-20, &
      8.7403E-20, 8.7263E-20, 8.8622E-20, 9.1068E-20, 9.3797E-20, 9.6628E-20, &
      9.9611E-20, 1.0263E-19, 1.0575E-19, 1.0896E-19, 1.1245E-19, 1.1607E-19, &
      1.2026E-19, 1.2508E-19, 1.3069E-19, 1.3723E-19, 1.4467E-19, 1.5285E-19, &
      1.6167E-19, 1.7056E-19, 1.7901E-19, 1.8659E-19, 1.9223E-19, 1.9613E-19, &
      1.9760E-19, 1.9693E-19, 1.9429E-19, 1.8994E-19, 1.8407E-19, 1.7688E-19, &
      1.6821E-19, 1.5641E-19, 1.3764E-19, 1.1451E-19 /)
    REAL, PARAMETER :: a0_1_2_SO2(dim58) = (/ &
      2.8340E-18, 2.7437E-18, 2.6447E-18, 2.5460E-18, 2.4359E-18, 2.3298E-18, &
      2.2199E-18, 2.1066E-18, 1.9893E-18, 1.8706E-18, 1.7443E-18, 1.6114E-18, &
      1.3916E-18, 1.0279E-18, 9.7489E-19, 8.4854E-19, 6.4106E-19, 6.0139E-19, &
      4.7551E-19, 3.0607E-19, 2.7485E-19, 1.7820E-19, 4.3175E-20, 1.9252E-20, &
      -6.2246E-20, -5.5392E-20, -1.2225E-19, -2.4308E-19, -3.7840E-19, -5.1942E-19, &
      -6.6854E-19, -8.2033E-19, -9.7727E-19, -1.1400E-18, -1.3171E-18, -1.5016E-18, &
      -1.7164E-18, -1.9642E-18, -2.2533E-18, -2.5923E-18, -2.9793E-18, -3.4061E-18, &
      -3.8683E-18, -4.3360E-18, -4.7821E-18, -5.1838E-18, -5.4838E-18, -5.6922E-18, &
      -5.7711E-18, -5.7349E-18, -5.5922E-18, -5.3563E-18, -5.0373E-18, -4.6445E-18, &
      -4.1693E-18, -3.5205E-18, -2.4842E-18, -1.2029E-18 /)
    REAL, PARAMETER :: a0_2_1_SO2(dim58) = (/ &
      -9.4493E-23, -1.0173E-22, -1.0918E-22, -1.1637E-22, -1.2397E-22, -1.3181E-22, &
      -1.3858E-22, -1.4568E-22, -1.5211E-22, -1.5906E-22, -1.6515E-22, -1.7201E-22, &
      -2.0415E-22, -2.7922E-22, -2.5262E-22, -2.4878E-22, -2.6567E-22, -2.3925E-22, &
      -2.3494E-22, -2.4373E-22, -2.1968E-22, -2.1224E-22, -2.1492E-22, -1.9312E-22, &
      -1.8422E-22, -1.5678E-22, -1.4316E-22, -1.3946E-22, -1.3651E-22, -1.3353E-22, &
      -1.3126E-22, -1.2871E-22, -1.2652E-22, -1.2498E-22, -1.2302E-22, -1.2173E-22, &
      -1.2105E-22, -1.2123E-22, -1.2225E-22, -1.2469E-22, -1.2824E-22, -1.3164E-22, &
      -1.3656E-22, -1.4027E-22, -1.4318E-22, -1.4517E-22, -1.4435E-22, -1.4227E-22, &
      -1.3848E-22, -1.3348E-22, -1.2767E-22, -1.2157E-22, -1.1419E-22, -1.0541E-22, &
      -9.5646E-23, -8.3687E-23, -7.1397E-23, -6.0860E-23 /)
    REAL, PARAMETER :: a0_2_2_SO2(dim58) = (/ &
      6.3108E-21, 6.6305E-21, 6.9613E-21, 7.2822E-21, 7.6225E-21, 7.9755E-21, &
      8.2813E-21, 8.6038E-21, 8.8970E-21, 9.2153E-21, 9.4956E-21, 9.8125E-21, &
      1.1304E-20, 1.4802E-20, 1.3557E-20, 1.3377E-20, 1.4174E-20, 1.2922E-20, &
      1.2716E-20, 1.3136E-20, 1.1982E-20, 1.1623E-20, 1.1753E-20, 1.0693E-20, &
      1.0259E-20, 8.9150E-21, 8.2446E-21, 8.0619E-21, 7.9154E-21, 7.7672E-21, &
      7.6536E-21, 7.5255E-21, 7.4154E-21, 7.3372E-21, 7.2376E-21, 7.1721E-21, &
      7.1370E-21, 7.1465E-21, 7.1988E-21, 7.3252E-21, 7.5100E-21, 7.6874E-21, &
      7.9454E-21, 8.1406E-21, 8.2939E-21, 8.3995E-21, 8.3562E-21, 8.2450E-21, &
      8.0417E-21, 7.7729E-21, 7.4591E-21, 7.1284E-21, 6.7268E-21, 6.2474E-21, &
      5.7125E-21, 5.0547E-21, 4.3763E-21, 3.7926E-21 /)
    REAL, PARAMETER :: a1_1_SO2(dim55) = (/ &
      9.5139E-20, 9.5277E-20, 9.8708E-20, 9.4366E-20, 9.3757E-20, 8.7438E-20, &
      8.4765E-20, 7.8380E-20, 7.5024E-20, 6.9488E-20, 6.6107E-20, 6.1586E-20, &
      5.8425E-20, 5.4834E-20, 5.1903E-20, 4.9109E-20, 4.6410E-20, 4.4250E-20, &
      4.1732E-20, 4.0086E-20, 3.7727E-20, 3.6496E-20, 3.4284E-20, 3.3385E-20, &
      3.1308E-20, 3.0675E-20, 2.8694E-20, 2.8309E-20, 2.6435E-20, 2.6216E-20, &
      2.4439E-20, 2.4375E-20, 2.2685E-20, 2.2742E-20, 2.1131E-20, 2.1296E-20, &
      1.9742E-20, 1.9987E-20, 1.8510E-20, 1.8822E-20, 1.6781E-20, 1.4843E-20, &
      1.2975E-20, 1.1766E-20, 1.0447E-20, 9.6414E-21, 8.6303E-21, 8.0739E-21, &
      6.9239E-21, 6.3599E-21, 5.8551E-21, 5.3934E-21, 4.9770E-21, 4.5987E-21, &
      4.2497E-21 /)
    REAL, PARAMETER :: b1_1_SO2(dim55) = (/ &
      1.1327E-18, 1.1323E-18, 1.1134E-18, 1.1482E-18, 1.1546E-18, 1.2367E-18, &
      1.2781E-18, 1.3931E-18, 1.4619E-18, 1.5892E-18, 1.6754E-18, 1.8020E-18, &
      1.8984E-18, 2.0169E-18, 2.1209E-18, 2.2271E-18, 2.3364E-18, 2.4293E-18, &
      2.5439E-18, 2.6229E-18, 2.7420E-18, 2.8072E-18, 2.9300E-18, 2.9822E-18, &
      3.1078E-18, 3.1477E-18, 3.2775E-18, 3.3037E-18, 3.4358E-18, 3.4517E-18, &
      3.5859E-18, 3.5909E-18, 3.7270E-18, 3.7223E-18, 3.8599E-18, 3.8454E-18, &
      3.9860E-18, 3.9633E-18, 4.1044E-18, 4.0737E-18, 4.2789E-18, 4.4979E-18, &
      4.7323E-18, 4.8992E-18, 5.0976E-18, 5.2290E-18, 5.4064E-18, 5.5110E-18, &
      5.7416E-18, 5.8618E-18, 5.9756E-18, 6.0855E-18, 6.1898E-18, 6.2893E-18, &
      6.3854E-18 /)
    REAL, PARAMETER :: a1_2_SO2(dim55) = (/ &
      -3.5197E-22, -2.2966E-22, -2.4643E-22, -1.2587E-22, -1.3118E-22, -3.7579E-23, &
      -4.1475E-23, 2.0348E-23, 1.5827E-23, 5.1963E-23, 4.8000E-23, 6.6841E-23, &
      6.4201E-23, 7.1956E-23, 7.1663E-23, 7.2093E-23, 7.3811E-23, 6.9756E-23, &
      7.3205E-23, 6.6154E-23, 7.1040E-23, 6.2059E-23, 6.8066E-23, 5.7920E-23, &
      6.4469E-23, 5.3751E-23, 6.0954E-23, 4.9690E-23, 5.7185E-23, 4.6043E-23, &
      5.3583E-23, 4.2487E-23, 5.0131E-23, 3.9283E-23, 4.6861E-23, 3.6240E-23, &
      4.3825E-23, 3.3593E-23, 4.0994E-23, 3.1093E-23, 3.2738E-23, 2.6287E-23, &
      2.3877E-23, 1.9466E-23, 1.8219E-23, 1.5049E-23, 1.4514E-23, 1.2087E-23, &
      1.3858E-23, 1.2736E-23, 1.1780E-23, 1.0969E-23, 1.0255E-23, 9.6193E-24, &
      9.0605E-24 /)
    REAL, PARAMETER :: b1_2_SO2(dim55) = (/ &
      -6.3416E-21, -6.7085E-21, -6.6162E-21, -7.5807E-21, -7.5250E-21, -8.7418E-21, &
      -8.6814E-21, -9.7942E-21, -9.7015E-21, -1.0533E-20, -1.0432E-20, -1.0959E-20, &
      -1.0879E-20, -1.1135E-20, -1.1124E-20, -1.1140E-20, -1.1210E-20, -1.1036E-20, &
      -1.1193E-20, -1.0854E-20, -1.1101E-20, -1.0625E-20, -1.0958E-20, -1.0370E-20, &
      -1.0766E-20, -1.0091E-20, -1.0563E-20, -9.7967E-21, -1.0325E-20, -9.5117E-21, &
      -1.0081E-20, -9.2154E-21, -9.8308E-21, -8.9304E-21, -9.5783E-21, -8.6437E-21, &
      -9.3301E-21, -8.3786E-21, -9.0854E-21, -8.1151E-21, -8.2804E-21, -7.5514E-21, &
      -7.2489E-21, -6.6402E-21, -6.4525E-21, -5.9359E-21, -5.8420E-21, -5.3857E-21, &
      -5.7409E-21, -5.5017E-21, -5.2863E-21, -5.0932E-21, -4.9143E-21, -4.7472E-21, &
      -4.5932E-21 /)

    jval_gp(ip_SO2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_SO2(0) = &
          p1(a0_1_1_SO2(i0(j,k))*dlv2(j,k) + &
          a0_1_2_SO2(i0(j,k)), &
          a0_2_1_SO2(i0(j,k))*dlv2(j,k) + &
          a0_2_2_SO2(i0(j,k)),v3_du1(j,k))
        sig_SO2(1) = &
          (p1(b1_1_SO2(i1(j,k)),a1_1_SO2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_SO2(i1(j,k)),a1_2_SO2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        dj = 0. &
          + sig_SO2(0) * fint(j,k,0) &
          + sig_SO2(1) * fint(j,k,1)

        jval_gp(ip_SO2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_SO2

  ! **************************************************************************

  SUBROUTINE jval_cal_so3(jrow)

    ! SO3 -> products
    ! Burkholder + McKeen GRL 24, 32001-32004 (1997)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_so3 

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_so3(dim58) = (/ &
      -4.8190E-22, -5.4728E-22, -5.8080E-22, -6.4697E-22, -7.0832E-22, -7.6949E-22, &
      -8.3700E-22, -9.0710E-22, -9.9206E-22, -1.0596E-21, -1.1532E-21, -1.2423E-21, &
      -1.3790E-21, -1.6182E-21, -1.6836E-21, -1.7831E-21, -1.9556E-21, -2.0250E-21, &
      -2.1501E-21, -2.3019E-21, -2.3827E-21, -2.5087E-21, -2.6717E-21, -2.7524E-21, &
      -2.8761E-21, -2.9310E-21, -3.0266E-21, -3.1763E-21, -3.3160E-21, -3.4528E-21, &
      -3.5967E-21, -3.7175E-21, -3.8293E-21, -3.9483E-21, -4.0455E-21, -4.1371E-21, &
      -4.2488E-21, -4.3520E-21, -4.4815E-21, -4.6106E-21, -4.7769E-21, -4.9491E-21, &
      -5.1129E-21, -5.2749E-21, -5.4035E-21, -5.4820E-21, -5.4978E-21, -5.4664E-21, &
      -5.3632E-21, -5.2066E-21, -5.0300E-21, -4.8042E-21, -4.5592E-21, -4.2853E-21, &
      -3.9569E-21, -3.5768E-21, -3.0886E-21, -2.5839E-21 /)
    REAL, PARAMETER :: a0_1_2_so3(dim58) = (/ &
      7.9225E-19, 7.9514E-19, 7.9663E-19, 7.9958E-19, 8.0233E-19, 8.0508E-19, &
      8.0813E-19, 8.1132E-19, 8.1519E-19, 8.1828E-19, 8.2259E-19, 8.2671E-19, &
      8.3305E-19, 8.4419E-19, 8.4726E-19, 8.5193E-19, 8.6008E-19, 8.6337E-19, &
      8.6932E-19, 8.7657E-19, 8.8045E-19, 8.8653E-19, 8.9441E-19, 8.9834E-19, &
      9.0437E-19, 9.0706E-19, 9.1177E-19, 9.1916E-19, 9.2609E-19, 9.3291E-19, &
      9.4010E-19, 9.4616E-19, 9.5180E-19, 9.5782E-19, 9.6276E-19, 9.6743E-19, &
      9.7315E-19, 9.7845E-19, 9.8514E-19, 9.9182E-19, 1.0005E-18, 1.0095E-18, &
      1.0180E-18, 1.0266E-18, 1.0334E-18, 1.0375E-18, 1.0384E-18, 1.0367E-18, &
      1.0311E-18, 1.0227E-18, 1.0132E-18, 1.0009E-18, 9.8762E-19, 9.7266E-19, &
      9.5467E-19, 9.3376E-19, 9.0681E-19, 8.7885E-19 /)
    REAL, PARAMETER :: a0_2_1_so3(dim58) = (/ &
      1.4465E-24, 1.7111E-24, 1.6647E-24, 1.9134E-24, 2.0665E-24, 2.1566E-24, &
      2.3775E-24, 2.4612E-24, 2.6776E-24, 2.7650E-24, 2.9997E-24, 3.1231E-24, &
      3.8937E-24, 5.9781E-24, 5.4545E-24, 5.4330E-24, 6.1901E-24, 5.6774E-24, &
      5.7645E-24, 6.2618E-24, 5.8448E-24, 5.8712E-24, 6.3761E-24, 5.9400E-24, &
      5.9584E-24, 5.2115E-24, 4.9219E-24, 5.0927E-24, 5.2248E-24, 5.3652E-24, &
      5.4877E-24, 5.5843E-24, 5.6600E-24, 5.7715E-24, 5.8079E-24, 5.8197E-24, &
      5.8820E-24, 5.9251E-24, 6.0245E-24, 6.0393E-24, 6.1893E-24, 6.3036E-24, &
      6.3802E-24, 6.4377E-24, 6.4589E-24, 6.3195E-24, 6.0850E-24, 5.8395E-24, &
      5.5064E-24, 5.0645E-24, 4.7347E-24, 4.2801E-24, 3.8901E-24, 3.4849E-24, &
      3.0031E-24, 2.5310E-24, 2.0843E-24, 1.6954E-24 /)
    REAL, PARAMETER :: a0_2_2_so3(dim58) = (/ &
      -1.2545E-22, -1.3715E-22, -1.3509E-22, -1.4618E-22, -1.5304E-22, -1.5709E-22, &
      -1.6708E-22, -1.7087E-22, -1.8074E-22, -1.8475E-22, -1.9554E-22, -2.0124E-22, &
      -2.3700E-22, -3.3413E-22, -3.0963E-22, -3.0862E-22, -3.4435E-22, -3.2005E-22, &
      -3.2420E-22, -3.4797E-22, -3.2795E-22, -3.2923E-22, -3.5366E-22, -3.3247E-22, &
      -3.3337E-22, -2.9677E-22, -2.8252E-22, -2.9095E-22, -2.9751E-22, -3.0450E-22, &
      -3.1063E-22, -3.1547E-22, -3.1929E-22, -3.2493E-22, -3.2678E-22, -3.2739E-22, &
      -3.3057E-22, -3.3279E-22, -3.3792E-22, -3.3868E-22, -3.4648E-22, -3.5245E-22, &
      -3.5647E-22, -3.5949E-22, -3.6061E-22, -3.5322E-22, -3.4074E-22, -3.2764E-22, &
      -3.0978E-22, -2.8600E-22, -2.6820E-22, -2.4356E-22, -2.2234E-22, -2.0022E-22, &
      -1.7381E-22, -1.4785E-22, -1.2319E-22, -1.0165E-22 /)
    REAL, PARAMETER :: a1_1_so3(dim55) = (/ &
      7.9109E-21, 7.6690E-21, 7.5766E-21, 7.0476E-21, 6.7093E-21, 6.1160E-21, &
      5.7065E-21, 5.1915E-21, 4.8107E-21, 4.4047E-21, 4.0795E-21, 3.7769E-21, &
      3.5036E-21, 3.2809E-21, 3.0506E-21, 2.8865E-21, 2.6894E-21, 2.5665E-21, &
      2.3959E-21, 2.3045E-21, 2.1542E-21, 2.0861E-21, 1.9500E-21, 1.9012E-21, &
      1.7789E-21, 1.7436E-21, 1.6308E-21, 1.6083E-21, 1.5032E-21, 1.4910E-21, &
      1.3933E-21, 1.3867E-21, 1.2967E-21, 1.2979E-21, 1.2101E-21, 1.2172E-21, &
      1.1356E-21, 1.1464E-21, 1.0693E-21, 1.0823E-21, 9.7369E-22, 8.6855E-22, &
      7.6869E-22, 7.0294E-22, 6.3278E-22, 5.8847E-22, 5.3434E-22, 5.0342E-22, &
      4.4100E-22, 4.0893E-22, 3.7983E-22, 3.5347E-22, 3.2908E-22, 3.0692E-22, &
      2.8663E-22 /)
    REAL, PARAMETER :: b1_1_so3(dim55) = (/ &
      1.6554E-19, 1.6627E-19, 1.6678E-19, 1.7101E-19, 1.7456E-19, 1.8228E-19, &
      1.8862E-19, 1.9789E-19, 2.0570E-19, 2.1504E-19, 2.2333E-19, 2.3180E-19, &
      2.4014E-19, 2.4749E-19, 2.5566E-19, 2.6190E-19, 2.6988E-19, 2.7516E-19, &
      2.8293E-19, 2.8732E-19, 2.9490E-19, 2.9851E-19, 3.0607E-19, 3.0890E-19, &
      3.1630E-19, 3.1852E-19, 3.2591E-19, 3.2744E-19, 3.3485E-19, 3.3574E-19, &
      3.4311E-19, 3.4363E-19, 3.5087E-19, 3.5078E-19, 3.5829E-19, 3.5766E-19, &
      3.6505E-19, 3.6404E-19, 3.7140E-19, 3.7013E-19, 3.8104E-19, 3.9292E-19, &
      4.0546E-19, 4.1453E-19, 4.2509E-19, 4.3231E-19, 4.4181E-19, 4.4762E-19, &
      4.6014E-19, 4.6697E-19, 4.7353E-19, 4.7981E-19, 4.8592E-19, 4.9174E-19, &
      4.9733E-19 /)
    REAL, PARAMETER :: a1_2_so3(dim55) = (/ &
      -1.9610E-23, -1.0460E-23, -9.7563E-24, -2.1523E-24, -1.4307E-24, 3.4495E-24, &
      3.7495E-24, 6.1243E-24, 6.0634E-24, 6.9008E-24, 6.7498E-24, 6.7127E-24, &
      6.6284E-24, 6.1786E-24, 6.1962E-24, 5.5549E-24, 5.6904E-24, 4.9631E-24, &
      5.1928E-24, 4.4410E-24, 4.7232E-24, 3.9843E-24, 4.3059E-24, 3.5839E-24, &
      3.9337E-24, 3.2308E-24, 3.5998E-24, 2.9324E-24, 3.3040E-24, 2.6516E-24, &
      3.0347E-24, 2.4250E-24, 2.7968E-24, 2.1993E-24, 2.5938E-24, 2.0207E-24, &
      2.3904E-24, 1.8500E-24, 2.2119E-24, 1.7108E-24, 1.7608E-24, 1.4040E-24, &
      1.2634E-24, 1.0295E-24, 9.5921E-25, 7.9506E-25, 7.6636E-25, 6.4212E-25, &
      7.3992E-25, 6.8855E-25, 6.4494E-25, 6.0745E-25, 5.7530E-25, 5.4586E-25, &
      5.1911E-25 /)
    REAL, PARAMETER :: b1_2_so3(dim55) = (/ &
      -5.2930E-22, -5.5675E-22, -5.6062E-22, -6.2145E-22, -6.2903E-22, -6.9247E-22, &
      -6.9712E-22, -7.3986E-22, -7.3862E-22, -7.5788E-22, -7.5403E-22, -7.5299E-22, &
      -7.5042E-22, -7.3557E-22, -7.3620E-22, -7.1183E-22, -7.1732E-22, -6.8604E-22, &
      -6.9649E-22, -6.6041E-22, -6.7466E-22, -6.3550E-22, -6.5334E-22, -6.1147E-22, &
      -6.3263E-22, -5.8835E-22, -6.1252E-22, -5.6713E-22, -5.9333E-22, -5.4571E-22, &
      -5.7463E-22, -5.2707E-22, -5.5700E-22, -5.0742E-22, -5.4114E-22, -4.9071E-22, &
      -5.2417E-22, -4.7391E-22, -5.0848E-22, -4.5937E-22, -4.6439E-22, -4.2407E-22, &
      -4.0642E-22, -3.7415E-22, -3.6357E-22, -3.3681E-22, -3.3177E-22, -3.0842E-22, &
      -3.2803E-22, -3.1708E-22, -3.0725E-22, -2.9833E-22, -2.9027E-22, -2.8253E-22, &
      -2.7516E-22 /)
    REAL, PARAMETER :: a2_so3(dim55) = (/ &
      -3.4636E-22, -2.9700E-22, -2.3816E-22, -1.8084E-22, -1.3204E-22, -9.4000E-23, &
      -6.6080E-23, -4.6400E-23, -3.2840E-23, -2.3560E-23, -1.7280E-23, -1.2920E-23, &
      -9.9200E-24, -7.8400E-24, -6.2800E-24, -5.2400E-24, -4.3600E-24, -3.7600E-24, &
      -3.2400E-24, -2.8800E-24, -2.5200E-24, -2.2800E-24, -2.0800E-24, -1.8400E-24, &
      -1.6800E-24, -1.5600E-24, -1.4400E-24, -1.3200E-24, -1.2000E-24, -1.1200E-24, &
      -1.0400E-24, -9.5998E-25, -8.8001E-25, -8.3998E-25, -8.0000E-25, -7.2003E-25, &
      -6.7996E-25, -6.4001E-25, -5.6000E-25, -5.6000E-25, -4.5600E-25, -3.2000E-25, &
      -2.4000E-25, -1.6800E-25, -1.2000E-25, -8.8001E-26, -6.4001E-26, -4.7999E-26, &
      -3.2005E-26, -2.4000E-26, -1.5994E-26, -1.6002E-26, -7.9972E-27, -8.0052E-27, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b2_so3(dim55) = (/ &
      5.1928E-21, 5.0447E-21, 4.7211E-21, 4.2625E-21, 3.7501E-21, 3.2556E-21, &
      2.8228E-21, 2.4686E-21, 2.1906E-21, 1.9772E-21, 1.8170E-21, 1.6950E-21, &
      1.6035E-21, 1.5348E-21, 1.4794E-21, 1.4399E-21, 1.4043E-21, 1.3785E-21, &
      1.3548E-21, 1.3375E-21, 1.3194E-21, 1.3066E-21, 1.2955E-21, 1.2816E-21, &
      1.2719E-21, 1.2644E-21, 1.2565E-21, 1.2484E-21, 1.2399E-21, 1.2341E-21, &
      1.2280E-21, 1.2218E-21, 1.2153E-21, 1.2120E-21, 1.2086E-21, 1.2016E-21, &
      1.1979E-21, 1.1942E-21, 1.1866E-21, 1.1866E-21, 1.1761E-21, 1.1608E-21, &
      1.1507E-21, 1.1408E-21, 1.1336E-21, 1.1283E-21, 1.1241E-21, 1.1211E-21, &
      1.1179E-21, 1.1162E-21, 1.1144E-21, 1.1144E-21, 1.1124E-21, 1.1124E-21, &
      1.1102E-21 /)
    REAL, PARAMETER :: a3_so3(dim55) = (/ &
      -1.6056E-24, -1.3516E-24, -1.0776E-24, -8.3317E-25, -6.3778E-25, -4.9081E-25, &
      -3.8434E-25, -3.0711E-25, -2.5120E-25, -2.1006E-25, -1.7899E-25, -1.5455E-25, &
      -1.3538E-25, -1.1981E-25, -1.0707E-25, -9.6645E-26, -8.7061E-26, -7.9473E-26, &
      -7.3113E-26, -6.6693E-26, -6.1901E-26, -5.7108E-26, -5.3137E-26, -4.9521E-26, &
      -4.6326E-26, -4.3530E-26, -4.0351E-26, -3.8339E-26, -3.5943E-26, -3.3946E-26, &
      -3.1961E-26, -3.0352E-26, -2.8754E-26, -2.7555E-26, -2.5970E-26, -2.4760E-26, &
      -2.3563E-26, -2.2363E-26, -2.1175E-26, -2.0766E-26, -1.8051E-26, -1.4776E-26, &
      -1.2380E-26, -1.0463E-26, -8.9529E-27, -7.7477E-27, -6.6295E-27, -5.8306E-27, &
      -5.1118E-27, -4.4729E-27, -3.9138E-27, -3.4345E-27, -3.0375E-27, -2.6358E-27, &
      -2.3163E-27 /)
    REAL, PARAMETER :: b3_so3(dim55) = (/ &
      5.2629E-22, 5.1981E-22, 5.0595E-22, 4.8747E-22, 4.6780E-22, 4.4933E-22, &
      4.3328E-22, 4.1971E-22, 4.0848E-22, 3.9919E-22, 3.9139E-22, 3.8465E-22, &
      3.7888E-22, 3.7381E-22, 3.6934E-22, 3.6541E-22, 3.6157E-22, 3.5834E-22, &
      3.5547E-22, 3.5241E-22, 3.5001E-22, 3.4749E-22, 3.4530E-22, 3.4321E-22, &
      3.4129E-22, 3.3954E-22, 3.3747E-22, 3.3611E-22, 3.3443E-22, 3.3297E-22, &
      3.3148E-22, 3.3023E-22, 3.2895E-22, 3.2796E-22, 3.2661E-22, 3.2555E-22, &
      3.2447E-22, 3.2336E-22, 3.2223E-22, 3.2183E-22, 3.1911E-22, 3.1542E-22, &
      3.1241E-22, 3.0977E-22, 3.0750E-22, 3.0554E-22, 3.0358E-22, 3.0208E-22, &
      3.0064E-22, 2.9928E-22, 2.9802E-22, 2.9688E-22, 2.9589E-22, 2.9483E-22, &
      2.9395E-22 /)
    REAL, PARAMETER :: a4_so3(2) = (/ 1.9176E-22, -1.2195E-26 /)
    REAL, PARAMETER :: a5_so3(2) = (/ 4.9262E-23, -7.1347E-27 /)

    jval_gp(ip_so3)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_SO3(0) = &
          p1(a0_1_1_SO3(i0(j,k))*dlv2(j,k) + a0_1_2_SO3(i0(j,k)), &
          a0_2_1_SO3(i0(j,k))*dlv2(j,k) + a0_2_2_SO3(i0(j,k)), v3_du1(j,k))
        sig_SO3(1) = &
          p1(b1_1_SO3(i1(j,k)),a1_1_SO3(i1(j,k)),v3_du1(j,k)) + &
          p1(b1_2_SO3(i1(j,k)),a1_2_SO3(i1(j,k)),v3_du1(j,k)) * v2s_m(j,k)
        sig_SO3(2) = p1(b2_SO3(i2(j,k)), a2_SO3(i2(j,k)),v3_du1(j,k))
        sig_SO3(3) = p1(b3_SO3(i3(j,k)), a3_SO3(i3(j,k)),v3_du2(j,k))
        sig_SO3(4) = p1(a4_SO3(1),a4_SO3(2),v3_du2(j,k))
        sig_SO3(5) = p1(a5_SO3(1),a5_SO3(2),v3_du2(j,k))
        dj = &
          sig_SO3(0) * fint(j,k,0) + &
          sig_SO3(1) * fint(j,k,1) + &
          sig_SO3(2) * fint(j,k,2) + &
          sig_SO3(3) * fint(j,k,3) + &
          sig_SO3(4) * fint(j,k,4) + &
          sig_SO3(5) * fint(j,k,5)
        jval_gp(ip_so3)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,1))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_so3

  ! **************************************************************************

  SUBROUTINE jval_cal_ocs(jrow)

    ! OCS -> products
    ! JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_ocs 

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_ocs(dim58) = (/ &
      -1.0693E-21, -1.1507E-21, -1.2322E-21, -1.3144E-21, -1.3971E-21, -1.4773E-21, &
      -1.5561E-21, -1.6319E-21, -1.7052E-21, -1.7775E-21, -1.8461E-21, -1.9133E-21, &
      -2.0693E-21, -2.3889E-21, -2.3234E-21, -2.3445E-21, -2.4285E-21, -2.3417E-21, &
      -2.3199E-21, -2.3416E-21, -2.2161E-21, -2.1370E-21, -2.0816E-21, -1.9127E-21, &
      -1.7757E-21, -1.5641E-21, -1.3917E-21, -1.2356E-21, -1.0692E-21, -8.9377E-22, &
      -7.0885E-22, -5.2147E-22, -3.3424E-22, -1.5118E-22, 2.5598E-23, 1.9052E-22, &
      3.4407E-22, 4.8425E-22, 6.1348E-22, 7.3054E-22, 8.3866E-22, 9.3876E-22, &
      1.0291E-21, 1.1097E-21, 1.1761E-21, 1.2253E-21, 1.2510E-21, 1.2542E-21, &
      1.2382E-21, 1.2033E-21, 1.1564E-21, 1.1007E-21, 1.0364E-21, 9.6424E-22, &
      8.8350E-22, 7.9071E-22, 6.7555E-22, 5.6336E-22 /)
    REAL, PARAMETER :: a0_1_2_ocs(dim58) = (/ &
      8.0963E-20, 8.4561E-20, 8.8179E-20, 9.1847E-20, 9.5552E-20, 9.9158E-20, &
      1.0272E-19, 1.0616E-19, 1.0951E-19, 1.1281E-19, 1.1597E-19, 1.1908E-19, &
      1.2631E-19, 1.4121E-19, 1.3814E-19, 1.3914E-19, 1.4310E-19, 1.3898E-19, &
      1.3795E-19, 1.3899E-19, 1.3296E-19, 1.2915E-19, 1.2647E-19, 1.1826E-19, &
      1.1157E-19, 1.0121E-19, 9.2720E-20, 8.5009E-20, 7.6760E-20, 6.8021E-20, &
      5.8775E-20, 4.9368E-20, 3.9932E-20, 3.0669E-20, 2.1689E-20, 1.3278E-20, &
      5.4165E-21, -1.7892E-21, -8.4574E-21, -1.4521E-20, -2.0143E-20, -2.5368E-20, &
      -3.0101E-20, -3.4342E-20, -3.7848E-20, -4.0455E-20, -4.1822E-20, -4.1991E-20, &
      -4.1136E-20, -3.9258E-20, -3.6725E-20, -3.3708E-20, -3.0211E-20, -2.6269E-20, &
      -2.1844E-20, -1.6741E-20, -1.0384E-20, -4.1686E-21 /)
    REAL, PARAMETER :: a0_2_1_ocs(dim58) = (/ &
      4.5119E-24, 4.8614E-24, 5.2157E-24, 5.5794E-24, 5.9484E-24, 6.3092E-24, &
      6.6742E-24, 7.0275E-24, 7.3764E-24, 7.7266E-24, 8.0698E-24, 8.4098E-24, &
      1.0136E-23, 1.4191E-23, 1.2621E-23, 1.2412E-23, 1.3135E-23, 1.1754E-23, &
      1.1396E-23, 1.1696E-23, 1.0430E-23, 9.9003E-24, 9.7871E-24, 8.6160E-24, &
      7.9527E-24, 6.6878E-24, 5.9405E-24, 5.4715E-24, 4.9736E-24, 4.4485E-24, &
      3.8902E-24, 3.3223E-24, 2.7572E-24, 2.2019E-24, 1.6639E-24, 1.1693E-24, &
      7.1927E-25, 3.1752E-25, -3.7595E-26, -3.4057E-25, -6.0137E-25, -8.2747E-25, &
      -1.0102E-24, -1.1664E-24, -1.2778E-24, -1.3569E-24, -1.3806E-24, -1.3587E-24, &
      -1.3122E-24, -1.2360E-24, -1.1386E-24, -1.0417E-24, -9.3499E-25, -8.1858E-25, &
      -7.0187E-25, -5.8557E-25, -4.6750E-25, -3.8439E-25 /)
    REAL, PARAMETER :: a0_2_2_ocs(dim58) = (/ &
      -2.4640E-22, -2.6185E-22, -2.7758E-22, -2.9380E-22, -3.1033E-22, -3.2656E-22, &
      -3.4307E-22, -3.5910E-22, -3.7501E-22, -3.9105E-22, -4.0684E-22, -4.2255E-22, &
      -5.0267E-22, -6.9161E-22, -6.1811E-22, -6.0833E-22, -6.4242E-22, -5.7698E-22, &
      -5.5995E-22, -5.7428E-22, -5.1350E-22, -4.8797E-22, -4.8249E-22, -4.2558E-22, &
      -3.9321E-22, -3.3123E-22, -2.9446E-22, -2.7129E-22, -2.4660E-22, -2.2045E-22, &
      -1.9253E-22, -1.6403E-22, -1.3554E-22, -1.0745E-22, -8.0116E-23, -5.4890E-23, &
      -3.1849E-23, -1.1199E-23, 7.1249E-24, 2.2819E-23, 3.6381E-23, 4.8183E-23, &
      5.7759E-23, 6.5976E-23, 7.1858E-23, 7.6047E-23, 7.7311E-23, 7.6140E-23, &
      7.3648E-23, 6.9546E-23, 6.4287E-23, 5.9038E-23, 5.3231E-23, 4.6875E-23, &
      4.0480E-23, 3.4083E-23, 2.7566E-23, 2.2962E-23 /)
    REAL, PARAMETER :: a1_1_ocs(dim55) = (/ &
      1.6728E-21, 1.2217E-21, 6.4977E-22, 2.9421E-22, -1.6332E-22, -3.6104E-22, &
      -6.6433E-22, -7.3309E-22, -9.0996E-22, -9.0220E-22, -9.9274E-22, -9.5260E-22, &
      -9.8840E-22, -9.3742E-22, -9.4377E-22, -8.9296E-22, -8.8138E-22, -8.3765E-22, &
      -8.1642E-22, -7.7789E-22, -7.5261E-22, -7.2255E-22, -6.9396E-22, -6.6971E-22, &
      -6.3855E-22, -6.2306E-22, -5.9033E-22, -5.7838E-22, -5.4719E-22, -5.3946E-22, &
      -5.0807E-22, -5.0324E-22, -4.7385E-22, -4.7260E-22, -4.4207E-22, -4.4368E-22, &
      -4.1509E-22, -4.1862E-22, -3.8955E-22, -3.9533E-22, -3.5407E-22, -3.1480E-22, &
      -2.7646E-22, -2.5163E-22, -2.2444E-22, -2.0778E-22, -1.8691E-22, -1.7535E-22, &
      -1.5095E-22, -1.3901E-22, -1.2836E-22, -1.1867E-22, -1.0991E-22, -1.0196E-22, &
      -9.4713E-23 /)
    REAL, PARAMETER :: b1_1_ocs(dim55) = (/ &
      1.5434E-19, 1.5569E-19, 1.5884E-19, 1.6168E-19, 1.6648E-19, 1.6906E-19, &
      1.7376E-19, 1.7499E-19, 1.7862E-19, 1.7844E-19, 1.8075E-19, 1.7963E-19, &
      1.8072E-19, 1.7904E-19, 1.7926E-19, 1.7733E-19, 1.7686E-19, 1.7498E-19, &
      1.7402E-19, 1.7217E-19, 1.7089E-19, 1.6930E-19, 1.6771E-19, 1.6630E-19, &
      1.6442E-19, 1.6344E-19, 1.6130E-19, 1.6048E-19, 1.5829E-19, 1.5772E-19, &
      1.5535E-19, 1.5498E-19, 1.5261E-19, 1.5251E-19, 1.4990E-19, 1.5004E-19, &
      1.4745E-19, 1.4778E-19, 1.4500E-19, 1.4557E-19, 1.4142E-19, 1.3698E-19, &
      1.3217E-19, 1.2875E-19, 1.2465E-19, 1.2194E-19, 1.1828E-19, 1.1610E-19, &
      1.1121E-19, 1.0867E-19, 1.0627E-19, 1.0396E-19, 1.0177E-19, 9.9673E-20, &
      9.7677E-20 /)
    REAL, PARAMETER :: a1_2_ocs(dim55) = (/ &
      1.0837E-23, 1.0800E-23, 1.3316E-23, 1.1128E-23, 1.2323E-23, 9.0904E-24, &
      9.4860E-24, 6.3277E-24, 6.4261E-24, 3.8697E-24, 3.8858E-24, 2.0754E-24, &
      2.0635E-24, 8.7119E-25, 8.6278E-25, 1.0557E-25, 8.2339E-26, -3.4255E-25, &
      -3.8735E-25, -6.2591E-25, -6.7044E-25, -7.5082E-25, -8.2897E-25, -8.2063E-25, &
      -9.1223E-25, -8.2993E-25, -9.4582E-25, -8.2293E-25, -9.4652E-25, -7.9088E-25, &
      -9.2868E-25, -7.6210E-25, -8.9112E-25, -7.1842E-25, -8.5719E-25, -6.8089E-25, &
      -8.1714E-25, -6.3118E-25, -7.7774E-25, -5.9603E-25, -6.3581E-25, -5.1875E-25, &
      -4.7811E-25, -3.9305E-25, -3.7093E-25, -3.0785E-25, -2.9809E-25, -2.4934E-25, &
      -2.9019E-25, -2.6863E-25, -2.4982E-25, -2.3376E-25, -2.1942E-25, -2.0653E-25, &
      -1.9476E-25 /)
    REAL, PARAMETER :: b1_2_ocs(dim55) = (/ &
      -1.1680E-22, -1.1669E-22, -1.3053E-22, -1.1302E-22, -1.2557E-22, -8.3550E-23, &
      -8.9681E-23, -3.2832E-23, -3.4850E-23, 2.3949E-23, 2.3537E-23, 7.4228E-23, &
      7.4590E-23, 1.1394E-22, 1.1424E-22, 1.4301E-22, 1.4395E-22, 1.6222E-22, &
      1.6426E-22, 1.7571E-22, 1.7796E-22, 1.8222E-22, 1.8656E-22, 1.8607E-22, &
      1.9162E-22, 1.8643E-22, 1.9402E-22, 1.8567E-22, 1.9438E-22, 1.8302E-22, &
      1.9342E-22, 1.8043E-22, 1.9081E-22, 1.7648E-22, 1.8834E-22, 1.7283E-22, &
      1.8516E-22, 1.6787E-22, 1.8186E-22, 1.6405E-22, 1.6805E-22, 1.5482E-22, &
      1.4972E-22, 1.3799E-22, 1.3466E-22, 1.2437E-22, 1.2266E-22, 1.1350E-22, &
      1.2169E-22, 1.1709E-22, 1.1285E-22, 1.0903E-22, 1.0544E-22, 1.0205E-22, &
      9.8806E-23 /)
    REAL, PARAMETER :: a2_ocs(dim55) = (/ &
      -1.8680E-22, -1.5908E-22, -1.2583E-22, -9.3588E-23, -6.6400E-23, -4.5544E-23, &
      -3.0572E-23, -2.0304E-23, -1.3464E-23, -9.0020E-24, -6.1204E-24, -4.2684E-24, &
      -3.0760E-24, -2.3020E-24, -1.7940E-24, -1.4524E-24, -1.2168E-24, -1.0488E-24, &
      -9.2440E-25, -8.2840E-25, -7.5120E-25, -6.8720E-25, -6.3280E-25, -5.8480E-25, &
      -5.4200E-25, -5.0400E-25, -4.6880E-25, -4.3680E-25, -4.0720E-25, -3.8040E-25, &
      -3.5480E-25, -3.3160E-25, -3.1000E-25, -2.9000E-25, -2.7080E-25, -2.5360E-25, &
      -2.3720E-25, -2.2200E-25, -2.0760E-25, -1.9440E-25, -1.6040E-25, -1.1568E-25, &
      -8.3520E-26, -6.0400E-26, -4.3600E-26, -3.1576E-26, -2.2800E-26, -1.6464E-26, &
      -1.1896E-26, -8.5920E-27, -6.2000E-27, -4.4720E-27, -3.2320E-27, -2.3360E-27, &
      -1.6800E-27 /)
    REAL, PARAMETER :: b2_ocs(dim55) = (/ &
      2.0634E-21, 1.9802E-21, 1.7974E-21, 1.5394E-21, 1.2540E-21, 9.8283E-22, &
      7.5077E-22, 5.6594E-22, 4.2572E-22, 3.2310E-22, 2.4962E-22, 1.9776E-22, &
      1.6139E-22, 1.3585E-22, 1.1781E-22, 1.0483E-22, 9.5292E-23, 8.8068E-23, &
      8.2408E-23, 7.7800E-23, 7.3902E-23, 7.0510E-23, 6.7490E-23, 6.4706E-23, &
      6.2117E-23, 5.9723E-23, 5.7417E-23, 5.5241E-23, 5.3155E-23, 5.1198E-23, &
      4.9265E-23, 4.7456E-23, 4.5717E-23, 4.4057E-23, 4.2415E-23, 4.0902E-23, &
      3.9418E-23, 3.8004E-23, 3.6629E-23, 3.5335E-23, 3.1918E-23, 2.6865E-23, &
      2.2829E-23, 1.9638E-23, 1.7110E-23, 1.5150E-23, 1.3610E-23, 1.2419E-23, &
      1.1503E-23, 1.0799E-23, 1.0260E-23, 9.8482E-24, 9.5376E-24, 9.3020E-24, &
      9.1212E-24 /)

    jval_gp(ip_ocs)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_OCS(0) = p1( &
          a0_1_1_OCS(i0(j,k))*dlv2(j,k) + a0_1_2_OCS(i0(j,k)), &
          a0_2_1_OCS(i0(j,k))*dlv2(j,k) + a0_2_2_OCS(i0(j,k)), &
          v3_du1(j,k))
        sig_OCS(1) = &
          p1(b1_1_OCS(i1(j,k)),a1_1_OCS(i1(j,k)),v3_du1(j,k)) + &
          p1(b1_2_OCS(i1(j,k)),a1_2_OCS(i1(j,k)),v3_du1(j,k)) * v2s_m(j,k)
        sig_OCS(2) = p1(b2_OCS(i2(j,k)), a2_OCS(i2(j,k)),v3_du1(j,k))
        dj = &
          sig_OCS(0) * fint(j,k,0) + &
          sig_OCS(1) * fint(j,k,1) + &
          sig_ocs(2) * fint(j,k,2)
        jval_gp(ip_ocs)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,7))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_ocs

  ! **************************************************************************

  SUBROUTINE jval_cal_cs2(jrow)

    ! CS2 -> products
    ! Xu + Joens, GRL 20, 1035 (1993)
    ! threshold: 280 nm JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_cs2 

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_cs2(dim58) = (/ &
      2.2849E-22, 2.4822E-22, 2.7114E-22, 2.9224E-22, 3.1649E-22, 3.3906E-22, &
      3.6435E-22, 3.8790E-22, 4.1319E-22, 4.3861E-22, 4.6484E-22, 4.8978E-22, &
      5.4158E-22, 6.4103E-22, 6.3939E-22, 6.6272E-22, 7.0711E-22, 7.0335E-22, &
      7.2096E-22, 7.5726E-22, 7.4925E-22, 7.5867E-22, 7.8710E-22, 7.7218E-22, &
      7.7607E-22, 7.4508E-22, 7.3387E-22, 7.3570E-22, 7.3579E-22, 7.3120E-22, &
      7.2229E-22, 7.0813E-22, 6.8830E-22, 6.6443E-22, 6.3622E-22, 6.0492E-22, &
      5.7264E-22, 5.3985E-22, 5.0459E-22, 4.7101E-22, 4.3469E-22, 3.9464E-22, &
      3.5091E-22, 2.9908E-22, 2.4128E-22, 1.7595E-22, 1.0698E-22, 3.8870E-23, &
      -2.5681E-23, -8.1124E-23, -1.2673E-22, -1.6464E-22, -1.9353E-22, -2.1660E-22, &
      -2.3395E-22, -2.4088E-22, -2.2401E-22, -1.8429E-22 /)
    REAL, PARAMETER :: a0_1_2_cs2(dim58) = (/ &
      3.6801E-21, 2.8084E-21, 1.7908E-21, 8.4945E-22, -2.3696E-22, -1.2525E-21, &
      -2.3958E-21, -3.4647E-21, -4.6182E-21, -5.7821E-21, -6.9886E-21, -8.1411E-21, &
      -1.0545E-20, -1.5179E-20, -1.5102E-20, -1.6199E-20, -1.8294E-20, -1.8116E-20, &
      -1.8954E-20, -2.0689E-20, -2.0305E-20, -2.0759E-20, -2.2134E-20, -2.1410E-20, &
      -2.1599E-20, -2.0081E-20, -1.9529E-20, -1.9620E-20, -1.9624E-20, -1.9396E-20, &
      -1.8950E-20, -1.8239E-20, -1.7240E-20, -1.6032E-20, -1.4599E-20, -1.3003E-20, &
      -1.1350E-20, -9.6647E-21, -7.8451E-21, -6.1057E-21, -4.2169E-21, -2.1263E-21, &
      1.6528E-22, 2.8912E-21, 5.9431E-21, 9.4056E-21, 1.3075E-20, 1.6712E-20, &
      2.0172E-20, 2.3155E-20, 2.5617E-20, 2.7672E-20, 2.9244E-20, 3.0503E-20, &
      3.1454E-20, 3.1835E-20, 3.0904E-20, 2.8704E-20 /)
    REAL, PARAMETER :: a0_2_1_cs2(dim58) = (/ &
      -8.4774E-25, -9.1077E-25, -9.9566E-25, -1.0631E-24, -1.1541E-24, -1.2219E-24, &
      -1.3136E-24, -1.3883E-24, -1.4761E-24, -1.5589E-24, -1.6525E-24, -1.7278E-24, &
      -2.1916E-24, -3.3197E-24, -2.9613E-24, -2.9707E-24, -3.2691E-24, -2.9492E-24, &
      -2.9353E-24, -3.1597E-24, -2.8682E-24, -2.8239E-24, -2.9871E-24, -2.7095E-24, &
      -2.6539E-24, -2.2641E-24, -2.1001E-24, -2.0924E-24, -2.0857E-24, -2.0667E-24, &
      -2.0378E-24, -2.0011E-24, -1.9457E-24, -1.8875E-24, -1.8204E-24, -1.7470E-24, &
      -1.6762E-24, -1.6093E-24, -1.5373E-24, -1.4775E-24, -1.4134E-24, -1.3380E-24, &
      -1.2662E-24, -1.1676E-24, -1.0611E-24, -9.3303E-25, -7.9162E-25, -6.5241E-25, &
      -5.1386E-25, -3.9422E-25, -2.8804E-25, -1.9455E-25, -1.2000E-25, -5.9979E-26, &
      -1.2827E-26, 2.0827E-26, 3.4986E-26, 4.8164E-26 /)
    REAL, PARAMETER :: a0_2_2_cs2(dim58) = (/ &
      5.4660E-23, 5.7446E-23, 6.1216E-23, 6.4225E-23, 6.8301E-23, 7.1351E-23, &
      7.5494E-23, 7.8887E-23, 8.2893E-23, 8.6683E-23, 9.0987E-23, 9.4469E-23, &
      1.1599E-22, 1.6856E-22, 1.5178E-22, 1.5222E-22, 1.6631E-22, 1.5115E-22, &
      1.5049E-22, 1.6121E-22, 1.4722E-22, 1.4508E-22, 1.5298E-22, 1.3949E-22, &
      1.3678E-22, 1.1768E-22, 1.0961E-22, 1.0923E-22, 1.0890E-22, 1.0795E-22, &
      1.0650E-22, 1.0466E-22, 1.0187E-22, 9.8927E-23, 9.5517E-23, 9.1773E-23, &
      8.8151E-23, 8.4710E-23, 8.0994E-23, 7.7898E-23, 7.4566E-23, 7.0628E-23, &
      6.6866E-23, 6.1681E-23, 5.6058E-23, 4.9269E-23, 4.1747E-23, 3.4312E-23, &
      2.6886E-23, 2.0450E-23, 1.4716E-23, 9.6488E-24, 5.5933E-24, 2.3163E-24, &
      -2.6767E-25, -2.1186E-24, -2.9003E-24, -3.6303E-24 /)
    REAL, PARAMETER :: a1_1_cs2(dim55) = (/ &
      1.3323E-23, 1.3622E-23, 1.5096E-23, 1.4723E-23, 1.5789E-23, 1.4969E-23, &
      1.5806E-23, 1.4771E-23, 1.5503E-23, 1.4428E-23, 1.5135E-23, 1.4050E-23, &
      1.4775E-23, 1.3712E-23, 1.4415E-23, 1.3409E-23, 1.4144E-23, 1.3136E-23, &
      1.3875E-23, 1.2901E-23, 1.3652E-23, 1.2679E-23, 1.3444E-23, 1.2461E-23, &
      1.3254E-23, 1.2305E-23, 1.3056E-23, 1.2131E-23, 1.2899E-23, 1.1977E-23, &
      1.2754E-23, 1.1840E-23, 1.2584E-23, 1.1714E-23, 1.2447E-23, 1.1581E-23, &
      1.2316E-23, 1.1469E-23, 1.2195E-23, 1.1345E-23, 1.1650E-23, 1.1232E-23, &
      1.1125E-23, 1.0743E-23, 1.0634E-23, 1.0274E-23, 1.0145E-23, 9.8051E-24, &
      9.7984E-24, 9.4666E-24, 9.1423E-24, 8.8189E-24, 8.5020E-24, 8.1942E-24, &
      7.8931E-24 /)
    REAL, PARAMETER :: b1_1_cs2(dim55) = (/ &
      8.3425E-22, 8.3336E-22, 8.2525E-22, 8.2823E-22, 8.1704E-22, 8.2770E-22, &
      8.1473E-22, 8.3336E-22, 8.1836E-22, 8.4308E-22, 8.2506E-22, 8.5544E-22, &
      8.3331E-22, 8.6841E-22, 8.4345E-22, 8.8166E-22, 8.5189E-22, 8.9525E-22, &
      8.6161E-22, 9.0838E-22, 8.7047E-22, 9.2201E-22, 8.7955E-22, 9.3657E-22, &
      8.8857E-22, 9.4840E-22, 8.9920E-22, 9.6210E-22, 9.0795E-22, 9.7524E-22, &
      9.1658E-22, 9.8788E-22, 9.2801E-22, 1.0002E-21, 9.3750E-22, 1.0137E-21, &
      9.4721E-22, 1.0260E-21, 9.5661E-22, 1.0400E-21, 1.0093E-21, 1.0565E-21, &
      1.0699E-21, 1.1226E-21, 1.1391E-21, 1.1978E-21, 1.2204E-21, 1.2843E-21, &
      1.2856E-21, 1.3563E-21, 1.4294E-21, 1.5064E-21, 1.5858E-21, 1.6667E-21, &
      1.7497E-21 /)
    REAL, PARAMETER :: a1_2_cs2(dim55) = (/ &
      -7.2580E-26, -5.2623E-26, -6.7546E-26, -4.3576E-26, -5.7471E-26, -3.3320E-26, &
      -4.7246E-26, -2.4776E-26, -3.8760E-26, -1.8659E-26, -3.2565E-26, -1.4266E-26, &
      -2.7928E-26, -1.1241E-26, -2.4106E-26, -8.9809E-27, -2.1540E-26, -7.2344E-27, &
      -1.9194E-26, -5.9131E-27, -1.7386E-26, -4.7835E-27, -1.5811E-26, -3.7698E-27, &
      -1.4465E-26, -3.1781E-27, -1.3146E-26, -2.5387E-27, -1.2151E-26, -2.0316E-27, &
      -1.1265E-26, -1.5982E-27, -1.0363E-26, -1.2646E-27, -9.5867E-27, -9.1760E-28, &
      -8.9384E-27, -7.0248E-28, -8.2913E-27, -3.9640E-28, -4.3515E-27, -2.1966E-27, &
      -2.6919E-27, -1.0242E-27, -1.4282E-27, -1.2439E-28, -4.0174E-28, 6.0801E-28, &
      -3.7832E-28, 4.9600E-28, 1.2770E-27, 1.9832E-27, 2.6141E-27, 3.1594E-27, &
      3.6373E-27 /)
    REAL, PARAMETER :: b1_2_cs2(dim55) = (/ &
      -9.2274E-25, -9.8262E-25, -9.0054E-25, -1.0923E-24, -9.4640E-25, -1.2604E-24, &
      -1.0445E-24, -1.4490E-24, -1.1623E-24, -1.6246E-24, -1.2700E-24, -1.7824E-24, &
      -1.3657E-24, -1.9164E-24, -1.4596E-24, -2.0344E-24, -1.5258E-24, -2.1409E-24, &
      -1.5967E-24, -2.2342E-24, -1.6549E-24, -2.3228E-24, -1.7107E-24, -2.4091E-24, &
      -1.7621E-24, -2.4732E-24, -1.8202E-24, -2.5416E-24, -1.8639E-24, -2.6026E-24, &
      -1.9055E-24, -2.6595E-24, -1.9539E-24, -2.7091E-24, -1.9976E-24, -2.7604E-24, &
      -2.0346E-24, -2.8005E-24, -2.0758E-24, -2.8495E-24, -2.4520E-24, -2.6955E-24, &
      -2.6333E-24, -2.8635E-24, -2.8027E-24, -3.0152E-24, -2.9665E-24, -3.1563E-24, &
      -2.9586E-24, -3.1448E-24, -3.3209E-24, -3.4890E-24, -3.6470E-24, -3.7905E-24, &
      -3.9221E-24 /)
    REAL, PARAMETER :: a2_cs2(dim55) = (/ &
      -2.5580E-23, -2.4960E-23, -2.2756E-23, -1.9672E-23, -1.6380E-23, -1.3320E-23, &
      -1.0692E-23, -8.5432E-24, -6.8332E-24, -5.4868E-24, -4.4308E-24, -3.6012E-24, &
      -2.9464E-24, -2.4252E-24, -2.0080E-24, -1.6708E-24, -1.3964E-24, -1.1720E-24, &
      -9.8680E-25, -8.3400E-25, -7.0600E-25, -5.9936E-25, -5.0984E-25, -4.3444E-25, &
      -3.7076E-25, -3.1684E-25, -2.7104E-25, -2.3216E-25, -1.9900E-25, -1.7072E-25, &
      -1.4656E-25, -1.2592E-25, -1.0820E-25, -9.3040E-26, -8.0040E-26, -6.8840E-26, &
      -5.9300E-26, -5.1044E-26, -4.3956E-26, -3.7864E-26, -2.4762E-26, -1.1780E-26, &
      -5.6110E-27, -2.6728E-27, -1.2730E-27, -6.0600E-28, -2.8840E-28, -1.3718E-28, &
      -6.5238E-29, -3.1013E-29, -1.4740E-29, -7.0046E-30, -3.3282E-30, -1.5812E-30, &
      -7.5113E-31 /)
    REAL, PARAMETER :: b2_cs2(dim55) = (/ &
      4.6418E-22, 4.6232E-22, 4.5020E-22, 4.2553E-22, 3.9096E-22, 3.5118E-22, &
      3.1045E-22, 2.7177E-22, 2.3671E-22, 2.0575E-22, 1.7882E-22, 1.5559E-22, &
      1.3562E-22, 1.1842E-22, 1.0361E-22, 9.0793E-23, 7.9680E-23, 7.0031E-23, &
      6.1604E-23, 5.4270E-23, 4.7806E-23, 4.2154E-23, 3.7186E-23, 3.2813E-23, &
      2.8960E-23, 2.5563E-23, 2.2563E-23, 1.9919E-23, 1.7581E-23, 1.5517E-23, &
      1.3693E-23, 1.2083E-23, 1.0657E-23, 9.3982E-24, 8.2867E-24, 7.3011E-24, &
      6.4377E-24, 5.6699E-24, 4.9930E-24, 4.3960E-24, 3.0793E-24, 1.6123E-24, &
      8.3810E-25, 4.3262E-25, 2.2195E-25, 1.1323E-25, 5.7488E-26, 2.9060E-26, &
      1.4635E-26, 7.3444E-27, 3.6749E-27, 1.8339E-27, 9.1298E-28, 4.5351E-28, &
      2.2482E-28 /)

    jval_gp(ip_cs2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CS2(0) = p1( &
          a0_1_1_CS2(i0(j,k))*dlv2(j,k) + a0_1_2_CS2(i0(j,k)), &
          a0_2_1_CS2(i0(j,k))*dlv2(j,k) + a0_2_2_CS2(i0(j,k)), &
          v3_du1(j,k))
        sig_CS2(1) = &
          p1(b1_1_CS2(i1(j,k)),a1_1_CS2(i1(j,k)),v3_du1(j,k)) + &
          p1(b1_2_CS2(i1(j,k)),a1_2_CS2(i1(j,k)),v3_du1(j,k)) * v2s_m(j,k)
        sig_CS2(2) = &
          MAX(0.E0,p1(b2_CS2(i2(j,k)), a2_CS2(i2(j,k)),v3_du1(j,k)))
        dj = &
          sig_CS2(0) * fint(j,k,0) + &
          sig_CS2(1) * fint(j,k,1) + &
          sig_CS2(2) * fint(j,k,2)
        jval_gp(ip_cs2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_cs2

  ! **************************************************************************

  SUBROUTINE jval_cal_h2so4(jrow)

    ! H2SO4 (gas) -> SO3 + H2O
    ! vibrational overtones: Vaida et al 2003 Science 299, Hintze et al 2003,
    !  J.Ph.Ch. A107; Lyalpha: Mills et al, 2005, JGR 110, D24208

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: k, j
    REAL :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_h2so4 ! effective cross section
    ! interval 7 (2 bands)
    REAL, PARAMETER :: a7_H2SO4(2) = (/4.2204E-25, 6.9058E-30/)
    jval_gp(ip_h2so4)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        SIG_H2SO4(7)=P1(a7_H2SO4(1),a7_H2SO4(2),v3_du2(j,k))
        dj=6.4e-18*r_m(j,k)*phi_la + SIG_H2SO4(7) * fint(j,k,7)
        jval_gp(ip_h2so4)%ptr(iu0(j),k,jrow) = MAX(vinit,dj*fj_corr(j,1))
      ENDDO
    ENDDO
    
  END SUBROUTINE jval_cal_h2so4

  ! **************************************************************************

  SUBROUTINE jval_cal_H2O(jrow)

    ! H2O -> H + OH JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_H2O

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_H2O(dim58) = (/ &
      -6.0972E-21, -6.5257E-21, -6.9768E-21, -7.4347E-21, -7.8916E-21, -8.3272E-21, &
      -8.7404E-21, -9.1174E-21, -9.4593E-21, -9.7664E-21, -1.0042E-20, -1.0297E-20, &
      -1.0617E-20, -1.1074E-20, -1.1134E-20, -1.1235E-20, -1.1346E-20, -1.1200E-20, &
      -1.1019E-20, -1.0754E-20, -1.0195E-20, -9.5391E-21, -8.7703E-21, -7.7865E-21, &
      -6.7795E-21, -5.7122E-21, -4.7335E-21, -3.8663E-21, -3.1162E-21, -2.4966E-21, &
      -2.0004E-21, -1.6082E-21, -1.2962E-21, -1.0428E-21, -8.3424E-22, -6.6109E-22, &
      -5.2033E-22, -4.0806E-22, -3.2090E-22, -2.5467E-22, -2.0455E-22, -1.6589E-22, &
      -1.3447E-22, -1.0728E-22, -8.2806E-23, -6.0950E-23, -4.2142E-23, -2.7038E-23, &
      -1.5800E-23, -8.2349E-24, -3.7253E-24, -1.4108E-24, -4.2794E-25, -9.8858E-26, &
      -1.6552E-26, -1.9361E-27, -1.5605E-28, -1.4389E-29 /)
    REAL, PARAMETER :: a0_1_2_H2O(dim58) = (/ &
      3.2065E-19, 3.3959E-19, 3.5961E-19, 3.8004E-19, 4.0051E-19, 4.2011E-19, &
      4.3879E-19, 4.5590E-19, 4.7149E-19, 4.8556E-19, 4.9825E-19, 5.1002E-19, &
      5.2487E-19, 5.4616E-19, 5.4897E-19, 5.5371E-19, 5.5897E-19, 5.5205E-19, &
      5.4341E-19, 5.3075E-19, 5.0393E-19, 4.7231E-19, 4.3509E-19, 3.8728E-19, &
      3.3814E-19, 2.8584E-19, 2.3769E-19, 1.9485E-19, 1.5764E-19, 1.2679E-19, &
      1.0198E-19, 8.2291E-20, 6.6569E-20, 5.3747E-20, 4.3150E-20, 3.4320E-20, &
      2.7113E-20, 2.1342E-20, 1.6844E-20, 1.3414E-20, 1.0808E-20, 8.7894E-21, &
      7.1430E-21, 5.7127E-21, 4.4207E-21, 3.2623E-21, 2.2617E-21, 1.4552E-21, &
      8.5282E-22, 4.4582E-22, 2.0230E-22, 7.6854E-23, 2.3389E-23, 5.4212E-24, &
      9.1079E-25, 1.0691E-25, 8.6470E-27, 7.9895E-28 /)
    REAL, PARAMETER :: a0_2_1_H2O(dim58) = (/ &
      4.3286E-23, 4.6429E-23, 4.9866E-23, 5.3355E-23, 5.6897E-23, 6.0293E-23, &
      6.3590E-23, 6.6640E-23, 6.9464E-23, 7.2055E-23, 7.4433E-23, 7.6755E-23, &
      8.2497E-23, 9.4352E-23, 9.1229E-23, 9.1302E-23, 9.3544E-23, 8.9250E-23, &
      8.7002E-23, 8.5566E-23, 7.8723E-23, 7.2864E-23, 6.7044E-23, 5.7842E-23, &
      4.9624E-23, 4.0294E-23, 3.2672E-23, 2.6377E-23, 2.0946E-23, 1.6489E-23, &
      1.2962E-23, 1.0219E-23, 8.0794E-24, 6.3736E-24, 4.9916E-24, 3.8602E-24, &
      2.9523E-24, 2.2404E-24, 1.6997E-24, 1.3013E-24, 1.0124E-24, 8.0087E-25, &
      6.3832E-25, 5.0373E-25, 3.8584E-25, 2.8224E-25, 1.9420E-25, 1.2419E-25, &
      7.2503E-26, 3.7827E-26, 1.7156E-26, 6.5189E-27, 1.9845E-27, 4.5996E-28, &
      7.7237E-29, 9.0569E-30, 7.3146E-31, 6.7548E-32 /)
    REAL, PARAMETER :: a0_2_2_H2O(dim58) = (/ &
      -2.2985E-21, -2.4374E-21, -2.5900E-21, -2.7456E-21, -2.9043E-21, -3.0571E-21, &
      -3.2061E-21, -3.3446E-21, -3.4734E-21, -3.5920E-21, -3.7014E-21, -3.8087E-21, &
      -4.0751E-21, -4.6276E-21, -4.4814E-21, -4.4849E-21, -4.5907E-21, -4.3872E-21, &
      -4.2801E-21, -4.2115E-21, -3.8830E-21, -3.6006E-21, -3.3189E-21, -2.8717E-21, &
      -2.4707E-21, -2.0135E-21, -1.6385E-21, -1.3275E-21, -1.0582E-21, -8.3622E-22, &
      -6.5986E-22, -5.2217E-22, -4.1431E-22, -3.2801E-22, -2.5780E-22, -2.0010E-22, &
      -1.5361E-22, -1.1702E-22, -8.9119E-23, -6.8484E-23, -5.3459E-23, -4.2419E-23, &
      -3.3901E-23, -2.6822E-23, -2.0597E-23, -1.5106E-23, -1.0422E-23, -6.6841E-24, &
      -3.9135E-24, -2.0479E-24, -9.3168E-25, -3.5513E-25, -1.0846E-25, -2.5223E-26, &
      -4.2500E-27, -5.0009E-28, -4.0531E-29, -3.7507E-30 /)
    REAL, PARAMETER :: a0_3_1_H2O(dim58) = (/ &
      -9.1126E-26, -9.7980E-26, -1.0578E-25, -1.1371E-25, -1.2190E-25, -1.2977E-25, &
      -1.3759E-25, -1.4495E-25, -1.5186E-25, -1.5834E-25, -1.6437E-25, -1.7058E-25, &
      -1.9875E-25, -2.6329E-25, -2.3633E-25, -2.3083E-25, -2.3883E-25, -2.1410E-25, &
      -2.0404E-25, -2.0127E-25, -1.7589E-25, -1.5945E-25, -1.4635E-25, -1.2088E-25, &
      -1.0160E-25, -7.8387E-26, -6.1958E-26, -4.9704E-26, -3.9141E-26, -3.0500E-26, &
      -2.3706E-26, -1.8474E-26, -1.4438E-26, -1.1258E-26, -8.7058E-27, -6.6325E-27, &
      -4.9807E-27, -3.6974E-27, -2.7350E-27, -2.0391E-27, -1.5478E-27, -1.2008E-27, &
      -9.4471E-28, -7.3977E-28, -5.6383E-28, -4.1088E-28, -2.8188E-28, -1.7993E-28, &
      -1.0501E-28, -5.4850E-29, -2.4933E-29, -9.5003E-30, -2.9003E-30, -6.7402E-31, &
      -1.1344E-31, -1.3327E-32, -1.0780E-33, -9.9666E-35 /)
    REAL, PARAMETER :: a0_3_2_H2O(dim58) = (/ &
      4.8979E-24, 5.2009E-24, 5.5470E-24, 5.9010E-24, 6.2677E-24, 6.6217E-24, &
      6.9755E-24, 7.3096E-24, 7.6246E-24, 7.9213E-24, 8.1987E-24, 8.4855E-24, &
      9.7929E-24, 1.2801E-23, 1.1539E-23, 1.1280E-23, 1.1658E-23, 1.0486E-23, &
      1.0007E-23, 9.8745E-24, 8.6560E-24, 7.8636E-24, 7.2296E-24, 5.9918E-24, &
      5.0511E-24, 3.9135E-24, 3.1051E-24, 2.4998E-24, 1.9759E-24, 1.5455E-24, &
      1.2059E-24, 9.4319E-25, 7.3980E-25, 5.7890E-25, 4.4922E-25, 3.4349E-25, &
      2.5891E-25, 1.9295E-25, 1.4330E-25, 1.0725E-25, 8.1699E-26, 6.3583E-26, &
      5.0166E-26, 3.9387E-26, 3.0097E-26, 2.1991E-26, 1.5128E-26, 9.6836E-27, &
      5.6683E-27, 2.9695E-27, 1.3540E-27, 5.1756E-28, 1.5852E-28, 3.6962E-29, &
      6.2420E-30, 7.3589E-31, 5.9736E-32, 5.5340E-33 /)

    jval_gp(ip_H2O)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_H2O(0) = &
          p2(a0_1_1_H2O(i0(j,k))*dlv2(j,k) + &
          a0_1_2_H2O(i0(j,k)), &
          a0_2_1_H2O(i0(j,k))*dlv2(j,k) + &
          a0_2_2_H2O(i0(j,k)), &
          a0_3_1_H2O(i0(j,k))*dlv2(j,k) + &
          a0_3_2_H2O(i0(j,k)), v3_du1(j,k))
        dj = 0. &
          + 1.53E-17 * r_m(j,k) * phi_la &
        + sig_H2O(0) * fint(j,k,0)

        jval_gp(ip_H2O)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_H2O

  ! **************************************************************************

  SUBROUTINE jval_cal_N2O(jrow)

    ! N2O -> N2 + O1D JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_N2O

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_N2O(dim58) = (/ &
      -1.1879E-21, -1.2919E-21, -1.4029E-21, -1.5157E-21, -1.6342E-21, -1.7546E-21, &
      -1.8786E-21, -2.0035E-21, -2.1318E-21, -2.2637E-21, -2.3985E-21, -2.5369E-21, &
      -2.7937E-21, -3.2679E-21, -3.2830E-21, -3.4080E-21, -3.6357E-21, -3.6401E-21, &
      -3.7440E-21, -3.9344E-21, -3.9164E-21, -3.9864E-21, -4.1331E-21, -4.0937E-21, &
      -4.1385E-21, -4.0295E-21, -4.0091E-21, -4.0609E-21, -4.1003E-21, -4.1297E-21, &
      -4.1412E-21, -4.1354E-21, -4.1121E-21, -4.0724E-21, -4.0226E-21, -3.9655E-21, &
      -3.9120E-21, -3.8642E-21, -3.8279E-21, -3.8031E-21, -3.7862E-21, -3.7700E-21, &
      -3.7459E-21, -3.6973E-21, -3.6155E-21, -3.4936E-21, -3.3266E-21, -3.1293E-21, &
      -2.9100E-21, -2.6818E-21, -2.4603E-21, -2.2414E-21, -2.0298E-21, -1.8185E-21, &
      -1.6060E-21, -1.3884E-21, -1.1554E-21, -9.5408E-22 /)
    REAL, PARAMETER :: a0_1_2_N2O(dim58) = (/ &
      1.2287E-19, 1.2747E-19, 1.3239E-19, 1.3742E-19, 1.4274E-19, 1.4816E-19, &
      1.5376E-19, 1.5943E-19, 1.6528E-19, 1.7132E-19, 1.7752E-19, 1.8392E-19, &
      1.9583E-19, 2.1793E-19, 2.1863E-19, 2.2451E-19, 2.3525E-19, 2.3547E-19, &
      2.4041E-19, 2.4951E-19, 2.4865E-19, 2.5202E-19, 2.5912E-19, 2.5721E-19, &
      2.5939E-19, 2.5406E-19, 2.5305E-19, 2.5561E-19, 2.5756E-19, 2.5903E-19, &
      2.5960E-19, 2.5931E-19, 2.5813E-19, 2.5613E-19, 2.5360E-19, 2.5068E-19, &
      2.4795E-19, 2.4549E-19, 2.4361E-19, 2.4233E-19, 2.4145E-19, 2.4061E-19, &
      2.3935E-19, 2.3679E-19, 2.3247E-19, 2.2601E-19, 2.1713E-19, 2.0659E-19, &
      1.9483E-19, 1.8255E-19, 1.7059E-19, 1.5873E-19, 1.4722E-19, 1.3568E-19, &
      1.2404E-19, 1.1207E-19, 9.9209E-20, 8.8055E-20 /)
    REAL, PARAMETER :: a0_2_1_N2O(dim58) = (/ &
      4.4056E-24, 4.7620E-24, 5.1391E-24, 5.5159E-24, 5.9173E-24, 6.3085E-24, &
      6.7144E-24, 7.1063E-24, 7.5095E-24, 7.9143E-24, 8.3248E-24, 8.7314E-24, &
      1.0871E-23, 1.6048E-23, 1.4373E-23, 1.4352E-23, 1.5689E-23, 1.4168E-23, &
      1.4048E-23, 1.5020E-23, 1.3611E-23, 1.3362E-23, 1.3991E-23, 1.2699E-23, &
      1.2375E-23, 1.0581E-23, 9.7640E-24, 9.7167E-24, 9.6324E-24, 9.5282E-24, &
      9.3863E-24, 9.2030E-24, 8.9832E-24, 8.7325E-24, 8.4620E-24, 8.1836E-24, &
      7.9197E-24, 7.6749E-24, 7.4647E-24, 7.2790E-24, 7.1115E-24, 6.9373E-24, &
      6.7457E-24, 6.4835E-24, 6.1510E-24, 5.7314E-24, 5.2304E-24, 4.6864E-24, &
      4.1278E-24, 3.5882E-24, 3.1062E-24, 2.6499E-24, 2.2437E-24, 1.8642E-24, &
      1.5109E-24, 1.1923E-24, 9.1833E-25, 7.3076E-25 /)
    REAL, PARAMETER :: a0_2_2_N2O(dim58) = (/ &
      -2.8873E-22, -3.0448E-22, -3.2122E-22, -3.3803E-22, -3.5601E-22, -3.7362E-22, &
      -3.9196E-22, -4.0975E-22, -4.2814E-22, -4.4668E-22, -4.6556E-22, -4.8435E-22, &
      -5.8361E-22, -8.2489E-22, -7.4647E-22, -7.4550E-22, -8.0860E-22, -7.3652E-22, &
      -7.3081E-22, -7.7726E-22, -7.0961E-22, -6.9762E-22, -7.2809E-22, -6.6528E-22, &
      -6.4947E-22, -5.6156E-22, -5.2136E-22, -5.1902E-22, -5.1484E-22, -5.0966E-22, &
      -5.0256E-22, -4.9336E-22, -4.8228E-22, -4.6959E-22, -4.5586E-22, -4.4166E-22, &
      -4.2814E-22, -4.1556E-22, -4.0472E-22, -3.9509E-22, -3.8639E-22, -3.7730E-22, &
      -3.6725E-22, -3.5346E-22, -3.3590E-22, -3.1367E-22, -2.8701E-22, -2.5796E-22, &
      -2.2802E-22, -1.9899E-22, -1.7296E-22, -1.4823E-22, -1.2613E-22, -1.0541E-22, &
      -8.6054E-23, -6.8532E-23, -5.3408E-23, -4.3017E-23 /)
    REAL, PARAMETER :: a1_1_N2O(dim55) = (/ &
      1.0588E-22, 1.0951E-22, 1.1088E-22, 1.1001E-22, 1.0762E-22, 1.0445E-22, &
      1.0050E-22, 9.6832E-23, 9.2659E-23, 8.9257E-23, 8.5429E-23, 8.2512E-23, &
      7.9137E-23, 7.6676E-23, 7.3768E-23, 7.1688E-23, 6.9141E-23, 6.7364E-23, &
      6.5127E-23, 6.3636E-23, 6.1585E-23, 6.0333E-23, 5.8477E-23, 5.7399E-23, &
      5.5739E-23, 5.4788E-23, 5.3242E-23, 5.2442E-23, 5.1003E-23, 5.0318E-23, &
      4.8988E-23, 4.8395E-23, 4.7117E-23, 4.6649E-23, 4.5446E-23, 4.4998E-23, &
      4.3906E-23, 4.3552E-23, 4.2450E-23, 4.2151E-23, 4.0061E-23, 3.7376E-23, &
      3.4897E-23, 3.2874E-23, 3.0877E-23, 2.9280E-23, 2.7604E-23, 2.6233E-23, &
      2.4543E-23, 2.3256E-23, 2.2102E-23, 2.1043E-23, 1.9993E-23, 1.9025E-23, &
      1.8142E-23 /)
    REAL, PARAMETER :: b1_1_N2O(dim55) = (/ &
      1.2899E-21, 1.2790E-21, 1.2715E-21, 1.2784E-21, 1.3035E-21, 1.3447E-21, &
      1.4059E-21, 1.4720E-21, 1.5575E-21, 1.6357E-21, 1.7334E-21, 1.8150E-21, &
      1.9180E-21, 1.9992E-21, 2.1024E-21, 2.1815E-21, 2.2846E-21, 2.3610E-21, &
      2.4628E-21, 2.5344E-21, 2.6380E-21, 2.7043E-21, 2.8073E-21, 2.8699E-21, &
      2.9703E-21, 3.0302E-21, 3.1315E-21, 3.1859E-21, 3.2873E-21, 3.3373E-21, &
      3.4377E-21, 3.4839E-21, 3.5868E-21, 3.6257E-21, 3.7286E-21, 3.7680E-21, &
      3.8668E-21, 3.8997E-21, 4.0050E-21, 4.0343E-21, 4.2443E-21, 4.5478E-21, &
      4.8588E-21, 5.1380E-21, 5.4385E-21, 5.6989E-21, 5.9931E-21, 6.2507E-21, &
      6.5896E-21, 6.8638E-21, 7.1240E-21, 7.3759E-21, 7.6389E-21, 7.8935E-21, &
      8.1369E-21 /)
    REAL, PARAMETER :: a1_2_N2O(dim55) = (/ &
      -4.5644E-25, -3.6387E-25, -2.8687E-25, -2.0718E-25, -1.3793E-25, -9.0716E-26, &
      -4.0647E-26, -2.3758E-26, 1.0548E-26, 1.0237E-26, 3.4579E-26, 2.6910E-26, &
      4.5617E-26, 3.4753E-26, 5.0138E-26, 3.8119E-26, 5.1776E-26, 3.9902E-26, &
      5.1665E-26, 3.9686E-26, 5.1661E-26, 3.8960E-26, 5.0488E-26, 3.8121E-26, &
      4.8600E-26, 3.7058E-26, 4.7190E-26, 3.5816E-26, 4.5672E-26, 3.4453E-26, &
      4.3795E-26, 3.3179E-26, 4.2822E-26, 3.1709E-26, 4.0975E-26, 3.1096E-26, &
      3.9683E-26, 2.9368E-26, 3.8770E-26, 2.8808E-26, 3.3014E-26, 2.9378E-26, &
      2.9882E-26, 2.7135E-26, 2.8376E-26, 2.5828E-26, 2.7128E-26, 2.5085E-26, &
      2.9852E-26, 2.9263E-26, 2.8262E-26, 2.6933E-26, 2.6115E-26, 2.5238E-26, &
      2.3791E-26 /)
    REAL, PARAMETER :: b1_2_N2O(dim55) = (/ &
      -9.9530E-24, -1.0231E-23, -1.0654E-23, -1.1292E-23, -1.2019E-23, -1.2633E-23, &
      -1.3409E-23, -1.3713E-23, -1.4416E-23, -1.4409E-23, -1.5030E-23, -1.4815E-23, &
      -1.5385E-23, -1.5027E-23, -1.5573E-23, -1.5116E-23, -1.5669E-23, -1.5159E-23, &
      -1.5694E-23, -1.5119E-23, -1.5724E-23, -1.5051E-23, -1.5690E-23, -1.4973E-23, &
      -1.5607E-23, -1.4880E-23, -1.5544E-23, -1.4770E-23, -1.5465E-23, -1.4646E-23, &
      -1.5351E-23, -1.4523E-23, -1.5300E-23, -1.4377E-23, -1.5169E-23, -1.4300E-23, &
      -1.5077E-23, -1.4118E-23, -1.5016E-23, -1.4040E-23, -1.4462E-23, -1.4051E-23, &
      -1.4115E-23, -1.3736E-23, -1.3922E-23, -1.3507E-23, -1.3735E-23, -1.3351E-23, &
      -1.4307E-23, -1.4181E-23, -1.3956E-23, -1.3639E-23, -1.3434E-23, -1.3204E-23, &
      -1.2805E-23 /)
    REAL, PARAMETER :: a1_3_N2O(dim55) = (/ &
      1.3841E-28, -3.3907E-28, -5.1767E-28, -6.9077E-28, -7.8021E-28, -7.2713E-28, &
      -7.7153E-28, -6.0655E-28, -6.4927E-28, -4.6481E-28, -5.1397E-28, -3.5391E-28, &
      -4.0793E-28, -2.6960E-28, -3.2851E-28, -2.0812E-28, -2.6857E-28, -1.6619E-28, &
      -2.2129E-28, -1.3201E-28, -1.8935E-28, -1.0526E-28, -1.6177E-28, -8.5897E-29, &
      -1.3747E-28, -7.0977E-29, -1.1988E-28, -5.8943E-29, -1.0575E-28, -4.8785E-29, &
      -9.2351E-29, -4.0991E-29, -8.4440E-29, -3.3783E-29, -7.4576E-29, -3.0528E-29, &
      -6.7993E-29, -2.4361E-29, -6.3043E-29, -2.2099E-29, -3.9802E-29, -2.6833E-29, &
      -2.9000E-29, -2.0069E-29, -2.3613E-29, -1.6000E-29, -1.9159E-29, -1.3195E-29, &
      -2.4349E-29, -2.1868E-29, -1.8928E-29, -1.5582E-29, -1.3309E-29, -1.1229E-29, &
      -8.2123E-30 /)
    REAL, PARAMETER :: b1_3_N2O(dim55) = (/ &
      2.5813E-26, 2.7245E-26, 2.8228E-26, 2.9612E-26, 3.0552E-26, 2.9862E-26, &
      3.0550E-26, 2.7580E-26, 2.8456E-26, 2.4213E-26, 2.5467E-26, 2.0985E-26, &
      2.2633E-26, 1.8068E-26, 2.0159E-26, 1.5585E-26, 1.8033E-26, 1.3630E-26, &
      1.6138E-26, 1.1852E-26, 1.4748E-26, 1.0291E-26, 1.3427E-26, 9.0264E-27, &
      1.2146E-26, 7.9575E-27, 1.1161E-26, 7.0169E-27, 1.0317E-26, 6.1584E-27, &
      9.4476E-27, 5.4415E-27, 8.9392E-27, 4.7346E-27, 8.2225E-27, 4.3463E-27, &
      7.7368E-27, 3.6790E-27, 7.3731E-27, 3.3607E-27, 5.1398E-27, 3.6744E-27, &
      3.9463E-27, 2.7138E-27, 3.2472E-27, 2.0063E-27, 2.5606E-27, 1.4393E-27, &
      3.6757E-27, 3.1474E-27, 2.4843E-27, 1.6880E-27, 1.1186E-27, 5.7170E-28, &
      -2.5952E-28 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_N2O(dim58) = (/ &
      -3.9122E-03, -3.9122E-03, -3.9122E-03, -5.1702E-03, -6.1473E-03, -7.5066E-03, &
      -8.4820E-03, -9.3341E-03, -9.7049E-03, -1.0293E-02, -1.0041E-02, -9.9148E-03, &
      -9.4026E-03, -8.7846E-03, -8.2882E-03, -7.9037E-03, -7.9897E-03, -8.2582E-03, &
      -8.9682E-03, -1.0176E-02, -1.0999E-02, -1.2077E-02, -1.2316E-02, -1.1492E-02, &
      -9.6789E-03, -6.5069E-03, -2.0917E-03, 3.3341E-03, 9.3419E-03, 1.4394E-02, &
      1.7959E-02, 1.9523E-02, 1.7719E-02, 1.2763E-02, 4.9173E-03, -4.7326E-03, &
      -1.4738E-02, -2.3275E-02, -2.8612E-02, -2.8353E-02, -2.2223E-02, -9.5056E-03, &
      8.4456E-03, 2.8752E-02, 4.8995E-02, 6.4727E-02, 7.4251E-02, 7.8022E-02, &
      7.7546E-02, 7.7180E-02, 8.1547E-02, 9.3417E-02, 1.1337E-01, 1.3806E-01, &
      1.6175E-01, 1.8074E-01, 2.0150E-01, 2.2980E-01 /)
    REAL, PARAMETER :: c0_1_2_N2O(dim58) = (/ &
      6.6538E-01, 6.6538E-01, 6.6538E-01, 7.2149E-01, 7.6526E-01, 8.2643E-01, &
      8.7052E-01, 9.0920E-01, 9.2611E-01, 9.5306E-01, 9.4145E-01, 9.3562E-01, &
      9.1186E-01, 8.8306E-01, 8.5982E-01, 8.4176E-01, 8.4581E-01, 8.5854E-01, &
      8.9234E-01, 9.5005E-01, 9.8959E-01, 1.0415E+00, 1.0531E+00, 1.0131E+00, &
      9.2458E-01, 7.6915E-01, 5.5192E-01, 2.8389E-01, -1.4099E-02, -2.6569E-01, &
      -4.4392E-01, -5.2247E-01, -4.3153E-01, -1.8075E-01, 2.1780E-01, 7.0994E-01, &
      1.2222E+00, 1.6610E+00, 1.9364E+00, 1.9230E+00, 1.6043E+00, 9.4038E-01, &
      -2.5931E-04, -1.0684E+00, -2.1372E+00, -2.9710E+00, -3.4777E+00, -3.6791E+00, &
      -3.6535E+00, -3.6338E+00, -3.8697E+00, -4.5130E+00, -5.5985E+00, -6.9463E+00, &
      -8.2449E+00, -9.2894E+00, -1.0435E+01, -1.2003E+01 /)
    REAL, PARAMETER :: c0_2_1_N2O(dim58) = (/ &
      -1.7093E-03, -1.7093E-03, -1.7093E-03, -1.1812E-03, -7.4906E-04, -2.4199E-03, &
      -2.9930E-03, -3.1437E-03, -1.5685E-03, -1.7126E-03, 1.4719E-04, -1.7286E-04, &
      2.7278E-03, 2.4713E-03, 4.3408E-03, 6.8345E-03, 6.8436E-03, 8.6334E-03, &
      7.6801E-03, 8.0477E-03, 5.9443E-03, 6.7762E-03, 5.8018E-03, 4.9516E-03, &
      5.2152E-03, 8.0859E-03, 6.6773E-03, 8.2107E-03, 7.5607E-03, 7.6798E-03, &
      4.2032E-03, 1.1332E-03, -9.7325E-04, -3.5432E-03, -3.4005E-03, -7.2491E-03, &
      -8.7204E-03, -4.6320E-03, 2.5192E-03, 1.8152E-02, 3.5007E-02, 5.3405E-02, &
      6.1137E-02, 6.6610E-02, 6.1754E-02, 5.1254E-02, 4.7714E-02, 4.7520E-02, &
      5.4389E-02, 6.0308E-02, 5.3734E-02, 3.4275E-02, -1.2484E-02, -6.4308E-02, &
      -1.0133E-01, -9.4576E-02, -3.1269E-02, 5.1118E-02 /)
    REAL, PARAMETER :: c0_2_2_N2O(dim58) = (/ &
      2.2370E-01, 2.2370E-01, 2.2370E-01, 2.0015E-01, 1.8079E-01, 2.5598E-01, &
      2.8188E-01, 2.8872E-01, 2.1689E-01, 2.2350E-01, 1.3794E-01, 1.5273E-01, &
      1.8139E-02, 3.0094E-02, -5.7402E-02, -1.7461E-01, -1.7503E-01, -2.5987E-01, &
      -2.1449E-01, -2.3206E-01, -1.3110E-01, -1.7120E-01, -1.2404E-01, -8.2718E-02, &
      -9.5584E-02, -2.3625E-01, -1.6694E-01, -2.4269E-01, -2.1045E-01, -2.1638E-01, &
      -4.2552E-02, 1.1156E-01, 2.1773E-01, 3.4777E-01, 3.4052E-01, 5.3679E-01, &
      6.1212E-01, 4.0198E-01, 3.2980E-02, -7.7679E-01, -1.6533E+00, -2.6136E+00, &
      -3.0188E+00, -3.3067E+00, -3.0503E+00, -2.4938E+00, -2.3055E+00, -2.2951E+00, &
      -2.6633E+00, -2.9817E+00, -2.6267E+00, -1.5720E+00, 9.7167E-01, 3.8012E+00, &
      5.8300E+00, 5.4586E+00, 1.9640E+00, -2.6002E+00 /)
    REAL, PARAMETER :: c1_N2O(3) = (/ 1.00,  1.33,  0.91 /)

    jval_gp(ip_N2O)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_N2O(0) = &
          p2(1.,c0_1_1_N2O(i0(j,k))*dlv2(j,k) + &
          c0_1_2_N2O(i0(j,k)), &
          c0_2_1_N2O(i0(j,k))*dlv2(j,k) + &
          c0_2_2_N2O(i0(j,k)), tnorm_sr(j,k)) * &
          p1(a0_1_1_N2O(i0(j,k))*dlv2(j,k) + &
          a0_1_2_N2O(i0(j,k)), &
          a0_2_1_N2O(i0(j,k))*dlv2(j,k) + &
          a0_2_2_N2O(i0(j,k)),v3_du1(j,k))
        sig_N2O(1) = &
          p2(c1_N2O(1),c1_N2O(2), &
          c1_N2O(3),tnorm(j,k)) * &
          (p1(b1_1_N2O(i1(j,k)),a1_1_N2O(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_N2O(i1(j,k)),a1_2_N2O(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k) + &
          p1(b1_3_N2O(i1(j,k)),a1_3_N2O(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k)**2)
        dj = 0. &
          + sig_N2O(0) * fint(j,k,0) &
          + sig_N2O(1) * fint(j,k,1)

        jval_gp(ip_N2O)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_N2O

  ! **************************************************************************

  SUBROUTINE jval_cal_no(jrow)

    ! NO -> N + O
    ! Allen + Frederick, J. Atmos. Sci. 39, 2066-2075, 1982

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_no 

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_no(dim58) = (/ &
      4.8294E-22, -2.6705E-22, -9.2287E-21, -2.1578E-20, -3.3937E-20, -4.4211E-20, &
      -5.1449E-20, -5.5561E-20, -5.7027E-20, -5.6724E-20, -5.5524E-20, -5.4432E-20, &
      -5.4184E-20, -5.5477E-20, -5.8313E-20, -6.3064E-20, -6.9663E-20, -7.7493E-20, &
      -8.6285E-20, -9.5515E-20, -1.0416E-19, -1.1214E-19, -1.1911E-19, -1.2427E-19, &
      -1.2818E-19, -1.3032E-19, -1.3125E-19, -1.3095E-19, -1.2923E-19, -1.2599E-19, &
      -1.2103E-19, -1.1422E-19, -1.0559E-19, -9.5234E-20, -8.3749E-20, -7.1719E-20, &
      -6.0169E-20, -4.9868E-20, -4.1403E-20, -3.4915E-20, -3.0102E-20, -2.6464E-20, &
      -2.3508E-20, -2.0890E-20, -1.8457E-20, -1.6152E-20, -1.3968E-20, -1.1999E-20, &
      -1.0344E-20, -9.1571E-21, -8.5636E-21, -8.5562E-21, -1.8846E-20, -1.3122E-20, &
      -6.0916E-21, -2.2562E-21, -6.2901E-22, -1.7769E-22 /)
    REAL, PARAMETER :: a0_1_2_no(dim58) = (/ &
      6.2919E-19, 6.6234E-19, 1.0602E-18, 1.6110E-18, 2.1647E-18, 2.6270E-18, &
      2.9542E-18, 3.1409E-18, 3.2077E-18, 3.1938E-18, 3.1386E-18, 3.0882E-18, &
      3.0767E-18, 3.1370E-18, 3.2697E-18, 3.4930E-18, 3.8044E-18, 4.1756E-18, &
      4.5941E-18, 5.0353E-18, 5.4504E-18, 5.8346E-18, 6.1720E-18, 6.4230E-18, &
      6.6139E-18, 6.7186E-18, 6.7645E-18, 6.7497E-18, 6.6642E-18, 6.5028E-18, &
      6.2548E-18, 5.9133E-18, 5.4780E-18, 4.9541E-18, 4.3707E-18, 3.7571E-18, &
      3.1658E-18, 2.6363E-18, 2.1995E-18, 1.8634E-18, 1.6132E-18, 1.4233E-18, &
      1.2684E-18, 1.1307E-18, 1.0022E-18, 8.8004E-19, 7.6384E-19, 6.5871E-19, &
      5.6999E-19, 5.0613E-19, 4.7408E-19, 4.7367E-19, 1.0335E-18, 7.2090E-19, &
      3.3564E-19, 1.2470E-19, 3.4875E-20, 9.8725E-21 /)
    REAL, PARAMETER :: a0_2_1_no(dim58) = (/ &
      -6.4112E-23, -8.3731E-23, -3.0543E-23, 5.6217E-23, 1.4808E-22, 2.2765E-22, &
      2.8591E-22, 3.2067E-22, 3.3430E-22, 3.3354E-22, 3.2478E-22, 3.1683E-22, &
      3.1700E-22, 3.3876E-22, 3.5573E-22, 3.9035E-22, 4.4412E-22, 4.9511E-22, &
      5.5721E-22, 6.2827E-22, 6.7845E-22, 7.2876E-22, 7.7624E-22, 7.9450E-22, &
      8.0973E-22, 8.0051E-22, 7.9258E-22, 7.8430E-22, 7.6869E-22, 7.4528E-22, &
      7.1196E-22, 6.6676E-22, 6.0960E-22, 5.3949E-22, 4.6097E-22, 3.7810E-22, &
      2.9876E-22, 2.2961E-22, 1.7558E-22, 1.3782E-22, 1.1363E-22, 9.8481E-23, &
      8.8190E-23, 7.9500E-23, 7.1498E-23, 6.3480E-23, 5.5503E-23, 4.7936E-23, &
      4.1291E-23, 3.6288E-23, 3.3633E-23, 3.3452E-23, 7.4318E-23, 5.1959E-23, &
      2.4218E-23, 9.0038E-24, 2.5179E-24, 7.1284E-25 /)
    REAL, PARAMETER :: a0_2_2_no(dim58) = (/ &
      -8.8093E-22, -1.3754E-23, -2.3753E-21, -6.2448E-21, -1.0360E-20, -1.3941E-20, &
      -1.6574E-20, -1.8153E-20, -1.8774E-20, -1.8739E-20, -1.8336E-20, -1.7969E-20, &
      -1.7977E-20, -1.8991E-20, -1.9785E-20, -2.1412E-20, -2.3950E-20, -2.6367E-20, &
      -2.9323E-20, -3.2720E-20, -3.5128E-20, -3.7553E-20, -3.9851E-20, -4.0738E-20, &
      -4.1482E-20, -4.1030E-20, -4.0640E-20, -4.0231E-20, -3.9457E-20, -3.8291E-20, &
      -3.6625E-20, -3.4356E-20, -3.1475E-20, -2.7928E-20, -2.3939E-20, -1.9712E-20, &
      -1.5650E-20, -1.2095E-20, -9.3080E-21, -7.3518E-21, -6.0937E-21, -5.3031E-21, &
      -4.7638E-21, -4.3068E-21, -3.8842E-21, -3.4593E-21, -3.0349E-21, -2.6308E-21, &
      -2.2747E-21, -2.0055E-21, -1.8621E-21, -1.8523E-21, -4.0754E-21, -2.8546E-21, &
      -1.3344E-21, -4.9763E-22, -1.3960E-22, -3.9604E-23 /)
    REAL, PARAMETER :: a0_3_1_no(dim58) = (/ &
      4.5919E-25, 5.7344E-25, 4.4437E-25, 1.9326E-25, -7.8876E-26, -3.2715E-25, &
      -5.1782E-25, -6.3429E-25, -6.7988E-25, -6.8079E-25, -6.5417E-25, -6.4150E-25, &
      -6.9416E-25, -9.4519E-25, -9.7579E-25, -1.1093E-24, -1.3672E-24, -1.4870E-24, &
      -1.6994E-24, -2.0044E-24, -2.0934E-24, -2.2478E-24, -2.4448E-24, -2.4161E-24, &
      -2.4352E-24, -2.2822E-24, -2.2060E-24, -2.1810E-24, -2.1364E-24, -2.0720E-24, &
      -1.9787E-24, -1.8478E-24, -1.6814E-24, -1.4701E-24, -1.2311E-24, -9.7562E-25, &
      -7.2985E-25, -5.1717E-25, -3.5557E-25, -2.4897E-25, -1.8826E-25, -1.5740E-25, &
      -1.4269E-25, -1.3135E-25, -1.2187E-25, -1.1072E-25, -9.8618E-26, -8.6156E-26, &
      -7.4548E-26, -6.5189E-26, -5.9951E-26, -5.9530E-26, -1.3382E-25, -9.4018E-26, &
      -4.4026E-26, -1.6438E-26, -4.6123E-27, -1.3090E-27 /)
    REAL, PARAMETER :: a0_3_2_no(dim58) = (/ &
      -1.0611E-23, -1.5661E-23, -9.9299E-24, 1.2695E-24, 1.3461E-23, 2.4634E-23, &
      3.3252E-23, 3.8539E-23, 4.0619E-23, 4.0660E-23, 3.9436E-23, 3.8850E-23, &
      4.1294E-23, 5.2992E-23, 5.4424E-23, 6.0700E-23, 7.2873E-23, 7.8551E-23, &
      8.8659E-23, 1.0324E-22, 1.0751E-22, 1.1495E-22, 1.2449E-22, 1.2310E-22, &
      1.2403E-22, 1.1653E-22, 1.1278E-22, 1.1154E-22, 1.0933E-22, 1.0613E-22, &
      1.0146E-22, 9.4890E-23, 8.6503E-23, 7.5812E-23, 6.3667E-23, 5.0640E-23, &
      3.8057E-23, 2.7125E-23, 1.8786E-23, 1.3264E-23, 1.0108E-23, 8.4964E-24, &
      7.7258E-24, 7.1294E-24, 6.6286E-24, 6.0377E-24, 5.3941E-24, 4.7286E-24, &
      4.1064E-24, 3.6029E-24, 3.3200E-24, 3.2972E-24, 7.3386E-24, 5.1654E-24, &
      2.4259E-24, 9.0852E-25, 2.5573E-25, 7.2728E-26 /)
    REAL, PARAMETER :: a0_4_1_no(dim58) = (/ &
      -9.8346E-28, -1.1835E-27, -1.0679E-27, -7.7518E-28, -4.7363E-28, -1.6377E-28, &
      8.9875E-29, 2.4372E-28, 2.9444E-28, 3.0025E-28, 2.6214E-28, 2.7906E-28, &
      5.2042E-28, 1.4125E-27, 1.3483E-27, 1.5636E-27, 2.1065E-27, 2.1079E-27, &
      2.3933E-27, 2.9482E-27, 2.8697E-27, 3.0409E-27, 3.3819E-27, 3.1568E-27, &
      3.1247E-27, 2.6968E-27, 2.5134E-27, 2.4933E-27, 2.4503E-27, 2.3853E-27, &
      2.2845E-27, 2.1347E-27, 1.9430E-27, 1.6905E-27, 1.4028E-27, 1.0915E-27, &
      7.8994E-28, 5.2857E-28, 3.3235E-28, 2.0616E-28, 1.3869E-28, 1.0889E-28, &
      1.0042E-28, 9.4681E-29, 9.1792E-29, 8.5801E-29, 7.8177E-29, 6.9375E-29, &
      6.0582E-29, 5.2845E-29, 4.8318E-29, 4.8101E-29, 1.0946E-28, 7.7243E-29, &
      3.6330E-29, 1.3616E-29, 3.8317E-30, 1.0900E-30 /)
    REAL, PARAMETER :: a0_4_2_no(dim58) = (/ &
      3.2681E-26, 4.1522E-26, 3.6391E-26, 2.3334E-26, 9.8250E-27, -4.1188E-27, &
      -1.5584E-26, -2.2568E-26, -2.4881E-26, -2.5147E-26, -2.3394E-26, -2.4176E-26, &
      -3.5375E-26, -7.6945E-26, -7.3940E-26, -8.4059E-26, -1.0968E-25, -1.0975E-25, &
      -1.2334E-25, -1.4986E-25, -1.4610E-25, -1.5434E-25, -1.7085E-25, -1.5991E-25, &
      -1.5834E-25, -1.3737E-25, -1.2835E-25, -1.2736E-25, -1.2522E-25, -1.2199E-25, &
      -1.1695E-25, -1.0943E-25, -9.9769E-26, -8.6994E-26, -7.2374E-26, -5.6502E-26, &
      -4.1060E-26, -2.7625E-26, -1.7501E-26, -1.0964E-26, -7.4555E-27, -5.9003E-27, &
      -5.4565E-27, -5.1545E-27, -5.0019E-27, -4.6844E-27, -4.2788E-27, -3.8087E-27, &
      -3.3375E-27, -2.9212E-27, -2.6767E-27, -2.6650E-27, -6.0028E-27, -4.2438E-27, &
      -2.0018E-27, -7.5254E-28, -2.1245E-28, -6.0560E-29 /)

    jval_gp(ip_no)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_no(0) = p3(a0_1_1_no(i0(j,k))*dlv2(j,k) + a0_1_2_no(i0(j,k)), &
          a0_2_1_no(i0(j,k))*dlv2(j,k) + a0_2_2_no(i0(j,k)), &
          a0_3_1_no(i0(j,k))*dlv2(j,k) + a0_3_2_no(i0(j,k)), &
          a0_4_1_no(i0(j,k))*dlv2(j,k) + a0_4_2_no(i0(j,k)), &
          v3_du1(j,k))
        dj = &
          sig_no(0) * fint(j,k,0)
        jval_gp(ip_no)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_no

  ! **************************************************************************

  SUBROUTINE jval_cal_CO2(jrow)

    ! CO2 -> CO + O Shemansky, JCP 56, 1582 (1972), lambda < 240 nm; Ly-alpha, Inn et al, JCP 21, 1648-1650 (1953)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CO2

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CO2(dim58) = (/ &
      -1.3096E-23, -1.4054E-23, -1.5026E-23, -1.6041E-23, -1.7062E-23, -1.8057E-23, &
      -1.8982E-23, -1.9880E-23, -2.0716E-23, -2.1507E-23, -2.2230E-23, -2.2938E-23, &
      -2.3786E-23, -2.4934E-23, -2.5262E-23, -2.5681E-23, -2.6134E-23, -2.6054E-23, &
      -2.5928E-23, -2.5664E-23, -2.4796E-23, -2.3771E-23, -2.2565E-23, -2.0879E-23, &
      -1.9168E-23, -1.7250E-23, -1.5487E-23, -1.3900E-23, -1.2460E-23, -1.1190E-23, &
      -1.0076E-23, -9.0947E-24, -8.2193E-24, -7.4253E-24, -6.7113E-24, -6.0721E-24, &
      -5.5218E-24, -5.0573E-24, -4.6721E-24, -4.3632E-24, -4.1050E-24, -3.8814E-24, &
      -3.6660E-24, -3.4384E-24, -3.1851E-24, -2.9051E-24, -2.6030E-24, -2.2990E-24, &
      -2.0054E-24, -1.7381E-24, -1.5027E-24, -1.2963E-24, -1.1122E-24, -9.4388E-25, &
      -7.8765E-25, -6.4260E-25, -5.0639E-25, -4.0590E-25 /)
    REAL, PARAMETER :: a0_1_2_CO2(dim58) = (/ &
      7.2158E-22, 7.6394E-22, 8.0708E-22, 8.5235E-22, 8.9810E-22, 9.4284E-22, &
      9.8466E-22, 1.0254E-21, 1.0635E-21, 1.0998E-21, 1.1331E-21, 1.1658E-21, &
      1.2051E-21, 1.2586E-21, 1.2740E-21, 1.2936E-21, 1.3150E-21, 1.3112E-21, &
      1.3053E-21, 1.2926E-21, 1.2510E-21, 1.2015E-21, 1.1432E-21, 1.0612E-21, &
      9.7774E-22, 8.8376E-22, 7.9701E-22, 7.1862E-22, 6.4721E-22, 5.8393E-22, &
      5.2826E-22, 4.7899E-22, 4.3487E-22, 3.9470E-22, 3.5843E-22, 3.2583E-22, &
      2.9765E-22, 2.7378E-22, 2.5390E-22, 2.3790E-22, 2.2447E-22, 2.1280E-22, &
      2.0151E-22, 1.8954E-22, 1.7617E-22, 1.6133E-22, 1.4526E-22, 1.2902E-22, &
      1.1329E-22, 9.8906E-23, 8.6190E-23, 7.5007E-23, 6.4992E-23, 5.5800E-23, &
      4.7239E-23, 3.9261E-23, 3.1742E-23, 2.6175E-23 /)
    REAL, PARAMETER :: a0_2_1_CO2(dim58) = (/ &
      8.8231E-26, 9.4879E-26, 1.0156E-25, 1.0875E-25, 1.1614E-25, 1.2346E-25, &
      1.2998E-25, 1.3661E-25, 1.4278E-25, 1.4883E-25, 1.5419E-25, 1.5971E-25, &
      1.7243E-25, 1.9822E-25, 1.9294E-25, 1.9433E-25, 2.0056E-25, 1.9278E-25, &
      1.8969E-25, 1.8887E-25, 1.7617E-25, 1.6616E-25, 1.5708E-25, 1.3976E-25, &
      1.2510E-25, 1.0662E-25, 9.2021E-26, 8.0311E-26, 6.9778E-26, 6.0582E-26, &
      5.2686E-26, 4.5897E-26, 3.9983E-26, 3.4755E-26, 3.0134E-26, 2.6092E-26, &
      2.2675E-26, 1.9845E-26, 1.7533E-26, 1.5747E-26, 1.4292E-26, 1.3093E-26, &
      1.1997E-26, 1.0901E-26, 9.7407E-27, 8.5117E-27, 7.2542E-27, 6.0416E-27, &
      4.9251E-27, 3.9654E-27, 3.1671E-27, 2.5166E-27, 1.9738E-27, 1.5203E-27, &
      1.1383E-27, 8.3290E-28, 5.9026E-28, 4.4357E-28 /)
    REAL, PARAMETER :: a0_2_2_CO2(dim58) = (/ &
      -4.8064E-24, -5.1003E-24, -5.3968E-24, -5.7175E-24, -6.0485E-24, -6.3779E-24, &
      -6.6726E-24, -6.9738E-24, -7.2551E-24, -7.5320E-24, -7.7787E-24, -8.0338E-24, &
      -8.6238E-24, -9.8257E-24, -9.5789E-24, -9.6442E-24, -9.9381E-24, -9.5694E-24, &
      -9.4223E-24, -9.3830E-24, -8.7733E-24, -8.2908E-24, -7.8516E-24, -7.0097E-24, &
      -6.2944E-24, -5.3888E-24, -4.6705E-24, -4.0920E-24, -3.5696E-24, -3.1117E-24, &
      -2.7168E-24, -2.3760E-24, -2.0780E-24, -1.8134E-24, -1.5787E-24, -1.3725E-24, &
      -1.1976E-24, -1.0521E-24, -9.3282E-25, -8.4031E-25, -7.6465E-25, -7.0206E-25, &
      -6.4465E-25, -5.8700E-25, -5.2572E-25, -4.6059E-25, -3.9369E-25, -3.2894E-25, &
      -2.6909E-25, -2.1746E-25, -1.7435E-25, -1.3910E-25, -1.0956E-25, -8.4807E-26, &
      -6.3870E-26, -4.7074E-26, -3.3681E-26, -2.5554E-26 /)
    REAL, PARAMETER :: a0_3_1_CO2(dim58) = (/ &
      -1.7818E-28, -1.9229E-28, -2.0628E-28, -2.2187E-28, -2.3834E-28, -2.5504E-28, &
      -2.6917E-28, -2.8439E-28, -2.9861E-28, -3.1322E-28, -3.2572E-28, -3.3942E-28, &
      -3.9919E-28, -5.3672E-28, -4.8407E-28, -4.7605E-28, -4.9762E-28, -4.4826E-28, &
      -4.3117E-28, -4.3161E-28, -3.8084E-28, -3.5117E-28, -3.3156E-28, -2.8046E-28, &
      -2.4490E-28, -1.9537E-28, -1.6226E-28, -1.3960E-28, -1.1930E-28, -1.0169E-28, &
      -8.6750E-29, -7.4097E-29, -6.3211E-29, -5.3732E-29, -4.5420E-29, -3.8241E-29, &
      -3.2256E-29, -2.7357E-29, -2.3397E-29, -2.0450E-29, -1.8103E-29, -1.6261E-29, &
      -1.4650E-29, -1.3100E-29, -1.1498E-29, -9.8268E-30, -8.1654E-30, -6.5908E-30, &
      -5.1653E-30, -3.9802E-30, -3.0207E-30, -2.2755E-30, -1.6699E-30, -1.1963E-30, &
      -8.1390E-31, -5.4314E-31, -3.4371E-31, -2.3955E-31 /)
    REAL, PARAMETER :: a0_3_2_CO2(dim58) = (/ &
      9.7837E-27, 1.0407E-26, 1.1028E-26, 1.1723E-26, 1.2461E-26, 1.3213E-26, &
      1.3852E-26, 1.4543E-26, 1.5191E-26, 1.5860E-26, 1.6435E-26, 1.7068E-26, &
      1.9841E-26, 2.6250E-26, 2.3787E-26, 2.3409E-26, 2.4428E-26, 2.2088E-26, &
      2.1275E-26, 2.1295E-26, 1.8859E-26, 1.7428E-26, 1.6479E-26, 1.3996E-26, &
      1.2261E-26, 9.8336E-27, 8.2047E-27, 7.0849E-27, 6.0783E-27, 5.2010E-27, &
      4.4543E-27, 3.8191E-27, 3.2704E-27, 2.7908E-27, 2.3685E-27, 2.0024E-27, &
      1.6960E-27, 1.4442E-27, 1.2398E-27, 1.0872E-27, 9.6515E-28, 8.6899E-28, &
      7.8455E-28, 7.0302E-28, 6.1844E-28, 5.2988E-28, 4.4150E-28, 3.5741E-28, &
      2.8101E-28, 2.1725E-28, 1.6544E-28, 1.2505E-28, 9.2098E-29, 6.6244E-29, &
      4.5286E-29, 3.0395E-29, 1.9386E-29, 1.3615E-29 /)
    REAL, PARAMETER :: a1_1_CO2(dim55) = (/ &
      6.6994E-27, 6.3248E-27, 6.0287E-27, 5.4760E-27, 5.0508E-27, 4.5234E-27, &
      4.1153E-27, 3.6962E-27, 3.3655E-27, 3.0565E-27, 2.8056E-27, 2.5837E-27, &
      2.3908E-27, 2.2335E-27, 2.0842E-27, 1.9666E-27, 1.8489E-27, 1.7586E-27, &
      1.6628E-27, 1.5936E-27, 1.5139E-27, 1.4572E-27, 1.3904E-27, 1.3435E-27, &
      1.2867E-27, 1.2495E-27, 1.1979E-27, 1.1667E-27, 1.1229E-27, 1.0971E-27, &
      1.0552E-27, 1.0358E-27, 9.9840E-28, 9.8154E-28, 9.4746E-28, 9.3295E-28, &
      9.0342E-28, 8.9001E-28, 8.6343E-28, 8.5260E-28, 7.9765E-28, 7.2964E-28, &
      6.7078E-28, 6.2557E-28, 5.8245E-28, 5.4960E-28, 5.1494E-28, 4.8943E-28, &
      4.5168E-28, 4.2505E-28, 4.0026E-28, 3.7729E-28, 3.5549E-28, 3.3551E-28, &
      3.1648E-28 /)
    REAL, PARAMETER :: b1_1_CO2(dim55) = (/ &
      5.4194E-25, 5.4306E-25, 5.4469E-25, 5.4911E-25, 5.5358E-25, 5.6043E-25, &
      5.6676E-25, 5.7430E-25, 5.8108E-25, 5.8819E-25, 5.9459E-25, 6.0080E-25, &
      6.0668E-25, 6.1187E-25, 6.1718E-25, 6.2164E-25, 6.2641E-25, 6.3029E-25, &
      6.3465E-25, 6.3797E-25, 6.4200E-25, 6.4500E-25, 6.4871E-25, 6.5143E-25, &
      6.5487E-25, 6.5721E-25, 6.6059E-25, 6.6271E-25, 6.6580E-25, 6.6768E-25, &
      6.7085E-25, 6.7236E-25, 6.7537E-25, 6.7677E-25, 6.7968E-25, 6.8096E-25, &
      6.8363E-25, 6.8488E-25, 6.8742E-25, 6.8848E-25, 6.9400E-25, 7.0169E-25, &
      7.0907E-25, 7.1531E-25, 7.2180E-25, 7.2716E-25, 7.3324E-25, 7.3804E-25, &
      7.4561E-25, 7.5128E-25, 7.5687E-25, 7.6234E-25, 7.6780E-25, 7.7305E-25, &
      7.7829E-25 /)
    REAL, PARAMETER :: a1_2_CO2(dim55) = (/ &
      -1.0404E-29, -3.5983E-30, -2.3565E-30, 2.5733E-30, 3.2693E-30, 5.7586E-30, &
      5.8042E-30, 6.5503E-30, 6.2157E-30, 6.1522E-30, 5.6830E-30, 5.3042E-30, &
      4.9349E-30, 4.4574E-30, 4.1889E-30, 3.7442E-30, 3.5625E-30, 3.1888E-30, &
      3.0710E-30, 2.7376E-30, 2.6662E-30, 2.3879E-30, 2.3471E-30, 2.1049E-30, &
      2.0846E-30, 1.8652E-30, 1.8669E-30, 1.6752E-30, 1.6795E-30, 1.5010E-30, &
      1.5362E-30, 1.3545E-30, 1.3962E-30, 1.2366E-30, 1.2737E-30, 1.1330E-30, &
      1.1705E-30, 1.0387E-30, 1.0741E-30, 9.5726E-31, 9.0087E-31, 7.4356E-31, &
      6.5540E-31, 5.5895E-31, 5.1667E-31, 4.5190E-31, 4.3433E-31, 3.8633E-31, &
      4.3062E-31, 4.2324E-31, 4.1788E-31, 4.1281E-31, 4.0892E-31, 4.0424E-31, &
      3.9873E-31 /)
    REAL, PARAMETER :: b1_2_CO2(dim55) = (/ &
      -4.5089E-28, -4.7131E-28, -4.7814E-28, -5.1758E-28, -5.2489E-28, -5.5725E-28, &
      -5.5796E-28, -5.7138E-28, -5.6453E-28, -5.6307E-28, -5.5110E-28, -5.4049E-28, &
      -5.2923E-28, -5.1347E-28, -5.0394E-28, -4.8704E-28, -4.7968E-28, -4.6362E-28, &
      -4.5825E-28, -4.4225E-28, -4.3864E-28, -4.2389E-28, -4.2163E-28, -4.0758E-28, &
      -4.0636E-28, -3.9253E-28, -3.9264E-28, -3.7961E-28, -3.7991E-28, -3.6688E-28, &
      -3.6954E-28, -3.5537E-28, -3.5873E-28, -3.4547E-28, -3.4865E-28, -3.3627E-28, &
      -3.3966E-28, -3.2740E-28, -3.3078E-28, -3.1933E-28, -3.1367E-28, -2.9589E-28, &
      -2.8483E-28, -2.7152E-28, -2.6515E-28, -2.5460E-28, -2.5151E-28, -2.4249E-28, &
      -2.5137E-28, -2.4980E-28, -2.4859E-28, -2.4738E-28, -2.4641E-28, -2.4518E-28, &
      -2.4366E-28 /)

    jval_gp(ip_CO2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CO2(0) = &
          p2(a0_1_1_CO2(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CO2(i0(j,k)), &
          a0_2_1_CO2(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CO2(i0(j,k)), &
          a0_3_1_CO2(i0(j,k))*dlv2(j,k) + &
          a0_3_2_CO2(i0(j,k)), v3_du1(j,k))
        sig_CO2(1) = &
          (p1(b1_1_CO2(i1(j,k)),a1_1_CO2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CO2(i1(j,k)),a1_2_CO2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        dj = 0. &
          + 1.E-19 * r_m(j,k) * phi_la &
        + sig_CO2(0) * fint(j,k,0) &
        + sig_CO2(1) * fint(j,k,1)
        ! Lyman alpha, Inn et al, JCP 1953
        !mz_cb_120308 reduced from 2.E-19 to be consistent with literature

        jval_gp(ip_CO2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CO2

  ! **************************************************************************

  SUBROUTINE jval_cal_HCl(jrow)

    ! HCl -> H + Cl JPL 1997

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_HCl

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_HCl(dim58) = (/ &
      -6.0169E-21, -6.5052E-21, -6.9846E-21, -7.4909E-21, -8.0041E-21, -8.5038E-21, &
      -9.0154E-21, -9.4936E-21, -9.9919E-21, -1.0469E-20, -1.0939E-20, -1.1389E-20, &
      -1.1950E-20, -1.2622E-20, -1.2966E-20, -1.3363E-20, -1.3786E-20, -1.3987E-20, &
      -1.4186E-20, -1.4359E-20, -1.4272E-20, -1.4150E-20, -1.3986E-20, -1.3594E-20, &
      -1.3203E-20, -1.2671E-20, -1.2190E-20, -1.1752E-20, -1.1318E-20, -1.0891E-20, &
      -1.0462E-20, -1.0025E-20, -9.5794E-21, -9.1276E-21, -8.6831E-21, -8.2554E-21, &
      -7.8654E-21, -7.5205E-21, -7.2237E-21, -6.9753E-21, -6.7618E-21, -6.5612E-21, &
      -6.3539E-21, -6.1109E-21, -5.8130E-21, -5.4589E-21, -5.0447E-21, -4.6040E-21, &
      -4.1490E-21, -3.7111E-21, -3.3045E-21, -2.9292E-21, -2.5827E-21, -2.2559E-21, &
      -1.9486E-21, -1.6541E-21, -1.3618E-21, -1.1196E-21 /)
    REAL, PARAMETER :: a0_1_2_HCl(dim58) = (/ &
      3.9419E-19, 4.1577E-19, 4.3705E-19, 4.5963E-19, 4.8262E-19, 5.0511E-19, &
      5.2824E-19, 5.4995E-19, 5.7267E-19, 5.9453E-19, 6.1616E-19, 6.3691E-19, &
      6.6297E-19, 6.9430E-19, 7.1039E-19, 7.2905E-19, 7.4900E-19, 7.5852E-19, &
      7.6799E-19, 7.7627E-19, 7.7210E-19, 7.6619E-19, 7.5828E-19, 7.3921E-19, &
      7.2014E-19, 6.9405E-19, 6.7043E-19, 6.4877E-19, 6.2726E-19, 6.0598E-19, &
      5.8451E-19, 5.6260E-19, 5.4013E-19, 5.1727E-19, 4.9470E-19, 4.7288E-19, &
      4.5291E-19, 4.3519E-19, 4.1987E-19, 4.0700E-19, 3.9590E-19, 3.8543E-19, &
      3.7457E-19, 3.6179E-19, 3.4605E-19, 3.2729E-19, 3.0525E-19, 2.8172E-19, &
      2.5734E-19, 2.3378E-19, 2.1182E-19, 1.9148E-19, 1.7263E-19, 1.5479E-19, &
      1.3794E-19, 1.2175E-19, 1.0561E-19, 9.2194E-20 /)
    REAL, PARAMETER :: a0_2_1_HCl(dim58) = (/ &
      3.6428E-23, 3.9428E-23, 4.2286E-23, 4.5361E-23, 4.8530E-23, 5.1489E-23, &
      5.4703E-23, 5.7452E-23, 6.0632E-23, 6.3482E-23, 6.6370E-23, 6.8881E-23, &
      7.5216E-23, 8.6832E-23, 8.5602E-23, 8.7323E-23, 9.1297E-23, 8.9067E-23, &
      8.9046E-23, 9.0553E-23, 8.6379E-23, 8.3836E-23, 8.2254E-23, 7.6284E-23, &
      7.1812E-23, 6.4630E-23, 5.9400E-23, 5.5564E-23, 5.1862E-23, 4.8364E-23, &
      4.5007E-23, 4.1791E-23, 3.8657E-23, 3.5642E-23, 3.2749E-23, 3.0070E-23, &
      2.7659E-23, 2.5579E-23, 2.3766E-23, 2.2260E-23, 2.0967E-23, 1.9764E-23, &
      1.8600E-23, 1.7308E-23, 1.5849E-23, 1.4233E-23, 1.2477E-23, 1.0742E-23, &
      9.0250E-24, 7.4925E-24, 6.1548E-24, 5.0031E-24, 4.0095E-24, 3.1333E-24, &
      2.3982E-24, 1.7702E-24, 1.3104E-24, 1.0083E-24 /)
    REAL, PARAMETER :: a0_2_2_HCl(dim58) = (/ &
      -2.1067E-21, -2.2394E-21, -2.3662E-21, -2.5034E-21, -2.6454E-21, -2.7785E-21, &
      -2.9238E-21, -3.0486E-21, -3.1936E-21, -3.3241E-21, -3.4570E-21, -3.5730E-21, &
      -3.8669E-21, -4.4082E-21, -4.3507E-21, -4.4316E-21, -4.6192E-21, -4.5134E-21, &
      -4.5124E-21, -4.5845E-21, -4.3841E-21, -4.2615E-21, -4.1850E-21, -3.8948E-21, &
      -3.6766E-21, -3.3247E-21, -3.0673E-21, -2.8779E-21, -2.6943E-21, -2.5200E-21, &
      -2.3522E-21, -2.1907E-21, -2.0328E-21, -1.8802E-21, -1.7333E-21, -1.5966E-21, &
      -1.4732E-21, -1.3663E-21, -1.2727E-21, -1.1947E-21, -1.1275E-21, -1.0647E-21, &
      -1.0037E-21, -9.3575E-22, -8.5872E-22, -7.7307E-22, -6.7966E-22, -5.8697E-22, &
      -4.9497E-22, -4.1252E-22, -3.4028E-22, -2.7786E-22, -2.2381E-22, -1.7597E-22, &
      -1.3568E-22, -1.0114E-22, -7.5760E-23, -5.9026E-23 /)
    REAL, PARAMETER :: a0_3_1_HCl(dim58) = (/ &
      -6.7037E-26, -7.2866E-26, -7.8442E-26, -8.4402E-26, -9.0851E-26, -9.6505E-26, &
      -1.0332E-25, -1.0852E-25, -1.1555E-25, -1.2136E-25, -1.2767E-25, -1.3255E-25, &
      -1.5977E-25, -2.1933E-25, -1.9979E-25, -1.9935E-25, -2.1237E-25, -1.9345E-25, &
      -1.8901E-25, -1.9426E-25, -1.7421E-25, -1.6503E-25, -1.6220E-25, -1.4186E-25, &
      -1.2979E-25, -1.0754E-25, -9.4080E-26, -8.6524E-26, -7.9276E-26, -7.2583E-26, &
      -6.6263E-26, -6.0369E-26, -5.4719E-26, -4.9427E-26, -4.4395E-26, -3.9790E-26, &
      -3.5749E-26, -3.2329E-26, -2.9345E-26, -2.6956E-26, -2.4966E-26, -2.3154E-26, &
      -2.1523E-26, -1.9716E-26, -1.7734E-26, -1.5580E-26, -1.3305E-26, -1.1163E-26, &
      -9.0058E-27, -7.1769E-27, -5.6319E-27, -4.3406E-27, -3.2570E-27, -2.3305E-27, &
      -1.6326E-27, -1.0311E-27, -7.0779E-28, -4.8925E-28 /)
    REAL, PARAMETER :: a0_3_2_HCl(dim58) = (/ &
      3.8707E-24, 4.1284E-24, 4.3759E-24, 4.6417E-24, 4.9307E-24, 5.1851E-24, &
      5.4929E-24, 5.7293E-24, 6.0497E-24, 6.3159E-24, 6.6060E-24, 6.8316E-24, &
      8.0944E-24, 1.0870E-23, 9.9558E-24, 9.9351E-24, 1.0550E-23, 9.6527E-24, &
      9.4413E-24, 9.6921E-24, 8.7298E-24, 8.2873E-24, 8.1502E-24, 7.1618E-24, &
      6.5728E-24, 5.4828E-24, 4.8204E-24, 4.4472E-24, 4.0876E-24, 3.7544E-24, &
      3.4383E-24, 3.1424E-24, 2.8577E-24, 2.5899E-24, 2.3343E-24, 2.0994E-24, &
      1.8925E-24, 1.7167E-24, 1.5628E-24, 1.4390E-24, 1.3356E-24, 1.2409E-24, &
      1.1555E-24, 1.0605E-24, 9.5582E-25, 8.4166E-25, 7.2060E-25, 6.0623E-25, &
      4.9060E-25, 3.9220E-25, 3.0877E-25, 2.3878E-25, 1.7984E-25, 1.2925E-25, &
      9.1005E-26, 5.7922E-26, 4.0074E-26, 2.7967E-26 /)
    REAL, PARAMETER :: a1_1_HCl(dim55) = (/ &
      7.9738E-23, 8.0338E-23, 8.4877E-23, 8.1678E-23, 8.3100E-23, 7.7955E-23, &
      7.7732E-23, 7.2232E-23, 7.1414E-23, 6.6334E-23, 6.5449E-23, 6.1000E-23, &
      6.0227E-23, 5.6389E-23, 5.5767E-23, 5.2423E-23, 5.1947E-23, 4.9041E-23, &
      4.8670E-23, 4.6095E-23, 4.5795E-23, 4.3549E-23, 4.3300E-23, 4.1286E-23, &
      4.1100E-23, 3.9277E-23, 3.9150E-23, 3.7497E-23, 3.7383E-23, 3.5916E-23, &
      3.5813E-23, 3.4489E-23, 3.4385E-23, 3.3181E-23, 3.3121E-23, 3.2011E-23, &
      3.1947E-23, 3.0932E-23, 3.0879E-23, 2.9947E-23, 2.8858E-23, 2.6836E-23, &
      2.5226E-23, 2.3756E-23, 2.2503E-23, 2.1369E-23, 2.0307E-23, 1.9398E-23, &
      1.8280E-23, 1.7330E-23, 1.6438E-23, 1.5604E-23, 1.4819E-23, 1.4082E-23, &
      1.3390E-23 /)
    REAL, PARAMETER :: b1_1_HCl(dim55) = (/ &
      9.0750E-22, 9.0570E-22, 8.8074E-22, 9.0633E-22, 8.9140E-22, 9.5828E-22, &
      9.6173E-22, 1.0607E-21, 1.0775E-21, 1.1943E-21, 1.2169E-21, 1.3415E-21, &
      1.3651E-21, 1.4917E-21, 1.5138E-21, 1.6409E-21, 1.6601E-21, 1.7851E-21, &
      1.8020E-21, 1.9256E-21, 1.9407E-21, 2.0598E-21, 2.0736E-21, 2.1904E-21, &
      2.2017E-21, 2.3165E-21, 2.3248E-21, 2.4372E-21, 2.4453E-21, 2.5524E-21, &
      2.5601E-21, 2.6634E-21, 2.6718E-21, 2.7717E-21, 2.7768E-21, 2.8745E-21, &
      2.8803E-21, 2.9747E-21, 2.9797E-21, 3.0711E-21, 3.1806E-21, 3.4091E-21, &
      3.6111E-21, 3.8139E-21, 4.0025E-21, 4.1874E-21, 4.3738E-21, 4.5446E-21, &
      4.7689E-21, 4.9712E-21, 5.1723E-21, 5.3707E-21, 5.5675E-21, 5.7613E-21, &
      5.9520E-21 /)
    REAL, PARAMETER :: a1_2_HCl(dim55) = (/ &
      -3.3400E-25, -2.2700E-25, -2.6186E-25, -1.4961E-25, -1.7576E-25, -7.9447E-26, &
      -1.0449E-25, -3.0378E-26, -5.5763E-26, -9.3306E-28, -2.5644E-26, 1.5391E-26, &
      -7.4661E-27, 2.3836E-26, 3.1649E-27, 2.8348E-26, 9.7468E-27, 3.0017E-26, &
      1.3762E-26, 3.0626E-26, 1.6332E-26, 3.0147E-26, 1.7760E-26, 2.9506E-26, &
      1.8357E-26, 2.8585E-26, 1.8607E-26, 2.7418E-26, 1.8672E-26, 2.6159E-26, &
      1.8422E-26, 2.4907E-26, 1.8103E-26, 2.3773E-26, 1.7557E-26, 2.2585E-26, &
      1.7111E-26, 2.1515E-26, 1.6566E-26, 2.0505E-26, 1.7007E-26, 1.6060E-26, &
      1.4401E-26, 1.3672E-26, 1.2765E-26, 1.2116E-26, 1.1773E-26, 1.1103E-26, &
      1.2122E-26, 1.2488E-26, 1.2811E-26, 1.3065E-26, 1.3263E-26, 1.3389E-26, &
      1.3451E-26 /)
    REAL, PARAMETER :: b1_2_HCl(dim55) = (/ &
      -5.3597E-24, -5.6807E-24, -5.4890E-24, -6.3870E-24, -6.1124E-24, -7.3645E-24, &
      -6.9764E-24, -8.3103E-24, -7.7899E-24, -9.0510E-24, -8.4209E-24, -9.5698E-24, &
      -8.8727E-24, -9.9057E-24, -9.1719E-24, -1.0129E-23, -9.3755E-24, -1.0247E-23, &
      -9.5075E-24, -1.0317E-23, -9.5951E-24, -1.0327E-23, -9.6398E-24, -1.0321E-23, &
      -9.6466E-24, -1.0291E-23, -9.6374E-24, -1.0237E-23, -9.6199E-24, -1.0167E-23, &
      -9.5824E-24, -1.0088E-23, -9.5405E-24, -1.0011E-23, -9.4796E-24, -9.9221E-24, &
      -9.4267E-24, -9.8362E-24, -9.3636E-24, -9.7496E-24, -9.3980E-24, -9.2911E-24, &
      -9.0829E-24, -8.9823E-24, -8.8457E-24, -8.7400E-24, -8.6797E-24, -8.5539E-24, &
      -8.7580E-24, -8.8361E-24, -8.9089E-24, -8.9693E-24, -9.0190E-24, -9.0520E-24, &
      -9.0691E-24 /)

    jval_gp(ip_HCl)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_HCl(0) = &
          p2(a0_1_1_HCl(i0(j,k))*dlv2(j,k) + &
          a0_1_2_HCl(i0(j,k)), &
          a0_2_1_HCl(i0(j,k))*dlv2(j,k) + &
          a0_2_2_HCl(i0(j,k)), &
          a0_3_1_HCl(i0(j,k))*dlv2(j,k) + &
          a0_3_2_HCl(i0(j,k)), v3_du1(j,k))
        sig_HCl(1) = &
          (p1(b1_1_HCl(i1(j,k)),a1_1_HCl(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_HCl(i1(j,k)),a1_2_HCl(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        dj = 0. &
          + sig_HCl(0) * fint(j,k,0) &
          + sig_HCl(1) * fint(j,k,1)

        jval_gp(ip_HCl)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_HCl

  ! **************************************************************************

  SUBROUTINE jval_cal_CHCl2Br(jrow)

    ! CHCl2Br -> products ref = ???

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CHCl2Br

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CHCl2Br(dim58) = (/ &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00 /)
    REAL, PARAMETER :: a0_1_2_CHCl2Br(dim58) = (/ &
       9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19, &
       9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19, &
       9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19, &
       9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19, &
       9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19, &
       9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19, &
       9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19, &
       9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19, &
       9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19, &
       9.3800E-19,  9.3800E-19,  9.3800E-19,  9.3800E-19 /)
    REAL, PARAMETER :: a0_2_1_CHCl2Br(dim58) = (/ &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -3.0098E-35, 4.5139E-35, -6.0186E-35,  3.0093E-35, -0.0000E+00 , 1.5046E-35, &
 -0.0000E+00, -0.0000E+00,  1.5046E-35, -3.0090E-35, -1.5050E-35,  3.0089E-35, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00 /)
    REAL, PARAMETER :: a0_2_2_CHCl2Br(dim58) = (/ &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  1.3965E-33, -2.1095E-33,  2.8197E-33, -1.4234E-33, -3.0093E-36, -7.1620E-34, &
  0.0000E+00,  0.0000E+00, -7.2219E-34,  1.4533E-33,  7.2541E-34, -1.4683E-33, &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00 /)
    REAL, PARAMETER :: a1_1_CHCl2Br(dim55) = (/ &
  6.9179E-21,  6.1164E-21,  5.2465E-21,  4.4312E-21,  3.5942E-21,  2.9793E-21, &
  2.3305E-21,  1.9410E-21,  1.4960E-21,  1.2730E-21,  9.8519E-22,  8.6267E-22, &
  6.8019E-22,  6.1617E-22,  5.0169E-22,  4.6599E-22,  3.9465E-22,  3.7469E-22, &
  3.3081E-22,  3.1776E-22,  2.9290E-22,  2.8068E-22,  2.7094E-22,  2.5763E-22, &
  2.5736E-22,  2.4294E-22,  2.4977E-22,  2.3411E-22,  2.4423E-22,  2.2830E-22, &
  2.4263E-22,  2.2733E-22,  2.4187E-22,  2.2479E-22,  2.4272E-22,  2.2381E-22, &
  2.4391E-22,  2.2334E-22,  2.4530E-22,  2.2448E-22,  2.3870E-22,  2.3665E-22, &
  2.4212E-22,  2.3798E-22,  2.4175E-22,  2.3616E-22,  2.3736E-22,  2.3072E-22, &
  2.3534E-22,  2.2870E-22,  2.2134E-22,  2.1441E-22,  2.0712E-22,  1.9986E-22, &
  1.9289E-22 /)
    REAL, PARAMETER :: b1_1_CHCl2Br(dim55) = (/ &
  6.0667E-19,  6.0908E-19,  6.1386E-19,  6.2039E-19,  6.2917E-19,  6.3717E-19, &
  6.4722E-19,  6.5423E-19,  6.6336E-19,  6.6849E-19,  6.7583E-19,  6.7926E-19, &
  6.8482E-19,  6.8693E-19,  6.9100E-19,  6.9236E-19,  6.9524E-19,  6.9610E-19, &
  6.9810E-19,  6.9873E-19,  6.9998E-19,  7.0063E-19,  7.0117E-19,  7.0194E-19, &
  7.0196E-19,  7.0287E-19,  7.0242E-19,  7.0348E-19,  7.0277E-19,  7.0393E-19, &
  7.0285E-19,  7.0404E-19,  7.0287E-19,  7.0429E-19,  7.0276E-19,  7.0442E-19, &
  7.0260E-19,  7.0452E-19,  7.0242E-19,  7.0446E-19,  7.0303E-19,  7.0326E-19, &
  7.0258E-19,  7.0315E-19,  7.0258E-19,  7.0349E-19,  7.0328E-19,  7.0453E-19, &
  7.0360E-19,  7.0502E-19,  7.0668E-19,  7.0833E-19,  7.1015E-19,  7.1206E-19, &
  7.1398E-19  /)
    REAL, PARAMETER :: a1_2_CHCl2Br(dim55) = (/ &
  4.5917E-24,  9.5968E-24,  1.3317E-23,  1.4447E-23,  1.6320E-23,  1.4484E-23, &
  1.4985E-23,  1.1979E-23,  1.1810E-23,  8.9153E-24,  8.5786E-24,  6.2780E-24, &
  5.9683E-24,  4.3026E-24,  4.0363E-24,  2.9159E-24,  2.7067E-24,  1.9587E-24, &
  1.7782E-24,  1.3203E-24,  1.1437E-24,  8.9140E-25,  6.9348E-25,  5.9568E-25, &
  3.9618E-25,  3.8606E-25,  1.7509E-25,  2.5035E-25,  3.8224E-26,  1.5200E-25, &
 -6.7102E-26,  6.6300E-26, -1.3676E-25,  2.1757E-26, -1.8874E-25, -6.0988E-27, &
 -2.2498E-25, -2.8268E-26, -2.4219E-25, -4.5736E-26, -1.7863E-25, -1.3994E-25, &
 -1.6299E-25, -1.1014E-25, -1.2258E-25, -7.4708E-26, -7.9944E-26, -4.0817E-26, &
 -7.2554E-26, -4.1717E-26, -1.2654E-26,  1.1314E-26,  3.3496E-26,  5.2702E-26, &
  6.9016E-26 /)
    REAL, PARAMETER :: b1_2_CHCl2Br(dim55) = (/ &
 -4.7025E-22, -4.8527E-22, -5.0573E-22, -5.1477E-22, -5.3444E-22, -5.1056E-22, &
 -5.1833E-22, -4.6423E-22, -4.6076E-22, -3.9418E-22, -3.8560E-22, -3.2118E-22, &
 -3.1174E-22, -2.5677E-22, -2.4731E-22, -2.0474E-22, -1.9627E-22, -1.6410E-22, &
 -1.5589E-22, -1.3391E-22, -1.2499E-22, -1.1162E-22, -1.0064E-22, -9.4963E-23, &
 -8.2893E-23, -8.2255E-23, -6.8437E-23, -7.3554E-23, -5.8600E-23, -6.6905E-23, &
 -5.0363E-23, -6.0768E-23, -4.4422E-23, -5.7579E-23, -3.9582E-23, -5.5654E-23, &
 -3.5845E-23, -5.4139E-23, -3.3710E-23, -5.2962E-23, -3.9606E-23, -4.3979E-23, &
 -4.1086E-23, -4.8379E-23, -4.6506E-23, -5.4310E-23, -5.3391E-23, -6.0747E-23, &
 -5.4383E-23, -6.0952E-23, -6.7506E-23, -7.3210E-23, -7.8766E-23, -8.3818E-23, &
 -8.8312E-23 /)
    REAL, PARAMETER :: a2_CHCl2Br(dim55) = (/ &
 -3.6228E-21, -3.0688E-21, -2.4268E-21, -1.8152E-21, -1.3028E-21, -9.0920E-22, &
 -6.2592E-22, -4.2872E-22, -2.9508E-22, -2.0560E-22, -1.4576E-22, -1.0572E-22, &
 -7.8640E-23, -6.0040E-23, -4.7080E-23, -3.7840E-23, -3.1160E-23, -2.6160E-23, &
 -2.2360E-23, -1.9400E-23, -1.7040E-23, -1.5080E-23, -1.3520E-23, -1.2200E-23, &
 -1.1040E-23, -1.0080E-23, -9.2001E-24, -8.4400E-24, -7.7600E-24, -7.2000E-24, &
 -6.6399E-24, -6.1200E-24, -5.7200E-24, -5.2801E-24, -4.9600E-24, -4.5600E-24, &
 -4.2800E-24, -4.0000E-24, -3.7199E-24, -3.4800E-24, -2.8400E-24, -2.0400E-24, &
 -1.4640E-24, -1.0560E-24, -7.6000E-25, -5.4400E-25, -4.0002E-25, -2.7998E-25, &
 -2.0799E-25, -1.4401E-25, -1.1199E-25, -7.2023E-26, -5.5996E-26, -4.0002E-26, &
 -3.1989E-26/)
    REAL, PARAMETER :: b2_CHCl2Br(dim55) = (/ &
  4.5206E-20,  4.3544E-20,  4.0013E-20,  3.5121E-20,  2.9740E-20,  2.4624E-20, &
  2.0233E-20,  1.6683E-20,  1.3944E-20,  1.1885E-20,  1.0360E-20,  9.2385E-21, &
  8.4125E-21,  7.7987E-21,  7.3386E-21,  6.9875E-21,  6.7170E-21,  6.5020E-21, &
  6.3291E-21,  6.1870E-21,  6.0678E-21,  5.9639E-21,  5.8774E-21,  5.8008E-21, &
  5.7306E-21,  5.6701E-21,  5.6125E-21,  5.5608E-21,  5.5129E-21,  5.4720E-21, &
  5.4297E-21,  5.3892E-21,  5.3570E-21,  5.3204E-21,  5.2931E-21,  5.2579E-21, &
  5.2325E-21,  5.2065E-21,  5.1797E-21,  5.1562E-21,  5.0919E-21,  5.0015E-21, &
  4.9292E-21,  4.8729E-21,  4.8284E-21,  4.7932E-21,  4.7679E-21,  4.7453E-21, &
  4.7309E-21,  4.7173E-21,  4.7101E-21,  4.7005E-21,  4.6965E-21,  4.6923E-21, &
  4.6901E-21/)
    REAL, PARAMETER :: a3_CHCl2Br(dim55) = (/ &
 -6.6168E-24, -3.9608E-24, -2.1889E-24, -1.2973E-24, -8.5416E-25, -6.0928E-25, &
 -4.5867E-25, -3.5947E-25, -2.9095E-25, -2.3960E-25, -2.0181E-25, -1.7217E-25, &
 -1.4924E-25, -1.3026E-25, -1.1518E-25, -1.0236E-25, -9.1563E-26, -8.2635E-26, &
 -7.4999E-26, -6.8322E-26, -6.2223E-26, -5.7363E-26, -5.2911E-26, -4.8801E-26, &
 -4.5299E-26, -4.1953E-26, -3.9212E-26, -3.6472E-26, -3.4017E-26, -3.2021E-26, &
 -2.9794E-26, -2.7911E-26, -2.6324E-26, -2.4486E-26, -2.3117E-26, -2.1709E-26, &
 -2.0549E-26, -1.9178E-26, -1.8149E-26, -1.6924E-26, -1.4276E-26, -1.0647E-26, &
 -7.9743E-27, -5.9568E-27, -4.5188E-27, -3.3883E-27, -2.5677E-27, -1.9514E-27, &
 -1.4714E-27, -1.1297E-27, -8.5591E-28, -6.5035E-28, -5.1334E-28, -3.7680E-28, &
 -3.0790E-28 /)
    REAL, PARAMETER :: b3_CHCl2Br(dim55) = (/ &
       1.9762E-21,  1.8197E-21,  1.6118E-21,  1.4550E-21,  1.3513E-21,  1.2796E-21, &
       1.2267E-21,  1.1861E-21,  1.1540E-21,  1.1270E-21,  1.1049E-21,  1.0858E-21, &
       1.0698E-21,  1.0553E-21,  1.0430E-21,  1.0318E-21,  1.0217E-21,  1.0128E-21, &
       1.0047E-21,  9.9733E-22,  9.9020E-22,  9.8423E-22,  9.7851E-22,  9.7298E-22, &
       9.6807E-22,  9.6318E-22,  9.5902E-22,  9.5469E-22,  9.5068E-22,  9.4729E-22, &
       9.4339E-22,  9.3998E-22,  9.3701E-22,  9.3346E-22,  9.3074E-22,  9.2786E-22, &
       9.2542E-22,  9.2246E-22,  9.2017E-22,  9.1738E-22,  9.1119E-22,  9.0165E-22, &
       8.9384E-22,  8.8736E-22,  8.8231E-22,  8.7802E-22,  8.7466E-22,  8.7196E-22, &
       8.6972E-22,  8.6802E-22,  8.6658E-22,  8.6544E-22,  8.6464E-22,  8.6380E-22, &
       8.6336E-22 /)
    REAL, PARAMETER :: a4_CHCl2Br(4) = (/  5.1944E-22, -8.8093E-26,  1.7940E-29, -1.2373E-33 /)
    REAL, PARAMETER :: a5_CHCl2Br(4) = (/  5.3806E-23, -2.9007E-26,  5.5640E-30, -3.6226E-34 /)

    jval_gp(ip_CHCl2Br)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CHCl2Br(0) = &
          p1(a0_1_1_CHCl2Br(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CHCl2Br(i0(j,k)), &
          a0_2_1_CHCl2Br(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CHCl2Br(i0(j,k)),v3_du1(j,k))
        sig_CHCl2Br(1) = &
          (p1(b1_1_CHCl2Br(i1(j,k)),a1_1_CHCl2Br(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CHCl2Br(i1(j,k)),a1_2_CHCl2Br(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CHCl2Br(2) = &
          p1(b2_CHCl2Br(i2(j,k)), a2_CHCl2Br(i2(j,k)), &
          v3_du1(j,k))
        sig_CHCl2Br(3) = &
          p1(b3_CHCl2Br(i3(j,k)), a3_CHCl2Br(i3(j,k)), &
          v3_du2(j,k))
        sig_CHCl2Br(4) = &
          p3(a4_CHCl2Br(1),a4_CHCl2Br(2),a4_CHCl2Br(3), &
          a4_CHCl2Br(4),v3_du2(j,k))
        sig_CHCl2Br(5) = &
          p3(a5_CHCl2Br(1),a5_CHCl2Br(2),a5_CHCl2Br(3), &
          a5_CHCl2Br(4),v3_du2(j,k))
        dj = 0. &
          + sig_CHCl2Br(0) * fint(j,k,0) &
          + sig_CHCl2Br(1) * fint(j,k,1) &
          + sig_CHCl2Br(2) * fint(j,k,2) &
          + sig_CHCl2Br(3) * fint(j,k,3) &
          + sig_CHCl2Br(4) * fint(j,k,4) &
          + sig_CHCl2Br(5) * fint(j,k,5)

        jval_gp(ip_CHCl2Br)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,7))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CHCl2Br

  ! **************************************************************************

  SUBROUTINE jval_cal_CHClBr2(jrow)

    ! CHClBr2 -> products ref = ???

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CHClBr2

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CHClBr2(dim58) = (/ &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
      -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00 /)
    REAL, PARAMETER :: a0_1_2_CHClBr2(dim58) = (/ &
       2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18, &
       2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18, &
       2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18, &
       2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18, &
       2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18, &
       2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18, &
       2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18, &
       2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18, &
       2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18, &
       2.8300E-18,  2.8300E-18,  2.8300E-18,  2.8300E-18 /)
    REAL, PARAMETER :: a0_2_1_CHClBr2(dim58) = (/ &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00,  6.0185E-35, -1.2037E-34,  6.0186E-35, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00,  1.2037E-34, -1.2036E-34, -6.0200E-35,  6.0178E-35, &
  6.0192E-35, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00/)
    REAL, PARAMETER :: a0_2_2_CHClBr2(dim58) = (/ &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  0.0000E+00, -2.8046E-33,  5.6455E-33, -2.8408E-33,  0.0000E+00,  0.0000E+00, &
  0.0000E+00,  0.0000E+00, -5.7775E-33,  5.8254E-33,  2.9137E-33, -2.9367E-33, &
 -2.9374E-33,  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35, &
  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35, &
  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35, &
  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35, &
  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35, &
  1.2037E-35,  1.2037E-35,  1.2037E-35,  1.2037E-35/)
    REAL, PARAMETER :: a1_1_CHClBr2(dim55) = (/ &
  3.8395E-20,  3.6599E-20,  3.5074E-20,  3.2118E-20,  2.9492E-20,  2.6484E-20, &
  2.3766E-20,  2.1309E-20,  1.8934E-20,  1.7170E-20,  1.5232E-20,  1.3970E-20, &
  1.2390E-20,  1.1574E-20,  1.0261E-20,  9.7214E-21,  8.6143E-21,  8.2770E-21, &
  7.3285E-21,  7.1270E-21,  6.2901E-21,  6.1986E-21,  5.4381E-21,  5.4443E-21, &
  4.7371E-21,  4.7954E-21,  4.1558E-21,  4.2609E-21,  3.6690E-21,  3.8028E-21, &
  3.2592E-21,  3.3958E-21,  2.9166E-21,  3.0568E-21,  2.5970E-21,  2.7854E-21, &
  2.3244E-21,  2.5136E-21,  2.1089E-21,  2.2871E-21,  1.8392E-21,  1.5202E-21, &
  1.1882E-21,  1.0150E-21,  7.9679E-22,  6.9807E-22,  5.4526E-22,  4.9058E-22, &
  3.0108E-22,  2.4648E-22,  1.9824E-22,  1.5862E-22,  1.2287E-22,  9.2016E-23, &
  6.7498E-23/)
    REAL, PARAMETER :: b1_1_CHClBr2(dim55) = (/ &
  1.8734E-18,  1.8788E-18,  1.8872E-18,  1.9109E-18,  1.9384E-18,  1.9775E-18, &
  2.0197E-18,  2.0639E-18,  2.1126E-18,  2.1531E-18,  2.2026E-18,  2.2379E-18, &
  2.2861E-18,  2.3130E-18,  2.3596E-18,  2.3801E-18,  2.4250E-18,  2.4395E-18, &
  2.4826E-18,  2.4923E-18,  2.5346E-18,  2.5394E-18,  2.5816E-18,  2.5813E-18, &
  2.6241E-18,  2.6204E-18,  2.6623E-18,  2.6551E-18,  2.6969E-18,  2.6871E-18, &
  2.7281E-18,  2.7175E-18,  2.7561E-18,  2.7444E-18,  2.7837E-18,  2.7671E-18, &
  2.8089E-18,  2.7913E-18,  2.8299E-18,  2.8125E-18,  2.8575E-18,  2.8935E-18, &
  2.9352E-18,  2.9591E-18,  2.9919E-18,  3.0080E-18,  3.0348E-18,  3.0451E-18, &
  3.0831E-18,  3.0947E-18,  3.1056E-18,  3.1150E-18,  3.1240E-18,  3.1321E-18, &
  3.1389E-18/)
    REAL, PARAMETER :: a1_2_CHClBr2(dim55) = (/ &
 -6.8630E-23, -2.6992E-23, -1.5418E-23,  1.3751E-23,  2.3916E-23,  3.8002E-23, &
  4.4263E-23,  4.6560E-23,  5.0180E-23,  4.5664E-23,  4.8100E-23,  4.1134E-23, &
  4.3618E-23,  3.5637E-23,  3.8412E-23,  3.0591E-23,  3.3627E-23,  2.6216E-23, &
  2.9410E-23,  2.2627E-23,  2.5904E-23,  1.9513E-23,  2.3013E-23,  1.6913E-23, &
  2.0547E-23,  1.4956E-23,  1.8296E-23,  1.3178E-23,  1.6475E-23,  1.1631E-23, &
  1.4818E-23,  1.0451E-23,  1.3302E-23,  9.3686E-24,  1.2159E-23,  8.2996E-24, &
  1.1053E-23,  7.5486E-24,  1.0079E-23,  6.7991E-24,  7.4560E-24,  5.5795E-24, &
  4.9534E-24,  3.7833E-24,  3.4896E-24,  2.7015E-24,  2.5673E-24,  2.0012E-24, &
  2.3663E-24,  2.0552E-24,  1.8020E-24,  1.5834E-24,  1.4011E-24,  1.2435E-24, &
  1.0994E-24/)
    REAL, PARAMETER :: b1_2_CHClBr2(dim55) = (/ &
 -2.5600E-21, -2.6849E-21, -2.7486E-21, -2.9819E-21, -3.0887E-21, -3.2718E-21, &
 -3.3688E-21, -3.4102E-21, -3.4844E-21, -3.3805E-21, -3.4426E-21, -3.2476E-21, &
 -3.3233E-21, -3.0600E-21, -3.1585E-21, -2.8613E-21, -2.9842E-21, -2.6656E-21, &
 -2.8109E-21, -2.4853E-21, -2.6508E-21, -2.3121E-21, -2.5063E-21, -2.1526E-21, &
 -2.3724E-21, -2.0202E-21, -2.2390E-21, -1.8909E-21, -2.1233E-21, -1.7697E-21, &
 -2.0104E-21, -1.6697E-21, -1.8992E-21, -1.5728E-21, -1.8113E-21, -1.4717E-21, &
 -1.7209E-21, -1.3950E-21, -1.6366E-21, -1.3152E-21, -1.3812E-21, -1.1692E-21, &
 -1.0906E-21, -9.2913E-22, -8.8492E-22, -7.5646E-22, -7.3291E-22, -6.2648E-22, &
 -6.9968E-22, -6.3343E-22, -5.7633E-22, -5.2431E-22, -4.7864E-22, -4.3720E-22, &
 -3.9747E-22/)
    REAL, PARAMETER :: a2_CHClBr2(dim55) = (/ &
 -1.4060E-20, -1.1876E-20, -9.3712E-21, -6.9972E-21, -5.0156E-21, -3.4996E-21, &
 -2.4072E-21, -1.6500E-21, -1.1364E-21, -7.9280E-22, -5.6280E-22, -4.0880E-22, &
 -3.0440E-22, -2.3320E-22, -1.8280E-22, -1.4720E-22, -1.2080E-22, -1.0200E-22, &
 -8.6800E-23, -7.5600E-23, -6.6000E-23, -5.8800E-23, -5.2400E-23, -4.7200E-23, &
 -4.3200E-23, -3.8800E-23, -3.6000E-23, -3.2400E-23, -3.0400E-23, -2.7600E-23, &
 -2.6000E-23, -2.3600E-23, -2.2400E-23, -2.0400E-23, -1.9200E-23, -1.7600E-23, &
 -1.6800E-23, -1.5200E-23, -1.4399E-23, -1.3600E-23, -1.1040E-23, -7.8400E-24, &
 -5.6800E-24, -4.0801E-24, -2.9600E-24, -2.1600E-24, -1.5199E-24, -1.0401E-24, &
 -8.0004E-25, -6.3990E-25, -4.0002E-25, -2.4001E-25, -2.4001E-25, -1.6001E-25, &
 -8.0004E-26 /)
    REAL, PARAMETER :: b2_CHClBr2(dim55) = (/ &
       1.7045E-19,  1.6390E-19,  1.5012E-19,  1.3113E-19,  1.1032E-19,  9.0616E-20, &
       7.3684E-20,  6.0054E-20,  4.9525E-20,  4.1622E-20,  3.5757E-20,  3.1445E-20, &
       2.8261E-20,  2.5912E-20,  2.4122E-20,  2.2770E-20,  2.1700E-20,  2.0892E-20, &
       2.0200E-20,  1.9663E-20,  1.9178E-20,  1.8796E-20,  1.8441E-20,  1.8140E-20, &
       1.7898E-20,  1.7620E-20,  1.7437E-20,  1.7192E-20,  1.7051E-20,  1.6847E-20, &
       1.6726E-20,  1.6539E-20,  1.6442E-20,  1.6276E-20,  1.6174E-20,  1.6033E-20, &
       1.5960E-20,  1.5812E-20,  1.5735E-20,  1.5657E-20,  1.5400E-20,  1.5038E-20, &
       1.4767E-20,  1.4546E-20,  1.4377E-20,  1.4247E-20,  1.4135E-20,  1.4045E-20, &
       1.3996E-20,  1.3962E-20,  1.3908E-20,  1.3870E-20,  1.3870E-20,  1.3849E-20, &
       1.3827E-20 /)
    REAL, PARAMETER :: a3_CHClBr2(dim55) = (/ &
 -1.8906E-23, -1.0895E-23, -5.7316E-24, -3.2364E-24, -2.0490E-24, -1.4222E-24, &
 -1.0508E-24, -8.1308E-25, -6.4522E-25, -5.2884E-25, -4.4163E-25, -3.7310E-25, &
 -3.2175E-25, -2.7901E-25, -2.4474E-25, -2.1568E-25, -1.9339E-25, -1.7280E-25, &
 -1.5754E-25, -1.4212E-25, -1.2820E-25, -1.1815E-25, -1.0959E-25, -9.9315E-26, &
 -9.2308E-26, -8.5617E-26, -8.0480E-26, -7.3630E-26, -6.8376E-26, -6.5068E-26, &
 -5.9931E-26, -5.6507E-26, -5.1283E-26, -4.9657E-26, -4.6232E-26, -4.2735E-26, &
 -4.1097E-26, -3.7670E-26, -3.5960E-26, -3.4188E-26, -2.8073E-26, -2.0883E-26, &
 -1.5400E-26, -1.1640E-26, -8.5588E-27, -6.5022E-27, -4.7929E-27, -3.7659E-27, &
 -2.7379E-27, -2.3966E-27, -1.3693E-27, -1.3688E-27, -1.0270E-27, -6.8480E-28, &
 -3.4211E-28 /)
    REAL, PARAMETER :: b3_CHClBr2(dim55) = (/ &
       4.3164E-21,  3.8443E-21,  3.2384E-21,  2.7998E-21,  2.5217E-21,  2.3383E-21, &
       2.2079E-21,  2.1105E-21,  2.0320E-21,  1.9707E-21,  1.9198E-21,  1.8757E-21, &
       1.8396E-21,  1.8072E-21,  1.7791E-21,  1.7536E-21,  1.7328E-21,  1.7123E-21, &
       1.6963E-21,  1.6791E-21,  1.6629E-21,  1.6505E-21,  1.6395E-21,  1.6257E-21, &
       1.6159E-21,  1.6061E-21,  1.5983E-21,  1.5875E-21,  1.5789E-21,  1.5733E-21, &
       1.5643E-21,  1.5581E-21,  1.5483E-21,  1.5452E-21,  1.5384E-21,  1.5312E-21, &
       1.5278E-21,  1.5204E-21,  1.5166E-21,  1.5125E-21,  1.4982E-21,  1.4793E-21, &
       1.4633E-21,  1.4512E-21,  1.4404E-21,  1.4326E-21,  1.4256E-21,  1.4211E-21, &
       1.4163E-21,  1.4146E-21,  1.4092E-21,  1.4092E-21,  1.4072E-21,  1.4051E-21, &
       1.4029E-21 /)
    REAL, PARAMETER :: a4_CHClBr2(4) = (/  7.9252E-22, -1.4297E-25,  2.9563E-29, -2.0567E-33 /)
    REAL, PARAMETER :: a5_CHClBr2(4) = (/  8.0737E-23, -4.3536E-26,  8.3519E-30, -5.4382E-34 /)

    jval_gp(ip_CHClBr2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CHClBr2(0) = &
          p1(a0_1_1_CHClBr2(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CHClBr2(i0(j,k)), &
          a0_2_1_CHClBr2(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CHClBr2(i0(j,k)),v3_du1(j,k))
        sig_CHClBr2(1) = &
          (p1(b1_1_CHClBr2(i1(j,k)),a1_1_CHClBr2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CHClBr2(i1(j,k)),a1_2_CHClBr2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CHClBr2(2) = &
          p1(b2_CHClBr2(i2(j,k)), a2_CHClBr2(i2(j,k)), &
          v3_du1(j,k))
        sig_CHClBr2(3) = &
          p1(b3_CHClBr2(i3(j,k)), a3_CHClBr2(i3(j,k)), &
          v3_du2(j,k))
        sig_CHClBr2(4) = &
          p3(a4_CHClBr2(1),a4_CHClBr2(2),a4_CHClBr2(3), &
          a4_CHClBr2(4),v3_du2(j,k))
        sig_CHClBr2(5) = &
          p3(a5_CHClBr2(1),a5_CHClBr2(2),a5_CHClBr2(3), &
          a5_CHClBr2(4),v3_du2(j,k))
        dj = 0. &
          + sig_CHClBr2(0) * fint(j,k,0) &
          + sig_CHClBr2(1) * fint(j,k,1) &
          + sig_CHClBr2(2) * fint(j,k,2) &
          + sig_CHClBr2(3) * fint(j,k,3) &
          + sig_CHClBr2(4) * fint(j,k,4) &
          + sig_CHClBr2(5) * fint(j,k,5)

        jval_gp(ip_CHClBr2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,7))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CHClBr2

  ! **************************************************************************

  SUBROUTINE jval_cal_CH2ClBr(jrow)

    ! CH2ClBr -> products ref = ???

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH2ClBr

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CH2ClBr(dim58) = (/ &
 -1.1929E-21, -1.3277E-21, -1.3498E-21, -1.3880E-21, -1.4947E-21, -1.5535E-21, &
 -1.5075E-21, -1.5231E-21, -1.5788E-21, -1.5267E-21, -1.5057E-21, -1.4171E-21, &
 -1.5698E-21, -1.6347E-21, -1.4305E-21, -1.2656E-21, -1.0313E-21, -7.9564E-22, &
 -4.6429E-22, -1.1063E-22,  2.6831E-22,  6.9631E-22,  1.1661E-21,  1.6702E-21, &
  2.3246E-21,  2.8553E-21,  3.4435E-21,  4.0417E-21,  4.8604E-21,  5.4953E-21, &
  6.1869E-21,  6.8999E-21,  7.6156E-21,  8.2429E-21,  8.7777E-21,  9.2780E-21, &
  9.9603E-21,  1.0384E-20,  1.1046E-20,  1.1605E-20,  1.2159E-20,  1.2726E-20, &
  1.3318E-20,  1.3828E-20,  1.4084E-20,  1.4138E-20,  1.4129E-20,  1.3582E-20, &
  1.3080E-20,  1.2344E-20,  1.1513E-20,  1.0649E-20,  9.7817E-21,  8.8213E-21, &
  7.8197E-21,  6.7592E-21,  5.6575E-21,  4.6884E-21 /)
    REAL, PARAMETER :: a0_1_2_CH2ClBr(dim58) = (/ &
  1.2245E-18,  1.2304E-18,  1.2314E-18,  1.2331E-18,  1.2379E-18,  1.2405E-18, &
  1.2385E-18,  1.2392E-18,  1.2417E-18,  1.2393E-18,  1.2384E-18,  1.2343E-18, &
  1.2414E-18,  1.2444E-18,  1.2348E-18,  1.2271E-18,  1.2160E-18,  1.2048E-18, &
  1.1891E-18,  1.1722E-18,  1.1540E-18,  1.1333E-18,  1.1106E-18,  1.0861E-18, &
  1.0542E-18,  1.0282E-18,  9.9923E-19,  9.6968E-19,  9.2907E-19,  8.9746E-19, &
  8.6287E-19,  8.2708E-19,  7.9101E-19,  7.5927E-19,  7.3210E-19,  7.0659E-19, &
  6.7165E-19,  6.4986E-19,  6.1572E-19,  5.8675E-19,  5.5796E-19,  5.2835E-19, &
  4.9731E-19,  4.7053E-19,  4.5699E-19,  4.5415E-19,  4.5463E-19,  4.8383E-19, &
  5.1074E-19,  5.5032E-19,  5.9520E-19,  6.4205E-19,  6.8920E-19,  7.4164E-19, &
  7.9653E-19,  8.5486E-19,  9.1567E-19,  9.6936E-19 /)
    REAL, PARAMETER :: a0_2_1_CH2ClBr(dim58) = (/ &
  5.7540E-24,  6.9247E-24,  7.2020E-24,  7.4683E-24,  8.2419E-24,  9.2416E-24, &
  9.0156E-24,  9.5835E-24,  1.0493E-23,  1.0444E-23,  1.1174E-23,  1.1232E-23, &
  1.4000E-23,  1.8019E-23,  1.5899E-23,  1.5765E-23,  1.5323E-23,  1.4157E-23, &
  1.2925E-23,  1.2135E-23,  1.0641E-23,  9.3612E-24,  8.1817E-24,  6.6683E-24, &
  4.7210E-24,  3.8508E-24,  2.7115E-24,  1.6644E-24, -4.3524E-25, -1.5675E-24, &
 -3.0833E-24, -4.7403E-24, -6.4127E-24, -8.0565E-24, -9.2124E-24, -1.0315E-23, &
 -1.2202E-23, -1.2875E-23, -1.4720E-23, -1.5760E-23, -1.6886E-23, -1.7860E-23, &
 -1.9131E-23, -2.0268E-23, -2.0197E-23, -2.0111E-23, -2.0092E-23, -1.8198E-23, &
 -1.7248E-23, -1.5582E-23, -1.3992E-23, -1.2117E-23, -1.0700E-23, -8.9676E-24, &
 -7.3787E-24, -5.9010E-24, -4.6926E-24, -3.7184E-24 /)
    REAL, PARAMETER :: a0_2_2_CH2ClBr(dim58) = (/ &
 -2.2602E-22, -2.7776E-22, -2.9008E-22, -3.0196E-22, -3.3661E-22, -3.8160E-22, &
 -3.7138E-22, -3.9717E-22, -4.3866E-22, -4.3639E-22, -4.6997E-22, -4.7267E-22, &
 -6.0107E-22, -7.8837E-22, -6.8918E-22, -6.8285E-22, -6.6201E-22, -6.0671E-22, &
 -5.4807E-22, -5.1035E-22, -4.3860E-22, -3.7693E-22, -3.1984E-22, -2.4629E-22, &
 -1.5126E-22, -1.0862E-22, -5.2567E-23, -8.4055E-25,  1.0330E-22,  1.5969E-22, &
  2.3548E-22,  3.1866E-22,  4.0295E-22,  4.8612E-22,  5.4484E-22,  6.0110E-22, &
  6.9767E-22,  7.3230E-22,  8.2747E-22,  8.8138E-22,  9.3989E-22,  9.9078E-22, &
  1.0573E-21,  1.1172E-21,  1.1134E-21,  1.1089E-21,  1.1079E-21,  1.0067E-21, &
  9.5580E-22,  8.6615E-22,  7.8030E-22,  6.7869E-22,  6.0156E-22,  5.0699E-22, &
  4.1992E-22,  3.3864E-22,  2.7195E-22,  2.1797E-22 /)
    REAL, PARAMETER :: a1_1_CH2ClBr(dim55) = (/ &
  1.8526E-20,  1.7518E-20,  1.6645E-20,  1.5128E-20,  1.3830E-20,  1.2364E-20, &
  1.1081E-20,  9.9217E-21,  8.8455E-21,  8.0127E-21,  7.1574E-21,  6.5841E-21, &
  5.9071E-21,  5.5168E-21,  4.9737E-21,  4.7088E-21,  4.2615E-21,  4.0797E-21, &
  3.7033E-21,  3.5816E-21,  3.2545E-21,  3.1790E-21,  2.8880E-21,  2.8460E-21, &
  2.5867E-21,  2.5670E-21,  2.3352E-21,  2.3276E-21,  2.1157E-21,  2.1242E-21, &
  1.9292E-21,  1.9609E-21,  1.7737E-21,  1.8066E-21,  1.6394E-21,  1.6643E-21, &
  1.5185E-21,  1.5489E-21,  1.4080E-21,  1.4598E-21,  1.2664E-21,  1.1092E-21, &
  9.5592E-22,  8.6007E-22,  7.5366E-22,  6.9526E-22,  6.1491E-22,  5.7583E-22, &
  4.8316E-22,  4.4001E-22,  4.0729E-22,  3.7059E-22,  3.4292E-22,  3.1657E-22, &
  2.9077E-22 /)
    REAL, PARAMETER :: b1_1_CH2ClBr(dim55) = (/ &
  5.1005E-19,  5.1308E-19,  5.1787E-19,  5.3001E-19,  5.4364E-19,  5.6271E-19, &
  5.8258E-19,  6.0346E-19,  6.2552E-19,  6.4467E-19,  6.6648E-19,  6.8254E-19, &
  7.0319E-19,  7.1606E-19,  7.3534E-19,  7.4541E-19,  7.6353E-19,  7.7134E-19, &
  7.8847E-19,  7.9431E-19,  8.1083E-19,  8.1483E-19,  8.3098E-19,  8.3342E-19, &
  8.4911E-19,  8.5035E-19,  8.6553E-19,  8.6605E-19,  8.8098E-19,  8.8037E-19, &
  8.9509E-19,  8.9261E-19,  9.0768E-19,  9.0495E-19,  9.1925E-19,  9.1706E-19, &
  9.3026E-19,  9.2743E-19,  9.4088E-19,  9.3581E-19,  9.5524E-19,  9.7300E-19, &
  9.9224E-19,  1.0055E-18,  1.0215E-18,  1.0310E-18,  1.0451E-18,  1.0525E-18, &
  1.0710E-18,  1.0802E-18,  1.0876E-18,  1.0963E-18,  1.1033E-18,  1.1102E-18, &
  1.1173E-18 /)
    REAL, PARAMETER :: a1_2_CH2ClBr(dim55) = (/ &
 -2.8575E-23, -9.3453E-24, -4.2290E-24,  9.0433E-24,  1.2964E-23,  1.8932E-23, &
  2.0912E-23,  2.1635E-23,  2.2395E-23,  2.0438E-23,  2.0826E-23,  1.7876E-23, &
  1.8299E-23,  1.5198E-23,  1.5777E-23,  1.2845E-23,  1.3586E-23,  1.0924E-23, &
  1.1781E-23,  9.3502E-24,  1.0311E-23,  8.0840E-24,  9.0878E-24,  7.0514E-24, &
  8.0603E-24,  6.2021E-24,  7.1865E-24,  5.5138E-24,  6.4806E-24,  4.9138E-24, &
  5.8552E-24,  4.3457E-24,  5.2888E-24,  3.9145E-24,  4.7924E-24,  3.5904E-24, &
  4.3713E-24,  3.2483E-24,  4.0412E-24,  2.8991E-24,  3.0817E-24,  2.3714E-24, &
  2.1019E-24,  1.6721E-24,  1.5460E-24,  1.2412E-24,  1.1892E-24,  9.7132E-25, &
  1.1246E-24,  1.0271E-24,  9.3142E-25,  8.7080E-25,  7.9669E-25,  7.4503E-25, &
  6.9628E-25 /)
    REAL, PARAMETER :: b1_2_CH2ClBr(dim55) = (/ &
 -1.2405E-21, -1.2982E-21, -1.3264E-21, -1.4326E-21, -1.4737E-21, -1.5513E-21, &
 -1.5820E-21, -1.5950E-21, -1.6106E-21, -1.5656E-21, -1.5755E-21, -1.4929E-21, &
 -1.5058E-21, -1.4034E-21, -1.4240E-21, -1.3126E-21, -1.3426E-21, -1.2281E-21, &
 -1.2671E-21, -1.1504E-21, -1.1990E-21, -1.0809E-21, -1.1366E-21, -1.0185E-21, &
 -1.0796E-21, -9.6250E-22, -1.0270E-21, -9.1323E-22, -9.8139E-22, -8.6702E-22, &
 -9.3809E-22, -8.2035E-22, -8.9627E-22, -7.8221E-22, -8.5727E-22, -7.5149E-22, &
 -8.2216E-22, -7.1772E-22, -7.9344E-22, -6.8152E-22, -6.9987E-22, -6.1960E-22, &
 -5.8578E-22, -5.2647E-22, -5.0749E-22, -4.5781E-22, -4.4868E-22, -4.0773E-22, &
 -4.3845E-22, -4.1769E-22, -3.9612E-22, -3.8169E-22, -3.6312E-22, -3.4954E-22, &
 -3.3611E-22 /)
    REAL, PARAMETER :: a2_CH2ClBr(dim55) = (/ &
 -7.4284E-22, -6.2376E-22, -4.8736E-22, -3.5852E-22, -2.5172E-22, -1.7087E-22, &
 -1.1342E-22, -7.4284E-23, -4.8380E-23, -3.1524E-23, -2.0676E-23, -1.3712E-23, &
 -9.2440E-24, -6.3640E-24, -4.4920E-24, -3.2640E-24, -2.4400E-24, -1.8800E-24, &
 -1.4920E-24, -1.2200E-24, -1.0160E-24, -8.6400E-25, -7.4800E-25, -6.6000E-25, &
 -5.8400E-25, -5.2400E-25, -4.7200E-25, -4.2800E-25, -3.8800E-25, -3.6000E-25, &
 -3.2800E-25, -3.0400E-25, -2.8000E-25, -2.5600E-25, -2.4000E-25, -2.2400E-25, &
 -2.0800E-25, -1.9200E-25, -1.7600E-25, -1.6800E-25, -1.3600E-25, -9.6800E-26, &
 -6.9601E-26, -4.9600E-26, -3.6000E-26, -2.5600E-26, -1.8400E-26, -1.3600E-26, &
 -9.5996E-27, -7.2005E-27, -4.8003E-27, -3.1999E-27, -3.1999E-27, -1.5994E-27, &
 -1.6004E-27 /)
    REAL, PARAMETER :: b2_CH2ClBr(dim55) = (/ &
       7.9521E-21,  7.5949E-21,  6.8447E-21,  5.8140E-21,  4.6926E-21,  3.6415E-21, &
       2.7510E-21,  2.0466E-21,  1.5156E-21,  1.1279E-21,  8.5125E-22,  6.5626E-22, &
       5.1998E-22,  4.2494E-22,  3.5849E-22,  3.1182E-22,  2.7845E-22,  2.5437E-22, &
       2.3672E-22,  2.2366E-22,  2.1336E-22,  2.0530E-22,  1.9886E-22,  1.9376E-22, &
       1.8916E-22,  1.8538E-22,  1.8198E-22,  1.7898E-22,  1.7616E-22,  1.7412E-22, &
       1.7170E-22,  1.6983E-22,  1.6790E-22,  1.6591E-22,  1.6454E-22,  1.6313E-22, &
       1.6168E-22,  1.6020E-22,  1.5867E-22,  1.5788E-22,  1.5467E-22,  1.5024E-22, &
       1.4682E-22,  1.4406E-22,  1.4202E-22,  1.4032E-22,  1.3906E-22,  1.3816E-22, &
       1.3735E-22,  1.3684E-22,  1.3630E-22,  1.3592E-22,  1.3592E-22,  1.3550E-22, &
       1.3550E-22 /)
    REAL, PARAMETER :: a3_CH2ClBr(dim55) = (/ &
 -1.9522E-25, -8.8263E-26, -3.1073E-26, -9.6291E-27, -2.7942E-27, -7.8034E-28, &
 -2.1270E-28, -5.6999E-29, -1.5075E-29, -3.9485E-30, -1.0263E-30, -2.6492E-31, &
 -6.8030E-32, -1.7391E-32, -4.4272E-33, -1.1234E-33, -2.8412E-34, -7.1646E-35, &
 -1.8046E-35, -4.5312E-36, -1.1336E-36, -2.8404E-37, -7.0937E-38, -1.7688E-38, &
 -4.3970E-39, -1.0953E-39, -2.7208E-40, -6.7503E-41, -1.6702E-41, -4.1422E-42, &
 -1.0243E-42, -2.5364E-43, -6.3058E-44, -1.5414E-44, -4.2039E-45, -1.4013E-45, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, -0.0000E+00, &
 -0.0000E+00 /)
    REAL, PARAMETER :: b3_CH2ClBr(dim55) = (/ &
  1.9265E-23,  1.2962E-23,  6.2504E-24,  2.4810E-24,  8.8020E-25,  2.9089E-25, &
  9.1619E-26,  2.7863E-26,  8.2459E-27,  2.3897E-27,  6.8090E-28,  1.9121E-28, &
  5.3069E-29,  1.4581E-29,  3.9701E-30,  1.0730E-30,  2.8794E-31,  7.6793E-32, &
  2.0394E-32,  5.3854E-33,  1.4135E-33,  3.7077E-34,  9.6735E-35,  2.5153E-35, &
  6.5099E-36,  1.6856E-36,  4.3458E-37,  1.1176E-37,  2.8630E-38,  7.3421E-39, &
  1.8755E-39,  4.7916E-40,  1.2278E-40,  3.0925E-41,  8.6488E-42,  2.9385E-42, &
  1.8217E-44,  4.2039E-45,  1.4013E-45,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00, &
  0.0000E+00 /)

    jval_gp(ip_CH2ClBr)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH2ClBr(0) = &
          p1(a0_1_1_CH2ClBr(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CH2ClBr(i0(j,k)), &
          a0_2_1_CH2ClBr(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CH2ClBr(i0(j,k)),v3_du1(j,k))
        sig_CH2ClBr(1) = &
          (p1(b1_1_CH2ClBr(i1(j,k)),a1_1_CH2ClBr(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CH2ClBr(i1(j,k)),a1_2_CH2ClBr(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CH2ClBr(2) = &
          p1(b2_CH2ClBr(i2(j,k)), a2_CH2ClBr(i2(j,k)), &
          v3_du1(j,k))
        sig_CH2ClBr(3) = &
          p1(b3_CH2ClBr(i3(j,k)), a3_CH2ClBr(i3(j,k)), &
          v3_du2(j,k))
        dj = 0. &
          + sig_CH2ClBr(0) * fint(j,k,0) &
          + sig_CH2ClBr(1) * fint(j,k,1) &
          + sig_CH2ClBr(2) * fint(j,k,2) &
          + sig_CH2ClBr(3) * fint(j,k,3)

        jval_gp(ip_CH2ClBr)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,7))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CH2ClBr

  ! **************************************************************************

  SUBROUTINE jval_cal_CH2Br2(jrow)

    ! CH2Br2 -> products ref = ???

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CH2Br2

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CH2Br2(dim58) = (/ &
  3.8159E-21,  4.1952E-21,  4.6588E-21,  4.9824E-21,  5.5601E-21,  6.0194E-21, &
  6.5637E-21,  7.2320E-21,  7.8145E-21,  8.4923E-21,  9.2978E-21,  9.9191E-21, &
  1.1465E-20,  1.3966E-20,  1.4193E-20,  1.5140E-20,  1.6602E-20,  1.6809E-20, &
  1.7691E-20,  1.9126E-20,  1.9521E-20,  2.0421E-20,  2.1902E-20,  2.2261E-20, &
  2.3097E-20,  2.2849E-20,  2.3038E-20,  2.3557E-20,  2.3928E-20,  2.3955E-20, &
  2.3674E-20,  2.3261E-20,  2.2502E-20,  2.1692E-20,  2.0698E-20,  1.9689E-20, &
  1.8561E-20,  1.7598E-20,  1.6619E-20,  1.5679E-20,  1.4682E-20,  1.3737E-20, &
  1.2686E-20,  1.1488E-20,  1.0156E-20,  8.6380E-21,  7.1436E-21,  5.5618E-21, &
  4.1422E-21,  2.9082E-21,  2.0288E-21,  9.5748E-22,  3.4120E-22, -1.9749E-22, &
 -5.9042E-22, -7.9100E-22, -8.8208E-22, -8.1429E-22 /)
    REAL, PARAMETER :: a0_1_2_CH2Br2(dim58) = (/ &
  1.9396E-18,  1.9229E-18,  1.9023E-18,  1.8878E-18,  1.8620E-18,  1.8413E-18, &
  1.8167E-18,  1.7863E-18,  1.7598E-18,  1.7287E-18,  1.6917E-18,  1.6630E-18, &
  1.5913E-18,  1.4747E-18,  1.4641E-18,  1.4196E-18,  1.3506E-18,  1.3407E-18, &
  1.2988E-18,  1.2302E-18,  1.2112E-18,  1.1678E-18,  1.0962E-18,  1.0787E-18, &
  1.0379E-18,  1.0500E-18,  1.0408E-18,  1.0152E-18,  9.9673E-19,  9.9538E-19, &
  1.0094E-18,  1.0301E-18,  1.0684E-18,  1.1094E-18,  1.1599E-18,  1.2114E-18, &
  1.2691E-18,  1.3186E-18,  1.3691E-18,  1.4178E-18,  1.4697E-18,  1.5190E-18, &
  1.5741E-18,  1.6371E-18,  1.7074E-18,  1.7879E-18,  1.8674E-18,  1.9518E-18, &
  2.0279E-18,  2.0943E-18,  2.1418E-18,  2.1999E-18,  2.2334E-18,  2.2628E-18, &
  2.2843E-18,  2.2954E-18,  2.3004E-18,  2.2966E-18 /)
    REAL, PARAMETER :: a0_2_1_CH2Br2(dim58) = (/ &
 -9.9732E-24, -1.0952E-23, -1.2240E-23, -1.2877E-23, -1.4309E-23, -1.5435E-23, &
 -1.7108E-23, -1.9258E-23, -2.0561E-23, -2.2678E-23, -2.5698E-23, -2.7014E-23, &
 -3.9155E-23, -6.7468E-23, -6.0240E-23, -6.2843E-23, -7.2888E-23, -6.6261E-23, &
 -6.7998E-23, -7.6643E-23, -7.1453E-23, -7.2869E-23, -8.0659E-23, -7.6192E-23, &
 -7.7021E-23, -6.7888E-23, -6.4718E-23, -6.6259E-23, -6.7237E-23, -6.7207E-23, &
 -6.6116E-23, -6.4821E-23, -6.2337E-23, -5.9747E-23, -5.6709E-23, -5.3687E-23, &
 -4.9959E-23, -4.7534E-23, -4.4657E-23, -4.2003E-23, -3.8905E-23, -3.6567E-23, &
 -3.3838E-23, -3.0547E-23, -2.7181E-23, -2.3200E-23, -1.9416E-23, -1.5421E-23, &
 -1.1708E-23, -9.4461E-24, -6.8563E-24, -4.2002E-24, -2.8272E-24, -1.6523E-24, &
 -5.7492E-25, -3.1882E-25,  2.6183E-25,  5.4943E-25 /)
    REAL, PARAMETER :: a0_2_2_CH2Br2(dim58) = (/ &
  8.8439E-22,  9.2765E-22,  9.8485E-22,  1.0132E-21,  1.0774E-21,  1.1281E-21, &
  1.2037E-21,  1.3013E-21,  1.3607E-21,  1.4577E-21,  1.5966E-21,  1.6574E-21, &
  2.2207E-21,  3.5401E-21,  3.2019E-21,  3.3242E-21,  3.7983E-21,  3.4842E-21, &
  3.5669E-21,  3.9801E-21,  3.7310E-21,  3.7992E-21,  4.1763E-21,  3.9592E-21, &
  3.9996E-21,  3.5521E-21,  3.3962E-21,  3.4723E-21,  3.5208E-21,  3.5193E-21, &
  3.4647E-21,  3.3998E-21,  3.2746E-21,  3.1435E-21,  2.9892E-21,  2.8350E-21, &
  2.6442E-21,  2.5195E-21,  2.3711E-21,  2.2336E-21,  2.0725E-21,  1.9505E-21, &
  1.8074E-21,  1.6343E-21,  1.4567E-21,  1.2457E-21,  1.0443E-21,  8.3101E-22, &
  6.3195E-22,  5.1028E-22,  3.7043E-22,  2.2647E-22,  1.5178E-22,  8.7636E-23, &
  2.8594E-23,  1.4508E-23, -1.7543E-23, -3.3476E-23 /)
    REAL, PARAMETER :: a1_1_CH2Br2(dim55) = (/ &
  3.3477E-20,  2.9109E-20,  2.3976E-20,  1.9691E-20,  1.4872E-20,  1.1745E-20, &
  8.0462E-21,  6.2012E-21,  3.6185E-21,  2.6922E-21,  9.8095E-22,  6.2709E-22, &
 -4.9201E-22, -5.7266E-22, -1.3077E-21, -1.2255E-21, -1.7213E-21, -1.5994E-21, &
 -1.9207E-21, -1.7741E-21, -1.9912E-21, -1.8544E-21, -1.9982E-21, -1.8522E-21, &
 -1.9481E-21, -1.8253E-21, -1.8903E-21, -1.7925E-21, -1.7984E-21, -1.7236E-21, &
 -1.7176E-21, -1.6740E-21, -1.6392E-21, -1.5906E-21, -1.5602E-21, -1.5267E-21, &
 -1.4807E-21, -1.4667E-21, -1.4076E-21, -1.3945E-21, -1.2851E-21, -1.1512E-21, &
 -1.0195E-21, -9.2295E-22, -8.2256E-22, -7.5383E-22, -6.7467E-22, -6.2783E-22, &
 -5.2817E-22, -4.7589E-22, -4.3784E-22, -3.9495E-22, -3.6245E-22, -3.3086E-22, &
 -3.0225E-22 /)
    REAL, PARAMETER :: b1_1_CH2Br2(dim55) = (/ &
  2.0652E-18,  2.0783E-18,  2.1065E-18,  2.1408E-18,  2.1914E-18,  2.2320E-18, &
  2.2894E-18,  2.3226E-18,  2.3755E-18,  2.3968E-18,  2.4405E-18,  2.4504E-18, &
  2.4845E-18,  2.4872E-18,  2.5133E-18,  2.5101E-18,  2.5302E-18,  2.5250E-18, &
  2.5396E-18,  2.5325E-18,  2.5435E-18,  2.5363E-18,  2.5442E-18,  2.5358E-18, &
  2.5416E-18,  2.5338E-18,  2.5381E-18,  2.5315E-18,  2.5319E-18,  2.5264E-18, &
  2.5259E-18,  2.5226E-18,  2.5198E-18,  2.5157E-18,  2.5131E-18,  2.5102E-18, &
  2.5060E-18,  2.5047E-18,  2.4991E-18,  2.4978E-18,  2.4868E-18,  2.4716E-18, &
  2.4551E-18,  2.4418E-18,  2.4267E-18,  2.4155E-18,  2.4016E-18,  2.3928E-18, &
  2.3728E-18,  2.3617E-18,  2.3531E-18,  2.3429E-18,  2.3347E-18,  2.3264E-18, &
  2.3186E-18 /)
    REAL, PARAMETER :: a1_2_CH2Br2(dim55) = (/ &
  4.4122E-23,  6.5990E-23,  9.0946E-23,  9.0295E-23,  1.0438E-22,  8.7952E-23, &
  9.3802E-23,  7.1570E-23,  7.3925E-23,  5.3070E-23,  5.4172E-23,  3.7069E-23, &
  3.8112E-23,  2.5284E-23,  2.6373E-23,  1.6782E-23,  1.7932E-23,  1.1204E-23, &
  1.2112E-23,  7.2387E-24,  8.0873E-24,  4.5621E-24,  5.3351E-24,  2.5916E-24, &
  3.2163E-24,  1.3967E-24,  1.8102E-24,  6.0509E-25,  6.9396E-25, -1.4187E-25, &
  3.0747E-26, -4.2770E-25, -5.5252E-25, -8.1666E-25, -8.7659E-25, -9.8377E-25, &
 -1.1779E-24, -1.0596E-24, -1.3656E-24, -1.2223E-24, -1.4348E-24, -1.4139E-24, &
 -1.4451E-24, -1.2980E-24, -1.2871E-24, -1.1212E-24, -1.1174E-24, -9.4692E-25, &
 -1.1420E-24, -1.0834E-24, -1.0023E-24, -9.5349E-25, -8.8892E-25, -8.3461E-25, &
 -7.8802E-25 /)
    REAL, PARAMETER :: b1_2_CH2Br2(dim55) = (/ &
 -2.2723E-21, -2.3379E-21, -2.4751E-21, -2.4699E-21, -2.6178E-21, -2.4043E-21, &
 -2.4949E-21, -2.0947E-21, -2.1430E-21, -1.6634E-21, -1.6915E-21, -1.2126E-21, &
 -1.2444E-21, -8.2107E-22, -8.5972E-22, -4.9528E-22, -5.4183E-22, -2.5253E-22, &
 -2.9386E-22, -5.9930E-23, -1.0278E-22,  8.4051E-23,  4.1151E-23,  2.0027E-22, &
  1.6248E-22,  2.7712E-22,  2.5003E-22,  3.3198E-22,  3.2571E-22,  3.8673E-22, &
  3.7369E-22,  4.0945E-22,  4.1950E-22,  4.4142E-22,  4.4655E-22,  4.5598E-22, &
  4.7355E-22,  4.6255E-22,  4.9177E-22,  4.7772E-22,  4.9908E-22,  4.9672E-22, &
  5.0063E-22,  4.8034E-22,  4.7869E-22,  4.5166E-22,  4.5100E-22,  4.1894E-22, &
  4.5804E-22,  4.4556E-22,  4.2729E-22,  4.1566E-22,  3.9949E-22,  3.8521E-22, &
  3.7237E-22 /)
    REAL, PARAMETER :: a2_CH2Br2(dim55) = (/ &
 -4.9264E-21, -4.1344E-21, -3.2276E-21, -2.3720E-21, -1.6636E-21, -1.1274E-21, &
 -7.4676E-22, -4.8788E-22, -3.1664E-22, -2.0552E-22, -1.3404E-22, -8.8360E-23, &
 -5.9120E-23, -4.0360E-23, -2.8240E-23, -2.0280E-23, -1.5040E-23, -1.1492E-23, &
 -9.0480E-24, -7.3280E-24, -6.0880E-24, -5.1680E-24, -4.4640E-24, -3.9160E-24, &
 -3.4720E-24, -3.1160E-24, -2.8080E-24, -2.5560E-24, -2.3320E-24, -2.1360E-24, &
 -1.9680E-24, -1.8120E-24, -1.6760E-24, -1.5520E-24, -1.4400E-24, -1.3400E-24, &
 -1.2440E-24, -1.1560E-24, -1.0800E-24, -1.0040E-24, -8.2240E-25, -5.8640E-25, &
 -4.2080E-25, -3.0320E-25, -2.1760E-25, -1.5760E-25, -1.1280E-25, -8.1603E-26, &
 -5.9199E-26, -4.2401E-26, -3.0397E-26, -2.1600E-26, -1.6002E-26, -1.1200E-26, &
 -8.7969E-27 /)
    REAL, PARAMETER :: b2_CH2Br2(dim55) = (/ &
  5.2464E-20,  5.0088E-20,  4.5101E-20,  3.8256E-20,  3.0817E-20,  2.3848E-20, &
  1.7947E-20,  1.3287E-20,  9.7770E-21,  7.2213E-21,  5.3985E-21,  4.1195E-21, &
  3.2277E-21,  2.6086E-21,  2.1783E-21,  1.8758E-21,  1.6636E-21,  1.5111E-21, &
  1.3999E-21,  1.3173E-21,  1.2547E-21,  1.2059E-21,  1.1668E-21,  1.1351E-21, &
  1.1082E-21,  1.0858E-21,  1.0656E-21,  1.0485E-21,  1.0327E-21,  1.0184E-21, &
  1.0057E-21,  9.9351E-22,  9.8256E-22,  9.7227E-22,  9.6269E-22,  9.5389E-22, &
  9.4520E-22,  9.3702E-22,  9.2976E-22,  9.2231E-22,  9.0406E-22,  8.7739E-22, &
  8.5661E-22,  8.4038E-22,  8.2750E-22,  8.1772E-22,  8.0986E-22,  8.0399E-22, &
  7.9950E-22,  7.9592E-22,  7.9321E-22,  7.9112E-22,  7.8972E-22,  7.8846E-22, &
  7.8779E-22/)
    REAL, PARAMETER :: a3_CH2Br2(dim55) = (/ &
 -1.1677E-24, -6.8196E-25, -3.6242E-25, -2.0378E-25, -1.2578E-25, -8.3279E-26, &
 -5.7609E-26, -4.0904E-26, -2.9548E-26, -2.1621E-26, -1.5972E-26, -1.1877E-26, &
 -8.8756E-27, -6.6570E-27, -5.0012E-27, -3.7640E-27, -2.8338E-27, -2.1341E-27, &
 -1.6092E-27, -1.2128E-27, -9.1214E-28, -6.8870E-28, -5.1885E-28, -3.9101E-28, &
 -2.9415E-28, -2.2207E-28, -1.6738E-28, -1.2618E-28, -9.4974E-29, -7.1747E-29, &
 -5.4098E-29, -4.0810E-29, -3.0735E-29, -2.3233E-29, -1.7533E-29, -1.3210E-29, &
 -9.9897E-30, -7.5411E-30, -5.6952E-30, -4.2933E-30, -2.0014E-30, -4.9232E-31, &
 -1.2112E-31, -2.9805E-32, -7.3256E-33, -1.7981E-33, -4.4116E-34, -1.0810E-34, &
 -2.6453E-35, -6.4728E-36, -1.5823E-36, -3.8644E-37, -9.4406E-38, -2.3046E-38, &
 -5.6225E-39 /)
    REAL, PARAMETER :: b3_CH2Br2(dim55) = (/ &
  1.6641E-22,  1.3779E-22,  1.0029E-22,  7.2406E-23,  5.4137E-23,  4.1700E-23, &
  3.2688E-23,  2.5848E-23,  2.0534E-23,  1.6362E-23,  1.3059E-23,  1.0425E-23, &
  8.3187E-24,  6.6324E-24,  5.2772E-24,  4.1923E-24,  3.3223E-24,  2.6270E-24, &
  2.0747E-24,  1.6345E-24,  1.2829E-24,  1.0087E-24,  7.9027E-25,  6.1841E-25, &
  4.8255E-25,  3.7723E-25,  2.9412E-25,  2.2911E-25,  1.7804E-25,  1.3867E-25, &
  1.0773E-25,  8.3653E-26,  6.4812E-26,  5.0343E-26,  3.9017E-26,  3.0176E-26, &
  2.3400E-26,  1.8106E-26,  1.4006E-26,  1.0811E-26,  5.4537E-27,  1.4854E-27, &
  4.0081E-28,  1.0734E-28,  2.8520E-29,  7.5257E-30,  1.9752E-30,  5.1554E-31, &
  1.3389E-31,  3.4652E-32,  8.9326E-33,  2.2946E-33,  5.8812E-34,  1.5030E-34, &
  3.8311E-35/)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_CH2Br2(dim58) = (/ &
  1.2211E-03,  1.2211E-03,  1.2211E-03,  1.4221E-03,  1.3703E-03,  1.3183E-03, &
  2.2318E-03,  2.2274E-03,  2.3270E-03,  2.9820E-03,  3.2814E-03,  3.2238E-03, &
  3.8771E-03,  3.7165E-03,  4.4648E-03,  4.0019E-03,  4.8474E-03,  4.9845E-03, &
  5.5226E-03,  5.4078E-03,  5.9409E-03,  6.5686E-03,  5.9999E-03,  5.9262E-03, &
  5.2029E-03,  4.8281E-03,  2.7249E-03,  1.4651E-03, -2.2164E-05, -1.8574E-03, &
 -3.2840E-03, -3.7560E-03, -4.0404E-03, -4.0178E-03, -3.7596E-03, -3.0566E-03, &
 -2.5480E-03, -1.8544E-03, -2.1398E-03, -2.4702E-03, -3.8738E-03, -4.5903E-03, &
 -6.0819E-03, -7.5267E-03, -8.5315E-03, -8.9541E-03, -8.0149E-03, -6.8927E-03, &
 -6.4509E-03, -5.3305E-03, -3.5863E-03, -3.0515E-03, -2.0832E-03, -1.5017E-03, &
 -1.9397E-04,  9.1951E-04,  2.0833E-03,  3.0037E-03 /)
    REAL, PARAMETER :: c0_1_2_CH2Br2(dim58) = (/ &
 -5.3291E-02, -5.3291E-02, -5.3291E-02, -6.2255E-02, -5.9935E-02, -5.7592E-02, &
 -9.8886E-02, -9.8685E-02, -1.0322E-01, -1.3323E-01, -1.4700E-01, -1.4433E-01, &
 -1.7465E-01, -1.6717E-01, -2.0218E-01, -1.8043E-01, -2.2034E-01, -2.2684E-01, &
 -2.5245E-01, -2.4696E-01, -2.7255E-01, -3.0281E-01, -2.7528E-01, -2.7170E-01, &
 -2.3640E-01, -2.1803E-01, -1.1456E-01, -5.2324E-02,  2.1443E-02,  1.1284E-01, &
  1.8417E-01,  2.0786E-01,  2.2219E-01,  2.2105E-01,  2.0794E-01,  1.7208E-01, &
  1.4604E-01,  1.1039E-01,  1.2512E-01,  1.4223E-01,  2.1522E-01,  2.5262E-01, &
  3.3078E-01,  4.0678E-01,  4.5983E-01,  4.8223E-01,  4.3226E-01,  3.7234E-01, &
  3.4866E-01,  2.8838E-01,  1.9419E-01,  1.6520E-01,  1.1253E-01, 8.0782E-02, &
  9.1181E-03, -5.2123E-02, -1.1637E-01, -1.6736E-01  /)
    REAL, PARAMETER :: c1_CH2Br2(2) = (/ 1.00, -0.15 /)
    REAL, PARAMETER :: c2_CH2Br2(2) = (/ 1.12,  2.82 /)
    REAL, PARAMETER :: c3_CH2Br2(2) = (/ 1.46,  6.61 /)

    jval_gp(ip_CH2Br2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CH2Br2(0) = &
          p1(1.,c0_1_1_CH2Br2(i0(j,k))*dlv2(j,k) + &
          c0_1_2_CH2Br2(i0(j,k)),tnorm_sr(j,k)) * &
          p1(a0_1_1_CH2Br2(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CH2Br2(i0(j,k)), &
          a0_2_1_CH2Br2(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CH2Br2(i0(j,k)),v3_du1(j,k))
        sig_CH2Br2(1) = &
          p1(c1_CH2Br2(1),c1_CH2Br2(2),tnorm(j,k)) * &
          (p1(b1_1_CH2Br2(i1(j,k)),a1_1_CH2Br2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CH2Br2(i1(j,k)),a1_2_CH2Br2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CH2Br2(2) = &
          p1(c2_CH2Br2(1),c2_CH2Br2(2),tnorm(j,k)) * &
          p1(b2_CH2Br2(i2(j,k)), a2_CH2Br2(i2(j,k)), &
          v3_du1(j,k))
        sig_CH2Br2(3) = &
          p1(c3_CH2Br2(1),c3_CH2Br2(2),tnorm(j,k)) * &
          p1(b3_CH2Br2(i3(j,k)), a3_CH2Br2(i3(j,k)), &
          v3_du2(j,k))
        dj = 0. &
          + sig_CH2Br2(0) * fint(j,k,0) &
          + sig_CH2Br2(1) * fint(j,k,1) &
          + sig_CH2Br2(2) * fint(j,k,2) &
          + sig_CH2Br2(3) * fint(j,k,3)

        jval_gp(ip_CH2Br2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,7))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CH2Br2

  ! **************************************************************************

  SUBROUTINE jval_cal_CHBr3(jrow)

    ! CHBr3 -> products ref = ???

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_CHBr3

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_CHBr3(dim58) = (/ &
 -4.5713E-20, -4.9060E-20, -5.2446E-20, -5.5864E-20, -5.9251E-20, -6.2535E-20, &
 -6.5763E-20, -6.8902E-20, -7.1716E-20, -7.4486E-20, -7.7043E-20, -7.9640E-20, &
 -8.5497E-20, -9.7836E-20, -9.4784E-20, -9.5102E-20, -9.7655E-20, -9.3738E-20, &
 -9.2113E-20, -9.1842E-20, -8.6083E-20, -8.2044E-20, -7.8674E-20, -7.1201E-20, &
 -6.4999E-20, -5.6452E-20, -4.9370E-20, -4.3385E-20, -3.7270E-20, -3.1140E-20, &
 -2.5052E-20, -1.9041E-20, -1.3076E-20, -7.3776E-21, -1.8761E-21,  3.1922E-21, &
  7.8235E-21,  1.2244E-20,  1.6243E-20,  1.9992E-20,  2.3533E-20,  2.6970E-20, &
  3.0218E-20,  3.3454E-20,  3.6150E-20,  3.8528E-20,  4.0124E-20,  4.0866E-20, &
  4.0996E-20,  4.0280E-20,  3.9126E-20,  3.7342E-20,  3.5431E-20,  3.2930E-20, &
  3.0115E-20,  2.6758E-20,  2.2760E-20,  1.9035E-20 /)
    REAL, PARAMETER :: a0_1_2_CHBr3(dim58) = (/ &
  6.4257E-18,  6.5736E-18,  6.7240E-18,  6.8764E-18,  7.0282E-18,  7.1759E-18, &
  7.3218E-18,  7.4643E-18,  7.5926E-18,  7.7195E-18,  7.8372E-18,  7.9571E-18, &
  8.2289E-18,  8.8039E-18,  8.6611E-18,  8.6760E-18,  8.7965E-18,  8.6108E-18, &
  8.5335E-18,  8.5205E-18,  8.2441E-18,  8.0494E-18,  7.8863E-18,  7.5232E-18, &
  7.2205E-18,  6.8017E-18,  6.4532E-18,  6.1576E-18,  5.8543E-18,  5.5490E-18, &
  5.2446E-18,  4.9428E-18,  4.6422E-18,  4.3539E-18,  4.0744E-18,  3.8159E-18, &
  3.5788E-18,  3.3516E-18,  3.1452E-18,  2.9510E-18,  2.7669E-18,  2.5875E-18, &
  2.4173E-18,  2.2471E-18,  2.1047E-18,  1.9787E-18,  1.8938E-18,  1.8542E-18, &
  1.8472E-18,  1.8857E-18,  1.9481E-18,  2.0447E-18,  2.1487E-18,  2.2852E-18, &
  2.4395E-18,  2.6242E-18,  2.8448E-18,  3.0512E-18 /)
    REAL, PARAMETER :: a0_2_1_CHBr3(dim58) = (/ &
  1.9796E-22,  2.1288E-22,  2.2807E-22,  2.4359E-22,  2.5850E-22,  2.7402E-22, &
  2.8868E-22,  3.0382E-22,  3.1736E-22,  3.3120E-22,  3.4344E-22,  3.5728E-22, &
  4.2427E-22,  5.8284E-22,  5.1690E-22,  5.0539E-22,  5.2838E-22,  4.7158E-22, &
  4.5374E-22,  4.5838E-22,  4.0548E-22,  3.8047E-22,  3.6932E-22,  3.2051E-22, &
  2.9069E-22,  2.4076E-22,  2.0932E-22,  1.9039E-22,  1.7117E-22,  1.5191E-22, &
  1.3305E-22,  1.1461E-22,  9.6325E-23,  7.9060E-23,  6.2335E-23,  4.7408E-23, &
  3.4072E-23,  2.1338E-23,  1.0869E-23,  1.2700E-24, -6.9151E-24, -1.4816E-23, &
 -2.1360E-23, -2.8422E-23, -3.3180E-23, -3.8077E-23, -4.0933E-23, -4.1839E-23, &
 -4.2648E-23, -4.0903E-23, -3.9272E-23, -3.6116E-23, -3.3351E-23, -2.9532E-23, &
 -2.5396E-23, -2.1146E-23, -1.6730E-23, -1.3839E-23 /)
    REAL, PARAMETER :: a0_2_2_CHBr3(dim58) = (/ &
 -1.0682E-20, -1.1341E-20, -1.2016E-20, -1.2708E-20, -1.3376E-20, -1.4074E-20, &
 -1.4737E-20, -1.5424E-20, -1.6042E-20, -1.6676E-20, -1.7239E-20, -1.7878E-20, &
 -2.0986E-20, -2.8376E-20, -2.5290E-20, -2.4749E-20, -2.5834E-20, -2.3142E-20, &
 -2.2293E-20, -2.2514E-20, -1.9975E-20, -1.8770E-20, -1.8230E-20, -1.5858E-20, &
 -1.4402E-20, -1.1956E-20, -1.0409E-20, -9.4739E-21, -8.5208E-21, -7.5615E-21, &
 -6.6184E-21, -5.6925E-21, -4.7712E-21, -3.8976E-21, -3.0480E-21, -2.2867E-21, &
 -1.6039E-21, -9.4937E-22, -4.0916E-22,  8.8064E-23,  5.1369E-22,  9.2610E-22, &
  1.2690E-21,  1.6405E-21,  1.8917E-21,  2.1512E-21,  2.3032E-21,  2.3516E-21, &
  2.3949E-21,  2.3011E-21,  2.2130E-21,  2.0419E-21,  1.8915E-21,  1.6830E-21, &
  1.4563E-21,  1.2226E-21,  9.7884E-22,  8.1867E-22 /)
    REAL, PARAMETER :: a1_1_CHBr3(dim55) = (/ &
  5.3408E-20,  4.5766E-20,  3.6471E-20,  2.9101E-20,  2.0442E-20,  1.5201E-20, &
  8.5893E-21,  5.6417E-21,  1.1319E-21, -2.1126E-22, -3.0945E-21, -3.4846E-21, &
 -5.2910E-21, -5.2048E-21, -6.2793E-21, -5.9777E-21, -6.6168E-21, -6.2474E-21, &
 -6.5769E-21, -6.2275E-21, -6.3440E-21, -6.0431E-21, -6.0371E-21, -5.7777E-21, &
 -5.6946E-21, -5.4781E-21, -5.2978E-21, -5.1692E-21, -4.9689E-21, -4.8632E-21, &
 -4.6225E-21, -4.5687E-21, -4.3080E-21, -4.2929E-21, -4.0249E-21, -4.0231E-21, &
 -3.7561E-21, -3.7867E-21, -3.5046E-21, -3.5613E-21, -3.1504E-21, -2.7494E-21, &
 -2.3455E-21, -2.0959E-21, -1.8028E-21, -1.6414E-21, -1.4233E-21, -1.3155E-21, &
 -1.0569E-21, -9.4732E-22, -8.5610E-22, -7.7490E-22, -7.0228E-22, -6.3875E-22, &
 -5.7982E-22 /)
    REAL, PARAMETER :: b1_1_CHBr3(dim55) = (/ &
  4.5821E-18,  4.6050E-18,  4.6562E-18,  4.7151E-18,  4.8060E-18,  4.8742E-18, &
  4.9766E-18,  5.0297E-18,  5.1222E-18,  5.1530E-18,  5.2266E-18,  5.2375E-18, &
  5.2926E-18,  5.2897E-18,  5.3279E-18,  5.3164E-18,  5.3423E-18,  5.3264E-18, &
  5.3414E-18,  5.3246E-18,  5.3305E-18,  5.3146E-18,  5.3142E-18,  5.2992E-18, &
  5.2942E-18,  5.2805E-18,  5.2687E-18,  5.2600E-18,  5.2459E-18,  5.2381E-18, &
  5.2200E-18,  5.2158E-18,  5.1948E-18,  5.1935E-18,  5.1706E-18,  5.1705E-18, &
  5.1463E-18,  5.1491E-18,  5.1222E-18,  5.1278E-18,  5.0865E-18,  5.0412E-18, &
  4.9905E-18,  4.9560E-18,  4.9119E-18,  4.8856E-18,  4.8473E-18,  4.8271E-18, &
  4.7752E-18,  4.7519E-18,  4.7313E-18,  4.7120E-18,  4.6938E-18,  4.6771E-18, &
  4.6608E-18 /)
    REAL, PARAMETER :: a1_2_CHBr3(dim55) = (/ &
  9.6947E-23,  1.3009E-22,  1.7778E-22,  1.7061E-22,  1.9797E-22,  1.6294E-22, &
  1.7523E-22,  1.3073E-22,  1.3550E-22,  9.4761E-23,  9.6615E-23,  6.4144E-23, &
  6.5600E-23,  4.1429E-23,  4.2579E-23,  2.5374E-23,  2.6468E-23,  1.4547E-23, &
  1.5263E-23,  7.3504E-24,  7.5429E-24,  2.4837E-24,  2.3636E-24, -5.7010E-25, &
 -1.0749E-24, -2.7523E-24, -3.6208E-24, -3.9801E-24, -5.0345E-24, -4.8008E-24, &
 -6.0678E-24, -5.2538E-24, -6.6761E-24, -5.4591E-24, -6.9330E-24, -5.5284E-24, &
 -7.0904E-24, -5.4816E-24, -7.1094E-24, -5.3488E-24, -6.1400E-24, -5.2631E-24, &
 -5.0698E-24, -4.1879E-24, -4.0540E-24, -3.3230E-24, -3.2507E-24, -2.6648E-24, &
 -3.1433E-24, -2.8562E-24, -2.5879E-24, -2.3541E-24, -2.1520E-24, -1.9720E-24, &
 -1.8165E-24 /)
    REAL, PARAMETER :: b1_2_CHBr3(dim55) = (/ &
 -3.6266E-21, -3.7260E-21, -3.9884E-21, -3.9310E-21, -4.2183E-21, -3.7628E-21, &
 -3.9534E-21, -3.1525E-21, -3.2501E-21, -2.3131E-21, -2.3604E-21, -1.4512E-21, &
 -1.4957E-21, -6.9799E-22, -7.3882E-22, -8.5061E-23, -1.2937E-22,  3.8323E-22, &
  3.5069E-22,  7.3048E-22,  7.2076E-22,  9.8890E-22,  9.9557E-22,  1.1657E-21, &
  1.1963E-21,  1.3019E-21,  1.3588E-21,  1.3833E-21,  1.4576E-21,  1.4405E-21, &
  1.5362E-21,  1.4727E-21,  1.5872E-21,  1.4862E-21,  1.6122E-21,  1.4886E-21, &
  1.6300E-21,  1.4803E-21,  1.6358E-21,  1.4632E-21,  1.5428E-21,  1.4437E-21, &
  1.4194E-21,  1.2977E-21,  1.2776E-21,  1.1584E-21,  1.1457E-21,  1.0356E-21, &
  1.1315E-21,  1.0704E-21,  1.0099E-21,  9.5422E-22,  9.0359E-22,  8.5624E-22, &
  8.1342E-22 /)
    REAL, PARAMETER :: a2_CHBr3(dim55) = (/ &
 -3.3880E-20, -2.8672E-20, -2.2676E-20, -1.6980E-20, -1.2204E-20, -8.5496E-21, &
 -5.9040E-21, -4.0652E-21, -2.8148E-21, -1.9736E-21, -1.4096E-21, -1.0292E-21, &
 -7.7040E-22, -5.9200E-22, -4.6640E-22, -3.7640E-22, -3.1080E-22, -2.6120E-22, &
 -2.2320E-22, -1.9400E-22, -1.7000E-22, -1.5080E-22, -1.3520E-22, -1.2160E-22, &
 -1.1000E-22, -1.0000E-22, -9.1600E-23, -8.4000E-23, -7.7199E-23, -7.1200E-23, &
 -6.6001E-23, -6.1200E-23, -5.6400E-23, -5.2401E-23, -4.9199E-23, -4.5200E-23, &
 -4.2401E-23, -3.9600E-23, -3.6799E-23, -3.4400E-23, -2.8160E-23, -2.0160E-23, &
 -1.4480E-23, -1.0400E-23, -7.5198E-24, -5.3601E-24, -3.9201E-24, -2.7997E-24, &
 -2.0801E-24, -1.4401E-24, -1.0399E-24, -8.0004E-25, -4.8002E-25, -3.9989E-25, &
 -3.2002E-25 /)
    REAL, PARAMETER :: b2_CHBr3(dim55) = (/ &
       4.1916E-19,  4.0354E-19,  3.7056E-19,  3.2499E-19,  2.7484E-19,  2.2733E-19, &
       1.8633E-19,  1.5323E-19,  1.2760E-19,  1.0825E-19,  9.3867E-20,  8.3216E-20, &
       7.5322E-20,  6.9435E-20,  6.4976E-20,  6.1556E-20,  5.8899E-20,  5.6767E-20, &
       5.5038E-20,  5.3636E-20,  5.2424E-20,  5.1406E-20,  5.0541E-20,  4.9752E-20, &
       4.9050E-20,  4.8420E-20,  4.7870E-20,  4.7353E-20,  4.6874E-20,  4.6436E-20, &
       4.6043E-20,  4.5669E-20,  4.5282E-20,  4.4950E-20,  4.4677E-20,  4.4325E-20, &
       4.4071E-20,  4.3811E-20,  4.3543E-20,  4.3308E-20,  4.2681E-20,  4.1777E-20, &
       4.1064E-20,  4.0501E-20,  4.0068E-20,  3.9716E-20,  3.9463E-20,  3.9252E-20, &
       3.9108E-20,  3.8972E-20,  3.8882E-20,  3.8824E-20,  3.8744E-20,  3.8723E-20, &
       3.8701E-20 /)
    REAL, PARAMETER :: a3_CHBr3(dim55) = (/ &
 -3.7258E-23, -2.1214E-23, -1.0981E-23, -6.0859E-24, -3.7949E-24, -2.6031E-24, &
 -1.9048E-24, -1.4601E-24, -1.1552E-24, -9.3788E-25, -7.7884E-25, -6.5719E-25, &
 -5.6307E-25, -4.8785E-25, -4.2786E-25, -3.7658E-25, -3.3545E-25, -2.9940E-25, &
 -2.7055E-25, -2.4487E-25, -2.2222E-25, -2.0377E-25, -1.8665E-25, -1.7294E-25, &
 -1.5898E-25, -1.4726E-25, -1.3699E-25, -1.2671E-25, -1.1795E-25, -1.0959E-25, &
 -1.0274E-25, -9.7603E-26, -8.8888E-26, -8.5617E-26, -7.8767E-26, -7.3506E-26, &
 -7.0205E-26, -6.5066E-26, -6.1646E-26, -5.8120E-26, -4.8614E-26, -3.5946E-26, &
 -2.6694E-26, -1.9856E-26, -1.5064E-26, -1.1294E-26, -8.5584E-27, -6.5044E-27, &
 -4.7916E-27, -3.7659E-27, -3.0807E-27, -2.0540E-27, -1.7111E-27, -1.3696E-27, &
 -6.8422E-28 /)
    REAL, PARAMETER :: b3_CHBr3(dim55) = (/ &
       7.5946E-21,  6.6492E-21,  5.4483E-21,  4.5879E-21,  4.0513E-21,  3.7025E-21, &
       3.4574E-21,  3.2753E-21,  3.1326E-21,  3.0182E-21,  2.9252E-21,  2.8470E-21, &
       2.7810E-21,  2.7238E-21,  2.6747E-21,  2.6297E-21,  2.5912E-21,  2.5554E-21, &
       2.5251E-21,  2.4965E-21,  2.4701E-21,  2.4474E-21,  2.4254E-21,  2.4070E-21, &
       2.3874E-21,  2.3703E-21,  2.3547E-21,  2.3385E-21,  2.3241E-21,  2.3099E-21, &
       2.2979E-21,  2.2886E-21,  2.2723E-21,  2.2660E-21,  2.2524E-21,  2.2416E-21, &
       2.2347E-21,  2.2236E-21,  2.2160E-21,  2.2080E-21,  2.1857E-21,  2.1524E-21, &
       2.1254E-21,  2.1034E-21,  2.0866E-21,  2.0723E-21,  2.0611E-21,  2.0521E-21, &
       2.0441E-21,  2.0390E-21,  2.0354E-21,  2.0297E-21,  2.0277E-21,  2.0256E-21, &
       2.0212E-21 /)
    REAL, PARAMETER :: a4_CHBr3(4) =(/1.0180E-21, -2.3651E-25, 4.9046E-29, -3.4181E-33/)
    REAL, PARAMETER :: a5_CHBr3(4) =(/  1.2405E-22, -3.9041E-26,  6.8947E-30, -4.3985E-34/)
    REAL, PARAMETER :: a6_CHBr3(4) =(/ 7.2594E-25, -1.0041E-29,  8.2354E-35, -3.9640E-40/)
    REAL, PARAMETER :: a7_CHBr3(4) =(/  5.6101E-31,  3.4649E-35,  5.9899E-40, -9.8091E-45/)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_CHBr3(dim58) = (/ &
 -6.0736E-03, -6.0736E-03, -6.0736E-03, -6.8970E-03, -7.4963E-03, -8.4612E-03, &
 -8.7834E-03, -9.0636E-03, -9.1330E-03, -9.0797E-03, -8.4723E-03, -8.2837E-03, &
 -7.6758E-03, -6.9820E-03, -6.3349E-03, -5.3379E-03, -4.4665E-03, -3.4491E-03, &
 -2.4219E-03, -1.1668E-03,  3.9819E-04,  2.4621E-03,  4.3299E-03,  6.4079E-03, &
  8.8971E-03,  1.1134E-02,  1.2909E-02,  1.4690E-02,  1.5864E-02,  1.6629E-02, &
  1.6695E-02,  1.6886E-02,  1.6359E-02,  1.6059E-02,  1.5486E-02,  1.5330E-02, &
  1.5150E-02,  1.5307E-02,  1.4947E-02,  1.5287E-02,  1.4478E-02,  1.3578E-02, &
  1.1980E-02,  9.9978E-03,  7.1026E-03,  4.5785E-03,  1.9360E-03, -1.7885E-04, &
 -1.6563E-03, -3.7901E-03, -5.7207E-03, -8.8209E-03, -1.3179E-02, -1.8320E-02, &
 -2.2987E-02, -2.7194E-02, -3.1690E-02, -3.6945E-02  /)
    REAL, PARAMETER :: c0_1_2_CHBr3(dim58) = (/ &
  2.6403E-01,  2.6403E-01,  2.6403E-01,  3.0075E-01,  3.2760E-01,  3.7102E-01, &
  3.8559E-01,  3.9831E-01,  4.0147E-01,  3.9903E-01,  3.7109E-01,  3.6238E-01, &
  3.3417E-01,  3.0184E-01,  2.7155E-01,  2.2470E-01,  1.8357E-01,  1.3534E-01, &
  8.6447E-02,  2.6455E-02, -4.8666E-02, -1.4815E-01, -2.3855E-01, -3.3954E-01, &
 -4.6101E-01, -5.7064E-01, -6.5796E-01, -7.4595E-01, -8.0415E-01, -8.4225E-01, &
 -8.4554E-01, -8.5513E-01, -8.2857E-01, -8.1341E-01, -7.8431E-01, -7.7635E-01, &
 -7.6713E-01, -7.7521E-01, -7.5664E-01, -7.7421E-01, -7.3215E-01, -6.8518E-01, &
 -6.0144E-01, -4.9718E-01, -3.4432E-01, -2.1054E-01, -6.9959E-02,  4.2973E-02, &
  1.2216E-01,  2.3697E-01,  3.4121E-01,  5.0924E-01,  7.4635E-01,  1.0270E+00, &
  1.2828E+00,  1.5142E+00,  1.7623E+00,  2.0535E+00 /)
    REAL, PARAMETER :: c1_CHBr3(2) = (/ 1.00,  0.004 /)
    REAL, PARAMETER :: c2_CHBr3(2) = (/ 1.00,  0.013 /)
    REAL, PARAMETER :: c3_CHBr3(2) = (/ 1.11,  2.440 /)
    REAL, PARAMETER :: c4_CHBr3(2) = (/ 1.14,  2.823 /)
    REAL, PARAMETER :: c5_CHBr3(2) = (/ 2.16, 12.58  /)
    REAL, PARAMETER :: c6_CHBr3(2) = (/ 1.36,  5.212 /)
    REAL, PARAMETER :: c7_CHBr3(2) = (/ 2.67, 15.79  /)

    jval_gp(ip_CHBr3)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_CHBr3(0) = &
          p1(1.,c0_1_1_CHBr3(i0(j,k))*dlv2(j,k) + &
          c0_1_2_CHBr3(i0(j,k)),tnorm_sr(j,k)) * &
          p1(a0_1_1_CHBr3(i0(j,k))*dlv2(j,k) + &
          a0_1_2_CHBr3(i0(j,k)), &
          a0_2_1_CHBr3(i0(j,k))*dlv2(j,k) + &
          a0_2_2_CHBr3(i0(j,k)),v3_du1(j,k))
        sig_CHBr3(1) = &
          p1(c1_CHBr3(1),c1_CHBr3(2),tnorm(j,k)) * &
          (p1(b1_1_CHBr3(i1(j,k)),a1_1_CHBr3(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_CHBr3(i1(j,k)),a1_2_CHBr3(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_CHBr3(2) = &
          p1(c2_CHBr3(1),c2_CHBr3(2),tnorm(j,k)) * &
          p1(b2_CHBr3(i2(j,k)), a2_CHBr3(i2(j,k)), &
          v3_du1(j,k))
        sig_CHBr3(3) = &
          p1(c3_CHBr3(1),c3_CHBr3(2),tnorm(j,k)) * &
          p1(b3_CHBr3(i3(j,k)), a3_CHBr3(i3(j,k)), &
          v3_du2(j,k))
          sig_CHBr3(4)= &
            p1(c4_CHBr3(1),c4_CHBr3(2),tnorm(j,k))* &
            p2(a4_CHBr3(1),a4_CHBr3(2),a4_CHBr3(3), &
            v3_du2(j,k))
          sig_CHBr3(5)= &
            p1(c5_CHBr3(1),c5_CHBr3(2),tnorm(j,k))* &
            p2(a5_CHBr3(1),a5_CHBr3(2),a5_CHBr3(3), &
            v3_du2(j,k))
          sig_CHBr3(6)= &
            p1(c6_CHBr3(1),c6_CHBr3(2),tnorm(j,k))* &
            p1(a6_CHBr3(1),a6_CHBr3(2), &
            v3_du2(j,k))
          sig_CHBr3(7)= &
            p1(c7_CHBr3(1),c7_CHBr3(2),tnorm(j,k))* &
            p1(a7_CHBr3(1),a7_CHBr3(2), &
            v3_du2(j,k))
        dj = 0. &
          + sig_CHBr3(0) * fint(j,k,0) &
          + sig_CHBr3(1) * fint(j,k,1) &
          + sig_CHBr3(2) * fint(j,k,2) &
          + sig_CHBr3(3) * fint(j,k,3) &
          + sig_CHBr3(4) * fint(j,k,4) &
          + sig_CHBr3(5) * fint(j,k,5) &
          + sig_CHBr3(6) * fint(j,k,6) &
          + sig_CHBr3(7) * fint(j,k,7)

        jval_gp(ip_CHBr3)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_CHBr3

  ! **************************************************************************

  SUBROUTINE jval_cal_sf6(jrow)

    ! SF6 -> products
    ! Lyman-alpha absorption cross section 1.76E-18 cm^2 from Table 1 of
    ! Ravishankara et al., Science 259, 194-199, 1993

    REAL :: dj
    INTEGER, INTENT(IN) :: jrow
    INTEGER :: j, k
    jval_gp(ip_sf6)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
       DO j = 1,kproma_day
          dj = 1.76E-18*r_m(j,k)*phi_la
          ! mz_ab_20070904+
          jval_gp(ip_sf6)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
          ! mz_ab_20070904-
       ENDDO
    ENDDO

  END SUBROUTINE jval_cal_SF6

  ! **************************************************************************

  SUBROUTINE jval_cal_NO3NOO(jrow)

    ! N2O5 -> NO3 + NO + O(3p)
    ! JPL 2006

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_NO3NOO

    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_NO3NOO(dim58) = (/ &
      -7.2803E-22, -8.0657E-22, -9.0984E-22, -9.6774E-22, -1.1499E-21, -1.2200E-21, &
      -1.3400E-21, -1.3980E-21, -1.5261E-21, -1.6503E-21, -1.7698E-21, -2.0018E-21, &
      -2.1221E-21, -2.5436E-21, -2.6015E-21, -2.7794E-21, -3.0438E-21, -3.1846E-21, &
      -3.3958E-21, -3.6065E-21, -3.7966E-21, -3.9701E-21, -4.2652E-21, -4.3091E-21, &
      -4.6824E-21, -4.6983E-21, -4.9008E-21, -5.2607E-21, -5.3846E-21, -5.7036E-21, &
      -5.9475E-21, -6.2077E-21, -6.4234E-21, -6.6415E-21, -6.8840E-21, -7.0957E-21, &
      -7.3747E-21, -7.5728E-21, -7.9032E-21, -8.2517E-21, -8.6562E-21, -9.0493E-21, &
      -9.5248E-21, -9.9635E-21, -1.0376E-20, -1.0582E-20, -1.0870E-20, -1.0933E-20, &
      -1.0944E-20, -1.0793E-20, -1.0497E-20, -1.0174E-20, -9.7398E-21, -9.2892E-21, &
      -8.7767E-21, -8.0693E-21, -7.0277E-21, -5.7455E-21 /)
    REAL, PARAMETER :: a0_1_2_NO3NOO(dim58) = (/ &
      9.1965E-18, 9.2000E-18, 9.2046E-18, 9.2072E-18, 9.2153E-18, 9.2185E-18, &
      9.2239E-18, 9.2266E-18, 9.2324E-18, 9.2381E-18, 9.2436E-18, 9.2543E-18, &
      9.2599E-18, 9.2795E-18, 9.2822E-18, 9.2906E-18, 9.3031E-18, 9.3098E-18, &
      9.3198E-18, 9.3299E-18, 9.3390E-18, 9.3474E-18, 9.3616E-18, 9.3638E-18, &
      9.3820E-18, 9.3828E-18, 9.3927E-18, 9.4105E-18, 9.4167E-18, 9.4325E-18, &
      9.4447E-18, 9.4578E-18, 9.4687E-18, 9.4797E-18, 9.4920E-18, 9.5028E-18, &
      9.5171E-18, 9.5273E-18, 9.5443E-18, 9.5624E-18, 9.5834E-18, 9.6040E-18, &
      9.6289E-18, 9.6519E-18, 9.6737E-18, 9.6847E-18, 9.7000E-18, 9.7033E-18, &
      9.7039E-18, 9.6958E-18, 9.6798E-18, 9.6623E-18, 9.6387E-18, 9.6141E-18, &
      9.5860E-18, 9.5471E-18, 9.4896E-18, 9.4186E-18 /)
    REAL, PARAMETER :: a0_2_1_NO3NOO(dim58) = (/ &
      1.9129E-24, 2.1537E-24, 2.6279E-24, 2.6607E-24, 3.3765E-24, 3.4490E-24, &
      3.8617E-24, 3.6903E-24, 3.8980E-24, 3.9275E-24, 4.2879E-24, 5.5225E-24, &
      5.1968E-24, 8.9489E-24, 7.8774E-24, 7.9546E-24, 9.0639E-24, 8.2171E-24, &
      8.5815E-24, 9.0142E-24, 8.6907E-24, 8.6332E-24, 9.3846E-24, 8.2130E-24, &
      8.9729E-24, 7.4150E-24, 6.9896E-24, 7.8158E-24, 7.4808E-24, 7.8776E-24, &
      7.8752E-24, 8.2545E-24, 8.2509E-24, 8.3490E-24, 8.5459E-24, 8.4336E-24, &
      8.7477E-24, 8.4649E-24, 8.8386E-24, 8.7084E-24, 9.2842E-24, 9.4332E-24, &
      9.1289E-24, 9.7661E-24, 9.9039E-24, 9.1074E-24, 9.3002E-24, 8.7795E-24, &
      8.5604E-24, 8.1202E-24, 7.2660E-24, 7.0195E-24, 6.2325E-24, 5.7217E-24, &
      5.1244E-24, 4.3835E-24, 3.4986E-24, 2.7995E-24 /)
    REAL, PARAMETER :: a0_2_2_NO3NOO(dim58) = (/ &
      -1.8682E-22, -1.9746E-22, -2.1851E-22, -2.1998E-22, -2.5205E-22, -2.5531E-22, &
      -2.7396E-22, -2.6618E-22, -2.7566E-22, -2.7701E-22, -2.9358E-22, -3.5062E-22, &
      -3.3551E-22, -5.1036E-22, -4.6021E-22, -4.6384E-22, -5.1620E-22, -4.7606E-22, &
      -4.9341E-22, -5.1409E-22, -4.9856E-22, -4.9579E-22, -5.3216E-22, -4.7522E-22, &
      -5.1230E-22, -4.3596E-22, -4.1503E-22, -4.5585E-22, -4.3923E-22, -4.5899E-22, &
      -4.5887E-22, -4.7791E-22, -4.7773E-22, -4.8270E-22, -4.9270E-22, -4.8697E-22, &
      -5.0305E-22, -4.8851E-22, -5.0780E-22, -5.0106E-22, -5.3100E-22, -5.3878E-22, &
      -5.2283E-22, -5.5634E-22, -5.6362E-22, -5.2141E-22, -5.3166E-22, -5.0386E-22, &
      -4.9211E-22, -4.6843E-22, -4.2231E-22, -4.0895E-22, -3.6613E-22, -3.3824E-22, &
      -3.0551E-22, -2.6476E-22, -2.1592E-22, -1.7719E-22 /)
    REAL, PARAMETER :: a1_1_NO3NOO(dim55) = (/ &
      9.3594E-20, 9.1156E-20, 9.0718E-20, 8.4769E-20, 8.1296E-20, 7.4423E-20, &
      7.0031E-20, 6.3915E-20, 5.9713E-20, 5.4815E-20, 5.1223E-20, 4.7468E-20, &
      4.4485E-20, 4.1613E-20, 3.9104E-20, 3.6944E-20, 3.4773E-20, 3.3138E-20, &
      3.1211E-20, 2.9962E-20, 2.8274E-20, 2.7321E-20, 2.5783E-20, 2.5062E-20, &
      2.3661E-20, 2.3124E-20, 2.1831E-20, 2.1437E-20, 2.0251E-20, 1.9963E-20, &
      1.8855E-20, 1.8699E-20, 1.7637E-20, 1.7548E-20, 1.6559E-20, 1.6535E-20, &
      1.5594E-20, 1.5640E-20, 1.4749E-20, 1.4826E-20, 1.3484E-20, 1.2107E-20, &
      1.0818E-20, 9.9351E-21, 9.0119E-21, 8.4058E-21, 7.6849E-21, 7.2468E-21, &
      6.4203E-21, 5.9626E-21, 5.5463E-21, 5.1648E-21, 4.8143E-21, 4.4933E-21, &
      4.1959E-21 /)
    REAL, PARAMETER :: b1_1_NO3NOO(dim55) = (/ &
      2.0841E-18, 2.0914E-18, 2.0938E-18, 2.1414E-18, 2.1779E-18, 2.2672E-18, &
      2.3353E-18, 2.4454E-18, 2.5315E-18, 2.6442E-18, 2.7357E-18, 2.8409E-18, &
      2.9319E-18, 3.0267E-18, 3.1157E-18, 3.1978E-18, 3.2857E-18, 3.3560E-18, &
      3.4437E-18, 3.5036E-18, 3.5889E-18, 3.6394E-18, 3.7248E-18, 3.7666E-18, &
      3.8514E-18, 3.8852E-18, 3.9699E-18, 3.9967E-18, 4.0803E-18, 4.1013E-18, &
      4.1849E-18, 4.1971E-18, 4.2826E-18, 4.2900E-18, 4.3746E-18, 4.3767E-18, &
      4.4619E-18, 4.4575E-18, 4.5427E-18, 4.5351E-18, 4.6699E-18, 4.8255E-18, &
      4.9874E-18, 5.1092E-18, 5.2481E-18, 5.3469E-18, 5.4734E-18, 5.5558E-18, &
      5.7215E-18, 5.8190E-18, 5.9129E-18, 6.0037E-18, 6.0915E-18, 6.1759E-18, &
      6.2578E-18 /)
    REAL, PARAMETER :: a1_2_NO3NOO(dim55) = (/ &
      -2.4957E-22, -1.3951E-22, -1.3549E-22, -4.1666E-23, -3.5987E-23, 2.6734E-23, &
      2.7429E-23, 6.1261E-23, 5.8488E-23, 7.3448E-23, 6.9311E-23, 7.3724E-23, &
      7.0174E-23, 6.9187E-23, 6.7078E-23, 6.2986E-23, 6.2600E-23, 5.6960E-23, &
      5.7949E-23, 5.1593E-23, 5.3347E-23, 4.6606E-23, 4.9087E-23, 4.2301E-23, &
      4.5292E-23, 3.8424E-23, 4.1871E-23, 3.5023E-23, 3.8594E-23, 3.2104E-23, &
      3.5771E-23, 2.9241E-23, 3.3152E-23, 2.6910E-23, 3.0770E-23, 2.4794E-23, &
      2.8665E-23, 2.2794E-23, 2.6657E-23, 2.1084E-23, 2.1556E-23, 1.7447E-23, &
      1.5767E-23, 1.3030E-23, 1.2192E-23, 1.0243E-23, 9.9055E-24, 8.4127E-24, &
      9.6873E-24, 9.1348E-24, 8.6576E-24, 8.2543E-24, 7.8899E-24, 7.5512E-24, &
      7.2474E-24 /)
    REAL, PARAMETER :: b1_2_NO3NOO(dim55) = (/ &
      -6.2525E-21, -6.5827E-21, -6.6049E-21, -7.3554E-21, -7.4151E-21, -8.2304E-21, &
      -8.2412E-21, -8.8502E-21, -8.7933E-21, -9.1374E-21, -9.0319E-21, -9.1555E-21, &
      -9.0472E-21, -9.0146E-21, -8.9398E-21, -8.7843E-21, -8.7687E-21, -8.5261E-21, &
      -8.5711E-21, -8.2660E-21, -8.3546E-21, -7.9973E-21, -8.1350E-21, -7.7414E-21, &
      -7.9224E-21, -7.4897E-21, -7.7155E-21, -7.2498E-21, -7.5016E-21, -7.0278E-21, &
      -7.3047E-21, -6.7953E-21, -7.1101E-21, -6.5921E-21, -6.9221E-21, -6.3962E-21, &
      -6.7466E-21, -6.2005E-21, -6.5695E-21, -6.0233E-21, -6.0707E-21, -5.6064E-21, &
      -5.3956E-21, -5.0178E-21, -4.8918E-21, -4.5741E-21, -4.5149E-21, -4.2342E-21, &
      -4.4898E-21, -4.3721E-21, -4.2645E-21, -4.1685E-21, -4.0772E-21, -3.9881E-21, &
      -3.9044E-21 /)
    REAL, PARAMETER :: a2_NO3NOO(dim55) = (/ &
      -7.1760E-21, -6.2520E-21, -5.1160E-21, -3.9960E-21, -3.0280E-21, -2.2556E-21, &
      -1.6844E-21, -1.2728E-21, -9.8120E-22, -7.7640E-22, -6.3120E-22, -5.2720E-22, &
      -4.5080E-22, -3.9360E-22, -3.4880E-22, -3.1400E-22, -2.8520E-22, -2.6120E-22, &
      -2.4080E-22, -2.2320E-22, -2.0720E-22, -1.9280E-22, -1.8040E-22, -1.6840E-22, &
      -1.5800E-22, -1.4800E-22, -1.3880E-22, -1.3040E-22, -1.2200E-22, -1.1520E-22, &
      -1.0760E-22, -1.0160E-22, -9.5201E-23, -8.9201E-23, -8.4398E-23, -7.8799E-23, &
      -7.4402E-23, -6.9599E-23, -6.5601E-23, -6.1198E-23, -5.1120E-23, -3.7280E-23, &
      -2.7120E-23, -1.9600E-23, -1.4240E-23, -1.0320E-23, -7.3598E-24, -5.4403E-24, &
      -3.8402E-24, -2.8000E-24, -1.9997E-24, -1.4403E-24, -1.0397E-24, -7.2016E-25, &
      -5.5990E-25 /)
    REAL, PARAMETER :: b2_NO3NOO(dim55) = (/ &
      1.7163E-19, 1.6886E-19, 1.6261E-19, 1.5365E-19, 1.4348E-19, 1.3344E-19, &
      1.2459E-19, 1.1718E-19, 1.1120E-19, 1.0649E-19, 1.0279E-19, 9.9878E-20, &
      9.7547E-20, 9.5660E-20, 9.4069E-20, 9.2747E-20, 9.1581E-20, 9.0549E-20, &
      8.9620E-20, 8.8776E-20, 8.7968E-20, 8.7204E-20, 8.6516E-20, 8.5820E-20, &
      8.5191E-20, 8.4561E-20, 8.3958E-20, 8.3387E-20, 8.2795E-20, 8.2299E-20, &
      8.1725E-20, 8.1257E-20, 8.0742E-20, 8.0244E-20, 7.9833E-20, 7.9340E-20, &
      7.8942E-20, 7.8496E-20, 7.8114E-20, 7.7682E-20, 7.6670E-20, 7.5106E-20, &
      7.3831E-20, 7.2793E-20, 7.1986E-20, 7.1347E-20, 7.0828E-20, 7.0467E-20, &
      7.0146E-20, 6.9924E-20, 6.9744E-20, 6.9611E-20, 6.9510E-20, 6.9426E-20, &
      6.9382E-20 /)
    REAL, PARAMETER :: a3_NO3NOO(dim55) = (/ &
      -9.6294E-23, -8.2039E-23, -6.6379E-23, -5.2163E-23, -4.0575E-23, -3.1669E-23, &
      -2.5090E-23, -2.0208E-23, -1.6653E-23, -1.3938E-23, -1.1866E-23, -1.0264E-23, &
      -8.9457E-24, -7.9473E-24, -7.0316E-24, -6.3099E-24, -5.7109E-24, -5.1518E-24, &
      -4.7144E-24, -4.3530E-24, -3.9537E-24, -3.6742E-24, -3.3959E-24, -3.1550E-24, &
      -2.9552E-24, -2.7556E-24, -2.5570E-24, -2.4361E-24, -2.2763E-24, -2.1565E-24, &
      -2.0376E-24, -1.9169E-24, -1.8371E-24, -1.7173E-24, -1.6380E-24, -1.5575E-24, &
      -1.5176E-24, -1.3978E-24, -1.3584E-24, -1.3179E-24, -1.1502E-24, -9.4249E-25, &
      -7.9073E-25, -6.7093E-25, -5.6755E-25, -4.9521E-25, -4.3130E-25, -3.7540E-25, &
      -3.2748E-25, -2.8753E-25, -2.5559E-25, -2.2365E-25, -1.9184E-25, -1.7571E-25, &
      -1.5176E-25 /)
    REAL, PARAMETER :: b3_NO3NOO(dim55) = (/ &
      3.6427E-20, 3.6063E-20, 3.5271E-20, 3.4196E-20, 3.3030E-20, 3.1911E-20, &
      3.0919E-20, 3.0061E-20, 2.9347E-20, 2.8734E-20, 2.8214E-20, 2.7772E-20, &
      2.7375E-20, 2.7050E-20, 2.6728E-20, 2.6457E-20, 2.6217E-20, 2.5978E-20, &
      2.5781E-20, 2.5609E-20, 2.5409E-20, 2.5262E-20, 2.5108E-20, 2.4969E-20, &
      2.4849E-20, 2.4724E-20, 2.4595E-20, 2.4513E-20, 2.4401E-20, 2.4314E-20, &
      2.4225E-20, 2.4131E-20, 2.4067E-20, 2.3968E-20, 2.3900E-20, 2.3830E-20, &
      2.3794E-20, 2.3683E-20, 2.3645E-20, 2.3606E-20, 2.3437E-20, 2.3203E-20, &
      2.3013E-20, 2.2848E-20, 2.2693E-20, 2.2575E-20, 2.2463E-20, 2.2358E-20, &
      2.2262E-20, 2.2177E-20, 2.2105E-20, 2.2029E-20, 2.1949E-20, 2.1907E-20, &
      2.1841E-20 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c2_NO3NOO(4) = (/ 1.00,  0.47, -0.21,  0.06 /)
    REAL, PARAMETER :: c3_NO3NOO(4) = (/ 1.00,  1.80, -0.13, -0.50 /)

    jval_gp(ip_NO3NOO)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_NO3NOO(0) = &
          p1(a0_1_1_NO3NOO(i0(j,k))*dlv2(j,k) + &
          a0_1_2_NO3NOO(i0(j,k)), &
          a0_2_1_NO3NOO(i0(j,k))*dlv2(j,k) + &
          a0_2_2_NO3NOO(i0(j,k)),v3_du1(j,k))
        sig_NO3NOO(1) = &
          (p1(b1_1_NO3NOO(i1(j,k)),a1_1_NO3NOO(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_NO3NOO(i1(j,k)),a1_2_NO3NOO(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_NO3NOO(2) = &
          p3(c2_NO3NOO(1),c2_NO3NOO(2),c2_NO3NOO(3),c2_NO3NOO(4),tnorm(j,k))* &
          p1(b2_NO3NOO(i2(j,k)), a2_NO3NOO(i2(j,k)), &
          v3_du1(j,k))
        sig_NO3NOO(3) = &
          p3(c3_NO3NOO(1),c3_NO3NOO(2),c3_NO3NOO(3),c3_NO3NOO(4),tnorm(j,k))* &
          p1(b3_NO3NOO(i3(j,k)), a3_NO3NOO(i3(j,k)), &
          v3_du2(j,k))

        dj = &
          sig_NO3NOO(0) * fint(j,k,0) * 0.72 + &
          sig_NO3NOO(1) * fint(j,k,1) * 0.72 + &
          sig_NO3NOO(2) * fint(j,k,2) * 0.3  + &
          sig_NO3NOO(3) * fint(j,k,3) * 0.05
        jval_gp(ip_NO3NOO)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,5))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_NO3NOO

  ! **************************************************************************

  SUBROUTINE jval_cal_ClONO2(jrow)

    ! ClNO3 -> ClO + NO2
    ! JPL 1997, quantum yields for 2 pathways JPL 2006

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL    :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_ClONO2

    ! (the same values a* b*, and c* are used for ClNO3 and ClONO2)
    ! T-const parameters:
    REAL, PARAMETER :: a0_1_1_ClONO2(dim58) = (/ &
      -1.4964E-21, -1.7393E-21, -1.8528E-21, -2.1237E-21, -2.2925E-21, -2.4287E-21, &
      -2.6449E-21, -2.9315E-21, -3.0666E-21, -3.5105E-21, -3.6068E-21, -3.9809E-21, &
      -4.4437E-21, -5.1606E-21, -5.3209E-21, -5.7159E-21, -6.2137E-21, -6.5006E-21, &
      -6.8051E-21, -7.3329E-21, -7.5549E-21, -7.8802E-21, -8.4548E-21, -8.6120E-21, &
      -9.0183E-21, -9.1815E-21, -9.4636E-21, -9.8815E-21, -1.0309E-20, -1.0735E-20, &
      -1.1151E-20, -1.1464E-20, -1.1746E-20, -1.2148E-20, -1.2357E-20, -1.2571E-20, &
      -1.2890E-20, -1.3100E-20, -1.3388E-20, -1.3762E-20, -1.4153E-20, -1.4515E-20, &
      -1.4952E-20, -1.5267E-20, -1.5545E-20, -1.5633E-20, -1.5545E-20, -1.5314E-20, &
      -1.4775E-20, -1.4228E-20, -1.3558E-20, -1.2829E-20, -1.1962E-20, -1.1069E-20, &
      -1.0064E-20, -8.8386E-21, -7.4899E-21, -6.1485E-21 /)
    REAL, PARAMETER :: a0_1_2_ClONO2(dim58) = (/ &
      2.9967E-18, 3.0075E-18, 3.0125E-18, 3.0246E-18, 3.0321E-18, 3.0383E-18, &
      3.0480E-18, 3.0611E-18, 3.0672E-18, 3.0875E-18, 3.0920E-18, 3.1093E-18, &
      3.1307E-18, 3.1641E-18, 3.1716E-18, 3.1902E-18, 3.2137E-18, 3.2273E-18, &
      3.2418E-18, 3.2670E-18, 3.2777E-18, 3.2934E-18, 3.3212E-18, 3.3288E-18, &
      3.3486E-18, 3.3566E-18, 3.3705E-18, 3.3912E-18, 3.4124E-18, 3.4336E-18, &
      3.4544E-18, 3.4701E-18, 3.4843E-18, 3.5046E-18, 3.5153E-18, 3.5262E-18, &
      3.5425E-18, 3.5533E-18, 3.5682E-18, 3.5875E-18, 3.6079E-18, 3.6268E-18, &
      3.6497E-18, 3.6662E-18, 3.6809E-18, 3.6856E-18, 3.6809E-18, 3.6686E-18, &
      3.6397E-18, 3.6102E-18, 3.5741E-18, 3.5345E-18, 3.4874E-18, 3.4386E-18, &
      3.3836E-18, 3.3162E-18, 3.2417E-18, 3.1674E-18 /)
    REAL, PARAMETER :: a0_2_1_ClONO2(dim58) = (/ &
      4.3277E-24, 5.2619E-24, 5.7210E-24, 6.4090E-24, 6.9793E-24, 7.2265E-24, &
      6.9824E-24, 8.3681E-24, 7.9749E-24, 9.7330E-24, 9.1414E-24, 1.0514E-23, &
      1.3106E-23, 1.9560E-23, 1.7431E-23, 1.8112E-23, 2.0312E-23, 1.9262E-23, &
      1.8499E-23, 2.0846E-23, 1.9234E-23, 1.9342E-23, 2.0975E-23, 1.9485E-23, &
      1.9319E-23, 1.7385E-23, 1.6087E-23, 1.6723E-23, 1.6995E-23, 1.8050E-23, &
      1.7959E-23, 1.8236E-23, 1.8279E-23, 1.9077E-23, 1.8897E-23, 1.8942E-23, &
      1.9472E-23, 1.9103E-23, 1.9412E-23, 1.9824E-23, 2.0185E-23, 2.0205E-23, &
      2.0596E-23, 2.0572E-23, 2.0387E-23, 2.0024E-23, 1.9510E-23, 1.8428E-23, &
      1.6844E-23, 1.5780E-23, 1.4380E-23, 1.3081E-23, 1.1508E-23, 1.0146E-23, &
      8.9510E-24, 7.0335E-24, 5.6473E-24, 4.3765E-24 /)
    REAL, PARAMETER :: a0_2_2_ClONO2(dim58) = (/ &
      -3.8181E-22, -4.2310E-22, -4.4349E-22, -4.7417E-22, -4.9972E-22, -5.1085E-22, &
      -4.9981E-22, -5.6272E-22, -5.4479E-22, -6.2532E-22, -5.9810E-22, -6.6151E-22, &
      -7.8179E-22, -1.0825E-21, -9.8290E-22, -1.0149E-21, -1.1188E-21, -1.0690E-21, &
      -1.0326E-21, -1.1448E-21, -1.0675E-21, -1.0727E-21, -1.1517E-21, -1.0793E-21, &
      -1.0712E-21, -9.7646E-22, -9.1258E-22, -9.4397E-22, -9.5748E-22, -1.0100E-21, &
      -1.0055E-21, -1.0194E-21, -1.0215E-21, -1.0619E-21, -1.0528E-21, -1.0550E-21, &
      -1.0822E-21, -1.0633E-21, -1.0792E-21, -1.1005E-21, -1.1193E-21, -1.1203E-21, &
      -1.1408E-21, -1.1396E-21, -1.1298E-21, -1.1106E-21, -1.0832E-21, -1.0254E-21, &
      -9.4052E-22, -8.8330E-22, -8.0769E-22, -7.3728E-22, -6.5171E-22, -5.7737E-22, &
      -5.1187E-22, -4.0640E-22, -3.2989E-22, -2.5948E-22 /)
    REAL, PARAMETER :: a1_1_ClONO2(dim55) = (/ &
      5.2365E-20, 4.7024E-20, 4.0797E-20, 3.4897E-20, 2.8326E-20, 2.3624E-20, &
      1.8143E-20, 1.5047E-20, 1.0949E-20, 9.1648E-21, 6.2142E-21, 5.3427E-21, &
      3.2129E-21, 2.8530E-21, 1.3188E-21, 1.2533E-21, 1.1035E-22, 2.0117E-22, &
      -6.9971E-22, -5.0210E-22, -1.1916E-21, -9.6309E-22, -1.5270E-21, -1.2795E-21, &
      -1.7268E-21, -1.4903E-21, -1.8428E-21, -1.6475E-21, -1.9144E-21, -1.7208E-21, &
      -1.9621E-21, -1.7537E-21, -1.9545E-21, -1.7993E-21, -1.9444E-21, -1.7961E-21, &
      -1.9134E-21, -1.7774E-21, -1.8949E-21, -1.7568E-21, -1.7655E-21, -1.6516E-21, &
      -1.5497E-21, -1.4450E-21, -1.3435E-21, -1.2553E-21, -1.1630E-21, -1.0950E-21, &
      -9.8153E-22, -9.0507E-22, -8.3989E-22, -7.7623E-22, -7.1930E-22, -6.6853E-22, &
      -6.2196E-22 /)
    REAL, PARAMETER :: b1_1_ClONO2(dim55) = (/ &
      2.4490E-18, 2.4650E-18, 2.4992E-18, 2.5464E-18, 2.6154E-18, 2.6766E-18, &
      2.7615E-18, 2.8172E-18, 2.9013E-18, 2.9423E-18, 3.0175E-18, 3.0419E-18, &
      3.1069E-18, 3.1188E-18, 3.1732E-18, 3.1757E-18, 3.2220E-18, 3.2181E-18, &
      3.2591E-18, 3.2496E-18, 3.2844E-18, 3.2723E-18, 3.3036E-18, 3.2893E-18, &
      3.3163E-18, 3.3014E-18, 3.3245E-18, 3.3112E-18, 3.3300E-18, 3.3159E-18, &
      3.3341E-18, 3.3179E-18, 3.3340E-18, 3.3212E-18, 3.3336E-18, 3.3205E-18, &
      3.3311E-18, 3.3185E-18, 3.3297E-18, 3.3162E-18, 3.3170E-18, 3.3042E-18, &
      3.2914E-18, 3.2769E-18, 3.2617E-18, 3.2473E-18, 3.2311E-18, 3.2183E-18, &
      3.1956E-18, 3.1793E-18, 3.1646E-18, 3.1494E-18, 3.1352E-18, 3.1218E-18, &
      3.1090E-18 /)
    REAL, PARAMETER :: a1_2_ClONO2(dim55) = (/ &
      1.6922E-23, 5.9678E-23, 9.5014E-23, 1.0744E-22, 1.3115E-22, 1.1798E-22, &
      1.3062E-22, 1.0507E-22, 1.1192E-22, 8.4261E-23, 8.8989E-23, 6.3902E-23, &
      6.8200E-23, 4.7690E-23, 5.1517E-23, 3.5162E-23, 3.8979E-23, 2.6016E-23, &
      2.9860E-23, 1.9301E-23, 2.2853E-23, 1.4439E-23, 1.7623E-23, 1.0896E-23, &
      1.3577E-23, 8.2076E-24, 1.0501E-23, 6.2812E-24, 8.1960E-24, 4.6563E-24, &
      6.4152E-24, 3.3932E-24, 4.9049E-24, 2.5740E-24, 3.7295E-24, 1.8278E-24, &
      2.8011E-24, 1.2377E-24, 2.1314E-24, 7.4426E-25, 7.1886E-25, -9.7961E-26, &
      -4.6094E-25, -7.1817E-25, -8.6924E-25, -9.1268E-25, -9.9914E-25, -9.4380E-25, &
      -1.1736E-24, -1.1980E-24, -1.1933E-24, -1.1899E-24, -1.1679E-24, -1.1399E-24, &
      -1.1060E-24 /)
    REAL, PARAMETER :: b1_2_ClONO2(dim55) = (/ &
      -3.5235E-21, -3.6518E-21, -3.8461E-21, -3.9455E-21, -4.1945E-21, -4.0233E-21, &
      -4.2192E-21, -3.7593E-21, -3.8997E-21, -3.2636E-21, -3.3842E-21, -2.6818E-21, &
      -2.8128E-21, -2.1360E-21, -2.2719E-21, -1.6504E-21, -1.8049E-21, -1.2476E-21, &
      -1.4225E-21, -9.1563E-22, -1.0950E-21, -6.4906E-22, -8.2579E-22, -4.3561E-22, &
      -5.9780E-22, -2.5953E-22, -4.0975E-22, -1.2280E-22, -2.5780E-22, 5.9845E-25, &
      -1.3220E-22, 1.0352E-22, -1.8169E-23, 1.7530E-22, 7.6499E-23, 2.4385E-22, &
      1.5577E-22, 3.0116E-22, 2.1581E-22, 3.5175E-22, 3.5430E-22, 4.4661E-22, &
      4.9216E-22, 5.2766E-22, 5.5039E-22, 5.5747E-22, 5.7265E-22, 5.6224E-22, &
      6.0831E-22, 6.1353E-22, 6.1245E-22, 6.1166E-22, 6.0614E-22, 5.9877E-22, &
      5.8943E-22 /)
    REAL, PARAMETER :: a2_ClONO2(dim55) = (/ &
      -1.0424E-20, -9.0560E-21, -7.3640E-21, -5.6840E-21, -4.2240E-21, -3.0752E-21, &
      -2.2156E-21, -1.6000E-21, -1.1668E-21, -8.6560E-22, -6.5520E-22, -5.0760E-22, &
      -4.0200E-22, -3.2600E-22, -2.7000E-22, -2.2760E-22, -1.9520E-22, -1.6920E-22, &
      -1.4920E-22, -1.3240E-22, -1.1840E-22, -1.0680E-22, -9.6798E-23, -8.8400E-23, &
      -8.0800E-23, -7.4400E-23, -6.8002E-23, -6.3199E-23, -5.8399E-23, -5.4002E-23, &
      -5.0399E-23, -4.6400E-23, -4.3600E-23, -4.0400E-23, -3.7601E-23, -3.5199E-23, &
      -3.2800E-23, -3.0800E-23, -2.8401E-23, -2.6801E-23, -2.2080E-23, -1.5760E-23, &
      -1.1440E-23, -8.1601E-24, -6.0002E-24, -4.2398E-24, -3.1200E-24, -2.1600E-24, &
      -1.6001E-24, -1.1999E-24, -7.9978E-25, -6.4003E-25, -4.0015E-25, -3.2002E-25, &
      -2.3988E-25 /)
    REAL, PARAMETER :: b2_ClONO2(dim55) = (/ &
      1.9757E-19, 1.9347E-19, 1.8416E-19, 1.7072E-19, 1.5539E-19, 1.4046E-19, &
      1.2713E-19, 1.1605E-19, 1.0717E-19, 1.0024E-19, 9.4880E-20, 9.0747E-20, &
      8.7526E-20, 8.5018E-20, 8.3030E-20, 8.1419E-20, 8.0107E-20, 7.8989E-20, &
      7.8079E-20, 7.7272E-20, 7.6565E-20, 7.5951E-20, 7.5395E-20, 7.4908E-20, &
      7.4448E-20, 7.4045E-20, 7.3626E-20, 7.3300E-20, 7.2961E-20, 7.2640E-20, &
      7.2368E-20, 7.2056E-20, 7.1831E-20, 7.1565E-20, 7.1326E-20, 7.1115E-20, &
      7.0897E-20, 7.0711E-20, 7.0482E-20, 7.0325E-20, 6.9851E-20, 6.9137E-20, &
      6.8595E-20, 6.8142E-20, 6.7817E-20, 6.7530E-20, 6.7334E-20, 6.7153E-20, &
      6.7041E-20, 6.6956E-20, 6.6865E-20, 6.6827E-20, 6.6767E-20, 6.6746E-20, &
      6.6724E-20 /)
    REAL, PARAMETER :: a3_ClONO2(dim55) = (/ &
      -9.5255E-23, -7.9722E-23, -6.3144E-23, -4.8368E-23, -3.6581E-23, -2.7716E-23, &
      -2.1254E-23, -1.6613E-23, -1.3259E-23, -1.0903E-23, -9.0691E-24, -7.7476E-24, &
      -6.6693E-24, -5.8706E-24, -5.1938E-24, -4.6326E-24, -4.2332E-24, -3.8339E-24, &
      -3.4759E-24, -3.2747E-24, -2.9952E-24, -2.7955E-24, -2.5969E-24, -2.4760E-24, &
      -2.3163E-24, -2.1566E-24, -2.0775E-24, -1.9569E-24, -1.8370E-24, -1.7971E-24, &
      -1.6780E-24, -1.5974E-24, -1.5176E-24, -1.4377E-24, -1.3983E-24, -1.3578E-24, &
      -1.2780E-24, -1.2380E-24, -1.1586E-24, -1.1182E-24, -1.0064E-24, -8.3866E-25, &
      -7.0287E-25, -5.9904E-25, -5.1159E-25, -4.4728E-25, -3.8339E-25, -3.3545E-25, &
      -2.8754E-25, -2.5559E-25, -2.2365E-25, -1.9968E-25, -1.6786E-25, -1.5176E-25, &
      -1.3578E-25 /)
    REAL, PARAMETER :: b3_ClONO2(dim55) = (/ &
      3.2253E-20, 3.1856E-20, 3.1018E-20, 2.9900E-20, 2.8714E-20, 2.7600E-20, &
      2.6626E-20, 2.5810E-20, 2.5136E-20, 2.4604E-20, 2.4144E-20, 2.3780E-20, &
      2.3455E-20, 2.3195E-20, 2.2957E-20, 2.2746E-20, 2.2586E-20, 2.2416E-20, &
      2.2254E-20, 2.2158E-20, 2.2018E-20, 2.1913E-20, 2.1804E-20, 2.1734E-20, &
      2.1638E-20, 2.1538E-20, 2.1486E-20, 2.1405E-20, 2.1321E-20, 2.1292E-20, &
      2.1202E-20, 2.1140E-20, 2.1076E-20, 2.1010E-20, 2.0976E-20, 2.0941E-20, &
      2.0869E-20, 2.0832E-20, 2.0756E-20, 2.0716E-20, 2.0604E-20, 2.0415E-20, &
      2.0245E-20, 2.0102E-20, 1.9971E-20, 1.9866E-20, 1.9754E-20, 1.9664E-20, &
      1.9568E-20, 1.9500E-20, 1.9428E-20, 1.9371E-20, 1.9291E-20, 1.9249E-20, &
      1.9205E-20 /)
    REAL, PARAMETER :: a4_ClONO2(3) = (/ 1.3462E-20, -1.5949E-24, 2.8270E-28 /)
    REAL, PARAMETER :: a5_ClONO2(3) = (/ 4.9350E-21, -6.2621E-25, 8.8046E-29 /)
    REAL, PARAMETER :: a6_ClONO2(1) = (/ 9.9971E-22 /)
    ! T-dep parameters:
    REAL, PARAMETER :: c0_1_1_ClONO2(dim58) = (/ &
      -7.5614E-04, -4.5783E-04, -9.4689E-04, -9.8414E-04, -6.8564E-04, -1.3215E-03, &
      -1.2880E-03, -1.1412E-03, -1.1796E-03, -2.1917E-03, -2.7985E-03, -2.8382E-03, &
      -3.4397E-03, -3.5192E-03, -3.6009E-03, -4.0583E-03, -4.0602E-03, -4.3299E-03, &
      -5.0119E-03, -5.3204E-03, -5.6690E-03, -5.4158E-03, -6.3635E-03, -6.2238E-03, &
      -6.5364E-03, -6.6975E-03, -6.5581E-03, -6.8013E-03, -6.7778E-03, -7.8844E-03, &
      -7.9385E-03, -8.4472E-03, -9.1070E-03, -9.7697E-03, -1.0626E-02, -1.1897E-02, &
      -1.2041E-02, -1.1871E-02, -1.2166E-02, -1.1549E-02, -1.1125E-02, -1.0686E-02, &
      -9.3035E-03, -8.5937E-03, -8.6383E-03, -7.9996E-03, -7.1333E-03, -6.8137E-03, &
      -5.7360E-03, -4.3062E-03, -1.9380E-03, 1.9304E-04, 2.3934E-03, 4.8932E-03, &
      8.9011E-03, 1.6857E-02, 3.3874E-02, 5.5800E-02 /)
    REAL, PARAMETER :: c0_1_2_ClONO2(dim58) = (/ &
      2.3617E-01, 2.2284E-01, 2.4480E-01, 2.4648E-01, 2.3295E-01, 2.6189E-01, &
      2.6035E-01, 2.5362E-01, 2.5539E-01, 3.0225E-01, 3.3046E-01, 3.3232E-01, &
      3.6053E-01, 3.6427E-01, 3.6814E-01, 3.8987E-01, 3.8995E-01, 4.0287E-01, &
      4.3568E-01, 4.5058E-01, 4.6749E-01, 4.5515E-01, 5.0150E-01, 4.9464E-01, &
      5.1005E-01, 5.1802E-01, 5.1110E-01, 5.2323E-01, 5.2205E-01, 5.7772E-01, &
      5.8045E-01, 6.0624E-01, 6.3982E-01, 6.7369E-01, 7.1761E-01, 7.8307E-01, &
      7.9053E-01, 7.8168E-01, 7.9707E-01, 7.6481E-01, 7.4255E-01, 7.1939E-01, &
      6.4627E-01, 6.0857E-01, 6.1095E-01, 5.7678E-01, 5.3026E-01, 5.1303E-01, &
      4.5473E-01, 3.7709E-01, 2.4802E-01, 1.3146E-01, 1.0659E-02, -1.2708E-01, &
      -3.4872E-01, -7.9029E-01, -1.7381E+00, -2.9638E+00 /)
    REAL, PARAMETER :: c2_ClONO2(3) = (/ 1.00,  0.67, 0.23 /)
    REAL, PARAMETER :: c3_ClONO2(3) = (/ 1.00,  0.90, 0.64 /)
    REAL, PARAMETER :: c4_ClONO2(3) = (/ 1.00,  1.06, 0.85 /)
    REAL, PARAMETER :: c5_ClONO2(3) = (/ 1.00,  1.12, 1.73 /)
    REAL, PARAMETER :: c6_ClONO2(3) = (/ 1.00,  0.67, 0.31 /)

    jval_gp(ip_ClONO2)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        sig_ClONO2(0) = &
          p1(1.,c0_1_1_ClONO2(i0(j,k))*dlv2(j,k) + &
          c0_1_2_ClONO2(i0(j,k)),tnorm_sr(j,k)) * &
          p1(a0_1_1_ClONO2(i0(j,k))*dlv2(j,k) + &
          a0_1_2_ClONO2(i0(j,k)), &
          a0_2_1_ClONO2(i0(j,k))*dlv2(j,k) + &
          a0_2_2_ClONO2(i0(j,k)),v3_du1(j,k))
        sig_ClONO2(1) = &
          (p1(b1_1_ClONO2(i1(j,k)),a1_1_ClONO2(i1(j,k)), &
          v3_du1(j,k)) + &
          p1(b1_2_ClONO2(i1(j,k)),a1_2_ClONO2(i1(j,k)), &
          v3_du1(j,k)) * v2s_m(j,k))
        sig_ClONO2(2) = &
          p2(c2_ClONO2(1),c2_ClONO2(2),c2_ClONO2(3),tnorm(j,k))* &
          p1(b2_ClONO2(i2(j,k)), a2_ClONO2(i2(j,k)), &
          v3_du1(j,k))
        sig_ClONO2(3) = &
          p2(c3_ClONO2(1),c3_ClONO2(2),c3_ClONO2(3),tnorm(j,k))* &
          p1(b3_ClONO2(i3(j,k)), a3_ClONO2(i3(j,k)), &
          v3_du2(j,k))
        sig_ClONO2(4) = &
          p2(c4_ClONO2(1),c4_ClONO2(2),c4_ClONO2(3),tnorm(j,k))* &
          p2(a4_ClONO2(1),a4_ClONO2(2),a4_ClONO2(3),v3_du2(j,k))
        sig_ClONO2(5) = &
          p2(c5_ClONO2(1),c5_ClONO2(2),c5_ClONO2(3),tnorm(j,k))* &
          p2(a5_ClONO2(1),a5_ClONO2(2),a5_ClONO2(3),v3_du2(j,k))
        sig_ClONO2(6) = &
          p2(c6_ClONO2(1),c6_ClONO2(2),c6_ClONO2(3),tnorm(j,k))* &
          a6_ClONO2(1)
        dj = &
          sig_ClONO2(0) * fint(j,k,0) * 0.4  + &
          sig_ClONO2(1) * fint(j,k,1) * 0.4  + &
          sig_ClONO2(2) * fint(j,k,2) * 0.4  + &
          sig_ClONO2(3) * fint(j,k,3) * 0.4  + &
          sig_ClONO2(4) * fint(j,k,4) * 0.35 + &
          sig_ClONO2(5) * fint(j,k,5) * 0.25
        jval_gp(ip_ClONO2)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,3))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_ClONO2

  ! *****************************************

  SUBROUTINE jval_cal_macr(jrow)

    ! MACR -> products
    ! JPL 2006, total quantum yield fitted
    ! first channel to CH2=CCH3 + CHO most likely, C3H6 not seen.

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_macr 

    REAL :: f6

    ! T-const parameters:
    REAL, PARAMETER :: a3_macr(dim55) = (/ &
      2.2318E-25, 1.4224E-25, 8.4374E-26, 5.3568E-26, 3.7145E-26, 2.7383E-26, &
      2.1222E-26, 1.6775E-26, 1.3863E-26, 1.1467E-26, 9.7569E-27, 8.3861E-27, &
      7.3592E-27, 6.3334E-27, 5.6477E-27, 5.1353E-27, 4.4497E-27, 4.1061E-27, &
      3.7671E-27, 3.4247E-27, 3.2478E-27, 2.7398E-27, 2.7396E-27, 2.3973E-27, &
      2.3932E-27, 2.0547E-27, 2.0549E-27, 1.8835E-27, 1.7094E-27, 1.7124E-27, &
      1.3698E-27, 1.5410E-27, 1.3677E-27, 1.1986E-27, 1.1986E-27, 1.1966E-27, &
      1.0272E-27, 1.0275E-27, 8.5607E-28, 1.0257E-27, 7.1894E-28, 5.8200E-28, &
      4.1066E-28, 3.0813E-28, 2.3965E-28, 2.0531E-28, 1.3693E-28, 1.0271E-28, &
      6.8465E-29, 6.8445E-29, 3.4266E-29, 3.4211E-29, 3.4223E-29, 3.4223E-29, &
      -0.0000E+00 /)
    REAL, PARAMETER :: b3_macr(dim55) = (/ &
      1.5812E-22, 1.6289E-22, 1.6968E-22, 1.7509E-22, 1.7894E-22, 1.8180E-22, &
      1.8396E-22, 1.8578E-22, 1.8714E-22, 1.8840E-22, 1.8940E-22, 1.9029E-22, &
      1.9101E-22, 1.9179E-22, 1.9235E-22, 1.9280E-22, 1.9344E-22, 1.9378E-22, &
      1.9414E-22, 1.9452E-22, 1.9472E-22, 1.9535E-22, 1.9535E-22, 1.9581E-22, &
      1.9581E-22, 1.9631E-22, 1.9631E-22, 1.9658E-22, 1.9686E-22, 1.9686E-22, &
      1.9746E-22, 1.9715E-22, 1.9747E-22, 1.9780E-22, 1.9780E-22, 1.9780E-22, &
      1.9816E-22, 1.9816E-22, 1.9854E-22, 1.9815E-22, 1.9887E-22, 1.9923E-22, &
      1.9973E-22, 2.0006E-22, 2.0030E-22, 2.0043E-22, 2.0071E-22, 2.0086E-22, &
      2.0102E-22, 2.0102E-22, 2.0120E-22, 2.0120E-22, 2.0120E-22, 2.0120E-22, &
      2.0142E-22 /)
    REAL, PARAMETER :: a4_macr(2)= (/2.3481E-22,  1.9076E-27/)
    REAL, PARAMETER :: a5_macr(2)= (/2.5435E-22, -1.2548E-27/)
    REAL, PARAMETER :: a6_macr(2)= (/3.8102E-23, -2.5458E-28/)
    jval_gp(ip_macr)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j  = 1,kproma_day
        !  PREL = (MIN(1.E5,PRESS(J,K))/PRESS_REF) !relative pressure (calc for 1000hpa)
        sig_MACR(3) = &
          p1(b3_MACR(i3(j,k)), a3_MACR(i3(j,k)),v3_du2(j,k))
        sig_MACR(4) = &
          p1(a4_MACR(1),a4_MACR(2),v3_du2(j,k))
        sig_MACR(5) = &
          p1(a5_MACR(1),a5_MACR(2),v3_du2(j,k))
        sig_MACR(6) = &
          p1(a6_MACR(1),a6_MACR(2),v3_du2(j,k))
        f6=1025./0.5856/(1000.+0.0075*press(j,k))
        dj=sig_MACR(3) *F6* fint(j,k,3) + &
          sig_MACR(4)* F6 * fint(j,k,4) + &
          sig_MACR(5)* F6 * fint(j,k,5) + &
          sig_MACR(6)* F6 * fint(j,k,6)
        jval_gp(ip_macr)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO
  END SUBROUTINE jval_cal_macr

  ! **************************************************************************

  SUBROUTINE jval_cal_mvk(jrow)

    ! MVK -> products
    ! JPL 2006, cross sections and total quantum yield, channels:
    ! 60% to C3H6 + CO
    ! 20% to CH2CHCO + CH3
    ! 20% to C2H3 + CH3CO (IUPAC)

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_mvk 

    REAL :: f6

    ! T-const parameters:
    REAL, PARAMETER :: a3_mvk(dim55) = (/ &
      -7.8560E-25,-5.2719E-25,-3.3545E-25,-2.2933E-25,-1.6775E-25,-1.3178E-25, &
      -1.0782E-25,-8.9010E-26,-7.3594E-26,-6.5036E-26,-5.6485E-26,-4.9635E-26, &
      -4.4496E-26,-3.9370E-26,-3.4231E-26,-3.2522E-26,-2.9095E-26,-2.7374E-26, &
      -2.3971E-26,-2.2263E-26,-2.0512E-26,-1.8836E-26,-1.8836E-26,-1.7121E-26, &
      -1.5386E-26,-1.3697E-26,-1.3701E-26,-1.3697E-26,-1.1965E-26,-1.0274E-26, &
      -1.0277E-26,-1.0274E-26,-1.0256E-26,-8.5621E-27,-6.8469E-27,-8.5474E-27, &
      -6.8503E-27,-6.8504E-27,-6.8469E-27,-6.8386E-27,-5.1355E-27,-3.7652E-27, &
      -3.0804E-27,-2.0541E-27,-1.7118E-27,-1.3691E-27,-1.0267E-27,-6.8514E-28, &
      -3.4211E-28,-6.8445E-28,-3.4223E-28,-0.0000E+00,-3.4223E-28,-0.0000E+00, &
      -3.4280E-28 /)
    REAL, PARAMETER :: b3_mvk(dim55) = (/ &
      1.8978E-21, 1.8826E-21, 1.8601E-21, 1.8414E-21, 1.8270E-21, 1.8165E-21, &
      1.8081E-21, 1.8003E-21, 1.7931E-21, 1.7886E-21, 1.7836E-21, 1.7792E-21, &
      1.7756E-21, 1.7717E-21, 1.7675E-21, 1.7660E-21, 1.7628E-21, 1.7611E-21, &
      1.7575E-21, 1.7556E-21, 1.7536E-21, 1.7515E-21, 1.7515E-21, 1.7492E-21, &
      1.7468E-21, 1.7443E-21, 1.7443E-21, 1.7443E-21, 1.7415E-21, 1.7386E-21, &
      1.7386E-21, 1.7386E-21, 1.7386E-21, 1.7353E-21, 1.7319E-21, 1.7354E-21, &
      1.7318E-21, 1.7318E-21, 1.7318E-21, 1.7318E-21, 1.7278E-21, 1.7242E-21, &
      1.7222E-21, 1.7189E-21, 1.7177E-21, 1.7164E-21, 1.7150E-21, 1.7135E-21, &
      1.7119E-21, 1.7136E-21, 1.7118E-21, 1.7099E-21, 1.7119E-21, 1.7098E-21, &
      1.7120E-21/)
    REAL, PARAMETER :: a6_mvk(2)= (/4.1874E-23, -3.9217E-28/)
    REAL, PARAMETER :: a5_mvk(3)= (/8.0692E-22, -5.8770E-26,  4.5077E-30/)
    REAL, PARAMETER :: a4_mvk(2)= (/1.4748E-21, -1.4195E-26/)
    jval_gp(ip_mvk)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j  = 1,kproma_day
        ! drel = dens(j,k)/dens_ref (32.16=denom with dens=2.90e19 used for fit in f6)
        sig_MVK(3) = &
          p1(b3_MVK(i3(j,k)), a3_MVK(i3(j,k)),v3_du2(j,k))
        sig_MVK(4) = &
          p1(a4_MVK(1),a4_MVK(2),v3_du2(j,k))
        sig_MVK(5) = &
          p2(a5_MVK(1),a5_MVK(2),a5_MVK(3),v3_du2(j,k))
        sig_MVK(6) = &
          p1(a6_MVK(1),a6_MVK(2),v3_du2(j,k))
        f6=32.16/(5.5+9.2E-19*dens(j,k))
        dj=sig_MVK(3) *F6* fint(j,k,3) + &
          sig_MVK(4)* F6 * fint(j,k,4) + &
          sig_MVK(5)* F6 * fint(j,k,5) + &
          sig_MVK(6)* F6 * fint(j,k,6)
        jval_gp(ip_mvk)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO
  END SUBROUTINE jval_cal_mvk

  ! *****************************************

  SUBROUTINE jval_cal_glyox(jrow)

    ! CHOCHO -> 2 CHO   (CHOCHO = glyox = glyoxal)
    ! Tadic et al, 2006, JPPA 177, only total yield

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_glyox 

    REAL :: f6
    REAL :: prel

    ! T-const parameters:
    REAL, PARAMETER :: a3_glyox(dim55) = (/ &
      -2.1052E-24, -4.6556E-24, -5.3568E-24, -5.1857E-24, -4.7073E-24, -4.1759E-24, &
      -3.6967E-24, -3.2523E-24, -2.8752E-24, -2.5501E-24, -2.2766E-24, -2.0366E-24, &
      -1.8313E-24, -1.6604E-24, -1.4889E-24, -1.3694E-24, -1.2493E-24, -1.1463E-24, &
      -1.0616E-24, -9.7599E-25, -9.0600E-25, -8.3905E-25, -7.8765E-25, -7.3631E-25, &
      -6.8374E-25, -6.3356E-25, -5.9932E-25, -5.6507E-25, -5.1285E-25, -4.9657E-25, &
      -4.6232E-25, -4.4523E-25, -4.1022E-25, -3.9383E-25, -3.5963E-25, -3.4184E-25, &
      -3.2539E-25, -3.0818E-25, -2.9114E-25, -2.7346E-25, -2.2938E-25, -1.7117E-25, &
      -1.3004E-25, -9.5862E-26, -7.5320E-26, -5.4749E-26, -4.4513E-26, -3.0807E-26, &
      -2.3963E-26, -2.0531E-26, -1.3695E-26, -1.0273E-26, -1.0265E-26, -6.8473E-27, &
      -3.4280E-27 /)
    REAL, PARAMETER :: b3_glyox(dim55) = (/ &
      3.5916E-20, 3.6066E-20, 3.6149E-20, 3.6119E-20, 3.6007E-20, 3.5851E-20, &
      3.5683E-20, 3.5501E-20, 3.5324E-20, 3.5153E-20, 3.4993E-20, 3.4839E-20, &
      3.4695E-20, 3.4565E-20, 3.4425E-20, 3.4320E-20, 3.4208E-20, 3.4105E-20, &
      3.4016E-20, 3.3921E-20, 3.3839E-20, 3.3757E-20, 3.3691E-20, 3.3622E-20, &
      3.3548E-20, 3.3475E-20, 3.3423E-20, 3.3369E-20, 3.3283E-20, 3.3256E-20, &
      3.3196E-20, 3.3165E-20, 3.3099E-20, 3.3068E-20, 3.3000E-20, 3.2963E-20, &
      3.2929E-20, 3.2891E-20, 3.2854E-20, 3.2813E-20, 3.2710E-20, 3.2557E-20, &
      3.2437E-20, 3.2327E-20, 3.2255E-20, 3.2177E-20, 3.2135E-20, 3.2075E-20, &
      3.2043E-20, 3.2026E-20, 3.1990E-20, 3.1971E-20, 3.1971E-20, 3.1950E-20, &
      3.1928E-20 /)
    REAL, PARAMETER :: a4_glyox(2) = (/3.0906E-20, 1.9869E-25/)
    REAL, PARAMETER :: a5_glyox(3) = (/ 1.5819E-20,-1.1829E-24, 8.9498E-29/)
    REAL, PARAMETER :: a6_glyox(2) = (/1.7007E-21,-6.2818E-27/)
    REAL, PARAMETER :: a7_glyox(2) = (/1.9405E-23, 1.3357E-27/)
    jval_gp(ip_glyox)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j  = 1,kproma_day
        PREL = (MIN(1.E5,PRESS(J,K))/PRESS_REF)  !relative pressure
        sig_glyox(3) = &
          p1(b3_glyox(i3(j,k)), a3_glyox(i3(j,k)),v3_du2(j,k))
        sig_glyox(4) = &
          p1(a4_glyox(1),a4_glyox(2),v3_du2(j,k))
        sig_glyox(5) = &
          p2(a5_glyox(1),a5_glyox(2),a5_glyox(3),v3_du2(j,k))
        sig_glyox(6) = &
          p1(a6_glyox(1),a6_glyox(2),v3_du2(j,k))
        sig_glyox(7) = &
          p1(a7_glyox(1),a7_glyox(2),v3_du2(j,k))
        f6=25.7/(6.8+ 1.89*prel)
        dj=sig_glyox(3) *    fint(j,k,3) + &
          sig_glyox(4)*      fint(j,k,4) + &
          sig_glyox(5)*      fint(j,k,5) + &
          sig_glyox(6)* F6 * fint(j,k,6) + &
          sig_glyox(7)* F6 * fint(j,k,7)
        jval_gp(ip_glyox)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,6))
      ENDDO
    ENDDO
  END SUBROUTINE jval_cal_glyox

  ! *****************************************

  SUBROUTINE jval_cal_hoch2cho(jrow)

    ! HOCH2CHO -> products
    ! JPL 2006, total quantum yield assumed to be 0.5 (included, lower
    ! limit, not clear if wavelength dependence similar to acetone
    ! should be included; suggested products: 80% CH2OH+CHO, 20%
    ! CH3OH+CO) total quantum yield can be also 0.75

    INTEGER, INTENT(IN) :: jrow

    INTEGER :: j, k
    REAL :: dj
    REAL, DIMENSION(0:MAXWAV) :: sig_HOCH2CHO 

    ! T-const parameters:
    REAL, PARAMETER :: a3_HOCH2CHO(dim55) = (/ &
      -4.0324E-23,-2.6034E-23,-1.5797E-23,-1.0286E-23,-7.3434E-24,-5.5622E-24, &
      -4.4155E-24,-3.5775E-24,-2.9779E-24,-2.5158E-24,-2.1568E-24,-1.8826E-24, &
      -1.6259E-24,-1.4379E-24,-1.2836E-24,-1.1469E-24,-1.0269E-24,-9.2387E-25, &
      -8.3904E-25,-7.7054E-25,-7.0086E-25,-6.3356E-25,-5.9930E-25,-5.4796E-25, &
      -4.9572E-25,-4.6232E-25,-4.4521E-25,-3.9383E-25,-3.7607E-25,-3.5959E-25, &
      -3.2534E-25,-3.0821E-25,-2.9060E-25,-2.5686E-25,-2.5685E-25,-2.3931E-25, &
      -2.2260E-25,-2.0548E-25,-1.8836E-25,-1.8803E-25,-1.5063E-25,-1.1297E-25, &
      -8.2137E-26,-6.1623E-26,-4.7928E-26,-3.4222E-26,-2.7389E-26,-1.7118E-26, &
      -1.7110E-26,-1.0271E-26,-1.0271E-26,-6.8450E-27,-3.4237E-27,-3.4236E-27, &
      -3.4225E-27 /)
    REAL, PARAMETER :: b3_HOCH2CHO(dim55) = (/ &
      2.0791E-20, 1.9949E-20, 1.8748E-20, 1.7779E-20, 1.7090E-20, 1.6569E-20, &
      1.6166E-20, 1.5823E-20, 1.5542E-20, 1.5299E-20, 1.5089E-20, 1.4913E-20, &
      1.4733E-20, 1.4590E-20, 1.4464E-20, 1.4344E-20, 1.4231E-20, 1.4129E-20, &
      1.4040E-20, 1.3964E-20, 1.3882E-20, 1.3800E-20, 1.3756E-20, 1.3687E-20, &
      1.3613E-20, 1.3565E-20, 1.3539E-20, 1.3457E-20, 1.3428E-20, 1.3400E-20, &
      1.3340E-20, 1.3309E-20, 1.3276E-20, 1.3211E-20, 1.3211E-20, 1.3175E-20, &
      1.3140E-20, 1.3103E-20, 1.3065E-20, 1.3065E-20, 1.2977E-20, 1.2878E-20, &
      1.2788E-20, 1.2722E-20, 1.2674E-20, 1.2622E-20, 1.2594E-20, 1.2549E-20, &
      1.2549E-20, 1.2515E-20, 1.2515E-20, 1.2496E-20, 1.2476E-20, 1.2476E-20, &
      1.2476E-20/)
    REAL, PARAMETER :: a4_HOCH2CHO(3) = (/7.8392E-21,-7.4842E-25, 6.9644E-29/)
    REAL, PARAMETER :: a5_HOCH2CHO(3) = (/1.1074E-21,-2.7036E-25, 2.2865E-29/)
    jval_gp(ip_HOCH2CHO)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j  = 1,kproma_day
        sig_HOCH2CHO(3) = &
          p1(b3_HOCH2CHO(i3(j,k)), a3_HOCH2CHO(i3(j,k)),v3_du2(j,k))
        sig_HOCH2CHO(4) = &
          p2(a4_HOCH2CHO(1),a4_HOCH2CHO(2),a4_HOCH2CHO(3),v3_du2(j,k))
        sig_HOCH2CHO(5) = &
          p2(a5_HOCH2CHO(1),a5_HOCH2CHO(2),a5_HOCH2CHO(3),v3_du2(j,k))
        dj=sig_HOCH2CHO(3) * fint(j,k,3) + &
          sig_HOCH2CHO(4)  * fint(j,k,4) + &
          sig_HOCH2CHO(5)  * fint(j,k,5)
        jval_gp(ip_HOCH2CHO)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,5))
      ENDDO
    ENDDO
  END SUBROUTINE jval_cal_hoch2cho

  ! **************************************************************************

  SUBROUTINE jval_cal_ch4(jrow)

    ! CH4 -> products
    ! Lyman-alpha absorption cross section 1.8E-17cm^2 from Turco (1975) in
    ! Geophysical Surveys 2 (Reidel/ Springer-link)

    INTEGER, INTENT(IN) :: jrow

    REAL :: dj
    INTEGER :: j, k
    jval_gp(ip_ch4)%ptr(:,:,jrow) = vinit
    DO k = 1,klev
      DO j = 1,kproma_day
        dj = 1.8E-17*r_m(j,k)*phi_la
        jval_gp(ip_ch4)%ptr(iu0(j),k,jrow) = MAX(vinit, dj*fj_corr(j,8))
      ENDDO
    ENDDO

  END SUBROUTINE jval_cal_ch4

  ! **************************************************************************
