# ----------------------------------------------------------------------------
#
# Author:
#   Rolf Sander, Max-Planck-Institute, Mainz, Germany, 2010-...
#
# Time-stamp: <2010-09-14 17:15:18 sander>
#
# findrefs.awk finds references
#
# usage:
# gawk -f findrefs.awk gas.eqn gas_mim1.eqn aqueous.eqn messy_cmn_gasaq.f90 > citefind.txt
#
# ----------------------------------------------------------------------------

{
    # store BibTeX references like {&1400} in ref:
    # - either allow only numbers:
    if (match($0, "{&+([0-9]*)}", arr) != 0) {
    # - or allow anything:
    #   if (match($0, "{&+([^}]*)}", arr) != 0) {
      ref = arr[1]
      if (ref!="") {
        # transform comma-separated values to one number per line:
        gsub("[, ]+", "\n", ref)
        # print ref(s) to output file:
        printf "%s\n", ref #>> outfile
      }
    }
}

# ----------------------------------------------------------------------------
