<?php
  require_once('common.php');
  set_time_limit(0);

  $out = tmpfile();
  if ($_REQUEST['submit'] == 'multi-run')
  {
    // sanity checks
    if (!isset($_REQUEST['var']['y1'])) die('No Y1 set!');
    if (!isset($_REQUEST['set_par0'])) die('No lc set!');
    if (!isset($_REQUEST['set_par1'])) die('No pt set!');
    if (!isset($_REQUEST['set_par2'])) die('No lw set!');
    if (count($_REQUEST['set_vals'][$_REQUEST['set_par0']]) == 0) die('Empty lc set!');
    if (count($_REQUEST['set_vals'][$_REQUEST['set_par1']]) == 0) die('Empty pt set!');
    if (count($_REQUEST['set_vals'][$_REQUEST['set_par2']]) == 0) die('Empty lw set!');
    if (!isset($_REQUEST['var']['par'])) die('No X set!');
    if (strlen(trim($_REQUEST['var']['x_0'])) == 0) die('No X= set!');
    if (strlen(trim($_REQUEST['var']['x_lt'])) == 0) die('No X< set!');
    if (strlen(trim($_REQUEST['var']['x_incr'])) == 0) die('No X+= set!');
    if ($_REQUEST['var']['x_0'] > $_REQUEST['var']['x_lt']) die('initial X > maximal X!');

    $multiplothead = '
      x = 1 # 1 - x
      t = 2 # 2 - time [s]
      p = 3 # 3 - p [Pa]
      T = 4 # 4 - T [K]
      q = 5 # 5 - q [1]
      m0 = 6 # 6 - m0
      m1 = 7 # 7 - m1
      m2 = 8 # 8 - m2
      m3 = 9 # 9 - m3
      RH_max = 10
      DWPT_elev_max = 11
      final_bins = 12
      
      R_d = 2.871019337017e+02
      R_v = 4.614024417314e+02
      R(q_v) = q_v * R_v + (1 - q_v) * R_d
      B(p,q) = ibeta(p,q,1)
      S_Twomey(w, c, k) = ((1.63e-3 * (w*100.) ** (3./2.)) / (c * k * B(3./2., k/2.))) ** (1./(k+2.))
      N_Twomey(S, c, k) = c * S ** k    # N[cm-3] w[m/s]
      rho_w_0 = 1000.
      delta(x,x0,dx,y) = (x < (x0 - dx / 2) || x > (x0 + dx / 2) ? 1./0 : y)
      ' . (count($_REQUEST['var']['y1']) <= 3 ? 'set grid' : '') . '
      ' . (count($_REQUEST['var']['y1']) <= 3 ? 'set key below' : 'set nokey') . '
      set ytics format "%6.4g"
      
      set size ' . (1. / count($_REQUEST['var']['y1'])) . ',' . (1. / count($_REQUEST['var']['y1'])) . '
    ';
    if ($_REQUEST['var']['x1'] != 'X') $_REQUEST['var']['x_label'][$_REQUEST['var']['par']] = $_REQUEST['var']['x1'];
    $multiplothead .= 'set xlabel "' . $_REQUEST['var']['x_label'][$_REQUEST['var']['par']] . '"' . "\n";
    
    for ($i=0; $i < count($_REQUEST['var']['y1']); ++$i)
    {
      $multiplotplot[$i] = 'set ylabel "' . $_REQUEST['var']['y1'][$i] . '"' . "\n";
      $multiplotplot[$i] .= 'set origin ' . ($i / count($_REQUEST['var']['y1'])) . ',0' . "\n";
      $multiplotplot[$i] .=  'plot NaN t \'\'';
      if ($_REQUEST['var']['x_label'][$_REQUEST['var']['par']] == 'U[m/s]' && $_REQUEST['var']['y1'][$i] == 'N[cm-3]') 
      {
        $multiplotplot[$i] .= ', N_Twomey(S_Twomey(x, 2000, 2./5.), 2000, 2./5.) w filledcurves x1 lc 1 t \'Twomey 1959 continental (C)\'';
        $multiplotplot[$i] .= ', N_Twomey(S_Twomey(x, 125, 1./3.), 125, 1./3.) w filledcurves x1 lc 2 t \'Twomey 1959 maritime (A)\'';
        //$multiplotplot[$i] .= ', N_Twomey(S_Twomey(x, 160, 1./4.), 160, 1./4.) t \'Twomey 1959 maritime (B)\'';
        //$multiplotplot[$i] .= ', N_Twomey(S_Twomey(x, 1.26e3, .308), 1.26e3, .308) t \'Seifert/Beheng 2005 continental\'';
        //$multiplotplot[$i] .= ', N_Twomey(S_Twomey(x, 1e2, .462), 1e2, .462) t \'Seifert/Beheng 2005 maritime\'';
      }
      else if ($_REQUEST['var']['x_label'][$_REQUEST['var']['par']] == 'U[m/s]' && $_REQUEST['var']['y1'][$i] == 'DWPT_elev_max[K]') 
      {
        $multiplotplot[$i] .= ', S_Twomey(x, 125, 1./3.) w filledcurves x1 lc 2 t \'Twomey 1959 maritime (A)\'';
        //$multiplotplot[$i] .= ', S_Twomey(x, 160, 1./4.) t \'Twomey 1959 maritime (B)\'';
        $multiplotplot[$i] .= ', S_Twomey(x, 2000, 2./5.) w filledcurves x1 lc 1 t \'Twomey 1959 continental (C)\'';
        //$multiplotplot[$i] .= ', S_Twomey(x, 1.26e3, .308) t \'Seifert/Beheng 2005 continental\'';
        //$multiplotplot[$i] .= ', S_Twomey(x, 1e2, .462) t \'Seifert/Beheng 2005 maritime\'';
      }
      else if ($_REQUEST['var']['x_label'][$_REQUEST['var']['par']] == 'S_max[%]' && $_REQUEST['var']['y1'][$i] == 'N[cm-3]')
      {
/*
        $multiplothead .= 'set arrow from .21,58.2812 to .21,108.194 nohead lt 8' . "\n";
        $multiplotplot[$i] .= ', delta(x,.21,.02,58.2812) lt 8 lw 1 t \'\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,70.8333) lt 8 lw 2 t \'\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,79.8438) lt 8 lw 3 t \'\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,87.1429) lt 8 lw 4 t \'CCNC obs.\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,96.9773) lt 8 lw 3 t \'\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,99.7727) lt 8 lw 2 t \'\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,108.194) lt 8 lw 1 t \'\'';

        $multiplothead .= 'set arrow from .21,831.250 to .21,1065.94 nohead lt 8' . "\n";
        $multiplotplot[$i] .= ', delta(x,.21,.02,831.250) lt 8 lw 1 t \'\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,881.250) lt 8 lw 2 t \'\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,914.750) lt 8 lw 3 t \'\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,946.333) lt 8 lw 4 t \'CCNC obs.\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,989.150) lt 8 lw 3 t \'\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,1015.62) lt 8 lw 2 t \'\'';
        $multiplotplot[$i] .= ', delta(x,.21,.02,1065.94) lt 8 lw 1 t \'\'';
*/
      }
      $lc = 0;
      foreach ($_REQUEST['set_vals'][$_REQUEST['set_par0']] as $val0)
      {
        $lc++; $pt = 0; 
        foreach ($_REQUEST['set_vals'][$_REQUEST['set_par1']] as $val1)
        {
          $pt++; $lw = 0;
          foreach ($_REQUEST['set_vals'][$_REQUEST['set_par2']] as $val2)
          {
            $lw++;
            $multiplotplot[$i] .= ',';
            $multiplotplot[$i] .= '\'-\' using ' . $y[$_REQUEST['var']['x1']] . ':' . $y[$_REQUEST['var']['y1'][$i]] . ' with linespoints';
            $multiplotplot[$i] .= ' t \'' . $val0 . ' / ' . $val1 . ' / ' . $val2 . '\'';
            $multiplotplot[$i] .= ' lc ' . $lc;
            $multiplotplot[$i] .= ' pt ' . $pt;
            $multiplotplot[$i] .= ' lw ' . $lw;
            $first = false;
          }
        }
      }
      $multiplotplot[$i] .= "\n";
    }

    $_REQUEST['var']['par'] = explode('-', $_REQUEST['var']['par']);
    $_REQUEST['set_par0'] = explode('-', $_REQUEST['set_par0']);
    $_REQUEST['set_par1'] = explode('-', $_REQUEST['set_par1']);
    $_REQUEST['set_par2'] = explode('-', $_REQUEST['set_par2']);
  }
  else
  {
    $_REQUEST['var']['x_0'] = 0;
    $_REQUEST['var']['x_lt'] = 1;
    $_REQUEST['var']['x_incr'] = 1;
    $_REQUEST['set_par0'] = array('');
    $_REQUEST['set_par1'] = array('');
    $_REQUEST['set_par2'] = array('');
    $_REQUEST['set_vals'][''] = array('');
  }

  // purging out-of-focus fields
  if (isset($_REQUEST['cmd']) && is_array($_REQUEST['cmd'])) 
  {
    foreach ($_REQUEST['cmd'] as $k => &$v) 
    {
      foreach ($v as $kk => &$vv) if ($kk > 0)
      {
        $min = $_REQUEST['fcs'][$k][$_REQUEST['cmd'][$k][0]]['min'];
        $max = $_REQUEST['fcs'][$k][$_REQUEST['cmd'][$k][0]]['max'];
        if ($kk < $min || $kk > $max) unset($_REQUEST['cmd'][$k][$kk]);
      }
    }
  }
  unset($v);

  // subscripts, superscripts
  if (isset($multiplotplot))
  {
    $tr = array('_max['=>'_{max} [', 'cm-3'=>'cm^{-3}', ' / wet / wet'=>'', 'kappa'=>'\kappa');
    foreach ($multiplotplot as $k => $v) $multiplotplot[$k] = strtr($v, $tr);
    $multiplothead = strtr($multiplothead, $tr); 
  }
  
  // handling file uploads
  if (count($_FILES) > 0) foreach ($_FILES as $n => $a) if (strlen($a['name']) > 0)
  {
    $_REQUEST['cmd'][strtok($n, '-')][strtok('-')] = $a['tmp_name'];
  }

  // run all processes in paralel
  foreach ($_REQUEST['set_vals'][implode($_REQUEST['set_par0'], '-')] as $set_val0)
  {
    foreach ($_REQUEST['set_vals'][implode($_REQUEST['set_par1'], '-')] as $set_val1)
    {
      foreach ($_REQUEST['set_vals'][implode($_REQUEST['set_par2'], '-')] as $set_val2)
      {
        $outs = array();
        $prcs = array();
        $pips = array();
        $done = array();
        for ($x = 1 * $_REQUEST['var']['x_0']; $x < 1 * $_REQUEST['var']['x_lt']; $x += 1 * $_REQUEST['var']['x_incr']) 
        {
          $cmd = 'exec nice -1 ../src/drops';
      
          if (count($_REQUEST['cmd']) > 0) foreach ($_REQUEST['cmd'] as $k => $v)
          {
            if ($_REQUEST['submit'] == 'multi-run')
            {
              if ($k == $_REQUEST['var']['par'][0]) $v[$_REQUEST['var']['par'][1]] = $x;
              if ($k == $_REQUEST['set_par0'][0]) $v[$_REQUEST['set_par0'][1]] = $set_val0;
              if ($k == $_REQUEST['set_par1'][0]) $v[$_REQUEST['set_par1'][1]] = $set_val1;
              if ($k == $_REQUEST['set_par2'][0]) $v[$_REQUEST['set_par2'][1]] = $set_val2;
              if ($k == 'output') 
              {
                $v[0] = 'GnuplotOneLine';
                $v = array($v[0], $v[1], $v[2], $v[3]);
              }
            }
            $cmd .= ' --' . $k . ' ' . implode(' ', $v);
          }
          $cmd = strtr($cmd, array('('=>'\(', ')'=>'\)', '['=>'\[', ']'=>'\]'));
    
          $outs[] = tmpfile();
          if ($_REQUEST['submit'] == 'multi-run') fwrite($outs[count($outs) - 1], $x . "\t");
          $prcs[] = proc_open($cmd, array(array("pipe", "r"), $outs[count($outs) - 1], array("pipe", "w")), $pipes);
          $pips[] = $pipes;
          $done[] = false;
        }
    
        // execution-time logic: error handling, waiting for all processes to finish
        $todo = count($prcs);
        while ($todo > 0)
        {
          foreach ($prcs as $i => $process) if (!$done[$i])
          {
            $status = proc_get_status($process);
            if ($status['running'] == FALSE || $status['exitcode'] == -1)
            {
              if ($status['exitcode'] != 0)
              {
                $err = '';
                while (!feof($pips[$i][2])) $err .= fread($pips[$i][2], 8192);
                if (substr($err, -12, 11) != '-- exit: OK') // TODO: ciema!!!
                { 
                  echo('<html><body><pre>');
                  echo('$ ' . $cmd . "\n");
                  echo($err);
                  echo('</pre></body></html>');
                  exit();
                }
              }
    
              $done[$i] = true;
              --$todo;
            }
          }
          usleep(50000);
        }
  
        // 
        foreach ($outs as $i => $f)
        {
          rewind($f);
          fseek($out, 0, SEEK_END);
          fwrite($out, stream_get_contents($f));
          fclose($f);
          proc_close($prcs[$i]);
        }
   
        if ($_REQUEST['submit'] == 'multi-run') fwrite($out, 'e' . "\n");
      }
    }
  }
  
  $svg = tmpfile();
  $gprocess = proc_open('gnuplot', 
    array(array("pipe", "r"), $svg, array("pipe", "w")), $gpipes);

  fwrite($gpipes[0], 'set term svg dynamic enhanced');
  if ($_REQUEST['submit'] == 'multi-run') 
    fwrite($gpipes[0], ' font "Arial,' . floor(12. / sqrt(count($_REQUEST['var']['y1']))) . '"');
  else
    fwrite($gpipes[0], ' enhanced font "Arial,8"');
  fwrite($gpipes[0], "\n");

  if ($_REQUEST['submit'] == 'multi-run')
  {
    fwrite($gpipes[0], $multiplothead);
    foreach ($multiplotplot as $plot)
    {
      fwrite($gpipes[0], $plot);
      rewind($out);
      fwrite($gpipes[0], stream_get_contents($out));
    }
  }
  else
  {
    rewind($out);
    fwrite($gpipes[0], stream_get_contents($out));
  }
  fclose($out);
  fclose($gpipes[0]);

  stream_set_blocking($gpipes[2], 1);
  $err = '';
  while (!feof($gpipes[2])) $err .= fread($gpipes[2], 8192);

  if (proc_close($gprocess) != 0)
  {
    echo('<html><body><pre>');
    echo($err);
    echo('</pre></body></html>');
  }
  else
  {
    rewind($svg);
    header("Content-type: image/svg+xml");
    echo(stream_get_contents($svg));
  }

?>
