<?php
  require_once('common.php');
?>
<html>
  <body style="font-family:monospace;">
    <style type="text/css">
      select, input {font-family:monospace; font-size:8pt;}
    </style>
    <form target="plot" action="plot.php" method="post" enctype="multipart/form-data">
      <fieldset>
        <legend>single-run parameters</legend>
<?php
  // parsing help
  exec('../src/drops --help 2>&1', $help);
  $form = array();
  foreach ($help as $i => $line)
  {
    if ($i > 6 && substr($line, 0, 9) == '-- help: ')
    {
      $line = strtr(substr($line, 9), array(' | ' => '|'));
      if (substr($line, 0, 2) != '- ')
      {
        next($form);
        $form[substr($line, 0, -1)] = array();
      } 
      else
      {
        $line = explode(' ', $line);
        $arr = array();
        for ($i = 2; $i < count($line); ++$i) $arr[] = $line[$i];
        $form[key($form)][$line[1]] = $arr;
      }
    }
  }

  // printing HTML form
  foreach ($form as $field => $options)
  {
    if (count($options) == 1 && count(current($options)) == 0)
    {
      echo('      <input type="hidden" name="cmd[' . $field . '][0]" value="' . key($options) . '" />' . "\n");
    }
    else 
    {
      echo('      <fieldset>' . "\n");
      echo('        <legend>' . $field . '</legend>' . "\n");
      $cnt = 1; 
      foreach ($options as $o => $oo) 
      {
        $default = '';
        if (substr($o, -1, 1) == '*') 
        {
          $o = substr($o, 0, -1);
          $default = ' checked="checked"';
        }
        echo('        <fieldset>' . "\n");
        echo('          <legend>' . "\n");
        echo('            <label for="cmd_' . $field . '">' . $o . '</label>' . "\n");
        echo('            <input type="radio" id="cmd_' . $field . '" name="cmd[' . $field. '][0]" value="' . $o . '" ' . $default . '/>' . "\n");
        echo('          </legend>' . "\n");
        echo('          <input type="hidden" name="fcs[' . $field . '][' . $o . '][min]" value="' . $cnt . '" />');
        foreach ($oo as $ooo)
        {
          if (substr_count($ooo, '|') > 0)
          {
            foreach (array(false, true) as $multiple)
            {
              echo('          <select name="' . (!$multiple ? 'cmd[' . $field. '][' . $cnt . ']' : 'set_vals[' . $field . '-' . $cnt . '][]') . '"');
              echo(' size="' . (substr_count($ooo, '|') + 2) . '"');
              if ($multiple) echo(' multiple="multiple"');
              echo('>' . "\n");
              echo('            <option value="">...</option>' . "\n");
              foreach (explode('|', $ooo) as $oooo) 
              {
                $default = '';
                if (substr($oooo, -1, 1) == '*') 
                {
                  $oooo = substr($oooo, 0, -1);
                  if (!$multiple) $default = ' selected="selected"';
                }
                echo('            <option value="' . $oooo . '"' . $default . '>' . $oooo . '</option>' . "\n");
              }
              echo('          </select>' . "\n");
            }
            echo('          <br />');
            echo('          <label for="set_par0">lc</label>' . "\n");
            echo('          <input type="radio" id="set_par0" name="set_par0" value="' . $field . '-' . $cnt . '" />' . "\n");
            echo('          <label for="set_par1">pt</label>' . "\n");
            echo('          <input type="radio" id="set_par1" name="set_par1" value="' . $field . '-' . $cnt . '" />' . "\n");
            echo('          <label for="set_par2">lw</label>' . "\n");
            echo('          <input type="radio" id="set_par2" name="set_par2" value="' . $field . '-' . $cnt . '" />' . "\n");
            echo('          <br />' . "\n");
          }
          else if ($ooo == "filename")
          {
            echo('          <input type="file" name="' . $field . '-' . $cnt. '" />' . "\n");
            echo('          <input type="hidden" name="cmd[' . $field . '][' . $cnt . ']" />' . "\n");
          }
          else
          {
            $default = '';
            if (($pos = strpos($ooo, '*')) !== FALSE)
            {
              $default = ' value="' . substr($ooo, $pos + 1) . '"';
              $ooo = substr($ooo, 0, $pos);
            }
            echo('          <label for="' . $field . '">' . $ooo . '</label>' . "\n");
            echo('          <br />' . "\n");
            echo('          <input type="text" id="' . $field . '" name="cmd[' . $field . '][' . $cnt . ']" ' . $default . '/>' . "\n");
            echo('          <label for="var_par">X</label>' . "\n");
            echo('          <input type="radio" id="var_par" name="var[par]" value="' . $field . '-' . $cnt . '" />' . "\n");
            echo('          <input type="hidden" name="var[x_label][' . $field . '-' . $cnt . ']" value="' . $ooo . '" />' . "\n");
            echo('          <br />' . "\n");
          }
          ++$cnt;
        }
        echo('          <input type="hidden" name="fcs[' . $field . '][' . $o . '][max]" value="' . ($cnt - 1) . '" />');
        echo('        </fieldset>' . "\n");
      }
      echo('      </fieldset>' . "\n");
    }
  }
?>
      </fieldset>
      <input type="submit" name="submit" value="single-run" />
      <fieldset>
        <legend>multi-run parameters</legend>

        <label for="var_x_lt">X=</label>
        <input type="text" id="var_x_0" name="var[x_0]" />
        <br />

        <label for="var_x_lt">X&lt;</label>
        <input type="text" id="var_x_lt" name="var[x_lt]" />
        <br />

        <label for="var_x_incr">X+=</label>
        <input type="text" id="var_x_incr" name="var[x_incr]" />
      </fieldset>

      <fieldset> 
        <legend>plot parameters</legend>       

        <label for="var_x1">X1</label>
        <select id="var_x1" name="var[x1]" size="<?php echo(count($y) + 1); ?>">
<?php
foreach ($y as $k => $v)
{
  echo('          <option value="' . htmlspecialchars($k) . '">' . htmlspecialchars($k) . '</option>' . "\n");
}
?>
        </select>

        <label for="var_y1">Y1</label>
        <select id="var_y1" name="var[y1][]" multiple="multiple" size="<?php echo(count($y)); ?>">
<?php
foreach ($y as $k => $v)
{
  echo('          <option value="' . htmlspecialchars($k) . '">' . htmlspecialchars($k) . '</option>' . "\n");
}
?>
        </select>

      </fieldset>
      <input type="submit" name="submit" value="multi-run" />
     
    </form>
  </body>
</html>
