/* UpdraftSteady.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef UPDRAFT_STEADY_HPP
#  define UPDRAFT_STEADY_HPP

#  define self UpdraftSteady
class self : public Updraft
{

  private: quantity<si::velocity> U_;

  public: self(quantity<si::velocity> U) 
  {
    U_ = U;
  };

  public: quantity<si::velocity> U(quantity<si::time>) 
  {
    return U_;
  }

  public: quantity<si::time> t(quantity<si::length> alt)
  {
    return alt / U_;
  }

};
#  undef self

#endif
