/* UpdraftBells.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef UPDRAFT_BELLS_HPP
#  define UPDRAFT_BELLS_HPP

#  define self UpdraftBells
class self : public Updraft
{

  private: quantity<si::velocity> U_max;
  private: quantity<si::time> period;

  public: self(quantity<si::velocity> U_max_, quantity<si::time> period_) 
  {
    U_max = U_max_;
    period = period_;
  };

  public: quantity<si::velocity> U(quantity<si::time> t) 
  {
    return U_max * sin(2 * M_PI * t / period) * abs(sin(2 * M_PI * t / period));
  }

  public: quantity<si::time> t(quantity<si::length> alt)
  {
    // TODO...
    cerr << "t(alt) not implemented yet for UpdraftBells" << endl;
    throw exception();
  }

};
#  undef self

#endif
