/* SolverCVODESBDFNewton.hpp
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef SOLVER_CVODES_BDF_NEWTON_HPP
#  define SOLVER_CVODES_BDF_NEWTON_HPP

#  include <cvode/cvode_diag.h>
#  include <cvode/cvode_dense.h>
#  include <cvode/cvode_spgmr.h>
#  include <cvode/cvode_spbcgs.h>
#  include <cvode/cvode_sptfqmr.h>

#  define self SolverCVODESBDFNewton
class self : public SolverCVODES
{

  private: string lsolver;
  private: SpectraMemLayout *ml;
  private: Model *model;

  public: self(Model *model_, Output *output, ModelParams *params, InitpTq *ptq,
    vector<InitSpectrum*>* ispecs, InitBinLayout *ibl, SpectraMemLayout *ml_, SatVapPresMltplr *svpm,
    Tolerances* tol, quantity<si::time> tmax, string lsolver_) 
  {
    construct(model_, output, params, ptq, ispecs, ibl, ml_, svpm, tol, tmax);
    lsolver = lsolver_; 
    ml = ml_;
    model = model_;
  }

  public: void postinit() 
  {
    if (lsolver == "CVDIAG")
    {
      if (CVDIAG_SUCCESS != CVDiag(cvode_mem)) 
        throw exception();
    } 
    else if (lsolver == "CVDENSE")
    {
      if (CVDLS_SUCCESS != CVDense(cvode_mem, model->isBulk() ? 3 : 3 + ml->length())) 
        throw exception();
    }
    else if (lsolver == "CVDENSE-JAC")
    {
      if (CVDLS_SUCCESS != CVDense(cvode_mem, model->isBulk() ? 3 : 3 + ml->length())) 
        throw exception();
      if (CVDLS_SUCCESS != CVDlsSetDenseJacFn(cvode_mem, model->getODEJacFnPtr()))
        throw exception();
    } 
    else if (lsolver == "CVSPGMR")
    {
      if (CVSPILS_SUCCESS != CVSpgmr(cvode_mem, PREC_NONE, 0))
        throw exception();
    }
    else if (lsolver == "CVSPBCG")
    {
      if (CVSPILS_SUCCESS != CVSpbcg(cvode_mem, PREC_NONE, 0))
        throw exception();
    }
    else if (lsolver == "CVSPTFQMR")
    {
      if (CVSPILS_SUCCESS != CVSptfqmr(cvode_mem, PREC_NONE, 0))
        throw exception();
    }
    else 
    {
      cerr << msgprefix << "unknown linear solver: " << lsolver << endl;
      throw exception();
    }
  };

  public: int getLinearMultistepMethod() 
  {
    return CV_BDF;
  }

  public: int getNonlinearSolverIteration() 
  {
    return CV_NEWTON;
  }

};
#  undef self

#endif
