/* SolverCVODESAdamsFunctional.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef SOLVER_CVODES_ADAMS_FUNCTIONAL_HPP
#  define SOLVER_CVODES_ADAMS_FUNCTIONAL_HPP

#  define self SolverCVODESAdamsFunctional
class self : public SolverCVODES
{

  public: self(Model *model, Output *output, ModelParams *params, InitpTq *ptq, 
    vector<InitSpectrum*>* ispecs, InitBinLayout *ibl, SpectraMemLayout *ml, SatVapPresMltplr *svpm,
    Tolerances* tol, quantity<si::time> tmax) 
  {
    construct(model, output, params, ptq, ispecs, ibl, ml, svpm, tol, tmax);
  };

  public: void postinit() { };

  public: int getLinearMultistepMethod() 
  {
    return CV_ADAMS;
  }

  public: int getNonlinearSolverIteration() 
  {
    return CV_FUNCTIONAL;
  }

};
#  undef self

#endif
