/* Solutes.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef SOLUTES_HPP
#  define SOLUTES_HPP

class SoluteAmmoniumSulphate : public Solute
{

  // van 't Hoff factor
  public: quantity<si::dimensionless> i() 
  {
    return 3.;
  }

  // density of pure solute
  public: quantity<si::mass_density> rho_s() 
  {
    // TODO: this is taken from Wikipedia :) (but the kappa-Kohler is the method of choice)
    return 1.769e3 * si::kilogrammes / si::cubic_metre; 
  }

  // molar mass of the solute
  public: quantity<si::constants::codata::mass_over_amount> M_s() 
  {
    // TODO: this is taken from Wikipedia :) (but the kappa-Kohler is the method of choice)
    return 132.14e-3 * si::kilogrammes / si::mole;
  }

  // Petters & Kreidenweis CCN derived kappa
  public: quantity<si::dimensionless> kappa()
  {
    return .61;
  }

};

class SoluteKappaKohlerOnly : public Solute
{
  public: quantity<si::dimensionless> i()
  {
    cerr << "kappa-Kohler-only solute!" << endl;
    throw exception();
  }

  public: quantity<si::mass_density> rho_s()
  {
    cerr << "kappa-Kohler-only solute!" << endl;
    throw exception();
  }

  public: quantity<si::constants::codata::mass_over_amount> M_s()
  {
    cerr << "kappa-Kohler-only solute!" << endl;
    throw exception();
  }
};

class SoluteKappa1_28 : public SoluteKappaKohlerOnly { public: quantity<si::dimensionless> kappa() { return 1.28; } };
class SoluteKappa0_64 : public SoluteKappaKohlerOnly { public: quantity<si::dimensionless> kappa() { return 0.64; } };
class SoluteKappa0_32 : public SoluteKappaKohlerOnly { public: quantity<si::dimensionless> kappa() { return 0.32; } };
class SoluteKappa0_16 : public SoluteKappaKohlerOnly { public: quantity<si::dimensionless> kappa() { return 0.16; } };
class SoluteKappa0_08 : public SoluteKappaKohlerOnly { public: quantity<si::dimensionless> kappa() { return 0.08; } };
class SoluteKappa0_04 : public SoluteKappaKohlerOnly { public: quantity<si::dimensionless> kappa() { return 0.04; } };
class SoluteKappa0_02 : public SoluteKappaKohlerOnly { public: quantity<si::dimensionless> kappa() { return 0.02; } };
class SoluteKappa0_01 : public SoluteKappaKohlerOnly { public: quantity<si::dimensionless> kappa() { return 0.01; } };
class SoluteKappa0_005 : public SoluteKappaKohlerOnly { public: quantity<si::dimensionless> kappa() { return .005; } };

class SoluteSodiumChloride : public SoluteKappaKohlerOnly
{
  // Petters & Kreidenweis CCN derived kappa
  public: quantity<si::dimensionless> kappa()
  {
    return 1.28;
  }
};

#endif
