/* SatVapPresMltplrUnity.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef SAT_VAP_PRES_MLTPLR_UNITY_HPP
#  define SAT_VAP_PRES_MLTPLR_UNITY_HPP

#  define self SatVapPresMltplrUnity
class self : public SatVapPresMltplr
{

  public: quantity<si::dimensionless> p_v_s_r__p_v_s_infty(
    quantity<si::temperature> T, quantity<si::length> r, quantity<si::length> r_d, Solute *solute
  ) 
  {
    return 1.;
  }

  public: quantity<si::length> r_eq(
    quantity<si::dimensionless>, quantity<si::temperature>, quantity<si::length>, Solute*
  )
  {
    cerr << msgprefix << "Equilibrium radius requested for a flat-surface droplet!" << endl;
    throw exception();
  }

  public: quantity<si::length> rd_eq(
    quantity<si::dimensionless>, quantity<si::temperature>, quantity<si::length>, Solute*
  )
  {
    cerr << msgprefix << "Equilibrium radius requested for a flat-surface droplet!" << endl;
    throw exception();
  }

  public: quantity<inverse_length> d_mltplr__d_r(
    quantity<si::temperature> T, quantity<si::length> radius, quantity<si::length> r_d, Solute *solute
  ) 
  {
    return 0. / si::metres;
  }

};
#  undef self

#endif
