/* SatVapPresMltplrRaoultPetters_2007.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef SAT_VAP_PRES_MLTPLR_RAOULT_PETTERS_2007_HPP
#  define SAT_VAP_PRES_MLTPLR_RAOULT_PETTERS_2007_HPP

#  include "SatVapPresMltplrLinearRwRd.hpp"

#  define self SatVapPresMltplrRaoultPetters_2007
class self : public SatVapPresMltplrLinearRwRd
{

  public: quantity<si::dimensionless> p_v_s_r__p_v_s_infty(
    quantity<si::temperature> T, quantity<si::length> r, quantity<si::length> r_d, 
    Solute *solute
  ) 
  {
    return (
      pow<3>(r) - pow<3>(r_d)
    ) / (
      pow<3>(r) - pow<3>(r_d) * (1. - solute->kappa()) 
    );
  }

  public: quantity<si::length> r_eq(
    quantity<si::dimensionless> svpm_eq, quantity<si::temperature> T,
    quantity<si::length> r_d, Solute *solute
  )
  {
    return r_d * boost::units::root<3>(
      (1. - svpm_eq * (1. - solute->kappa())) / (1. - svpm_eq)
    );
  }

  public: quantity<inverse_length> d_mltplr__d_r(
    quantity<si::temperature> T, quantity<si::length> radius, quantity<si::length> r_d, Solute *solute
  )
  {
    quantity<si::dimensionless> a = p_v_s_r__p_v_s_infty(T, radius, r_d, solute);
    return (
      3. * pow<2>(radius) * a * (1. - a) / (pow<3>(radius) - pow<3>(r_d))
    );
  }

};
#  undef self

#endif
