/* SatVapPresMltplrLinearRwRd.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef SAT_VAP_PRES_MLTPLR_LINEAR_RW_RD_HPP
#  define SAT_VAP_PRES_MLTPLR_LINEAR_RW_RD_HPP

#  define self SatVapPresMltplrLinearRwRd
class self : public SatVapPresMltplr
{

  public: quantity<si::length> rd_eq(
    quantity<si::dimensionless> svpm_eq, quantity<si::temperature> T, quantity<si::length> r_w, Solute *solute
  )
  {
    return r_w / (r_eq(svpm_eq, T, 1. * si::meters, solute) / si::metres);
  }

};
#  undef self

#endif
