/* SatVapPresMltplrKelvin.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef SAT_VAP_PRES_MLTPLR_KELVIN_HPP
#  define SAT_VAP_PRES_MLTPLR_KELVIN_HPP

#  define self SatVapPresMltplrKelvin
class self : public SatVapPresMltplr
{

  public: quantity<si::dimensionless> p_v_s_r__p_v_s_infty(
    quantity<si::temperature> T, quantity<si::length> r, quantity<si::length> r_d, Solute *solute
  ) 
  {
    return exp(2. * constants::sigma_w_0 / r / constants::R_v / constants::rho_w_0 / T);
  }

  public: quantity<si::length> r_eq(
    quantity<si::dimensionless> svpm_eq, quantity<si::temperature> T, quantity<si::length> r_d, Solute *solute
  )
  {
    return 2. * constants::sigma_w_0 / constants::R_v / constants::rho_w_0 / T / log(svpm_eq);
  }

  public: quantity<si::length> rd_eq(
    quantity<si::dimensionless>, quantity<si::temperature>, quantity<si::length>, Solute*
  )
  {
    cerr << msgprefix << "Equilibrium wet radius requested for a pure-water droplet!" << endl;
    throw exception();
  }

  public: quantity<inverse_length> d_mltplr__d_r(
    quantity<si::temperature> T, quantity<si::length> radius, quantity<si::length> r_d, Solute *solute
  ) 
  {
    quantity<si::dimensionless> a = p_v_s_r__p_v_s_infty(T, radius, r_d, solute);
    return -1. * a * log(a) * pow<-1>(radius);
  }

};
#  undef self

#endif
