/* OutputGnuplotSpecEvol.hpp
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef OUTPUT_GNUPLOT_SPEC_EVOL_HPP
#  define OUTPUT_GNUPLOT_SPEC_EVOL_HPP

#  define self OutputGnuplotSpecEvol
class self : public OutputGnuplot
{

  protected: int n_spec;
  protected: quantity<si::dimensionless> div_spec;

  public: self(Model *model_, InitpTq *initptq_, SpectraMemLayout *ml_, Updraft *updraft,
    int n_spec_, quantity<si::dimensionless> div_spec_, size_t rec_step
  ) : OutputGnuplot(model_, initptq_, ml_, updraft, rec_step) 
  { 
    n_spec = n_spec_;
    div_spec = div_spec_;
  }

  public: void record(quantity<si::time> t, N_Vector y, N_Vector p)
  {
    ++step;
    if (step - step_last < rec_step) return;
    step_last = step;
    tmpfile_write(t, y, p); 
  }

  public: void head() {}

  public: void foot(quantity<si::time>, N_Vector, N_Vector) 
  {
    cout << "set logscale x" << endl;
    cout << "set xrange [10e-10:100e-6]" << endl;
    cout << "set yrange [-"
      << realtype(times.back() / si::seconds / 40) << ":" 
      << realtype(times.back() / si::seconds) << "]" << endl;
    cout << "set view 39,200,1.0888,.617676" << endl;
    cout << "set xlabel 'wet radius [um]'" << endl;
    cout << "set ylabel 'time [s]'" << endl;
    cout << "set x2label 'RH [%]'" << endl;
    cout << "set x2tics" << endl;
    cout << "set zlabel \"specific concentration\\n density [mg-1 um-1]\"" << endl;
    cout << "set ticslevel 0" << endl;
    cout << "splot ";
    for (int i = n_spec - 1; i >= 0; --i) // going from top to botton to allow filledcurves act as overlays for previous spectra
    {
      for (int s = 0; s < ml->n_specs(); ++s)
      {
        if (s != 0 || i != n_spec - 1) cout << ",";
        cout << "'-' using 2:1:($3*1e-12) with lines lt " << 3 - 2 * s << " t '";
        if (i == n_spec - 1) 
        {
          cout << "wet spectra (";
          if (s == 0) cout << "a";
          else cout << "b";
          cout << ", every " << lrint(realtype(times.back() / si::seconds) / n_spec) << " s)";
        }
        cout << "'";
      }
    }
    cout << endl;

    { // scope for times_spec
      vector<size_t> times_spec(n_spec); 
      { // scope for j
        int j = 0;
        for (size_t i = 1; i < times.size() - 1; ++i) // starting with 1 so that (i - 1) works from the start, 
        {                                             // ending at (length() - 1) so that tmax is never reached
          if (times[i] > (j / realtype(n_spec)) * times.back()) 
          { 
            times_spec[j] = i - 1;
            ++j;
          }
        }
      }

      for (int i = n_spec - 1; i >= 0; --i)
      {
        for (int s = 0; s < ml->n_specs(); ++s)
        {
          dataSpectrum(times_spec[i], s, false, true); 
          cout << "e" << endl;
        }
      }
    }
  }

};
#  undef self

#endif
