/* ModelPseudoAdiabaticMovingSectional.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef MODEL_PSEUDOADIABATIC_MOVING_SECTIONAL_HPP
#  define MODEL_PSEUDOADIABATIC_MOVING_SECTIONAL_HPP

#  include "drops.hpp"

/* does not work... :(
#  include "/usr/local/src/sundials-2.4.0/src/cvode/cvode_direct_impl.h"
*/

#  define self ModelPseudoAdiabaticMovingSectional
class self : public Model
{

  private: class params : public ModelParams
  {
    public: Updraft *U;
    public: InBinSpectrum *I;
    public: SpectraMemLayout *ML;
    public: SatVapPresMltplr *SVPM;
    public: DiffCoeffMltplr *DCMV, *DCMH;
    public: DropGrowthEq *DGE;

    public: params(Updraft* U_, InBinSpectrum* I_, SpectraMemLayout* ML_, 
      SatVapPresMltplr* SVPM_, DiffCoeffMltplr* DCMV_, DiffCoeffMltplr* DCMH_, 
      vector<Solute*> *S_, DropGrowthEq* DGE_) 
    {
      U = U_; 
      I = I_;
      ML = ML_;
      SVPM = SVPM_;
      DCMV = DCMV_;
      DCMH = DCMH_;
      S = S_;
      DGE = DGE_;
    }
  };

  public: ModelParams* getParams(Updraft* U, InBinSpectrum* I, 
    SpectraMemLayout* ML, SatVapPresMltplr* SVPM, DiffCoeffMltplr* DCMV, 
    DiffCoeffMltplr* DCMH, vector<Solute*>* S, DropGrowthEq* DGE) 
  {
    return new self::params(U, I, ML, SVPM, DCMV, DCMH, S, DGE);
  } 

#  define idx_p 0
#  define idx_T 1
#  define idx_q_v 2
#  define idx_r 3
 
  public: size_t getStateVectorIndexPressure() { return idx_p; }
  public: size_t getStateVectorIndexTemperature() { return idx_T; }
  public: size_t getStateVectorIndexSpecificHumidity() { return idx_q_v; }
  public: size_t getStateVectorIndexRadii() { return idx_r; }
  public: bool isBulk() { return false; }
  public: CVDlsDenseJacFn getODEJacFnPtr() { assert(false); }

  // ODE system for SUNDIALS
  public: CVRhsFn getODERhsFnPtr() { return &self::system; }
  public: static int system(realtype t_, N_Vector Y, N_Vector dY_dt, void * P_)
  { 

#  define P (static_cast<self::params*>(P_))
#  define t (t_ * si::seconds)
#  define q_v NV_Ith_S(Y, idx_q_v) 
#  define p (NV_Ith_S(Y, idx_p) * quantity<si::pressure>(1 * si::pascals))
#  define T (NV_Ith_S(Y, idx_T) * quantity<si::temperature>(1 * si::kelvins))

#  define r_d_l(s, i) (NV_Ith_S(P->pp, P->ML->r_d_l_ix(s, i)) * si::metres)
#  define r_d_r(s, i) (NV_Ith_S(P->pp, P->ML->r_d_r_ix(s, i)) * si::metres)
#  define r_l(s, b) (NV_Ith_S(Y, idx_r + P->ML->r_l_ix(s, b)) * si::metres)
#  define r_r(s, b) (NV_Ith_S(Y, idx_r + P->ML->r_r_ix(s, b)) * si::metres)
#  define T_o_l(s, i) (NV_Ith_S(Y, idx_r + P->ML->To_l_ix(s, i)) * si::kelvins)
#  define T_o_r(s, i) (NV_Ith_S(Y, idx_r + P->ML->To_r_ix(s, i)) * si::kelvins)
#  define N(s, b) (NV_Ith_S(P->pp, P->ML->N_ix(s, b)) / si::kilogrammes)

#  define dr_l__dt(s, i) NV_Ith_S(dY_dt, idx_r + P->ML->r_l_ix(s, i)) 
#  define dr_r__dt(s, i) NV_Ith_S(dY_dt, idx_r + P->ML->r_r_ix(s, i)) 
#  define dr__dt_unit (quantity<si::length>(1 * si::metres) / quantity<si::time>(1 * si::seconds))

    if (q_v < 0) 
    {
      cerr << msgprefix << "q_v < 0 ! -> asking for refinement..." << endl;
      return 1; 
    }

    for (int s = 0; s < P->ML->n_specs(); ++s)
    {
      for (int i = 0; P->ML->bin_r(s, i) != -1; i = P->ML->bin_r(s, i))
      {
        if (r_l(s, i) > r_r(s, i)) 
        {
          cerr << "r_l (" << i << " -> " << r_l(s, i) << ") > r_r (" << r_r(s, i) << ")! -> asking for refinement..." << endl;
          return 1; 
        }

        if (r_d_l(s, i) > r_d_r(s, i)) 
        {
          cerr << "r_d_l (" << i << " -> " << r_d_l(s, i) << ") > r_d_r (" << r_d_r(s, i) << ")! -> asking for refinement..." << endl;
          return 1; 
        }
      }

      for (int i = 0; i < P->ML->n_bins(s) + 1; ++i)
      {
        if (r_l(s, i) < r_d_l(s, i)) 
        {
          cerr << msgprefix << "r_l (" << r_l(s, i) << ") < r_d_l (" << r_d_l(s, i) << ") ! -> asking for refinement..." << endl;
          return 1; 
        }

        dr_l__dt(s, i) = P->DGE->dr__dt(
          r_l(s, i), r_d_l(s, i), T, T_o_l(s, i), p, q_v, P->S->at(s), P->DCMV, P->DCMH, P->SVPM
        ) / dr__dt_unit;

#  define dTo_l__dt(s, i) NV_Ith_S(dY_dt, idx_r + P->ML->To_l_ix(s, i))
#  define dTo_r__dt(s, i) NV_Ith_S(dY_dt, idx_r + P->ML->To_r_ix(s, i))
#  define dTo__dt_unit (si::kelvins / si::seconds)
        dTo_l__dt(s,i) = (
          3. / (P->c_p_w * r_l(s, i)) * (
            (P->K_0 * P->DCMH->D_transition__D_continuum(P->Kn_K(r_l(s, i), T, p))) 
            * (T - T_o_l(s, i)) / r_l(s, i) / P->rho_w_0
            + dr_l__dt(s, i) * dr__dt_unit * P->l_v(T_o_l(s, i))
          )
        ) / dTo__dt_unit;
#  undef T_o_l
#  undef T_o_r
#  undef r
#  undef dr__dt
      }
    }

    {
      quantity<inverse_mass_density_over_time> sum(0 * si::cubic_metres / si::kilogrammes / si::seconds);
      for (int s = 0; s < P->ML->n_specs(); ++s)
      {
        for (int b = 0; P->ML->bin_r(s, b) != -1; b = P->ML->bin_r(s, b))
        {

          sum += N(s, b) * (
            P->I->kappa(r_r(s, b), r_l(s, b)) * dr_r__dt(s, b) * dr__dt_unit +
            P->I->kappa(r_l(s, b), r_r(s, b)) * dr_l__dt(s, b) * dr__dt_unit 
          );
#  undef dr__dt_unit
#  undef N
#  undef dr_l__dt
#  undef dr_r__dt
#  undef r_l
#  undef r_r
        }
      }
#  define dq_v__dt NV_Ith_S(dY_dt,idx_q_v) 
#  define dq_v__dt_unit (quantity<si::dimensionless>(1) / quantity<si::time>(1 * si::seconds))
      dq_v__dt = (
        (q_v - 1.) * M_PI * P->rho_w_0 / 3. * sum
      ) / dq_v__dt_unit;
   }

#  define dp__dt NV_Ith_S(dY_dt,idx_p) 
#  define dp__dt_unit (quantity<si::pressure>(1 * si::pascals) / quantity<si::time>(1 * si::seconds))
    dp__dt = ( 
      - p * P->g_0 * P->U->U(t) / P->R(q_v) / T
    ) / dp__dt_unit;

#  define dT__dt NV_Ith_S(dY_dt,idx_T)
#  define dT__dt_unit (quantity<si::temperature>(1 * si::kelvins) / quantity<si::time>(1 * si::seconds))
    dT__dt = (
      T * P->R(q_v) / p / P->c_p(q_v) * dp__dt * dp__dt_unit
      - P->l_v(T) / P->c_p(q_v) * dq_v__dt * dq_v__dt_unit
    ) / dT__dt_unit;

    return 0; // 0: ok, 1 :adjust-timestep, -1: fatal
  }

#  undef t
#  undef p
#  undef T
#  undef dp__dt
#  undef dp__dt_unit
#  undef dT__dt
#  undef dT__dt_unit
#  undef q_v
#  undef dq_v__dt
#  undef dq_v__dt_unit
#  undef P

#  undef idx_p
#  undef idx_T
#  undef idx_q_v

};

#  undef self
#endif
