/* ModelPseudoAdiabaticBulk.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef MODEL_PSEUDOADIABATIC_BULK_HPP
#  define MODEL_PSEUDOADIABATIC_BULK_HPP

#  include "drops.hpp"

#  define self ModelPseudoAdiabaticBulk
class self : public Model
{

#  define idx_p 0
#  define idx_T 1
#  define idx_q_v 2
 
  private: class params : public ModelParams
  {
    public: params(Updraft* U_) 
    {
      U = U_; 
    }
    public: Updraft *U;
  };

  // TODO: that should be put present only in ModelMovingSectional ctor
  public: ModelParams* getParams(Updraft* U, InBinSpectrum*, SpectraMemLayout*, 
    SatVapPresMltplr*, DiffCoeffMltplr*, DiffCoeffMltplr*, vector<Solute*>*, DropGrowthEq*) 
  {
    return new self::params(U);
  } 

  public: size_t getStateVectorMaxLength() { return 3; }
  public: size_t getStateVectorIndexPressure() { return idx_p; }
  public: size_t getStateVectorIndexTemperature() { return idx_T; }
  public: size_t getStateVectorIndexSpecificHumidity() { return idx_q_v; }
  public: size_t getStateVectorIndexRadii() { return 3; }
  public: bool isBulk() { return true; }

  public: CVDlsDenseJacFn getODEJacFnPtr() { assert(false); }
  public: CVRhsFn getODERhsFnPtr() { return &self::system; }

  public: static int system(realtype t_, N_Vector Y, N_Vector dY_dt, void * P_)
  { 

#  define t (t_ * si::seconds)
#  define p (NV_Ith_S(Y,idx_p) * quantity<si::pressure>(1 * si::pascals))
#  define T (NV_Ith_S(Y,idx_T) * quantity<si::temperature>(1 * si::kelvins))
#  define q_v NV_Ith_S(Y,idx_q_v) 
#  define P static_cast<self::params*>(P_)

    if (q_v < 0) return 1; // asking for refinement

#  define dp__dt NV_Ith_S(dY_dt,idx_p) 
#  define dp__dt_unit (quantity<si::pressure>(1 * si::pascals) / quantity<si::time>(1 * si::seconds))
    dp__dt = ( 
      - p * P->g_0 * P->U->U(t) / P->R(q_v) / T
    ) / dp__dt_unit;

#  define dT__dt NV_Ith_S(dY_dt,idx_T)
#  define dT__dt_unit (quantity<si::temperature>(1 * si::kelvins) / quantity<si::time>(1 * si::seconds))
    dT__dt = dp__dt * dp__dt_unit / dT__dt_unit * (
      T * P->R(q_v) / p 
      + (q_v < P->q_v_s(T, p) 
        ? quantity<inverse_mass_density>(0. * si::cubic_metres / si::kilogrammes)
        : P->l_v(T) * pow<2>(q_v) / P->epsilon / P->p_v_s(T) 
      )
    ) / (
      P->c_p(q_v)
      + (q_v < P->q_v_s(T, p)
        ? quantity<energy_over_temperature_mass>(0. * si::joules / si::kelvins / si::kilogrammes)
        : p * pow<2>(P->l_v(T)) * pow<2>(q_v) / pow<2>(T) / P->epsilon / P->R_v / P->p_v_s(T)
      )
    );

#  define dq_v__dt NV_Ith_S(dY_dt,idx_q_v) 
#  define dq_v__dt_unit (quantity<si::dimensionless>(1) / quantity<si::time>(1 * si::seconds))
    dq_v__dt = q_v < P->q_v_s(T, p) 
      ? quantity<si::dimensionless>(0.) // waiting till saturated
      : (
        - pow<2>(P->q_v_s(T, p)) / P->epsilon / P->p_v_s(T) 
          * dp__dt * dp__dt_unit
        + p * pow<2>(P->q_v_s(T, p)) / P->epsilon / P->p_v_s(T) / pow<2>(T) / P->R_v * P->l_v(T)
          * dT__dt * dT__dt_unit 
      ) / dq_v__dt_unit;

    return 0; // 0: ok, 1 :adjust-timestep, -1: fatal

#  undef p
#  undef dp__dt
#  undef dp__dt_unit

#  undef T
#  undef dT__dt
#  undef dT__dt_unit

#  undef q_v
#  undef dq_v__dt
#  undef dq_v__dt_unit

#  undef P
#  undef t

  }

#  undef idx_p
#  undef idx_T
#  undef idx_q_v

};

#  undef self

#endif
