/* InitpTqCmdLinepTRH.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef INIT_PTQ_CMDLINE_PTRH_HPP
#  define INIT_PTQ_CMDLINE_PTRH_HPP

#  define self InitpTqCmdLinepTRH
#  define parent InitpTqCmdLine
class self : public parent
{

  public: self(quantity<si::pressure> p, quantity<si::temperature> T, quantity<si::dimensionless> RH) :
    parent(p, T, pow<-1>(1. - 1. / constants::epsilon * (1. - p / RH / constants::p_v_s(T))))
  { 
  };

};
#  undef parent
#  undef self

#endif
