/* InitpTqCmdLine.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef INIT_PTQ_CMDLINE_HPP
#  define INIT_PTQ_CMDLINE_HPP

#  define self InitpTqCmdLine
class self : public InitpTq
{

  private: quantity<si::pressure> p_;
  private: quantity<si::temperature> T_;
  private: quantity<si::dimensionless> q_;

  public: self(quantity<si::pressure> p, quantity<si::temperature> T, quantity<si::dimensionless> q) 
  {
    p_ = p;
    T_ = T;
    q_ = q;
  };

  public: quantity<si::pressure> getPressure() { return p_; }
  public: quantity<si::temperature> getTemperature() { return T_; }
  public: quantity<si::dimensionless> getSpecificHumidity() { return q_; }

};
#  undef self

#endif
