/* InitSpectrumWhitby1978.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef INIT_SPECTRUM_WHITBY_1978_HPP
#  define INIT_SPECTRUM_WHITBY_1978_HPP

#  include "InitSpectrumLognormal.hpp"

#  define self InitSpectrumWhitby1978
#  define parent InitSpectrumLognormal
class self : public parent
{
  public: self(string type, bool dryNotWet) : parent(dryNotWet)
  {
    cf = new vector<InitSpectrumLognormal::coeffset>(3);

    if (type == "marine")
    {
      (*cf)[0].r = .005 * 1e-6 * si::metres;
      (*cf)[0].s = 1.6;
      (*cf)[0].n = 340. * pow<-3>(1e-2 * si::meters);

      (*cf)[1].r = .035 * 1e-6 * si::metres;
      (*cf)[1].s = 2.0;
      (*cf)[1].n = 60. * pow<-3>(1e-2 * si::meters);

      (*cf)[2].r = .31 * 1e-6 * si::metres;
      (*cf)[2].s = 2.7;
      (*cf)[2].n = 3.1 * pow<-3>(1e-2 * si::meters);
    }
    else if (type == "clean_continental")
    {
      (*cf)[0].r = .008 * 1e-6 * si::metres;
      (*cf)[0].s = 1.6;
      (*cf)[0].n = 1000. * pow<-3>(1e-2 * si::meters);

      (*cf)[1].r = .034 * 1e-6 * si::metres;
      (*cf)[1].s = 2.1;
      (*cf)[1].n = 800. * pow<-3>(1e-2 * si::meters);

      (*cf)[2].r = .46 * 1e-6 * si::metres;
      (*cf)[2].s = 2.2;
      (*cf)[2].n = .72 * pow<-3>(1e-2 * si::meters);
    }
    else if (type == "average_background")
    {
      (*cf)[0].r = .008 * 1e-6 * si::metres;
      (*cf)[0].s = 1.7;
      (*cf)[0].n = 6400. * pow<-3>(1e-2 * si::meters);

      (*cf)[1].r = .038 * 1e-6 * si::metres;
      (*cf)[1].s = 2.0;
      (*cf)[1].n = 2300. * pow<-3>(1e-2 * si::meters);

      (*cf)[2].r = .51 * 1e-6 * si::metres;
      (*cf)[2].s = 2.16;
      (*cf)[2].n = 3.2 * pow<-3>(1e-2 * si::meters);
    }
    else if (type == "urban")
    {
      (*cf)[0].r = .007 * 1e-6 * si::metres;
      (*cf)[0].s = 1.8;
      (*cf)[0].n = 106000. * pow<-3>(1e-2 * si::meters);

      (*cf)[1].r = .027 * 1e-6 * si::metres;
      (*cf)[1].s = 2.16;
      (*cf)[1].n = 32000. * pow<-3>(1e-2 * si::meters);

      (*cf)[2].r = .43 * 1e-6 * si::metres;
      (*cf)[2].s = 2.21;
      (*cf)[2].n = 5.4 * pow<-3>(1e-2 * si::meters);
    }
  }

};
#  undef self
#  undef parent

#endif
