/* InitSpectrumODowd1997.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef INIT_SPECTRUM_ODOWD_1997_HPP
#  define INIT_SPECTRUM_ODOWD_1997_HPP

#  include "InitSpectrumLognormal.hpp"

#  define self InitSpectrumODowd1997
#  define parent InitSpectrumLognormal
class self : public parent
{
  public: self(string type, bool dryNotWet) : parent(dryNotWet) 
  {

    if (type == "nss_sulphate")
    {
      cf = new vector<InitSpectrumLognormal::coeffset>(1);

      (*cf)[0].r = .08 * 1e-6 * si::metres;
      (*cf)[0].s = 1.45;
      (*cf)[0].n = 100. * pow<-3>(1e-2 * si::meters);
    }
    else if (type == "sea_salt")
    {
      cf = new vector<InitSpectrumLognormal::coeffset>(3);

      // the film drop mode (for U=15 m/s)
      (*cf)[0].r = .1 * 1e-6 * si::metres;
      (*cf)[0].s = 1.9;
      (*cf)[0].n = 51.1 * pow<-3>(1e-2 * si::meters);

      // the jet drop mode (for U=15 m/s)
      (*cf)[1].r = 1. * 1e-6 * si::metres;
      (*cf)[1].s = 2.;
      (*cf)[1].n = 2.21 * pow<-3>(1e-2 * si::meters);

      // the spume drop mode (for U=15 m/s)
      (*cf)[2].r = 6. * 1e-6 * si::metres;
      (*cf)[2].s = 3.;
      (*cf)[2].n = 1.7e-5 * pow<-3>(1e-2 * si::meters);
    }
  }

};
#  undef self
#  undef parent

#endif
