/* InitSpectrumLognormal.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef INIT_SPECTRUM_LOGNORMAL_HPP
#  define INIT_SPECTRUM_LOGNORMAL_HPP

#  define self InitSpectrumLognormal
#  define parent InitSpectrum
class self : public parent
{
  protected: class coeffset
  {
    public: quantity<si::length> r; // mode mean radius
    public: quantity<si::dimensionless> s; // geometric standard deviation
    public: quantity<concentration> n; // number concentration in the mode
  };  

  protected: vector<self::coeffset> *cf;

  public: quantity<concentration_density> n_n(quantity<si::length> radius)
  {
    vector<self::coeffset> *cf = this->getCoeffs();
    quantity<concentration_density> f = 0. / pow<4>(si::metres);
    for (size_t i = 0; i < cf->size(); i++)
    {   
      // Sinfeld & Pandis eq. 7.34
      f += (*cf)[i].n / sqrt(2*M_PI) / log((*cf)[i].s) * exp(
        -pow<2>(log(radius/(*cf)[i].r)) / 2. / pow<2>(log((*cf)[i].s))
      ) / radius;
    }   
    return f;
  }

  public: self(bool dryNotWet) : parent(dryNotWet) 
  {
  }

  public: self(quantity<si::length> r, quantity<si::dimensionless> s, quantity<concentration> n, bool dryNotWet) : parent(dryNotWet) 
  {
    cf = new vector<self::coeffset>(1);
    (*cf)[0].r = r;
    (*cf)[0].s = s;
    (*cf)[0].n = n;
  }

  public: ~self()
  {
    delete cf; 
  }

  private: vector<InitSpectrumLognormal::coeffset>* getCoeffs()
  {
    return cf; 
  }

};
#  undef self
#  undef parent

#endif
