/* InitSpectrumJaenicke1993.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef INIT_SPECTRUM_JAENICKE_1993_HPP
#  define INIT_SPECTRUM_JAENICKE_1993_HPP

#  include "InitSpectrumLognormal.hpp"

#  define self InitSpectrumJaenicke1993
#  define parent InitSpectrumLognormal
class self : public parent
{
  public: self(string type, bool dryNotWet) : parent(dryNotWet) 
  {
    cf = new vector<InitSpectrumLognormal::coeffset>(3);

    if (type == "polar")
    {
      (*cf)[0].n = 2.17e1 * pow<-3>(1e-2 * si::meters);
      (*cf)[0].r = .0689 * 1e-6 * si::metres;
      (*cf)[0].s = exp(.245);

      (*cf)[1].n = 1.86e-1 * pow<-3>(1e-2 * si::meters);
      (*cf)[1].r = .375 * 1e-6 * si::metres;
      (*cf)[1].s = exp(.3);

      (*cf)[2].n = 3.04e-4 * pow<-3>(1e-2 * si::meters);
      (*cf)[2].r = 4.29 * 1e-6 * si::metres;
      (*cf)[2].s = exp(.291);
    }
    else if (type == "background")
    {
      (*cf)[0].n = 1.29e2 * pow<-3>(1e-2 * si::meters);
      (*cf)[0].r = .0036 * 1e-6 * si::metres;
      (*cf)[0].s = exp(.645);

      (*cf)[1].n = 5.97e1 * pow<-3>(1e-2 * si::meters);
      (*cf)[1].r = .127 * 1e-6 * si::metres;
      (*cf)[1].s = exp(.253);

      (*cf)[2].n = 6.35e1 * pow<-3>(1e-2 * si::meters);
      (*cf)[2].r = .259 * 1e-6 * si::metres;
      (*cf)[2].s = exp(.425);
    }
    else if (type == "maritime")
    {
      (*cf)[0].n = 1.33e2 * pow<-3>(1e-2 * si::meters);
      (*cf)[0].r = .0039 * 1e-6 * si::metres;
      (*cf)[0].s = exp(.657);

      (*cf)[1].n = 6.66e1 * pow<-3>(1e-2 * si::meters);
      (*cf)[1].r = .133 * 1e-6 * si::metres;
      (*cf)[1].s = exp(.210);

      (*cf)[2].n = 3.06e0 * pow<-3>(1e-2 * si::meters);
      (*cf)[2].r = .29 * 1e-6 * si::metres;
      (*cf)[2].s = exp(.396);
    }
    else if (type == "remote_continental")
    {
      (*cf)[0].n = 3.2e3 * pow<-3>(1e-2 * si::meters);
      (*cf)[0].r = .01 * 1e-6 * si::metres;
      (*cf)[0].s = exp(.161);

      (*cf)[1].n = 2.9e3 * pow<-3>(1e-2 * si::meters);
      (*cf)[1].r = .058 * 1e-6 * si::metres;
      (*cf)[1].s = exp(.217);

      (*cf)[2].n = 3.00e-1 * pow<-3>(1e-2 * si::meters);
      (*cf)[2].r = .9 * 1e-6 * si::metres;
      (*cf)[2].s = exp(.380);
    }
    else if (type == "desert_dust_storm")
    {
      (*cf)[0].n = 7.26e2 * pow<-3>(1e-2 * si::meters);
      (*cf)[0].r = .001 * 1e-6 * si::metres;
      (*cf)[0].s = exp(.247);

      (*cf)[1].n = 1.14e3 * pow<-3>(1e-2 * si::meters);
      (*cf)[1].r = .0188 * 1e-6 * si::metres;
      (*cf)[1].s = exp(.770);

      (*cf)[2].n = 1.78e-1 * pow<-3>(1e-2 * si::meters);
      (*cf)[2].r = 10.8 * 1e-6 * si::metres;
      (*cf)[2].s = exp(.438);
    }
    else if (type == "rural")
    {
      (*cf)[0].n = 6.65e3 * pow<-3>(1e-2 * si::meters);
      (*cf)[0].r = .00739 * 1e-6 * si::metres;
      (*cf)[0].s = exp(.225);

      (*cf)[1].n = 1.47e2 * pow<-3>(1e-2 * si::meters);
      (*cf)[1].r = .0269 * 1e-6 * si::metres;
      (*cf)[1].s = exp(.557);

      (*cf)[2].n = 1.99e3 * pow<-3>(1e-2 * si::meters);
      (*cf)[2].r = .0419 * 1e-6 * si::metres;
      (*cf)[2].s = exp(.266);
    }
    else if (type == "urban")
    {
      (*cf)[0].n = 9.93e4 * pow<-3>(1e-2 * si::meters);
      (*cf)[0].r = .00651 * 1e-6 * si::metres;
      (*cf)[0].s = exp(.245);

      (*cf)[1].n = 1.11e3 * pow<-3>(1e-2 * si::meters);
      (*cf)[1].r = .00714 * 1e-6 * si::metres;
      (*cf)[1].s = exp(.666);

      (*cf)[2].n = 3.64e4 * pow<-3>(1e-2 * si::meters);
      (*cf)[2].r = .0248 * 1e-6 * si::metres;
      (*cf)[2].s = exp(.337);
    }
  }

};
#  undef self
#  undef parent

#endif
