/* InBinSpectrumConstNr.hpp 
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef IN_BIN_SPECTRUM_CONST_N_R_HPP
#  define IN_BIN_SPECTRUM_CONST_N_R_HPP

#  define self InBinSpectrumConstNr
class self : public InBinSpectrum
{

  private: quantity<si::area> kappa(quantity<si::length> a, quantity<si::length> b) 
  {
    return (
      3. * pow<4>(a) + pow<4>(b) - 4. * pow<3>(a) * b
    ) / ( 
      pow<2>(b - a)
    );  
  }

  private: quantity<si::length> d_kappa__d_a(quantity<si::length> a, quantity<si::length> b)
  {
    return (
      2. * pow<4>(b) - 6. * pow<4>(a) + 16. * pow<3>(a) * b - 12. * pow<2>(a) * pow<2>(b)
    ) / (
      pow<3>(b - a)
    );
  }

  private: quantity<si::length> d_kappa__d_b(quantity<si::length> a, quantity<si::length> b)
  {
    return (
      2. * pow<4>(b) - 2. * pow<4>(a) + 4. * pow<3>(a) * b - 4. * pow<3>(b) * a
    ) / (
      pow<3>(b - a)
    );
  }

};
#  undef self

#endif
