/* DropGrowthEqMaxwellMason.hpp
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef DROP_GROWTH_EQ_MAXWELL_MASON_HPP
#  define DROP_GROWTH_EQ_MAXWELL_MASON_HPP

#  define self DropGrowthEqMaxwellMason
class self : public DropGrowthEq
{

  public: quantity<si::velocity> dr__dt(
    quantity<si::length> r, quantity<si::length> r_d, quantity<si::temperature> T, 
    quantity<si::temperature>, quantity<si::pressure> p, quantity<si::dimensionless> q_v, 
    Solute* solute, DiffCoeffMltplr* dcmv, DiffCoeffMltplr* dcmh, SatVapPresMltplr* svpm
  )
  {
     quantity<si::pressure> p_v_s = constants::p_v_s(T);
     quantity<si::dimensionless> RH, RH_eq;

     RH = q_v * p / (constants::epsilon + q_v * (1. - constants::epsilon)) / p_v_s;

     RH_eq = svpm->p_v_s_r__p_v_s_infty(T, r, r_d, solute);

     return (RH - RH_eq) / r / constants::rho_w_0 / (
       constants::R_v * T 
         / p_v_s 
         / (constants::D_0 * dcmv->D_transition__D_continuum(constants::Kn_D(r, T)))
       + 
       constants::l_v(T) 
         / (constants::K_0 * dcmh->D_transition__D_continuum(constants::Kn_K(r, T, p))) 
         / T 
         * (constants::l_v(T) / constants::R_v / T - 1.)
     );
  }

};
#  undef self

#endif
