/* DropGrowthEqFick.hpp
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef DROP_GROWTH_EQ_FICK_HPP
#  define DROP_GROWTH_EQ_FICK_HPP

#  define self DropGrowthEqFick
class self : public DropGrowthEq
{

  public: quantity<si::velocity> dr__dt(
    quantity<si::length> r, quantity<si::length> r_d, quantity<si::temperature> T, 
    quantity<si::temperature> T_w, quantity<si::pressure> p, quantity<si::dimensionless> q_v, 
    Solute* solute, DiffCoeffMltplr* dcmv, DiffCoeffMltplr* dcmh, SatVapPresMltplr* svpm
  )
  {
     quantity<si::mass_density> rho_v, rho_v_eq;

     rho_v = q_v * p / constants::R_d / T / (1. - q_v * (1. - 1. / constants::epsilon));

     rho_v_eq = constants::p_v_s(T_w) * svpm->p_v_s_r__p_v_s_infty(
       T_w, r, r_d, solute
     ) / constants::R_v / T_w;

     return (
       (constants::D_0 * dcmv->D_transition__D_continuum(constants::Kn_D(r, T_w))) 
       / constants::rho_w_0 * (rho_v - rho_v_eq) / r
     );
  }

};
#  undef self

#endif
