/* DiffCoeffMltpltFuchsSutugin.hpp
 * 
 * Copyright (C) 2010 Sylwester Arabas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef DIFF_COEFF_MLTPLR_FUCHS_SUTUGIN_HPP
#  define DIFF_COEFF_MLTPLR_FUCHS_SUTUGIN_HPP

#  define self DiffCoeffMltplrFuchsSutugin
class self : public DiffCoeffMltplr
{
  // mass/thermal accomodation coefficient of unity
  private: quantity<si::dimensionless> alpha;

  public: self(quantity<si::dimensionless> alpha_)
  {
    alpha = alpha_;
  }

  // transition r\'egime correction 
  public: quantity<si::dimensionless> D_transition__D_continuum(
    quantity<si::dimensionless> Kn
  )
  {
    return (1. + Kn) / (1. + (4./3./alpha + .377) * Kn + 4./3./alpha * pow<2>(Kn));
  }

};
#  undef self

#endif
