clc;
clear;
close all;

for i=1:4  
%(4 corresponds with the number of xls-sheets (i.e. the number of tests that will be analysed)
    
%% Data Preprosessing
    data0=xlsread('TotalDataBeste2.xls',i); 
%(change to your file name)
    
    % Here you can choose the proxy combination (8=Mg, 9=Sr, 10=Ba and 11=Pb)
    ProxyComb=[8 9 10 11]
%( the columns in which the proxy measurements are given)
    data0=data0(:,[1:7 ProxyComb 12])
%(7 is the number of specimens studied, 12 the column with the environmental parameters)
    
    %Here you can choose how many times you want to repeat the data.
    %In the paper the system is supposed to be static and herhaling is
    %chosen [-0 0]
    herhaling=[-0 0]; 
    
    [data1]=PrepaireData(data0,herhaling);
    C=find(data0(1,:)> 0);
    HerDat=data1(:,C(2):end);
    In=data1(:,1:C(2)-1);
    for a=1:7;
        OneShell=find(In(:,a)==1);
        p(a)=OneShell(1);
        l(a)=length(OneShell);
    end
    
%% Choosing training and test data
    TrainD=HerDat(1:p(5)-1,:);%training sett
    OptimD=HerDat(p(5):p(7)-1,:);%optimisation set
    TestD=HerDat(p(7):end,:);%validation set

%(here you choose which specimens are used to train/to validate the model, this has to be adapted depending on number of specimens studied)

TrainD=[[sum(TrainD(:,1:4:end-1),2) sum(TrainD(:,2:4:end-1),2) sum(TrainD(:,3:4:end-1),2) sum(TrainD(:,4:4:end-1),2)]./4 TrainD(:,end)];

OptimD=[[sum(OptimD(:,1:4:end-1),2) sum(OptimD(:,2:4:end-1),2) sum(OptimD(:,3:4:end-1),2) sum(OptimD(:,4:4:end-1),2)]./4 OptimD(:,end)];

TestD=[[sum(TestD(:,1:4:end-1),2) sum(TestD(:,2:4:end-1),2) sum(TestD(:,3:4:end-1),2) sum(TestD(:,4:4:end-1),2)]./4 TestD(:,end)];

    [Nr,Nk]=size(TrainD);
    k=9;
    lambda=0.9;
    r=0.02;
    
%% Traing the model using WDMR
K=WDMR([TrainD(:,1:Nk-1)' OptimD(:,1:Nk-1)'],TestD(:,1:Nk-1)',lambda,k,r);
y_pred = K * [TrainD(:,Nk) ;OptimD(:,Nk); zeros(size(TestD(:,Nk)))];
[fi g]=fit(TestD(1:end,Nk).*std(data0(:,end))+mean(data0(:,end)),y_pred(end+1-length(TestD(:,Nk)):end).*std(data0(:,end))+mean(data0(:,end)))
 
%% Validation of the model
    figure(1);
    TEREC=TestD(1:end,Nk).*std(data0(:,end))+mean(data0(:,end));
    REC=y_pred(end+1-length(TestD(:,Nk)):end).*std(data0(:,end))+mean(data0(:,end));
    subplot(4,1,i); 
%(4 and i depend on the number of tests that are planned)
    plot(TEREC,'--k'); hold on;plot(REC,'k');
    MAE(i)=mean(abs(REC-TEREC));
    RMSE(i)=sqrt(mean((REC-TEREC).^2))
    FoutStd(i)=std(abs(REC-TEREC));
    text(1,18,['RMSE:',num2str(round(RMSE(i).*100)./100) ]);
    ylabel('Temperature'); xlabel('Sample');
end

