;******************************************************************************
;* DESCRIPTION:  
;*      Test routine calling LANLstar_GEO
;*      fortran code - using same test case as in example.f
;*
;* KEYWORDS: LIB_NAME
;* CALLING SEQUENCE:
;*      stand-alone
;*
;* MODIFICATION HISTORY:       
;*      Novemner 2008, written by R.Friedel
;******************************************************************************
PRO idl_example,  LIB_NAME = LIB_NAME

IF NOT keyword_set(LIB_NAME) THEN BEGIN
    message, 'Please specify location of .so with keyword LIB_NAME', /info
    return
ENDIF 

file =  file_search(lib_name,  count = c)
IF c NE 1 THEN BEGIN
    message, 'lib_name: '+lib_name, ' not found', /info
    return
ENDIF


;----------------------------------------------------------------------------
;set up test case parameters, same as in ../LANLstar_GEO/source/fortran.f
;
;All VAriables are of FORTRAN type DOUBLE PRECISION
;                         IDL type Double-precision

Kp   = 20.0  ; omni2 format
Dst  = -3.0  ; Dst index (nT)
dens = 3.9   ; solar wind density (cm^-3)
velo = 410.0 ; solar wind velocity (km/s)
Pdyn = 1.38  ; solar wind dynamic pressure (nPA)
ByIMF = -3.1 ; GSM y component of IMF magnetic field (nT)
BzIMF = 2.5  ; GSM z component of IMF magnetic field (nT)
G1 = -0.89255239550589571  ; as defined in Tsyganenko 2002
G2 = 0.0                   ; as defined in Tsyganenko 2002
G3 = 0.0                   ; as defined in Tsyganenko 2002

YEAR  = 2002.0  ; year (in double precision  but dont use fractions)
DOY   = 2.0     ; day of the year
UT_hr = 9.0     ; UT in units of decimal hours

lm = 6.5896831261717335   ; McIllwain L (for 90 deg PA)
mlt = 9.243973522191073   ; magnetic local time in hours


PA = 80.0 ; Pitch angle in degrees; should be between 10 < PA < 90
;----------------------------------------------------------------------------

;force correct variable type for variables in call to lib_name
Kp =  double(Kp) & Dst = double(Dst) & dens = double(dens)
velo = double(velo) & Pdyn = double(Pdyn) & ByIMF= double(ByIMF)
BzIMF = double(BzIMF) & G1 = double(G1) & G2 = double(G2) & G3 = double(G3)
YEAR = double(YEAR) & DOY= double(DOY) & UT_hr= double(UT_hr)
lm = double(lm) & mlt= double(mlt)
PA =  double(PA)

;set correct variable type for output variable
Lstar =  0.0D

result = call_external(lib_name, 'lstar_nnet_idl_', $
           YEAR, DOY, UT_hr, lm, mlt, PA, Kp, Dst, dens, velo, $
              Pdyn, ByIMF, BzIMF, G1, G2, G3, Lstar, /f_value)

print, Lstar,  format = "('Lstar test:  ',f27.15)"
print, 'The result should be:  6.085766059999295 '

END
