c -------------------------------------------------------------------
c -------------- WRAPPER FOR IDL ------------------------------------
c -------------------------------------------------------------------
      REAL*4 FUNCTION lstar_nnet_idl(argc, argv) ! Called by IDL
c
c     the include.inc will be based on the architecture
      INCLUDE 'include.inc'

      j = loc(argc)  ! Obtains the number of arguments (argc)

c  Call subroutine Lstar_nnet, converting the IDL parameters to standard FORTRAN
c  passed by reference arguments.
c
      CALL Lstar_nnet(%VAL(argv(1)), %VAL(argv(2)), %VAL(argv(3)),
     & %VAL(argv(4)),  %VAL(argv(5)),  %VAL(argv(6)),  %VAL(argv(7)),
     & %VAL(argv(8)),  %VAL(argv(9)),  %VAL(argv(10)), %VAL(argv(11)),
     & %VAL(argv(12)), %VAL(argv(13)), %VAL(argv(14)), %VAL(argv(15)),
     & %VAL(argv(16)), %VAL(argv(17)) )


      Lstar_nnet_idl = -99.9

      RETURN
      END
      

c -------------------------------------------------------------------
c ---------------MAIN FORTRAN SUBROUTINE ----------------------------
c -------------------------------------------------------------------      
c -------------------------------------------------------------------
      SUBROUTINE Lstar_nnet(YEAR, DOY, UT_hr, lm, mlt, PA, 
     &      Kp, Dst, dens, velo, Pdyn, ByIMF, BzIMF, G1, G2, G3, Lstar)

      DOUBLE PRECISION Kp, Dst, dens, velo, Pdyn, ByIMF, BzIMF, G1, G2
      DOUBLE PRECISION G3, YEAR, DOY, UT_hr, lm, mlt, PA
      DOUBLE PRECISION Lstar

      DOUBLE PRECISION input_Lmax(12)
      DOUBLE PRECISION output_Lmax
      DOUBLE PRECISION input_Lstar(14)
      DOUBLE PRECISION output_Lstar

c assemble all into input vector     

      input_Lmax(1) = DOY
      input_Lmax(2) = UT_hr
      input_Lmax(3) = Kp
      input_Lmax(4) = Dst
      input_Lmax(5) = velo
      input_Lmax(6) = dens
      input_Lmax(7) = Pdyn
      input_Lmax(8) = ByIMF
      input_Lmax(9) = BzIMF
      input_Lmax(10) = G1
      input_Lmax(11) = G2
      input_Lmax(12) = G3

      output_Lmax = 0.0

      input_Lstar(1) = DOY
      input_Lstar(2) = UT_hr
      input_Lstar(3) = Kp
      input_Lstar(4) = Dst
      input_Lstar(5) = dens
      input_Lstar(6) = velo
      input_Lstar(7) = Pdyn
      input_Lstar(8) = ByIMF
      input_Lstar(9) = BzIMF
      input_Lstar(10) = G1
      input_Lstar(11) = G2
      input_Lstar(12) = G3
      input_Lstar(13) = lm
      input_Lstar(14) = mlt

      output_Lstar = 0.0

c find the last closed drift shell

      CALL get_Lstar_max(PA, input_Lmax, output_Lmax)

c get the L* value and pick check if Lstar < Lstar_max

      CALL get_Lstar(PA, input_Lstar, output_Lstar)
      
      IF (output_Lstar .GT. output_Lmax) THEN
         Lstar = -99.0  
      ELSE
         Lstar = output_Lstar
      ENDIF


      END

c -------------------------------------------------------------------      
c -------------------------------------------------------------------     
      SUBROUTINE get_Lstar_max(PA, input_Lmax, output_Lmax)

      IMPLICIT NONE

      DOUBLE PRECISION PA
      DOUBLE PRECISION input_Lmax(12)
      DOUBLE PRECISION output_Lmax

      DOUBLE PRECISION PA1, Lmax1, Lmax2, d, c


      IF (PA .GE. 10.0 .AND. PA .LT. 20.0) THEN
         PA1 = 10.0
         CALL Lmax_PA10(input_Lmax, Lmax1)
         CALL Lmax_PA20(input_Lmax, Lmax2)

      ELSEIF (PA .GE. 20.0 .AND. PA .LT. 30.0) THEN
         PA1 = 20.0
         CALL Lmax_PA20(input_Lmax, Lmax1)
         CALL Lmax_PA30(input_Lmax, Lmax2)

      ELSEIF (PA .GE. 30.0 .AND. PA .LT. 40.0) THEN
         PA1 = 30.0
         CALL Lmax_PA30(input_Lmax, Lmax1)
         CALL Lmax_PA40(input_Lmax, Lmax2)

      ELSEIF (PA .GE. 40.0 .AND. PA .LT. 50.0) THEN
         PA1 = 40.0
         CALL Lmax_PA40(input_Lmax, Lmax1)
         CALL Lmax_PA50(input_Lmax, Lmax2)

      ELSEIF (PA .GE. 50.0 .AND. PA .LT. 60.0) THEN
         PA1 = 50.0
         CALL Lmax_PA50(input_Lmax, Lmax1)
         CALL Lmax_PA60(input_Lmax, Lmax2)

      ELSEIF (PA .GE. 60.0 .AND. PA .LT. 70.0) THEN
         PA1 = 60.0
         CALL Lmax_PA60(input_Lmax, Lmax1)
         CALL Lmax_PA70(input_Lmax, Lmax2)

      ELSEIF (PA .GE. 70.0 .AND. PA .LT. 80.0) THEN
         PA1 = 70.0
         CALL Lmax_PA70(input_Lmax, Lmax1)
         CALL Lmax_PA80(input_Lmax, Lmax2)

      ELSEIF (PA .GE. 80.0 .AND. PA .LE. 90.0) THEN
         PA1 = 80.0
         CALL Lmax_PA80(input_Lmax, Lmax1)
         CALL Lmax_PA90(input_Lmax, Lmax2)

      ELSE
         PRINT*, "Requested PA not available: 10 <= PA <= 90"

      ENDIF


c now interpolate between the two Lmax values for this PA

      d = (Lmax2-Lmax1)/10.0
      c = Lmax1 - d*PA1 
      output_Lmax =  c + d * PA

      END

c -------------------------------------------------------------------
c -------------------------------------------------------------------

      
      SUBROUTINE get_Lstar(PA, input_Lstar, output_Lstar)

      IMPLICIT NONE

      DOUBLE PRECISION PA
      DOUBLE PRECISION input_Lstar(14)
      DOUBLE PRECISION output_Lstar

      DOUBLE PRECISION PA1, Lstar1, Lstar2, d, c


      IF (PA .GE. 10.0 .AND. PA .LT. 20.0) THEN
         PA1 = 10.0
         CALL Lstar_PA10(input_Lstar, Lstar1)
         CALL Lstar_PA20(input_Lstar, Lstar2)

      ELSEIF (PA .GE. 20.0 .AND. PA .LT. 30.0) THEN
         PA1 = 20.0
         CALL Lstar_PA20(input_Lstar, Lstar1)
         CALL Lstar_PA30(input_Lstar, Lstar2)

      ELSEIF (PA .GE. 30.0 .AND. PA .LT. 40.0) THEN
         PA1 = 30.0
         CALL Lstar_PA30(input_Lstar, Lstar1)
         CALL Lstar_PA40(input_Lstar, Lstar2)

      ELSEIF (PA .GE. 40.0 .AND. PA .LT. 50.0) THEN
         PA1 = 40.0
         CALL Lstar_PA40(input_Lstar, Lstar1)
         CALL Lstar_PA50(input_Lstar, Lstar2)

      ELSEIF (PA .GE. 50.0 .AND. PA .LT. 60.0) THEN
         PA1 = 50.0
         CALL Lstar_PA50(input_Lstar, Lstar1)
         CALL Lstar_PA60(input_Lstar, Lstar2)

      ELSEIF (PA .GE. 60.0 .AND. PA .LT. 70.0) THEN
         PA1 = 60.0
         CALL Lstar_PA60(input_Lstar, Lstar1)
         CALL Lstar_PA70(input_Lstar, Lstar2)

      ELSEIF (PA .GE. 70.0 .AND. PA .LT. 80.0) THEN
         PA1 = 70.0
         CALL Lstar_PA70(input_Lstar, Lstar1)
         CALL Lstar_PA80(input_Lstar, Lstar2)

      ELSEIF (PA .GE. 80.0 .AND. PA .LE. 90.0) THEN
         PA1 = 80.0
         CALL Lstar_PA80(input_Lstar, Lstar1)
         CALL Lstar_PA90(input_Lstar, Lstar2)

      ELSE
         PRINT*, "Requested PA not available: 10 <= PA <= 90"

      ENDIF

c now interpolate between the two Lmax values for this PA

      d = (Lstar2-Lstar1)/10.0
      c = Lstar1 - d*PA1 
      output_Lstar =  c + d * PA

      END
