      PROGRAM example
c -------------------------------
c example for  LANL* prototype
c use neural network to get L*
c good for geosynchronous locations
c
c Version: 14-Oct-2008
c Author: J. Koller
c Email: jkoller@lanl.gov
c -------------------------------

      IMPLICIT NONE

      DOUBLE PRECISION Kp, Dst, dens, velo, Pdyn, ByIMF, BzIMF, G1, G2
      DOUBLE PRECISION G3, YEAR, DOY, UT_hr, lm, mlt, PA
      DOUBLE PRECISION Lstar

      INTEGER i

c setup the input data

      Kp = 20.0  ! omni2 format
      Dst = -3.0 ! Dst index (nT)
      dens = 3.9 ! solar wind density (cm^-3)
      velo = 410.0 ! solar wind velocity (km/s)
      Pdyn = 1.38  ! solar wind dynamic pressure (nPA)
      ByIMF = -3.1 ! GSM y component of IMF magnetic field (nT)
      BzIMF = 2.5  ! GSM z component of IMF magnetic field (nT)
      G1 = -0.89255239550589571  ! as defined in Tsyganenko 2002
      G2 = 0.0 ! as defined in Tsyganenko 2002
      G3 = 0.0 ! as defined in Tsyganenko 2002
      
      YEAR = 2002.0  ! year (in double precision  but don't use fractions)
      DOY = 2.0      ! day of the year
      UT_hr = 9.0    ! UT in units of hours; include minutes and seconds as fractions

      lm = 6.5896831261717335   ! McIllwain L for 90 deg PA
      mlt = 9.243973522191073   ! magnetic local time in hours

      PA = 80.0 ! Pitch angle in degrees; should be between 10 < PA < 90


c all values are treated as input, the only ouput is the last one "Lstar"    
c      do i = 1,1000000
      CALL Lstar_nnet(YEAR, DOY, UT_hr, lm, mlt, PA, 
     &      Kp, Dst, dens, velo, Pdyn, ByIMF, BzIMF, G1, G2, G3, Lstar)
c      end do

      PRINT*, "Lstar calculated  ", Lstar
      PRINT*, "Should be close to  6.08576606"

      END
