function [] = figure_last_scatter(shat, independent_variables,caption)
A=[shat independent_variables];
names={'shat','delz','delR','delX','delQ','delBeta'};
figure('Renderer', 'painters', 'Position', [10 10  2500  1800])
t = tiledlayout(2,3,'TileSpacing','Compact','Padding','Compact');
X = A(:,1); Y = A(:,2);       % Data to be plotted
[rho,p] = corrcoef(X,Y); % correlation coefficient & associated p-value
Rho = rho(2,1);     % Rho: accumulated r-values
fitlinewidth=2;
marker_width=4;
line_st='-';
%% Y2 with respect to z
nexttile
Y = A(:,2); 
plot(X,Y,'o','MarkerSize',marker_width);  % Marker shape: circle
Po = polyfit(X,Y,1);     % 1st order polynomial (linear)
Yfit = Po(1)*X+Po(2);    % y-values of the fitted line
hold on;                    % Allow superimposed plots
plot(X,Yfit,'Color','#7E2F8E','LineStyle',line_st,'LineWidth',fitlinewidth);       % Fitted line (color: red, type: solid)
hold on;
axis([min(X)-.1*(max(X)-min(X)) max(X)+.1*(max(X)-min(X))...
    min(Y)-.1*(max(Y)-min(Y)) max(Y)+.25*(max(Y)-min(Y))]);
xLimit = get(gca, 'xlim');
xLoc = xLimit(1) + .05*(max(xLimit)-min(xLimit));   % x location for text
xLoc2=xLimit(2) - .2*(max(xLimit));
yLimit = get(gca, 'ylim');
yLoc = yLimit(1) + .925*(max(yLimit)-min(yLimit));   % y location for text
% Add corr coef, p-value, and sample size to each plot %
%text(xLoc,yLoc,[num2str(Rho(i,j),'%.3f')...
%'[' num2str(P(i,j),'%.3f') ']' int2str(N)],'FontSize',labelsize); \rho
text(xLoc,yLoc,['\rho',' = ',num2str(Rho,'%.2f')],'FontSize',22);
text(xLoc2,yLoc,'(A)','FontSize',22);
ylabel('$$ \frac{\partial \hat{\mathbf{s}} }{\partial \mathbf{z}}_{grouped}$$','interpreter',...
    'latex',"FontSize",16,'fontweight','bold');
xlabel('$${\hat{\mathbf{s}}}$$','interpreter','latex',...
    "FontSize",16,'fontweight','bold');
ax = gca;
ax.GridColor = [0.1, 0.2, 0.9];
ax.LineWidth = 3;
grid on
set(gca,'fontsize',22)
hold off
%% Y3 with respect to R
nexttile
Y = A(:,3);       % Data to be plotted
[rho,p] = corrcoef(X,Y); % correlation coefficient & associated p-value
Rho = rho(2,1);     % Rho: accumulated r-values
plot(X,Y,'o','MarkerSize',marker_width);  % Marker shape: circle
Po = polyfit(X,Y,1);     % 1st order polynomial (linear)
Yfit = Po(1)*X+Po(2);    % y-values of the fitted line
hold on;                    % Allow superimposed plots
plot(X,Yfit,'Color','#7E2F8E','LineStyle',line_st,'LineWidth',fitlinewidth);       % Fitted line (color: red, type: solid)
hold on;
axis([min(X)-.1*(max(X)-min(X)) max(X)+.1*(max(X)-min(X))...
    min(Y)-.1*(max(Y)-min(Y)) max(Y)+.25*(max(Y)-min(Y))]);
xLimit = get(gca, 'xlim');
xLoc = xLimit(1) + .05*(max(xLimit)-min(xLimit));   % x location for text
xLoc2=xLimit(2) - .2*(max(xLimit));
yLimit = get(gca, 'ylim');
yLoc = yLimit(1) + .925*(max(yLimit)-min(yLimit));   % y location for text
% Add corr coef, p-value, and sample size to each plot %
%text(xLoc,yLoc,[num2str(Rho(i,j),'%.3f')...
%'[' num2str(P(i,j),'%.3f') ']' int2str(N)],'FontSize',labelsize);
text(xLoc,yLoc,['\rho',' = ',num2str(Rho,'%.2f')],'FontSize',22);
text(xLoc2,yLoc,'(B)','FontSize',22);
ylabel('$$ \frac{\partial \hat{\mathbf{s}} }{\partial \mathbf{R}}_{grouped}$$','interpreter',...
    'latex',"FontSize",16,'fontweight','bold');
xlabel('$${\hat{\mathbf{s}}}$$','interpreter','latex',...
    "FontSize",16,'fontweight','bold');
ax = gca;
ax.GridColor = [0.1, 0.2, 0.9];
ax.LineWidth = 3;
grid on
set(gca,'fontsize',22)
hold off
%% Y4 with respect to X
nexttile
Y = A(:,4);       % Data to be plotted
[rho,p] = corrcoef(X,Y); % correlation coefficient & associated p-value
Rho = rho(2,1);     % Rho: accumulated r-values
plot(X,Y,'o','MarkerSize',marker_width);  % Marker shape: circle
Po = polyfit(X,Y,1);     % 1st order polynomial (linear)
Yfit = Po(1)*X+Po(2);    % y-values of the fitted line
hold on;                    % Allow superimposed plots
plot(X,Yfit,'Color','#7E2F8E','LineStyle',line_st,'LineWidth',fitlinewidth);       % Fitted line (color: red, type: solid)
hold on;
axis([min(X)-.1*(max(X)-min(X)) max(X)+.1*(max(X)-min(X))...
    min(Y)-.1*(max(Y)-min(Y)) max(Y)+.25*(max(Y)-min(Y))]);
xLimit = get(gca, 'xlim');
xLoc = xLimit(1) + .05*(max(xLimit)-min(xLimit));   % x location for text
xLoc2=xLimit(2) - .2*(max(xLimit));
yLimit = get(gca, 'ylim');
yLoc = yLimit(1) + .925*(max(yLimit)-min(yLimit));   % y location for text
% Add corr coef, p-value, and sample size to each plot %
%text(xLoc,yLoc,[num2str(Rho(i,j),'%.3f')...
%'[' num2str(P(i,j),'%.3f') ']' int2str(N)],'FontSize',labelsize);
text(xLoc,yLoc,['\rho',' = ',num2str(Rho,'%.2f')],'FontSize',22);
text(xLoc2,yLoc,'(C)','FontSize',22);
ylabel('$$ \frac{\partial \hat{\mathbf{s}} }{\partial \mathbf{X}}_{grouped}$$',...
    'interpreter','latex',"FontSize",16,'fontweight','bold');
xlabel('$${\hat{\mathbf{s}}}$$','interpreter','latex',...
    "FontSize",16,'fontweight','bold');
ax = gca;
ax.GridColor = [0.1, 0.2, 0.9];
ax.LineWidth = 3;
grid on
set(gca,'fontsize',22)
hold off
%% Y5 with respect to Q
nexttile
Y = A(:,5);       % Data to be plotted
[rho,p] = corrcoef(X,Y); % correlation coefficient & associated p-value
Rho = rho(2,1);     % Rho: accumulated r-values
plot(X,Y,'o','MarkerSize',marker_width);  % Marker shape: circle
Po = polyfit(X,Y,1);     % 1st order polynomial (linear)
Yfit = Po(1)*X+Po(2);    % y-values of the fitted line
hold on;                    % Allow superimposed plots
plot(X,Yfit,'Color','#7E2F8E','LineStyle',line_st,'LineWidth',fitlinewidth);       % Fitted line (color: red, type: solid)
hold on;
axis([min(X)-.1*(max(X)-min(X)) max(X)+.1*(max(X)-min(X))...
    min(Y)-.1*(max(Y)-min(Y)) max(Y)+.25*(max(Y)-min(Y))]);
xLimit = get(gca, 'xlim');
xLoc = xLimit(1) + .05*(max(xLimit)-min(xLimit));   % x location for text
xLoc2=xLimit(2) - .2*(max(xLimit));
yLimit = get(gca, 'ylim');
yLoc = yLimit(1) + .925*(max(yLimit)-min(yLimit));   % y location for text
% Add corr coef, p-value, and sample size to each plot %
%text(xLoc,yLoc,[num2str(Rho(i,j),'%.3f')...
%'[' num2str(P(i,j),'%.3f') ']' int2str(N)],'FontSize',labelsize);
text(xLoc,yLoc,['\rho',' = ',num2str(Rho,'%.2f')],'FontSize',22);
text(xLoc2,yLoc,'(D)','FontSize',22);
ylabel('$$ \frac{\partial \hat{\mathbf{s}} }{\partial \mathbf{Q}}_{grouped}$$','interpreter',...
    'latex',"FontSize",16,'fontweight','bold');
xlabel('$${\hat{\mathbf{s}}}$$','interpreter','latex',...
    "FontSize",16,'fontweight','bold');
ax = gca;
ax.GridColor = [0.1, 0.2, 0.9];
ax.LineWidth = 3;
grid on
set(gca,'fontsize',22)
hold off
%% Y6 with respect to Beta
nexttile
Y = A(:,6);       % Data to be plotted
[rho,p] = corrcoef(X,Y); % correlation coefficient & associated p-value
Rho = rho(2,1);     % Rho: accumulated r-values
plot(X,Y,'o','MarkerSize',marker_width);  % Marker shape: circle
Po = polyfit(X,Y,1);     % 1st order polynomial (linear)
Yfit = Po(1)*X+Po(2);    % y-values of the fitted line
hold on;                    % Allow superimposed plots
plot(X,Yfit,'Color','#7E2F8E','LineStyle',line_st,'LineWidth',fitlinewidth);       % Fitted line (color: red, type: solid)
hold on;
axis([min(X)-.1*(max(X)-min(X)) max(X)+.1*(max(X)-min(X))...
    min(Y)-.1*(max(Y)-min(Y)) max(Y)+.25*(max(Y)-min(Y))]);
xLimit = get(gca, 'xlim');
xLoc = xLimit(1) + .05*(max(xLimit)-min(xLimit));   % x location for text
xLoc2=xLimit(2) - .2*(max(xLimit));
yLimit = get(gca, 'ylim');
yLoc = yLimit(1) + .925*(max(yLimit)-min(yLimit));   % y location for text
% Add corr coef, p-value, and sample size to each plot %
%text(xLoc,yLoc,[num2str(Rho(i,j),'%.3f')...
%'[' num2str(P(i,j),'%.3f') ']' int2str(N)],'FontSize',labelsize);
text(xLoc,yLoc,['\rho',' = ',num2str(Rho,'%.2f')],'FontSize',22);
text(xLoc2,yLoc,'(E)','FontSize',22);
ylabel('$$ \frac{\partial \hat{\mathbf{s}} }{\partial \mathbf{\beta}}_{grouped}$$','interpreter',...
    'latex',"FontSize",16,'fontweight','bold');
xlabel('$${\hat{\mathbf{s}}}$$','interpreter','latex',...
    "FontSize",16,'fontweight','bold');
ax = gca;
ax.GridColor = [0.1, 0.2, 0.9];
ax.LineWidth = 3;
grid on
set(gca,'fontsize',22)
title(t,caption,'fontsize',40)
hold off
%print([dataPath,'\','scatter_new.png'],'-dpng','-r500')