#!/usr/bin/env python

# Documentation of 'plotfile' see -
# http://matplotlib.org/api/pyplot_api.html#module-matplotlib.pyplot

# This script is used to plot the data generated by - 'test_albedo'

from pylab import plotfile, show, gca, savefig

fname="fort.100"
plotfile(fname, (0, 1, 2, 3, 4, 5), delimiter=' ',subplots=False)
gca().set_xlabel(r'angle')
gca().set_title(r'Albedo as function of zenith angle')
savefig('albedo_zenith.png')
show()

fname="fort.101"
plotfile(fname, (0, 1, 2, 3, 4, 5, 6, 7, 8 ), delimiter=' ',subplots=False)
gca().set_xlabel(r'year day')
gca().set_title(r'Albedo as function of year day')
savefig('albedo_yearday.png')
show()
