#!/usr/bin/env python

# Documentation of 'plotfile' see -
# http://matplotlib.org/api/pyplot_api.html#module-matplotlib.pyplot

# This script is used to plot the data generated by - 'test_airsea'

from pylab import plotfile, show, gca, savefig

fname="fort.100"
plotfile(fname, (0, 1, 2, 3, 4), delimiter=' ',subplots=False)
gca().set_xlabel(r'hour')
gca().set_title(r'Solar zenith angle (1 day)')
savefig('solar_zenith_angle_day.png')
show()

fname="fort.101"
plotfile(fname, (0, 1, 2, 3, 4), delimiter=' ',subplots=False)
gca().set_xlabel(r'hour')
gca().set_title(r'Short wave radiation (1 day)')
savefig('short_wave_radiation_day.png')
show()

fname="fort.200"
plotfile(fname, (0, 1, 2, 3, 4), delimiter=' ',subplots=False)
gca().set_xlabel(r'day')
gca().set_title(r'Solar zenith angle (1 year)')
savefig('solar_zenith_angle_year.png')
show()

fname="fort.201"
plotfile(fname, (0, 1, 2, 3, 4), delimiter=' ',subplots=False)
gca().set_xlabel(r'day')
gca().set_title(r'Short wave radiation (1 year)')
savefig('short_wave_radiation_year.png')
show()
