#include "cppdefs.h"
!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: Initialise mean netCDf variables
!
! !INTERFACE:
   subroutine init_mean_ncdf(fn,title,starttime,runtype)
!
! !DESCRIPTION:
!
! !USES:
   use netcdf
   use exceptions
   use ncdf_common
   use ncdf_mean
   use domain, only: ioff,joff
   use domain, only: imin,imax,jmin,jmax,kmax
   use domain, only: vert_cord
   use m3d, only: update_temp,update_salt
   use nonhydrostatic, only: nonhyd_iters,bnh_filter,bnh_weight
   use meteo, only: metforcing
#ifndef NO_BAROCLINIC
   use getm_ice, only: ice_model,ICE_MODEL_WINTON
#endif
#ifdef GETM_BIO
   use bio_var, only: numc,var_names,var_units,var_long
#endif
#ifdef _FABM_
   use getm_fabm, only: model,fabm_pel,output_none
#endif
   use getm_version
!
   IMPLICIT NONE
!
! !INPUT PARAMETERS:
   character(len=*), intent(in)        :: fn,title,starttime
   integer, intent(in)                 :: runtype
!
! !DEFINED PARAMETERS:
   logical,    parameter               :: init3d=.true.
!
! !REVISION HISTORY:
!  Original author(s): Adolf Stips & Karsten Bolding
!
!  Revision 1.1  2004/03/29 15:38:10  kbk
!  possible to store calculated mean fields
!
! !LOCAL VARIABLES:
   integer                   :: n
   integer                   :: err
   integer                   :: scalar(1),f3_dims(3),f4_dims(4)
   REALTYPE                  :: fv,mv,vr(2)
   character(len=80)         :: history,tts
!EOP
!-------------------------------------------------------------------------
!BOC
!  create netCDF file
   err = nf90_create(fn, NF90_CLOBBER, ncid)
   if (err .NE. NF90_NOERR) go to 10

!  initialize all time-independent, grid related variables
   call init_grid_ncdf(ncid,init3d,x_dim,y_dim,z_dim)

!  define unlimited dimension
   err = nf90_def_dim(ncid,'time',NF90_UNLIMITED,time_dim)
   if (err .NE. NF90_NOERR) go to 10

!  netCDF dimension vectors
   f3_dims(3)= time_dim
   f3_dims(2)= y_dim
   f3_dims(1)= x_dim

   f4_dims(4)= time_dim
   f4_dims(3)= z_dim
   f4_dims(2)= y_dim
   f4_dims(1)= x_dim


!  globall settings
   history = 'GETM - www.getm.eu'
   tts = 'seconds since '//starttime

!  time
   err = nf90_def_var(ncid,'time',NF90_DOUBLE,time_dim,time_id)
   if (err .NE. NF90_NOERR) go to 10
   call set_attributes(ncid,time_id,units=trim(tts),long_name='time')

!  elevation
   err = nf90_def_var(ncid,'z_mean',NCDF_FLOAT_PRECISION,f3_dims,elevmean_id)
   if (err .NE. NF90_NOERR) go to 10
   fv = elev_missing
   mv = elev_missing
   vr(1) = -15.
   vr(2) =  15.
   call set_attributes(ncid,elevmean_id,long_name='mean elevation',units='m', &
                       FillValue=fv,missing_value=mv,valid_range=vr)

! Ustar at bottom
   fv = vel_missing; mv = vel_missing
   err = nf90_def_var(ncid,'z_max',NCDF_FLOAT_PRECISION,f3_dims,ustarmean_id)
   if (err .NE. NF90_NOERR) go to 10
   call set_attributes(ncid,ustarmean_id,  &
          long_name='maximum elevation',units='m', &
          FillValue=fv,missing_value=mv,valid_range=vr)

! Standard deviation of ustar
   fv = vel_missing; mv = vel_missing
   err = nf90_def_var(ncid,'z_min',NCDF_FLOAT_PRECISION,f3_dims,ustar2mean_id)
   if (err .NE. NF90_NOERR) go to 10
   call set_attributes(ncid,ustar2mean_id,  &
          long_name='minimum elevation',units='m', &
          FillValue=fv,missing_value=mv,valid_range=vr)


!  globals
   err = nf90_put_att(ncid,NF90_GLOBAL,'title',trim(title))
   if (err .NE. NF90_NOERR) go to 10

   err = nf90_put_att(ncid,NF90_GLOBAL,'model ',trim(history))
   if (err .NE. NF90_NOERR) go to 10

#if 0
   err = nf90_put_att(ncid,NF90_GLOBAL,'git hash:   ',trim(git_commit_id))
   if (err .NE. NF90_NOERR) go to 10
   err = nf90_put_att(ncid,NF90_GLOBAL,'git branch: ',trim(git_branch_name))
   if (err .NE. NF90_NOERR) go to 10
#endif

!   history = FORTRAN_VERSION
!   err = nf90_put_att(ncid,NF90_GLOBAL,'compiler',trim(history))
!   if (err .NE. NF90_NOERR) go to 10

   ! leave define mode
   err = nf90_enddef(ncid)
   if (err .NE. NF90_NOERR) go to 10

   return

   10 FATAL 'init_mean_ncdf: ',nf90_strerror(err)
   stop 'init_mean_ncdf'
   end subroutine init_mean_ncdf
!EOC

!-----------------------------------------------------------------------
! Copyright (C) 2004 - Adolf Stips and Karsten Bolding (BBH)           !
!-----------------------------------------------------------------------
